/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.AbstractStochasticCachingDiffFunction;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.StochasticCalculateMethods;
import edu.stanford.nlp.optimization.StochasticMinimizer;
import edu.stanford.nlp.util.Pair;
import java.text.DecimalFormat;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMDMinimizer<T extends Function>
extends StochasticMinimizer<T> {
    public double mu = 0.01;
    public double lam = 1.0;
    public double cPosDef = 0.0;
    public double meta;
    public boolean printMinMax = false;
    private double[] Hv;
    private double[] gains;
    StochasticCalculateMethods method = null;
    private static NumberFormat nf = new DecimalFormat("0.000E0");

    @Override
    public void shutUp() {
        this.quiet = true;
    }

    public void setBatchSize(int batchSize) {
        bSize = batchSize;
    }

    public SMDMinimizer() {
    }

    public SMDMinimizer(double initialSMDGain, int batchSize, StochasticCalculateMethods method, int passes) {
        this(initialSMDGain, batchSize, method, passes, false);
    }

    public SMDMinimizer(double initGain, int batchSize, StochasticCalculateMethods method, int passes, boolean outputToFile) {
        StochasticMinimizer.bSize = batchSize;
        StochasticMinimizer.gain = initGain;
        this.method = method;
        this.numPasses = passes;
        this.outputIterationsToFile = outputToFile;
    }

    @Override
    public double[] minimize(Function function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, -1);
    }

    @Override
    protected void init(AbstractStochasticCachingDiffFunction func) {
        func.method = this.method;
        this.gains = new double[this.x.length];
        this.v = new double[this.x.length];
        this.Hv = new double[this.x.length];
        for (int i = 0; i < this.v.length; ++i) {
            this.gains[i] = gain;
        }
    }

    @Override
    public Pair<Integer, Double> tune(Function function, double[] initial, long msPerTest) {
        this.quiet = true;
        this.lam = 0.9;
        this.mu = this.tuneDouble(function, initial, msPerTest, new setMu(this), 1.0E-8, 0.01);
        this.lam = this.tuneDouble(function, initial, msPerTest, new setLam(this), 0.1, 1.0);
        StochasticMinimizer.gain = this.tuneGain(function, initial, msPerTest, 1.0E-8, 1.0);
        StochasticMinimizer.bSize = this.tuneBatch(function, initial, msPerTest, 1);
        System.err.println("Results:  gain: " + nf.format(StochasticMinimizer.gain) + "  batch " + StochasticMinimizer.bSize + "   mu" + nf.format(this.mu) + "  lam" + nf.format(this.lam));
        return new Pair<Integer, Double>(StochasticMinimizer.bSize, StochasticMinimizer.gain);
    }

    @Override
    protected void takeStep(AbstractStochasticCachingDiffFunction dfunction) {
        dfunction.returnPreviousValues = true;
        System.arraycopy(dfunction.HdotVAt(this.x, this.v, this.grad, bSize), 0, this.Hv, 0, this.Hv.length);
        for (int i = 0; i < this.x.length; ++i) {
            this.meta = 1.0 - this.mu * this.grad[i] * this.v[i];
            this.gains[i] = 0.5 > this.meta ? this.gains[i] * 0.5 : this.gains[i] * this.meta;
            this.v[i] = this.lam * (1.0 + this.cPosDef * this.gains[i]) * this.v[i] - this.gains[i] * (this.grad[i] + this.lam * this.Hv[i]);
            this.newX[i] = this.x[i] - this.gains[i] * this.grad[i];
        }
        if (this.printMinMax) {
            this.say("vMin = " + ArrayMath.min(this.v) + "  ");
            this.say("vMax = " + ArrayMath.max(this.v) + "  ");
            this.say("gainMin = " + ArrayMath.min(this.gains) + "  ");
            this.say("gainMax = " + ArrayMath.max(this.gains) + "  ");
        }
    }

    @Override
    protected String getName() {
        int m = (int)(this.mu * 1000.0);
        int l = (int)(this.lam * 1000.0);
        int g = (int)(gain * 10000.0);
        return "SMD" + bSize + "_mu" + m + "_lam" + l + "_g" + g;
    }

    public static void main(String[] args) {
        int dim = 500000;
        double maxVar = 5.0;
        final double[] var = new double[500000];
        double[] init = new double[500000];
        for (int i = 0; i < 500000; ++i) {
            init[i] = (double)(i + 1) / 500000.0 - 0.5;
            var[i] = 5.0 * (double)(i + 1) / 500000.0;
        }
        final double[] grads = new double[500000];
        DiffFunction f = new DiffFunction(){

            public double[] derivativeAt(double[] x) {
                double val = Math.PI * this.valuePow(x, 2.141592653589793);
                for (int i = 0; i < 500000; ++i) {
                    grads[i] = x[i] * var[i] * val;
                }
                return grads;
            }

            public double valueAt(double[] x) {
                return 1.0 + this.valuePow(x, Math.PI);
            }

            private double valuePow(double[] x, double pow) {
                double val = 0.0;
                for (int i = 0; i < 500000; ++i) {
                    val += x[i] * x[i] * var[i];
                }
                return Math.pow(val * 0.5, pow);
            }

            public int domainDimension() {
                return 500000;
            }
        };
        SMDMinimizer min = new SMDMinimizer();
        min.minimize(f, 1.0E-4, init);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class setLam
    implements StochasticMinimizer.PropertySetter<Double> {
        SMDMinimizer<T> parent = null;

        public setLam(SMDMinimizer<T> smd) {
            this.parent = smd;
        }

        @Override
        public void set(Double in) {
            this.parent.lam = in;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class setMu
    implements StochasticMinimizer.PropertySetter<Double> {
        SMDMinimizer<T> parent = null;

        public setMu(SMDMinimizer<T> smd) {
            this.parent = smd;
        }

        @Override
        public void set(Double in) {
            this.parent.mu = in;
        }
    }
}

