/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.AbstractTreeExtractor;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.Pair;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryGrammarExtractor
extends AbstractTreeExtractor<Pair<UnaryGrammar, BinaryGrammar>> {
    protected Numberer stateNumberer = Numberer.getGlobalNumberer("states");
    private ClassicCounter<Rule> ruleCounter = new ClassicCounter();
    private ClassicCounter<String> symbolCounter = new ClassicCounter();
    private Set<Rule> binaryRules = new HashSet<Rule>();
    private Set<Rule> unaryRules = new HashSet<Rule>();

    protected void tallyRule(Rule r, double weight2) {
        this.symbolCounter.incrementCount((String)this.stateNumberer.object(r.parent), weight2);
        this.ruleCounter.incrementCount(r, weight2);
        if (r.isUnary()) {
            this.unaryRules.add(r);
        } else {
            this.binaryRules.add(r);
        }
    }

    @Override
    protected void tallyInternalNode(Tree lt) {
        Rule r = lt.children().length == 1 ? new UnaryRule(this.stateNumberer.number(lt.label().value()), this.stateNumberer.number(lt.children()[0].label().value())) : new BinaryRule(this.stateNumberer.number(lt.label().value()), this.stateNumberer.number(lt.children()[0].label().value()), this.stateNumberer.number(lt.children()[1].label().value()));
        this.tallyRule(r, this.weight);
    }

    @Override
    public Pair<UnaryGrammar, BinaryGrammar> formResult() {
        this.stateNumberer.number(".$$.");
        BinaryGrammar bg = new BinaryGrammar(this.stateNumberer.total());
        UnaryGrammar ug = new UnaryGrammar(this.stateNumberer.total());
        for (UnaryRule unaryRule : this.unaryRules) {
            unaryRule.score = (float)Math.log(this.ruleCounter.getCount(unaryRule) / this.symbolCounter.getCount((String)this.stateNumberer.object(unaryRule.parent)));
            if (Train.compactGrammar() >= 4) {
                unaryRule.score = (float)this.ruleCounter.getCount(unaryRule);
            }
            ug.addRule(unaryRule);
        }
        for (BinaryRule binaryRule : this.binaryRules) {
            binaryRule.score = (float)Math.log((this.ruleCounter.getCount(binaryRule) - Train.ruleDiscount) / this.symbolCounter.getCount((String)this.stateNumberer.object(binaryRule.parent)));
            if (Train.compactGrammar() >= 4) {
                binaryRule.score = (float)this.ruleCounter.getCount(binaryRule);
            }
            bg.addRule(binaryRule);
        }
        return new Pair<UnaryGrammar, BinaryGrammar>(ug, bg);
    }
}

