/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.PTBTokenizerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPipeline
implements Annotator {
    protected static final boolean TIME = true;
    private List<Annotator> annotators;
    private List<MutableInteger> accumulatedTime;

    public AnnotationPipeline(List<Annotator> annotators) {
        this.annotators = annotators;
        int num = annotators.size();
        this.accumulatedTime = new ArrayList<MutableInteger>(annotators.size());
        for (int i = 0; i < num; ++i) {
            this.accumulatedTime.add(new MutableInteger());
        }
    }

    public AnnotationPipeline() {
        this(new ArrayList<Annotator>());
    }

    public void addAnnotator(Annotator annotator) {
        this.annotators.add(annotator);
        this.accumulatedTime.add(new MutableInteger());
    }

    @Override
    public void annotate(Annotation annotation) {
        Iterator<MutableInteger> it = this.accumulatedTime.iterator();
        Timing t = new Timing();
        for (Annotator annotator : this.annotators) {
            t.start();
            annotator.annotate(annotation);
            int elapsed = (int)t.stop();
            MutableInteger m = it.next();
            m.incValue(elapsed);
        }
    }

    protected long getTotalTime() {
        long total = 0L;
        for (MutableInteger m : this.accumulatedTime) {
            total += m.longValue();
        }
        return total;
    }

    public String timingInformation() {
        StringBuilder sb = new StringBuilder();
        sb.append("Annotation pipeline timing information:\n");
        Iterator<MutableInteger> it = this.accumulatedTime.iterator();
        long total = 0L;
        for (Annotator annotator : this.annotators) {
            MutableInteger m = it.next();
            sb.append(StringUtils.getShortClassName(annotator)).append(": ");
            sb.append(Timing.toSecondsString(m.longValue())).append(" sec.\n");
            total += m.longValue();
        }
        sb.append("TOTAL: ").append(Timing.toSecondsString(total)).append(" sec.");
        return sb.toString();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Timing tim = new Timing();
        AnnotationPipeline ap = new AnnotationPipeline();
        boolean verbose = false;
        ap.addAnnotator(new PTBTokenizerAnnotator(verbose));
        ap.addAnnotator(new WordsToSentencesAnnotator(verbose));
        ap.addAnnotator(new ParserAnnotator(verbose, -1));
        String text = "USAir said in the filings that Mr. Icahn first contacted Mr. Colodny last September to discuss the benefits of combining TWA and USAir -- either by TWA's acquisition of USAir, or USAir's acquisition of TWA.";
        Annotation a = new Annotation(text);
        ap.annotate(a);
        System.out.println(a.get(CoreAnnotations.TokensAnnotation.class));
        for (CoreMap sentence : (List)a.get(CoreAnnotations.SentencesAnnotation.class)) {
            System.out.println(sentence.get(CoreAnnotations.TreeAnnotation.class));
        }
        System.out.println(ap.timingInformation());
        System.err.println("Total time for AnnotationPipeline: " + tim.toSecondsString() + " sec.");
    }
}

