/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.util.ArrayMap;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreMapAttributeAggregator {
    public static final CoreMapAttributeAggregator FIRST_NON_NIL = new CoreMapAttributeAggregator(){

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            for (CoreMap coreMap : in) {
                Object obj = coreMap.get(key);
                if (obj == null) continue;
                return obj;
            }
            return null;
        }
    };
    public static final CoreMapAttributeAggregator FIRST = new CoreMapAttributeAggregator(){

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            Iterator<? extends CoreMap> i$ = in.iterator();
            if (i$.hasNext()) {
                CoreMap cm = i$.next();
                Object obj = cm.get(key);
                return obj;
            }
            return null;
        }
    };
    public static final CoreMapAttributeAggregator LAST_NON_NIL = new CoreMapAttributeAggregator(){

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            for (int i = in.size() - 1; i >= 0; --i) {
                CoreMap cm = in.get(i);
                Object obj = cm.get(key);
                if (obj == null) continue;
                return obj;
            }
            return null;
        }
    };
    public static final CoreMapAttributeAggregator LAST = new CoreMapAttributeAggregator(){

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            int i = in.size() - 1;
            if (i >= 0) {
                CoreMap cm = in.get(i);
                return cm.get(key);
            }
            return null;
        }
    };
    public static final ConcatCoreMapListAggregator<CoreLabel> CONCAT_TOKENS = new ConcatCoreMapListAggregator(true);
    public static final ConcatCoreMapListAggregator<CoreMap> CONCAT_COREMAP = new ConcatCoreMapListAggregator(true);
    public static final CoreMapAttributeAggregator CONCAT = new ConcatAggregator(" ");
    public static final CoreMapAttributeAggregator COUNT = new CoreMapAttributeAggregator(){

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            return in.size();
        }
    };
    public static final CoreMapAttributeAggregator SUM = new CoreMapAttributeAggregator(){

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            double sum = 0.0;
            for (CoreMap coreMap : in) {
                Object obj = coreMap.get(key);
                if (obj == null) continue;
                if (obj instanceof Number) {
                    sum += ((Number)obj).doubleValue();
                    continue;
                }
                if (obj instanceof String) {
                    sum += Double.parseDouble((String)obj);
                    continue;
                }
                throw new RuntimeException("Cannot sum attribute " + key + ", object of type: " + obj.getClass());
            }
            return sum;
        }
    };
    public static final CoreMapAttributeAggregator MIN = new CoreMapAttributeAggregator(){

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            Comparable min = null;
            for (CoreMap coreMap : in) {
                Object obj = coreMap.get(key);
                if (obj == null) continue;
                if (obj instanceof Comparable) {
                    Comparable c = (Comparable)obj;
                    if (min == null) {
                        min = c;
                        continue;
                    }
                    if (c.compareTo(min) >= 0) continue;
                    min = c;
                    continue;
                }
                throw new RuntimeException("Cannot get min of attribute " + key + ", object of type: " + obj.getClass());
            }
            return min;
        }
    };
    public static final CoreMapAttributeAggregator MAX = new CoreMapAttributeAggregator(){

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            Comparable max = null;
            for (CoreMap coreMap : in) {
                Object obj = coreMap.get(key);
                if (obj == null) continue;
                if (obj instanceof Comparable) {
                    Comparable c = (Comparable)obj;
                    if (max == null) {
                        max = c;
                        continue;
                    }
                    if (c.compareTo(max) <= 0) continue;
                    max = c;
                    continue;
                }
                throw new RuntimeException("Cannot get max of attribute " + key + ", object of type: " + obj.getClass());
            }
            return max;
        }
    };
    public static final CoreMapAttributeAggregator MOST_FREQ = new MostFreqAggregator();
    private static final Map<String, CoreMapAttributeAggregator> AGGREGATOR_LOOKUP = new HashMap<String, CoreMapAttributeAggregator>();
    public static final Map<Class, CoreMapAttributeAggregator> DEFAULT_AGGREGATORS;
    public static final Map<Class, CoreMapAttributeAggregator> DEFAULT_NUMERIC_AGGREGATORS;
    public static final Map<Class, CoreMapAttributeAggregator> DEFAULT_NUMERIC_TOKENS_AGGREGATORS;

    public static Map<Class, CoreMapAttributeAggregator> getDefaultAggregators() {
        return DEFAULT_AGGREGATORS;
    }

    public static CoreMapAttributeAggregator getAggregator(String str) {
        return AGGREGATOR_LOOKUP.get(str);
    }

    public abstract Object aggregate(Class var1, List<? extends CoreMap> var2);

    static {
        AGGREGATOR_LOOKUP.put("FIRST", FIRST);
        AGGREGATOR_LOOKUP.put("FIRST_NON_NIL", FIRST_NON_NIL);
        AGGREGATOR_LOOKUP.put("LAST", LAST);
        AGGREGATOR_LOOKUP.put("LAST_NON_NIL", LAST_NON_NIL);
        AGGREGATOR_LOOKUP.put("MIN", MIN);
        AGGREGATOR_LOOKUP.put("MAX", MAX);
        AGGREGATOR_LOOKUP.put("COUNT", COUNT);
        AGGREGATOR_LOOKUP.put("SUM", SUM);
        AGGREGATOR_LOOKUP.put("CONCAT", CONCAT);
        AGGREGATOR_LOOKUP.put("CONCAT_TOKENS", CONCAT_TOKENS);
        AGGREGATOR_LOOKUP.put("MOST_FREQ", MOST_FREQ);
        ArrayMap<Class, CoreMapAttributeAggregator> defaultAggr = new ArrayMap<Class, CoreMapAttributeAggregator>();
        defaultAggr.put(CoreAnnotations.TextAnnotation.class, CONCAT);
        defaultAggr.put(CoreAnnotations.CharacterOffsetBeginAnnotation.class, FIRST);
        defaultAggr.put(CoreAnnotations.CharacterOffsetEndAnnotation.class, LAST);
        defaultAggr.put(CoreAnnotations.TokenBeginAnnotation.class, FIRST);
        defaultAggr.put(CoreAnnotations.TokenEndAnnotation.class, LAST);
        defaultAggr.put(CoreAnnotations.TokensAnnotation.class, CONCAT_TOKENS);
        DEFAULT_AGGREGATORS = Collections.unmodifiableMap(defaultAggr);
        ArrayMap<Class, CoreMapAttributeAggregator> defaultNumericAggr = new ArrayMap<Class, CoreMapAttributeAggregator>(DEFAULT_AGGREGATORS);
        defaultNumericAggr.put(CoreAnnotations.NumericCompositeTypeAnnotation.class, FIRST_NON_NIL);
        defaultNumericAggr.put(CoreAnnotations.NumericCompositeValueAnnotation.class, FIRST_NON_NIL);
        defaultNumericAggr.put(CoreAnnotations.NamedEntityTagAnnotation.class, FIRST_NON_NIL);
        defaultNumericAggr.put(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, FIRST_NON_NIL);
        DEFAULT_NUMERIC_AGGREGATORS = Collections.unmodifiableMap(defaultNumericAggr);
        ArrayMap<Class, CoreMapAttributeAggregator> defaultNumericTokensAggr = new ArrayMap<Class, CoreMapAttributeAggregator>(DEFAULT_NUMERIC_AGGREGATORS);
        defaultNumericTokensAggr.put(CoreAnnotations.NumerizedTokensAnnotation.class, CONCAT_COREMAP);
        DEFAULT_NUMERIC_TOKENS_AGGREGATORS = Collections.unmodifiableMap(defaultNumericTokensAggr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MostFreqAggregator
    extends CoreMapAttributeAggregator {
        Set<Object> ignoreSet;

        public MostFreqAggregator() {
        }

        public MostFreqAggregator(Set<Object> set) {
            this.ignoreSet = set;
        }

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            IntCounter counter = new IntCounter();
            for (CoreMap coreMap : in) {
                Object obj = coreMap.get(key);
                if (obj == null || this.ignoreSet != null && this.ignoreSet.contains(obj)) continue;
                counter.incrementCount(obj);
            }
            if (counter.size() > 0) {
                return counter.argmax();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ConcatAggregator
    extends CoreMapAttributeAggregator {
        String delimiter;

        public ConcatAggregator(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (CoreMap coreMap : in) {
                Object obj = coreMap.get(key);
                if (obj == null) continue;
                if (sb.length() > 0) {
                    sb.append(this.delimiter);
                }
                sb.append(obj);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ConcatCoreMapListAggregator<T extends CoreMap>
    extends CoreMapAttributeAggregator {
        boolean concatSelf = false;

        public ConcatCoreMapListAggregator() {
        }

        public ConcatCoreMapListAggregator(boolean concatSelf) {
            this.concatSelf = concatSelf;
        }

        @Override
        public Object aggregate(Class key, List<? extends CoreMap> in) {
            if (in == null) {
                return null;
            }
            ArrayList<CoreMap> res = new ArrayList<CoreMap>();
            for (CoreMap coreMap : in) {
                Object obj = coreMap.get(key);
                boolean added = false;
                if (obj != null && obj instanceof List) {
                    res.addAll((List)obj);
                    added = true;
                }
                if (added || !this.concatSelf) continue;
                res.add(coreMap);
            }
            return res;
        }
    }
}

