/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.regexp.RegexNERSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Timing;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexNERAnnotator
implements Annotator {
    private RegexNERSequenceClassifier classifier;
    private Timing timer;
    private boolean verbose;

    public RegexNERAnnotator(String mapping) {
        this(mapping, false, true, false);
    }

    public RegexNERAnnotator(String mapping, boolean ignoreCase) {
        this(mapping, ignoreCase, true, false);
    }

    public RegexNERAnnotator(String mapping, boolean ignoreCase, boolean overwriteMyLabels, boolean verbose) {
        this.classifier = new RegexNERSequenceClassifier(mapping, ignoreCase, overwriteMyLabels);
        this.timer = new Timing();
        this.verbose = verbose;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.verbose) {
            this.timer.start();
            System.err.print("Adding RegexNER annotation...");
        }
        if (!annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            throw new RuntimeException("Unable to find sentences in " + annotation);
        }
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            this.classifier.classify(tokens);
            for (CoreLabel token : tokens) {
                if (token.get(CoreAnnotations.NamedEntityTagAnnotation.class) != null) continue;
                token.set(CoreAnnotations.NamedEntityTagAnnotation.class, this.classifier.flags.backgroundSymbol);
            }
            for (int start = 0; start < tokens.size(); ++start) {
                CoreLabel token;
                token = (CoreLabel)tokens.get(start);
                String answerType = (String)token.get(CoreAnnotations.AnswerAnnotation.class);
                String NERType = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                if (answerType == null) continue;
                int answerEnd = RegexNERAnnotator.findEndOfAnswerAnnotation(tokens, start);
                int NERStart = RegexNERAnnotator.findStartOfNERAnnotation(tokens, start);
                int NEREnd = RegexNERAnnotator.findEndOfNERAnnotation(tokens, start);
                if ((NERStart == start || NERType.equals(this.classifier.flags.backgroundSymbol)) && (answerEnd == NEREnd || NERType.equals(this.classifier.flags.backgroundSymbol) && NEREnd >= answerEnd)) {
                    for (int i = start; i < answerEnd; ++i) {
                        ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NamedEntityTagAnnotation.class, answerType);
                    }
                }
                start = answerEnd - 1;
            }
        }
        if (this.verbose) {
            this.timer.stop("done.");
        }
    }

    private static int findEndOfAnswerAnnotation(List<CoreLabel> tokens, int start) {
        String type = (String)tokens.get(start).get(CoreAnnotations.AnswerAnnotation.class);
        while (start < tokens.size() && type.equals(tokens.get(start).get(CoreAnnotations.AnswerAnnotation.class))) {
            ++start;
        }
        return start;
    }

    private static int findStartOfNERAnnotation(List<CoreLabel> tokens, int start) {
        String type = (String)tokens.get(start).get(CoreAnnotations.NamedEntityTagAnnotation.class);
        while (start >= 0 && type.equals(tokens.get(start).get(CoreAnnotations.NamedEntityTagAnnotation.class))) {
            --start;
        }
        return start + 1;
    }

    private static int findEndOfNERAnnotation(List<CoreLabel> tokens, int start) {
        String type = (String)tokens.get(start).get(CoreAnnotations.NamedEntityTagAnnotation.class);
        while (start < tokens.size() && type.equals(tokens.get(start).get(CoreAnnotations.NamedEntityTagAnnotation.class))) {
            ++start;
        }
        return start;
    }
}

