/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.DeprecatedAnnotations;
import edu.stanford.nlp.process.WordToSentenceProcessor;
import edu.stanford.nlp.util.Timing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordsToSentencesAnnotator
implements Annotator {
    private final WordToSentenceProcessor<CoreLabel> wts;
    private Timing timer = new Timing();
    private boolean VERBOSE = true;
    private static long millisecondsAnnotating = 0L;

    public WordsToSentencesAnnotator() {
        this(true);
    }

    public WordsToSentencesAnnotator(boolean verbose) {
        this.VERBOSE = verbose;
        this.wts = new WordToSentenceProcessor();
    }

    private WordsToSentencesAnnotator(WordToSentenceProcessor<CoreLabel> wts, boolean verbose) {
        this.VERBOSE = verbose;
        this.wts = wts;
    }

    public static WordsToSentencesAnnotator newlineSplitter(boolean verbose) {
        WordToSentenceProcessor<CoreLabel> wts = new WordToSentenceProcessor<CoreLabel>("", Collections.<String>emptySet(), Collections.singleton("\n"));
        return new WordsToSentencesAnnotator(wts, verbose);
    }

    public void setSentenceBoundaryToDiscard(Set<String> boundaries) {
        this.wts.setSentenceBoundaryToDiscard(boundaries);
    }

    public void addHtmlSentenceBoundaryToDiscard(Set<String> boundaries) {
        this.wts.addHtmlSentenceBoundaryToDiscard(boundaries);
    }

    public void setOneSentence(boolean isOneSentence) {
        this.wts.setOneSentence(isOneSentence);
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            this.timer.start();
            System.err.print("PTB tokenizing...");
        }
        if (annotation.has(DeprecatedAnnotations.WordsPLAnnotation.class)) {
            ArrayList<List<CoreLabel>> sentences = new ArrayList<List<CoreLabel>>();
            List wordsList = (List)annotation.get(DeprecatedAnnotations.WordsPLAnnotation.class);
            if (wordsList != null) {
                for (List words : wordsList) {
                    sentences.addAll(this.wts.process(words));
                }
            }
            annotation.set(DeprecatedAnnotations.WordsPLAnnotation.class, sentences);
            System.err.println("NUM SENTENCES: " + sentences.size());
            if (this.VERBOSE) {
                millisecondsAnnotating += this.timer.stop("done.");
                System.err.println("output: " + annotation.get(DeprecatedAnnotations.WordsPLAnnotation.class) + "\n");
            }
        } else if (annotation.has(CoreAnnotations.TokensAnnotation.class)) {
            String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            int tokenOffset = 0;
            ArrayList<Annotation> sentences = new ArrayList<Annotation>();
            for (List<CoreLabel> sentenceTokens : this.wts.process(tokens)) {
                if (sentenceTokens.size() == 0) {
                    throw new RuntimeException("unexpected empty sentence: " + sentenceTokens);
                }
                int begin = (Integer)sentenceTokens.get(0).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int last = sentenceTokens.size() - 1;
                int end = (Integer)sentenceTokens.get(last).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                String sentenceText = text.substring(begin, end);
                Annotation sentence = new Annotation(sentenceText);
                sentence.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
                sentence.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, end);
                sentence.set(CoreAnnotations.TokensAnnotation.class, sentenceTokens);
                sentence.set(CoreAnnotations.TokenBeginAnnotation.class, tokenOffset);
                sentence.set(CoreAnnotations.TokenEndAnnotation.class, tokenOffset += sentenceTokens.size());
                sentences.add(sentence);
            }
            annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }
}

