/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.XMLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformXML<T> {
    private final SAXParser saxParser;
    private InputSource inSource;
    private SAXInterface<T> saxInterface = new SAXInterface();

    public TransformXML() {
        try {
            this.saxParser = SAXParserFactory.newInstance().newSAXParser();
            this.saxInterface.elementsToBeTransformed = new ArrayList<String>();
            ((SAXInterface)this.saxInterface).clear();
        }
        catch (Exception e) {
            System.err.println("Error configuring XML parser: " + e);
            throw new RuntimeException(e);
        }
    }

    private void parse() throws SAXException, IOException {
        ((SAXInterface)this.saxInterface).clear();
        this.saxParser.parse(this.inSource, this.saxInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformXML(String[] tags, Function<String, T> fn, File in) {
        BufferedInputStream ins = null;
        try {
            ins = new BufferedInputStream(new FileInputStream(in));
            this.transformXML(tags, fn, (InputStream)ins, System.out);
        }
        catch (Exception e) {
            try {
                System.err.println("Error reading file " + in + ": " + e);
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringExceptions(ins);
                throw throwable;
            }
            IOUtils.closeIgnoringExceptions(ins);
        }
        IOUtils.closeIgnoringExceptions(ins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformXML(String[] tags, Function<String, T> fn, File in, File out2) {
        BufferedInputStream ins = null;
        BufferedOutputStream outs = null;
        try {
            ins = new BufferedInputStream(new FileInputStream(in));
            outs = new BufferedOutputStream(new FileOutputStream(out2));
            this.transformXML(tags, fn, (InputStream)ins, outs);
        }
        catch (Exception e) {
            try {
                System.err.println("Error reading file " + in + " or writing file " + out2 + ": " + e);
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringExceptions(ins);
                IOUtils.closeIgnoringExceptions(outs);
                throw throwable;
            }
            IOUtils.closeIgnoringExceptions(ins);
            IOUtils.closeIgnoringExceptions(outs);
        }
        IOUtils.closeIgnoringExceptions(ins);
        IOUtils.closeIgnoringExceptions(outs);
    }

    public void transformXML(String[] tags, Function<String, T> fn, InputStream in) {
        this.transformXML(tags, fn, in, System.out);
    }

    public void transformXML(String[] tags, Function<String, T> fn, InputStream in, OutputStream out2) {
        this.transformXML(tags, fn, in, (Writer)new OutputStreamWriter(out2), this.saxInterface);
    }

    public void transformXML(String[] tags, Function<String, T> fn, InputStream in, Writer w) {
        this.transformXML(tags, fn, in, w, this.saxInterface);
    }

    public void transformXML(String[] tags, Function<String, T> fn, InputStream in, Writer w, SAXInterface<T> handler) {
        this.transformXML(tags, fn, new InputSource(in), w, handler);
    }

    public void transformXML(String[] tags, Function<String, T> fn, Reader in, Writer w, SAXInterface<T> handler) {
        this.transformXML(tags, fn, new InputSource(in), w, handler);
    }

    public void transformXML(String[] tags, Function<String, T> fn, InputSource in, Writer w, SAXInterface<T> handler) {
        this.saxInterface = handler;
        this.inSource = in;
        this.saxInterface.outWriter = new PrintWriter(w, true);
        this.saxInterface.function = fn;
        this.saxInterface.elementsToBeTransformed = new ArrayList<String>();
        this.saxInterface.elementsToBeTransformed.addAll(Arrays.asList(tags));
        try {
            this.parse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SAXInterface<T>
    extends DefaultHandler {
        protected List<String> elementsToBeTransformed;
        protected StringBuffer textToBeTransformed;
        protected PrintWriter outWriter = new PrintWriter(System.out, true);
        protected Function<String, T> function;
        protected int depth = 0;
        String openingTag;

        private void clear() {
            this.depth = 0;
            this.openingTag = null;
            this.textToBeTransformed = new StringBuffer();
        }

        private void outputTextAndTag(String qName, Attributes attributes, boolean close) {
            this.outWriter.print(XMLUtils.escapeXML(this.textToBeTransformed.toString()));
            this.textToBeTransformed = new StringBuffer();
            this.outWriter.print('<');
            if (close) {
                this.outWriter.print('/');
            }
            this.outWriter.print(qName);
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.outWriter.print(' ');
                    this.outWriter.print(attributes.getQName(i));
                    this.outWriter.print("=\"");
                    this.outWriter.print(XMLUtils.escapeXML(attributes.getValue(i)));
                    this.outWriter.print('\"');
                }
            }
            this.outWriter.print(">\n");
        }

        @Override
        public void endDocument() {
            this.outWriter.print(XMLUtils.escapeXML(this.textToBeTransformed.toString()));
            this.outWriter.flush();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.depth == 0) {
                this.outputTextAndTag(qName, attributes, false);
            }
            if (this.elementsToBeTransformed.contains(qName)) {
                if (this.depth == 0) {
                    this.openingTag = qName;
                }
                ++this.depth;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.depth == 0) {
                this.outputTextAndTag(qName, null, true);
            } else if (this.elementsToBeTransformed.contains(qName)) {
                --this.depth;
                if (this.depth == 0) {
                    String text = this.textToBeTransformed.toString().trim();
                    if (text.length() > 0) {
                        text = this.function.apply(text).toString();
                        this.outWriter.print(XMLUtils.escapeXML(text));
                        this.outWriter.print('\n');
                    }
                    this.textToBeTransformed = new StringBuffer();
                    this.outWriter.print("</" + this.openingTag + ">\n");
                }
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            this.textToBeTransformed.append(buf, offset, len);
        }
    }
}

