/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

public abstract class CoolingSchedule {
    public abstract int numIterations();

    public abstract double getTemperature(int var1);

    public static CoolingSchedule getExponentialSchedule(final double start, final double rate, final int numIterations) {
        return new CoolingSchedule(){

            public int numIterations() {
                return numIterations;
            }

            public double getTemperature(int iteration) {
                return start * Math.pow(rate, iteration);
            }
        };
    }

    public static CoolingSchedule getLinearSchedule(final double start, final int numIterations) {
        return new CoolingSchedule(){
            final double rate;
            {
                this.rate = start / (double)numIterations;
            }

            public int numIterations() {
                return numIterations + 1;
            }

            public double getTemperature(int iteration) {
                return start - this.rate * (double)iteration;
            }
        };
    }
}

