/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.PRCurve;
import edu.stanford.nlp.classify.ProbabilisticClassifier;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Scorer;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.text.NumberFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccuracyStats<L>
implements Scorer<L> {
    double confWeightedAccuracy;
    double accuracy;
    double optAccuracy;
    double optConfWeightedAccuracy;
    double logLikelihood;
    int[] accrecall;
    int[] optaccrecall;
    L posLabel;
    String saveFile;
    static int saveIndex = 1;

    public <F> AccuracyStats(ProbabilisticClassifier<L, F> classifier, GeneralDataset<L, F> data, L posLabel) {
        this.posLabel = posLabel;
        this.score(classifier, data);
    }

    public AccuracyStats(L posLabel, String saveFile) {
        this.posLabel = posLabel;
        this.saveFile = saveFile;
    }

    @Override
    public <F> double score(ProbabilisticClassifier<L, F> classifier, GeneralDataset<L, F> data) {
        ArrayList<Pair<Double, Integer>> dataScores = new ArrayList<Pair<Double, Integer>>();
        for (int i = 0; i < data.size(); ++i) {
            RVFDatum<L, F> d = data.getRVFDatum(i);
            Counter<L> scores = classifier.logProbabilityOf(d);
            int labelD = d.label().equals(this.posLabel) ? 1 : 0;
            dataScores.add(new Pair<Double, Integer>(Math.exp(scores.getCount(this.posLabel)), labelD));
        }
        PRCurve prc = new PRCurve(dataScores);
        this.confWeightedAccuracy = prc.cwa();
        this.accuracy = prc.accuracy();
        this.optAccuracy = prc.optimalAccuracy();
        this.optConfWeightedAccuracy = prc.optimalCwa();
        this.logLikelihood = prc.logLikelihood();
        this.accrecall = prc.cwaArray();
        this.optaccrecall = prc.optimalCwaArray();
        return this.accuracy;
    }

    @Override
    public String getDescription(int numDigits) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(numDigits);
        StringBuilder sb = new StringBuilder();
        sb.append("--- Accuracy Stats ---").append('\n');
        sb.append("accuracy: ").append(nf.format(this.accuracy)).append('\n');
        sb.append("optimal fn accuracy: ").append(nf.format(this.optAccuracy)).append('\n');
        sb.append("confidence weighted accuracy :").append(nf.format(this.confWeightedAccuracy)).append('\n');
        sb.append("optimal confidence weighted accuracy: ").append(nf.format(this.optConfWeightedAccuracy)).append('\n');
        sb.append("log-likelihood: ").append(this.logLikelihood).append('\n');
        if (this.saveFile != null) {
            String f = this.saveFile + '-' + saveIndex;
            sb.append("saving accuracy info to ").append(f).append(".accuracy\n");
            StringUtils.printToFile(f + ".accuracy", AccuracyStats.toStringArr(this.accrecall));
            sb.append("saving optimal accuracy info to ").append(f).append(".optimal_accuracy\n");
            StringUtils.printToFile(f + ".optimal_accuracy", AccuracyStats.toStringArr(this.optaccrecall));
            ++saveIndex;
        }
        return sb.toString();
    }

    public static String toStringArr(int[] acc) {
        StringBuilder sb = new StringBuilder();
        int total = acc.length;
        for (int i = 0; i < acc.length; ++i) {
            double coverage = (double)(i + 1) / (double)total;
            double accuracy = (double)acc[i] / (double)(i + 1);
            sb.append((int)(coverage *= 1000000.0) / 10000);
            sb.append('\t');
            sb.append((int)(accuracy *= 1000000.0) / 10000);
            sb.append('\n');
        }
        return sb.toString();
    }
}

