/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.pipeline.LabeledChunkIdentifier;
import edu.stanford.nlp.stats.MultiClassPrecisionRecallExtendedStats;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassChunkEvalStats
extends MultiClassPrecisionRecallExtendedStats.MultiClassStringLabelStats {
    private boolean inCorrect = false;
    private LabeledChunkIdentifier.LabelTagType prevCorrect = null;
    private LabeledChunkIdentifier.LabelTagType prevGuess = null;
    private LabeledChunkIdentifier chunker = new LabeledChunkIdentifier();
    private boolean useLabel = false;

    public <F> MultiClassChunkEvalStats(Classifier<String, F> classifier, GeneralDataset<String, F> data, String negLabel) {
        super(classifier, data, negLabel);
        this.chunker.setNegLabel(negLabel);
    }

    public MultiClassChunkEvalStats(String negLabel) {
        super(negLabel);
        this.chunker.setNegLabel(negLabel);
    }

    public MultiClassChunkEvalStats(Index<String> dataLabelIndex, String negLabel) {
        super(dataLabelIndex, negLabel);
        this.chunker.setNegLabel(negLabel);
    }

    public LabeledChunkIdentifier getChunker() {
        return this.chunker;
    }

    @Override
    public void clearCounts() {
        super.clearCounts();
        this.inCorrect = false;
        this.prevCorrect = null;
        this.prevGuess = null;
    }

    @Override
    protected void finalizeCounts() {
        this.markBoundary();
        super.finalizeCounts();
    }

    private String getTypeLabel(LabeledChunkIdentifier.LabelTagType tagType) {
        if (this.useLabel) {
            return tagType.label;
        }
        return tagType.type;
    }

    @Override
    protected void markBoundary() {
        if (this.inCorrect) {
            this.inCorrect = false;
            this.correctGuesses.incrementCount(this.getTypeLabel(this.prevCorrect));
        }
        this.prevGuess = null;
        this.prevCorrect = null;
    }

    @Override
    protected void addGuess(String guess, String trueLabel, boolean addUnknownLabels) {
        LabeledChunkIdentifier.LabelTagType guessTagType = this.chunker.getTagType(guess);
        LabeledChunkIdentifier.LabelTagType correctTagType = this.chunker.getTagType(trueLabel);
        this.addGuess(guessTagType, correctTagType, addUnknownLabels);
    }

    @Override
    protected void addGuess(LabeledChunkIdentifier.LabelTagType guess, LabeledChunkIdentifier.LabelTagType correct, boolean addUnknownLabels) {
        if (addUnknownLabels) {
            if (this.labelIndex == null) {
                this.labelIndex = new HashIndex();
            }
            this.labelIndex.add(this.getTypeLabel(guess));
            this.labelIndex.add(this.getTypeLabel(correct));
        }
        if (this.inCorrect) {
            boolean prevCorrectEnded = LabeledChunkIdentifier.isEndOfChunk(this.prevCorrect, correct);
            boolean prevGuessEnded = LabeledChunkIdentifier.isEndOfChunk(this.prevGuess, guess);
            if (prevCorrectEnded && prevGuessEnded && this.prevGuess.typeMatches(this.prevCorrect)) {
                this.inCorrect = false;
                this.correctGuesses.incrementCount(this.getTypeLabel(this.prevCorrect));
            } else if (prevCorrectEnded != prevGuessEnded || !guess.typeMatches(correct)) {
                this.inCorrect = false;
            }
        }
        boolean correctStarted = LabeledChunkIdentifier.isStartOfChunk(this.prevCorrect, correct);
        boolean guessStarted = LabeledChunkIdentifier.isStartOfChunk(this.prevGuess, guess);
        if (correctStarted && guessStarted && guess.typeMatches(correct)) {
            this.inCorrect = true;
        }
        if (correctStarted) {
            this.foundCorrect.incrementCount(this.getTypeLabel(correct));
        }
        if (guessStarted) {
            this.foundGuessed.incrementCount(this.getTypeLabel(guess));
        }
        if (this.chunker.isIgnoreProvidedTag()) {
            if (guess.typeMatches(correct)) {
                ++this.tokensCorrect;
            }
        } else if (guess.label.equals(correct.label)) {
            ++this.tokensCorrect;
        }
        ++this.tokensCount;
        this.prevGuess = guess;
        this.prevCorrect = correct;
    }

    @Override
    public String getConllEvalString() {
        return this.getConllEvalString(true);
    }

    public static void main(String[] args) throws Exception {
        StringUtils.printErrInvocationString("MultiClassChunkEvalStats", args);
        Properties props = StringUtils.argsToProperties(args);
        String boundary = props.getProperty("b", "-X-");
        String delimiter = props.getProperty("d", "\t");
        String defaultPosTag = props.getProperty("t", "I");
        boolean raw = Boolean.valueOf(props.getProperty("r", "false"));
        boolean ignoreProvidedTag = Boolean.valueOf(props.getProperty("ignoreProvidedTag", "false"));
        String format = props.getProperty("format", "conll");
        String filename = props.getProperty("i");
        String backgroundLabel = props.getProperty("k", "O");
        try {
            MultiClassPrecisionRecallExtendedStats.MultiClassStringLabelStats stats;
            if (raw) {
                stats = new MultiClassPrecisionRecallExtendedStats.MultiClassStringLabelStats(backgroundLabel);
            } else {
                MultiClassChunkEvalStats mstats = new MultiClassChunkEvalStats(backgroundLabel);
                mstats.getChunker().setDefaultPosTag(defaultPosTag);
                mstats.getChunker().setIgnoreProvidedTag(ignoreProvidedTag);
                stats = mstats;
            }
            if (filename != null) {
                stats.score(filename, delimiter, boundary);
            } else {
                stats.score(new BufferedReader(new InputStreamReader(System.in)), delimiter, boundary);
            }
            if ("conll".equalsIgnoreCase(format)) {
                System.out.println(stats.getConllEvalString());
            } else {
                System.out.println(stats.getDescription(6));
            }
        }
        catch (IOException ex) {
            System.err.println("Error processing file: " + ex.toString());
            ex.printStackTrace(System.err);
        }
    }
}

