/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.io.FileUtils;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.stats.MultiClassPrecisionRecallStats;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassPrecisionRecallExtendedStats<L>
extends MultiClassPrecisionRecallStats<L> {
    protected IntCounter<L> correctGuesses;
    protected IntCounter<L> foundCorrect;
    protected IntCounter<L> foundGuessed;
    protected int tokensCount = 0;
    protected int tokensCorrect = 0;
    protected Function<String, L> stringConverter;

    public <F> MultiClassPrecisionRecallExtendedStats(Classifier<L, F> classifier, GeneralDataset<L, F> data, L negLabel) {
        super(classifier, data, negLabel);
    }

    public MultiClassPrecisionRecallExtendedStats(L negLabel) {
        super(negLabel);
    }

    public MultiClassPrecisionRecallExtendedStats(Index<L> dataLabelIndex, L negLabel) {
        this(negLabel);
        this.setLabelIndex(dataLabelIndex);
    }

    public void setLabelIndex(Index<L> dataLabelIndex) {
        this.labelIndex = dataLabelIndex;
        this.negIndex = this.labelIndex.indexOf(this.negLabel);
    }

    @Override
    public <F> double score(Classifier<L, F> classifier, GeneralDataset<L, F> data) {
        this.setLabelIndex(data.labelIndex);
        this.clearCounts();
        int[] labelsArr = data.getLabelsArray();
        for (int i = 0; i < data.size(); ++i) {
            RVFDatum<L, F> d = data.getRVFDatum(i);
            L guess = classifier.classOf(d);
            this.addGuess(guess, this.labelIndex.get(labelsArr[i]));
        }
        this.finalizeCounts();
        return this.getFMeasure();
    }

    public double score(List<L> guesses, List<L> trueLabels, Index<L> dataLabelIndex) {
        this.setLabelIndex(dataLabelIndex);
        return this.score(guesses, trueLabels);
    }

    public double score(List<L> guesses, List<L> trueLabels) {
        this.clearCounts();
        this.addGuesses(guesses, trueLabels);
        this.finalizeCounts();
        return this.getFMeasure();
    }

    public double score() {
        this.finalizeCounts();
        return this.getFMeasure();
    }

    public void clearCounts() {
        if (this.foundCorrect != null) {
            this.foundCorrect.clear();
        } else {
            this.foundCorrect = new IntCounter();
        }
        if (this.foundGuessed != null) {
            this.foundGuessed.clear();
        } else {
            this.foundGuessed = new IntCounter();
        }
        if (this.correctGuesses != null) {
            this.correctGuesses.clear();
        } else {
            this.correctGuesses = new IntCounter();
        }
        if (this.tpCount != null) {
            Arrays.fill(this.tpCount, 0);
        }
        if (this.fnCount != null) {
            Arrays.fill(this.fnCount, 0);
        }
        if (this.fpCount != null) {
            Arrays.fill(this.fpCount, 0);
        }
        this.tokensCount = 0;
        this.tokensCorrect = 0;
    }

    protected void finalizeCounts() {
        this.negIndex = this.labelIndex.indexOf(this.negLabel);
        int numClasses = this.labelIndex.size();
        if (this.tpCount == null || this.tpCount.length != numClasses) {
            this.tpCount = new int[numClasses];
        }
        if (this.fpCount == null || this.fpCount.length != numClasses) {
            this.fpCount = new int[numClasses];
        }
        if (this.fnCount == null || this.fnCount.length != numClasses) {
            this.fnCount = new int[numClasses];
        }
        for (int i = 0; i < numClasses; ++i) {
            Object label = this.labelIndex.get(i);
            this.tpCount[i] = this.correctGuesses.getIntCount(label);
            this.fnCount[i] = this.foundCorrect.getIntCount(label) - this.tpCount[i];
            this.fpCount[i] = this.foundGuessed.getIntCount(label) - this.tpCount[i];
        }
    }

    protected void markBoundary() {
    }

    protected void addGuess(L guess, L label) {
        this.addGuess(guess, label, true);
    }

    protected void addGuess(L guess, L label, boolean addUnknownLabels) {
        if (addUnknownLabels) {
            if (this.labelIndex == null) {
                this.labelIndex = new HashIndex();
            }
            this.labelIndex.add(guess);
            this.labelIndex.add(label);
        }
        if (guess.equals(label)) {
            this.correctGuesses.incrementCount(label);
            ++this.tokensCorrect;
        }
        if (!guess.equals(this.negLabel)) {
            this.foundGuessed.incrementCount(guess);
        }
        if (!label.equals(this.negLabel)) {
            this.foundCorrect.incrementCount(label);
        }
        ++this.tokensCount;
    }

    public void addGuesses(List<L> guesses, List<L> trueLabels) {
        for (int i = 0; i < guesses.size(); ++i) {
            L guess = guesses.get(i);
            L label = trueLabels.get(i);
            this.addGuess(guess, label);
        }
    }

    public int getCorrect() {
        return this.correctGuesses.totalIntCount();
    }

    public int getCorrect(L label) {
        return this.correctGuesses.getIntCount(label);
    }

    public int getRetrieved(L label) {
        return this.foundGuessed.getIntCount(label);
    }

    public int getRetrieved() {
        return this.foundGuessed.totalIntCount();
    }

    public int getRelevant(L label) {
        return this.foundCorrect.getIntCount(label);
    }

    public int getRelevant() {
        return this.foundCorrect.totalIntCount();
    }

    public Triple<Double, Integer, Integer> getAccuracyInfo() {
        int totalCorrect = this.tokensCorrect;
        int totalWrong = this.tokensCount - this.tokensCorrect;
        return new Triple<Double, Integer, Integer>((double)totalCorrect / (double)this.tokensCount, totalCorrect, totalWrong);
    }

    public double getAccuracy() {
        return this.getAccuracyInfo().first();
    }

    public String getAccuracyDescription(int numDigits) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(numDigits);
        Triple<Double, Integer, Integer> accu = this.getAccuracyInfo();
        return nf.format(accu.first()) + "  (" + accu.second() + "/" + (accu.second() + accu.third()) + ")";
    }

    public double score(String filename, String delimiter) throws IOException {
        return this.score(filename, delimiter, null);
    }

    public double score(String filename, String delimiter, String boundary) throws IOException {
        return this.score(FileUtils.getBufferedFileReader(filename), delimiter, boundary);
    }

    public double score(BufferedReader br, String delimiter) throws IOException {
        return this.score(br, delimiter, null);
    }

    public double score(BufferedReader br, String delimiter, String boundary) throws IOException {
        String line;
        int TOKEN_INDEX = 0;
        int ANSWER_INDEX = 1;
        int GUESS_INDEX = 2;
        Pattern delimPattern = Pattern.compile(delimiter);
        this.clearCounts();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() > 0) {
                String[] fields = delimPattern.split(line);
                if (boundary != null && boundary.equals(fields[TOKEN_INDEX])) {
                    this.markBoundary();
                    continue;
                }
                L answer = this.stringConverter.apply(fields[ANSWER_INDEX]);
                L guess = this.stringConverter.apply(fields[GUESS_INDEX]);
                this.addGuess(guess, answer);
                continue;
            }
            this.markBoundary();
        }
        this.finalizeCounts();
        return this.getFMeasure();
    }

    public List<L> getLabels() {
        return this.labelIndex.objectsList();
    }

    public String getConllEvalString() {
        return this.getConllEvalString(true);
    }

    public String getConllEvalString(boolean ignoreNegLabel) {
        List<L> labels = this.getLabels();
        if (labels.size() > 1 && labels.get(0) instanceof Comparable) {
            List<L> sortedLabels = labels;
            Collections.sort(sortedLabels);
        }
        return this.getConllEvalString(labels, ignoreNegLabel);
    }

    private String getConllEvalString(List<L> orderedLabels, boolean ignoreNegLabel) {
        StringBuilder sb = new StringBuilder();
        int correctPhrases = this.getCorrect() - this.getCorrect(this.negLabel);
        Triple<Double, Integer, Integer> accuracyInfo = this.getAccuracyInfo();
        int totalCount = accuracyInfo.second() + accuracyInfo.third();
        sb.append("processed " + totalCount + " tokens with " + this.getRelevant() + " phrases; ");
        sb.append("found: " + this.getRetrieved() + " phrases; correct: " + correctPhrases + "\n");
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("accuracy: %6.2f%%; ", accuracyInfo.first() * 100.0);
        formatter.format("precision: %6.2f%%; ", this.getPrecision() * 100.0);
        formatter.format("recall: %6.2f%%; ", this.getRecall() * 100.0);
        formatter.format("FB1: %6.2f\n", this.getFMeasure() * 100.0);
        for (L label : orderedLabels) {
            if (ignoreNegLabel && label.equals(this.negLabel)) continue;
            formatter.format("%17s: ", label);
            formatter.format("precision: %6.2f%%; ", this.getPrecision(label) * 100.0);
            formatter.format("recall: %6.2f%%; ", this.getRecall(label) * 100.0);
            formatter.format("FB1: %6.2f  %d\n", this.getFMeasure(label) * 100.0, this.getRetrieved(label));
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiClassStringLabelStats
    extends MultiClassPrecisionRecallExtendedStats<String> {
        public <F> MultiClassStringLabelStats(Classifier<String, F> classifier, GeneralDataset<String, F> data, String negLabel) {
            super(classifier, data, negLabel);
            this.stringConverter = new StringStringConverter();
        }

        public MultiClassStringLabelStats(String negLabel) {
            super(negLabel);
            this.stringConverter = new StringStringConverter();
        }

        public MultiClassStringLabelStats(Index<String> dataLabelIndex, String negLabel) {
            this(negLabel);
            this.setLabelIndex(dataLabelIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringStringConverter
    implements Function<String, String> {
        @Override
        public String apply(String str) {
            return str;
        }
    }
}

