/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.AbstractCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Factory;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenAddressCounter<E>
extends AbstractCounter<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AdjustableObject2DoubleOpenHashMap<E> map;
    private double total;

    public OpenAddressCounter(float loadFactor) {
        this.map = new AdjustableObject2DoubleOpenHashMap(16, loadFactor);
    }

    public OpenAddressCounter() {
        this.map = new AdjustableObject2DoubleOpenHashMap();
    }

    public OpenAddressCounter(Counter<E> c) {
        this(c, 0.75f);
    }

    public OpenAddressCounter(Counter<E> c, float loadFactor) {
        this.map = new AdjustableObject2DoubleOpenHashMap((int)((float)c.size() / loadFactor) + 1, loadFactor);
        for (Map.Entry<E, Double> e : c.entrySet()) {
            this.incrementCount(e.getKey(), e.getValue());
        }
    }

    @Override
    public Factory<Counter<E>> getFactory() {
        return new Factory<Counter<E>>(){
            private static final long serialVersionUID = 5992407519116558008L;

            @Override
            public Counter<E> create() {
                return new OpenAddressCounter();
            }
        };
    }

    @Override
    public void setDefaultReturnValue(double rv) {
        this.map.defaultReturnValue(rv);
    }

    @Override
    public double defaultReturnValue() {
        return this.map.defaultReturnValue();
    }

    @Override
    public double getCount(Object key) {
        return this.map.getDouble(key);
    }

    @Override
    public double remove(E key) {
        double rv = this.map.removeDouble(key);
        this.total -= rv;
        return rv;
    }

    @Override
    public void setCount(E key, double value) {
        this.total += value - this.map.put(key, value);
    }

    @Override
    public double incrementCount(E key, double amount) {
        this.total += amount;
        return this.map.adjust(key, amount) + amount;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.total = 0.0;
    }

    @Override
    public boolean containsKey(E key) {
        return this.map.containsKey(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public double totalCount() {
        return this.total;
    }

    public DoubleCollection values() {
        return this.map.values();
    }

    @Override
    public Set<E> keySet() {
        return new AbstractSet<E>(){

            @Override
            public Iterator<E> iterator() {
                return OpenAddressCounter.this.map.keySet().iterator();
            }

            @Override
            public int size() {
                return OpenAddressCounter.this.map.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<E, Double>> entrySet() {
        return (Set)ErasureUtils.uncheckedCast(this.object2DoubleEntrySet());
    }

    public ObjectSet<Object2DoubleMap.Entry<E>> object2DoubleEntrySet() {
        Object2DoubleMap.FastEntrySet set = this.map.object2DoubleEntrySet();
        return new AbstractObjectSet<Object2DoubleMap.Entry<E>>((ObjectSet)set){
            final /* synthetic */ ObjectSet val$set;
            {
                this.val$set = objectSet;
            }

            public ObjectIterator<Object2DoubleMap.Entry<E>> iterator() {
                return new ObjectIterator<Object2DoubleMap.Entry<E>>(){
                    final ObjectIterator<Object2DoubleMap.Entry<E>> iterator;
                    double lastValue;
                    {
                        this.iterator = val$set.iterator();
                    }

                    public int skip(int n) {
                        return this.iterator.skip(n);
                    }

                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    public Object2DoubleMap.Entry<E> next() {
                        Object2DoubleMap.Entry entry = (Object2DoubleMap.Entry)this.iterator.next();
                        this.lastValue = entry.getDoubleValue();
                        return new CounterEntry(entry);
                    }

                    public void remove() {
                        this.iterator.remove();
                        OpenAddressCounter.this.total -= this.lastValue;
                    }
                };
            }

            public boolean contains(Object o) {
                return this.val$set.contains(o);
            }

            public int size() {
                return this.val$set.size();
            }
        };
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Counter)) {
            return false;
        }
        if (!(other instanceof OpenAddressCounter)) {
            return Counters.equals(this, (Counter)other);
        }
        return this.map.equals(((OpenAddressCounter)other).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdjustableObject2DoubleOpenHashMap<F>
    extends Object2DoubleOpenHashMap<F> {
        private static final long serialVersionUID = 1L;

        public AdjustableObject2DoubleOpenHashMap() {
        }

        public AdjustableObject2DoubleOpenHashMap(int n, float f) {
            super(n, f);
        }

        public double adjust(F k, double adjust) {
            int i = this.findInsertionPoint(k);
            if (i < 0) {
                double oldvalue = this.value[-i - 1];
                int n = -i - 1;
                this.value[n] = this.value[n] + adjust;
                return oldvalue;
            }
            if (this.state[i] == 0) {
                --this.free;
            }
            this.state[i] = -1;
            this.key[i] = k;
            this.value[i] = adjust;
            if (++this.count >= this.maxFill) {
                int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
                while (PRIMES[newP] == PRIMES[this.p]) {
                    ++newP;
                }
                this.rehash(newP);
            }
            if (this.free == 0) {
                this.rehash(this.p);
            }
            return this.defRetValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CounterEntry
    implements Object2DoubleMap.Entry<E> {
        private Object2DoubleMap.Entry<E> wrapped;

        public CounterEntry(Object2DoubleMap.Entry<E> wrapped) {
            this.wrapped = wrapped;
        }

        public double getDoubleValue() {
            return this.wrapped.getDoubleValue();
        }

        public double setValue(double value) {
            OpenAddressCounter.this.total += value - this.wrapped.getDoubleValue();
            return this.wrapped.setValue(value);
        }

        public E getKey() {
            return this.wrapped.getKey();
        }

        public Double getValue() {
            return (Double)this.wrapped.getValue();
        }

        public Double setValue(Double value) {
            return this.setValue((double)value);
        }
    }
}

