/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;

class ExtractorWordShapeClassifier
extends Extractor {
    private final int wordShaper;
    private static final long serialVersionUID = 101L;

    ExtractorWordShapeClassifier(int position, String wsc) {
        super(position, false);
        this.wordShaper = WordShapeClassifier.lookupShaper(wsc);
    }

    String extract(History h, PairsHolder pH) {
        String s = super.extract(h, pH);
        String shape = WordShapeClassifier.wordShape(s, this.wordShaper);
        return shape;
    }

    public boolean isLocal() {
        return this.position == 0;
    }

    public boolean isDynamic() {
        return false;
    }
}

