/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.tagger.maxent.DataWordTag;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.HistoryTable;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.ReadDataTagged;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.tagger.maxent.TaggerFeature;
import edu.stanford.nlp.tagger.maxent.TaggerFeatures;
import edu.stanford.nlp.tagger.maxent.TemplateHash;
import edu.stanford.nlp.util.Pair;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TaggerExperiments
extends Experiments {
    private static final boolean DEBUG = true;
    private static final String zeroSt = "0";
    private final TaggerFeatures feats;
    private final Set<FeatureKey> sTemplates = new HashSet<FeatureKey>();
    private final HistoryTable tHistories = new HistoryTable();
    private final int numFeatsGeneral;
    private final int numFeatsAll;
    private final MaxentTagger maxentTagger;
    private final TemplateHash tFeature;

    TaggerExperiments(MaxentTagger maxentTagger) {
        this.maxentTagger = maxentTagger;
        this.tFeature = new TemplateHash(maxentTagger);
        this.numFeatsGeneral = maxentTagger.extractors.getSize();
        this.numFeatsAll = this.numFeatsGeneral + maxentTagger.extractorsRare.getSize();
        this.feats = new TaggerFeatures(maxentTagger.tags, this);
    }

    protected TaggerExperiments(TaggerConfig config, MaxentTagger maxentTagger) throws IOException {
        this(maxentTagger);
        System.err.println("TaggerExperiments: adding word/tags");
        PairsHolder pairs = new PairsHolder();
        ReadDataTagged c = new ReadDataTagged(config, maxentTagger, pairs);
        this.vArray = new int[c.getSize()][2];
        this.initTemplatesNew();
        System.err.println("Featurizing tagged data tokens...");
        int size = c.getSize();
        for (int i = 0; i < size; ++i) {
            DataWordTag d = c.get(i);
            String yS = d.getY();
            History h = d.getHistory();
            int indX = this.tHistories.add(h);
            int indY = d.getYInd();
            this.addTemplatesNew(h, yS);
            this.addRareTemplatesNew(h, yS);
            this.vArray[i][0] = indX;
            this.vArray[i][1] = indY;
            if (i <= 0 || i % 10000 != 0) continue;
            System.err.printf("%d ", i);
            if (i % 100000 != 0) continue;
            System.err.println();
        }
        System.err.println();
        System.err.println("Featurized " + c.getSize() + " data tokens [done].");
        c.release();
        this.ptilde();
        maxentTagger.xSize = this.xSize;
        maxentTagger.ySize = this.ySize;
        System.err.println("xSize [num Phi templates] = " + this.xSize + "; ySize [num classes] = " + this.ySize);
        this.hashHistories();
        if (!maxentTagger.occuringTagsOnly && !maxentTagger.possibleTagsOnly) {
            this.tHistories.release();
            pairs.clear();
        }
        this.getFeaturesNew();
    }

    public TaggerFeatures getTaggerFeatures() {
        return this.feats;
    }

    protected boolean add(FeatureKey s) {
        if (this.sTemplates.contains(s)) {
            return false;
        }
        this.sTemplates.add(s);
        return true;
    }

    private void getFeaturesNew() {
        try {
            int y;
            System.err.println("TaggerExperiments.getFeaturesNew: initializing fnumArr.");
            this.maxentTagger.fnumArr = new byte[this.xSize][this.ySize];
            File hFile = File.createTempFile("temp", ".x", new File("./"));
            RandomAccessFile hF = new RandomAccessFile(hFile, "rw");
            System.err.println("  length of sTemplates keys: " + this.sTemplates.size());
            System.err.println("getFeaturesNew adding features ...");
            int current = 0;
            int numFeats = 0;
            boolean VERBOSE = false;
            for (FeatureKey fK : this.sTemplates) {
                int numF = fK.num;
                Pair<Integer, String> wT = new Pair<Integer, String>(numF, fK.val);
                int[] xValues = this.tFeature.getXValues(wT);
                if (xValues == null) {
                    System.err.println("  xValues is null: " + fK.toString());
                    continue;
                }
                int numEvidence = 0;
                y = this.maxentTagger.tags.getIndex(fK.tag);
                for (int xValue : xValues) {
                    String word;
                    if (this.maxentTagger.occuringTagsOnly && this.maxentTagger.dict.getCount(word = ExtractorFrames.cWord.extract(this.tHistories.getHistory(xValue)), fK.tag) == 0) continue;
                    if (this.maxentTagger.possibleTagsOnly) {
                        word = ExtractorFrames.cWord.extract(this.tHistories.getHistory(xValue));
                        String[] tags = this.maxentTagger.dict.getTags(word);
                        HashSet<String> s = new HashSet<String>(Arrays.asList(this.maxentTagger.tags.deterministicallyExpandTags(tags, word)));
                        System.err.printf("possible tags for %s: %s\n", word, Arrays.toString(s.toArray()));
                        if (!s.contains(fK.tag)) continue;
                    }
                    numEvidence += this.px[xValue];
                }
                if (!this.populated(numF, numEvidence)) continue;
                int[] positions = this.tFeature.getPositions(fK);
                if (this.maxentTagger.occuringTagsOnly || this.maxentTagger.possibleTagsOnly) {
                    positions = null;
                }
                if (positions == null) {
                    int numElements = 0;
                    for (int x : xValues) {
                        String[] tags;
                        HashSet<String> s;
                        String word;
                        if (this.maxentTagger.occuringTagsOnly && this.maxentTagger.dict.getCount(word = ExtractorFrames.cWord.extract(this.tHistories.getHistory(x)), fK.tag) == 0 || this.maxentTagger.possibleTagsOnly && !(s = new HashSet<String>(Arrays.asList(this.maxentTagger.tags.deterministicallyExpandTags(tags = this.maxentTagger.dict.getTags(word = ExtractorFrames.cWord.extract(this.tHistories.getHistory(x))), word)))).contains(fK.tag)) continue;
                        ++numElements;
                        hF.writeInt(x);
                        byte[] byArray = this.maxentTagger.fnumArr[x];
                        int n = y;
                        byArray[n] = (byte)(byArray[n] + 1);
                    }
                    TaggerFeature tF = new TaggerFeature(current, current + numElements - 1, fK, this.maxentTagger.tags, this);
                    this.tFeature.addPositions(current, current + numElements - 1, fK);
                    current += numElements;
                    this.feats.add(tF);
                } else {
                    for (int x : xValues) {
                        byte[] byArray = this.maxentTagger.fnumArr[x];
                        int n = y;
                        byArray[n] = (byte)(byArray[n] + 1);
                    }
                    TaggerFeature tF = new TaggerFeature(positions[0], positions[1], fK, this.maxentTagger.tags, this);
                    this.feats.add(tF);
                }
                this.maxentTagger.fAssociations.put(fK, numFeats);
                ++numFeats;
            }
            this.tFeature.release();
            this.feats.xIndexed = new int[current];
            hF.seek(0L);
            for (int current1 = 0; current1 < current; ++current1) {
                this.feats.xIndexed[current1] = hF.readInt();
            }
            System.err.println("  total feats: " + this.sTemplates.size() + ", populated: " + numFeats);
            hF.close();
            hFile.delete();
            byte max = 0;
            int maxGt = 0;
            int numZeros = 0;
            for (int x = 0; x < this.xSize; ++x) {
                int numGt = 0;
                for (y = 0; y < this.ySize; ++y) {
                    if (this.maxentTagger.fnumArr[x][y] > 0) {
                        ++numGt;
                        if (max >= this.maxentTagger.fnumArr[x][y]) continue;
                        max = this.maxentTagger.fnumArr[x][y];
                        continue;
                    }
                    ++numZeros;
                }
                if (maxGt >= numGt) continue;
                maxGt = numGt;
            }
            System.err.println("  Max features per x,y pair: " + max);
            System.err.println("  Max non-zero y values for an x: " + maxGt);
            System.err.println("  Number of non-zero feature x,y pairs: " + (this.xSize * this.ySize - numZeros));
            System.err.println("  Number of zero feature x,y pairs: " + numZeros);
            System.err.println("end getFeaturesNew.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hashHistories() {
        int i;
        int fSize;
        History h;
        int x;
        int fAll = this.maxentTagger.extractors.getSize() + this.maxentTagger.extractorsRare.getSize();
        int fGeneral = this.maxentTagger.extractors.getSize();
        System.err.println("Hashing histories ...");
        for (x = 0; x < this.xSize; ++x) {
            h = this.tHistories.getHistory(x);
            if (x > 0 && x % 10000 == 0) {
                System.err.printf("%d ", x);
                if (x % 100000 == 0) {
                    System.err.println();
                }
            }
            fSize = this.maxentTagger.isRare(ExtractorFrames.cWord.extract(h)) ? fAll : fGeneral;
            for (i = 0; i < fSize; ++i) {
                this.tFeature.addPrev(i, h);
            }
        }
        System.err.println();
        System.err.println("Hashed " + this.xSize + " histories.");
        System.err.println("Hashing populated histories ...");
        for (x = 0; x < this.xSize; ++x) {
            h = this.tHistories.getHistory(x);
            if (x > 0 && x % 10000 == 0) {
                System.err.print(x + " ");
                if (x % 100000 == 0) {
                    System.err.println();
                }
            }
            fSize = this.maxentTagger.isRare(ExtractorFrames.cWord.extract(h)) ? fAll : fGeneral;
            for (i = 0; i < fSize; ++i) {
                this.tFeature.add(i, h, x);
            }
        }
        System.err.println();
        System.err.println("Hashed populated histories.");
    }

    protected boolean populated(int fNo, int size) {
        return TaggerExperiments.isPopulated(fNo, size, this.maxentTagger);
    }

    protected static boolean isPopulated(int fNo, int size, MaxentTagger maxentTagger) {
        if (fNo == 0) {
            return size > maxentTagger.curWordMinFeatureThresh;
        }
        if (fNo < maxentTagger.extractors.getSize()) {
            return size > maxentTagger.minFeatureThresh;
        }
        return size > maxentTagger.rareWordMinFeatureThresh;
    }

    private void initTemplatesNew() {
        this.maxentTagger.dict.setAmbClasses(this.maxentTagger.ambClasses, this.maxentTagger.veryCommonWordThresh, this.maxentTagger.tags);
    }

    private void addTemplatesNew(History h, String tag) {
        for (int i = 0; i < this.numFeatsGeneral; ++i) {
            String s = this.maxentTagger.extractors.extract(i, h);
            if (s.equals(zeroSt)) continue;
            this.maxentTagger.getClass();
            FeatureKey key = new FeatureKey(i, s, tag);
            if (!this.maxentTagger.extractors.get(i).precondition(tag)) continue;
            this.add(key);
        }
    }

    private void addRareTemplatesNew(History h, String tag) {
        int start;
        if (!this.maxentTagger.isRare(ExtractorFrames.cWord.extract(h))) {
            return;
        }
        for (int i = start = this.numFeatsGeneral; i < this.numFeatsAll; ++i) {
            String s = this.maxentTagger.extractorsRare.extract(i - start, h);
            if (s.equals(zeroSt)) continue;
            this.maxentTagger.getClass();
            FeatureKey key = new FeatureKey(i, s, tag);
            if (!this.maxentTagger.extractorsRare.get(i - start).precondition(tag)) continue;
            this.add(key);
        }
    }

    HistoryTable getHistoryTable() {
        return this.tHistories;
    }
}

