/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.maxent.Features;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.tagger.maxent.TaggerExperiments;
import edu.stanford.nlp.tagger.maxent.TaggerFeature;

public class TaggerFeatures
extends Features {
    int[] xIndexed;
    final TTags ttags;
    final TaggerExperiments domain;

    TaggerFeatures(TTags ttags, TaggerExperiments domain) {
        this.ttags = ttags;
        this.domain = domain;
    }

    public void save(String filename) {
        try {
            OutDataStreamFile rF = new OutDataStreamFile(filename);
            rF.writeInt(this.xIndexed.length);
            for (int aXIndexed : this.xIndexed) {
                rF.writeInt(aXIndexed);
            }
            rF.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.get(i).save(rF);
            }
            rF.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rF = new InDataStreamFile(filename);
            int len = rF.readInt();
            this.xIndexed = new int[len];
            for (int i = 0; i < this.xIndexed.length; ++i) {
                this.xIndexed[i] = rF.readInt();
            }
            int numFeats = rF.readInt();
            for (int i = 0; i < numFeats; ++i) {
                TaggerFeature tF = new TaggerFeature(this.ttags, this.domain);
                tF.read(rF);
                this.add(tF);
            }
            rF.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

