/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.ling.HasOffset;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.ExactBestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.Extractors;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.util.ArrayUtils;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSentence
implements SequenceModel {
    protected static final boolean VERBOSE = false;
    protected static final String naTag = "NA";
    protected static final boolean DBG = false;
    protected static final boolean doDeterministicTagExpansion = true;
    protected static final int kBestSize = 1;
    protected final String tagSeparator;
    protected final String encoding;
    protected final PairsHolder pairs = new PairsHolder();
    protected List<String> sent;
    protected List<HasWord> origWords;
    protected int size;
    protected String[] correctTags;
    protected String[] finalTags;
    int numRight;
    int numWrong;
    int numUnknown;
    int numWrongUnknown;
    private int endSizePairs;
    private volatile History history;
    protected volatile Map<String, double[]> localScores = new HashMap<String, double[]>();
    protected volatile double[][] localContextScores;
    protected final MaxentTagger maxentTagger;

    public TestSentence(MaxentTagger maxentTagger) {
        assert (maxentTagger != null);
        assert (maxentTagger.getLambdaSolve() != null);
        this.maxentTagger = maxentTagger;
        if (maxentTagger.config != null) {
            this.tagSeparator = maxentTagger.config.getTagSeparator();
            this.encoding = maxentTagger.config.getEncoding();
        } else {
            this.tagSeparator = TaggerConfig.getDefaultTagSeparator();
            this.encoding = "utf-8";
        }
        this.history = new History(this.pairs, maxentTagger.extractors);
    }

    public TestSentence(MaxentTagger maxentTagger, String[] s, String[] correctTags, PrintFile pf, Dictionary wrongWords, boolean verboseResults) {
        this(maxentTagger);
        this.origWords = null;
        this.sent = new ArrayList<String>(Arrays.asList(s));
        this.size = this.sent.size();
        this.correctTags = correctTags;
        this.init();
        this.testTagInference(pf, wrongWords, verboseResults);
    }

    public ArrayList<TaggedWord> tagSentence(List<? extends HasWord> s) {
        this.origWords = new ArrayList<HasWord>(s);
        int sz = s.size();
        ArrayList<String> sentence = new ArrayList<String>(sz + 1);
        this.sent = sentence;
        for (int j = 0; j < sz; ++j) {
            sentence.add(s.get(j).word());
        }
        this.sent.add(".$.");
        this.size = sz + 1;
        this.init();
        return this.testTagInference();
    }

    protected void revert(int prevSize) {
        this.endSizePairs = prevSize;
    }

    protected void init() {
        this.localContextScores = new double[this.size][];
        for (int i = 0; i < this.size - 1; ++i) {
            if (!this.maxentTagger.dict.isUnknown(this.sent.get(i))) continue;
            ++this.numUnknown;
        }
    }

    String getTaggedNice() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size - 1; ++i) {
            sb.append(TestSentence.toNice(this.sent.get(i))).append(this.tagSeparator).append(TestSentence.toNice(this.finalTags[i]));
            sb.append(' ');
        }
        return sb.toString();
    }

    ArrayList<TaggedWord> getTaggedSentence() {
        boolean hasOffset = this.origWords != null && this.origWords.get(0) instanceof HasOffset;
        ArrayList<TaggedWord> taggedSentence = new ArrayList<TaggedWord>();
        for (int j = 0; j < this.size - 1; ++j) {
            String tag = this.finalTags[j];
            TaggedWord w = new TaggedWord(this.sent.get(j), tag);
            if (hasOffset) {
                HasOffset offset = (HasOffset)((Object)this.origWords.get(j));
                w.setBeginPosition(offset.beginPosition());
                w.setEndPosition(offset.endPosition());
            }
            taggedSentence.add(w);
        }
        return taggedSentence;
    }

    static String toNice(String s) {
        if (s == null) {
            return naTag;
        }
        return s;
    }

    protected void calculateProbs(double[][][] probabilities) {
        ArrayUtils.fill(probabilities, Double.NEGATIVE_INFINITY);
        for (int hyp = 0; hyp < 1; ++hyp) {
            this.pairs.setSize(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.pairs.setWord(i, this.sent.get(i));
                this.pairs.setTag(i, this.finalTags[i]);
            }
            int start = this.endSizePairs;
            int end = this.endSizePairs + this.size - 1;
            this.endSizePairs += this.size;
            for (int current = 0; current < this.size; ++current) {
                History h = new History(start, end, current + start, this.pairs, this.maxentTagger.extractors);
                String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
                double[] probs = this.getHistories(tags, h);
                ArrayMath.logNormalize(probs);
                for (int j = 0; j < tags.length; ++j) {
                    String tag = tags[j];
                    boolean approximate = this.maxentTagger.defaultScore > 0.0;
                    int tagindex = approximate ? this.maxentTagger.tags.getIndex(tag) : j;
                    probabilities[current][hyp][tagindex] = probs[j];
                }
            }
        }
        this.revert(0);
    }

    protected void writeTagsAndErrors(String[] finalTags, PrintFile pf, Dictionary wrongWords, boolean verboseResults) {
        StringWriter sw = new StringWriter(200);
        for (int i = 0; i < this.correctTags.length - 1; ++i) {
            sw.write(TestSentence.toNice(this.sent.get(i)));
            sw.write(this.tagSeparator);
            sw.write(finalTags[i]);
            sw.write(32);
            if (pf != null) {
                pf.print(TestSentence.toNice(this.sent.get(i)));
                pf.print(this.tagSeparator);
                pf.print(finalTags[i]);
            }
            if (this.correctTags[i].equals(finalTags[i])) {
                ++this.numRight;
            } else {
                ++this.numWrong;
                if (pf != null) {
                    pf.print('|' + this.correctTags[i]);
                }
                if (verboseResults) {
                    EncodingPrintWriter.err.println("Word: " + this.sent.get(i) + "; correct: " + this.correctTags[i] + "; guessed: " + finalTags[i], this.encoding);
                }
                wrongWords.add(this.sent.get(i) + this.correctTags[i], finalTags[i]);
                if (this.maxentTagger.dict.isUnknown(this.sent.get(i))) {
                    ++this.numWrongUnknown;
                    if (pf != null) {
                        pf.print("*");
                    }
                }
            }
            if (pf == null) continue;
            pf.print(' ');
        }
        if (pf != null) {
            pf.println();
        }
        if (verboseResults) {
            PrintWriter pw;
            try {
                pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, this.encoding), true);
            }
            catch (UnsupportedEncodingException uee) {
                pw = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
            }
            pw.println(sw);
        }
    }

    private void testTagInference(PrintFile pf, Dictionary wrongWords, boolean verboseResults) {
        this.runTagInference();
        this.writeTagsAndErrors(this.finalTags, pf, wrongWords, verboseResults);
    }

    private ArrayList<TaggedWord> testTagInference() {
        this.runTagInference();
        return this.getTaggedSentence();
    }

    private void runTagInference() {
        this.initializeScorer();
        ExactBestSequenceFinder ti = new ExactBestSequenceFinder();
        int[] bestTags = ti.bestSequence(this);
        this.finalTags = new String[bestTags.length];
        for (int j = 0; j < this.size; ++j) {
            this.finalTags[j] = this.maxentTagger.tags.getTag(bestTags[j + this.leftWindow()]);
        }
        this.cleanUpScorer();
    }

    private void setHistory(int current, History h, int[] tags) {
        int left = this.leftWindow();
        int right = this.rightWindow();
        for (int j = current - left; j <= current + right; ++j) {
            if (j < left) continue;
            if (j >= this.size + left) break;
            h.setTag(j - left, this.maxentTagger.tags.getTag(tags[j]));
        }
    }

    protected void initializeScorer() {
        this.pairs.setSize(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.pairs.setWord(i, this.sent.get(i));
        }
        this.endSizePairs += this.size;
    }

    protected void cleanUpScorer() {
        this.revert(0);
    }

    protected String[] append(String[] tags, String word) {
        return this.maxentTagger.tags.deterministicallyExpandTags(tags, word);
    }

    private double[] getScores(History h) {
        if (this.maxentTagger.defaultScore > 0.0) {
            return this.getApproximateScores(h);
        }
        return this.getExactScores(h);
    }

    private double[] getExactScores(History h) {
        String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
        double[] histories = this.getHistories(tags, h);
        ArrayMath.logNormalize(histories);
        double[] scores = new double[tags.length];
        for (int j = 0; j < tags.length; ++j) {
            String tag = tags[j];
            int tagindex = this.maxentTagger.tags.getIndex(tag);
            scores[j] = histories[tagindex];
        }
        return scores;
    }

    private double[] getApproximateScores(History h) {
        String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
        double[] scores = this.getHistories(tags, h);
        double nDefault = this.maxentTagger.ySize - tags.length;
        double logScore = ArrayMath.logSum(scores);
        double logScoreInactiveTags = Math.log(nDefault * this.maxentTagger.defaultScore);
        double logTotal = ArrayMath.logSum(new double[]{logScore, logScoreInactiveTags});
        ArrayMath.addInPlace(scores, -logTotal);
        return scores;
    }

    protected double[] getHistories(String[] tags, History h) {
        double[] lcS;
        boolean rare = this.maxentTagger.isRare(ExtractorFrames.cWord.extract(h));
        Extractors ex = this.maxentTagger.extractors;
        Extractors exR = this.maxentTagger.extractorsRare;
        String w = this.pairs.getWord(h.current);
        double[] lS = this.localScores.get(w);
        if (lS == null) {
            lS = this.getHistories(tags, h, ex.local, rare ? exR.local : null);
            this.localScores.put(w, lS);
        }
        if ((lcS = this.localContextScores[h.current]) == null) {
            lcS = this.getHistories(tags, h, ex.localContext, rare ? exR.localContext : null);
            this.localContextScores[h.current] = lcS;
            ArrayMath.pairwiseAddInPlace(lcS, lS);
        }
        double[] totalS = this.getHistories(tags, h, ex.dynamic, rare ? exR.dynamic : null);
        ArrayMath.pairwiseAddInPlace(totalS, lcS);
        return totalS;
    }

    private double[] getHistories(String[] tags, History h, Map<Integer, Extractor> extractors, Map<Integer, Extractor> extractorsRare) {
        if (this.maxentTagger.defaultScore > 0.0) {
            return this.getApproximateHistories(tags, h, extractors, extractorsRare);
        }
        return this.getExactHistories(h, extractors, extractorsRare);
    }

    private double[] getExactHistories(History h, Map<Integer, Extractor> extractors, Map<Integer, Extractor> extractorsRare) {
        int fNum;
        String tag;
        int i;
        Extractor ex;
        int kf;
        double[] scores = new double[this.maxentTagger.ySize];
        FeatureKey s = new FeatureKey();
        int szCommon = this.maxentTagger.extractors.getSize();
        for (Map.Entry<Integer, Extractor> e : extractors.entrySet()) {
            kf = e.getKey();
            ex = e.getValue();
            for (i = 0; i < this.maxentTagger.ySize; ++i) {
                tag = this.maxentTagger.tags.getTag(i);
                s.set(kf, ex.extract(h), tag);
                fNum = this.maxentTagger.getNum(s);
                if (fNum <= -1) continue;
                int n = i;
                scores[n] = scores[n] + this.maxentTagger.getLambdaSolve().lambda[fNum];
            }
        }
        if (extractorsRare != null) {
            for (Map.Entry<Integer, Extractor> e : extractorsRare.entrySet()) {
                kf = e.getKey();
                ex = e.getValue();
                for (i = 0; i < this.maxentTagger.ySize; ++i) {
                    tag = this.maxentTagger.tags.getTag(i);
                    s.set(szCommon + kf, ex.extract(h), tag);
                    fNum = this.maxentTagger.getNum(s);
                    if (fNum <= -1) continue;
                    int n = i;
                    scores[n] = scores[n] + this.maxentTagger.getLambdaSolve().lambda[fNum];
                }
            }
        }
        return scores;
    }

    private double[] getApproximateHistories(String[] tags, History h, Map<Integer, Extractor> extractors, Map<Integer, Extractor> extractorsRare) {
        int fNum;
        String tag;
        int j;
        Extractor ex;
        int kf;
        double[] scores = new double[tags.length];
        FeatureKey s = new FeatureKey();
        int szCommon = this.maxentTagger.extractors.getSize();
        for (Map.Entry<Integer, Extractor> e : extractors.entrySet()) {
            kf = e.getKey();
            ex = e.getValue();
            for (j = 0; j < tags.length; ++j) {
                tag = tags[j];
                s.set(kf, ex.extract(h), tag);
                fNum = this.maxentTagger.getNum(s);
                if (fNum <= -1) continue;
                int n = j;
                scores[n] = scores[n] + this.maxentTagger.getLambdaSolve().lambda[fNum];
            }
        }
        if (extractorsRare != null) {
            for (Map.Entry<Integer, Extractor> e : extractorsRare.entrySet()) {
                kf = e.getKey();
                ex = e.getValue();
                for (j = 0; j < tags.length; ++j) {
                    tag = tags[j];
                    s.set(szCommon + kf, ex.extract(h), tag);
                    fNum = this.maxentTagger.getNum(s);
                    if (fNum <= -1) continue;
                    int n = j;
                    scores[n] = scores[n] + this.maxentTagger.getLambdaSolve().lambda[fNum];
                }
            }
        }
        return scores;
    }

    void printUnknown(int numSent, PrintFile pfu) {
        DecimalFormat nf = new DecimalFormat("0.0000");
        int numTags = this.maxentTagger.tags.getSize();
        double[][][] probabilities = new double[this.size][1][numTags];
        this.calculateProbs(probabilities);
        for (int current = 0; current < this.size; ++current) {
            int rank;
            if (!this.maxentTagger.dict.isUnknown(this.sent.get(current))) continue;
            pfu.print(this.sent.get(current));
            pfu.print(':');
            pfu.print(numSent);
            double[] probs = new double[3];
            String[] tag3 = new String[3];
            this.getTop3(probabilities, current, probs, tag3);
            for (int i = 0; i < 3; ++i) {
                if (!(probs[i] > Double.NEGATIVE_INFINITY)) continue;
                pfu.print('\t');
                pfu.print(tag3[i]);
                pfu.print(' ');
                pfu.print(nf.format(Math.exp(probs[i])));
            }
            String correctTag = TestSentence.toNice(this.correctTags[current]);
            for (rank = 0; rank < 3 && !correctTag.equals(tag3[rank]); ++rank) {
            }
            pfu.print('\t');
            switch (rank) {
                case 0: {
                    pfu.print("Correct");
                    break;
                }
                case 1: {
                    pfu.print("2nd");
                    break;
                }
                case 2: {
                    pfu.print("3rd");
                    break;
                }
                default: {
                    pfu.print("Not top 3");
                }
            }
            pfu.println();
        }
    }

    void printTop(PrintFile pfu) {
        DecimalFormat nf = new DecimalFormat("0.0000");
        int numTags = this.maxentTagger.tags.getSize();
        double[][][] probabilities = new double[this.size][1][numTags];
        this.calculateProbs(probabilities);
        for (int current = 0; current < this.size; ++current) {
            int rank;
            pfu.print(this.sent.get(current));
            double[] probs = new double[3];
            String[] tag3 = new String[3];
            this.getTop3(probabilities, current, probs, tag3);
            for (int i = 0; i < 3; ++i) {
                if (!(probs[i] > Double.NEGATIVE_INFINITY)) continue;
                pfu.print('\t');
                pfu.print(tag3[i]);
                pfu.print(' ');
                pfu.print(nf.format(Math.exp(probs[i])));
            }
            String correctTag = TestSentence.toNice(this.correctTags[current]);
            for (rank = 0; rank < 3 && !correctTag.equals(tag3[rank]); ++rank) {
            }
            pfu.print('\t');
            switch (rank) {
                case 0: {
                    pfu.print("Correct");
                    break;
                }
                case 1: {
                    pfu.print("2nd");
                    break;
                }
                case 2: {
                    pfu.print("3rd");
                    break;
                }
                default: {
                    pfu.print("Not top 3");
                }
            }
            pfu.println();
        }
    }

    private void getTop3(double[][][] probabilities, int current, double[] probs, String[] tags) {
        int[] topIds = new int[3];
        double[] probTags = probabilities[current][0];
        Arrays.fill(probs, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < probTags.length; ++i) {
            if (probTags[i] > probs[0]) {
                probs[2] = probs[1];
                probs[1] = probs[0];
                probs[0] = probTags[i];
                topIds[2] = topIds[1];
                topIds[1] = topIds[0];
                topIds[0] = i;
                continue;
            }
            if (probTags[i] > probs[1]) {
                probs[2] = probs[1];
                probs[1] = probTags[i];
                topIds[2] = topIds[1];
                topIds[1] = i;
                continue;
            }
            if (!(probTags[i] > probs[2])) continue;
            probs[2] = probTags[i];
            topIds[2] = i;
        }
        for (int j = 0; j < 3; ++j) {
            tags[j] = TestSentence.toNice(this.maxentTagger.tags.getTag(topIds[j]));
        }
    }

    @Override
    public int length() {
        return this.sent.size();
    }

    @Override
    public int leftWindow() {
        return this.maxentTagger.leftContext;
    }

    @Override
    public int rightWindow() {
        return this.maxentTagger.rightContext;
    }

    @Override
    public int[] getPossibleValues(int pos) {
        String[] arr1 = this.stringTagsAt(pos);
        int[] arr = new int[arr1.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.maxentTagger.tags.getIndex(arr1[i]);
        }
        return arr;
    }

    @Override
    public double scoreOf(int[] tags, int pos) {
        double[] scores = this.scoresOf(tags, pos);
        double score = Double.NEGATIVE_INFINITY;
        int[] pv = this.getPossibleValues(pos);
        for (int i = 0; i < scores.length; ++i) {
            if (pv[i] != tags[pos]) continue;
            score = scores[i];
        }
        return score;
    }

    @Override
    public double scoreOf(int[] sequence) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] scoresOf(int[] tags, int pos) {
        this.history.init(this.endSizePairs - this.size, this.endSizePairs - 1, this.endSizePairs - this.size + pos - this.leftWindow());
        this.setHistory(pos, this.history, tags);
        return this.getScores(this.history);
    }

    protected String[] stringTagsAt(int pos) {
        if (pos < this.leftWindow() || pos >= this.size + this.leftWindow()) {
            String[] arr1 = new String[]{naTag};
            return arr1;
        }
        String[] arr1 = this.maxentTagger.dict.isUnknown(this.sent.get(pos - this.leftWindow())) ? this.maxentTagger.tags.getOpenTags().toArray(new String[this.maxentTagger.tags.getOpenTags().size()]) : this.maxentTagger.dict.getTags(this.sent.get(pos - this.leftWindow()));
        arr1 = this.append(arr1, this.sent.get(pos - this.leftWindow()));
        return arr1;
    }
}

