/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.TreeGraphNode;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedDependency
implements Comparable<TypedDependency>,
Serializable {
    private static final long serialVersionUID = -7690294213151279779L;
    private GrammaticalRelation reln;
    private TreeGraphNode gov;
    private TreeGraphNode dep;
    private boolean extra;

    public TypedDependency(GrammaticalRelation reln, TreeGraphNode gov, TreeGraphNode dep) {
        this.reln = reln;
        this.gov = gov;
        this.dep = dep;
    }

    public GrammaticalRelation reln() {
        return this.reln;
    }

    public TreeGraphNode gov() {
        return this.gov;
    }

    public TreeGraphNode dep() {
        return this.dep;
    }

    public boolean extra() {
        return this.extra;
    }

    public void setReln(GrammaticalRelation reln) {
        this.reln = reln;
    }

    public void setGov(TreeGraphNode gov) {
        this.gov = gov;
    }

    public void setDep(TreeGraphNode dep) {
        this.dep = dep;
    }

    public void setExtra() {
        this.extra = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedDependency)) {
            return false;
        }
        TypedDependency typedDep = (TypedDependency)o;
        if (this.reln != null ? !this.reln.equals(typedDep.reln) : typedDep.reln != null) {
            return false;
        }
        if (this.gov != null ? !this.gov.equals(typedDep.gov) : typedDep.gov != null) {
            return false;
        }
        return !(this.dep != null ? !this.dep.equals(typedDep.dep) : typedDep.dep != null);
    }

    public int hashCode() {
        int result = this.reln != null ? this.reln.hashCode() : 17;
        result = 29 * result + (this.gov != null ? this.gov.hashCode() : 0);
        result = 29 * result + (this.dep != null ? this.dep.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.reln + "(" + this.gov + this.gov.toPrimes() + ", " + this.dep + this.dep.toPrimes() + ")";
    }

    public String toString(boolean noIndex) {
        if (!noIndex) {
            return this.toString();
        }
        String govWord = this.gov.toString();
        String depWord = this.dep.toString();
        govWord = govWord.substring(0, govWord.lastIndexOf("-"));
        depWord = depWord.substring(0, depWord.lastIndexOf("-"));
        return this.reln + "(" + govWord + ", " + depWord + ")";
    }

    @Override
    public int compareTo(TypedDependency tdArg) {
        TreeGraphNode depArg = tdArg.dep();
        TreeGraphNode depThis = this.dep();
        int indexArg = depArg.index();
        int indexThis = depThis.index();
        if (indexThis > indexArg) {
            return 1;
        }
        if (indexThis < indexArg) {
            return -1;
        }
        int govIndexArg = tdArg.gov().index();
        int govIndexThis = this.gov().index();
        if (govIndexThis > govIndexArg) {
            return 1;
        }
        if (govIndexThis < govIndexArg) {
            return -1;
        }
        return this.reln().compareTo(tdArg.reln());
    }
}

