/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.semgraph;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.semgraph.SemanticGraphUtils;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticGraphFactory {
    private static final boolean INCLUDE_PUNCTUATION_DEPENDENCIES = false;

    private SemanticGraphFactory() {
    }

    public static SemanticGraph makeFromTree(Tree tree, boolean collapse, boolean ccProcess, boolean includeExtras, boolean lemmatize, boolean threadSafe, Filter<TypedDependency> filter) {
        return SemanticGraphFactory.makeFromTree(tree, collapse, ccProcess, includeExtras, lemmatize, threadSafe, filter, "", 0);
    }

    public static SemanticGraph makeFromTree(Tree tree, boolean collapse, boolean ccProcess, boolean includeExtras, boolean lemmatize, boolean threadSafe, Filter<TypedDependency> filter, String docID, int sentIndex) {
        Filter<String> wordFilt = new PennTreebankLanguagePack().punctuationWordRejectFilter();
        EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree, wordFilt, (HeadFinder)new SemanticHeadFinder(true), threadSafe);
        return SemanticGraphFactory.makeFromTree(gs, collapse, false, ccProcess, includeExtras, lemmatize, threadSafe, filter, docID, sentIndex);
    }

    public static SemanticGraph makeFromTree(GrammaticalStructure gs, boolean collapse, boolean tree, boolean ccProcess, boolean includeExtras, boolean lemmatize, boolean threadSafe, Filter<TypedDependency> filter, String docID, int sentIndex) {
        SemanticGraphFactory.addProjectedCategoriesToGrammaticalStructure(gs);
        Collection<TypedDependency> deps = tree ? gs.typedDependenciesCollapsedTree() : (collapse ? (ccProcess ? gs.typedDependenciesCCprocessed(includeExtras) : gs.typedDependenciesCollapsed(includeExtras)) : gs.typedDependencies(includeExtras));
        if (filter != null) {
            ArrayList<TypedDependency> depsFiltered = Generics.newArrayList();
            for (TypedDependency td : deps) {
                if (!filter.accept(td)) continue;
                depsFiltered.add(td);
            }
            deps = depsFiltered;
        }
        HashSet<TreeGraphNode> roots = Generics.newHashSet();
        if (gs.root().headWordNode() != null) {
            roots.add(gs.root().headWordNode());
        }
        return new SemanticGraph(deps, roots, docID, sentIndex, lemmatize, threadSafe);
    }

    public static SemanticGraph makeFromTree(GrammaticalStructure structure, String docID, int sentIndex) {
        return SemanticGraphFactory.makeFromTree(structure, false, false, false, false, false, false, null, docID, sentIndex);
    }

    public static SemanticGraph makeFromTree(Tree tree, boolean collapse, boolean ccProcess, boolean includeExtras, Filter<TypedDependency> filter) {
        return SemanticGraphFactory.makeFromTree(tree, collapse, ccProcess, includeExtras, false, false, filter);
    }

    public static SemanticGraph makeFromTree(Tree tree, boolean collapse, boolean ccProcess, boolean includeExtras, boolean lemmatize, boolean threadSafe) {
        return SemanticGraphFactory.makeFromTree(tree, collapse, ccProcess, includeExtras, lemmatize, threadSafe, null);
    }

    public static SemanticGraph makeFromTree(Tree tree, boolean collapse) {
        return SemanticGraphFactory.makeFromTree(tree, collapse, false, false, false, false, null);
    }

    public static SemanticGraph makeFromTree(Tree tree) {
        return SemanticGraphFactory.makeFromTree(tree, true, false, false, false, false, null);
    }

    public static SemanticGraph allTypedDependencies(Tree tree, boolean collapse) {
        return SemanticGraphFactory.makeFromTree(tree, collapse, false, true, null);
    }

    static void addProjectedCategoriesToGrammaticalStructure(GrammaticalStructure gs) {
        ArrayList<TreeGraphNode> nodes = new ArrayList<TreeGraphNode>();
        for (Tree tree : gs.root()) {
            nodes.add((TreeGraphNode)tree);
        }
        Collections.reverse(nodes);
        for (TreeGraphNode treeGraphNode : nodes) {
            CyclicCoreLabel label;
            Tree hw;
            if ("ROOT".equals(treeGraphNode.value()) || (hw = (Tree)(label = treeGraphNode.label()).get(TreeCoreAnnotations.HeadWordAnnotation.class)) == null) continue;
            TreeGraphNode hwn = (TreeGraphNode)hw;
            CyclicCoreLabel hwLabel = hwn.label();
            hwLabel.set(CoreAnnotations.ProjectedCategoryAnnotation.class, treeGraphNode.value());
        }
    }

    public static SemanticGraph makeFromEdges(Iterable<SemanticGraphEdge> edges) {
        SemanticGraph sg = new SemanticGraph();
        Collection<IndexedWord> vertices = SemanticGraphUtils.getVerticesFromEdgeSet(edges);
        for (IndexedWord vertice : vertices) {
            sg.addVertex(vertice);
        }
        for (SemanticGraphEdge edge : edges) {
            sg.addEdge((IndexedWord)edge.getSource(), (IndexedWord)edge.getTarget(), edge.getRelation(), edge.getWeight());
        }
        sg.resetRoots();
        return sg;
    }

    public static SemanticGraph makeFromVertices(SemanticGraph sg, Collection<IndexedWord> nodes) {
        ArrayList<SemanticGraphEdge> edgesToAdd = new ArrayList<SemanticGraphEdge>();
        ArrayList<IndexedWord> nodesToAdd = new ArrayList<IndexedWord>(nodes);
        for (IndexedWord nodeA : nodes) {
            for (IndexedWord nodeB : nodes) {
                List<SemanticGraphEdge> edges;
                if (nodeA == nodeB || (edges = sg.getShortestDirectPathEdges(nodeA, nodeB)) == null) continue;
                edgesToAdd.addAll(edges);
                for (SemanticGraphEdge edge : edges) {
                    IndexedWord gov = edge.getGovernor();
                    IndexedWord dep = edge.getDependent();
                    if (gov != null && !nodesToAdd.contains(gov)) {
                        nodesToAdd.add(gov);
                    }
                    if (dep == null || nodesToAdd.contains(dep)) continue;
                    nodesToAdd.add(dep);
                }
            }
        }
        SemanticGraph retSg = new SemanticGraph();
        for (IndexedWord node : nodesToAdd) {
            retSg.addVertex(node);
        }
        for (SemanticGraphEdge edge : edgesToAdd) {
            retSg.addEdge(edge.getGovernor(), edge.getDependent(), edge.getRelation(), edge.getWeight());
        }
        retSg.resetRoots();
        return retSg;
    }

    public static SemanticGraph duplicateKeepNodes(SemanticGraph sg) {
        SemanticGraph retSg = new SemanticGraph();
        for (IndexedWord node : sg.vertexSet()) {
            retSg.addVertex(node);
        }
        retSg.setRoots(sg.getRoots());
        for (SemanticGraphEdge edge : sg.edgeSet()) {
            retSg.addEdge(edge.getGovernor(), edge.getDependent(), edge.getRelation(), edge.getWeight());
        }
        return retSg;
    }

    public static SemanticGraph makeFromGraphs(Collection<SemanticGraph> sgList) {
        SemanticGraph sg = new SemanticGraph();
        HashSet<IndexedWord> newRoots = new HashSet<IndexedWord>();
        for (SemanticGraph currSg : sgList) {
            newRoots.addAll(currSg.getRoots());
            for (IndexedWord currVertex : currSg.vertexList()) {
                sg.addVertex(currVertex);
            }
            for (SemanticGraphEdge currEdge : currSg.edgeList()) {
                sg.addEdge(currEdge.getGovernor(), currEdge.getDependent(), currEdge.getRelation(), currEdge.getWeight());
            }
        }
        sg.setRoots(newRoots);
        return sg;
    }

    public static SemanticGraph deepCopyFromGraphs(List<SemanticGraph> graphs, List<Integer> lengths) {
        SemanticGraph newGraph = new SemanticGraph();
        HashMap<Integer, IndexedWord> newWords = new HashMap<Integer, IndexedWord>();
        ArrayList<IndexedWord> newRoots = new ArrayList<IndexedWord>();
        int vertexOffset = 0;
        for (int i = 0; i < graphs.size(); ++i) {
            SemanticGraph graph = graphs.get(i);
            for (IndexedWord vertex : graph.vertexList()) {
                IndexedWord newVertex = new IndexedWord(vertex);
                newVertex.setIndex(vertex.index() + vertexOffset);
                newGraph.addVertex(newVertex);
                newWords.put(newVertex.index(), newVertex);
            }
            for (SemanticGraphEdge edge : graph.edgeList()) {
                IndexedWord gov = (IndexedWord)newWords.get(edge.getGovernor().index() + vertexOffset);
                IndexedWord dep = (IndexedWord)newWords.get(edge.getDependent().index() + vertexOffset);
                if (gov == null || dep == null) {
                    throw new AssertionError((Object)"Counting problem (or broken edge)");
                }
                newGraph.addEdge(gov, dep, edge.getRelation(), edge.getWeight());
            }
            for (IndexedWord root : graph.getRoots()) {
                newRoots.add((IndexedWord)newWords.get(root.index() + vertexOffset));
            }
            vertexOffset += lengths.get(i).intValue();
        }
        newGraph.setRoots(newRoots);
        return newGraph;
    }
}

