/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.semgraph;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.LabeledWord;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.semgraph.ISemanticGraphEdgeEql;
import edu.stanford.nlp.trees.semgraph.IndexedWordUnaryPred;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MapList;
import edu.stanford.nlp.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgrapht.Graph;
import org.jgrapht.ext.JGraphModelAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticGraphUtils {
    public static final String WILDCARD_VERTICE_TOKEN = "WILDCARD";
    public static final IndexedWord WILDCARD_VERTICE = new IndexedWord();
    public static final String SHARED_NODE_ANON_PREFIX = "A";
    public static final String BLANKET_NODE_ANON_PREFIX = "B";
    private static final int DISPLAY_WIDTH = 1100;
    private static final int DISPLAY_HEIGHT = 800;
    private static final int NODE_STEP_X = 100;
    private static final int NODE_STEP_Y = 100;
    private static final int START_X = 550;
    private static final int START_Y = 10;

    private SemanticGraphUtils() {
    }

    public static SemanticGraph makeGraphFromNodes(Collection<IndexedWord> nodes, SemanticGraph srcGraph) {
        if (nodes.size() == 1) {
            SemanticGraph retSg = new SemanticGraph();
            for (IndexedWord node : nodes) {
                retSg.addVertex(node);
            }
            return retSg;
        }
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<SemanticGraphEdge> edges = new ArrayList<SemanticGraphEdge>();
        for (IndexedWord nodeG : nodes) {
            for (IndexedWord nodeD : nodes) {
                SemanticGraphEdge edge = (SemanticGraphEdge)srcGraph.getEdge(nodeG, nodeD);
                if (edge == null) continue;
                edges.add(edge);
            }
        }
        return SemanticGraphFactory.makeFromEdges(edges);
    }

    public static IndexedWord findMatchingNode(IndexedWord node, SemanticGraph sg) {
        for (IndexedWord tgt : sg.vertexList()) {
            if (tgt.index() != node.index() || tgt.sentIndex() != node.sentIndex() || !tgt.word().equals(node.word())) continue;
            return tgt;
        }
        return null;
    }

    public static Set<SemanticGraphEdge> getSubTreeEdges(IndexedWord vertice, SemanticGraph sg, SemanticGraphEdge excludedEdge) {
        HashSet<SemanticGraphEdge> tabu = new HashSet<SemanticGraphEdge>();
        tabu.add(excludedEdge);
        SemanticGraphUtils.getSubTreeEdgesHelper(vertice, sg, tabu);
        tabu.remove(excludedEdge);
        return tabu;
    }

    public static void getSubTreeEdgesHelper(IndexedWord vertice, SemanticGraph sg, Set<SemanticGraphEdge> tabuEdges) {
        ArrayList outgoingEdges = new ArrayList(sg.outgoingEdgesOf(vertice));
        for (SemanticGraphEdge edge : outgoingEdges) {
            if (tabuEdges.contains(edge)) continue;
            IndexedWord dep = edge.getDependent();
            tabuEdges.add(edge);
            SemanticGraphUtils.getSubTreeEdgesHelper(dep, sg, tabuEdges);
        }
    }

    public static Collection<IndexedWord> getVerticesFromEdgeSet(Iterable<SemanticGraphEdge> edges) {
        ArrayList<IndexedWord> retSet = new ArrayList<IndexedWord>();
        for (SemanticGraphEdge edge : edges) {
            retSet.add(edge.getGovernor());
            retSet.add(edge.getDependent());
        }
        return retSet;
    }

    public static Collection<SemanticGraphEdge> getEdgesSpannedByVertices(Collection<IndexedWord> nodes, SemanticGraph sg) {
        HashSet<SemanticGraphEdge> ret = new HashSet<SemanticGraphEdge>();
        for (IndexedWord n1 : nodes) {
            for (IndexedWord n2 : nodes) {
                SemanticGraphEdge edge;
                if (n1 == n2 || (edge = (SemanticGraphEdge)sg.getEdge(n1, n2)) == null) continue;
                ret.add(edge);
            }
        }
        return ret;
    }

    public static List<IndexedWord> getChildrenWithRelnPrefix(SemanticGraph graph, IndexedWord vertex, String relnPrefix) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!graph.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> childList = new ArrayList<IndexedWord>();
        Set edges = graph.outgoingEdgesOf(vertex);
        for (SemanticGraphEdge edge : edges) {
            if (!edge.getRelation().toString().startsWith(relnPrefix)) continue;
            childList.add((IndexedWord)edge.getTarget());
        }
        return childList;
    }

    public static List<IndexedWord> getChildrenWithRelnPrefix(SemanticGraph graph, IndexedWord vertex, Collection<String> relnPrefixes) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!graph.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> childList = new ArrayList<IndexedWord>();
        Set edges = graph.outgoingEdgesOf(vertex);
        block0: for (SemanticGraphEdge edge : edges) {
            String edgeString = edge.getRelation().toString();
            for (String relnPrefix : relnPrefixes) {
                if (!edgeString.startsWith(relnPrefix)) continue;
                childList.add((IndexedWord)edge.getTarget());
                continue block0;
            }
        }
        return childList;
    }

    public static List<IndexedWord> getChildrenWithPrepC(SemanticGraph sg, IndexedWord vertex) {
        ArrayList<IndexedWord> ret = new ArrayList<IndexedWord>();
        for (SemanticGraphEdge edge : sg.outgoingEdgesOf(vertex)) {
            if (!edge.getRelation().toString().startsWith("prep")) continue;
            ret.add(edge.getDependent());
        }
        return ret;
    }

    public static List<SemanticGraphEdge> incomingEdgesWithReln(IndexedWord node, SemanticGraph sg, GrammaticalRelation reln) {
        return SemanticGraphUtils.edgesWithReln(sg.incomingEdgesOf(node), reln);
    }

    public static List<SemanticGraphEdge> outgoingEdgesWithReln(IndexedWord node, SemanticGraph sg, GrammaticalRelation reln) {
        return SemanticGraphUtils.edgesWithReln(sg.outgoingEdgesOf(node), reln);
    }

    public static List<SemanticGraphEdge> edgesWithReln(Collection<SemanticGraphEdge> edges, GrammaticalRelation reln) {
        ArrayList<SemanticGraphEdge> found = Generics.newArrayList();
        for (SemanticGraphEdge edge : edges) {
            GrammaticalRelation tgtReln = edge.getRelation();
            if (!tgtReln.equals(reln)) continue;
            found.add(edge);
        }
        return found;
    }

    public static List<SemanticGraphEdge> findAllRelnsWithPrefix(SemanticGraph sg, String prefix) {
        ArrayList<SemanticGraphEdge> relns = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : sg.edgeList()) {
            GrammaticalRelation edgeRelation = edge.getRelation();
            if (!edgeRelation.toString().startsWith(prefix)) continue;
            relns.add(edge);
        }
        return relns;
    }

    public static Set<IndexedWord> tabuDescendants(SemanticGraph sg, IndexedWord vertex, Collection<IndexedWord> tabu) {
        if (!sg.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        HashSet<IndexedWord> descendantSet = new HashSet<IndexedWord>();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, tabu, null, null);
        return descendantSet;
    }

    public static Set<IndexedWord> tabuDescendants(SemanticGraph sg, IndexedWord vertex, Collection<IndexedWord> tabu, Collection<GrammaticalRelation> tabuRelns) {
        if (!sg.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        HashSet<IndexedWord> descendantSet = new HashSet<IndexedWord>();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, tabu, tabuRelns, null);
        return descendantSet;
    }

    public static Set<IndexedWord> descendantsTabuRelns(SemanticGraph sg, IndexedWord vertex, Collection<GrammaticalRelation> tabuRelns) {
        if (!sg.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        HashSet<IndexedWord> descendantSet = new HashSet<IndexedWord>();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, new HashSet<IndexedWord>(), tabuRelns, null);
        return descendantSet;
    }

    public static Set<IndexedWord> descendantsTabuTestAndRelns(SemanticGraph sg, IndexedWord vertex, Collection<GrammaticalRelation> tabuRelns, IndexedWordUnaryPred tabuTest) {
        if (!sg.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        HashSet<IndexedWord> descendantSet = new HashSet<IndexedWord>();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, new HashSet<IndexedWord>(), tabuRelns, tabuTest);
        return descendantSet;
    }

    public static Set<IndexedWord> descendantsTabuTestAndRelns(SemanticGraph sg, IndexedWord vertex, Collection<IndexedWord> tabuNodes, Collection<GrammaticalRelation> tabuRelns, IndexedWordUnaryPred tabuTest) {
        if (!sg.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        HashSet<IndexedWord> descendantSet = new HashSet<IndexedWord>();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, tabuNodes, tabuRelns, tabuTest);
        return descendantSet;
    }

    private static void tabuDescendantsHelper(SemanticGraph sg, IndexedWord curr, Set<IndexedWord> descendantSet, Collection<IndexedWord> tabu, Collection<GrammaticalRelation> relnsToAvoid, IndexedWordUnaryPred tabuTest) {
        if (tabu.contains(curr)) {
            return;
        }
        if (descendantSet.contains(curr)) {
            return;
        }
        descendantSet.add(curr);
        for (IndexedWord child : sg.getChildList(curr)) {
            SemanticGraphEdge edge = (SemanticGraphEdge)sg.getEdge(curr, child);
            if (relnsToAvoid != null && relnsToAvoid.contains(edge.getRelation()) || tabuTest != null && tabuTest.test(edge.getDependent(), sg)) continue;
            SemanticGraphUtils.tabuDescendantsHelper(sg, child, descendantSet, tabu, relnsToAvoid, tabuTest);
        }
    }

    public static IndexedWord leftMostChildVertice(IndexedWord startNode, SemanticGraph sg) {
        TreeSet<IndexedWord> vertices = new TreeSet<IndexedWord>();
        for (IndexedWord vertex : sg.descendants(startNode)) {
            vertices.add(vertex);
        }
        return (IndexedWord)vertices.first();
    }

    public static Collection<IndexedWord> getDependencyBlanket(SemanticGraph sg, Collection<IndexedWord> assertedNodes) {
        HashSet<IndexedWord> retSet = new HashSet<IndexedWord>();
        for (IndexedWord curr : sg.vertexList()) {
            if (assertedNodes.contains(curr) || retSet.contains(curr)) continue;
            for (IndexedWord assertedNode : assertedNodes) {
                if (!sg.containsEdge(assertedNode, curr) && !sg.containsEdge(curr, assertedNode)) continue;
                retSet.add(curr);
            }
        }
        return retSet;
    }

    public static SemanticGraph resetVerticeOrdering(SemanticGraph sg) {
        SemanticGraph nsg = new SemanticGraph();
        ArrayList<IndexedWord> vertices = new ArrayList<IndexedWord>(sg.vertexList(true));
        ArrayList edges = new ArrayList(sg.edgeSet());
        int index = 1;
        HashMap<IndexedWord, IndexedWord> oldToNewVertices = new HashMap<IndexedWord, IndexedWord>();
        ArrayList<IndexedWord> newVertices = new ArrayList<IndexedWord>();
        for (IndexedWord vertex : vertices) {
            IndexedWord newVertex = new IndexedWord(vertex);
            newVertex.setIndex(index++);
            oldToNewVertices.put(vertex, newVertex);
            newVertices.add(newVertex);
        }
        for (IndexedWord nv : newVertices) {
            nsg.addVertex(nv);
        }
        ArrayList<IndexedWord> newRoots = new ArrayList<IndexedWord>();
        for (IndexedWord or : sg.getRoots()) {
            newRoots.add((IndexedWord)oldToNewVertices.get(or));
        }
        nsg.setRoots(newRoots);
        for (SemanticGraphEdge edge : edges) {
            IndexedWord newGov = (IndexedWord)oldToNewVertices.get(edge.getGovernor());
            IndexedWord newDep = (IndexedWord)oldToNewVertices.get(edge.getDependent());
            SemanticGraphEdge newEdge = new SemanticGraphEdge(newGov, newDep, edge.getRelation(), edge.getWeight());
            nsg.addEdge(newGov, newDep, newEdge);
        }
        return nsg;
    }

    public static void enRepairEdges(SemanticGraph sg, boolean verbose) {
        ArrayList<SemanticGraphEdge> edges = Generics.newArrayList(sg.edgeSet());
        for (SemanticGraphEdge edge : edges) {
            if (!edge.getRelation().isFromString()) continue;
            GrammaticalRelation newReln = EnglishGrammaticalRelations.valueOf(edge.getRelation().toString());
            if (newReln != null) {
                IndexedWord gov = edge.getGovernor();
                IndexedWord dep = edge.getDependent();
                double weight2 = edge.getWeight();
                sg.removeEdge(edge);
                sg.addEdge(gov, dep, newReln, weight2);
                continue;
            }
            if (!verbose) continue;
            System.err.println("Warning, could not find matching GrammaticalRelation for reln=" + edge.getRelation());
        }
    }

    public static void enRepairEdges(SemanticGraph sg) {
        SemanticGraphUtils.enRepairEdges(sg, false);
    }

    public static void killNonRooted(SemanticGraph sg) {
        ArrayList nodes = new ArrayList(sg.vertexSet());
        HashSet<IndexedWord> guaranteed = new HashSet<IndexedWord>();
        for (IndexedWord root : sg.getRoots()) {
            guaranteed.add(root);
            guaranteed.addAll(sg.descendants(root));
        }
        for (IndexedWord node : nodes) {
            if (guaranteed.contains(node)) continue;
            sg.removeVertex(node);
        }
    }

    public static void replaceNode(IndexedWord newNode, IndexedWord oldNode, SemanticGraph sg) {
        ArrayList govEdges = new ArrayList(sg.outgoingEdgesOf(oldNode));
        ArrayList depEdges = new ArrayList(sg.incomingEdgesOf(oldNode));
        boolean oldNodeRemoved = sg.removeVertex(oldNode);
        if (oldNodeRemoved) {
            if (!sg.containsVertex(newNode)) {
                sg.addVertex(newNode);
            }
            for (SemanticGraphEdge govEdge : govEdges) {
                sg.removeEdge(govEdge);
                sg.addEdge(newNode, govEdge.getDependent(), govEdge.getRelation(), govEdge.getWeight());
            }
            for (SemanticGraphEdge depEdge : depEdges) {
                sg.removeEdge(depEdge);
                sg.addEdge(depEdge.getGovernor(), newNode, depEdge.getRelation(), depEdge.getWeight());
            }
        } else {
            System.err.println("SemanticGraphUtils.replaceNode: previous node does not exist");
        }
        sg.vertexList(true);
    }

    public static Map<IndexedWord, IndexedWord> anonymyizeNodes(Iterable<IndexedWord> verts, String prefix) {
        HashMap<IndexedWord, IndexedWord> retMap = new HashMap<IndexedWord, IndexedWord>();
        int index = 1;
        for (IndexedWord orig : verts) {
            IndexedWord genericVert = new IndexedWord(orig);
            genericVert.set(CoreAnnotations.LemmaAnnotation.class, "");
            String genericValue = prefix + index;
            genericVert.setValue(genericValue);
            genericVert.setWord(genericValue);
            genericVert.setCurrent(genericValue);
            ++index;
            retMap.put(orig, genericVert);
        }
        return retMap;
    }

    public static Map<IndexedWord, IndexedWord> makeGenericVertices(Iterable<IndexedWord> verts) {
        return SemanticGraphUtils.anonymyizeNodes(verts, SHARED_NODE_ANON_PREFIX);
    }

    public static Map<IndexedWord, IndexedWord> makeBlanketVertices(Iterable<IndexedWord> verts) {
        return SemanticGraphUtils.anonymyizeNodes(verts, BLANKET_NODE_ANON_PREFIX);
    }

    public static List<SemanticGraphEdge> makeReplacedEdges(Iterable<SemanticGraphEdge> edges, Map<IndexedWord, IndexedWord> vertReplacementMap, boolean useGenericReplacement) {
        ArrayList<SemanticGraphEdge> retList = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : edges) {
            IndexedWord gov = edge.getGovernor();
            IndexedWord dep = edge.getDependent();
            IndexedWord newGov = vertReplacementMap.get(gov);
            IndexedWord newDep = vertReplacementMap.get(dep);
            if (useGenericReplacement) {
                if (newGov == null) {
                    newGov = new IndexedWord(gov);
                    newGov.set(CoreAnnotations.TextAnnotation.class, WILDCARD_VERTICE_TOKEN);
                    newGov.set(CoreAnnotations.CurrentAnnotation.class, WILDCARD_VERTICE_TOKEN);
                    newGov.set(CoreAnnotations.LemmaAnnotation.class, WILDCARD_VERTICE_TOKEN);
                }
                if (newDep == null) {
                    newDep = new IndexedWord(dep);
                    newDep.set(CoreAnnotations.TextAnnotation.class, WILDCARD_VERTICE_TOKEN);
                    newDep.set(CoreAnnotations.CurrentAnnotation.class, WILDCARD_VERTICE_TOKEN);
                    newDep.set(CoreAnnotations.LemmaAnnotation.class, WILDCARD_VERTICE_TOKEN);
                }
            } else {
                if (newGov == null) {
                    newGov = edge.getGovernor();
                }
                if (newDep == null) {
                    newDep = edge.getDependent();
                }
            }
            SemanticGraphEdge newEdge = new SemanticGraphEdge(newGov, newDep, edge.getRelation(), edge.getWeight());
            retList.add(newEdge);
        }
        return retList;
    }

    public static Set<SemanticGraphEdge> allEdgesInSet(Iterable<IndexedWord> vertices, SemanticGraph sg) {
        HashSet<SemanticGraphEdge> edges = new HashSet<SemanticGraphEdge>();
        for (IndexedWord v1 : vertices) {
            for (SemanticGraphEdge edge : sg.outgoingEdgesOf(v1)) {
                edges.add(edge);
            }
            for (SemanticGraphEdge edge : sg.incomingEdgesOf(v1)) {
                edges.add(edge);
            }
        }
        return edges;
    }

    public static EdgeDiffResult diffEdges(Collection<SemanticGraphEdge> edges1, Collection<SemanticGraphEdge> edges2, SemanticGraph sg1, SemanticGraph sg2, ISemanticGraphEdgeEql compareObj) {
        HashSet<SemanticGraphEdge> remainingEdges1 = new HashSet<SemanticGraphEdge>();
        HashSet<SemanticGraphEdge> remainingEdges2 = new HashSet<SemanticGraphEdge>();
        HashSet<SemanticGraphEdge> sameEdges = new HashSet<SemanticGraphEdge>();
        ArrayList<SemanticGraphEdge> edges2Cache = new ArrayList<SemanticGraphEdge>(edges2);
        block0: for (SemanticGraphEdge edge1 : edges1) {
            for (SemanticGraphEdge edge2 : edges2Cache) {
                if (!compareObj.equals(edge1, edge2, sg1, sg2)) continue;
                sameEdges.add(edge1);
                edges2Cache.remove(edge2);
                continue block0;
            }
            remainingEdges1.add(edge1);
        }
        ArrayList<SemanticGraphEdge> edges1Cache = new ArrayList<SemanticGraphEdge>(edges1);
        block2: for (SemanticGraphEdge edge2 : edges2) {
            for (SemanticGraphEdge edge1 : edges1) {
                if (!compareObj.equals(edge1, edge2, sg1, sg2)) continue;
                edges1Cache.remove(edge1);
                continue block2;
            }
            remainingEdges2.add(edge2);
        }
        return new EdgeDiffResult(sameEdges, remainingEdges1, remainingEdges2);
    }

    public static String printEdges(Iterable<SemanticGraphEdge> edges) {
        StringWriter buf = new StringWriter();
        for (SemanticGraphEdge edge : edges) {
            buf.append("\t");
            buf.append(edge.getRelation().toString());
            buf.append("(");
            buf.append(edge.getGovernor().toString());
            buf.append(", ");
            buf.append(edge.getDependent().toString());
            buf.append(")\n");
        }
        return buf.toString();
    }

    public static String printVertices(SemanticGraph sg) {
        return SemanticGraphUtils.printVertices(sg, new PrintVerticeParams());
    }

    public static String printVertices(SemanticGraph sg, PrintVerticeParams params) {
        StringWriter buf = new StringWriter();
        int count = 0;
        for (IndexedWord word : sg.vertexList()) {
            if (++count % params.wrapAt == 0) {
                buf.write("\n\t");
            }
            if (params.showIndex) {
                buf.write(String.valueOf(word.index()));
                buf.write(":");
            }
            if (params.showSentIndex) {
                buf.write("s");
                buf.write(String.valueOf(word.sentIndex()));
                buf.write("/");
            }
            if (params.showPOS) {
                buf.write(word.tag());
                buf.write("/");
            }
            if (params.showWord) {
                buf.write(word.word());
            }
            buf.write(" ");
        }
        return buf.toString();
    }

    public static String semgrexFromGraph(SemanticGraph sg, boolean matchTag, boolean matchWord, Map<IndexedWord, String> nodeNameMap) throws Exception {
        return SemanticGraphUtils.semgrexFromGraph(sg, null, matchTag, matchWord, nodeNameMap);
    }

    public static String semgrexFromGraph(SemanticGraph sg, Collection<IndexedWord> wildcardNodes, boolean useTag, boolean useWord, Map<IndexedWord, String> nodeNameMap) throws Exception {
        IndexedWord patternRoot = sg.getFirstRoot();
        StringWriter buf = new StringWriter();
        HashSet<IndexedWord> tabu = new HashSet<IndexedWord>();
        HashSet<SemanticGraphEdge> seenEdges = new HashSet<SemanticGraphEdge>();
        buf.append(SemanticGraphUtils.semgrexFromGraphHelper(patternRoot, sg, tabu, seenEdges, true, true, wildcardNodes, useTag, useWord, nodeNameMap));
        String patternString = buf.toString();
        return patternString;
    }

    public static String semgrexFromGraph(Iterable<SemanticGraphEdge> edges, boolean matchTag, boolean matchWord, Map<IndexedWord, String> nodeNameMap) throws Exception {
        SemanticGraph sg = SemanticGraphFactory.makeFromEdges(edges);
        return SemanticGraphUtils.semgrexFromGraph(sg, matchTag, matchWord, nodeNameMap);
    }

    protected static String semgrexFromGraphHelper(IndexedWord vertice, SemanticGraph sg, Set<IndexedWord> tabu, Set<SemanticGraphEdge> seenEdges, boolean useWordAsLabel, boolean nameEdges, Collection<IndexedWord> wildcardNodes, boolean useTag, boolean useWord, Map<IndexedWord, String> nodeNameMap) {
        StringWriter buf = new StringWriter();
        Set edges = sg.outgoingEdgesOf(vertice);
        if (wildcardNodes != null && wildcardNodes.contains(vertice)) {
            buf.append("{}");
        } else {
            buf.append("{");
            if (useTag) {
                buf.append("tag:");
                buf.append(vertice.tag());
                if (useWord) {
                    buf.append(";");
                }
            }
            if (useWord) {
                buf.append("word:");
                buf.append(vertice.word());
            }
            buf.append("}");
        }
        if (nodeNameMap != null) {
            buf.append("=");
            buf.append(nodeNameMap.get(vertice));
            buf.append(" ");
        } else if (useWordAsLabel) {
            buf.append("=");
            buf.append(SemanticGraphUtils.sanitizeForSemgrexName(vertice.word()));
            buf.append(" ");
        }
        tabu.add(vertice);
        for (SemanticGraphEdge edge : edges) {
            seenEdges.add(edge);
            IndexedWord tgtVert = edge.getDependent();
            boolean applyParens = sg.outDegreeOf(tgtVert) > 0 && !tabu.contains(tgtVert);
            buf.append(" >");
            buf.append(edge.getRelation().toString());
            if (nameEdges) {
                buf.append("=E");
                buf.write(String.valueOf(seenEdges.size()));
            }
            buf.append(" ");
            if (applyParens) {
                buf.append("(");
            }
            if (tabu.contains(tgtVert)) {
                buf.append("{tag:");
                buf.append(tgtVert.tag());
                buf.append("}");
                if (!useWordAsLabel) continue;
                buf.append("=");
                buf.append(tgtVert.word());
                buf.append(" ");
                continue;
            }
            buf.append(SemanticGraphUtils.semgrexFromGraphHelper(tgtVert, sg, tabu, seenEdges, useWordAsLabel, nameEdges, wildcardNodes, useTag, useWord, nodeNameMap));
            if (!applyParens) continue;
            buf.append(")");
        }
        return buf.toString();
    }

    public static String sanitizeForSemgrexName(String text) {
        text = text.replaceAll("\\.", "_DOT_");
        text = text.replaceAll("\\,", "_COMMA_");
        text = text.replaceAll("\\\\", "_BSLASH_");
        text = text.replaceAll("\\/", "_BSLASH_");
        text = text.replaceAll("\\?", "_QUES_");
        text = text.replaceAll("\\!", "_BANG_");
        text = text.replaceAll("\\$", "_DOL_");
        text = text.replaceAll("\\!", "_BANG_");
        text = text.replaceAll("\\&", "_AMP_");
        text = text.replaceAll("\\:", "_COL_");
        text = text.replaceAll("\\;", "_SCOL_");
        text = text.replaceAll("\\#", "_PND_");
        text = text.replaceAll("\\@", "_AND_");
        text = text.replaceAll("\\%", "_PER_");
        text = text.replaceAll("\\(", "_LRB_");
        text = text.replaceAll("\\)", "_RRB_");
        return text;
    }

    public static SemanticGraph lemmatize(SemanticGraph sg) {
        SemanticGraph newGraph = new SemanticGraph(sg);
        ArrayList<IndexedWord> prevRoots = new ArrayList<IndexedWord>(newGraph.getRoots());
        ArrayList<IndexedWord> newRoots = new ArrayList<IndexedWord>();
        for (IndexedWord node : newGraph.vertexList()) {
            IndexedWord newWord = new IndexedWord(node);
            String lemma = Morphology.stemStatic(node.word(), node.tag()).word();
            newWord.setLemma(lemma);
            SemanticGraphUtils.replaceNode(newWord, node, newGraph);
            if (!prevRoots.contains(node)) continue;
            newRoots.add(newWord);
        }
        newGraph.setRoots(newRoots);
        return newGraph;
    }

    public static SemanticGraph setSentIndex(SemanticGraph sg, int newSentIndex) {
        SemanticGraph newGraph = new SemanticGraph(sg);
        ArrayList<IndexedWord> prevRoots = new ArrayList<IndexedWord>(newGraph.getRoots());
        ArrayList<IndexedWord> newRoots = new ArrayList<IndexedWord>();
        for (IndexedWord node : newGraph.vertexList()) {
            IndexedWord newWord = new IndexedWord(node);
            newWord.setSentIndex(newSentIndex);
            SemanticGraphUtils.replaceNode(newWord, node, newGraph);
            if (!prevRoots.contains(node)) continue;
            newRoots.add(newWord);
        }
        newGraph.setRoots(newRoots);
        return newGraph;
    }

    public static Collection<SemanticGraph> removeDuplicates(Collection<SemanticGraph> graphs) {
        HashMap<String, SemanticGraph> map = new HashMap<String, SemanticGraph>();
        for (SemanticGraph sg : graphs) {
            String keyVal = sg.toString().intern();
            map.put(keyVal, sg);
        }
        return map.values();
    }

    public static Collection<SemanticGraph> removeDuplicates(Collection<SemanticGraph> graphs, Collection<SemanticGraph> tabuGraphs) {
        HashMap<String, SemanticGraph> tabuMap = new HashMap<String, SemanticGraph>();
        for (SemanticGraph tabuSg : tabuGraphs) {
            String keyVal = tabuSg.toString().intern();
            tabuMap.put(keyVal, tabuSg);
        }
        HashMap<String, SemanticGraph> map = new HashMap<String, SemanticGraph>();
        for (SemanticGraph sg : graphs) {
            String keyVal = sg.toString().intern();
            if (tabuMap.containsKey(keyVal)) continue;
            map.put(keyVal, sg);
        }
        return map.values();
    }

    public static Collection<SemanticGraph> removeDuplicates(Collection<SemanticGraph> graphs, SemanticGraph tabuGraph) {
        HashSet<SemanticGraph> tabuSet = new HashSet<SemanticGraph>();
        tabuSet.add(tabuGraph);
        return SemanticGraphUtils.removeDuplicates(graphs, tabuSet);
    }

    public static Map<PositionedTree, IndexedWord> mapTreeToSg(Tree tree, SemanticGraph sg) {
        MapList<String, TreeNodeProxy> lexToTreeNode = new MapList<String, TreeNodeProxy>();
        MapList<String, IndexedWordProxy> lexToSemNode = new MapList<String, IndexedWordProxy>();
        for (Tree child : tree.getLeaves()) {
            List<TreeNodeProxy> leafProxies = TreeNodeProxy.create(child, tree);
            for (TreeNodeProxy proxy : leafProxies) {
                lexToTreeNode.add(proxy.lex, proxy);
            }
        }
        HashMap<IndexedWord, Integer> depthMap = new HashMap<IndexedWord, Integer>();
        for (IndexedWord node : sg.vertexList()) {
            List<IndexedWord> path = sg.getPathToRoot(node);
            if (path != null) {
                depthMap.put(node, path.size());
            } else {
                depthMap.put(node, 99999);
            }
            List<IndexedWordProxy> nodeProxies = IndexedWordProxy.create(node);
            for (IndexedWordProxy proxy : nodeProxies) {
                lexToSemNode.add(proxy.lex, proxy);
            }
        }
        HashMap<PositionedTree, IndexedWord> map = new HashMap<PositionedTree, IndexedWord>();
        for (String lex : lexToTreeNode.keySet()) {
            for (int i = 0; i < lexToTreeNode.size(lex) && i < lexToSemNode.size(lex); ++i) {
                map.put(new PositionedTree(((TreeNodeProxy)lexToTreeNode.get(lex, (int)i)).treeNode, tree), ((IndexedWordProxy)lexToSemNode.get(lex, (int)i)).node);
            }
        }
        for (Tree nonTerm : tree) {
            if (nonTerm.isLeaf()) continue;
            IndexedWord bestNode = null;
            int bestScore = 99999;
            for (Tree curr : nonTerm) {
                int currScore;
                IndexedWord equivNode = (IndexedWord)map.get(new PositionedTree(curr, tree));
                if (equivNode == null || !depthMap.containsKey(equivNode) || (currScore = ((Integer)depthMap.get(equivNode)).intValue()) >= bestScore) continue;
                bestScore = currScore;
                bestNode = equivNode;
            }
            if (bestNode == null) continue;
            map.put(new PositionedTree(nonTerm, tree), bestNode);
        }
        return map;
    }

    public static JFrame render(GrammaticalStructure gs, String frameLabel) {
        SemanticGraph sg = SemanticGraphFactory.makeFromTree(gs, true, false, true, true, false, true, null, "", 1);
        return SemanticGraphUtils.render(sg, frameLabel);
    }

    public static JFrame render(SemanticGraph sg, String frameLabel) {
        boolean formerState = SemanticGraphEdge.printOnlyRelation;
        SemanticGraphEdge.printOnlyRelation = true;
        JGraphModelAdapter modelAdapter = new JGraphModelAdapter((Graph)sg);
        JGraph jgraph = new JGraph((GraphModel)modelAdapter);
        JFrame graphFrame = new JFrame(frameLabel);
        graphFrame.getContentPane().add((Component)new JLabel("Semantic Graph "), "Center");
        jgraph.setSize(new Dimension(1100, 800));
        graphFrame.setSize(new Dimension(1100, 800));
        jgraph.setBackground(Color.WHITE);
        graphFrame.add((Component)jgraph);
        SemanticGraphUtils.layoutJGraphNodes(sg, (JGraphModelAdapter<IndexedWord, SemanticGraphEdge>)modelAdapter);
        graphFrame.pack();
        graphFrame.setVisible(true);
        SemanticGraphEdge.printOnlyRelation = formerState;
        return graphFrame;
    }

    private static void layoutJGraphNodes(SemanticGraph sg, JGraphModelAdapter<IndexedWord, SemanticGraphEdge> modelAdapter) {
        HashSet<IndexedWord> used = new HashSet<IndexedWord>();
        int xOffset = 550;
        int yOffset = 10;
        for (IndexedWord root : sg.getRoots()) {
            SemanticGraphUtils.placeNode(root, xOffset, yOffset, used, sg, modelAdapter);
            yOffset += 100;
            xOffset += 100;
        }
    }

    private static void placeNode(IndexedWord currNode, int xOffset, int yOffset, Set<IndexedWord> used, SemanticGraph sg, JGraphModelAdapter<IndexedWord, SemanticGraphEdge> modelAdapter) {
        if (!used.contains(currNode)) {
            SemanticGraphUtils.placeJGraphNode(currNode, xOffset, yOffset, modelAdapter);
            used.add(currNode);
        }
        ArrayList edges = new ArrayList(sg.outgoingEdgesOf(currNode));
        Collections.sort(edges);
        int startX = -1;
        int effectiveNodeStepX = 200;
        while (effectiveNodeStepX > 16 && startX <= 0) {
            startX = xOffset - (int)((double)edges.size() / 2.0 * (double)(effectiveNodeStepX /= 2));
        }
        for (SemanticGraphEdge edge : edges) {
            IndexedWord target = (IndexedWord)edge.getTarget();
            if (used.contains(target)) continue;
            SemanticGraphUtils.placeNode(target, startX, yOffset + 100, used, sg, modelAdapter);
            startX += effectiveNodeStepX;
        }
    }

    public static void placeJGraphNode(IndexedWord node, int xPos, int yPos, JGraphModelAdapter<IndexedWord, SemanticGraphEdge> modelAdapter) {
        DefaultGraphCell jCell = modelAdapter.getVertexCell((Object)node);
        AttributeMap cellAttr = jCell.getAttributes();
        Rectangle2D cellBounds = GraphConstants.getBounds((Map)cellAttr);
        GraphConstants.setBounds((Map)cellAttr, (Rectangle2D)new Rectangle2D.Double(xPos, yPos, cellBounds.getWidth(), cellBounds.getHeight()));
        HashMap<DefaultGraphCell, AttributeMap> newCellAttr = new HashMap<DefaultGraphCell, AttributeMap>();
        newCellAttr.put(jCell, cellAttr);
        modelAdapter.edit(newCellAttr, null, null, null);
    }

    public static void toDOT(SemanticGraph sg, File tgt) {
        StringWriter buf = new StringWriter();
        buf.write("digraph \"tree\" {order=out; node [shape=plaintext];\n");
        HashMap<IndexedWord, Integer> lookup = new HashMap<IndexedWord, Integer>();
        int uid = 1;
        for (IndexedWord vert : sg.vertexList()) {
            lookup.put(vert, uid);
            buf.write("n" + uid + " [label=\"" + vert.toString() + "\"];\n");
            ++uid;
        }
        for (SemanticGraphEdge edge : sg.edgeList()) {
            String gov = "n" + lookup.get(edge.getGovernor());
            String dep = "n" + lookup.get(edge.getDependent());
            buf.write(gov + " -> " + dep + " [label=\"" + edge.toString() + "\" fontsize=10 fontname=\"Times-Italic\"];\n");
        }
        buf.write("}");
        StringUtils.printToFile(tgt, buf.toString());
    }

    static {
        WILDCARD_VERTICE.setWord("*");
        WILDCARD_VERTICE.setValue("*");
        WILDCARD_VERTICE.setCurrent("*");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IndexedWordProxy {
        IndexedWord node;
        String lex;

        public String toString() {
            return this.lex + " -> " + this.node.word() + ":" + this.node.sentIndex() + "." + this.node.index();
        }

        private IndexedWordProxy(IndexedWord node, String lex) {
            this.node = node;
            this.lex = lex;
        }

        public static List<IndexedWordProxy> create(IndexedWord node) {
            ArrayList<IndexedWordProxy> ret = new ArrayList<IndexedWordProxy>();
            if (node.current().length() > 0) {
                for (String token : node.current().split(" ")) {
                    ret.add(new IndexedWordProxy(node, token));
                }
            } else {
                ret.add(new IndexedWordProxy(node, node.word()));
            }
            return ret;
        }
    }

    public static class PositionedTree {
        Tree tree;
        Tree root;
        int nodeNumber;

        public String toString() {
            return this.tree + "." + this.nodeNumber;
        }

        public PositionedTree(Tree tree, Tree root) {
            this.tree = tree;
            this.root = root;
            this.nodeNumber = tree.nodeNumber(root);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PositionedTree) {
                PositionedTree tgt = (PositionedTree)obj;
                return this.tree.equals(tgt.tree) && this.root.equals(tgt.root) && tgt.nodeNumber == this.nodeNumber;
            }
            return false;
        }

        public int hashCode() {
            int hc = this.tree.hashCode() ^ this.root.hashCode() << 8;
            return hc ^= 2 ^ this.nodeNumber;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeNodeProxy {
        Tree treeNode;
        String lex;
        Tree root;

        public String toString() {
            return this.lex + " -> " + this.treeNode.toString() + ", #=" + this.treeNode.nodeNumber(this.root);
        }

        private TreeNodeProxy(Tree intree, String lex, Tree root) {
            this.treeNode = intree;
            this.lex = lex;
            this.root = root;
        }

        public static List<TreeNodeProxy> create(Tree intree, Tree root) {
            ArrayList<TreeNodeProxy> ret = new ArrayList<TreeNodeProxy>();
            if (intree.isLeaf()) {
                ret.add(new TreeNodeProxy(intree, intree.label().value(), root));
            } else {
                for (LabeledWord lword : intree.labeledYield()) {
                    ret.add(new TreeNodeProxy(intree, lword.word(), root));
                }
            }
            return ret;
        }
    }

    public static class PrintVerticeParams {
        public boolean showWord = true;
        public boolean showIndex = true;
        public boolean showSentIndex = false;
        public boolean showPOS = false;
        public int wrapAt = 8;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EdgeDiffResult {
        Set<SemanticGraphEdge> sameEdges;
        Set<SemanticGraphEdge> remaining1;
        Set<SemanticGraphEdge> remaining2;

        public EdgeDiffResult(Set<SemanticGraphEdge> sameEdges, Set<SemanticGraphEdge> remaining1, Set<SemanticGraphEdge> remaining2) {
            this.sameEdges = sameEdges;
            this.remaining1 = remaining1;
            this.remaining2 = remaining2;
        }

        public Set<SemanticGraphEdge> getRemaining1() {
            return this.remaining1;
        }

        public Set<SemanticGraphEdge> getRemaining2() {
            return this.remaining2;
        }

        public Set<SemanticGraphEdge> getSameEdges() {
            return this.sameEdges;
        }
    }
}

