#!/usr/bin/perl

use Test::Simple tests => 16;

use Lingua::StanfordCoreNLP;

# 1:
my $pipeline = new Lingua::StanfordCoreNLP::Pipeline(1, 1);

ok(
	defined($pipeline) && ref $pipeline eq 'Lingua::StanfordCoreNLP::Pipeline',
	'new Lingua::StanfordCoreNLP::Pipeline()'
);

# 2:
my $result   = $pipeline->process('Jane looked at the IBM computer. She turned it off.');

ok(
	defined($result) && ref $result eq 'Lingua::StanfordCoreNLP::PipelineSentenceList',
	'Lingua::StanfordCoreNLP::Pipeline->process()'
);

# 3:
my @sentences = @{$result->toArray};

ok(
	@sentences == 2,
	'"ssplit" annotator'
);

# 4:
my $sentence = $sentences[0]->getSentence;

ok(
	defined $sentence,
	'Lingua::StanfordCoreNLP::PipelineSentence->getSentence'
);

# 5:
my $tokens_ref = $sentences[0]->getTokens;

ok(
	defined $tokens_ref && ref $tokens_ref eq 'Lingua::StanfordCoreNLP::PipelineTokenList',
	'Lingua::StanfordCoreNLP::PipelineSentence->getTokens'
);

# 6:
my @tokens   = @{$tokens_ref->toArray};

ok(
	@tokens == 7,
	'Lingua::StanfordCoreNLP::PipelineTokenList->toArray'
);

my $token_look = $tokens[1];
my $token_IBM  = $tokens[4];

# 7:
ok(
	$token_look->getWord   eq 'looked',
	'"tokenize" annotator'
);

# 8:
ok(
	$token_look->getLemma  eq 'look',
	'"lemma" annotator'
);

# 9:
ok(
	$token_look->getPOSTag  eq 'VBD',
	'"pos" annotator'
);

# 10:
ok(
	$token_IBM->getNERTag  eq 'ORGANIZATION',
	'"ner" annotator'
);

# 11:
my $corefs_ref   = $sentences[0]->getCoreferences;

ok(
	defined($corefs_ref) &&
	ref $corefs_ref eq 'Lingua::StanfordCoreNLP::PipelineCoreferenceList',
	'Lingua::StanfordCoreNLP::PipelineSentence->getCoreferences'
);

# 12:
my @corefs = @{$corefs_ref->toArray};

ok(
	@corefs == 2,
	'Lingua::StanfordCoreNLP::PipelineCoreferenceList->toArray'
);

# 13:
my $coref_jane = $corefs[0];

ok(
	($coref_jane->getSourceToken->getWord eq 'Jane') &&
	($coref_jane->getTargetToken->getWord eq 'She'),
	'"dcoref" annotator'
);

# 14:
my $deps_ref = $sentences[0]->getDependencies;

ok(
	defined($deps_ref) &&
	ref $deps_ref eq 'Lingua::StanfordCoreNLP::PipelineDependencyList',
	'Lingua::StanfordCoreNLP::PipelineSentence->getDependencies'
);

# 15:
my @deps =  @{$deps_ref->toArray};

ok(
	@deps == 4,
	'Lingua::StanfordCoreNLP::PipelineSentenceDependencyList->toArray'
);

# 16:
my $dep_nsubj = $deps[0];

ok(
	($dep_nsubj->getRelation eq 'nsubj') &&
	($dep_nsubj->getGovernorIndex  == 1)  &&
	($dep_nsubj->getDependentIndex == 0),
	'"parser" annotator'
);
