## Domain Registry Interface, .COOP EPP extensions
##
## Copyright (c) 2006,2008,2009 Patrick Mevzek <netdri@dotandco.com>. All rights reserved.
##
## This file is part of Net::DRI
##
## Net::DRI is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## See the LICENSE file that comes with this distribution for more details.
####################################################################################################

package Net::DRI::Protocol::EPP::Extensions::COOP;

use strict;

use base qw/Net::DRI::Protocol::EPP/;
use Net::DRI::Data::Contact::COOP;

=pod

=head1 NAME

Net::DRI::Protocol::EPP::Extensions::COOP - .COOP EPP extensions for Net::DRI

=head1 DESCRIPTION

Please see the README file for details.

=head1 SUPPORT

For now, support questions should be sent to:

E<lt>netdri@dotandco.comE<gt>

Please also see the SUPPORT file in the distribution.

=head1 SEE ALSO

E<lt>http://www.dotandco.com/services/software/Net-DRI/E<gt>

=head1 AUTHOR

Patrick Mevzek, E<lt>netdri@dotandco.comE<gt>

=head1 COPYRIGHT

Copyright (c) 2006,2008,2009 Patrick Mevzek <netdri@dotandco.com>.
All rights reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

See the LICENSE file that comes with this distribution for more details.

=cut

####################################################################################################

sub setup
{
 my ($self,$rp)=@_;
 $self->ns({ coop => ['http://www.nic.coop/contactCoopExt-1.0','contactCoopExt-1.0.xsd'] }); ## fake XSD
 $self->capabilities('contact_update','sponsor',['add','del']);
 $self->factories('contact',sub { return Net::DRI::Data::Contact::COOP->new() });
 return;
}

sub default_extensions { return qw/COOP::Contact/; }

####################################################################################################
1;
