/*
 * This file was generated automatically by xsubpp version 1.9 from the 
 * contents of OpenGL.xs. Don't edit this file, edit OpenGL.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

/*
 *  file OpenGL.xs is generated by OpenGL.xs.gen 
 */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <GL/gl.h>
#include <GL/glx.h>
#include <GL/glu.h>
#include <unistd.h>
#include <stdio.h>

Display *dpy;
XVisualInfo *vi;
Colormap cmap;
XSetWindowAttributes swa;
Window win;
GLXContext cx;

static int default_attributes[] = { GLX_RGBA, /*GLX_DOUBLEBUFFER,*/  None };
static Bool WaitForNotify(Display *d, XEvent *e, char *arg) {
    return (e->type == MapNotify) && (e->xmap.window == (Window)arg);
}


 


XS(XS_OpenGL_glpOpenWindow)
{
    dXSARGS;
    if (items < 0) {
	croak("Usage: OpenGL::glpOpenWindow(w=500,h=500, ...)");
    }
    {
	int	w;
	int	h;

	if (items < 1)
	    w = 500;
	else {
	    w = (int)SvIV(ST(0));
	}

	if (items < 2)
	    h = 500;
	else {
	    h = (int)SvIV(ST(1));
	}
	{

	    XEvent event;

	    int *attributes = default_attributes;

	    if(items>2){

	        int i;

	        attributes = (int *)malloc((items-2+1)* sizeof(int));

	        for(i=2;i<items;i++) {

	            attributes[i-2]=SvIV(ST(i));

	        }

	        attributes[items-2]=None;

	    }

	    /* get a connection */

	    dpy = XOpenDisplay(0);

	    if (!dpy) { fprintf(stderr, "No display!\n");exit(-1);}


	    /* get an appropriate visual */

	    vi = glXChooseVisual(dpy, DefaultScreen(dpy),attributes);

	    if(!vi) { fprintf(stderr, "No visual!\n");exit(-1);}


	    /* create a GLX context */

	    cx = glXCreateContext(dpy, vi, 0, GL_TRUE);

	    if(!cx){fprintf(stderr, "No context!\n");exit(-1);}


	    /* create a color map */

	    cmap = XCreateColormap(dpy, RootWindow(dpy, vi->screen),

				   vi->visual, AllocNone);


	    /* create a window */

	    swa.colormap = cmap;

	    swa.border_pixel = 0;

	    swa.event_mask = StructureNotifyMask;

	    win = XCreateWindow(dpy, RootWindow(dpy, vi->screen), 

				0, 0, w, h,

				0, vi->depth, InputOutput, vi->visual,

				CWBorderPixel|CWColormap|CWEventMask, &swa);

	    XMapWindow(dpy, win);

	    XIfEvent(dpy, &event, WaitForNotify, (char*)win);


	    /* connect the context to the window */

	    if(!glXMakeCurrent(dpy, win, cx)) {

	        fprintf(stderr, "Non current\n");

	        exit(-1);

	    }


	    /* clear the buffer */

	    glClearColor(0,0,0,1);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glXSwapBuffers)
{
    dXSARGS;
    if (items < 0 || items > 2) {
	croak("Usage: OpenGL::glXSwapBuffers(d=dpy,w=win)");
    }
    {
	void *	d;
	GLXDrawable	w;

	if (items < 1)
	    d = dpy;
	else {
	    d = (void *)SvIV(ST(0));
	}

	if (items < 2)
	    w = win;
	else {
	    w = (unsigned long)SvIV(ST(1));
	}
	{

	    glXSwapBuffers(d,w);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glpClipPlane)
{
    dXSARGS;
    if (items != 5) {
	croak("Usage: OpenGL::glpClipPlane(p,a,b,c,d)");
    }
    {
	GLenum	p = (unsigned int)SvIV(ST(0));
	GLdouble	a = (double)SvNV(ST(1));
	GLdouble	b = (double)SvNV(ST(2));
	GLdouble	c = (double)SvNV(ST(3));
	GLdouble	d = (double)SvNV(ST(4));
	{

		GLdouble e[4];

		e[0]=a;e[1]=b;e[2]=c;e[3]=d;

		glClipPlane(p,e);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glpGetClipPlane)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glpGetClipPlane(plane)");
    }
    SP -= items;
    {
	GLenum	plane = (unsigned int)SvIV(ST(0));
	{

	    GLdouble equation[4];

	    glGetClipPlane(plane,equation);

	    EXTEND(sp,4);

	    PUSHs(sv_2mortal(newSVnv(equation[0])));

	    PUSHs(sv_2mortal(newSVnv(equation[1])));

	    PUSHs(sv_2mortal(newSVnv(equation[2])));

	    PUSHs(sv_2mortal(newSVnv(equation[3])));

	}

	PUTBACK;
	return;
    }
}

XS(XS_OpenGL_glpReadTex)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glpReadTex(file)");
    }
    {
	char *	file = (char *)SvPV(ST(0),na);
	{

	    GLsizei w,h;

	    int d,i;

	    char buf[250];

	    unsigned char *image;

	    FILE *fp;

	    fp=fopen(file,"r");

	    if(!fp) {

	        fprintf(stderr,"couldn't open file %s\n",file);

	        return;

	    }

	    fgets(buf,250,fp);

	    fgets(buf,250,fp);

	    fscanf(fp,"%d%d",&w,&h);

	    fscanf(fp,"%d",&d);

	    if(d != 255 || w<64 || h<64 || w>10000 || h>10000) {

	        fprintf(stderr,"error reading %s\n",file);

	        return;

	    }

	    image=(unsigned char *)malloc(w*h*3);

	    for(i=0;i<w*h*3;i++) {

		int v;

	        fscanf(fp,"%d",&v);

	        image[i]=(unsigned char) v;

	    }

	    fclose(fp);

	    glTexImage2D(GL_TEXTURE_2D, 0, 3, w,h, 

	                 0, GL_RGB, GL_UNSIGNED_BYTE,image);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glpLoadMatrixd)
{
    dXSARGS;
    if (items != 16) {
	croak("Usage: OpenGL::glpLoadMatrixd(m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,ma,mb,mc,md,me,mf)");
    }
    {
	GLdouble	m0 = (double)SvNV(ST(0));
	GLdouble	m1 = (double)SvNV(ST(1));
	GLdouble	m2 = (double)SvNV(ST(2));
	GLdouble	m3 = (double)SvNV(ST(3));
	GLdouble	m4 = (double)SvNV(ST(4));
	GLdouble	m5 = (double)SvNV(ST(5));
	GLdouble	m6 = (double)SvNV(ST(6));
	GLdouble	m7 = (double)SvNV(ST(7));
	GLdouble	m8 = (double)SvNV(ST(8));
	GLdouble	m9 = (double)SvNV(ST(9));
	GLdouble	ma = (double)SvNV(ST(10));
	GLdouble	mb = (double)SvNV(ST(11));
	GLdouble	mc = (double)SvNV(ST(12));
	GLdouble	md = (double)SvNV(ST(13));
	GLdouble	me = (double)SvNV(ST(14));
	GLdouble	mf = (double)SvNV(ST(15));
	{

		GLdouble m[16];

		m[0]= m0; m[1]= m1; m[2]= m2; m[3]= m3;

		m[4]= m4; m[5]= m5; m[6]= m6; m[7]= m7;

		m[8]= m8; m[9]= m9; m[10]=ma; m[11]=mb;

		m[12]=mc; m[13]=md; m[14]=me; m[15]=mf;

		glLoadMatrixd(m);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glpMultMatrixd)
{
    dXSARGS;
    if (items != 16) {
	croak("Usage: OpenGL::glpMultMatrixd(m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,ma,mb,mc,md,me,mf)");
    }
    {
	GLdouble	m0 = (double)SvNV(ST(0));
	GLdouble	m1 = (double)SvNV(ST(1));
	GLdouble	m2 = (double)SvNV(ST(2));
	GLdouble	m3 = (double)SvNV(ST(3));
	GLdouble	m4 = (double)SvNV(ST(4));
	GLdouble	m5 = (double)SvNV(ST(5));
	GLdouble	m6 = (double)SvNV(ST(6));
	GLdouble	m7 = (double)SvNV(ST(7));
	GLdouble	m8 = (double)SvNV(ST(8));
	GLdouble	m9 = (double)SvNV(ST(9));
	GLdouble	ma = (double)SvNV(ST(10));
	GLdouble	mb = (double)SvNV(ST(11));
	GLdouble	mc = (double)SvNV(ST(12));
	GLdouble	md = (double)SvNV(ST(13));
	GLdouble	me = (double)SvNV(ST(14));
	GLdouble	mf = (double)SvNV(ST(15));
	{

		GLdouble m[16];

		m[0]= m0; m[1]= m1; m[2]= m2; m[3]= m3;

		m[4]= m4; m[5]= m5; m[6]= m6; m[7]= m7;

		m[8]= m8; m[9]= m9; m[10]=ma; m[11]=mb;

		m[12]=mc; m[13]=md; m[14]=me; m[15]=mf;

		glMultMatrixd(m);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glpLoadMatrixf)
{
    dXSARGS;
    if (items != 16) {
	croak("Usage: OpenGL::glpLoadMatrixf(m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,ma,mb,mc,md,me,mf)");
    }
    {
	GLfloat	m0 = (float)SvNV(ST(0));
	GLfloat	m1 = (float)SvNV(ST(1));
	GLfloat	m2 = (float)SvNV(ST(2));
	GLfloat	m3 = (float)SvNV(ST(3));
	GLfloat	m4 = (float)SvNV(ST(4));
	GLfloat	m5 = (float)SvNV(ST(5));
	GLfloat	m6 = (float)SvNV(ST(6));
	GLfloat	m7 = (float)SvNV(ST(7));
	GLfloat	m8 = (float)SvNV(ST(8));
	GLfloat	m9 = (float)SvNV(ST(9));
	GLfloat	ma = (float)SvNV(ST(10));
	GLfloat	mb = (float)SvNV(ST(11));
	GLfloat	mc = (float)SvNV(ST(12));
	GLfloat	md = (float)SvNV(ST(13));
	GLfloat	me = (float)SvNV(ST(14));
	GLfloat	mf = (float)SvNV(ST(15));
	{

		GLfloat m[16];

		m[0]= m0; m[1]= m1; m[2]= m2; m[3]= m3;

		m[4]= m4; m[5]= m5; m[6]= m6; m[7]= m7;

		m[8]= m8; m[9]= m9; m[10]=ma; m[11]=mb;

		m[12]=mc; m[13]=md; m[14]=me; m[15]=mf;

		glLoadMatrixf(m);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glpMultMatrixf)
{
    dXSARGS;
    if (items != 16) {
	croak("Usage: OpenGL::glpMultMatrixf(m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,ma,mb,mc,md,me,mf)");
    }
    {
	GLfloat	m0 = (float)SvNV(ST(0));
	GLfloat	m1 = (float)SvNV(ST(1));
	GLfloat	m2 = (float)SvNV(ST(2));
	GLfloat	m3 = (float)SvNV(ST(3));
	GLfloat	m4 = (float)SvNV(ST(4));
	GLfloat	m5 = (float)SvNV(ST(5));
	GLfloat	m6 = (float)SvNV(ST(6));
	GLfloat	m7 = (float)SvNV(ST(7));
	GLfloat	m8 = (float)SvNV(ST(8));
	GLfloat	m9 = (float)SvNV(ST(9));
	GLfloat	ma = (float)SvNV(ST(10));
	GLfloat	mb = (float)SvNV(ST(11));
	GLfloat	mc = (float)SvNV(ST(12));
	GLfloat	md = (float)SvNV(ST(13));
	GLfloat	me = (float)SvNV(ST(14));
	GLfloat	mf = (float)SvNV(ST(15));
	{

		GLfloat m[16];

		m[0]= m0; m[1]= m1; m[2]= m2; m[3]= m3;

		m[4]= m4; m[5]= m5; m[6]= m6; m[7]= m7;

		m[8]= m8; m[9]= m9; m[10]=ma; m[11]=mb;

		m[12]=mc; m[13]=md; m[14]=me; m[15]=mf;

		glMultMatrixf(m);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_gluOrtho2D)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::gluOrtho2D(left,right,bottom,top)");
    }
    {
	GLdouble	left = (double)SvNV(ST(0));
	GLdouble	right = (double)SvNV(ST(1));
	GLdouble	bottom = (double)SvNV(ST(2));
	GLdouble	top = (double)SvNV(ST(3));

	gluOrtho2D(left, right, bottom, top);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_gluPerspective)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::gluPerspective(fovy,aspect,zNear,zFar)");
    }
    {
	GLdouble	fovy = (double)SvNV(ST(0));
	GLdouble	aspect = (double)SvNV(ST(1));
	GLdouble	zNear = (double)SvNV(ST(2));
	GLdouble	zFar = (double)SvNV(ST(3));

	gluPerspective(fovy, aspect, zNear, zFar);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_gluLookAt)
{
    dXSARGS;
    if (items != 9) {
	croak("Usage: OpenGL::gluLookAt(eyex,eyey,eyez,centerx,centery,centerz,upx,upy,upz)");
    }
    {
	GLdouble	eyex = (double)SvNV(ST(0));
	GLdouble	eyey = (double)SvNV(ST(1));
	GLdouble	eyez = (double)SvNV(ST(2));
	GLdouble	centerx = (double)SvNV(ST(3));
	GLdouble	centery = (double)SvNV(ST(4));
	GLdouble	centerz = (double)SvNV(ST(5));
	GLdouble	upx = (double)SvNV(ST(6));
	GLdouble	upy = (double)SvNV(ST(7));
	GLdouble	upz = (double)SvNV(ST(8));

	gluLookAt(eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glAccum)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glAccum(op,value)");
    }
    {
	GLenum	op = (unsigned int)SvIV(ST(0));
	GLfloat	value = (float)SvNV(ST(1));

	glAccum(op, value);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glAlphaFunc)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glAlphaFunc(func,ref)");
    }
    {
	GLenum	func = (unsigned int)SvIV(ST(0));
	GLclampf	ref = (float)SvNV(ST(1));

	glAlphaFunc(func, ref);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glBegin)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glBegin(mode)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));

	glBegin(mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glBitmap)
{
    dXSARGS;
    if (items != 7) {
	croak("Usage: OpenGL::glBitmap(width,height,xorig,yorig,xmove,ymove,bitmap)");
    }
    {
	GLsizei	width = (int)SvIV(ST(0));
	GLsizei	height = (int)SvIV(ST(1));
	GLfloat	xorig = (float)SvNV(ST(2));
	GLfloat	yorig = (float)SvNV(ST(3));
	GLfloat	xmove = (float)SvNV(ST(4));
	GLfloat	ymove = (float)SvNV(ST(5));
	char *	bitmap = (char *)SvPV(ST(6),na);
	{

	   glBitmap(width,height,xorig,yorig,xmove,ymove,(GLubyte *)bitmap);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glBlendColorEXT)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glBlendColorEXT(red,green,blue,alpha)");
    }
    {
	GLclampf	red = (float)SvNV(ST(0));
	GLclampf	green = (float)SvNV(ST(1));
	GLclampf	blue = (float)SvNV(ST(2));
	GLclampf	alpha = (float)SvNV(ST(3));

	glBlendColorEXT(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glBlendEquationEXT)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glBlendEquationEXT(mode)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));

	glBlendEquationEXT(mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glBlendFunc)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glBlendFunc(sfactor,dfactor)");
    }
    {
	GLenum	sfactor = (unsigned int)SvIV(ST(0));
	GLenum	dfactor = (unsigned int)SvIV(ST(1));

	glBlendFunc(sfactor, dfactor);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glCallList)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glCallList(list)");
    }
    {
	GLuint	list = (unsigned int)SvIV(ST(0));

	glCallList(list);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glCallLists)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glCallLists(n,type,lists)");
    }
    {
	GLsizei	n = (int)SvIV(ST(0));
	GLenum	type = (unsigned int)SvIV(ST(1));
	char *	lists = (char *)SvPV(ST(2),na);
	{

	   glCallLists(n,type,(GLvoid *)lists);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glClear)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glClear(mask)");
    }
    {
	GLbitfield	mask = (unsigned int)SvIV(ST(0));

	glClear(mask);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glClearAccum)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glClearAccum(red,green,blue,alpha)");
    }
    {
	GLfloat	red = (float)SvNV(ST(0));
	GLfloat	green = (float)SvNV(ST(1));
	GLfloat	blue = (float)SvNV(ST(2));
	GLfloat	alpha = (float)SvNV(ST(3));

	glClearAccum(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glClearColor)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glClearColor(red,green,blue,alpha)");
    }
    {
	GLclampf	red = (float)SvNV(ST(0));
	GLclampf	green = (float)SvNV(ST(1));
	GLclampf	blue = (float)SvNV(ST(2));
	GLclampf	alpha = (float)SvNV(ST(3));

	glClearColor(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glClearDepth)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glClearDepth(depth)");
    }
    {
	GLclampd	depth = (double)SvNV(ST(0));

	glClearDepth(depth);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glClearIndex)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glClearIndex(c)");
    }
    {
	GLfloat	c = (float)SvNV(ST(0));

	glClearIndex(c);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glClearStencil)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glClearStencil(s)");
    }
    {
	GLint	s = (int)SvIV(ST(0));

	glClearStencil(s);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glClipPlane)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glClipPlane(plane,equation)");
    }
    {
	GLenum	plane = (unsigned int)SvIV(ST(0));
	char *	equation = (char *)SvPV(ST(1),na);
	{

	   glClipPlane(plane,(GLdouble *)equation);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3b)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glColor3b(red,green,blue)");
    }
    {
	GLbyte	red = (char)*SvPV(ST(0),na);
	GLbyte	green = (char)*SvPV(ST(1),na);
	GLbyte	blue = (char)*SvPV(ST(2),na);

	glColor3b(red, green, blue);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3bv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor3bv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor3bv((GLbyte *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3d)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glColor3d(red,green,blue)");
    }
    {
	GLdouble	red = (double)SvNV(ST(0));
	GLdouble	green = (double)SvNV(ST(1));
	GLdouble	blue = (double)SvNV(ST(2));

	glColor3d(red, green, blue);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor3dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor3dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3f)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glColor3f(red,green,blue)");
    }
    {
	GLfloat	red = (float)SvNV(ST(0));
	GLfloat	green = (float)SvNV(ST(1));
	GLfloat	blue = (float)SvNV(ST(2));

	glColor3f(red, green, blue);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor3fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor3fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3i)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glColor3i(red,green,blue)");
    }
    {
	GLint	red = (int)SvIV(ST(0));
	GLint	green = (int)SvIV(ST(1));
	GLint	blue = (int)SvIV(ST(2));

	glColor3i(red, green, blue);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor3iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor3iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3s)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glColor3s(red,green,blue)");
    }
    {
	GLshort	red = (short)SvIV(ST(0));
	GLshort	green = (short)SvIV(ST(1));
	GLshort	blue = (short)SvIV(ST(2));

	glColor3s(red, green, blue);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor3sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor3sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3ub)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glColor3ub(red,green,blue)");
    }
    {
	GLubyte	red = (unsigned char)SvIV(ST(0));
	GLubyte	green = (unsigned char)SvIV(ST(1));
	GLubyte	blue = (unsigned char)SvIV(ST(2));

	glColor3ub(red, green, blue);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3ubv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor3ubv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor3ubv((GLubyte *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3ui)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glColor3ui(red,green,blue)");
    }
    {
	GLuint	red = (unsigned int)SvIV(ST(0));
	GLuint	green = (unsigned int)SvIV(ST(1));
	GLuint	blue = (unsigned int)SvIV(ST(2));

	glColor3ui(red, green, blue);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3uiv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor3uiv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor3uiv((GLuint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3us)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glColor3us(red,green,blue)");
    }
    {
	GLushort	red = (unsigned short)SvIV(ST(0));
	GLushort	green = (unsigned short)SvIV(ST(1));
	GLushort	blue = (unsigned short)SvIV(ST(2));

	glColor3us(red, green, blue);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor3usv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor3usv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor3usv((GLushort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4b)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glColor4b(red,green,blue,alpha)");
    }
    {
	GLbyte	red = (char)*SvPV(ST(0),na);
	GLbyte	green = (char)*SvPV(ST(1),na);
	GLbyte	blue = (char)*SvPV(ST(2),na);
	GLbyte	alpha = (char)*SvPV(ST(3),na);

	glColor4b(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4bv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor4bv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor4bv((GLbyte *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4d)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glColor4d(red,green,blue,alpha)");
    }
    {
	GLdouble	red = (double)SvNV(ST(0));
	GLdouble	green = (double)SvNV(ST(1));
	GLdouble	blue = (double)SvNV(ST(2));
	GLdouble	alpha = (double)SvNV(ST(3));

	glColor4d(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor4dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor4dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4f)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glColor4f(red,green,blue,alpha)");
    }
    {
	GLfloat	red = (float)SvNV(ST(0));
	GLfloat	green = (float)SvNV(ST(1));
	GLfloat	blue = (float)SvNV(ST(2));
	GLfloat	alpha = (float)SvNV(ST(3));

	glColor4f(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor4fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor4fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4i)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glColor4i(red,green,blue,alpha)");
    }
    {
	GLint	red = (int)SvIV(ST(0));
	GLint	green = (int)SvIV(ST(1));
	GLint	blue = (int)SvIV(ST(2));
	GLint	alpha = (int)SvIV(ST(3));

	glColor4i(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor4iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor4iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4s)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glColor4s(red,green,blue,alpha)");
    }
    {
	GLshort	red = (short)SvIV(ST(0));
	GLshort	green = (short)SvIV(ST(1));
	GLshort	blue = (short)SvIV(ST(2));
	GLshort	alpha = (short)SvIV(ST(3));

	glColor4s(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor4sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor4sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4ub)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glColor4ub(red,green,blue,alpha)");
    }
    {
	GLubyte	red = (unsigned char)SvIV(ST(0));
	GLubyte	green = (unsigned char)SvIV(ST(1));
	GLubyte	blue = (unsigned char)SvIV(ST(2));
	GLubyte	alpha = (unsigned char)SvIV(ST(3));

	glColor4ub(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4ubv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor4ubv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor4ubv((GLubyte *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4ui)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glColor4ui(red,green,blue,alpha)");
    }
    {
	GLuint	red = (unsigned int)SvIV(ST(0));
	GLuint	green = (unsigned int)SvIV(ST(1));
	GLuint	blue = (unsigned int)SvIV(ST(2));
	GLuint	alpha = (unsigned int)SvIV(ST(3));

	glColor4ui(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4uiv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor4uiv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor4uiv((GLuint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4us)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glColor4us(red,green,blue,alpha)");
    }
    {
	GLushort	red = (unsigned short)SvIV(ST(0));
	GLushort	green = (unsigned short)SvIV(ST(1));
	GLushort	blue = (unsigned short)SvIV(ST(2));
	GLushort	alpha = (unsigned short)SvIV(ST(3));

	glColor4us(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColor4usv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glColor4usv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glColor4usv((GLushort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColorMask)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glColorMask(red,green,blue,alpha)");
    }
    {
	GLboolean	red = (unsigned char)SvIV(ST(0));
	GLboolean	green = (unsigned char)SvIV(ST(1));
	GLboolean	blue = (unsigned char)SvIV(ST(2));
	GLboolean	alpha = (unsigned char)SvIV(ST(3));

	glColorMask(red, green, blue, alpha);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glColorMaterial)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glColorMaterial(face,mode)");
    }
    {
	GLenum	face = (unsigned int)SvIV(ST(0));
	GLenum	mode = (unsigned int)SvIV(ST(1));

	glColorMaterial(face, mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glConvolutionFilter1DEXT)
{
    dXSARGS;
    if (items != 6) {
	croak("Usage: OpenGL::glConvolutionFilter1DEXT(target,internalformat,width,format,type,image)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	internalformat = (unsigned int)SvIV(ST(1));
	GLsizei	width = (int)SvIV(ST(2));
	GLenum	format = (unsigned int)SvIV(ST(3));
	GLenum	type = (unsigned int)SvIV(ST(4));
	char *	image = (char *)SvPV(ST(5),na);
	{

	   glConvolutionFilter1DEXT(target,internalformat,width,format,type,(GLvoid *)image);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glConvolutionFilter2DEXT)
{
    dXSARGS;
    if (items != 7) {
	croak("Usage: OpenGL::glConvolutionFilter2DEXT(target,internalformat,width,height,format,type,image)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	internalformat = (unsigned int)SvIV(ST(1));
	GLsizei	width = (int)SvIV(ST(2));
	GLsizei	height = (int)SvIV(ST(3));
	GLenum	format = (unsigned int)SvIV(ST(4));
	GLenum	type = (unsigned int)SvIV(ST(5));
	char *	image = (char *)SvPV(ST(6),na);
	{

	   glConvolutionFilter2DEXT(target,internalformat,width,height,format,type,(GLvoid *)image);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glConvolutionParameterfEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glConvolutionParameterfEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLfloat	params = (float)SvNV(ST(2));

	glConvolutionParameterfEXT(target, pname, params);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glConvolutionParameterfvEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glConvolutionParameterfvEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glConvolutionParameterfvEXT(target,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glConvolutionParameteriEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glConvolutionParameteriEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLint	params = (int)SvIV(ST(2));

	glConvolutionParameteriEXT(target, pname, params);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glConvolutionParameterivEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glConvolutionParameterivEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glConvolutionParameterivEXT(target,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glCopyConvolutionFilter1DEXT)
{
    dXSARGS;
    if (items != 5) {
	croak("Usage: OpenGL::glCopyConvolutionFilter1DEXT(target,internalformat,x,y,width)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	internalformat = (unsigned int)SvIV(ST(1));
	GLint	x = (int)SvIV(ST(2));
	GLint	y = (int)SvIV(ST(3));
	GLsizei	width = (int)SvIV(ST(4));

	glCopyConvolutionFilter1DEXT(target, internalformat, x, y, width);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glCopyConvolutionFilter2DEXT)
{
    dXSARGS;
    if (items != 6) {
	croak("Usage: OpenGL::glCopyConvolutionFilter2DEXT(target,internalformat,x,y,width,height)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	internalformat = (unsigned int)SvIV(ST(1));
	GLint	x = (int)SvIV(ST(2));
	GLint	y = (int)SvIV(ST(3));
	GLsizei	width = (int)SvIV(ST(4));
	GLsizei	height = (int)SvIV(ST(5));

	glCopyConvolutionFilter2DEXT(target, internalformat, x, y, width, height);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glCopyPixels)
{
    dXSARGS;
    if (items != 5) {
	croak("Usage: OpenGL::glCopyPixels(x,y,width,height,type)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));
	GLsizei	width = (int)SvIV(ST(2));
	GLsizei	height = (int)SvIV(ST(3));
	GLenum	type = (unsigned int)SvIV(ST(4));

	glCopyPixels(x, y, width, height, type);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glCullFace)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glCullFace(mode)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));

	glCullFace(mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glDeleteLists)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glDeleteLists(list,range)");
    }
    {
	GLuint	list = (unsigned int)SvIV(ST(0));
	GLsizei	range = (int)SvIV(ST(1));

	glDeleteLists(list, range);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glDepthFunc)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glDepthFunc(func)");
    }
    {
	GLenum	func = (unsigned int)SvIV(ST(0));

	glDepthFunc(func);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glDepthMask)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glDepthMask(flag)");
    }
    {
	GLboolean	flag = (unsigned char)SvIV(ST(0));

	glDepthMask(flag);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glDepthRange)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glDepthRange(near,far)");
    }
    {
	GLclampd	near = (double)SvNV(ST(0));
	GLclampd	far = (double)SvNV(ST(1));

	glDepthRange(near, far);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glDetailTexFuncSGIS)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glDetailTexFuncSGIS(target,n,points)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLsizei	n = (int)SvIV(ST(1));
	char *	points = (char *)SvPV(ST(2),na);
	{

	   glDetailTexFuncSGIS(target,n,(GLfloat *)points);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glDisable)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glDisable(cap)");
    }
    {
	GLenum	cap = (unsigned int)SvIV(ST(0));

	glDisable(cap);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glDrawBuffer)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glDrawBuffer(mode)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));

	glDrawBuffer(mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glDrawPixels)
{
    dXSARGS;
    if (items != 5) {
	croak("Usage: OpenGL::glDrawPixels(width,height,format,type,pixels)");
    }
    {
	GLsizei	width = (int)SvIV(ST(0));
	GLsizei	height = (int)SvIV(ST(1));
	GLenum	format = (unsigned int)SvIV(ST(2));
	GLenum	type = (unsigned int)SvIV(ST(3));
	char *	pixels = (char *)SvPV(ST(4),na);
	{

	   glDrawPixels(width,height,format,type,(GLvoid *)pixels);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEdgeFlag)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEdgeFlag(flag)");
    }
    {
	GLboolean	flag = (unsigned char)SvIV(ST(0));

	glEdgeFlag(flag);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEdgeFlagv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEdgeFlagv(flag)");
    }
    {
	char *	flag = (char *)SvPV(ST(0),na);
	{

	   glEdgeFlagv((GLboolean *)flag);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEnable)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEnable(cap)");
    }
    {
	GLenum	cap = (unsigned int)SvIV(ST(0));

	glEnable(cap);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEnd)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glEnd()");
    }
    {

	glEnd();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEndList)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glEndList()");
    }
    {

	glEndList();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalCoord1d)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEvalCoord1d(u)");
    }
    {
	GLdouble	u = (double)SvNV(ST(0));

	glEvalCoord1d(u);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalCoord1dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEvalCoord1dv(u)");
    }
    {
	char *	u = (char *)SvPV(ST(0),na);
	{

	   glEvalCoord1dv((GLdouble *)u);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalCoord1f)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEvalCoord1f(u)");
    }
    {
	GLfloat	u = (float)SvNV(ST(0));

	glEvalCoord1f(u);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalCoord1fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEvalCoord1fv(u)");
    }
    {
	char *	u = (char *)SvPV(ST(0),na);
	{

	   glEvalCoord1fv((GLfloat *)u);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalCoord2d)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glEvalCoord2d(u,v)");
    }
    {
	GLdouble	u = (double)SvNV(ST(0));
	GLdouble	v = (double)SvNV(ST(1));

	glEvalCoord2d(u, v);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalCoord2dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEvalCoord2dv(u)");
    }
    {
	char *	u = (char *)SvPV(ST(0),na);
	{

	   glEvalCoord2dv((GLdouble *)u);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalCoord2f)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glEvalCoord2f(u,v)");
    }
    {
	GLfloat	u = (float)SvNV(ST(0));
	GLfloat	v = (float)SvNV(ST(1));

	glEvalCoord2f(u, v);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalCoord2fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEvalCoord2fv(u)");
    }
    {
	char *	u = (char *)SvPV(ST(0),na);
	{

	   glEvalCoord2fv((GLfloat *)u);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalMesh1)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glEvalMesh1(mode,i1,i2)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));
	GLint	i1 = (int)SvIV(ST(1));
	GLint	i2 = (int)SvIV(ST(2));

	glEvalMesh1(mode, i1, i2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalMesh2)
{
    dXSARGS;
    if (items != 5) {
	croak("Usage: OpenGL::glEvalMesh2(mode,i1,i2,j1,j2)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));
	GLint	i1 = (int)SvIV(ST(1));
	GLint	i2 = (int)SvIV(ST(2));
	GLint	j1 = (int)SvIV(ST(3));
	GLint	j2 = (int)SvIV(ST(4));

	glEvalMesh2(mode, i1, i2, j1, j2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalPoint1)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glEvalPoint1(i)");
    }
    {
	GLint	i = (int)SvIV(ST(0));

	glEvalPoint1(i);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glEvalPoint2)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glEvalPoint2(i,j)");
    }
    {
	GLint	i = (int)SvIV(ST(0));
	GLint	j = (int)SvIV(ST(1));

	glEvalPoint2(i, j);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glFeedbackBuffer)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glFeedbackBuffer(size,type,buffer)");
    }
    {
	GLsizei	size = (int)SvIV(ST(0));
	GLenum	type = (unsigned int)SvIV(ST(1));
	char *	buffer = (char *)SvPV(ST(2),na);
	{

	   glFeedbackBuffer(size,type,(GLfloat *)buffer);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glFinish)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glFinish()");
    }
    {

	glFinish();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glFlush)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glFlush()");
    }
    {

	glFlush();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glFogf)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glFogf(pname,param)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	GLfloat	param = (float)SvNV(ST(1));

	glFogf(pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glFogfv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glFogfv(pname,params)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	char *	params = (char *)SvPV(ST(1),na);
	{

	   glFogfv(pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glFogi)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glFogi(pname,param)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	GLint	param = (int)SvIV(ST(1));

	glFogi(pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glFogiv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glFogiv(pname,params)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	char *	params = (char *)SvPV(ST(1),na);
	{

	   glFogiv(pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glFrontFace)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glFrontFace(mode)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));

	glFrontFace(mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glFrustum)
{
    dXSARGS;
    if (items != 6) {
	croak("Usage: OpenGL::glFrustum(left,right,bottom,top,near,far)");
    }
    {
	GLdouble	left = (double)SvNV(ST(0));
	GLdouble	right = (double)SvNV(ST(1));
	GLdouble	bottom = (double)SvNV(ST(2));
	GLdouble	top = (double)SvNV(ST(3));
	GLdouble	near = (double)SvNV(ST(4));
	GLdouble	far = (double)SvNV(ST(5));

	glFrustum(left, right, bottom, top, near, far);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGenLists)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glGenLists(range)");
    }
    {
	GLsizei	range = (int)SvIV(ST(0));
	GLuint	RETVAL;

	RETVAL = glGenLists(range);
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetBooleanv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetBooleanv(pname,params)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	char *	params = (char *)SvPV(ST(1),na);
	{

	   glGetBooleanv(pname,(GLboolean *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetClipPlane)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetClipPlane(plane,equation)");
    }
    {
	GLenum	plane = (unsigned int)SvIV(ST(0));
	char *	equation = (char *)SvPV(ST(1),na);
	{

	   glGetClipPlane(plane,(GLdouble *)equation);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetConvolutionFilterEXT)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glGetConvolutionFilterEXT(target,format,type,image)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	format = (unsigned int)SvIV(ST(1));
	GLenum	type = (unsigned int)SvIV(ST(2));
	char *	image = (char *)SvPV(ST(3),na);
	{

	   glGetConvolutionFilterEXT(target,format,type,(GLvoid *)image);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetConvolutionParameterfvEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetConvolutionParameterfvEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetConvolutionParameterfvEXT(target,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetConvolutionParameterivEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetConvolutionParameterivEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetConvolutionParameterivEXT(target,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetDetailTexFuncSGIS)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetDetailTexFuncSGIS(target,points)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	char *	points = (char *)SvPV(ST(1),na);
	{

	   glGetDetailTexFuncSGIS(target,(GLfloat *)points);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetDoublev)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetDoublev(pname,params)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	char *	params = (char *)SvPV(ST(1),na);
	{

	   glGetDoublev(pname,(GLdouble *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetError)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glGetError()");
    }
    {
	GLenum	RETVAL;

	RETVAL = glGetError();
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetFloatv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetFloatv(pname,params)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	char *	params = (char *)SvPV(ST(1),na);
	{

	   glGetFloatv(pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetHistogramEXT)
{
    dXSARGS;
    if (items != 5) {
	croak("Usage: OpenGL::glGetHistogramEXT(target,reset,format,type,values)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLboolean	reset = (unsigned char)SvIV(ST(1));
	GLenum	format = (unsigned int)SvIV(ST(2));
	GLenum	type = (unsigned int)SvIV(ST(3));
	char *	values = (char *)SvPV(ST(4),na);
	{

	   glGetHistogramEXT(target,reset,format,type,(GLvoid *)values);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetHistogramParameterfvEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetHistogramParameterfvEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetHistogramParameterfvEXT(target,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetHistogramParameterivEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetHistogramParameterivEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetHistogramParameterivEXT(target,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetIntegerv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetIntegerv(pname,params)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	char *	params = (char *)SvPV(ST(1),na);
	{

	   glGetIntegerv(pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetLightfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetLightfv(light,pname,params)");
    }
    {
	GLenum	light = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetLightfv(light,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetLightiv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetLightiv(light,pname,params)");
    }
    {
	GLenum	light = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetLightiv(light,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetMapdv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetMapdv(target,query,v)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	query = (unsigned int)SvIV(ST(1));
	char *	v = (char *)SvPV(ST(2),na);
	{

	   glGetMapdv(target,query,(GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetMapfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetMapfv(target,query,v)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	query = (unsigned int)SvIV(ST(1));
	char *	v = (char *)SvPV(ST(2),na);
	{

	   glGetMapfv(target,query,(GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetMapiv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetMapiv(target,query,v)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	query = (unsigned int)SvIV(ST(1));
	char *	v = (char *)SvPV(ST(2),na);
	{

	   glGetMapiv(target,query,(GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetMaterialfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetMaterialfv(face,pname,params)");
    }
    {
	GLenum	face = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetMaterialfv(face,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetMaterialiv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetMaterialiv(face,pname,params)");
    }
    {
	GLenum	face = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetMaterialiv(face,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetMinmaxEXT)
{
    dXSARGS;
    if (items != 5) {
	croak("Usage: OpenGL::glGetMinmaxEXT(target,reset,format,type,values)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLboolean	reset = (unsigned char)SvIV(ST(1));
	GLenum	format = (unsigned int)SvIV(ST(2));
	GLenum	type = (unsigned int)SvIV(ST(3));
	char *	values = (char *)SvPV(ST(4),na);
	{

	   glGetMinmaxEXT(target,reset,format,type,(GLvoid *)values);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetMinmaxParameterfvEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetMinmaxParameterfvEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetMinmaxParameterfvEXT(target,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetMinmaxParameterivEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetMinmaxParameterivEXT(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetMinmaxParameterivEXT(target,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetPixelMapfv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetPixelMapfv(map,values)");
    }
    {
	GLenum	map = (unsigned int)SvIV(ST(0));
	char *	values = (char *)SvPV(ST(1),na);
	{

	   glGetPixelMapfv(map,(GLfloat *)values);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetPixelMapuiv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetPixelMapuiv(map,values)");
    }
    {
	GLenum	map = (unsigned int)SvIV(ST(0));
	char *	values = (char *)SvPV(ST(1),na);
	{

	   glGetPixelMapuiv(map,(GLuint *)values);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetPixelMapusv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetPixelMapusv(map,values)");
    }
    {
	GLenum	map = (unsigned int)SvIV(ST(0));
	char *	values = (char *)SvPV(ST(1),na);
	{

	   glGetPixelMapusv(map,(GLushort *)values);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetPolygonStipple)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glGetPolygonStipple(mask)");
    }
    {
	char *	mask = (char *)SvPV(ST(0),na);
	{

	   glGetPolygonStipple((GLubyte *)mask);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetSeparableFilterEXT)
{
    dXSARGS;
    if (items != 6) {
	croak("Usage: OpenGL::glGetSeparableFilterEXT(target,format,type,row,column,span)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	format = (unsigned int)SvIV(ST(1));
	GLenum	type = (unsigned int)SvIV(ST(2));
	char *	row = (char *)SvPV(ST(3),na);
	char *	column = (char *)SvPV(ST(4),na);
	char *	span = (char *)SvPV(ST(5),na);
	{

	   glGetSeparableFilterEXT(target,format,type,(GLvoid *)row,(GLvoid *)column,(GLvoid *)span);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetSharpenTexFuncSGIS)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glGetSharpenTexFuncSGIS(target,points)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	char *	points = (char *)SvPV(ST(1),na);
	{

	   glGetSharpenTexFuncSGIS(target,(GLfloat *)points);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexEnvfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetTexEnvfv(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetTexEnvfv(target,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexEnviv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetTexEnviv(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetTexEnviv(target,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexGendv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetTexGendv(coord,pname,params)");
    }
    {
	GLenum	coord = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetTexGendv(coord,pname,(GLdouble *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexGenfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetTexGenfv(coord,pname,params)");
    }
    {
	GLenum	coord = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetTexGenfv(coord,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexGeniv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetTexGeniv(coord,pname,params)");
    }
    {
	GLenum	coord = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetTexGeniv(coord,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexImage)
{
    dXSARGS;
    if (items != 5) {
	croak("Usage: OpenGL::glGetTexImage(target,level,format,type,pixels)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLint	level = (int)SvIV(ST(1));
	GLenum	format = (unsigned int)SvIV(ST(2));
	GLenum	type = (unsigned int)SvIV(ST(3));
	char *	pixels = (char *)SvPV(ST(4),na);
	{

	   glGetTexImage(target,level,format,type,(GLvoid *)pixels);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexLevelParameterfv)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glGetTexLevelParameterfv(target,level,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLint	level = (int)SvIV(ST(1));
	GLenum	pname = (unsigned int)SvIV(ST(2));
	char *	params = (char *)SvPV(ST(3),na);
	{

	   glGetTexLevelParameterfv(target,level,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexLevelParameteriv)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glGetTexLevelParameteriv(target,level,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLint	level = (int)SvIV(ST(1));
	GLenum	pname = (unsigned int)SvIV(ST(2));
	char *	params = (char *)SvPV(ST(3),na);
	{

	   glGetTexLevelParameteriv(target,level,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexParameterfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetTexParameterfv(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetTexParameterfv(target,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glGetTexParameteriv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glGetTexParameteriv(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glGetTexParameteriv(target,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glHint)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glHint(target,mode)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	mode = (unsigned int)SvIV(ST(1));

	glHint(target, mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glHistogramEXT)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glHistogramEXT(target,width,internalformat,sink)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLsizei	width = (int)SvIV(ST(1));
	GLenum	internalformat = (unsigned int)SvIV(ST(2));
	GLboolean	sink = (unsigned char)SvIV(ST(3));

	glHistogramEXT(target, width, internalformat, sink);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIndexMask)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIndexMask(mask)");
    }
    {
	GLuint	mask = (unsigned int)SvIV(ST(0));

	glIndexMask(mask);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIndexd)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIndexd(c)");
    }
    {
	GLdouble	c = (double)SvNV(ST(0));

	glIndexd(c);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIndexdv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIndexdv(c)");
    }
    {
	char *	c = (char *)SvPV(ST(0),na);
	{

	   glIndexdv((GLdouble *)c);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIndexf)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIndexf(c)");
    }
    {
	GLfloat	c = (float)SvNV(ST(0));

	glIndexf(c);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIndexfv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIndexfv(c)");
    }
    {
	char *	c = (char *)SvPV(ST(0),na);
	{

	   glIndexfv((GLfloat *)c);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIndexi)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIndexi(c)");
    }
    {
	GLint	c = (int)SvIV(ST(0));

	glIndexi(c);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIndexiv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIndexiv(c)");
    }
    {
	char *	c = (char *)SvPV(ST(0),na);
	{

	   glIndexiv((GLint *)c);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIndexs)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIndexs(c)");
    }
    {
	GLshort	c = (short)SvIV(ST(0));

	glIndexs(c);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIndexsv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIndexsv(c)");
    }
    {
	char *	c = (char *)SvPV(ST(0),na);
	{

	   glIndexsv((GLshort *)c);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glInitNames)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glInitNames()");
    }
    {

	glInitNames();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIsEnabled)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIsEnabled(cap)");
    }
    {
	GLenum	cap = (unsigned int)SvIV(ST(0));
	GLboolean	RETVAL;

	RETVAL = glIsEnabled(cap);
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glIsList)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glIsList(list)");
    }
    {
	GLuint	list = (unsigned int)SvIV(ST(0));
	GLboolean	RETVAL;

	RETVAL = glIsList(list);
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLightModelf)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glLightModelf(pname,param)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	GLfloat	param = (float)SvNV(ST(1));

	glLightModelf(pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLightModelfv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glLightModelfv(pname,params)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	char *	params = (char *)SvPV(ST(1),na);
	{

	   glLightModelfv(pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLightModeli)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glLightModeli(pname,param)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	GLint	param = (int)SvIV(ST(1));

	glLightModeli(pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLightModeliv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glLightModeliv(pname,params)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	char *	params = (char *)SvPV(ST(1),na);
	{

	   glLightModeliv(pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLightf)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glLightf(light,pname,param)");
    }
    {
	GLenum	light = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLfloat	param = (float)SvNV(ST(2));

	glLightf(light, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLightfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glLightfv(light,pname,params)");
    }
    {
	GLenum	light = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glLightfv(light,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLighti)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glLighti(light,pname,param)");
    }
    {
	GLenum	light = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLint	param = (int)SvIV(ST(2));

	glLighti(light, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLightiv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glLightiv(light,pname,params)");
    }
    {
	GLenum	light = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glLightiv(light,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLineStipple)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glLineStipple(factor,pattern)");
    }
    {
	GLint	factor = (int)SvIV(ST(0));
	GLushort	pattern = (unsigned short)SvIV(ST(1));

	glLineStipple(factor, pattern);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLineWidth)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glLineWidth(width)");
    }
    {
	GLfloat	width = (float)SvNV(ST(0));

	glLineWidth(width);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glListBase)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glListBase(base)");
    }
    {
	GLuint	base = (unsigned int)SvIV(ST(0));

	glListBase(base);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLoadIdentity)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glLoadIdentity()");
    }
    {

	glLoadIdentity();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLoadMatrixd)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glLoadMatrixd(m)");
    }
    {
	char *	m = (char *)SvPV(ST(0),na);
	{

	   glLoadMatrixd((GLdouble *)m);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLoadMatrixf)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glLoadMatrixf(m)");
    }
    {
	char *	m = (char *)SvPV(ST(0),na);
	{

	   glLoadMatrixf((GLfloat *)m);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLoadName)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glLoadName(name)");
    }
    {
	GLuint	name = (unsigned int)SvIV(ST(0));

	glLoadName(name);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glLogicOp)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glLogicOp(opcode)");
    }
    {
	GLenum	opcode = (unsigned int)SvIV(ST(0));

	glLogicOp(opcode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMap1d)
{
    dXSARGS;
    if (items != 6) {
	croak("Usage: OpenGL::glMap1d(target,u1,u2,stride,order,points)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLdouble	u1 = (double)SvNV(ST(1));
	GLdouble	u2 = (double)SvNV(ST(2));
	GLint	stride = (int)SvIV(ST(3));
	GLint	order = (int)SvIV(ST(4));
	char *	points = (char *)SvPV(ST(5),na);
	{

	   glMap1d(target,u1,u2,stride,order,(GLdouble *)points);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMap1f)
{
    dXSARGS;
    if (items != 6) {
	croak("Usage: OpenGL::glMap1f(target,u1,u2,stride,order,points)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLfloat	u1 = (float)SvNV(ST(1));
	GLfloat	u2 = (float)SvNV(ST(2));
	GLint	stride = (int)SvIV(ST(3));
	GLint	order = (int)SvIV(ST(4));
	char *	points = (char *)SvPV(ST(5),na);
	{

	   glMap1f(target,u1,u2,stride,order,(GLfloat *)points);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMap2d)
{
    dXSARGS;
    if (items != 10) {
	croak("Usage: OpenGL::glMap2d(target,u1,u2,ustride,uorder,v1,v2,vstride,vorder,points)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLdouble	u1 = (double)SvNV(ST(1));
	GLdouble	u2 = (double)SvNV(ST(2));
	GLint	ustride = (int)SvIV(ST(3));
	GLint	uorder = (int)SvIV(ST(4));
	GLdouble	v1 = (double)SvNV(ST(5));
	GLdouble	v2 = (double)SvNV(ST(6));
	GLint	vstride = (int)SvIV(ST(7));
	GLint	vorder = (int)SvIV(ST(8));
	char *	points = (char *)SvPV(ST(9),na);
	{

	   glMap2d(target,u1,u2,ustride,uorder,v1,v2,vstride,vorder,(GLdouble *)points);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMap2f)
{
    dXSARGS;
    if (items != 10) {
	croak("Usage: OpenGL::glMap2f(target,u1,u2,ustride,uorder,v1,v2,vstride,vorder,points)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLfloat	u1 = (float)SvNV(ST(1));
	GLfloat	u2 = (float)SvNV(ST(2));
	GLint	ustride = (int)SvIV(ST(3));
	GLint	uorder = (int)SvIV(ST(4));
	GLfloat	v1 = (float)SvNV(ST(5));
	GLfloat	v2 = (float)SvNV(ST(6));
	GLint	vstride = (int)SvIV(ST(7));
	GLint	vorder = (int)SvIV(ST(8));
	char *	points = (char *)SvPV(ST(9),na);
	{

	   glMap2f(target,u1,u2,ustride,uorder,v1,v2,vstride,vorder,(GLfloat *)points);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMapGrid1d)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glMapGrid1d(un,u1,u2)");
    }
    {
	GLint	un = (int)SvIV(ST(0));
	GLdouble	u1 = (double)SvNV(ST(1));
	GLdouble	u2 = (double)SvNV(ST(2));

	glMapGrid1d(un, u1, u2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMapGrid1f)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glMapGrid1f(un,u1,u2)");
    }
    {
	GLint	un = (int)SvIV(ST(0));
	GLfloat	u1 = (float)SvNV(ST(1));
	GLfloat	u2 = (float)SvNV(ST(2));

	glMapGrid1f(un, u1, u2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMapGrid2d)
{
    dXSARGS;
    if (items != 6) {
	croak("Usage: OpenGL::glMapGrid2d(un,u1,u2,vn,v1,v2)");
    }
    {
	GLint	un = (int)SvIV(ST(0));
	GLdouble	u1 = (double)SvNV(ST(1));
	GLdouble	u2 = (double)SvNV(ST(2));
	GLint	vn = (int)SvIV(ST(3));
	GLdouble	v1 = (double)SvNV(ST(4));
	GLdouble	v2 = (double)SvNV(ST(5));

	glMapGrid2d(un, u1, u2, vn, v1, v2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMapGrid2f)
{
    dXSARGS;
    if (items != 6) {
	croak("Usage: OpenGL::glMapGrid2f(un,u1,u2,vn,v1,v2)");
    }
    {
	GLint	un = (int)SvIV(ST(0));
	GLfloat	u1 = (float)SvNV(ST(1));
	GLfloat	u2 = (float)SvNV(ST(2));
	GLint	vn = (int)SvIV(ST(3));
	GLfloat	v1 = (float)SvNV(ST(4));
	GLfloat	v2 = (float)SvNV(ST(5));

	glMapGrid2f(un, u1, u2, vn, v1, v2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMaterialf)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glMaterialf(face,pname,param)");
    }
    {
	GLenum	face = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLfloat	param = (float)SvNV(ST(2));

	glMaterialf(face, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMaterialfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glMaterialfv(face,pname,params)");
    }
    {
	GLenum	face = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glMaterialfv(face,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMateriali)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glMateriali(face,pname,param)");
    }
    {
	GLenum	face = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLint	param = (int)SvIV(ST(2));

	glMateriali(face, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMaterialiv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glMaterialiv(face,pname,params)");
    }
    {
	GLenum	face = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glMaterialiv(face,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMatrixMode)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glMatrixMode(mode)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));

	glMatrixMode(mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMinmaxEXT)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glMinmaxEXT(target,internalformat,sink)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	internalformat = (unsigned int)SvIV(ST(1));
	GLboolean	sink = (unsigned char)SvIV(ST(2));

	glMinmaxEXT(target, internalformat, sink);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMultMatrixd)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glMultMatrixd(m)");
    }
    {
	char *	m = (char *)SvPV(ST(0),na);
	{

	   glMultMatrixd((GLdouble *)m);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glMultMatrixf)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glMultMatrixf(m)");
    }
    {
	char *	m = (char *)SvPV(ST(0),na);
	{

	   glMultMatrixf((GLfloat *)m);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNewList)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glNewList(list,mode)");
    }
    {
	GLuint	list = (unsigned int)SvIV(ST(0));
	GLenum	mode = (unsigned int)SvIV(ST(1));

	glNewList(list, mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3b)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glNormal3b(nx,ny,nz)");
    }
    {
	GLbyte	nx = (char)*SvPV(ST(0),na);
	GLbyte	ny = (char)*SvPV(ST(1),na);
	GLbyte	nz = (char)*SvPV(ST(2),na);

	glNormal3b(nx, ny, nz);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3bv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glNormal3bv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glNormal3bv((GLbyte *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3d)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glNormal3d(nx,ny,nz)");
    }
    {
	GLdouble	nx = (double)SvNV(ST(0));
	GLdouble	ny = (double)SvNV(ST(1));
	GLdouble	nz = (double)SvNV(ST(2));

	glNormal3d(nx, ny, nz);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glNormal3dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glNormal3dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3f)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glNormal3f(nx,ny,nz)");
    }
    {
	GLfloat	nx = (float)SvNV(ST(0));
	GLfloat	ny = (float)SvNV(ST(1));
	GLfloat	nz = (float)SvNV(ST(2));

	glNormal3f(nx, ny, nz);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glNormal3fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glNormal3fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3i)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glNormal3i(nx,ny,nz)");
    }
    {
	GLint	nx = (int)SvIV(ST(0));
	GLint	ny = (int)SvIV(ST(1));
	GLint	nz = (int)SvIV(ST(2));

	glNormal3i(nx, ny, nz);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glNormal3iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glNormal3iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3s)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glNormal3s(nx,ny,nz)");
    }
    {
	GLshort	nx = (short)SvIV(ST(0));
	GLshort	ny = (short)SvIV(ST(1));
	GLshort	nz = (short)SvIV(ST(2));

	glNormal3s(nx, ny, nz);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glNormal3sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glNormal3sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glNormal3sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glOrtho)
{
    dXSARGS;
    if (items != 6) {
	croak("Usage: OpenGL::glOrtho(left,right,bottom,top,near,far)");
    }
    {
	GLdouble	left = (double)SvNV(ST(0));
	GLdouble	right = (double)SvNV(ST(1));
	GLdouble	bottom = (double)SvNV(ST(2));
	GLdouble	top = (double)SvNV(ST(3));
	GLdouble	near = (double)SvNV(ST(4));
	GLdouble	far = (double)SvNV(ST(5));

	glOrtho(left, right, bottom, top, near, far);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPassThrough)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glPassThrough(token)");
    }
    {
	GLfloat	token = (float)SvNV(ST(0));

	glPassThrough(token);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPixelMapfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glPixelMapfv(map,mapsize,values)");
    }
    {
	GLenum	map = (unsigned int)SvIV(ST(0));
	GLint	mapsize = (int)SvIV(ST(1));
	char *	values = (char *)SvPV(ST(2),na);
	{

	   glPixelMapfv(map,mapsize,(GLfloat *)values);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPixelMapuiv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glPixelMapuiv(map,mapsize,values)");
    }
    {
	GLenum	map = (unsigned int)SvIV(ST(0));
	GLint	mapsize = (int)SvIV(ST(1));
	char *	values = (char *)SvPV(ST(2),na);
	{

	   glPixelMapuiv(map,mapsize,(GLuint *)values);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPixelMapusv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glPixelMapusv(map,mapsize,values)");
    }
    {
	GLenum	map = (unsigned int)SvIV(ST(0));
	GLint	mapsize = (int)SvIV(ST(1));
	char *	values = (char *)SvPV(ST(2),na);
	{

	   glPixelMapusv(map,mapsize,(GLushort *)values);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPixelStoref)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glPixelStoref(pname,param)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	GLfloat	param = (float)SvNV(ST(1));

	glPixelStoref(pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPixelStorei)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glPixelStorei(pname,param)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	GLint	param = (int)SvIV(ST(1));

	glPixelStorei(pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPixelTransferf)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glPixelTransferf(pname,param)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	GLfloat	param = (float)SvNV(ST(1));

	glPixelTransferf(pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPixelTransferi)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glPixelTransferi(pname,param)");
    }
    {
	GLenum	pname = (unsigned int)SvIV(ST(0));
	GLint	param = (int)SvIV(ST(1));

	glPixelTransferi(pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPixelZoom)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glPixelZoom(xfactor,yfactor)");
    }
    {
	GLfloat	xfactor = (float)SvNV(ST(0));
	GLfloat	yfactor = (float)SvNV(ST(1));

	glPixelZoom(xfactor, yfactor);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPointSize)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glPointSize(size)");
    }
    {
	GLfloat	size = (float)SvNV(ST(0));

	glPointSize(size);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPolygonMode)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glPolygonMode(face,mode)");
    }
    {
	GLenum	face = (unsigned int)SvIV(ST(0));
	GLenum	mode = (unsigned int)SvIV(ST(1));

	glPolygonMode(face, mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPolygonOffsetEXT)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glPolygonOffsetEXT(factor,bias)");
    }
    {
	GLfloat	factor = (float)SvNV(ST(0));
	GLfloat	bias = (float)SvNV(ST(1));

	glPolygonOffsetEXT(factor, bias);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPolygonStipple)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glPolygonStipple(mask)");
    }
    {
	char *	mask = (char *)SvPV(ST(0),na);
	{

	   glPolygonStipple((GLubyte *)mask);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPopAttrib)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glPopAttrib()");
    }
    {

	glPopAttrib();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPopMatrix)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glPopMatrix()");
    }
    {

	glPopMatrix();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPopName)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glPopName()");
    }
    {

	glPopName();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPushAttrib)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glPushAttrib(mask)");
    }
    {
	GLbitfield	mask = (unsigned int)SvIV(ST(0));

	glPushAttrib(mask);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPushMatrix)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glPushMatrix()");
    }
    {

	glPushMatrix();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glPushName)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glPushName(name)");
    }
    {
	GLuint	name = (unsigned int)SvIV(ST(0));

	glPushName(name);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos2d)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glRasterPos2d(x,y)");
    }
    {
	GLdouble	x = (double)SvNV(ST(0));
	GLdouble	y = (double)SvNV(ST(1));

	glRasterPos2d(x, y);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos2dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos2dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos2dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos2f)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glRasterPos2f(x,y)");
    }
    {
	GLfloat	x = (float)SvNV(ST(0));
	GLfloat	y = (float)SvNV(ST(1));

	glRasterPos2f(x, y);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos2fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos2fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos2fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos2i)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glRasterPos2i(x,y)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));

	glRasterPos2i(x, y);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos2iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos2iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos2iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos2s)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glRasterPos2s(x,y)");
    }
    {
	GLshort	x = (short)SvIV(ST(0));
	GLshort	y = (short)SvIV(ST(1));

	glRasterPos2s(x, y);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos2sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos2sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos2sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos3d)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glRasterPos3d(x,y,z)");
    }
    {
	GLdouble	x = (double)SvNV(ST(0));
	GLdouble	y = (double)SvNV(ST(1));
	GLdouble	z = (double)SvNV(ST(2));

	glRasterPos3d(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos3dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos3dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos3dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos3f)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glRasterPos3f(x,y,z)");
    }
    {
	GLfloat	x = (float)SvNV(ST(0));
	GLfloat	y = (float)SvNV(ST(1));
	GLfloat	z = (float)SvNV(ST(2));

	glRasterPos3f(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos3fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos3fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos3fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos3i)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glRasterPos3i(x,y,z)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));
	GLint	z = (int)SvIV(ST(2));

	glRasterPos3i(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos3iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos3iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos3iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos3s)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glRasterPos3s(x,y,z)");
    }
    {
	GLshort	x = (short)SvIV(ST(0));
	GLshort	y = (short)SvIV(ST(1));
	GLshort	z = (short)SvIV(ST(2));

	glRasterPos3s(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos3sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos3sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos3sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos4d)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRasterPos4d(x,y,z,w)");
    }
    {
	GLdouble	x = (double)SvNV(ST(0));
	GLdouble	y = (double)SvNV(ST(1));
	GLdouble	z = (double)SvNV(ST(2));
	GLdouble	w = (double)SvNV(ST(3));

	glRasterPos4d(x, y, z, w);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos4dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos4dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos4dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos4f)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRasterPos4f(x,y,z,w)");
    }
    {
	GLfloat	x = (float)SvNV(ST(0));
	GLfloat	y = (float)SvNV(ST(1));
	GLfloat	z = (float)SvNV(ST(2));
	GLfloat	w = (float)SvNV(ST(3));

	glRasterPos4f(x, y, z, w);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos4fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos4fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos4fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos4i)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRasterPos4i(x,y,z,w)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));
	GLint	z = (int)SvIV(ST(2));
	GLint	w = (int)SvIV(ST(3));

	glRasterPos4i(x, y, z, w);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos4iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos4iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos4iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos4s)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRasterPos4s(x,y,z,w)");
    }
    {
	GLshort	x = (short)SvIV(ST(0));
	GLshort	y = (short)SvIV(ST(1));
	GLshort	z = (short)SvIV(ST(2));
	GLshort	w = (short)SvIV(ST(3));

	glRasterPos4s(x, y, z, w);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRasterPos4sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRasterPos4sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glRasterPos4sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glReadBuffer)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glReadBuffer(mode)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));

	glReadBuffer(mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glReadPixels)
{
    dXSARGS;
    if (items != 7) {
	croak("Usage: OpenGL::glReadPixels(x,y,width,height,format,type,pixels)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));
	GLsizei	width = (int)SvIV(ST(2));
	GLsizei	height = (int)SvIV(ST(3));
	GLenum	format = (unsigned int)SvIV(ST(4));
	GLenum	type = (unsigned int)SvIV(ST(5));
	char *	pixels = (char *)SvPV(ST(6),na);
	{

	   glReadPixels(x,y,width,height,format,type,(GLvoid *)pixels);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRectd)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRectd(x1,y1,x2,y2)");
    }
    {
	GLdouble	x1 = (double)SvNV(ST(0));
	GLdouble	y1 = (double)SvNV(ST(1));
	GLdouble	x2 = (double)SvNV(ST(2));
	GLdouble	y2 = (double)SvNV(ST(3));

	glRectd(x1, y1, x2, y2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRectdv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glRectdv(v1,v2)");
    }
    {
	char *	v1 = (char *)SvPV(ST(0),na);
	char *	v2 = (char *)SvPV(ST(1),na);
	{

	   glRectdv((GLdouble *)v1,(GLdouble *)v2);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRectf)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRectf(x1,y1,x2,y2)");
    }
    {
	GLfloat	x1 = (float)SvNV(ST(0));
	GLfloat	y1 = (float)SvNV(ST(1));
	GLfloat	x2 = (float)SvNV(ST(2));
	GLfloat	y2 = (float)SvNV(ST(3));

	glRectf(x1, y1, x2, y2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRectfv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glRectfv(v1,v2)");
    }
    {
	char *	v1 = (char *)SvPV(ST(0),na);
	char *	v2 = (char *)SvPV(ST(1),na);
	{

	   glRectfv((GLfloat *)v1,(GLfloat *)v2);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRecti)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRecti(x1,y1,x2,y2)");
    }
    {
	GLint	x1 = (int)SvIV(ST(0));
	GLint	y1 = (int)SvIV(ST(1));
	GLint	x2 = (int)SvIV(ST(2));
	GLint	y2 = (int)SvIV(ST(3));

	glRecti(x1, y1, x2, y2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRectiv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glRectiv(v1,v2)");
    }
    {
	char *	v1 = (char *)SvPV(ST(0),na);
	char *	v2 = (char *)SvPV(ST(1),na);
	{

	   glRectiv((GLint *)v1,(GLint *)v2);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRects)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRects(x1,y1,x2,y2)");
    }
    {
	GLshort	x1 = (short)SvIV(ST(0));
	GLshort	y1 = (short)SvIV(ST(1));
	GLshort	x2 = (short)SvIV(ST(2));
	GLshort	y2 = (short)SvIV(ST(3));

	glRects(x1, y1, x2, y2);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRectsv)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glRectsv(v1,v2)");
    }
    {
	char *	v1 = (char *)SvPV(ST(0),na);
	char *	v2 = (char *)SvPV(ST(1),na);
	{

	   glRectsv((GLshort *)v1,(GLshort *)v2);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRenderMode)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glRenderMode(mode)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));
	GLint	RETVAL;

	RETVAL = glRenderMode(mode);
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glResetHistogramEXT)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glResetHistogramEXT(target)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));

	glResetHistogramEXT(target);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glResetMinmaxEXT)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glResetMinmaxEXT(target)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));

	glResetMinmaxEXT(target);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRotated)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRotated(angle,x,y,z)");
    }
    {
	GLdouble	angle = (double)SvNV(ST(0));
	GLdouble	x = (double)SvNV(ST(1));
	GLdouble	y = (double)SvNV(ST(2));
	GLdouble	z = (double)SvNV(ST(3));

	glRotated(angle, x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glRotatef)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glRotatef(angle,x,y,z)");
    }
    {
	GLfloat	angle = (float)SvNV(ST(0));
	GLfloat	x = (float)SvNV(ST(1));
	GLfloat	y = (float)SvNV(ST(2));
	GLfloat	z = (float)SvNV(ST(3));

	glRotatef(angle, x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glSampleMaskSGIS)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glSampleMaskSGIS(value,invert)");
    }
    {
	GLfloat	value = (float)SvNV(ST(0));
	GLboolean	invert = (unsigned char)SvIV(ST(1));

	glSampleMaskSGIS(value, invert);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glSamplePatternSGIS)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glSamplePatternSGIS(pattern)");
    }
    {
	GLenum	pattern = (unsigned int)SvIV(ST(0));

	glSamplePatternSGIS(pattern);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glScaled)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glScaled(x,y,z)");
    }
    {
	GLdouble	x = (double)SvNV(ST(0));
	GLdouble	y = (double)SvNV(ST(1));
	GLdouble	z = (double)SvNV(ST(2));

	glScaled(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glScalef)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glScalef(x,y,z)");
    }
    {
	GLfloat	x = (float)SvNV(ST(0));
	GLfloat	y = (float)SvNV(ST(1));
	GLfloat	z = (float)SvNV(ST(2));

	glScalef(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glScissor)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glScissor(x,y,width,height)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));
	GLsizei	width = (int)SvIV(ST(2));
	GLsizei	height = (int)SvIV(ST(3));

	glScissor(x, y, width, height);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glSelectBuffer)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glSelectBuffer(size,buffer)");
    }
    {
	GLsizei	size = (int)SvIV(ST(0));
	char *	buffer = (char *)SvPV(ST(1),na);
	{

	   glSelectBuffer(size,(GLuint *)buffer);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glSeparableFilter2DEXT)
{
    dXSARGS;
    if (items != 8) {
	croak("Usage: OpenGL::glSeparableFilter2DEXT(target,internalformat,width,height,format,type,row,column)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	internalformat = (unsigned int)SvIV(ST(1));
	GLsizei	width = (int)SvIV(ST(2));
	GLsizei	height = (int)SvIV(ST(3));
	GLenum	format = (unsigned int)SvIV(ST(4));
	GLenum	type = (unsigned int)SvIV(ST(5));
	char *	row = (char *)SvPV(ST(6),na);
	char *	column = (char *)SvPV(ST(7),na);
	{

	   glSeparableFilter2DEXT(target,internalformat,width,height,format,type,(GLvoid *)row,(GLvoid *)column);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glShadeModel)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glShadeModel(mode)");
    }
    {
	GLenum	mode = (unsigned int)SvIV(ST(0));

	glShadeModel(mode);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glSharpenTexFuncSGIS)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glSharpenTexFuncSGIS(target,n,points)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLsizei	n = (int)SvIV(ST(1));
	char *	points = (char *)SvPV(ST(2),na);
	{

	   glSharpenTexFuncSGIS(target,n,(GLfloat *)points);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glStencilFunc)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glStencilFunc(func,ref,mask)");
    }
    {
	GLenum	func = (unsigned int)SvIV(ST(0));
	GLint	ref = (int)SvIV(ST(1));
	GLuint	mask = (unsigned int)SvIV(ST(2));

	glStencilFunc(func, ref, mask);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glStencilMask)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glStencilMask(mask)");
    }
    {
	GLuint	mask = (unsigned int)SvIV(ST(0));

	glStencilMask(mask);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glStencilOp)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glStencilOp(fail,zfail,zpass)");
    }
    {
	GLenum	fail = (unsigned int)SvIV(ST(0));
	GLenum	zfail = (unsigned int)SvIV(ST(1));
	GLenum	zpass = (unsigned int)SvIV(ST(2));

	glStencilOp(fail, zfail, zpass);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTagSampleBufferSGIX)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: OpenGL::glTagSampleBufferSGIX()");
    }
    {

	glTagSampleBufferSGIX();
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord1d)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord1d(s)");
    }
    {
	GLdouble	s = (double)SvNV(ST(0));

	glTexCoord1d(s);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord1dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord1dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord1dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord1f)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord1f(s)");
    }
    {
	GLfloat	s = (float)SvNV(ST(0));

	glTexCoord1f(s);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord1fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord1fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord1fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord1i)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord1i(s)");
    }
    {
	GLint	s = (int)SvIV(ST(0));

	glTexCoord1i(s);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord1iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord1iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord1iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord1s)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord1s(s)");
    }
    {
	GLshort	s = (short)SvIV(ST(0));

	glTexCoord1s(s);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord1sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord1sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord1sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord2d)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glTexCoord2d(s,t)");
    }
    {
	GLdouble	s = (double)SvNV(ST(0));
	GLdouble	t = (double)SvNV(ST(1));

	glTexCoord2d(s, t);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord2dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord2dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord2dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord2f)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glTexCoord2f(s,t)");
    }
    {
	GLfloat	s = (float)SvNV(ST(0));
	GLfloat	t = (float)SvNV(ST(1));

	glTexCoord2f(s, t);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord2fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord2fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord2fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord2i)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glTexCoord2i(s,t)");
    }
    {
	GLint	s = (int)SvIV(ST(0));
	GLint	t = (int)SvIV(ST(1));

	glTexCoord2i(s, t);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord2iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord2iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord2iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord2s)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glTexCoord2s(s,t)");
    }
    {
	GLshort	s = (short)SvIV(ST(0));
	GLshort	t = (short)SvIV(ST(1));

	glTexCoord2s(s, t);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord2sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord2sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord2sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord3d)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexCoord3d(s,t,r)");
    }
    {
	GLdouble	s = (double)SvNV(ST(0));
	GLdouble	t = (double)SvNV(ST(1));
	GLdouble	r = (double)SvNV(ST(2));

	glTexCoord3d(s, t, r);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord3dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord3dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord3dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord3f)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexCoord3f(s,t,r)");
    }
    {
	GLfloat	s = (float)SvNV(ST(0));
	GLfloat	t = (float)SvNV(ST(1));
	GLfloat	r = (float)SvNV(ST(2));

	glTexCoord3f(s, t, r);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord3fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord3fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord3fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord3i)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexCoord3i(s,t,r)");
    }
    {
	GLint	s = (int)SvIV(ST(0));
	GLint	t = (int)SvIV(ST(1));
	GLint	r = (int)SvIV(ST(2));

	glTexCoord3i(s, t, r);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord3iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord3iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord3iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord3s)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexCoord3s(s,t,r)");
    }
    {
	GLshort	s = (short)SvIV(ST(0));
	GLshort	t = (short)SvIV(ST(1));
	GLshort	r = (short)SvIV(ST(2));

	glTexCoord3s(s, t, r);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord3sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord3sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord3sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord4d)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glTexCoord4d(s,t,r,q)");
    }
    {
	GLdouble	s = (double)SvNV(ST(0));
	GLdouble	t = (double)SvNV(ST(1));
	GLdouble	r = (double)SvNV(ST(2));
	GLdouble	q = (double)SvNV(ST(3));

	glTexCoord4d(s, t, r, q);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord4dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord4dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord4dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord4f)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glTexCoord4f(s,t,r,q)");
    }
    {
	GLfloat	s = (float)SvNV(ST(0));
	GLfloat	t = (float)SvNV(ST(1));
	GLfloat	r = (float)SvNV(ST(2));
	GLfloat	q = (float)SvNV(ST(3));

	glTexCoord4f(s, t, r, q);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord4fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord4fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord4fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord4i)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glTexCoord4i(s,t,r,q)");
    }
    {
	GLint	s = (int)SvIV(ST(0));
	GLint	t = (int)SvIV(ST(1));
	GLint	r = (int)SvIV(ST(2));
	GLint	q = (int)SvIV(ST(3));

	glTexCoord4i(s, t, r, q);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord4iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord4iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord4iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord4s)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glTexCoord4s(s,t,r,q)");
    }
    {
	GLshort	s = (short)SvIV(ST(0));
	GLshort	t = (short)SvIV(ST(1));
	GLshort	r = (short)SvIV(ST(2));
	GLshort	q = (short)SvIV(ST(3));

	glTexCoord4s(s, t, r, q);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexCoord4sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glTexCoord4sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glTexCoord4sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexEnvf)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexEnvf(target,pname,param)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLfloat	param = (float)SvNV(ST(2));

	glTexEnvf(target, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexEnvfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexEnvfv(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glTexEnvfv(target,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexEnvi)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexEnvi(target,pname,param)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLint	param = (int)SvIV(ST(2));

	glTexEnvi(target, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexEnviv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexEnviv(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glTexEnviv(target,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexGend)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexGend(coord,pname,param)");
    }
    {
	GLenum	coord = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLdouble	param = (double)SvNV(ST(2));

	glTexGend(coord, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexGendv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexGendv(coord,pname,params)");
    }
    {
	GLenum	coord = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glTexGendv(coord,pname,(GLdouble *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexGenf)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexGenf(coord,pname,param)");
    }
    {
	GLenum	coord = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLfloat	param = (float)SvNV(ST(2));

	glTexGenf(coord, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexGenfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexGenfv(coord,pname,params)");
    }
    {
	GLenum	coord = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glTexGenfv(coord,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexGeni)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexGeni(coord,pname,param)");
    }
    {
	GLenum	coord = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLint	param = (int)SvIV(ST(2));

	glTexGeni(coord, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexGeniv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexGeniv(coord,pname,params)");
    }
    {
	GLenum	coord = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glTexGeniv(coord,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexImage1D)
{
    dXSARGS;
    if (items != 8) {
	croak("Usage: OpenGL::glTexImage1D(target,level,components,width,border,format,type,pixels)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLint	level = (int)SvIV(ST(1));
	GLint	components = (int)SvIV(ST(2));
	GLsizei	width = (int)SvIV(ST(3));
	GLint	border = (int)SvIV(ST(4));
	GLenum	format = (unsigned int)SvIV(ST(5));
	GLenum	type = (unsigned int)SvIV(ST(6));
	char *	pixels = (char *)SvPV(ST(7),na);
	{

	   glTexImage1D(target,level,components,width,border,format,type,(GLvoid *)pixels);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexImage2D)
{
    dXSARGS;
    if (items != 9) {
	croak("Usage: OpenGL::glTexImage2D(target,level,components,width,height,border,format,type,pixels)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLint	level = (int)SvIV(ST(1));
	GLint	components = (int)SvIV(ST(2));
	GLsizei	width = (int)SvIV(ST(3));
	GLsizei	height = (int)SvIV(ST(4));
	GLint	border = (int)SvIV(ST(5));
	GLenum	format = (unsigned int)SvIV(ST(6));
	GLenum	type = (unsigned int)SvIV(ST(7));
	char *	pixels = (char *)SvPV(ST(8),na);
	{

	   glTexImage2D(target,level,components,width,height,border,format,type,(GLvoid *)pixels);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexImage3DEXT)
{
    dXSARGS;
    if (items != 10) {
	croak("Usage: OpenGL::glTexImage3DEXT(target,level,internalformat,width,height,depth,border,format,type,pixels)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLint	level = (int)SvIV(ST(1));
	GLenum	internalformat = (unsigned int)SvIV(ST(2));
	GLsizei	width = (int)SvIV(ST(3));
	GLsizei	height = (int)SvIV(ST(4));
	GLsizei	depth = (int)SvIV(ST(5));
	GLint	border = (int)SvIV(ST(6));
	GLenum	format = (unsigned int)SvIV(ST(7));
	GLenum	type = (unsigned int)SvIV(ST(8));
	char *	pixels = (char *)SvPV(ST(9),na);
	{

	   glTexImage3DEXT(target,level,internalformat,width,height,depth,border,format,type,(GLvoid *)pixels);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexParameterf)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexParameterf(target,pname,param)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLfloat	param = (float)SvNV(ST(2));

	glTexParameterf(target, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexParameterfv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexParameterfv(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glTexParameterfv(target,pname,(GLfloat *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexParameteri)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexParameteri(target,pname,param)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	GLint	param = (int)SvIV(ST(2));

	glTexParameteri(target, pname, param);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexParameteriv)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTexParameteriv(target,pname,params)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLenum	pname = (unsigned int)SvIV(ST(1));
	char *	params = (char *)SvPV(ST(2),na);
	{

	   glTexParameteriv(target,pname,(GLint *)params);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexSubImage1DEXT)
{
    dXSARGS;
    if (items != 7) {
	croak("Usage: OpenGL::glTexSubImage1DEXT(target,level,xoffset,width,format,type,pixels)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLint	level = (int)SvIV(ST(1));
	GLint	xoffset = (int)SvIV(ST(2));
	GLsizei	width = (int)SvIV(ST(3));
	GLenum	format = (unsigned int)SvIV(ST(4));
	GLenum	type = (unsigned int)SvIV(ST(5));
	char *	pixels = (char *)SvPV(ST(6),na);
	{

	   glTexSubImage1DEXT(target,level,xoffset,width,format,type,(GLvoid *)pixels);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexSubImage2DEXT)
{
    dXSARGS;
    if (items != 9) {
	croak("Usage: OpenGL::glTexSubImage2DEXT(target,level,xoffset,yoffset,width,height,format,type,pixels)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLint	level = (int)SvIV(ST(1));
	GLint	xoffset = (int)SvIV(ST(2));
	GLint	yoffset = (int)SvIV(ST(3));
	GLsizei	width = (int)SvIV(ST(4));
	GLsizei	height = (int)SvIV(ST(5));
	GLenum	format = (unsigned int)SvIV(ST(6));
	GLenum	type = (unsigned int)SvIV(ST(7));
	char *	pixels = (char *)SvPV(ST(8),na);
	{

	   glTexSubImage2DEXT(target,level,xoffset,yoffset,width,height,format,type,(GLvoid *)pixels);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTexSubImage3DEXT)
{
    dXSARGS;
    if (items != 11) {
	croak("Usage: OpenGL::glTexSubImage3DEXT(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,pixels)");
    }
    {
	GLenum	target = (unsigned int)SvIV(ST(0));
	GLint	level = (int)SvIV(ST(1));
	GLsizei	xoffset = (int)SvIV(ST(2));
	GLsizei	yoffset = (int)SvIV(ST(3));
	GLsizei	zoffset = (int)SvIV(ST(4));
	GLsizei	width = (int)SvIV(ST(5));
	GLsizei	height = (int)SvIV(ST(6));
	GLsizei	depth = (int)SvIV(ST(7));
	GLenum	format = (unsigned int)SvIV(ST(8));
	GLenum	type = (unsigned int)SvIV(ST(9));
	char *	pixels = (char *)SvPV(ST(10),na);
	{

	   glTexSubImage3DEXT(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,(GLvoid *)pixels);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTranslated)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTranslated(x,y,z)");
    }
    {
	GLdouble	x = (double)SvNV(ST(0));
	GLdouble	y = (double)SvNV(ST(1));
	GLdouble	z = (double)SvNV(ST(2));

	glTranslated(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glTranslatef)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glTranslatef(x,y,z)");
    }
    {
	GLfloat	x = (float)SvNV(ST(0));
	GLfloat	y = (float)SvNV(ST(1));
	GLfloat	z = (float)SvNV(ST(2));

	glTranslatef(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex2d)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glVertex2d(x,y)");
    }
    {
	GLdouble	x = (double)SvNV(ST(0));
	GLdouble	y = (double)SvNV(ST(1));

	glVertex2d(x, y);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex2dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex2dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex2dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex2f)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glVertex2f(x,y)");
    }
    {
	GLfloat	x = (float)SvNV(ST(0));
	GLfloat	y = (float)SvNV(ST(1));

	glVertex2f(x, y);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex2fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex2fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex2fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex2i)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glVertex2i(x,y)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));

	glVertex2i(x, y);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex2iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex2iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex2iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex2s)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: OpenGL::glVertex2s(x,y)");
    }
    {
	GLshort	x = (short)SvIV(ST(0));
	GLshort	y = (short)SvIV(ST(1));

	glVertex2s(x, y);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex2sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex2sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex2sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex3d)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glVertex3d(x,y,z)");
    }
    {
	GLdouble	x = (double)SvNV(ST(0));
	GLdouble	y = (double)SvNV(ST(1));
	GLdouble	z = (double)SvNV(ST(2));

	glVertex3d(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex3dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex3dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex3dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex3f)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glVertex3f(x,y,z)");
    }
    {
	GLfloat	x = (float)SvNV(ST(0));
	GLfloat	y = (float)SvNV(ST(1));
	GLfloat	z = (float)SvNV(ST(2));

	glVertex3f(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex3fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex3fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex3fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex3i)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glVertex3i(x,y,z)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));
	GLint	z = (int)SvIV(ST(2));

	glVertex3i(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex3iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex3iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex3iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex3s)
{
    dXSARGS;
    if (items != 3) {
	croak("Usage: OpenGL::glVertex3s(x,y,z)");
    }
    {
	GLshort	x = (short)SvIV(ST(0));
	GLshort	y = (short)SvIV(ST(1));
	GLshort	z = (short)SvIV(ST(2));

	glVertex3s(x, y, z);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex3sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex3sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex3sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex4d)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glVertex4d(x,y,z,w)");
    }
    {
	GLdouble	x = (double)SvNV(ST(0));
	GLdouble	y = (double)SvNV(ST(1));
	GLdouble	z = (double)SvNV(ST(2));
	GLdouble	w = (double)SvNV(ST(3));

	glVertex4d(x, y, z, w);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex4dv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex4dv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex4dv((GLdouble *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex4f)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glVertex4f(x,y,z,w)");
    }
    {
	GLfloat	x = (float)SvNV(ST(0));
	GLfloat	y = (float)SvNV(ST(1));
	GLfloat	z = (float)SvNV(ST(2));
	GLfloat	w = (float)SvNV(ST(3));

	glVertex4f(x, y, z, w);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex4fv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex4fv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex4fv((GLfloat *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex4i)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glVertex4i(x,y,z,w)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));
	GLint	z = (int)SvIV(ST(2));
	GLint	w = (int)SvIV(ST(3));

	glVertex4i(x, y, z, w);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex4iv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex4iv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex4iv((GLint *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex4s)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glVertex4s(x,y,z,w)");
    }
    {
	GLshort	x = (short)SvIV(ST(0));
	GLshort	y = (short)SvIV(ST(1));
	GLshort	z = (short)SvIV(ST(2));
	GLshort	w = (short)SvIV(ST(3));

	glVertex4s(x, y, z, w);
    }
    XSRETURN(1);
}

XS(XS_OpenGL_glVertex4sv)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: OpenGL::glVertex4sv(v)");
    }
    {
	char *	v = (char *)SvPV(ST(0),na);
	{

	   glVertex4sv((GLshort *)v);

	}

    }
    XSRETURN(1);
}

XS(XS_OpenGL_glViewport)
{
    dXSARGS;
    if (items != 4) {
	croak("Usage: OpenGL::glViewport(x,y,width,height)");
    }
    {
	GLint	x = (int)SvIV(ST(0));
	GLint	y = (int)SvIV(ST(1));
	GLsizei	width = (int)SvIV(ST(2));
	GLsizei	height = (int)SvIV(ST(3));

	glViewport(x, y, width, height);
    }
    XSRETURN(1);
}

XS(boot_OpenGL)
{
    dXSARGS;
    char* file = __FILE__;

    newXS("OpenGL::glpOpenWindow", XS_OpenGL_glpOpenWindow, file);
    newXS("OpenGL::glXSwapBuffers", XS_OpenGL_glXSwapBuffers, file);
    newXS("OpenGL::glpClipPlane", XS_OpenGL_glpClipPlane, file);
    newXS("OpenGL::glpGetClipPlane", XS_OpenGL_glpGetClipPlane, file);
    newXS("OpenGL::glpReadTex", XS_OpenGL_glpReadTex, file);
    newXS("OpenGL::glpLoadMatrixd", XS_OpenGL_glpLoadMatrixd, file);
    newXS("OpenGL::glpMultMatrixd", XS_OpenGL_glpMultMatrixd, file);
    newXS("OpenGL::glpLoadMatrixf", XS_OpenGL_glpLoadMatrixf, file);
    newXS("OpenGL::glpMultMatrixf", XS_OpenGL_glpMultMatrixf, file);
    newXS("OpenGL::gluOrtho2D", XS_OpenGL_gluOrtho2D, file);
    newXS("OpenGL::gluPerspective", XS_OpenGL_gluPerspective, file);
    newXS("OpenGL::gluLookAt", XS_OpenGL_gluLookAt, file);
    newXS("OpenGL::glAccum", XS_OpenGL_glAccum, file);
    newXS("OpenGL::glAlphaFunc", XS_OpenGL_glAlphaFunc, file);
    newXS("OpenGL::glBegin", XS_OpenGL_glBegin, file);
    newXS("OpenGL::glBitmap", XS_OpenGL_glBitmap, file);
    newXS("OpenGL::glBlendColorEXT", XS_OpenGL_glBlendColorEXT, file);
    newXS("OpenGL::glBlendEquationEXT", XS_OpenGL_glBlendEquationEXT, file);
    newXS("OpenGL::glBlendFunc", XS_OpenGL_glBlendFunc, file);
    newXS("OpenGL::glCallList", XS_OpenGL_glCallList, file);
    newXS("OpenGL::glCallLists", XS_OpenGL_glCallLists, file);
    newXS("OpenGL::glClear", XS_OpenGL_glClear, file);
    newXS("OpenGL::glClearAccum", XS_OpenGL_glClearAccum, file);
    newXS("OpenGL::glClearColor", XS_OpenGL_glClearColor, file);
    newXS("OpenGL::glClearDepth", XS_OpenGL_glClearDepth, file);
    newXS("OpenGL::glClearIndex", XS_OpenGL_glClearIndex, file);
    newXS("OpenGL::glClearStencil", XS_OpenGL_glClearStencil, file);
    newXS("OpenGL::glClipPlane", XS_OpenGL_glClipPlane, file);
    newXS("OpenGL::glColor3b", XS_OpenGL_glColor3b, file);
    newXS("OpenGL::glColor3bv", XS_OpenGL_glColor3bv, file);
    newXS("OpenGL::glColor3d", XS_OpenGL_glColor3d, file);
    newXS("OpenGL::glColor3dv", XS_OpenGL_glColor3dv, file);
    newXS("OpenGL::glColor3f", XS_OpenGL_glColor3f, file);
    newXS("OpenGL::glColor3fv", XS_OpenGL_glColor3fv, file);
    newXS("OpenGL::glColor3i", XS_OpenGL_glColor3i, file);
    newXS("OpenGL::glColor3iv", XS_OpenGL_glColor3iv, file);
    newXS("OpenGL::glColor3s", XS_OpenGL_glColor3s, file);
    newXS("OpenGL::glColor3sv", XS_OpenGL_glColor3sv, file);
    newXS("OpenGL::glColor3ub", XS_OpenGL_glColor3ub, file);
    newXS("OpenGL::glColor3ubv", XS_OpenGL_glColor3ubv, file);
    newXS("OpenGL::glColor3ui", XS_OpenGL_glColor3ui, file);
    newXS("OpenGL::glColor3uiv", XS_OpenGL_glColor3uiv, file);
    newXS("OpenGL::glColor3us", XS_OpenGL_glColor3us, file);
    newXS("OpenGL::glColor3usv", XS_OpenGL_glColor3usv, file);
    newXS("OpenGL::glColor4b", XS_OpenGL_glColor4b, file);
    newXS("OpenGL::glColor4bv", XS_OpenGL_glColor4bv, file);
    newXS("OpenGL::glColor4d", XS_OpenGL_glColor4d, file);
    newXS("OpenGL::glColor4dv", XS_OpenGL_glColor4dv, file);
    newXS("OpenGL::glColor4f", XS_OpenGL_glColor4f, file);
    newXS("OpenGL::glColor4fv", XS_OpenGL_glColor4fv, file);
    newXS("OpenGL::glColor4i", XS_OpenGL_glColor4i, file);
    newXS("OpenGL::glColor4iv", XS_OpenGL_glColor4iv, file);
    newXS("OpenGL::glColor4s", XS_OpenGL_glColor4s, file);
    newXS("OpenGL::glColor4sv", XS_OpenGL_glColor4sv, file);
    newXS("OpenGL::glColor4ub", XS_OpenGL_glColor4ub, file);
    newXS("OpenGL::glColor4ubv", XS_OpenGL_glColor4ubv, file);
    newXS("OpenGL::glColor4ui", XS_OpenGL_glColor4ui, file);
    newXS("OpenGL::glColor4uiv", XS_OpenGL_glColor4uiv, file);
    newXS("OpenGL::glColor4us", XS_OpenGL_glColor4us, file);
    newXS("OpenGL::glColor4usv", XS_OpenGL_glColor4usv, file);
    newXS("OpenGL::glColorMask", XS_OpenGL_glColorMask, file);
    newXS("OpenGL::glColorMaterial", XS_OpenGL_glColorMaterial, file);
    newXS("OpenGL::glConvolutionFilter1DEXT", XS_OpenGL_glConvolutionFilter1DEXT, file);
    newXS("OpenGL::glConvolutionFilter2DEXT", XS_OpenGL_glConvolutionFilter2DEXT, file);
    newXS("OpenGL::glConvolutionParameterfEXT", XS_OpenGL_glConvolutionParameterfEXT, file);
    newXS("OpenGL::glConvolutionParameterfvEXT", XS_OpenGL_glConvolutionParameterfvEXT, file);
    newXS("OpenGL::glConvolutionParameteriEXT", XS_OpenGL_glConvolutionParameteriEXT, file);
    newXS("OpenGL::glConvolutionParameterivEXT", XS_OpenGL_glConvolutionParameterivEXT, file);
    newXS("OpenGL::glCopyConvolutionFilter1DEXT", XS_OpenGL_glCopyConvolutionFilter1DEXT, file);
    newXS("OpenGL::glCopyConvolutionFilter2DEXT", XS_OpenGL_glCopyConvolutionFilter2DEXT, file);
    newXS("OpenGL::glCopyPixels", XS_OpenGL_glCopyPixels, file);
    newXS("OpenGL::glCullFace", XS_OpenGL_glCullFace, file);
    newXS("OpenGL::glDeleteLists", XS_OpenGL_glDeleteLists, file);
    newXS("OpenGL::glDepthFunc", XS_OpenGL_glDepthFunc, file);
    newXS("OpenGL::glDepthMask", XS_OpenGL_glDepthMask, file);
    newXS("OpenGL::glDepthRange", XS_OpenGL_glDepthRange, file);
    newXS("OpenGL::glDetailTexFuncSGIS", XS_OpenGL_glDetailTexFuncSGIS, file);
    newXS("OpenGL::glDisable", XS_OpenGL_glDisable, file);
    newXS("OpenGL::glDrawBuffer", XS_OpenGL_glDrawBuffer, file);
    newXS("OpenGL::glDrawPixels", XS_OpenGL_glDrawPixels, file);
    newXS("OpenGL::glEdgeFlag", XS_OpenGL_glEdgeFlag, file);
    newXS("OpenGL::glEdgeFlagv", XS_OpenGL_glEdgeFlagv, file);
    newXS("OpenGL::glEnable", XS_OpenGL_glEnable, file);
    newXS("OpenGL::glEnd", XS_OpenGL_glEnd, file);
    newXS("OpenGL::glEndList", XS_OpenGL_glEndList, file);
    newXS("OpenGL::glEvalCoord1d", XS_OpenGL_glEvalCoord1d, file);
    newXS("OpenGL::glEvalCoord1dv", XS_OpenGL_glEvalCoord1dv, file);
    newXS("OpenGL::glEvalCoord1f", XS_OpenGL_glEvalCoord1f, file);
    newXS("OpenGL::glEvalCoord1fv", XS_OpenGL_glEvalCoord1fv, file);
    newXS("OpenGL::glEvalCoord2d", XS_OpenGL_glEvalCoord2d, file);
    newXS("OpenGL::glEvalCoord2dv", XS_OpenGL_glEvalCoord2dv, file);
    newXS("OpenGL::glEvalCoord2f", XS_OpenGL_glEvalCoord2f, file);
    newXS("OpenGL::glEvalCoord2fv", XS_OpenGL_glEvalCoord2fv, file);
    newXS("OpenGL::glEvalMesh1", XS_OpenGL_glEvalMesh1, file);
    newXS("OpenGL::glEvalMesh2", XS_OpenGL_glEvalMesh2, file);
    newXS("OpenGL::glEvalPoint1", XS_OpenGL_glEvalPoint1, file);
    newXS("OpenGL::glEvalPoint2", XS_OpenGL_glEvalPoint2, file);
    newXS("OpenGL::glFeedbackBuffer", XS_OpenGL_glFeedbackBuffer, file);
    newXS("OpenGL::glFinish", XS_OpenGL_glFinish, file);
    newXS("OpenGL::glFlush", XS_OpenGL_glFlush, file);
    newXS("OpenGL::glFogf", XS_OpenGL_glFogf, file);
    newXS("OpenGL::glFogfv", XS_OpenGL_glFogfv, file);
    newXS("OpenGL::glFogi", XS_OpenGL_glFogi, file);
    newXS("OpenGL::glFogiv", XS_OpenGL_glFogiv, file);
    newXS("OpenGL::glFrontFace", XS_OpenGL_glFrontFace, file);
    newXS("OpenGL::glFrustum", XS_OpenGL_glFrustum, file);
    newXS("OpenGL::glGenLists", XS_OpenGL_glGenLists, file);
    newXS("OpenGL::glGetBooleanv", XS_OpenGL_glGetBooleanv, file);
    newXS("OpenGL::glGetClipPlane", XS_OpenGL_glGetClipPlane, file);
    newXS("OpenGL::glGetConvolutionFilterEXT", XS_OpenGL_glGetConvolutionFilterEXT, file);
    newXS("OpenGL::glGetConvolutionParameterfvEXT", XS_OpenGL_glGetConvolutionParameterfvEXT, file);
    newXS("OpenGL::glGetConvolutionParameterivEXT", XS_OpenGL_glGetConvolutionParameterivEXT, file);
    newXS("OpenGL::glGetDetailTexFuncSGIS", XS_OpenGL_glGetDetailTexFuncSGIS, file);
    newXS("OpenGL::glGetDoublev", XS_OpenGL_glGetDoublev, file);
    newXS("OpenGL::glGetError", XS_OpenGL_glGetError, file);
    newXS("OpenGL::glGetFloatv", XS_OpenGL_glGetFloatv, file);
    newXS("OpenGL::glGetHistogramEXT", XS_OpenGL_glGetHistogramEXT, file);
    newXS("OpenGL::glGetHistogramParameterfvEXT", XS_OpenGL_glGetHistogramParameterfvEXT, file);
    newXS("OpenGL::glGetHistogramParameterivEXT", XS_OpenGL_glGetHistogramParameterivEXT, file);
    newXS("OpenGL::glGetIntegerv", XS_OpenGL_glGetIntegerv, file);
    newXS("OpenGL::glGetLightfv", XS_OpenGL_glGetLightfv, file);
    newXS("OpenGL::glGetLightiv", XS_OpenGL_glGetLightiv, file);
    newXS("OpenGL::glGetMapdv", XS_OpenGL_glGetMapdv, file);
    newXS("OpenGL::glGetMapfv", XS_OpenGL_glGetMapfv, file);
    newXS("OpenGL::glGetMapiv", XS_OpenGL_glGetMapiv, file);
    newXS("OpenGL::glGetMaterialfv", XS_OpenGL_glGetMaterialfv, file);
    newXS("OpenGL::glGetMaterialiv", XS_OpenGL_glGetMaterialiv, file);
    newXS("OpenGL::glGetMinmaxEXT", XS_OpenGL_glGetMinmaxEXT, file);
    newXS("OpenGL::glGetMinmaxParameterfvEXT", XS_OpenGL_glGetMinmaxParameterfvEXT, file);
    newXS("OpenGL::glGetMinmaxParameterivEXT", XS_OpenGL_glGetMinmaxParameterivEXT, file);
    newXS("OpenGL::glGetPixelMapfv", XS_OpenGL_glGetPixelMapfv, file);
    newXS("OpenGL::glGetPixelMapuiv", XS_OpenGL_glGetPixelMapuiv, file);
    newXS("OpenGL::glGetPixelMapusv", XS_OpenGL_glGetPixelMapusv, file);
    newXS("OpenGL::glGetPolygonStipple", XS_OpenGL_glGetPolygonStipple, file);
    newXS("OpenGL::glGetSeparableFilterEXT", XS_OpenGL_glGetSeparableFilterEXT, file);
    newXS("OpenGL::glGetSharpenTexFuncSGIS", XS_OpenGL_glGetSharpenTexFuncSGIS, file);
    newXS("OpenGL::glGetTexEnvfv", XS_OpenGL_glGetTexEnvfv, file);
    newXS("OpenGL::glGetTexEnviv", XS_OpenGL_glGetTexEnviv, file);
    newXS("OpenGL::glGetTexGendv", XS_OpenGL_glGetTexGendv, file);
    newXS("OpenGL::glGetTexGenfv", XS_OpenGL_glGetTexGenfv, file);
    newXS("OpenGL::glGetTexGeniv", XS_OpenGL_glGetTexGeniv, file);
    newXS("OpenGL::glGetTexImage", XS_OpenGL_glGetTexImage, file);
    newXS("OpenGL::glGetTexLevelParameterfv", XS_OpenGL_glGetTexLevelParameterfv, file);
    newXS("OpenGL::glGetTexLevelParameteriv", XS_OpenGL_glGetTexLevelParameteriv, file);
    newXS("OpenGL::glGetTexParameterfv", XS_OpenGL_glGetTexParameterfv, file);
    newXS("OpenGL::glGetTexParameteriv", XS_OpenGL_glGetTexParameteriv, file);
    newXS("OpenGL::glHint", XS_OpenGL_glHint, file);
    newXS("OpenGL::glHistogramEXT", XS_OpenGL_glHistogramEXT, file);
    newXS("OpenGL::glIndexMask", XS_OpenGL_glIndexMask, file);
    newXS("OpenGL::glIndexd", XS_OpenGL_glIndexd, file);
    newXS("OpenGL::glIndexdv", XS_OpenGL_glIndexdv, file);
    newXS("OpenGL::glIndexf", XS_OpenGL_glIndexf, file);
    newXS("OpenGL::glIndexfv", XS_OpenGL_glIndexfv, file);
    newXS("OpenGL::glIndexi", XS_OpenGL_glIndexi, file);
    newXS("OpenGL::glIndexiv", XS_OpenGL_glIndexiv, file);
    newXS("OpenGL::glIndexs", XS_OpenGL_glIndexs, file);
    newXS("OpenGL::glIndexsv", XS_OpenGL_glIndexsv, file);
    newXS("OpenGL::glInitNames", XS_OpenGL_glInitNames, file);
    newXS("OpenGL::glIsEnabled", XS_OpenGL_glIsEnabled, file);
    newXS("OpenGL::glIsList", XS_OpenGL_glIsList, file);
    newXS("OpenGL::glLightModelf", XS_OpenGL_glLightModelf, file);
    newXS("OpenGL::glLightModelfv", XS_OpenGL_glLightModelfv, file);
    newXS("OpenGL::glLightModeli", XS_OpenGL_glLightModeli, file);
    newXS("OpenGL::glLightModeliv", XS_OpenGL_glLightModeliv, file);
    newXS("OpenGL::glLightf", XS_OpenGL_glLightf, file);
    newXS("OpenGL::glLightfv", XS_OpenGL_glLightfv, file);
    newXS("OpenGL::glLighti", XS_OpenGL_glLighti, file);
    newXS("OpenGL::glLightiv", XS_OpenGL_glLightiv, file);
    newXS("OpenGL::glLineStipple", XS_OpenGL_glLineStipple, file);
    newXS("OpenGL::glLineWidth", XS_OpenGL_glLineWidth, file);
    newXS("OpenGL::glListBase", XS_OpenGL_glListBase, file);
    newXS("OpenGL::glLoadIdentity", XS_OpenGL_glLoadIdentity, file);
    newXS("OpenGL::glLoadMatrixd", XS_OpenGL_glLoadMatrixd, file);
    newXS("OpenGL::glLoadMatrixf", XS_OpenGL_glLoadMatrixf, file);
    newXS("OpenGL::glLoadName", XS_OpenGL_glLoadName, file);
    newXS("OpenGL::glLogicOp", XS_OpenGL_glLogicOp, file);
    newXS("OpenGL::glMap1d", XS_OpenGL_glMap1d, file);
    newXS("OpenGL::glMap1f", XS_OpenGL_glMap1f, file);
    newXS("OpenGL::glMap2d", XS_OpenGL_glMap2d, file);
    newXS("OpenGL::glMap2f", XS_OpenGL_glMap2f, file);
    newXS("OpenGL::glMapGrid1d", XS_OpenGL_glMapGrid1d, file);
    newXS("OpenGL::glMapGrid1f", XS_OpenGL_glMapGrid1f, file);
    newXS("OpenGL::glMapGrid2d", XS_OpenGL_glMapGrid2d, file);
    newXS("OpenGL::glMapGrid2f", XS_OpenGL_glMapGrid2f, file);
    newXS("OpenGL::glMaterialf", XS_OpenGL_glMaterialf, file);
    newXS("OpenGL::glMaterialfv", XS_OpenGL_glMaterialfv, file);
    newXS("OpenGL::glMateriali", XS_OpenGL_glMateriali, file);
    newXS("OpenGL::glMaterialiv", XS_OpenGL_glMaterialiv, file);
    newXS("OpenGL::glMatrixMode", XS_OpenGL_glMatrixMode, file);
    newXS("OpenGL::glMinmaxEXT", XS_OpenGL_glMinmaxEXT, file);
    newXS("OpenGL::glMultMatrixd", XS_OpenGL_glMultMatrixd, file);
    newXS("OpenGL::glMultMatrixf", XS_OpenGL_glMultMatrixf, file);
    newXS("OpenGL::glNewList", XS_OpenGL_glNewList, file);
    newXS("OpenGL::glNormal3b", XS_OpenGL_glNormal3b, file);
    newXS("OpenGL::glNormal3bv", XS_OpenGL_glNormal3bv, file);
    newXS("OpenGL::glNormal3d", XS_OpenGL_glNormal3d, file);
    newXS("OpenGL::glNormal3dv", XS_OpenGL_glNormal3dv, file);
    newXS("OpenGL::glNormal3f", XS_OpenGL_glNormal3f, file);
    newXS("OpenGL::glNormal3fv", XS_OpenGL_glNormal3fv, file);
    newXS("OpenGL::glNormal3i", XS_OpenGL_glNormal3i, file);
    newXS("OpenGL::glNormal3iv", XS_OpenGL_glNormal3iv, file);
    newXS("OpenGL::glNormal3s", XS_OpenGL_glNormal3s, file);
    newXS("OpenGL::glNormal3sv", XS_OpenGL_glNormal3sv, file);
    newXS("OpenGL::glOrtho", XS_OpenGL_glOrtho, file);
    newXS("OpenGL::glPassThrough", XS_OpenGL_glPassThrough, file);
    newXS("OpenGL::glPixelMapfv", XS_OpenGL_glPixelMapfv, file);
    newXS("OpenGL::glPixelMapuiv", XS_OpenGL_glPixelMapuiv, file);
    newXS("OpenGL::glPixelMapusv", XS_OpenGL_glPixelMapusv, file);
    newXS("OpenGL::glPixelStoref", XS_OpenGL_glPixelStoref, file);
    newXS("OpenGL::glPixelStorei", XS_OpenGL_glPixelStorei, file);
    newXS("OpenGL::glPixelTransferf", XS_OpenGL_glPixelTransferf, file);
    newXS("OpenGL::glPixelTransferi", XS_OpenGL_glPixelTransferi, file);
    newXS("OpenGL::glPixelZoom", XS_OpenGL_glPixelZoom, file);
    newXS("OpenGL::glPointSize", XS_OpenGL_glPointSize, file);
    newXS("OpenGL::glPolygonMode", XS_OpenGL_glPolygonMode, file);
    newXS("OpenGL::glPolygonOffsetEXT", XS_OpenGL_glPolygonOffsetEXT, file);
    newXS("OpenGL::glPolygonStipple", XS_OpenGL_glPolygonStipple, file);
    newXS("OpenGL::glPopAttrib", XS_OpenGL_glPopAttrib, file);
    newXS("OpenGL::glPopMatrix", XS_OpenGL_glPopMatrix, file);
    newXS("OpenGL::glPopName", XS_OpenGL_glPopName, file);
    newXS("OpenGL::glPushAttrib", XS_OpenGL_glPushAttrib, file);
    newXS("OpenGL::glPushMatrix", XS_OpenGL_glPushMatrix, file);
    newXS("OpenGL::glPushName", XS_OpenGL_glPushName, file);
    newXS("OpenGL::glRasterPos2d", XS_OpenGL_glRasterPos2d, file);
    newXS("OpenGL::glRasterPos2dv", XS_OpenGL_glRasterPos2dv, file);
    newXS("OpenGL::glRasterPos2f", XS_OpenGL_glRasterPos2f, file);
    newXS("OpenGL::glRasterPos2fv", XS_OpenGL_glRasterPos2fv, file);
    newXS("OpenGL::glRasterPos2i", XS_OpenGL_glRasterPos2i, file);
    newXS("OpenGL::glRasterPos2iv", XS_OpenGL_glRasterPos2iv, file);
    newXS("OpenGL::glRasterPos2s", XS_OpenGL_glRasterPos2s, file);
    newXS("OpenGL::glRasterPos2sv", XS_OpenGL_glRasterPos2sv, file);
    newXS("OpenGL::glRasterPos3d", XS_OpenGL_glRasterPos3d, file);
    newXS("OpenGL::glRasterPos3dv", XS_OpenGL_glRasterPos3dv, file);
    newXS("OpenGL::glRasterPos3f", XS_OpenGL_glRasterPos3f, file);
    newXS("OpenGL::glRasterPos3fv", XS_OpenGL_glRasterPos3fv, file);
    newXS("OpenGL::glRasterPos3i", XS_OpenGL_glRasterPos3i, file);
    newXS("OpenGL::glRasterPos3iv", XS_OpenGL_glRasterPos3iv, file);
    newXS("OpenGL::glRasterPos3s", XS_OpenGL_glRasterPos3s, file);
    newXS("OpenGL::glRasterPos3sv", XS_OpenGL_glRasterPos3sv, file);
    newXS("OpenGL::glRasterPos4d", XS_OpenGL_glRasterPos4d, file);
    newXS("OpenGL::glRasterPos4dv", XS_OpenGL_glRasterPos4dv, file);
    newXS("OpenGL::glRasterPos4f", XS_OpenGL_glRasterPos4f, file);
    newXS("OpenGL::glRasterPos4fv", XS_OpenGL_glRasterPos4fv, file);
    newXS("OpenGL::glRasterPos4i", XS_OpenGL_glRasterPos4i, file);
    newXS("OpenGL::glRasterPos4iv", XS_OpenGL_glRasterPos4iv, file);
    newXS("OpenGL::glRasterPos4s", XS_OpenGL_glRasterPos4s, file);
    newXS("OpenGL::glRasterPos4sv", XS_OpenGL_glRasterPos4sv, file);
    newXS("OpenGL::glReadBuffer", XS_OpenGL_glReadBuffer, file);
    newXS("OpenGL::glReadPixels", XS_OpenGL_glReadPixels, file);
    newXS("OpenGL::glRectd", XS_OpenGL_glRectd, file);
    newXS("OpenGL::glRectdv", XS_OpenGL_glRectdv, file);
    newXS("OpenGL::glRectf", XS_OpenGL_glRectf, file);
    newXS("OpenGL::glRectfv", XS_OpenGL_glRectfv, file);
    newXS("OpenGL::glRecti", XS_OpenGL_glRecti, file);
    newXS("OpenGL::glRectiv", XS_OpenGL_glRectiv, file);
    newXS("OpenGL::glRects", XS_OpenGL_glRects, file);
    newXS("OpenGL::glRectsv", XS_OpenGL_glRectsv, file);
    newXS("OpenGL::glRenderMode", XS_OpenGL_glRenderMode, file);
    newXS("OpenGL::glResetHistogramEXT", XS_OpenGL_glResetHistogramEXT, file);
    newXS("OpenGL::glResetMinmaxEXT", XS_OpenGL_glResetMinmaxEXT, file);
    newXS("OpenGL::glRotated", XS_OpenGL_glRotated, file);
    newXS("OpenGL::glRotatef", XS_OpenGL_glRotatef, file);
    newXS("OpenGL::glSampleMaskSGIS", XS_OpenGL_glSampleMaskSGIS, file);
    newXS("OpenGL::glSamplePatternSGIS", XS_OpenGL_glSamplePatternSGIS, file);
    newXS("OpenGL::glScaled", XS_OpenGL_glScaled, file);
    newXS("OpenGL::glScalef", XS_OpenGL_glScalef, file);
    newXS("OpenGL::glScissor", XS_OpenGL_glScissor, file);
    newXS("OpenGL::glSelectBuffer", XS_OpenGL_glSelectBuffer, file);
    newXS("OpenGL::glSeparableFilter2DEXT", XS_OpenGL_glSeparableFilter2DEXT, file);
    newXS("OpenGL::glShadeModel", XS_OpenGL_glShadeModel, file);
    newXS("OpenGL::glSharpenTexFuncSGIS", XS_OpenGL_glSharpenTexFuncSGIS, file);
    newXS("OpenGL::glStencilFunc", XS_OpenGL_glStencilFunc, file);
    newXS("OpenGL::glStencilMask", XS_OpenGL_glStencilMask, file);
    newXS("OpenGL::glStencilOp", XS_OpenGL_glStencilOp, file);
    newXS("OpenGL::glTagSampleBufferSGIX", XS_OpenGL_glTagSampleBufferSGIX, file);
    newXS("OpenGL::glTexCoord1d", XS_OpenGL_glTexCoord1d, file);
    newXS("OpenGL::glTexCoord1dv", XS_OpenGL_glTexCoord1dv, file);
    newXS("OpenGL::glTexCoord1f", XS_OpenGL_glTexCoord1f, file);
    newXS("OpenGL::glTexCoord1fv", XS_OpenGL_glTexCoord1fv, file);
    newXS("OpenGL::glTexCoord1i", XS_OpenGL_glTexCoord1i, file);
    newXS("OpenGL::glTexCoord1iv", XS_OpenGL_glTexCoord1iv, file);
    newXS("OpenGL::glTexCoord1s", XS_OpenGL_glTexCoord1s, file);
    newXS("OpenGL::glTexCoord1sv", XS_OpenGL_glTexCoord1sv, file);
    newXS("OpenGL::glTexCoord2d", XS_OpenGL_glTexCoord2d, file);
    newXS("OpenGL::glTexCoord2dv", XS_OpenGL_glTexCoord2dv, file);
    newXS("OpenGL::glTexCoord2f", XS_OpenGL_glTexCoord2f, file);
    newXS("OpenGL::glTexCoord2fv", XS_OpenGL_glTexCoord2fv, file);
    newXS("OpenGL::glTexCoord2i", XS_OpenGL_glTexCoord2i, file);
    newXS("OpenGL::glTexCoord2iv", XS_OpenGL_glTexCoord2iv, file);
    newXS("OpenGL::glTexCoord2s", XS_OpenGL_glTexCoord2s, file);
    newXS("OpenGL::glTexCoord2sv", XS_OpenGL_glTexCoord2sv, file);
    newXS("OpenGL::glTexCoord3d", XS_OpenGL_glTexCoord3d, file);
    newXS("OpenGL::glTexCoord3dv", XS_OpenGL_glTexCoord3dv, file);
    newXS("OpenGL::glTexCoord3f", XS_OpenGL_glTexCoord3f, file);
    newXS("OpenGL::glTexCoord3fv", XS_OpenGL_glTexCoord3fv, file);
    newXS("OpenGL::glTexCoord3i", XS_OpenGL_glTexCoord3i, file);
    newXS("OpenGL::glTexCoord3iv", XS_OpenGL_glTexCoord3iv, file);
    newXS("OpenGL::glTexCoord3s", XS_OpenGL_glTexCoord3s, file);
    newXS("OpenGL::glTexCoord3sv", XS_OpenGL_glTexCoord3sv, file);
    newXS("OpenGL::glTexCoord4d", XS_OpenGL_glTexCoord4d, file);
    newXS("OpenGL::glTexCoord4dv", XS_OpenGL_glTexCoord4dv, file);
    newXS("OpenGL::glTexCoord4f", XS_OpenGL_glTexCoord4f, file);
    newXS("OpenGL::glTexCoord4fv", XS_OpenGL_glTexCoord4fv, file);
    newXS("OpenGL::glTexCoord4i", XS_OpenGL_glTexCoord4i, file);
    newXS("OpenGL::glTexCoord4iv", XS_OpenGL_glTexCoord4iv, file);
    newXS("OpenGL::glTexCoord4s", XS_OpenGL_glTexCoord4s, file);
    newXS("OpenGL::glTexCoord4sv", XS_OpenGL_glTexCoord4sv, file);
    newXS("OpenGL::glTexEnvf", XS_OpenGL_glTexEnvf, file);
    newXS("OpenGL::glTexEnvfv", XS_OpenGL_glTexEnvfv, file);
    newXS("OpenGL::glTexEnvi", XS_OpenGL_glTexEnvi, file);
    newXS("OpenGL::glTexEnviv", XS_OpenGL_glTexEnviv, file);
    newXS("OpenGL::glTexGend", XS_OpenGL_glTexGend, file);
    newXS("OpenGL::glTexGendv", XS_OpenGL_glTexGendv, file);
    newXS("OpenGL::glTexGenf", XS_OpenGL_glTexGenf, file);
    newXS("OpenGL::glTexGenfv", XS_OpenGL_glTexGenfv, file);
    newXS("OpenGL::glTexGeni", XS_OpenGL_glTexGeni, file);
    newXS("OpenGL::glTexGeniv", XS_OpenGL_glTexGeniv, file);
    newXS("OpenGL::glTexImage1D", XS_OpenGL_glTexImage1D, file);
    newXS("OpenGL::glTexImage2D", XS_OpenGL_glTexImage2D, file);
    newXS("OpenGL::glTexImage3DEXT", XS_OpenGL_glTexImage3DEXT, file);
    newXS("OpenGL::glTexParameterf", XS_OpenGL_glTexParameterf, file);
    newXS("OpenGL::glTexParameterfv", XS_OpenGL_glTexParameterfv, file);
    newXS("OpenGL::glTexParameteri", XS_OpenGL_glTexParameteri, file);
    newXS("OpenGL::glTexParameteriv", XS_OpenGL_glTexParameteriv, file);
    newXS("OpenGL::glTexSubImage1DEXT", XS_OpenGL_glTexSubImage1DEXT, file);
    newXS("OpenGL::glTexSubImage2DEXT", XS_OpenGL_glTexSubImage2DEXT, file);
    newXS("OpenGL::glTexSubImage3DEXT", XS_OpenGL_glTexSubImage3DEXT, file);
    newXS("OpenGL::glTranslated", XS_OpenGL_glTranslated, file);
    newXS("OpenGL::glTranslatef", XS_OpenGL_glTranslatef, file);
    newXS("OpenGL::glVertex2d", XS_OpenGL_glVertex2d, file);
    newXS("OpenGL::glVertex2dv", XS_OpenGL_glVertex2dv, file);
    newXS("OpenGL::glVertex2f", XS_OpenGL_glVertex2f, file);
    newXS("OpenGL::glVertex2fv", XS_OpenGL_glVertex2fv, file);
    newXS("OpenGL::glVertex2i", XS_OpenGL_glVertex2i, file);
    newXS("OpenGL::glVertex2iv", XS_OpenGL_glVertex2iv, file);
    newXS("OpenGL::glVertex2s", XS_OpenGL_glVertex2s, file);
    newXS("OpenGL::glVertex2sv", XS_OpenGL_glVertex2sv, file);
    newXS("OpenGL::glVertex3d", XS_OpenGL_glVertex3d, file);
    newXS("OpenGL::glVertex3dv", XS_OpenGL_glVertex3dv, file);
    newXS("OpenGL::glVertex3f", XS_OpenGL_glVertex3f, file);
    newXS("OpenGL::glVertex3fv", XS_OpenGL_glVertex3fv, file);
    newXS("OpenGL::glVertex3i", XS_OpenGL_glVertex3i, file);
    newXS("OpenGL::glVertex3iv", XS_OpenGL_glVertex3iv, file);
    newXS("OpenGL::glVertex3s", XS_OpenGL_glVertex3s, file);
    newXS("OpenGL::glVertex3sv", XS_OpenGL_glVertex3sv, file);
    newXS("OpenGL::glVertex4d", XS_OpenGL_glVertex4d, file);
    newXS("OpenGL::glVertex4dv", XS_OpenGL_glVertex4dv, file);
    newXS("OpenGL::glVertex4f", XS_OpenGL_glVertex4f, file);
    newXS("OpenGL::glVertex4fv", XS_OpenGL_glVertex4fv, file);
    newXS("OpenGL::glVertex4i", XS_OpenGL_glVertex4i, file);
    newXS("OpenGL::glVertex4iv", XS_OpenGL_glVertex4iv, file);
    newXS("OpenGL::glVertex4s", XS_OpenGL_glVertex4s, file);
    newXS("OpenGL::glVertex4sv", XS_OpenGL_glVertex4sv, file);
    newXS("OpenGL::glViewport", XS_OpenGL_glViewport, file);
    ST(0) = &sv_yes;
    XSRETURN(1);
}
