use strict;
use Test::More tests => 47;

use_ok('Number::Phone::JP', 'freedial');

my $tel  = Number::Phone::JP->new;
my $line = 34;

for (1..$line) {
	my $num = <DATA>;
	chomp $num;
	ok($tel->set_number($num)->is_valid_number);
}

while (<DATA>) {
	chomp;
	ok(! $tel->set_number($_)->is_valid_number);
}

__DATA__
0120 000123
0120 010123
0120 020123
0120 030123
0120 040123
0120 050123
0120 060123
0120 070123
0120 080123
0120 090123
0120 100123
0120 200123
0120 300123
0120 400123
0120 500123
0120 600123
0120 700123
0120 800123
0120 900123
0120 910123
0120 920123
0120 930123
0120 940123
0120 950123
0120 960123
0120 970123
0120 980123
0120 990123
0800 0001234
0800 0801234
0800 1001234
0800 1201234
0800 1701234
0800 2001234
0120 913123
0120 921123
0120 931123
0120 942123
0120 951123
0120 961123
0120 971123
0120 984123
0800 0011234
0800 1911234
0800 3321234
0800 4011234
