use strict;
use Test::More tests => 35;

use_ok('Number::Phone::JP', 'united');

my $tel  = Number::Phone::JP->new;
my $line = 18;

for (1..$line) {
	my $num = <DATA>;
	chomp $num;
	ok($tel->set_number($num)->is_valid_number);
}

while (<DATA>) {
	chomp;
	ok(! $tel->set_number($_)->is_valid_number);
}

__DATA__
0570 000123
0570 100123
0570 111123
0570 222123
0570 300123
0570 333123
0570 500123
0570 555123
0570 570123
0570 600123
0570 700123
0570 800123
0570 809123
0570 881123
0570 882123
0570 888123
0570 919123
0570 999123
0570 103123
0570 110123
0570 223123
0570 301123
0570 334123
0570 501123
0570 556123
0570 573123
0570 601123
0570 701123
0570 810123
0570 883123
0570 884123
0570 889123
0570 918123
0570 998123
