/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.feature.value;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.maltparser.core.feature.function.Function;
import org.maltparser.core.feature.value.FeatureValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleFeatureValue
extends FeatureValue {
    protected SortedMap<Integer, String> featureValues;
    protected Map<Integer, Boolean> featureKnown;

    public MultipleFeatureValue(Function function) {
        super(function);
        this.setFeatureValues(new TreeMap<Integer, String>(), new HashMap<Integer, Boolean>());
    }

    @Override
    public void reset() {
        super.reset();
        this.featureValues.clear();
        this.featureKnown.clear();
    }

    public void addFeatureValue(int code, String Symbol, boolean known) {
        this.featureValues.put(code, Symbol);
        this.featureKnown.put(code, known);
    }

    protected void setFeatureValues(SortedMap<Integer, String> featureValues, Map<Integer, Boolean> featureKnown) {
        this.featureValues = featureValues;
        this.featureKnown = featureKnown;
    }

    public Set<Integer> getCodes() {
        return this.featureValues.keySet();
    }

    public int getFirstCode() {
        return this.featureValues.firstKey();
    }

    public Set<String> getSymbols() {
        return new HashSet<String>(this.featureValues.values());
    }

    public String getFirstSymbol() {
        return (String)this.featureValues.get(this.featureValues.firstKey());
    }

    public boolean isKnown(int value) {
        return this.featureKnown.get(value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString() + "{ ");
        for (Integer code : this.featureValues.keySet()) {
            sb.append("{" + (String)this.featureValues.get(code) + "->" + code + ", known=" + this.featureKnown.get(code) + "} ");
        }
        sb.append("}");
        return sb.toString();
    }
}

