#!/usr/bin/perl

package eBay::API::XML::Call::GetOrders;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetOrders.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetOrders

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetOrders inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetOrders::GetOrdersRequestType;
use eBay::API::XML::Call::GetOrders::GetOrdersResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetOrders';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetOrders::GetOrdersRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetOrders::GetOrdersResponseType';
}

#
# input properties
#

=head2 setCreateTimeFrom()

The starting date of the date range for the orders to retrieve.
Also applicable to Half.com.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut
       
sub setCreateTimeFrom {
   my $self   = shift;
   my $sCreateTimeFrom = shift;
   $self->getRequestDataType()->setCreateTimeFrom($sCreateTimeFrom);
}

=head2 setCreateTimeTo()

The ending date of the date range for the orders to retrieve.
Also applicable to Half.com.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut
       
sub setCreateTimeTo {
   my $self   = shift;
   my $sCreateTimeTo = shift;
   $self->getRequestDataType()->setCreateTimeTo($sCreateTimeTo);
}

=head2 setListingType()

To retrieve Half.com orders, specify Half. To retrieve eBay
orders, don't specify this field at all.
(This field can't be used as a listing type filter on eBay.com.
If not provided or if any value other than Half is specified,
this field has no useful effect and the call retrieves
eBay orders of all types.
Also, you can't retrieve both eBay and Half.com orders
in the same response.)

  RequiredInput: Conditionally
  OnlyTheseValues: Half
#    Argument: 'ns:ListingTypeCodeType'

=cut
       
sub setListingType {
   my $self   = shift;
   my $sListingType = shift;
   $self->getRequestDataType()->setListingType($sListingType);
}

=head2 setOrderIDArray()

A set of orders to retrieve.
Does not retrieve Express orders, even when the explicit Express OrderID found on the eBay Express site is included in the request.
Not applicable to Half.com.

  RequiredInput: Conditionally
#    Argument: 'ns:OrderIDArrayType'

=cut
       
sub setOrderIDArray {
   my $self   = shift;
   my $pOrderIDArray = shift;
   $self->getRequestDataType()->setOrderIDArray($pOrderIDArray);
}

=head2 setOrderRole()

Filters orders based on the role of the user making the
GetOrders request.
Not applicable to Half.com.

  RequiredInput: Conditionally
#    Argument: 'ns:TradingRoleCodeType'

=cut
       
sub setOrderRole {
   my $self   = shift;
   my $sOrderRole = shift;
   $self->getRequestDataType()->setOrderRole($sOrderRole);
}

=head2 setOrderStatus()

Filters the returned orders by order status (Active or Completed).
To retrieve orders with a status of Inactive or Cancelled, you must
specify the order IDs (OrderIDArray.OrderID). When you specify
OrderIDArray.OrderID, no other filters are used.
<br><br>
For Half.com, you can get some, but not all orders.
Orders on Half.com have different order status values from
eBay orders. When you set ListingType to Half, set OrderStatus
to Shipped. Otherwise, GetOrders may return incomplete information
or have indeterminate results.

  RequiredInput: Conditionally
  OnlyTheseValues: Active, Completed, Shipped
#    Argument: 'ns:OrderStatusCodeType'

=cut
       
sub setOrderStatus {
   my $self   = shift;
   my $sOrderStatus = shift;
   $self->getRequestDataType()->setOrderStatus($sOrderStatus);
}

=head2 setPagination()

Not applicable to eBay.com. Applicable to Half.com. If many orders are available,
you may need to call GetOrders multiple times to retrieve all the data.
Each result set is returned as a page of entries.
Use this Pagination information to indicate the maximum number of entries to
retrieve per page (i.e., per call), the page number to retrieve, and other data.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut
       
sub setPagination {
   my $self   = shift;
   my $pPagination = shift;
   $self->getRequestDataType()->setPagination($pPagination);
}



#
# output properties
#

=head2 isHasMoreOrders()

Applies only to Half.com. If true, there are more orders yet to be
retrieved. Additional GetOrders calls with higher page numbers or more
entries per page must be made to retrieve these orders. If false, no more
orders are available or no orders match the request (based on the input
filters).

  Returned: Always
  Details: DetailLevel: none
#    Returns: 'xs:boolean'

=cut
       
sub isHasMoreOrders {
   my $self = shift;
   return $self->getResponseDataType()->isHasMoreOrders();
}

=head2 getOrderArray()

The set of orders that match the order IDs or filter criteria specified.
Also applicable to Half.com (only returns orders that have not been marked as shipped).

  Returned: Always
  Details: DetailLevel: none
#    Returns: 'ns:OrderArrayType'

=cut
       
sub getOrderArray {
   my $self = shift;
   return $self->getResponseDataType()->getOrderArray();
}

=head2 getOrdersPerPage()

Applies only to Half.com. Indicates the number of orders that can be
returned per page of data (i.e., per call). This is the same as the value
specified in the Pagination.EntriesPerPage input (or the default value, if
EntriesPerPage was not specified). This is not necessarily the actual
number of orders returned per page (see ReturnedOrderCountActual).

  Returned: Always
  Details: DetailLevel: none
#    Returns: 'xs:int'

=cut
       
sub getOrdersPerPage {
   my $self = shift;
   return $self->getResponseDataType()->getOrdersPerPage();
}

=head2 getPageNumber()

Applies only to Half.com. Indicates which page of data holds the current
result set. Will be the same as the value specified in the
Pagination.PageNumber input. If orders are returned, the first page is 1.

  Returned: Always
  Details: DetailLevel: none
#    Returns: 'xs:int'

=cut
       
sub getPageNumber {
   my $self = shift;
   return $self->getResponseDataType()->getPageNumber();
}

=head2 getPaginationResult()

Applies only to Half.com. Contains information regarding the pagination of
data (if pagination is used), including total number of pages and total
number of entries.

  Returned: Always
  Details: DetailLevel: none
#    Returns: 'ns:PaginationResultType'

=cut
       
sub getPaginationResult {
   my $self = shift;
   return $self->getResponseDataType()->getPaginationResult();
}

=head2 getReturnedOrderCountActual()

Applies only to Half.com. Indicates the total number of orders returned.

  Returned: Always
  Details: DetailLevel: none
#    Returns: 'xs:int'

=cut
       
sub getReturnedOrderCountActual {
   my $self = shift;
   return $self->getResponseDataType()->getReturnedOrderCountActual();
}





1;   
