use strict;
use warnings;
use lib './lib/';
use CM::Permutation::Cycle;
use CM::Permutation;
use CM::Group::Sym;
use Data::Dumper;
use Test::More 'no_plan';
use List::AllUtils qw/all uniq reduce/;
#use feature 'say';
use Math::BigInt;


sub p{
    CM::Permutation->new(@_);
}
sub pc{
    CM::Permutation::Cycle->new(@_);
}

sub eq1 {
    my $p1=shift;
    $p1==p(@_);
}



#goto SKIP_TO_COMMUTATORS;




ok(!eval{ my $n = CM::Permutation->new(4,8,2,3);    } ,'not enough arguments to constructor');
eval "my \$n = CM::Permutation->new(4,1,2,3);";
ok( !$@ ,'enough arguments to constructor');

my $w = CM::Permutation->new(4,1,2,3);

ok($w==$w                       ,'permutation equals itself');

# ~~@array is the same as scalar(@array)
is(2,~~uniq( (p(1,2,3),p(3,1,2))x4 ),'two permutation 4 times');

ok(eq1($w**2       ,3 ,4 ,1 ,2) ,'squared permutation all in place');

# TODO: add more tests with power for longer permutations and bigger powers than 2

ok(eq1($w**-1      ,2 ,3 ,4 ,1) ,'inverse works right');
ok(eq1($w*($w**-1) ,1 ,2 ,3 ,4) ,'inverse identity is pretty much ok');
ok(eq1(($w**-1)*$w ,1 ,2 ,3 ,4) ,'again the inverse identitiy is fine');
ok(eq1($w*($w**-1) ,1 ,2 ,3 ,4) ,'w*w^-1 equals the identical permutation');




ok(p(1,3,2)*p(1,2,3) == p(1,3,2),'multiplied with identity stays the same');
ok(p(2,1,3)*p(1,2,3) == p(2,1,3),'again multiplied with identity stays the same');
ok(p(1,3,2)*p(3,1,2) == p(2,1,3),"supposed to be 2,1,3");



ok( CM::Group::Sym->new({n=>7})->order() % p(1,5,4,3,6,2,7)->order == 0 , 'applying Lagrange theorem , order of perm (1,5,4,3,6,2,7) divides order of group S_7');
#(1)*(5,2)*(4,3)



# reduce used to make a repeated conjunction
my $g5 = CM::Group::Sym->new({n=>5});
$g5->compute_elements()->();
ok( (
        reduce {
            $a && $b;
        } map {
            $g5->order % $_->order == 0
        } @{$g5->elements}
    )==1,
    'Lagrange theorem partially verified on all cyclic subgroups generated by elements of S_5'
); # Lagrange theorems says more, it says that EVERY subgroup order will divide the order of the group,
   # but we haven't yet implemented something that will  generate all subgroups(although it is possible)



# testing inverse done with the use of the computed operation table
my $g = CM::Group::Sym->new({n=>3});
$g->compute;
ok(defined $g->identity,'identity from group defined');
ok($g->identity == p(1,2,3),'identity from group ok');
my $p4 = $g->operation_table->[4]->[0];
#say "$p4 has inverse ".$p4->inverse;
ok($p4*($p4**-1) == $g->identity,"permutation ($p4) with inverse (".$p4->inverse.")");

ok(p(1,3,2,4,5)->even_odd==1, 'testing odd');
ok(p(1,3,4,2,5)->even_odd==0, 'testing even');


my $g4 = CM::Group::Sym->new({n=>4});
$g4->compute();

my (@odd,@even);

$_->even_odd
? push @odd ,$_
: push @even,$_
for @{$g4->elements};

ok(~~@odd == ~~@even,'there are as many even permutations as there are odd ones in S_4');



#properties of commutators
#http://en.wikipedia.org/wiki/Commutator

SKIP_TO_COMMUTATORS:



my $x = p(1,3,4,2,5);
my $y = p(4,2,3,5,1);
my $z = p(3,2,5,1,4);

$x->group($g5);
$y->group($g5);
$z->group($g5);
my $xz = $x % $z;


ok(defined($x->{group}),'x belongs to a group');
ok(defined($xz->{group}),'% sets group attribute');


ok( ($y % $x)      == ($x % $y)**-1              , 'commutator 1');

#TODO: fix this test, as it fails
#ok( ($x * $y) % $z == (($x % $z)^$y) * ($y % $z) , 'commutator 2'  );




#ok( ($x % ($y*$z)) == ($x % $z)*( ($x % $y)^$z)  , 'commutator 3'  );
#ok(  $x % ($y**-1)  == (($y % $x)^($y**-1))       , 'commutator 4'  ); # if I don't enclose the RHS in parenthesis here I'll get inf
                                                                      # and overflow from the result on RHS although that's not a
                                                                      # operation that could ever overflow considering I'm dealing with
                                                                      # permutations and I define my own operations(need to see how this test can be written for the overloaded operators).


ok( p({
        1=>2,
        2=>3,
        3=>1,
        }
    )*p({
        1=>2,
        2=>3,
        3=>1,
        }
    )*p({
        1=>2,
        2=>3,
        3=>1,
        }
    ) == p(1,2,3),
    "checking hashref constructor argument"
);


my @seta=(6,5,4,3,2,1);
my @resseta = p(3,2,1)->apply(@seta);
ok( @resseta == 6 , 'the set on which permutation was applied has same length as initial set'.join(',',@resseta));


my $q = CM::Permutation->new({
        19=>34,
        22=>31,
        25=>28,

        34=>16,
        31=>13,
        28=>10,

        16=>39,
        13=>38,
        10 =>37,

        39=>19,
        38=>22,
        37=>25,
    });



# testing R from CM::Rubik and multiplication
my $q1 = CM::Permutation->new({
        25=>45,
        26=>42,
        27=>39,

        45=>18,
        42=>17,
        39=>16,

        18=>3,
        17=>6,
        16=>9,

        3=>25,
        6=>26,
        9=>27,
    });



my $pbig = p(2,3,1,4,14,8,9,7,5,12,15,6,13,10,11);
#$pbig->print_cycles;
my $exponent = 140;
ok($pbig ** $exponent == $pbig->power_fast($exponent) , "** and power_fast do the same thing");

#done_testing;
