#include <qlistview.h>

suicidal virtual class QListView : virtual QScrollView {
    enum WidthMode { Manual, Maximum };
    QListView(QWidget * = 0, const char * = 0);
    virtual ~QListView();
    virtual int addColumn(const QString &, int = -1);
    virtual int addColumn(const QIconSet &, const QString &, int = -1);
    bool allColumnsShowFocus() const;
    int childCount() const;
    virtual void clear();
    virtual void clearSelection();
    int columnAlignment(int) const;
    const char *columnText(int) const;
    int columnWidth(int) const;
    QListView::WidthMode columnWidthMode(int) const;
    QListViewItem *currentItem() const;
    void ensureItemVisible(const QListViewItem *);
    virtual bool eventFilter(QObject *, QEvent *);
    QListViewItem *firstChild() const;
    QHeader *header() const;
    virtual void insertItem(QListViewItem *);
    bool isMultiSelection() const;
    bool isOpen(QListViewItem *) const;
    bool isSelected(QListViewItem *) const;
    QListViewItem *itemAt(const QPoint &) const;
    int itemMargin() const;
    int itemPos(const QListViewItem *);
    QRect itemRect(const QListViewItem *) const;
    virtual QSize minimumSizeHint() const;
    virtual void removeItem(QListViewItem *);
    void repaintItem(const QListViewItem *) const;
    bool rootIsDecorated() const;
    QListViewItem *selectedItem() const;
    virtual void setAllColumnsShowFocus(bool);
    virtual void setColumnAlignment(int, int);
    virtual void setColumnText(int, const QString &);
    virtual void setColumnText(int, const QIconSet &, const QString &);
    virtual void setColumnWidth(int, int);
    virtual void setColumnWidthMode(int, QListView::WidthMode);
    virtual void setCurrentItem(QListViewItem *);
    virtual void setFont(const QFont &);
    virtual void setItemMargin(int);
    virtual void setMultiSelection(bool);
    virtual void setOpen(QListViewItem *, bool);
    virtual void setPalette(const QPalette &);
    virtual void setRootIsDecorated(bool);
    virtual void setSelected(QListViewItem *, bool);
    virtual void setSorting(int, bool = TRUE);
    virtual void setTreeStepSize(int);
    virtual void show();
    virtual QSize sizeHint() const;
    virtual void takeItem(QListViewItem *);
    int treeStepSize() const;
    void triggerUpdate() slot;
protected:
    virtual void contentsMousePressEvent(QMouseEvent *);
    virtual void contentsMouseReleaseEvent(QMouseEvent *);
    virtual void contentsMouseDoubleClickEvent(QMouseEvent *);
    virtual void contentsMouseMoveEvent(QMouseEvent *);
    void currentChanged(QListViewItem *) signal;
    void doAutoScroll() slot;
    void doubleClicked(QListViewItem *) signal;
    virtual void drawContentsOffset(QPainter *, int, int, int, int, int, int);
    virtual void enabledChange(bool);
    virtual void focusInEvent(QFocusEvent *);
    virtual void focusOutEvent(QFocusEvent *);
    virtual void keyPressEvent(QKeyEvent *);
    virtual void paintEmptyArea(QPainter *, const QRect &);
    virtual void resizeEvent(QResizeEvent *);
    void returnPressed(QListViewItem *) signal;
    void rightButtonClicked(QListViewItem *, const QPoint &, int) signal;
    void rightButtonPressed(QListViewItem *, const QPoint &, int) signal;
    void selectionChanged() signal;
    void selectionChanged(QListViewItem *) signal;
    virtual void showEvent(QShowEvent *);
    virtual void styleChange(QStyle &);
    void updateContents() slot;
} Qt::ListView;
