.\" @(#)a2ps.man.1 4.6 02/10/1996
.\"
.TH A2PS 1L "2 October 1996"
.UC 4
.SH NAME
a2ps \- formats an ascii file for printing on a postscript printer
.PP
.SH SYNOPSIS
.B a2ps
[
.B global options
] [
.B positional options
]
[
.I file1
[
.B positional options
] ]
.I file2 \fP...
] ]
..PP
SH DESCRIPTION
\fIa2ps\fP formats each named file for printing in a postscript
printer; if no file is given, \fIa2ps\fP reads from the standard
input. The output is sent to the printer or to stdout or to a file.
The format used is nice and compact: normally two pages on each
physical page, borders surrounding pages, headers with useful
information (page number, printing date, file name or supplied
header), line numbering, pretty-printing, symbol substitution etc.
This is very useful for making archive listings of programs.
.PP
.SS Global options
Global options offered by \fIa2ps\fP are the following:
.TP 0.6i
.B -? -h
Print usage information.
.TP 0.6i
.B -8
Print non ascii characters (with the high bit set) as ISO Latin 1
characters. (default: see -V).
.TP 0.6i
.B -a
Use alternative paper size. In general defined to be US letter. (see
-V).
.TP 0.6i
.B -b
Force printing binary files. By default, binary files printing is
stopped before second page (see -nb option).
.TP 0.6i
.B -c
Compact mode for a sequence of files. This option allows the printing
of two files in the same physical page: last page of the first file in
the left (or up) side and first page of the second file in the right
(or down) side. This option is valid only for twin-page mode (two pages
per physical page).
.TP 0.6i
.B -f
Fold lines too large to be printed inside the borders (default
option).  Max line size depends on format and font size used and
whether line numbering has been suppressed.
.TP 0.6i
.B -G
Don't print files, but write the language option -k would have
guessed for them.
.TP 0.6i
.B -h
Print usage information and exit.
.TP 0.6i
.B -I\fIfile\fP
Use the specified file as the postscript prologue for a2ps.
.TP 0.6i
.B -na
Don't use alternative paper dimensions. In general corresponds to a4
paper. (see -V for values).
.TP 0.6i
.B -nb
Don't print binary files (default option). To detect such a file we
make use of a very simple heuristic: if the first page of the file
contains at less 75% of non-printing characters, it's a binary file.
First page is always printed.
.TP 0.6i
.B -nc
Don't use compact mode for a sequence of files. The beginning of each
file will be printed in a new physical page.
.TP 0.6i
.B -nf
Truncate lines too large (don't fold).
.TP 0.6i
.B -nP
Send output to stdout. (default: see -V).
.TP 0.6i
.B -nr
Sheet numbering (see -r option) must be continue for all files (don't
reset on new file). Default option.
.TP 0.6i
.B -nv
Replace non-printing characters by a space.
.TP 0.6i
.B -n8
Don't print non ascii characters as ISO Latin 1 characters: these
characters are printed as M- (for meta) followed by the character of
the low 7 bits (see -8 option).
.TP 0.6i
.B -o -o\fIfilename\fP
Save the postscript into a file. Use the file \fIfilename\fP if
specified, \fIa2ps.ps\fP otherwise. (default: postscript is sent to
stdout).
.TP 0.6i
.B -P -P\fIprinter\fP
Send the result to the default printer or to \fIprinter\fP if
specified. Depending on your installation, it may not be
available. This option cannot follow option -o. (default: see -V).
.TP 0.6i
.B -q
Print files in quiet mode (no summary).
.TP 0.6i
.B -r
Reset sheet numbering for each new file.  Sheet numbering is used to
number physical pages (sheets) as they are printed.  Page numbering
numbers the logical pages, of which there are usually two per physical
page (i.e. unless -p or -w is specified).
.TP 0.6i
.B -s1
Print output in one-sided mode (only one side of each
sheet). (default: see -V).
.TP 0.6i
.B -s2
Print output in two-sided mode (front and backside of each
sheet). (default: see -V).
.TP 0.6i
.B -t\fInum\fP
Set TAB size to \fInum\fR (default 8).  This option is ignored if
\fB-ni\fR is specified (see below).
.TP 0.6i
.B -v
Replace non-printing characters so that they are visible and easy to
identify (default option). Control characters (ascii codes lower than
0x20) are printed like ^X for ctrl-x; the delete character (hex 0x3f)
is printed as ^?. Non ascii characters (with the high bit set) are
printed as M- (for meta) followed by the character of the low 7
bits. TAB, BS and FF are handled like non-printing characters if -ni
option was taken.
.TP 0.6i
.B -V
Print version and installation dependent configuration information,
and exit.
.TP 0.6i
.B -W -W\fIlang\fP
Generate a report about all the styles \fIa2ps\fP knows, and exit. If
\fIlang\fP is given, just \fIlang\fP-style is reported.
.PP
.SS Positional options
Positional options are applied to all files that will be found in the
rest of the command line. The \fI-H\fP option is the only exception:
it is applied only to the next file.  Positional options offered by
\fIa2ps\fP are the following:
.TP 0.6i
.B -1
Print only one page per physical page (single page mode).
.TP 0.6i
.B -2
Print two pages per physical page (twin-page mode), side by side or
up-down, depending on the printing mode (landscape or portrait).
.TP 0.6i
.B -#\fInum\fP
To get multiple copies of output, where \fInum\fP is the number of
copies desired of each file named. By default, you get only one copy.
.TP 0.6i
.B -B
Print using bold font.
.TP 0.6i
.B -d
Print the current date and time at the bottom of the page. This option
is affected by the no surrounding border and the no header options.
.TP 0.6i
.B -F\fInum\fP
Changes font size to this value. Default values for font size are 6.8
in landscape mode, 6.4 in twin-page portrait mode and 9.0 in single
page portrait mode. Try other sizes if you think that these values are
too small (or big).
.TP 0.6i
.B -H -H\fItext\fP
Print a page header with the file name. If \fItext\fP is given use it
instead of the file name in the page headers for printing next (and
only next) file. Additional -H directives can be mixed in with the
filenames.
.TP 0.6i
.B -i
Interpret TAB, BS and FF characters (default option). TAB is replaced
by enough spaces to reach next tab stop while BS and FF have their
meanings.
.TP 0.6i
.B -k -k\fIlanguage\fP
Enable pretty printing. If no argument is given, the style is
automatically selected upon the files suffix. (default: see -V). If
\fIlanguage\fP is specified, used the corresponding style.
.TP 0.6i
.B -l
Print files in landscape mode (default option). This option may not be
used with the -p option.
.TP 0.6i
.B -l\fInum\fP
Set the lines per page for printing. The font size is automatically
scaled up to fill in the whole page. This is useful for printing
preformatted documents which have a fixed number of lines per
page. The scaling of the font size will be suppressed if this option
is used with option \fB-f\fPnum.  The minimum number of lines per page
is set at 40 and maximum is at 160. If a number less than 40 is
supplied, scaling will be turned off and a warning message is printed
on the terminal.
.TP 0.6i
.B -L
Print user login ID in the upper right corner of the page (default
option). (available for Unix systems only)
.TP 0.6i
.B -m
Understand UNIX manual output ie: 66 lines per page, no line numbering
and possible \fIbolding\fP and \fIunderlining\fP sequences. The
understanding of \fIbolding\fP and \fIunderlining\fP is there by
default even if -m is not specified.
.TP 0.6i
.B -n
Output lines are preceded by line numbers, numbered sequentially from 1.
.TP 0.6i
.B -nB
Don't print using bold font.
.TP 0.6i
.B -nd
Don't print the current date and time in the footer (default option).
.TP 0.6i
.B -nH
Don't print page headers.
.TP 0.6i
.B -ni
Don't interpret TAB, BS and FF characters. They will be printed
according to -v option.
.TP 0.6i
.B -nk
Don't pretty print files (default option).
.TP 0.6i
.B -nn
Don't number output lines (default option).
.TP 0.6i
.B -ns
Don't print page surrounding borders.
.TP 0.6i
.B -nt
Don't translate special keywords in symbols (default option).
.TP 0.6i
.B -nu
Don't print filename at bottom of page.
.TP 0.6i
.B -nL
Don't print user login ID at top of page.
.TP 0.6i
.B -p
Print files in portrait mode (horizontal pages).  The default option
is to use landscape mode.
.TP 0.6i
.B -s
Print page surrounding borders (default option).
.TP 0.6i
.B -t
Translate special keywords in symbols. See Section Pretty
printing. This option is always enabled when the processed language is
\fIprescript\fP(4).
.TP 0.6i
.B -u -u\fItext\fP
Print the filename, centered, at the bottom of the page (default
option). If \fItext\fP is given, use it for following pages. This is
useful to leave a note about a whole set of files.
.PP
.SS Pretty printing
\fIa2ps\fP is able to use special fonts for strings, comments, and
keywords, for some languages. Currently known languages are:
.RS
.PP
\fBada c c++ caml(ml) claire(cl) coq-vernacular(coq) common-lisp(lsp)
eiffel(e) fortran(f) java lace(ace) mailfolder(mail) modula-3(m3) o2c
oberon pascal(pas) perl(pl) postscript(ps) prescript(pre) promela(pml)
python(py) sather(sa) scheme(scm) sdl-88(sdl) sh tcl tk zsh\fP
.RE
.PP
(names in parenthesis are abbreviations).
.TP 0.6i
.B -k
Enable automatic pretty-printing. To recognize the language in which a
file has been written \fIa2ps\fP first consults the unix command
\fIfile\fP and trusts its result unless it is "C-program" (\fIfile\fP
is often wrong on this). If \fIfile\fP was unable to recognize the
language, then the suffix of the file is examined. Automatic
pretty-printing may be the default: see -V.
.TP 0.6i
.B -k\fIlanguage\fP
Selects the \fIlanguage\fP mode.
.TP 0.6i
.B -nk
Returns to the plain style, and disable automatic pretty-printing.
.TP 0.6i
.B -t
Translate special keywords in symbols. \fIa2ps\fP is able to convert
=> or other special sequences in the corresponding character in the
symbol font. This must be used in conjunction with the pretty-printing
mode. It is always enabled for prescript.
.TP 0.6i
.B -nt
Do not convert symbols.
.TP 0.6i
.B -W -W\fIlang\fP
\fIa2ps\fP generates a report about all the styles it knows (or just
\fIlang\fP if it is given). The report is in \fIprescript\fP which a
language close to LaTeX. It should be processed by \fIa2ps\fP itself:

.ti +0.5i
a2ps -W | a2ps -kpre -oreport.ps 

\fIprescript\fP has been conceived to be a good choice of language for
programs that want to produce postscript without having really to deal
with postscript. Since its syntax is very close to that of LaTeX, with
minor corrections it can be compiled using LaTeX.
.PP
.SH USAGE
\fIa2ps\fP generates postscript to its standard output. The user could
redirect this output to a file, pipe it directly to a print command
(like lpr), or to another filter for further processing.

.ti +0.5i
a2ps file1 > file2

.ti +0.5i
a2ps -p file1 | psnup -n4 | lpr

.ti +0.5i
a2ps -n -c -kc main.c main.h -Plwriter

.ti +0.5i
a2ps -t tcp.pr -Plwriter

\fIprescript\fP and \fIa2ps\fP can be used for one-the-fly
formating. For instance, one the passwd file:

.ti +0.5i
ypcat passwd |
.ti +0.7i
awk -F: '{print "\\textbf{" $5 "} (" $1 ") \\rightarrow\\textit{" $7 "}"}' |
.ti +0.7i
xa2ps -kpre -P
.PP
Don't forget to make sure your printer is capable of printing postscript.
.PP
This filter must be used only with text files. Avoid specially output from
TeX, troff or any other such text formatters.
.PP
.SH EXIT STATUS
The following exit values are returned:
.TP 3
.B 0
\fIa2ps\fP terminated normally.
.TP
.B 1
an error occured.
.TP
.B 2
bad argument was given.
.TP
.B 3
unknown language mode was given.
.PP
.SH BUGS
If \fIa2ps\fP is often wrong on some languages, check the result
returned by \fIfile\fP, and on big mistakes (such as "lex program
text" on a perl script), ask your system administrator to update the
/etc/magic file.
.PP
.SH SEE ALSO
lpr(1), file(1), gs(1), latex(1), tgrind(1), enscript(1),
prescript(4).
.PP
.SH AUTHORS
Evan Kirshenbaum (evan@csli) for the initial version.
.br
Miguel Santana (M.Santana@frgu.bull.fr) for versions 1.0, 2.0, 3.0, 4.0,
4.1, 4.2 and 4.3.
.br
Emmanuel Briot (emmanuel.briot@matra-com.fr) and Akim Demaille (demaille@inf.enst.fr) for versions 4.5 and 4.6.
.PP
.SH CONTRIBUTORS
Oscar Nierstrasz (oscar@cui.uucp)
.br
Tim Clark (T.Clark@warwick.ac.uk)
.br
Henk Tullemans (tullemans@apolloway.prl.philips.nl)
.br
Johan Vromans (jv@mh.nl)
.br
Craig Stevenson (craig.r.stevenson@att.com)
.br
John Macdonald (jmm@eci386.uucp)
.br
Huub van de Wetering (wstahw@lso.win.tue.nl)
.br
erikt@cs.umu.se
.br
wstahw@lso.win.tue.nl
.br
mai@wolfen.cc.uow.oz
.br
Johan Garpendahl (garp@isy.liu.se)
.br
John Interrante (interran@uluru.stanford.edu)
.br
Larry Barbieri (lbarbieri@ll.mit.edu)
.br
Chris Adamo (adamo@ll.mit.edu)
.br
Basile Starynkevitch (Basile.Starynkevitch@cea.fr)
.br
Denis Girou (Denis.Girou@idris.fr)