/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlImageInput
extends HtmlInput {
    private static final long serialVersionUID = -2955826367201282767L;
    private boolean wasPositionSpecified_;
    private int xPosition_;
    private int yPosition_;

    HtmlImageInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        String name = this.getNameAttribute();
        String prefix = StringUtils.isEmpty((String)name) ? "" : name + ".";
        if (this.wasPositionSpecified_) {
            return new NameValuePair[]{new NameValuePair(prefix + 'x', String.valueOf(this.xPosition_)), new NameValuePair(prefix + 'y', String.valueOf(this.yPosition_))};
        }
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected Page doClickAction(Page defaultPage) throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            return form.submit(this);
        }
        return super.doClickAction(defaultPage);
    }

    @Override
    public Page click(int x, int y) throws IOException, ElementNotFoundException {
        this.wasPositionSpecified_ = true;
        this.xPosition_ = x;
        this.yPosition_ = y;
        return super.click();
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }
}

