/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLSerializer;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.ArrayList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;

public class Node
extends SimpleScriptable {
    private static final long serialVersionUID = -5695262053081637445L;
    private HTMLCollection childNodes_;
    private EventListenersContainer eventListenersContainer_;
    public static final short ELEMENT_NODE = 1;
    public static final short ATTRIBUTE_NODE = 2;
    public static final short TEXT_NODE = 3;
    public static final short CDATA_SECTION_NODE = 4;
    public static final short ENTITY_REFERENCE_NODE = 5;
    public static final short ENTITY_NODE = 6;
    public static final short PROCESSING_INSTRUCTION_NODE = 7;
    public static final short COMMENT_NODE = 8;
    public static final short DOCUMENT_NODE = 9;
    public static final short DOCUMENT_TYPE_NODE = 10;
    public static final short DOCUMENT_FRAGMENT_NODE = 11;
    public static final short NOTATION_NODE = 12;
    public static final short DOCUMENT_POSITION_DISCONNECTED = 1;
    public static final short DOCUMENT_POSITION_PRECEDING = 2;
    public static final short DOCUMENT_POSITION_FOLLOWING = 4;
    public static final short DOCUMENT_POSITION_CONTAINS = 8;
    public static final short DOCUMENT_POSITION_CONTAINED_BY = 16;
    public static final short DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;

    public short jsxGet_nodeType() {
        return this.getDomNodeOrDie().getNodeType();
    }

    public String jsxGet_nodeName() {
        return this.getDomNodeOrDie().getNodeName();
    }

    public String jsxGet_nodeValue() {
        return this.getDomNodeOrDie().getNodeValue();
    }

    public void jsxSet_nodeValue(String newValue) {
        this.getDomNodeOrDie().setNodeValue(newValue);
    }

    public Object jsxFunction_appendChild(Object childObject) {
        Object appendedChild = null;
        if (childObject instanceof Node) {
            DomNode childDomNode = ((Node)childObject).getDomNodeOrDie();
            DomNode parentNode = this.getDomNodeOrDie();
            parentNode.appendChild(childDomNode);
            appendedChild = childObject;
            if (!(parentNode instanceof SgmlPage) && !(this instanceof DocumentFragment) && parentNode.getParentNode() == null && this.getBrowserVersion().isIE()) {
                DomDocumentFragment fragment = parentNode.getPage().createDomDocumentFragment();
                fragment.appendChild(parentNode);
            }
        }
        return appendedChild;
    }

    public Object jsxFunction_cloneNode(boolean deep) {
        DomNode domNode = this.getDomNodeOrDie();
        DomNode clonedNode = domNode.cloneNode(deep);
        Node jsClonedNode = this.getJavaScriptNode(clonedNode);
        if (this.getBrowserVersion().isIE()) {
            this.copyEventListenersWhenNeeded(domNode, clonedNode);
        }
        return jsClonedNode;
    }

    private void copyEventListenersWhenNeeded(DomNode domNode, DomNode clonedNode) {
        Node jsNode = (Node)domNode.getScriptObject();
        if (jsNode != null) {
            Node jsClonedNode = this.getJavaScriptNode(clonedNode);
            jsClonedNode.getEventListenersContainer().copyFrom(jsNode.getEventListenersContainer());
        }
        DomNode child = domNode.getFirstChild();
        for (DomNode clonedChild = clonedNode.getFirstChild(); child != null && clonedChild != null; child = child.getNextSibling(), clonedChild = clonedChild.getNextSibling()) {
            this.copyEventListenersWhenNeeded(child, clonedChild);
        }
    }

    public static Object jsxFunction_insertBefore(Context context, Scriptable thisObj, Object[] args, Function function) {
        return ((Node)thisObj).jsxFunction_insertBefore(args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object jsxFunction_insertBefore(Object[] args) {
        DomNode refChildNode;
        Object newChildObject = args[0];
        Object refChildObject = args.length > 1 ? args[1] : Undefined.instance;
        Object appendedChild = null;
        if (!(newChildObject instanceof Node)) return appendedChild;
        DomNode newChildNode = ((Node)newChildObject).getDomNodeOrDie();
        if (newChildNode instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)newChildNode;
            for (DomNode child : fragment.getChildren()) {
                this.jsxFunction_insertBefore(new Object[]{child.getScriptObject(), refChildObject});
            }
            return newChildObject;
        }
        if (refChildObject == Undefined.instance) {
            if (this.getBrowserVersion().isIE()) {
                if (args.length > 1) {
                    throw Context.reportRuntimeError((String)"Invalid argument.");
                }
                refChildNode = null;
            } else {
                if (args.length != 2) throw Context.reportRuntimeError((String)"insertBefore: not enough arguments");
                refChildNode = null;
            }
        } else {
            refChildNode = refChildObject != null ? ((Node)refChildObject).getDomNodeOrDie() : null;
        }
        DomNode domNode = this.getDomNodeOrDie();
        if (refChildNode != null) {
            refChildNode.insertBefore(newChildNode);
            appendedChild = newChildObject;
        } else {
            domNode.appendChild(newChildNode);
            appendedChild = newChildObject;
        }
        if (domNode.getParentNode() != null || !this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) return appendedChild;
        DomDocumentFragment fragment = domNode.getPage().createDomDocumentFragment();
        fragment.appendChild(domNode);
        return appendedChild;
    }

    public boolean jsxFunction_isSameNode(Object other) {
        return other == this;
    }

    public Object jsxFunction_removeChild(Object childObject) {
        Object removedChild = null;
        if (childObject instanceof Node) {
            DomNode childNode = ((Node)childObject).getDomNodeOrDie();
            childNode.remove();
            removedChild = childObject;
        }
        return removedChild;
    }

    public boolean jsxFunction_hasChildNodes() {
        return this.getDomNodeOrDie().getChildren().iterator().hasNext();
    }

    public HTMLCollection jsxGet_childNodes() {
        if (this.childNodes_ == null) {
            this.childNodes_ = new HTMLCollection(this);
            this.childNodes_.initFromChildren(this.getDomNodeOrDie());
        }
        return this.childNodes_;
    }

    public Object jsxFunction_replaceChild(Object newChildObject, Object oldChildObject) {
        Object removedChild = null;
        if (newChildObject instanceof DocumentFragment) {
            DocumentFragment fragment = (DocumentFragment)newChildObject;
            Node firstNode = null;
            Node refChildObject = ((Node)oldChildObject).jsxGet_nextSibling();
            for (DomNode node : fragment.getDomNodeOrDie().getChildren()) {
                if (firstNode == null) {
                    this.jsxFunction_replaceChild(node.getScriptObject(), oldChildObject);
                    firstNode = (Node)node.getScriptObject();
                    continue;
                }
                this.jsxFunction_insertBefore(new Object[]{node.getScriptObject(), refChildObject});
            }
            if (firstNode == null) {
                this.jsxFunction_removeChild(oldChildObject);
            }
            removedChild = oldChildObject;
        } else if (newChildObject instanceof Node && oldChildObject instanceof Node) {
            DomNode newChildNode = ((Node)newChildObject).getDomNodeOrDie();
            DomNode oldChildNode = ((Node)oldChildObject).getDomNodeOrDie();
            oldChildNode.replace(newChildNode);
            removedChild = oldChildObject;
        }
        return removedChild;
    }

    public Node jsxGet_parentNode() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getParentNode());
    }

    public Node jsxGet_nextSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getNextSibling());
    }

    public Node jsxGet_previousSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getPreviousSibling());
    }

    public Node jsxGet_firstChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getFirstChild());
    }

    public Node jsxGet_lastChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getLastChild());
    }

    protected Node getJavaScriptNode(DomNode domNode) {
        if (domNode == null) {
            return null;
        }
        return (Node)this.getScriptableFor(domNode);
    }

    public boolean jsxFunction_attachEvent(String type, Function listener) {
        return this.getEventListenersContainer().addEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    public void jsxFunction_addEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    private EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    public void jsxFunction_detachEvent(String type, Function listener) {
        this.jsxFunction_removeEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    public void jsxFunction_removeEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult executeEvent(Event event) {
        if (this.eventListenersContainer_ != null) {
            HtmlPage page = (HtmlPage)this.getDomNodeOrDie().getPage();
            boolean isIE = this.getBrowserVersion().isIE();
            Window window = (Window)page.getEnclosingWindow().getScriptObject();
            Object[] args = new Object[]{event};
            Object[] propHandlerArgs = isIE ? ArrayUtils.EMPTY_OBJECT_ARRAY : args;
            window.setCurrentEvent(event);
            try {
                ScriptResult scriptResult = this.eventListenersContainer_.executeListeners(event, args, propHandlerArgs);
                return scriptResult;
            }
            finally {
                window.setCurrentEvent(null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult fireEvent(Event event) {
        HtmlPage page = (HtmlPage)this.getDomNodeOrDie().getPage();
        boolean ie = this.getBrowserVersion().isIE();
        Window window = (Window)page.getEnclosingWindow().getScriptObject();
        Object[] args = new Object[]{event};
        event.startFire();
        ScriptResult result = null;
        Event previousEvent = window.getCurrentEvent();
        window.setCurrentEvent(event);
        try {
            DomNode node;
            EventListenersContainer windowsListeners = this.getWindow().getEventListenersContainer();
            event.setEventPhase((short)1);
            result = windowsListeners.executeCapturingListeners(event, args);
            if (event.isPropagationStopped()) {
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            ArrayList<DomNode> parents = new ArrayList<DomNode>();
            for (node = this.getDomNodeOrDie(); node != null; node = node.getParentNode()) {
                parents.add(node);
            }
            for (int i = parents.size() - 1; i >= 0; --i) {
                DomNode curNode = (DomNode)parents.get(i);
                Node jsNode = (Node)curNode.getScriptObject();
                EventListenersContainer elc = jsNode.eventListenersContainer_;
                if (elc == null) continue;
                ScriptResult r = elc.executeCapturingListeners(event, args);
                result = ScriptResult.combine(r, result, ie);
                if (!event.isPropagationStopped()) continue;
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            Object[] propHandlerArgs = ie ? ArrayUtils.EMPTY_OBJECT_ARRAY : args;
            event.setEventPhase((short)2);
            for (node = this.getDomNodeOrDie(); node != null; node = node.getParentNode()) {
                Node jsNode = (Node)node.getScriptObject();
                EventListenersContainer elc = jsNode.eventListenersContainer_;
                if (elc != null) {
                    ScriptResult r = elc.executeBubblingListeners(event, args, propHandlerArgs);
                    result = ScriptResult.combine(r, result, ie);
                    if (event.isPropagationStopped()) {
                        ScriptResult scriptResult = result;
                        return scriptResult;
                    }
                }
                event.setEventPhase((short)3);
            }
            ScriptResult r = windowsListeners.executeBubblingListeners(event, args, propHandlerArgs);
            result = ScriptResult.combine(r, result, ie);
        }
        finally {
            event.endFire();
            window.setCurrentEvent(previousEvent);
        }
        return result;
    }

    public Function getEventHandler(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        return this.eventListenersContainer_.getEventHandler(StringUtils.substring((String)eventName, (int)2));
    }

    public void setEventHandler(String eventName, Function eventHandler) {
        this.setEventHandlerProp(eventName, eventHandler);
    }

    protected void setEventHandlerProp(String eventName, Object value) {
        this.getEventListenersContainer().setEventHandlerProp(StringUtils.substring((String)eventName.toLowerCase(), (int)2), value);
    }

    protected Object getEventHandlerProp(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        return this.eventListenersContainer_.getEventHandlerProp(StringUtils.substring((String)eventName.toLowerCase(), (int)2));
    }

    public Object jsxGet_ownerDocument() {
        Document document = this.getDomNodeOrDie().getOwnerDocument();
        if (document == null) {
            return null;
        }
        return ((SgmlPage)document).getScriptObject();
    }

    public String jsxGet_prefix() {
        String prefix = this.getDomNodeOrDie().getPrefix();
        if (this.getBrowserVersion().isIE() && (prefix == null || this.getDomNodeOrDie().getPage() instanceof HtmlPage)) {
            return "";
        }
        return prefix;
    }

    public String jsxGet_localName() {
        return this.getDomNodeOrDie().getLocalName();
    }

    public String jsxGet_namespaceURI() {
        if (this.getBrowserVersion().isIE()) {
            return "";
        }
        return this.getDomNodeOrDie().getNamespaceURI();
    }

    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if (this.getBrowserVersion().isIE() && !(this.getDomNodeOrDie().getPage() instanceof HtmlPage)) {
            ActiveXObject.addProperty((SimpleScriptable)this, "namespaceURI", true, false);
            ActiveXObject.addProperty((SimpleScriptable)this, "prefix", true, false);
        }
    }

    public short jsxFunction_compareDocumentPosition(Node node) {
        return this.getDomNodeOrDie().compareDocumentPosition(node.getDomNodeOrDie());
    }

    public void jsxFunction_normalize() {
        this.getDomNodeOrDie().normalize();
    }

    public Object jsxGet_xml() {
        DomNode node = this.getDomNodeOrDie();
        if (node.getPage() instanceof XmlPage) {
            if (this instanceof Element) {
                XMLSerializer serializer = new XMLSerializer();
                serializer.setParentScope(this.getParentScope());
                String xml = serializer.jsxFunction_serializeToString(this);
                if (this.getBrowserVersion().isIE() && xml.endsWith("\r\n")) {
                    xml = xml.substring(0, xml.length() - 2);
                }
                return xml;
            }
            return node.asXml();
        }
        return Undefined.instance;
    }
}

