/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.AbstractCSSRuleImpl;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSPageRuleImpl
extends AbstractCSSRuleImpl
implements CSSPageRule,
Serializable {
    private static final long serialVersionUID = -6007519872104320812L;
    private String ident = null;
    private String pseudoPage = null;
    private CSSStyleDeclaration style = null;

    public CSSPageRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, String ident, String pseudoPage) {
        super(parentStyleSheet, parentRule);
        this.ident = ident;
        this.pseudoPage = pseudoPage;
    }

    public CSSPageRuleImpl() {
    }

    public short getType() {
        return 6;
    }

    public String getCssText() {
        String sel = this.getSelectorText();
        return "@page {" + sel + (sel.length() > 0 ? " " : "") + this.getStyle().getCssText() + "}";
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.parentStyleSheet != null && this.parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 6) {
                throw new DOMExceptionImpl(13, 9);
            }
            this.ident = ((CSSPageRuleImpl)r).ident;
            this.pseudoPage = ((CSSPageRuleImpl)r).pseudoPage;
            this.style = ((CSSPageRuleImpl)r).style;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getSelectorText() {
        return (this.ident != null ? this.ident : "") + (this.pseudoPage != null ? ":" + this.pseudoPage : "");
    }

    public void setSelectorText(String selectorText) throws DOMException {
    }

    public CSSStyleDeclaration getStyle() {
        return this.style;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    public void setPseudoPage(String pseudoPage) {
        this.pseudoPage = pseudoPage;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this.style = style;
    }
}

