/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.JavaScriptPage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.XHtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultPageCreator
implements PageCreator,
Serializable {
    public static PageType determinePageType(String contentType) {
        if (null == contentType) {
            return PageType.UNKNOWN;
        }
        if ("text/html".equals(contentType)) {
            return PageType.HTML;
        }
        if ("text/javascript".equals(contentType) || "application/x-javascript".equals(contentType)) {
            return PageType.JAVASCRIPT;
        }
        if ("text/xml".equals(contentType) || "application/xml".equals(contentType) || "text/vnd.wap.wml".equals(contentType) || contentType.endsWith("+xml")) {
            return PageType.XML;
        }
        if (contentType.startsWith("text/")) {
            return PageType.TEXT;
        }
        return PageType.UNKNOWN;
    }

    public Page createPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        String contentType = this.determineContentType(webResponse.getContentType().toLowerCase(), webResponse.getContentAsStream());
        PageType pageType = DefaultPageCreator.determinePageType(contentType);
        switch (pageType) {
            case HTML: {
                return this.createHtmlPage(webResponse, webWindow);
            }
            case JAVASCRIPT: {
                return this.createJavaScriptPage(webResponse, webWindow);
            }
            case XML: {
                XmlPage xml = this.createXmlPage(webResponse, webWindow);
                DomElement doc = xml.getDocumentElement();
                if (doc != null && "http://www.w3.org/1999/xhtml".equals(doc.getNamespaceURI())) {
                    return this.createXHtmlPage(webResponse, webWindow);
                }
                return xml;
            }
            case TEXT: {
                return this.createTextPage(webResponse, webWindow);
            }
        }
        return this.createUnexpectedPage(webResponse, webWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String determineContentType(String contentType, InputStream contentAsStream) throws IOException {
        byte[] markerUTF8 = new byte[]{-17, -69, -65};
        byte[] markerUTF16BE = new byte[]{-2, -1};
        byte[] markerUTF16LE = new byte[]{-1, -2};
        try {
            if (!StringUtils.isEmpty((CharSequence)contentType)) {
                String string = contentType;
                return string;
            }
            byte[] bytes = this.read(contentAsStream, 500);
            if (bytes.length == 0) {
                String string = "text/plain";
                return string;
            }
            String asAsciiString = new String(bytes, "ASCII").toUpperCase(Locale.ENGLISH);
            if (asAsciiString.contains("<HTML")) {
                String string = "text/html";
                return string;
            }
            if (this.startsWith(bytes, markerUTF8) || this.startsWith(bytes, markerUTF16BE) || this.startsWith(bytes, markerUTF16LE)) {
                String string = "text/plain";
                return string;
            }
            if (this.isBinary(bytes)) {
                String string = "application/octet-stream";
                return string;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentAsStream);
        }
        return "text/plain";
    }

    private boolean isBinary(byte[] bytes) {
        for (byte b : bytes) {
            if (b >= 8 && b != 11 && (b < 14 || b > 26) && (b < 28 || b > 31)) continue;
            return true;
        }
        return false;
    }

    private boolean startsWith(byte[] bytes, byte[] lookFor) {
        if (bytes.length < lookFor.length) {
            return false;
        }
        for (int i = 0; i < lookFor.length; ++i) {
            if (bytes[i] == lookFor[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] read(InputStream stream, int maxNb) throws IOException {
        byte[] buffer = new byte[maxNb];
        int nbRead = stream.read(buffer);
        if (nbRead == buffer.length) {
            return buffer;
        }
        return ArrayUtils.subarray((byte[])buffer, (int)0, (int)nbRead);
    }

    protected HtmlPage createHtmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        return HTMLParser.parseHtml(webResponse, webWindow);
    }

    protected XHtmlPage createXHtmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        return HTMLParser.parseXHtml(webResponse, webWindow);
    }

    protected JavaScriptPage createJavaScriptPage(WebResponse webResponse, WebWindow webWindow) {
        JavaScriptPage newPage = new JavaScriptPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected TextPage createTextPage(WebResponse webResponse, WebWindow webWindow) {
        TextPage newPage = new TextPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected UnexpectedPage createUnexpectedPage(WebResponse webResponse, WebWindow webWindow) {
        UnexpectedPage newPage = new UnexpectedPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected XmlPage createXmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XmlPage newPage = new XmlPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageType {
        HTML,
        JAVASCRIPT,
        XML,
        TEXT,
        UNKNOWN;

    }
}

