/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFrame
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(BaseFrame.class);
    private final WebWindow enclosedWindow_;
    private boolean contentLoaded_ = false;
    private boolean createdByJavascript_ = false;

    protected BaseFrame(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        FrameWindow enclosedWindow = null;
        try {
            if (this.getPage() instanceof HtmlPage) {
                enclosedWindow = new FrameWindow(this);
                WebClient webClient = this.getPage().getWebClient();
                HtmlPage temporaryPage = (HtmlPage)webClient.getPage(enclosedWindow, new WebRequest(WebClient.URL_ABOUT_BLANK));
                temporaryPage.setReadyState("loading");
            }
        }
        catch (FailingHttpStatusCodeException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        this.enclosedWindow_ = enclosedWindow;
    }

    public void loadInnerPage() throws FailingHttpStatusCodeException {
        String source = this.getSrcAttribute();
        if (source.length() == 0) {
            source = "about:blank";
        }
        this.loadInnerPageIfPossible(source);
        Page enclosedPage = this.getEnclosedPage();
        if (enclosedPage instanceof HtmlPage) {
            final HtmlPage htmlPage = (HtmlPage)enclosedPage;
            JavaScriptEngine jsEngine = this.getPage().getWebClient().getJavaScriptEngine();
            if (jsEngine.isScriptRunning()) {
                PostponedAction action = new PostponedAction(this.getPage()){

                    public void execute() throws Exception {
                        htmlPage.setReadyState("complete");
                    }
                };
                jsEngine.addPostponedAction(action);
            } else {
                htmlPage.setReadyState("complete");
            }
        }
    }

    boolean isContentLoaded() {
        return this.contentLoaded_;
    }

    void setContentLoaded() {
        this.contentLoaded_ = true;
    }

    private void loadInnerPageIfPossible(String src) throws FailingHttpStatusCodeException {
        this.setContentLoaded();
        if (src.length() != 0) {
            URL url;
            try {
                url = ((HtmlPage)this.getPage()).getFullyQualifiedUrl(src);
            }
            catch (MalformedURLException e) {
                this.notifyIncorrectness("Invalid src attribute of " + this.getTagName() + ": url=[" + src + "]. Ignored.");
                return;
            }
            if (this.isAlreadyLoadedByAncestor(url)) {
                this.notifyIncorrectness("Recursive src attribute of " + this.getTagName() + ": url=[" + src + "]. Ignored.");
                return;
            }
            try {
                WebRequest request = new WebRequest(url);
                request.setAdditionalHeader("Referer", this.getPage().getWebResponse().getWebRequest().getUrl().toExternalForm());
                this.getPage().getEnclosingWindow().getWebClient().getPage(this.enclosedWindow_, request);
            }
            catch (IOException e) {
                LOG.error((Object)("IOException when getting content for " + this.getTagName() + ": url=[" + url + "]"), (Throwable)e);
            }
        }
    }

    private boolean isAlreadyLoadedByAncestor(URL url) {
        WebWindow window = this.getPage().getEnclosingWindow();
        while (window != null) {
            if (url.sameFile(window.getEnclosedPage().getWebResponse().getWebRequest().getUrl())) {
                return true;
            }
            if (window == window.getParentWindow()) {
                window = null;
                continue;
            }
            window = window.getParentWindow();
        }
        return false;
    }

    public final String getLongDescAttribute() {
        return this.getAttribute("longdesc");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final void setNameAttribute(String name) {
        this.setAttribute("name", name);
    }

    public final String getSrcAttribute() {
        return this.getAttribute("src");
    }

    public final String getFrameBorderAttribute() {
        return this.getAttribute("frameborder");
    }

    public final String getMarginWidthAttribute() {
        return this.getAttribute("marginwidth");
    }

    public final String getMarginHeightAttribute() {
        return this.getAttribute("marginheight");
    }

    public final String getNoResizeAttribute() {
        return this.getAttribute("noresize");
    }

    public final String getScrollingAttribute() {
        return this.getAttribute("scrolling");
    }

    public final String getOnLoadAttribute() {
        return this.getAttribute("onload");
    }

    public Page getEnclosedPage() {
        return this.getEnclosedWindow().getEnclosedPage();
    }

    public WebWindow getEnclosedWindow() {
        return this.enclosedWindow_;
    }

    public final void setSrcAttribute(String attribute) {
        this.setAttribute("src", attribute);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        if ("src".equals(qualifiedName)) {
            attributeValue = attributeValue.trim();
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
        if ("src".equals(qualifiedName)) {
            JavaScriptEngine jsEngine = this.getPage().getWebClient().getJavaScriptEngine();
            if (!jsEngine.isScriptRunning() || attributeValue.startsWith("javascript:")) {
                this.loadInnerPageIfPossible(attributeValue);
            } else {
                final String src = attributeValue;
                PostponedAction action = new PostponedAction(this.getPage()){

                    public void execute() throws Exception {
                        if (BaseFrame.this.getSrcAttribute().equals(src)) {
                            BaseFrame.this.loadInnerPage();
                        }
                    }
                };
                jsEngine.addPostponedAction(action);
            }
        }
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public void unmarkAsCreatedByJavascript() {
        this.createdByJavascript_ = false;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }
}

