/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSubmitInput
extends HtmlInput {
    private static final String DEFAULT_VALUE = "Submit Query";

    HtmlSubmitInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.SUBMITINPUT_DEFAULT_VALUE_IF_VALUE_NOT_DEFINED) && !this.hasAttribute("value")) {
            this.setAttribute("value", DEFAULT_VALUE);
        }
    }

    @Override
    protected boolean doClickStateUpdate() throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            form.submit(this);
            return false;
        }
        super.doClickStateUpdate();
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public String asText() {
        String text = this.getValueAttribute();
        if (text == ATTRIBUTE_NOT_DEFINED) {
            text = DEFAULT_VALUE;
        }
        return text;
    }

    @Override
    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        for (DomAttr attribute : this.getAttributesMap().values()) {
            String name = attribute.getNodeName();
            String value = attribute.getValue();
            if ("value".equals(name) && DEFAULT_VALUE.equals(value)) continue;
            printWriter.print(" ");
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringUtils.escapeXmlAttributeValue(value));
            printWriter.print("\"");
        }
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        if (this.getNameAttribute().length() != 0 && !this.hasAttribute("value")) {
            return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), DEFAULT_VALUE)};
        }
        return super.getSubmitKeyValuePairs();
    }
}

