/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.xpath.XPathUtils;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XPathDomNodeList<E extends DomNode>
extends AbstractList<E>
implements DomNodeList<E>,
Serializable {
    private String xpath_;
    private DomNode node_;
    private Transformer transformer_;
    private List<Object> cachedElements_;

    public XPathDomNodeList(DomNode node, String xpath) {
        this(node, xpath, NOPTransformer.INSTANCE);
    }

    public XPathDomNodeList(DomNode node, String xpath, Transformer transformer) {
        if (node != null) {
            this.node_ = node;
            this.xpath_ = xpath;
            this.transformer_ = transformer;
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            this.node_.addDomChangeListener(listener);
            if (this.node_ instanceof HtmlElement) {
                ((HtmlElement)this.node_).addHtmlAttributeChangeListener(listener);
                this.cachedElements_ = null;
            }
        }
    }

    private List<Object> getNodes() {
        if (this.cachedElements_ == null) {
            this.cachedElements_ = this.node_ != null ? XPathUtils.getByXPath(this.node_, this.xpath_) : new ArrayList<Object>();
        }
        return this.cachedElements_;
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public int getLength() {
        return this.getNodes().size();
    }

    @Override
    public Node item(int index) {
        return (DomNode)this.transformer_.transform(this.getNodes().get(index));
    }

    @Override
    public E get(int index) {
        return (E)((DomNode)this.getNodes().get(index));
    }

    @Override
    public String toString() {
        return "XPathDomNodeList[" + this.xpath_ + "]";
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private DomHtmlAttributeChangeListenerImpl() {
        }

        public void nodeAdded(DomChangeEvent event) {
            XPathDomNodeList.this.cachedElements_ = null;
        }

        public void nodeDeleted(DomChangeEvent event) {
            XPathDomNodeList.this.cachedElements_ = null;
        }

        public void attributeAdded(HtmlAttributeChangeEvent event) {
            XPathDomNodeList.this.cachedElements_ = null;
        }

        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            XPathDomNodeList.this.cachedElements_ = null;
        }

        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            XPathDomNodeList.this.cachedElements_ = null;
        }
    }
}

