/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DefaultElementFactory;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.ElementFactory;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLErrorHandler;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HTMLScannerForIE;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBold;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFont;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlItalic;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlStrong;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlUnderlined;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.UnknownElementFactory;
import com.gargoylesoftware.htmlunit.html.XHtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.svg.SvgElementFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLEventInfo;
import org.cyberneko.html.HTMLScanner;
import org.cyberneko.html.HTMLTagBalancingListener;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class HTMLParser {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final Map<String, ElementFactory> ELEMENT_FACTORIES = new HashMap<String, ElementFactory>();
    private static final ElementFactory SVG_FACTORY = new SvgElementFactory();

    private HTMLParser() {
    }

    public static void parseFragment(DomNode parent, String source) throws SAXException, IOException {
        HTMLParser.parseFragment(parent, parent, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFragment(DomNode parent, DomNode context, String source) throws SAXException, IOException {
        HtmlPage page = (HtmlPage)parent.getPage();
        URL url = page.getUrl();
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(parent, url, source);
        domBuilder.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        ArrayList<QName> ancestors = new ArrayList<QName>();
        for (DomNode node = context; node != null && node.getNodeType() != 9; node = node.getParentNode()) {
            ancestors.add(0, new QName(null, node.getNodeName(), null, null));
        }
        if (ancestors.isEmpty() || !"html".equals(((QName)ancestors.get((int)0)).localpart)) {
            ancestors.add(0, new QName(null, "html", null, null));
        }
        if (ancestors.size() == 1 || !"body".equals(((QName)ancestors.get((int)1)).localpart)) {
            ancestors.add(1, new QName(null, "body", null, null));
        }
        domBuilder.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-tags", true);
        domBuilder.setProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack", ancestors.toArray(new QName[0]));
        XMLInputSource in = new XMLInputSource(null, url.toString(), null, (Reader)new StringReader(source), null);
        page.registerParsingStart();
        page.registerSnippetParsingStart();
        try {
            domBuilder.parse(in);
        }
        finally {
            page.registerParsingEnd();
            page.registerSnippetParsingEnd();
        }
    }

    public static HtmlPage parseHtml(WebResponse webResponse, WebWindow webWindow) throws IOException {
        HtmlPage page = new HtmlPage(webResponse.getWebRequest().getUrl(), webResponse, webWindow);
        HTMLParser.parse(webResponse, webWindow, page, false);
        return page;
    }

    public static XHtmlPage parseXHtml(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XHtmlPage page = new XHtmlPage(webResponse.getWebRequest().getUrl(), webResponse, webWindow);
        HTMLParser.parse(webResponse, webWindow, page, true);
        return page;
    }

    private static void parse(WebResponse webResponse, WebWindow webWindow, HtmlPage page, boolean xhtml) throws IOException {
        webWindow.setEnclosedPage(page);
        URL url = webResponse.getWebRequest().getUrl();
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(page, url, null);
        String charset = webResponse.getContentCharsetOrNull();
        try {
            if (charset != null) {
                domBuilder.setFeature("http://cyberneko.org/html/features/scanner/ignore-specified-charset", true);
            } else {
                String specifiedCharset = webResponse.getWebRequest().getCharset();
                if (specifiedCharset != null) {
                    charset = specifiedCharset;
                }
            }
            if (xhtml) {
                domBuilder.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-tags", true);
            }
        }
        catch (Exception e) {
            throw new ObjectInstantiationException("Error setting HTML parser feature", e);
        }
        InputStream content = webResponse.getContentAsStream();
        XMLInputSource in = new XMLInputSource(null, url.toString(), null, content, charset);
        page.registerParsingStart();
        try {
            domBuilder.parse(in);
        }
        catch (XNIException e) {
            Throwable origin = HTMLParser.extractNestedException(e);
            throw new RuntimeException("Failed parsing content from " + url, origin);
        }
        finally {
            page.registerParsingEnd();
        }
        HTMLParser.addBodyToPageIfNecessary(page, true, domBuilder.body_ != null);
    }

    private static void addBodyToPageIfNecessary(HtmlPage page, boolean originalCall, boolean checkInsideFrameOnly) {
        boolean waitToLoad = page.hasFeature(BrowserVersionFeatures.PAGE_WAIT_LOAD_BEFORE_BODY);
        if (page.getEnclosingWindow() instanceof FrameWindow && originalCall && waitToLoad) {
            return;
        }
        HtmlElement doc = page.getDocumentElement();
        boolean hasBody = false;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HtmlBody) && !(child instanceof HtmlFrameSet)) continue;
            hasBody = true;
            break;
        }
        if (!hasBody && !checkInsideFrameOnly) {
            HtmlBody body = new HtmlBody(null, "body", page, null, false);
            doc.appendChild(body);
        }
        if (waitToLoad) {
            for (FrameWindow frame : page.getFrames()) {
                Page containedPage = frame.getEnclosedPage();
                if (!(containedPage instanceof HtmlPage)) continue;
                HTMLParser.addBodyToPageIfNecessary((HtmlPage)containedPage, false, false);
            }
        }
    }

    static Throwable extractNestedException(Throwable e) {
        Throwable originalException = e;
        Throwable cause = ((XNIException)e).getException();
        while (cause != null) {
            originalException = cause;
            if (cause instanceof XNIException) {
                cause = ((XNIException)cause).getException();
                continue;
            }
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        return originalException;
    }

    public static ElementFactory getFactory(String tagName) {
        ElementFactory result = ELEMENT_FACTORIES.get(tagName);
        if (result != null) {
            return result;
        }
        return UnknownElementFactory.instance;
    }

    static ElementFactory getElementFactory(HtmlPage page, String namespaceURI, String qualifiedName) {
        if (namespaceURI == null || namespaceURI.isEmpty() || !qualifiedName.contains(":") || namespaceURI.equals(XHTML_NAMESPACE)) {
            if (SVG_NAMESPACE.equals(namespaceURI) && page.hasFeature(BrowserVersionFeatures.SVG)) {
                return SVG_FACTORY;
            }
            String tagName = qualifiedName;
            int index = tagName.indexOf(58);
            tagName = index != -1 ? tagName.substring(index + 1) : tagName.toLowerCase();
            ElementFactory factory = ELEMENT_FACTORIES.get(tagName);
            if (factory != null) {
                return factory;
            }
        }
        return UnknownElementFactory.instance;
    }

    static {
        ELEMENT_FACTORIES.put("input", InputElementFactory.instance);
        DefaultElementFactory defaultElementFactory = new DefaultElementFactory();
        for (String tagName : DefaultElementFactory.SUPPORTED_TAGS_) {
            ELEMENT_FACTORIES.put(tagName, defaultElementFactory);
        }
    }

    static final class HtmlUnitDOMBuilder
    extends AbstractSAXParser
    implements ContentHandler,
    LexicalHandler,
    HTMLTagBalancingListener {
        private final HtmlPage page_;
        private Locator locator_;
        private final Stack<DomNode> stack_ = new Stack();
        private DomNode currentNode_;
        private StringBuilder characters_;
        private boolean headParsed_ = false;
        private boolean parsingInnerHead_ = false;
        private HtmlElement head_;
        private HtmlElement body_;
        private Augmentations augmentations_;
        private HtmlForm formWaitingForLostChildren_;
        private static final String FEATURE_AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
        private static final String FEATURE_PARSE_NOSCRIPT = "http://cyberneko.org/html/features/parse-noscript-content";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushInputString(String html) {
            this.page_.registerParsingStart();
            this.page_.registerInlineSnippetParsingStart();
            try {
                WebResponse webResponse = this.page_.getWebResponse();
                String charset = webResponse.getContentCharset();
                String url = webResponse.getWebRequest().getUrl().toString();
                XMLInputSource in = new XMLInputSource(null, url, null, (Reader)new StringReader(html), charset);
                ((HTMLConfiguration)this.fConfiguration).evaluateInputSource(in);
            }
            finally {
                this.page_.registerParsingEnd();
                this.page_.registerInlineSnippetParsingEnd();
            }
        }

        private HtmlUnitDOMBuilder(DomNode node, URL url, String htmlContent) {
            super(HtmlUnitDOMBuilder.createConfiguration(node.getPage().getWebClient()));
            boolean reportErrors;
            this.page_ = (HtmlPage)node.getPage();
            this.currentNode_ = node;
            for (Node ancestor : this.currentNode_.getAncestors(true)) {
                this.stack_.push((DomNode)ancestor);
            }
            WebClient webClient = this.page_.getWebClient();
            HTMLParserListener listener = webClient.getHTMLParserListener();
            if (listener != null) {
                reportErrors = true;
                this.fConfiguration.setErrorHandler((XMLErrorHandler)new HTMLErrorHandler(listener, url, htmlContent));
            } else {
                reportErrors = false;
            }
            try {
                this.setFeature(FEATURE_AUGMENTATIONS, true);
                this.setProperty("http://cyberneko.org/html/properties/names/elems", "default");
                this.setFeature("http://cyberneko.org/html/features/report-errors", reportErrors);
                this.setFeature(FEATURE_PARSE_NOSCRIPT, !webClient.getOptions().isJavaScriptEnabled());
                this.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-iframe", !webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLIFRAME_IGNORE_SELFCLOSING));
                this.setContentHandler(this);
                this.setLexicalHandler(this);
            }
            catch (SAXException e) {
                throw new ObjectInstantiationException("unable to create HTML parser", e);
            }
        }

        private static XMLParserConfiguration createConfiguration(WebClient webClient) {
            final BrowserVersion browserVersion = webClient.getBrowserVersion();
            if (browserVersion.hasFeature(BrowserVersionFeatures.HTMLCONDITIONAL_COMMENTS)) {
                return new HTMLConfiguration(){

                    protected HTMLScanner createDocumentScanner() {
                        return new HTMLScannerForIE(browserVersion);
                    }
                };
            }
            return new HTMLConfiguration();
        }

        public Locator getLocator() {
            return this.locator_;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator_ = locator;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.handleCharacters();
            if (namespaceURI != null) {
                namespaceURI = namespaceURI.trim();
            }
            String tagLower = localName.toLowerCase();
            if (this.page_.isParsingHtmlSnippet() && ("html".equals(tagLower) || "body".equals(tagLower))) {
                return;
            }
            if (this.parsingInnerHead_ && this.page_.hasFeature(BrowserVersionFeatures.IGNORE_CONTENTS_OF_INNER_HEAD)) {
                return;
            }
            if ("head".equals(tagLower)) {
                if (this.headParsed_ || this.page_.isParsingHtmlSnippet()) {
                    this.parsingInnerHead_ = true;
                    return;
                }
                this.headParsed_ = true;
            } else if (!this.headParsed_ && ("body".equals(tagLower) || "frameset".equals(tagLower))) {
                ElementFactory factory = HTMLParser.getElementFactory(this.page_, namespaceURI, "head");
                DomElement newElement = factory.createElement(this.page_, "head", null);
                this.currentNode_.appendChild(newElement);
                this.headParsed_ = true;
            }
            HtmlBody oldBody = null;
            if ("body".equals(qName) && this.page_.getBody() instanceof HtmlBody) {
                oldBody = (HtmlBody)this.page_.getBody();
            }
            if (!(this.page_ instanceof XHtmlPage) && HTMLParser.XHTML_NAMESPACE.equals(namespaceURI)) {
                namespaceURI = null;
            }
            ElementFactory factory = HTMLParser.getElementFactory(this.page_, namespaceURI, qName);
            DomElement newElement = factory.createElementNS(this.page_, namespaceURI, qName, atts, true);
            newElement.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            this.addNodeToRightParent(this.currentNode_, newElement);
            if (oldBody != null) {
                oldBody.quietlyRemoveAndMoveChildrenTo(newElement);
            }
            if ("body".equals(tagLower)) {
                this.body_ = (HtmlElement)newElement;
            } else if ("head".equals(tagLower)) {
                this.head_ = (HtmlElement)newElement;
            }
            this.currentNode_ = newElement;
            this.stack_.push(this.currentNode_);
        }

        private void addNodeToRightParent(DomNode currentNode, DomElement newElement) {
            String currentNodeName = currentNode.getNodeName();
            String newNodeName = newElement.getNodeName();
            if ("table".equals(currentNodeName) && "div".equals(newNodeName)) {
                currentNode.insertBefore(newElement);
            } else if ("title".equals(newNodeName) && this.head_ != null) {
                this.head_.appendChild(newElement);
            } else {
                currentNode.appendChild(newElement);
            }
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            this.augmentations_ = augs;
            super.endElement(element, augs);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.handleCharacters();
            String tagLower = localName.toLowerCase();
            if (this.page_.isParsingHtmlSnippet() && ("html".equals(tagLower) || "body".equals(tagLower))) {
                return;
            }
            if (this.parsingInnerHead_) {
                if ("head".equals(tagLower)) {
                    this.parsingInnerHead_ = false;
                }
                if ("head".equals(tagLower) || this.page_.hasFeature(BrowserVersionFeatures.IGNORE_CONTENTS_OF_INNER_HEAD)) {
                    return;
                }
            }
            DomNode previousNode = this.stack_.pop();
            previousNode.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            if (previousNode instanceof HtmlForm && ((HTMLEventInfo)this.augmentations_.getItem(FEATURE_AUGMENTATIONS)).isSynthesized()) {
                this.formWaitingForLostChildren_ = (HtmlForm)previousNode;
            } else if (this.formWaitingForLostChildren_ != null && previousNode instanceof SubmittableElement) {
                this.formWaitingForLostChildren_.addLostChild((HtmlElement)previousNode);
            }
            if (!this.stack_.isEmpty()) {
                this.currentNode_ = this.stack_.peek();
            }
            boolean postponed = this.page_.isParsingInlineHtmlSnippet();
            previousNode.onAllChildrenAddedToPage(postponed);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if ((this.characters_ == null || this.characters_.length() == 0) && this.page_.hasFeature(BrowserVersionFeatures.HTMLPARSER_REMOVE_EMPTY_CONTENT) && StringUtils.isBlank((CharSequence)new String(ch, start, length))) {
                DomNode node = this.currentNode_.getLastChild();
                if (this.currentNode_ instanceof HTMLElement.ProxyDomNode) {
                    HTMLElement.ProxyDomNode proxyNode = (HTMLElement.ProxyDomNode)this.currentNode_;
                    node = proxyNode.getDomNode();
                    if (!proxyNode.isAppend() && (node = node.getPreviousSibling()) == null) {
                        node = proxyNode.getDomNode().getParentNode();
                    }
                }
                if (this.removeEmptyCharacters(node)) {
                    return;
                }
            }
            if (this.characters_ == null) {
                this.characters_ = new StringBuilder();
            }
            this.characters_.append(ch, start, length);
        }

        private boolean removeEmptyCharacters(DomNode node) {
            if (node != null) {
                if (node instanceof HtmlInput) {
                    return false;
                }
                if ((node instanceof HtmlAnchor || node instanceof HtmlSpan || node instanceof HtmlFont || node instanceof HtmlStrong || node instanceof HtmlBold || node instanceof HtmlItalic || node instanceof HtmlUnderlined) && node.getFirstChild() != null) {
                    return false;
                }
            } else if (this.currentNode_ instanceof HtmlFont) {
                return false;
            }
            return true;
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuilder();
            }
            this.characters_.append(ch, start, length);
        }

        private void handleCharacters() {
            if (this.characters_ != null && this.characters_.length() > 0) {
                if (this.currentNode_ instanceof HtmlHtml) {
                    this.characters_.setLength(0);
                } else {
                    String textValue = this.characters_.toString();
                    DomText text = new DomText(this.page_, textValue);
                    this.characters_.setLength(0);
                    if (this.currentNode_ instanceof HtmlTableRow && StringUtils.isNotBlank((CharSequence)textValue)) {
                        HtmlTableRow row = (HtmlTableRow)this.currentNode_;
                        HtmlTable enclosingTable = row.getEnclosingTable();
                        if (enclosingTable != null) {
                            enclosingTable.insertBefore(text);
                        }
                    } else {
                        this.currentNode_.appendChild(text);
                    }
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.handleCharacters();
            HtmlPage currentPage = this.page_;
            currentPage.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) {
            this.handleCharacters();
            String data = new String(ch, start, length);
            if (!data.startsWith("[CDATA") || !this.page_.hasFeature(BrowserVersionFeatures.GENERATED_3)) {
                DomComment comment = new DomComment(this.page_, data);
                this.currentNode_.appendChild(comment);
            }
        }

        @Override
        public void endCDATA() {
        }

        @Override
        public void endDTD() {
        }

        @Override
        public void endEntity(String name) {
        }

        @Override
        public void startCDATA() {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
            DomDocumentType type = new DomDocumentType(this.page_, name, publicId, systemId);
            this.page_.setDocumentType(type);
            this.page_.appendChild(type);
        }

        @Override
        public void startEntity(String name) {
        }

        public void ignoredEndElement(QName element, Augmentations augs) {
            if (this.formWaitingForLostChildren_ != null && "form".equals(element.localpart)) {
                this.formWaitingForLostChildren_ = null;
            }
        }

        public void ignoredStartElement(QName elem, XMLAttributes attrs, Augmentations augs) {
            if (this.body_ != null && "body".equalsIgnoreCase(elem.localpart) && attrs != null) {
                int length = attrs.getLength();
                for (int i = 0; i < length; ++i) {
                    String attrName = attrs.getLocalName(i).toLowerCase();
                    if (this.body_.getAttributes().getNamedItem(attrName) != null) continue;
                    this.body_.setAttribute(attrName, attrs.getValue(i));
                    if (!attrName.startsWith("on") || this.body_.getScriptObject() == null) continue;
                    HTMLBodyElement jsBody = (HTMLBodyElement)this.body_.getScriptObject();
                    jsBody.createEventHandlerFromAttribute(attrName, attrs.getValue(i));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(XMLInputSource inputSource) throws XNIException, IOException {
            HtmlUnitDOMBuilder oldBuilder = this.page_.getBuilder();
            this.page_.setBuilder(this);
            try {
                super.parse(inputSource);
            }
            finally {
                this.page_.setBuilder(oldBuilder);
            }
        }
    }
}

