/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSPrimitiveValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHtmlElement;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS21;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.EvaluatorException;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import net.sourceforge.htmlunit.corejs.javascript.WrappedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;

@JsxClass
public class CSSStyleDeclaration
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    protected static final String PRIORITY_IMPORTANT = "important";
    private static final String AZIMUTH = "azimuth";
    private static final String BACKGROUND = "background";
    private static final String BACKGROUND_ATTACHMENT = "background-attachment";
    private static final String BACKGROUND_COLOR = "background-color";
    private static final String BACKGROUND_IMAGE = "background-image";
    private static final String BACKGROUND_POSITION = "background-position";
    private static final String BACKGROUND_POSITION_X = "background-position-x";
    private static final String BACKGROUND_POSITION_Y = "background-position-y";
    private static final String BACKGROUND_REPEAT = "background-repeat";
    private static final String BEHAVIOR = "behavior";
    private static final String BORDER = "border";
    private static final String BORDER_BOTTOM = "border-bottom";
    private static final String BORDER_BOTTOM_COLOR = "border-bottom-color";
    private static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    private static final String BORDER_BOTTOM_WIDTH = "border-bottom-width";
    private static final String BORDER_COLLAPSE = "border-collapse";
    private static final String BORDER_COLOR = "border-color";
    private static final String BORDER_LEFT = "border-left";
    private static final String BORDER_LEFT_COLOR = "border-left-color";
    private static final String BORDER_LEFT_STYLE = "border-left-style";
    private static final String BORDER_WIDTH = "border-width";
    private static final String BORDER_LEFT_WIDTH = "border-left-width";
    private static final String BORDER_RIGHT = "border-right";
    private static final String BORDER_RIGHT_COLOR = "border-right-color";
    private static final String BORDER_RIGHT_STYLE = "border-right-style";
    private static final String BORDER_RIGHT_WIDTH = "border-right-width";
    private static final String BORDER_SPACING = "border-spacing";
    private static final String BORDER_STYLE = "border-style";
    private static final String BORDER_TOP = "border-top";
    private static final String BORDER_TOP_COLOR = "border-top-color";
    private static final String BORDER_TOP_STYLE = "border-top-style";
    private static final String BORDER_TOP_WIDTH = "border-top-width";
    private static final String BOTTOM = "bottom";
    private static final String BOX_SIZING = "box-sizing";
    private static final String CAPTION_SIDE = "caption-side";
    private static final String CLEAR = "clear";
    private static final String CLIP = "clip";
    private static final String COLOR = "color";
    private static final String CONTENT = "content";
    private static final String COUNTER_INCREMENT = "counter-increment";
    private static final String COUNTER_RESET = "counter-reset";
    private static final String CUE = "cue";
    private static final String CUE_AFTER = "cue-after";
    private static final String CUE_BEFORE = "cue-before";
    private static final String CURSOR = "cursor";
    private static final String DIRECTION = "direction";
    private static final String DISPLAY = "display";
    private static final String ELEVATION = "elevation";
    private static final String EMPTY_CELLS = "empty-cells";
    private static final String FILTER = "filter";
    private static final String FONT = "font";
    private static final String FONT_FAMILY = "font-family";
    private static final String FONT_SIZE = "font-size";
    private static final String FONT_SIZE_ADJUST = "font-size-adjust";
    private static final String FONT_STRETCH = "font-stretch";
    private static final String FONT_STYLE = "font-style";
    private static final String FONT_VARIANT = "font-variant";
    private static final String FONT_WEIGHT = "font-weight";
    private static final String HEIGHT = "height";
    private static final String IME_MODE = "ime-mode";
    private static final String LAYOUT_FLOW = "layout-flow";
    private static final String LAYOUT_GRID = "layout-grid";
    private static final String LAYOUT_GRID_CHAR = "layout-grid-char";
    private static final String LAYOUT_GRID_LINE = "layout-grid-line";
    private static final String LAYOUT_GRID_MODE = "layout-grid-mode";
    private static final String LAYOUT_GRID_TYPE = "layout-grid-type";
    private static final String LEFT = "left";
    private static final String LETTER_SPACING = "letter-spacing";
    private static final String LINE_BREAK = "line-break";
    private static final String LINE_HEIGHT = "line-height";
    private static final String LIST_STYLE = "list-style";
    private static final String LIST_STYLE_IMAGE = "list-style-image";
    private static final String LIST_STYLE_POSITION = "list-style-position";
    private static final String LIST_STYLE_TYPE = "list-style-type";
    private static final String MARGIN_BOTTOM = "margin-bottom";
    private static final String MARGIN_LEFT = "margin-left";
    private static final String MARGIN_RIGHT = "margin-right";
    private static final String MARGIN = "margin";
    private static final String MARGIN_TOP = "margin-top";
    private static final String MARKER_OFFSET = "marker-offset";
    private static final String MARKS = "marks";
    private static final String MAX_HEIGHT = "max-height";
    private static final String MAX_WIDTH = "max-width";
    private static final String MIN_HEIGHT = "min-height";
    private static final String MIN_WIDTH = "min-width";
    private static final String MOZ_APPEARANCE = "-moz-appearance";
    private static final String MOZ_BACKGROUND_CLIP = "-moz-background-clip";
    private static final String MOZ_BACKGROUND_INLINE_POLICY = "-moz-background-inline-policy";
    private static final String MOZ_BACKGROUND_ORIGIN = "-moz-background-origin";
    private static final String MOZ_BACKGROUND_SIZE = "-moz-background-size";
    private static final String MOZ_BINDING = "-moz-binding";
    private static final String MOZ_BORDER_BOTTOM_COLORS = "-moz-border-bottom-colors";
    private static final String MOZ_BORDER_END = "-moz-border-end";
    private static final String MOZ_BORDER_END_COLOR = "-moz-border-end-color";
    private static final String MOZ_BORDER_END_STYLE = "-moz-border-end-style";
    private static final String MOZ_BORDER_END_WIDTH = "-moz-border-end-width";
    private static final String MOZ_BORDER_IMAGE = "-moz-border-image";
    private static final String MOZ_BORDER_LEFT_COLORS = "-moz-border-left-colors";
    private static final String MOZ_BORDER_RADIUS = "-moz-border-radius";
    private static final String MOZ_BORDER_RADIUS_BOTTOMLEFT = "-moz-border-radius-bottomleft";
    private static final String MOZ_BORDER_RADIUS_BOTTOMRIGHT = "-moz-border-radius-bottomright";
    private static final String MOZ_BORDER_RADIUS_TOPLEFT = "-moz-border-radius-topleft";
    private static final String MOZ_BORDER_RADIUS_TOPRIGHT = "-moz-border-radius-topright";
    private static final String MOZ_BORDER_RIGHT_COLORS = "-moz-border-right-colors";
    private static final String MOZ_BORDER_START = "-moz-border-start";
    private static final String MOZ_BORDER_START_COLOR = "-moz-border-start-color";
    private static final String MOZ_BORDER_START_STYLE = "-moz-border-start-style";
    private static final String MOZ_BORDER_START_WIDTH = "-moz-border-start-width";
    private static final String MOZ_BORDER_TOP_COLORS = "-moz-border-top-colors";
    private static final String MOZ_BOX_ALIGN = "-moz-box-align";
    private static final String MOZ_BOX_DIRECTION = "-moz-box-direction";
    private static final String MOZ_BOX_FLEX = "-moz-box-flex";
    private static final String MOZ_BOX_ORDINAL_GROUP = "-moz-box-ordinal-group";
    private static final String MOZ_BOX_ORIENT = "-moz-box-orient";
    private static final String MOZ_BOX_PACK = "-moz-box-pack";
    private static final String MOZ_BOX_SHADOW = "-moz-box-shadow";
    private static final String MOZ_BOX_SIZING = "-moz-box-sizing";
    private static final String MOZ_COLUMN_COUNT = "-moz-column-count";
    private static final String MOZ_COLUMN_GAP = "-moz-column-gap";
    private static final String MOZ_COLUMN_RULE = "-moz-column-rule";
    private static final String MOZ_COLUMN_RULE_COLOR = "-moz-column-rule-color";
    private static final String MOZ_COLUMN_RULE_STYLE = "-moz-column-rule-style";
    private static final String MOZ_COLUMN_RULE_WIDTH = "-moz-column-rule-width";
    private static final String MOZ_COLUMN_WIDTH = "-moz-column-width";
    private static final String MOZ_FLOAT_EDGE = "-moz-float-edge";
    private static final String MOZ_FORCE_BROKEN_IMAGE_ICON = "-moz-force-broken-image-icon";
    private static final String MOZ_IMAGE_REGION = "-moz-image-region";
    private static final String MOZ_MARGIN_END = "-moz-margin-end";
    private static final String MOZ_MARGIN_START = "-moz-margin-start";
    private static final String MOZ_OPACITY = "-moz-opacity";
    private static final String MOZ_OUTLINE = "-moz-outline";
    private static final String MOZ_OUTLINE_COLOR = "-moz-outline-color";
    private static final String MOZ_OUTLINE_OFFSET = "-moz-outline-offset";
    private static final String MOZ_OUTLINE_RADIUS = "-mz-outline-radius";
    private static final String MOZ_OUTLINE_RADIUS_BOTTOMLEFT = "-moz-outline-radius-bottomleft";
    private static final String MOZ_OUTLINE_RADIUS_BOTTOMRIGHT = "-moz-outline-radius-bottomright";
    private static final String MOZ_OUTLINE_RADIUS_TOPLEFT = "-moz-outline-radius-topleft";
    private static final String MOZ_OUTLINE_RADIUS_TOPRIGHT = "-moz-outline-radius-topright";
    private static final String MOZ_OUTLINE_STYLE = "-moz-outline-style";
    private static final String MOZ_OUTLINE_WIDTH = "-moz-outline-width";
    private static final String MOZ_PADDING_END = "-moz-padding-end";
    private static final String MOZ_PADDING_START = "-moz-padding-start";
    private static final String MOZ_STACK_SIZING = "-moz-stack-sizing";
    private static final String MOZ_TRANSFORM = "-moz-transform";
    private static final String MOZ_TRANSFORM_ORIGIN = "-moz-transform-origin";
    private static final String MOZ_USER_FOCUS = "-moz-user-focus";
    private static final String MOZ_USER_INPUT = "-moz-user-input";
    private static final String MOZ_USER_MODIFY = "-moz-user-modify";
    private static final String MOZ_USER_SELECT = "-moz-user-select";
    private static final String MOZ_WINDOW_SHADOW = "-moz-window-shadow";
    private static final String MS_BLOCK_PROGRESSION = "ms-block-progression";
    private static final String MS_INTERPOLATION_MODE = "ms-interpolation-mode";
    private static final String OPACITY = "opacity";
    private static final String ORPHANS = "orphans";
    private static final String OUTLINE = "outline";
    private static final String OUTLINE_COLOR = "outline-color";
    private static final String OUTLINE_OFFSET = "outline-offset";
    private static final String OUTLINE_STYLE = "outline-style";
    private static final String OUTLINE_WIDTH = "outline-width";
    private static final String OVERFLOW = "overflow";
    private static final String OVERFLOW_X = "overflow-x";
    private static final String OVERFLOW_Y = "overflow-y";
    private static final String PADDING_BOTTOM = "padding-bottom";
    private static final String PADDING_LEFT = "padding-left";
    private static final String PADDING_RIGHT = "padding-right";
    private static final String PADDING = "padding";
    private static final String PADDING_TOP = "padding-top";
    private static final String PAGE = "page";
    private static final String PAGE_BREAK_AFTER = "page-break-after";
    private static final String PAGE_BREAK_BEFORE = "page-break-before";
    private static final String PAGE_BREAK_INSIDE = "page-break-inside";
    private static final String PAUSE = "pause";
    private static final String PAUSE_AFTER = "pause-after";
    private static final String PAUSE_BEFORE = "pause-before";
    private static final String PITCH = "pitch";
    private static final String PITCH_RANGE = "pitch-range";
    private static final String POINTER_EVENTS = "pointer-events";
    private static final String POSITION = "position";
    private static final String QUOTES = "quotes";
    private static final String RICHNESS = "richness";
    private static final String RIGHT = "right";
    private static final String RUBY_ALIGN = "ruby-align";
    private static final String RUBY_OVERHANG = "ruby-overhang";
    private static final String RUBY_POSITION = "ruby-position";
    private static final String SCROLLBAR3D_LIGHT_COLOR = "scrollbar3d-light-color";
    private static final String SCROLLBAR_ARROW_COLOR = "scrollbar-arrow-color";
    private static final String SCROLLBAR_BASE_COLOR = "scrollbar-base-color";
    private static final String SCROLLBAR_DARK_SHADOW_COLOR = "scrollbar-dark-shadow-color";
    private static final String SCROLLBAR_FACE_COLOR = "scrollbar-face-color";
    private static final String SCROLLBAR_HIGHLIGHT_COLOR = "scrollbar-highlight-color";
    private static final String SCROLLBAR_SHADOW_COLOR = "scrollbar-shadow-color";
    private static final String SCROLLBAR_TRACK_COLOR = "scrollbar-track-color";
    private static final String SIZE = "size";
    private static final String SPEAK = "speak";
    private static final String SPEAK_HEADER = "speak-header";
    private static final String SPEAK_NUMERAL = "speak-numeral";
    private static final String SPEAK_PUNCTUATION = "speak-punctuation";
    private static final String SPEECH_RATE = "speech-rate";
    private static final String STRESS = "stress";
    private static final String FLOAT = "float";
    private static final String TABLE_LAYOUT = "table-layout";
    private static final String TEXT_ALIGN = "text-align";
    private static final String TEXT_ALIGN_LAST = "text-align-last";
    private static final String TEXT_AUTOSPACE = "text-autospace";
    private static final String TEXT_DECORATION = "text-decoration";
    private static final String TEXT_INDENT = "text-indent";
    private static final String TEXT_JUSTIFY = "text-justify";
    private static final String TEXT_JUSTIFY_TRIM = "text-justify-trim";
    private static final String TEXT_KASHIDA = "text-kashida";
    private static final String TEXT_KASHIDA_SPACE = "text-kashida-space";
    private static final String TEXT_OVERFLOW = "text-overflow";
    private static final String TEXT_SHADOW = "text-shadow";
    private static final String TEXT_TRANSFORM = "text-transform";
    private static final String TEXT_UNDERLINE_POSITION = "text-underline-position";
    private static final String TOP = "top";
    private static final String UNICODE_BIDI = "unicode-bidi";
    private static final String VERTICAL_ALIGN = "vertical-align";
    private static final String VISIBILITY = "visibility";
    private static final String VOICE_FAMILY = "voice-family";
    private static final String VOLUME = "volume";
    private static final String WHITE_SPACE = "white-space";
    private static final String WIDOWS = "widows";
    private static final String WORD_BREAK = "word-break";
    private static final String WORD_SPACING = "word-spacing";
    private static final String WORD_WRAP = "word-wrap";
    private static final String WRITING_MODE = "writing-mode";
    private static final String Z_INDEX = "z-index";
    private static final String ZOOM = "zoom";
    protected static final String WIDTH = "width";
    private static final Pattern TO_INT_PATTERN = Pattern.compile("(\\d+).*");
    private static final Pattern URL_PATTERN = Pattern.compile("url\\(\\s*[\"']?(.*?)[\"']?\\s*\\)");
    private static final Pattern POSITION_PATTERN = Pattern.compile("(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex))\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|top|bottom|center)");
    private static final Pattern POSITION_PATTERN2 = Pattern.compile("(left|right|center)\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|top|bottom|center)");
    private static final Pattern POSITION_PATTERN3 = Pattern.compile("(top|bottom|center)\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|left|right|center)");
    private static final Log LOG = LogFactory.getLog(CSSStyleDeclaration.class);
    private static final Map<String, String> CSSColors_ = new HashMap<String, String>();
    private static final Map<String, String> CamelizeCache_ = new HashMap<String, String>();
    private static final Map<String, Integer> pixelValuesCache_ = new HashMap<String, Integer>();
    private static final MessageFormat URL_FORMAT = new MessageFormat("url({0})");
    private Element jsElement_;
    private org.w3c.dom.css.CSSStyleDeclaration styleDeclaration_;
    private long currentElementIndex_;

    public CSSStyleDeclaration() {
    }

    public CSSStyleDeclaration(Element element) {
        this.setParentScope(element.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.initialize(element);
    }

    CSSStyleDeclaration(Scriptable parentScope, org.w3c.dom.css.CSSStyleDeclaration styleDeclaration) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.styleDeclaration_ = styleDeclaration;
    }

    void initialize(Element element) {
        WebAssert.notNull("htmlElement", element);
        this.jsElement_ = element;
        this.setDomNode((DomNode)element.getDomNodeOrNull(), false);
        if (element instanceof HTMLElement && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_SUPPORTS_BEHAVIOR_PROPERTY)) {
            HTMLElement htmlElement = (HTMLElement)element;
            for (StyleElement styleElement : this.getStyleMap().values()) {
                if (!BEHAVIOR.equals(styleElement.getName())) continue;
                try {
                    Object[] url = URL_FORMAT.parse(styleElement.getValue());
                    if (url.length <= 0) continue;
                    htmlElement.addBehavior((String)url[0]);
                    break;
                }
                catch (ParseException e) {
                    LOG.warn((Object)("Invalid behavior: '" + styleElement.getValue() + "'."));
                }
            }
        }
    }

    @Override
    public Object getWithFallback(String name) {
        Map<String, StyleElement> style;
        StyleElement element;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_UNSUPPORTED_PROPERTY_GETTER) && null != this.jsElement_ && (element = (style = this.getStyleMap()).get(name)) != null && element.getValue() != null) {
            return element.getValue();
        }
        return NOT_FOUND;
    }

    protected HTMLElement getElement() {
        return (HTMLElement)this.jsElement_;
    }

    protected String getStyleAttribute(String name, Map<String, StyleElement> styleMap) {
        StyleElement element;
        if (this.styleDeclaration_ != null) {
            return this.styleDeclaration_.getPropertyValue(name);
        }
        Map<String, StyleElement> style = styleMap;
        if (null == style) {
            style = this.getStyleMap();
        }
        if ((element = style.get(name)) != null && element.getValue() != null) {
            return element.getValue();
        }
        return "";
    }

    private String getStyleAttribute(String name1, String name2, Shorthand shorthand) {
        String value;
        if (this.styleDeclaration_ != null) {
            String value1 = this.styleDeclaration_.getPropertyValue(name1);
            String value2 = this.styleDeclaration_.getPropertyValue(name2);
            if ("".equals(value1) && "".equals(value2)) {
                return "";
            }
            if (!"".equals(value1) && "".equals(value2)) {
                return value1;
            }
            value = value2;
        } else {
            Map<String, StyleElement> styleMap = this.getStyleMap();
            StyleElement element1 = styleMap.get(name1);
            StyleElement element2 = styleMap.get(name2);
            if (element1 == null && element2 == null) {
                return "";
            }
            if (element1 != null && element2 == null) {
                return element1.getValue();
            }
            if (element1 == null && element2 != null) {
                value = element2.getValue();
            } else {
                if (element1.getIndex() > element2.getIndex()) {
                    return element1.getValue();
                }
                value = element2.getValue();
            }
        }
        String[] values = StringUtils.split((String)value);
        switch (shorthand) {
            case TOP: {
                return values[0];
            }
            case RIGHT: {
                if (values.length > 1) {
                    return values[1];
                }
                return values[0];
            }
            case BOTTOM: {
                if (values.length > 2) {
                    return values[2];
                }
                return values[0];
            }
            case LEFT: {
                if (values.length > 3) {
                    return values[3];
                }
                if (values.length > 1) {
                    return values[1];
                }
                return values[0];
            }
        }
        throw new IllegalStateException("Unknown shorthand value: " + (Object)((Object)shorthand));
    }

    protected void setStyleAttribute(String name, String newValue) {
        if (this.styleDeclaration_ != null) {
            this.styleDeclaration_.setProperty(name, newValue, null);
            return;
        }
        this.replaceStyleAttribute(name, newValue);
    }

    private void replaceStyleAttribute(String name, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.removeStyleAttribute(name);
        } else {
            Map<String, StyleElement> styleMap = this.getStyleMap();
            StyleElement old = styleMap.get(name);
            long index = old != null ? old.getIndex() : this.getCurrentElementIndex();
            StyleElement element = new StyleElement(name, value, index);
            styleMap.put(name, element);
            this.writeToElement(styleMap);
        }
    }

    private String removeStyleAttribute(String name) {
        if (null != this.styleDeclaration_) {
            return this.styleDeclaration_.removeProperty(name);
        }
        Map<String, StyleElement> styleMap = this.getStyleMap();
        StyleElement value = styleMap.get(name);
        if (value == null) {
            return "";
        }
        styleMap.remove(name);
        this.writeToElement(styleMap);
        return value.getValue();
    }

    protected Map<String, StyleElement> getStyleMap() {
        LinkedHashMap<String, StyleElement> styleMap = new LinkedHashMap<String, StyleElement>();
        String styleAttribute = this.jsElement_.getDomNodeOrDie().getAttribute("style");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == styleAttribute || DomElement.ATTRIBUTE_VALUE_EMPTY == styleAttribute) {
            return styleMap;
        }
        for (String token : StringUtils.split((String)styleAttribute, (char)';')) {
            int index = token.indexOf(":");
            if (index == -1) continue;
            String key = token.substring(0, index).trim().toLowerCase();
            String value = token.substring(index + 1).trim();
            String priority = "";
            if (StringUtils.endsWithIgnoreCase((CharSequence)value, (CharSequence)"!important")) {
                priority = PRIORITY_IMPORTANT;
                value = value.substring(0, value.length() - 10);
                value = value.trim();
            }
            StyleElement element = new StyleElement(key, value, priority, SelectorSpecificity.FROM_STYLE_ATTRIBUTE, this.getCurrentElementIndex());
            styleMap.put(key, element);
        }
        return styleMap;
    }

    private void writeToElement(Map<String, StyleElement> styleMap) {
        StringBuilder buffer = new StringBuilder();
        TreeSet<StyleElement> sortedValues = new TreeSet<StyleElement>(styleMap.values());
        for (StyleElement e : sortedValues) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(e.getName());
            buffer.append(": ");
            buffer.append(e.getValue());
            buffer.append(";");
        }
        this.jsElement_.getDomNodeOrDie().setAttribute("style", buffer.toString());
    }

    protected long getCurrentElementIndex() {
        return this.currentElementIndex_++;
    }

    protected static String camelize(String string) {
        if (string == null) {
            return null;
        }
        String result = CamelizeCache_.get(string);
        if (null != result) {
            return result;
        }
        int pos = string.indexOf(45);
        if (pos == -1 || pos >= string.length() - 1) {
            CamelizeCache_.put(string, string);
            return string;
        }
        StringBuilder buffer = new StringBuilder(string);
        buffer.deleteCharAt(pos);
        buffer.setCharAt(pos, Character.toUpperCase(buffer.charAt(pos)));
        for (int i = pos + 1; i < buffer.length() - 1; ++i) {
            if (buffer.charAt(i) != '-') continue;
            buffer.deleteCharAt(i);
            buffer.setCharAt(i, Character.toUpperCase(buffer.charAt(i)));
        }
        result = buffer.toString();
        CamelizeCache_.put(string, result);
        return result;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getAzimuth() {
        return this.getStyleAttribute(AZIMUTH, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setAzimuth(String azimuth) {
        this.setStyleAttribute(AZIMUTH, azimuth);
    }

    @JsxGetter
    public String getBackground() {
        return this.getStyleAttribute(BACKGROUND, null);
    }

    @JsxSetter
    public void setBackground(String background) {
        this.setStyleAttribute(BACKGROUND, background);
    }

    @JsxGetter
    public String getBackgroundAttachment() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if (StringUtils.isBlank((CharSequence)(value = this.getStyleAttribute(BACKGROUND_ATTACHMENT, style)))) {
            String bg = this.getStyleAttribute(BACKGROUND, style);
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = CSSStyleDeclaration.findAttachment(bg);
                if (value == null) {
                    return "scroll";
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundAttachment(String backgroundAttachment) {
        this.setStyleAttribute(BACKGROUND_ATTACHMENT, backgroundAttachment);
    }

    @JsxGetter
    public String getBackgroundColor() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if (StringUtils.isBlank((CharSequence)(value = this.getStyleAttribute(BACKGROUND_COLOR, style)))) {
            String bg = this.getStyleAttribute(BACKGROUND, style);
            if (StringUtils.isBlank((CharSequence)bg)) {
                return "";
            }
            value = this.findColor(bg);
            if (value == null) {
                return "transparent";
            }
            return value;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundColor(String backgroundColor) {
        this.setStyleAttribute(BACKGROUND_COLOR, backgroundColor);
    }

    @JsxGetter
    public String getBackgroundImage() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if (StringUtils.isBlank((CharSequence)(value = this.getStyleAttribute(BACKGROUND_IMAGE, style)))) {
            String bg = this.getStyleAttribute(BACKGROUND, style);
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = this.findImageUrl(bg);
                if (value == null) {
                    return "none";
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundImage(String backgroundImage) {
        this.setStyleAttribute(BACKGROUND_IMAGE, backgroundImage);
    }

    @JsxGetter
    public String getBackgroundPosition() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute(BACKGROUND_POSITION, style)) == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(BACKGROUND, style);
            if (bg == null) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = CSSStyleDeclaration.findPosition(bg);
                if (value == null) {
                    return "0% 0%";
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundPosition(String backgroundPosition) {
        this.setStyleAttribute(BACKGROUND_POSITION, backgroundPosition);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBackgroundPositionX() {
        return this.getStyleAttribute(BACKGROUND_POSITION_X, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBackgroundPositionX(String backgroundPositionX) {
        this.setStyleAttribute(BACKGROUND_POSITION_X, backgroundPositionX);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBackgroundPositionY() {
        return this.getStyleAttribute(BACKGROUND_POSITION_Y, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBackgroundPositionY(String backgroundPositionY) {
        this.setStyleAttribute(BACKGROUND_POSITION_Y, backgroundPositionY);
    }

    @JsxGetter
    public String getBackgroundRepeat() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if (StringUtils.isBlank((CharSequence)(value = this.getStyleAttribute(BACKGROUND_REPEAT, style)))) {
            String bg = this.getStyleAttribute(BACKGROUND, style);
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = CSSStyleDeclaration.findRepeat(bg);
                if (value == null) {
                    return "repeat";
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundRepeat(String backgroundRepeat) {
        this.setStyleAttribute(BACKGROUND_REPEAT, backgroundRepeat);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBehavior() {
        return this.getStyleAttribute(BEHAVIOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBehavior(String behavior) {
        this.setStyleAttribute(BEHAVIOR, behavior);
        if (!(this.jsElement_ instanceof HTMLElement)) {
            throw new RuntimeException("Bug! behavior can be set for Element too!!!");
        }
        HTMLElement htmlElement = (HTMLElement)this.jsElement_;
        htmlElement.removeBehavior(0);
        htmlElement.removeBehavior(1);
        htmlElement.removeBehavior(2);
        if (!behavior.isEmpty()) {
            try {
                Object[] url = URL_FORMAT.parse(behavior);
                if (url.length > 0) {
                    htmlElement.addBehavior((String)url[0]);
                }
            }
            catch (ParseException e) {
                LOG.warn((Object)("Invalid behavior: '" + behavior + "'."));
            }
        }
    }

    @JsxGetter
    public String getBorder() {
        return this.getStyleAttribute(BORDER, null);
    }

    @JsxSetter
    public void setBorder(String border) {
        this.setStyleAttribute(BORDER, border);
    }

    @JsxGetter
    public String getBorderBottom() {
        return this.getStyleAttribute(BORDER_BOTTOM, null);
    }

    @JsxSetter
    public void setBorderBottom(String borderBottom) {
        this.setStyleAttribute(BORDER_BOTTOM, borderBottom);
    }

    @JsxGetter
    public String getBorderBottomColor() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute(BORDER_BOTTOM_COLOR, style)).isEmpty()) {
            value = this.findColor(this.getStyleAttribute(BORDER_BOTTOM, style));
            if (value == null) {
                value = this.findColor(this.getStyleAttribute(BORDER, style));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderBottomColor(String borderBottomColor) {
        this.setStyleAttribute(BORDER_BOTTOM_COLOR, borderBottomColor);
    }

    @JsxGetter
    public String getBorderBottomStyle() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute(BORDER_BOTTOM_STYLE, style)).isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_BOTTOM, style));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER, style));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderBottomStyle(String borderBottomStyle) {
        this.setStyleAttribute(BORDER_BOTTOM_STYLE, borderBottomStyle);
    }

    @JsxGetter
    public String getBorderBottomWidth() {
        return this.getBorderWidth(Shorthand.BOTTOM);
    }

    @JsxSetter
    public void setBorderBottomWidth(String borderBottomWidth) {
        this.setStyleAttributePixel(BORDER_BOTTOM_WIDTH, borderBottomWidth);
    }

    @JsxGetter
    public String getBorderCollapse() {
        return this.getStyleAttribute(BORDER_COLLAPSE, null);
    }

    @JsxSetter
    public void setBorderCollapse(String borderCollapse) {
        this.setStyleAttribute(BORDER_COLLAPSE, borderCollapse);
    }

    @JsxGetter
    public String getBorderColor() {
        return this.getStyleAttribute(BORDER_COLOR, null);
    }

    @JsxSetter
    public void setBorderColor(String borderColor) {
        this.setStyleAttribute(BORDER_COLOR, borderColor);
    }

    @JsxGetter
    public String getBorderLeft() {
        return this.getStyleAttribute(BORDER_LEFT, null);
    }

    @JsxSetter
    public void setBorderLeft(String borderLeft) {
        this.setStyleAttribute(BORDER_LEFT, borderLeft);
    }

    @JsxGetter
    public String getBorderLeftColor() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute(BORDER_LEFT_COLOR, style)).isEmpty()) {
            value = this.findColor(this.getStyleAttribute(BORDER_LEFT, style));
            if (value == null) {
                value = this.findColor(this.getStyleAttribute(BORDER, style));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderLeftColor(String borderLeftColor) {
        this.setStyleAttribute(BORDER_LEFT_COLOR, borderLeftColor);
    }

    @JsxGetter
    public String getBorderLeftStyle() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute(BORDER_LEFT_STYLE, style)).isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_LEFT, style));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER, style));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderLeftStyle(String borderLeftStyle) {
        this.setStyleAttribute(BORDER_LEFT_STYLE, borderLeftStyle);
    }

    @JsxGetter
    public String getBorderLeftWidth() {
        return this.getBorderWidth(Shorthand.LEFT);
    }

    private String getBorderWidth(Shorthand side) {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute("border-" + (Object)((Object)side) + "-width", style)).isEmpty()) {
            String[] values;
            String borderWidth;
            value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute("border-" + (Object)((Object)side), style));
            if (value == null && !StringUtils.isEmpty((CharSequence)(borderWidth = this.getStyleAttribute(BORDER_WIDTH, style))) && (values = StringUtils.split((String)borderWidth)).length > side.ordinal()) {
                value = values[side.ordinal()];
            }
            if (value == null) {
                value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute(BORDER, style));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderLeftWidth(String borderLeftWidth) {
        this.setStyleAttributePixel(BORDER_LEFT_WIDTH, borderLeftWidth);
    }

    @JsxGetter
    public String getBorderRight() {
        return this.getStyleAttribute(BORDER_RIGHT, null);
    }

    @JsxSetter
    public void setBorderRight(String borderRight) {
        this.setStyleAttribute(BORDER_RIGHT, borderRight);
    }

    @JsxGetter
    public String getBorderRightColor() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute(BORDER_RIGHT_COLOR, style)).isEmpty()) {
            value = this.findColor(this.getStyleAttribute(BORDER_RIGHT, style));
            if (value == null) {
                value = this.findColor(this.getStyleAttribute(BORDER, style));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderRightColor(String borderRightColor) {
        this.setStyleAttribute(BORDER_RIGHT_COLOR, borderRightColor);
    }

    @JsxGetter
    public String getBorderRightStyle() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute(BORDER_RIGHT_STYLE, style)).isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_RIGHT, style));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER, style));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderRightStyle(String borderRightStyle) {
        this.setStyleAttribute(BORDER_RIGHT_STYLE, borderRightStyle);
    }

    @JsxGetter
    public String getBorderRightWidth() {
        return this.getBorderWidth(Shorthand.RIGHT);
    }

    @JsxSetter
    public void setBorderRightWidth(String borderRightWidth) {
        this.setStyleAttributePixel(BORDER_RIGHT_WIDTH, borderRightWidth);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getBorderSpacing() {
        return this.getStyleAttribute(BORDER_SPACING, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setBorderSpacing(String borderSpacing) {
        this.setStyleAttribute(BORDER_SPACING, borderSpacing);
    }

    @JsxGetter
    public String getBorderStyle() {
        return this.getStyleAttribute(BORDER_STYLE, null);
    }

    @JsxSetter
    public void setBorderStyle(String borderStyle) {
        this.setStyleAttribute(BORDER_STYLE, borderStyle);
    }

    @JsxGetter
    public String getBorderTop() {
        return this.getStyleAttribute(BORDER_TOP, null);
    }

    @JsxSetter
    public void setBorderTop(String borderTop) {
        this.setStyleAttribute(BORDER_TOP, borderTop);
    }

    @JsxGetter
    public String getBorderTopColor() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute(BORDER_TOP_COLOR, style)).isEmpty()) {
            value = this.findColor(this.getStyleAttribute(BORDER_TOP, style));
            if (value == null) {
                value = this.findColor(this.getStyleAttribute(BORDER, style));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderTopColor(String borderTopColor) {
        this.setStyleAttribute(BORDER_TOP_COLOR, borderTopColor);
    }

    @JsxGetter
    public String getBorderTopStyle() {
        String value;
        Map<String, StyleElement> style = null;
        if (this.styleDeclaration_ == null) {
            style = this.getStyleMap();
        }
        if ((value = this.getStyleAttribute(BORDER_TOP_STYLE, style)).isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_TOP, style));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER, style));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderTopStyle(String borderTopStyle) {
        this.setStyleAttribute(BORDER_TOP_STYLE, borderTopStyle);
    }

    @JsxGetter
    public String getBorderTopWidth() {
        return this.getBorderWidth(Shorthand.TOP);
    }

    @JsxSetter
    public void setBorderTopWidth(String borderTopWidth) {
        this.setStyleAttributePixel(BORDER_TOP_WIDTH, borderTopWidth);
    }

    @JsxGetter
    public String getBorderWidth() {
        return this.getStyleAttribute(BORDER_WIDTH, null);
    }

    @JsxSetter
    public void setBorderWidth(String borderWidth) {
        this.setStyleAttribute(BORDER_WIDTH, borderWidth);
    }

    @JsxGetter
    public String getBottom() {
        return this.getStyleAttribute(BOTTOM, null);
    }

    @JsxSetter
    public void setBottom(String bottom) {
        this.setStyleAttributePixel(BOTTOM, bottom);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f)})
    public String getBoxSizing() {
        return this.getStyleAttribute(BOX_SIZING, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f)})
    public void setBoxSizing(String boxSizing) {
        this.setStyleAttribute(BOX_SIZING, boxSizing);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getCaptionSide() {
        return this.getStyleAttribute(CAPTION_SIDE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setCaptionSide(String captionSide) {
        this.setStyleAttribute(CAPTION_SIDE, captionSide);
    }

    @JsxGetter
    public String getClear() {
        return this.getStyleAttribute(CLEAR, null);
    }

    @JsxSetter
    public void setClear(String clear) {
        this.setStyleAttribute(CLEAR, clear);
    }

    @JsxGetter
    public String getClip() {
        return this.getStyleAttribute(CLIP, null);
    }

    @JsxSetter
    public void setClip(String clip) {
        this.setStyleAttribute(CLIP, clip);
    }

    @JsxGetter
    public String getColor() {
        return this.getStyleAttribute(COLOR, null);
    }

    @JsxSetter
    public void setColor(String color) {
        this.setStyleAttribute(COLOR, color);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getContent() {
        return this.getStyleAttribute(CONTENT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setContent(String content) {
        this.setStyleAttribute(CONTENT, content);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getCounterIncrement() {
        return this.getStyleAttribute(COUNTER_INCREMENT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setCounterIncrement(String counterIncrement) {
        this.setStyleAttribute(COUNTER_INCREMENT, counterIncrement);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getCounterReset() {
        return this.getStyleAttribute(COUNTER_RESET, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setCounterReset(String counterReset) {
        this.setStyleAttribute(COUNTER_RESET, counterReset);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getCssFloat() {
        return this.getStyleAttribute(FLOAT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setCssFloat(String value) {
        this.setStyleAttribute(FLOAT, value);
    }

    @JsxGetter
    public String getCssText() {
        return this.jsElement_.getDomNodeOrDie().getAttribute("style");
    }

    @JsxSetter
    public void setCssText(String value) {
        this.jsElement_.getDomNodeOrDie().setAttribute("style", value);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getCue() {
        return this.getStyleAttribute(CUE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setCue(String cue) {
        this.setStyleAttribute(CUE, cue);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getCueAfter() {
        return this.getStyleAttribute(CUE_AFTER, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setCueAfter(String cueAfter) {
        this.setStyleAttribute(CUE_AFTER, cueAfter);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getCueBefore() {
        return this.getStyleAttribute(CUE_BEFORE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setCueBefore(String cueBefore) {
        this.setStyleAttribute(CUE_BEFORE, cueBefore);
    }

    @JsxGetter
    public String getCursor() {
        return this.getStyleAttribute(CURSOR, null);
    }

    @JsxSetter
    public void setCursor(String cursor) {
        this.setStyleAttribute(CURSOR, cursor);
    }

    @JsxGetter
    public String getDirection() {
        return this.getStyleAttribute(DIRECTION, null);
    }

    @JsxSetter
    public void setDirection(String direction) {
        this.setStyleAttribute(DIRECTION, direction);
    }

    @JsxGetter
    public String getDisplay() {
        return this.getStyleAttribute(DISPLAY, null);
    }

    @JsxSetter
    public void setDisplay(String display) {
        this.setStyleAttribute(DISPLAY, display);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getElevation() {
        return this.getStyleAttribute(ELEVATION, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setElevation(String elevation) {
        this.setStyleAttribute(ELEVATION, elevation);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getEmptyCells() {
        return this.getStyleAttribute(EMPTY_CELLS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setEmptyCells(String emptyCells) {
        this.setStyleAttribute(EMPTY_CELLS, emptyCells);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getFilter() {
        return this.getStyleAttribute(FILTER, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setFilter(String filter) {
        this.setStyleAttribute(FILTER, filter);
    }

    @JsxGetter
    public String getFont() {
        return this.getStyleAttribute(FONT, null);
    }

    @JsxSetter
    public void setFont(String font) {
        this.setStyleAttribute(FONT, font);
    }

    @JsxGetter
    public String getFontFamily() {
        return this.getStyleAttribute(FONT_FAMILY, null);
    }

    @JsxSetter
    public void setFontFamily(String fontFamily) {
        this.setStyleAttribute(FONT_FAMILY, fontFamily);
    }

    @JsxGetter
    public String getFontSize() {
        return this.getStyleAttribute(FONT_SIZE, null);
    }

    @JsxSetter
    public void setFontSize(String fontSize) {
        this.setStyleAttributePixel(FONT_SIZE, fontSize);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getFontSizeAdjust() {
        return this.getStyleAttribute(FONT_SIZE_ADJUST, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setFontSizeAdjust(String fontSizeAdjust) {
        this.setStyleAttribute(FONT_SIZE_ADJUST, fontSizeAdjust);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getFontStretch() {
        return this.getStyleAttribute(FONT_STRETCH, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setFontStretch(String fontStretch) {
        this.setStyleAttribute(FONT_STRETCH, fontStretch);
    }

    @JsxGetter
    public String getFontStyle() {
        return this.getStyleAttribute(FONT_STYLE, null);
    }

    @JsxSetter
    public void setFontStyle(String fontStyle) {
        this.setStyleAttribute(FONT_STYLE, fontStyle);
    }

    @JsxGetter
    public String getFontVariant() {
        return this.getStyleAttribute(FONT_VARIANT, null);
    }

    @JsxSetter
    public void setFontVariant(String fontVariant) {
        this.setStyleAttribute(FONT_VARIANT, fontVariant);
    }

    @JsxGetter
    public String getFontWeight() {
        return this.getStyleAttribute(FONT_WEIGHT, null);
    }

    @JsxSetter
    public void setFontWeight(String fontWeight) {
        this.setStyleAttribute(FONT_WEIGHT, fontWeight);
    }

    @JsxGetter
    public String getHeight() {
        return this.getStyleAttribute(HEIGHT, null);
    }

    @JsxSetter
    public void setHeight(String height) {
        this.setStyleAttributePixel(HEIGHT, height);
    }

    @JsxGetter
    public String getImeMode() {
        return this.getStyleAttribute(IME_MODE, null);
    }

    @JsxSetter
    public void setImeMode(String imeMode) {
        this.setStyleAttribute(IME_MODE, imeMode);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getLayoutFlow() {
        return this.getStyleAttribute(LAYOUT_FLOW, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setLayoutFlow(String layoutFlow) {
        this.setStyleAttribute(LAYOUT_FLOW, layoutFlow);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getLayoutGrid() {
        return this.getStyleAttribute(LAYOUT_GRID, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setLayoutGrid(String layoutGrid) {
        this.setStyleAttribute(LAYOUT_GRID_CHAR, layoutGrid);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getLayoutGridChar() {
        return this.getStyleAttribute(LAYOUT_GRID_CHAR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setLayoutGridChar(String layoutGridChar) {
        this.setStyleAttribute(LAYOUT_GRID_CHAR, layoutGridChar);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getLayoutGridLine() {
        return this.getStyleAttribute(LAYOUT_GRID_LINE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setLayoutGridLine(String layoutGridLine) {
        this.setStyleAttribute(LAYOUT_GRID_LINE, layoutGridLine);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getLayoutGridMode() {
        return this.getStyleAttribute(LAYOUT_GRID_MODE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setLayoutGridMode(String layoutGridMode) {
        this.setStyleAttribute(LAYOUT_GRID_MODE, layoutGridMode);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getLayoutGridType() {
        return this.getStyleAttribute(LAYOUT_GRID_TYPE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setLayoutGridType(String layoutGridType) {
        this.setStyleAttribute(LAYOUT_GRID_TYPE, layoutGridType);
    }

    @JsxGetter
    public String getLeft() {
        return this.getStyleAttribute(LEFT, null);
    }

    @JsxSetter
    public void setLeft(String left) {
        this.setStyleAttributePixel(LEFT, left);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getLength() {
        return 0;
    }

    @JsxGetter
    public String getLetterSpacing() {
        return this.getStyleAttribute(LETTER_SPACING, null);
    }

    @JsxSetter
    public void setLetterSpacing(String letterSpacing) {
        this.setStyleAttributePixel(LETTER_SPACING, letterSpacing);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getLineBreak() {
        return this.getStyleAttribute(LINE_BREAK, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setLineBreak(String lineBreak) {
        this.setStyleAttribute(LINE_BREAK, lineBreak);
    }

    @JsxGetter
    public String getLineHeight() {
        return this.getStyleAttribute(LINE_HEIGHT, null);
    }

    @JsxSetter
    public void setLineHeight(String lineHeight) {
        this.setStyleAttribute(LINE_HEIGHT, lineHeight);
    }

    @JsxGetter
    public String getListStyle() {
        return this.getStyleAttribute(LIST_STYLE, null);
    }

    @JsxSetter
    public void setListStyle(String listStyle) {
        this.setStyleAttribute(LIST_STYLE, listStyle);
    }

    @JsxGetter
    public String getListStyleImage() {
        return this.getStyleAttribute(LIST_STYLE_IMAGE, null);
    }

    @JsxSetter
    public void setListStyleImage(String listStyleImage) {
        this.setStyleAttribute(LIST_STYLE_IMAGE, listStyleImage);
    }

    @JsxGetter
    public String getListStylePosition() {
        return this.getStyleAttribute(LIST_STYLE_POSITION, null);
    }

    @JsxSetter
    public void setListStylePosition(String listStylePosition) {
        this.setStyleAttribute(LIST_STYLE_POSITION, listStylePosition);
    }

    @JsxGetter
    public String getListStyleType() {
        return this.getStyleAttribute(LIST_STYLE_TYPE, null);
    }

    @JsxSetter
    public void setListStyleType(String listStyleType) {
        this.setStyleAttribute(LIST_STYLE_TYPE, listStyleType);
    }

    @JsxGetter
    public String getMargin() {
        return this.getStyleAttribute(MARGIN, null);
    }

    @JsxSetter
    public void setMargin(String margin) {
        this.setStyleAttribute(MARGIN, margin);
    }

    @JsxGetter
    public String getMarginBottom() {
        return this.getStyleAttribute(MARGIN_BOTTOM, MARGIN, Shorthand.BOTTOM);
    }

    @JsxSetter
    public void setMarginBottom(String marginBottom) {
        this.setStyleAttributePixel(MARGIN_BOTTOM, marginBottom);
    }

    @JsxGetter
    public String getMarginLeft() {
        return this.getStyleAttribute(MARGIN_LEFT, MARGIN, Shorthand.LEFT);
    }

    @JsxSetter
    public void setMarginLeft(String marginLeft) {
        this.setStyleAttributePixel(MARGIN_LEFT, marginLeft);
    }

    @JsxGetter
    public String getMarginRight() {
        return this.getStyleAttribute(MARGIN_RIGHT, MARGIN, Shorthand.RIGHT);
    }

    @JsxSetter
    public void setMarginRight(String marginRight) {
        this.setStyleAttributePixel(MARGIN_RIGHT, marginRight);
    }

    @JsxGetter
    public String getMarginTop() {
        return this.getStyleAttribute(MARGIN_TOP, MARGIN, Shorthand.TOP);
    }

    @JsxSetter
    public void setMarginTop(String marginTop) {
        this.setStyleAttributePixel(MARGIN_TOP, marginTop);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getMarkerOffset() {
        return this.getStyleAttribute(MARKER_OFFSET, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setMarkerOffset(String markerOffset) {
        this.setStyleAttribute(MARKER_OFFSET, markerOffset);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getMarks() {
        return this.getStyleAttribute(MARKS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setMarks(String marks) {
        this.setStyleAttribute(MARKS, marks);
    }

    @JsxGetter
    public String getMaxHeight() {
        return this.getStyleAttribute(MAX_HEIGHT, null);
    }

    @JsxSetter
    public void setMaxHeight(String maxHeight) {
        this.setStyleAttributePixel(MAX_HEIGHT, maxHeight);
    }

    @JsxGetter
    public String getMaxWidth() {
        return this.getStyleAttribute(MAX_WIDTH, null);
    }

    @JsxSetter
    public void setMaxWidth(String maxWidth) {
        this.setStyleAttributePixel(MAX_WIDTH, maxWidth);
    }

    @JsxGetter
    public String getMinHeight() {
        return this.getStyleAttribute(MIN_HEIGHT, null);
    }

    @JsxSetter
    public void setMinHeight(String minHeight) {
        this.setStyleAttributePixel(MIN_HEIGHT, minHeight);
    }

    @JsxGetter
    public String getMinWidth() {
        return this.getStyleAttribute(MIN_WIDTH, null);
    }

    @JsxSetter
    public void setMinWidth(String minWidth) {
        this.setStyleAttributePixel(MIN_WIDTH, minWidth);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozAppearance")
    public String getMozAppearance() {
        return this.getStyleAttribute(MOZ_APPEARANCE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozAppearance")
    public void setMozAppearance(String mozAppearance) {
        this.setStyleAttribute(MOZ_APPEARANCE, mozAppearance);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBackgroundClip")
    public String getMozBackgroundClip() {
        return this.getStyleAttribute(MOZ_BACKGROUND_CLIP, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBackgroundClip")
    public void setMozBackgroundClip(String mozBackgroundClip) {
        this.setStyleAttribute(MOZ_BACKGROUND_CLIP, mozBackgroundClip);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBackgroundInlinePolicy")
    public String getMozBackgroundInlinePolicy() {
        return this.getStyleAttribute(MOZ_BACKGROUND_INLINE_POLICY, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBackgroundInlinePolicy")
    public void setMozBackgroundInlinePolicy(String mozBackgroundInlinePolicy) {
        this.setStyleAttribute(MOZ_BACKGROUND_INLINE_POLICY, mozBackgroundInlinePolicy);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBackgroundOrigin")
    public String getMozBackgroundOrigin() {
        return this.getStyleAttribute(MOZ_BACKGROUND_ORIGIN, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBackgroundOrigin")
    public void setMozBackgroundOrigin(String mozBackgroundOrigin) {
        this.setStyleAttribute(MOZ_BACKGROUND_ORIGIN, mozBackgroundOrigin);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBackgroundSize")
    public String getMozBackgroundSize() {
        return this.getStyleAttribute(MOZ_BACKGROUND_SIZE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBackgroundSize")
    public void setMozBackgroundSize(String mozBackgroundSize) {
        this.setStyleAttribute(MOZ_BACKGROUND_SIZE, mozBackgroundSize);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBinding")
    public String getMozBinding() {
        return this.getStyleAttribute(MOZ_BINDING, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBinding")
    public void setMozBinding(String mozBinding) {
        this.setStyleAttribute(MOZ_BINDING, mozBinding);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderBottomColors")
    public String getMozBorderBottomColors() {
        return this.getStyleAttribute(MOZ_BORDER_BOTTOM_COLORS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderBottomColors")
    public void setMozBorderBottomColors(String mozBorderBottomColors) {
        this.setStyleAttribute(MOZ_BORDER_BOTTOM_COLORS, mozBorderBottomColors);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderEnd")
    public String getMozBorderEnd() {
        return this.getStyleAttribute(MOZ_BORDER_END, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderEnd")
    public void setMozBorderEnd(String mozBorderEnd) {
        this.setStyleAttribute(MOZ_BORDER_END, mozBorderEnd);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderEndColor")
    public String getMozBorderEndColor() {
        return this.getStyleAttribute(MOZ_BORDER_END_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderEndColor")
    public void setMozBorderEndColor(String mozBorderEndColor) {
        this.setStyleAttribute(MOZ_BORDER_END_COLOR, mozBorderEndColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderEndStyle")
    public String getMozBorderEndStyle() {
        return this.getStyleAttribute(MOZ_BORDER_END_STYLE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderEndStyle")
    public void setMozBorderEndStyle(String mozBorderEndStyle) {
        this.setStyleAttribute(MOZ_BORDER_END_STYLE, mozBorderEndStyle);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderEndWidth")
    public String getMozBorderEndWidth() {
        return this.getStyleAttribute(MOZ_BORDER_END_WIDTH, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderEndWidth")
    public void setMozBorderEndWidth(String mozBorderEndWidth) {
        this.setStyleAttribute(MOZ_BORDER_END_WIDTH, mozBorderEndWidth);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderImage")
    public String getMozBorderImage() {
        return this.getStyleAttribute(MOZ_BORDER_IMAGE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderImage")
    public void setMozBorderImage(String mozBorderImage) {
        this.setStyleAttribute(MOZ_BORDER_IMAGE, mozBorderImage);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderLeftColors")
    public String getMozBorderLeftColors() {
        return this.getStyleAttribute(MOZ_BORDER_LEFT_COLORS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderLeftColors")
    public void setMozBorderLeftColors(String mozBorderLeftColors) {
        this.setStyleAttribute(MOZ_BORDER_LEFT_COLORS, mozBorderLeftColors);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadius")
    public String getMozBorderRadius() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadius")
    public void setMozBorderRadius(String mozBorderRadius) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS, mozBorderRadius);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadiusBottomleft")
    public String getMozBorderRadiusBottomleft() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS_BOTTOMLEFT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadiusBottomleft")
    public void setMozBorderRadiusBottomleft(String mozBorderRadiusBottomleft) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS_BOTTOMLEFT, mozBorderRadiusBottomleft);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadiusBottomright")
    public String getMozBorderRadiusBottomright() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS_BOTTOMRIGHT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadiusBottomright")
    public void setMozBorderRadiusBottomright(String mozBorderRadiusBottomright) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS_BOTTOMRIGHT, mozBorderRadiusBottomright);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadiusTopleft")
    public String getMozBorderRadiusTopleft() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS_TOPLEFT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadiusTopleft")
    public void setMozBorderRadiusTopleft(String mozBorderRadiusTopleft) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS_TOPLEFT, mozBorderRadiusTopleft);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadiusTopright")
    public String getMozBorderRadiusTopright() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS_TOPRIGHT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRadiusTopright")
    public void setMozBorderRadiusTopright(String mozBorderRadiusTopright) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS_TOPRIGHT, mozBorderRadiusTopright);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRightColors")
    public String getMozBorderRightColors() {
        return this.getStyleAttribute(MOZ_BORDER_RIGHT_COLORS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderRightColors")
    public void setMozBorderRightColors(String mozBorderRightColors) {
        this.setStyleAttribute(MOZ_BORDER_RIGHT_COLORS, mozBorderRightColors);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderStart")
    public String getMozBorderStart() {
        return this.getStyleAttribute(MOZ_BORDER_START, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderStart")
    public void setMozBorderStart(String mozBorderStart) {
        this.setStyleAttribute(MOZ_BORDER_START, mozBorderStart);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderStartColor")
    public String getMozBorderStartColor() {
        return this.getStyleAttribute(MOZ_BORDER_START_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderStartColor")
    public void setMozBorderStartColor(String mozBorderStartColor) {
        this.setStyleAttribute(MOZ_BORDER_START_COLOR, mozBorderStartColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderStartStyle")
    public String getMozBorderStartStyle() {
        return this.getStyleAttribute(MOZ_BORDER_START_STYLE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderStartStyle")
    public void setMozBorderStartStyle(String mozBorderStartStyle) {
        this.setStyleAttribute(MOZ_BORDER_START_STYLE, mozBorderStartStyle);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderStartWidth")
    public String getMozBorderStartWidth() {
        return this.getStyleAttribute(MOZ_BORDER_START_WIDTH, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderStartWidth")
    public void setMozBorderStartWidth(String mozBorderStartWidth) {
        this.setStyleAttribute(MOZ_BORDER_START_WIDTH, mozBorderStartWidth);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderTopColors")
    public String getMozBorderTopColors() {
        return this.getStyleAttribute(MOZ_BORDER_TOP_COLORS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBorderTopColors")
    public void setMozBorderTopColors(String mozBorderTopColors) {
        this.setStyleAttribute(MOZ_BORDER_TOP_COLORS, mozBorderTopColors);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxAlign")
    public String getMozBoxAlign() {
        return this.getStyleAttribute(MOZ_BOX_ALIGN, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxAlign")
    public void setMozBoxAlign(String mozBoxAlign) {
        this.setStyleAttribute(MOZ_BOX_ALIGN, mozBoxAlign);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxDirection")
    public String getMozBoxDirection() {
        return this.getStyleAttribute(MOZ_BOX_DIRECTION, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxDirection")
    public void setMozBoxDirection(String mozBoxDirection) {
        this.setStyleAttribute(MOZ_BOX_DIRECTION, mozBoxDirection);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxFlex")
    public String getMozBoxFlex() {
        return this.getStyleAttribute(MOZ_BOX_FLEX, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxFlex")
    public void setMozBoxFlex(String mozBoxFlex) {
        this.setStyleAttribute(MOZ_BOX_FLEX, mozBoxFlex);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxOrdinalGroup")
    public String getMozBoxOrdinalGroup() {
        return this.getStyleAttribute(MOZ_BOX_ORDINAL_GROUP, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxOrdinalGroup")
    public void setMozBoxOrdinalGroup(String mozBoxOrdinalGroup) {
        this.setStyleAttribute(MOZ_BOX_ORDINAL_GROUP, mozBoxOrdinalGroup);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxOrient")
    public String getMozBoxOrient() {
        return this.getStyleAttribute(MOZ_BOX_ORIENT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxOrient")
    public void setMozBoxOrient(String mozBoxOrient) {
        this.setStyleAttribute(MOZ_BOX_ORIENT, mozBoxOrient);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxPack")
    public String getMozBoxPack() {
        return this.getStyleAttribute(MOZ_BOX_PACK, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxPack")
    public void setMozBoxPack(String mozBoxPack) {
        this.setStyleAttribute(MOZ_BOX_PACK, mozBoxPack);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxShadow")
    public String getMozBoxShadow() {
        return this.getStyleAttribute(MOZ_BOX_SHADOW, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxShadow")
    public void setMozBoxShadow(String mozBoxShadow) {
        this.setStyleAttribute(MOZ_BOX_SHADOW, mozBoxShadow);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxSizing")
    public String getMozBoxSizing() {
        return this.getStyleAttribute(MOZ_BOX_SIZING, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozBoxSizing")
    public void setMozBoxSizing(String mozBoxSizing) {
        this.setStyleAttribute(MOZ_BOX_SIZING, mozBoxSizing);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnCount")
    public String getMozColumnCount() {
        return this.getStyleAttribute(MOZ_COLUMN_COUNT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnCount")
    public void setMozColumnCount(String mozColumnCount) {
        this.setStyleAttribute(MOZ_COLUMN_COUNT, mozColumnCount);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnGap")
    public String getMozColumnGap() {
        return this.getStyleAttribute(MOZ_COLUMN_GAP, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnGap")
    public void setMozColumnGap(String mozColumnGap) {
        this.setStyleAttribute(MOZ_COLUMN_GAP, mozColumnGap);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnRule")
    public String getMozColumnRule() {
        return this.getStyleAttribute(MOZ_COLUMN_RULE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnRule")
    public void setMozColumnRule(String mozColumnRule) {
        this.setStyleAttribute(MOZ_COLUMN_RULE, mozColumnRule);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnRuleColor")
    public String getMozColumnRuleColor() {
        return this.getStyleAttribute(MOZ_COLUMN_RULE_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnRuleColor")
    public void setMozColumnRuleColor(String mozColumnRuleColor) {
        this.setStyleAttribute(MOZ_COLUMN_RULE_COLOR, mozColumnRuleColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnRuleStyle")
    public String getMozColumnRuleStyle() {
        return this.getStyleAttribute(MOZ_COLUMN_RULE_STYLE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnRuleStyle")
    public void setMozColumnRuleStyle(String mozColumnRuleStyle) {
        this.setStyleAttribute(MOZ_COLUMN_RULE_STYLE, mozColumnRuleStyle);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnRuleWidth")
    public String getMozColumnRuleWidth() {
        return this.getStyleAttribute(MOZ_COLUMN_RULE_WIDTH, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnRuleWidth")
    public void setMozColumnRuleWidth(String mozColumnRuleWidth) {
        this.setStyleAttribute(MOZ_COLUMN_RULE_WIDTH, mozColumnRuleWidth);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnWidth")
    public String getMozColumnWidth() {
        return this.getStyleAttribute(MOZ_COLUMN_WIDTH, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozColumnWidth")
    public void setMozColumnWidth(String mozColumnWidth) {
        this.setStyleAttribute(MOZ_COLUMN_WIDTH, mozColumnWidth);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozFloatEdge")
    public String getMozFloatEdge() {
        return this.getStyleAttribute(MOZ_FLOAT_EDGE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozFloatEdge")
    public void setMozFloatEdge(String mozFloatEdge) {
        this.setStyleAttribute(MOZ_FLOAT_EDGE, mozFloatEdge);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozForceBrokenImageIcon")
    public String getMozForceBrokenImageIcon() {
        return this.getStyleAttribute(MOZ_FORCE_BROKEN_IMAGE_ICON, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozForceBrokenImageIcon")
    public void setMozForceBrokenImageIcon(String mozForceBrokenImageIcon) {
        this.setStyleAttribute(MOZ_FORCE_BROKEN_IMAGE_ICON, mozForceBrokenImageIcon);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozImageRegion")
    public String getMozImageRegion() {
        return this.getStyleAttribute(MOZ_IMAGE_REGION, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozImageRegion")
    public void setMozImageRegion(String mozImageRegion) {
        this.setStyleAttribute(MOZ_IMAGE_REGION, mozImageRegion);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozMarginEnd")
    public String getMozMarginEnd() {
        return this.getStyleAttribute(MOZ_MARGIN_END, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozMarginEnd")
    public void setMozMarginEnd(String mozMarginEnd) {
        this.setStyleAttribute(MOZ_MARGIN_END, mozMarginEnd);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozMarginStart")
    public String getMozMarginStart() {
        return this.getStyleAttribute(MOZ_MARGIN_START, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozMarginStart")
    public void setMozMarginStart(String mozMarginStart) {
        this.setStyleAttribute(MOZ_MARGIN_START, mozMarginStart);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOpacity")
    public String getMozOpacity() {
        return this.getStyleAttribute(MOZ_OPACITY, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOpacity")
    public void setMozOpacity(String mozOpacity) {
        this.setStyleAttribute(MOZ_OPACITY, mozOpacity);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutline")
    public String getMozOutline() {
        return this.getStyleAttribute(MOZ_OUTLINE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutline")
    public void setMozOutline(String mozOutline) {
        this.setStyleAttribute(MOZ_OUTLINE, mozOutline);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineColor")
    public String getMozOutlineColor() {
        return this.getStyleAttribute(MOZ_OUTLINE_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineColor")
    public void setMozOutlineColor(String mozOutlineColor) {
        this.setStyleAttribute(MOZ_OUTLINE_COLOR, mozOutlineColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineOffset")
    public String getMozOutlineOffset() {
        return this.getStyleAttribute(MOZ_OUTLINE_OFFSET, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineOffset")
    public void setMozOutlineOffset(String mozOutlineOffset) {
        this.setStyleAttribute(MOZ_OUTLINE_OFFSET, mozOutlineOffset);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadius")
    public String getMozOutlineRadius() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadius")
    public void setMozOutlineRadius(String mozOutlineRadius) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS, mozOutlineRadius);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadiusBottomleft")
    public String getMozOutlineRadiusBottomleft() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS_BOTTOMLEFT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadiusBottomleft")
    public void setMozOutlineRadiusBottomleft(String mozOutlineRadiusBottomleft) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS_BOTTOMLEFT, mozOutlineRadiusBottomleft);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadiusBottomright")
    public String getMozOutlineRadiusBottomright() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS_BOTTOMRIGHT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadiusBottomright")
    public void setMozOutlineRadiusBottomright(String mozOutlineRadiusBottomright) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS_BOTTOMRIGHT, mozOutlineRadiusBottomright);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadiusTopleft")
    public String getMozOutlineRadiusTopleft() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS_TOPLEFT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadiusTopleft")
    public void setMozOutlineRadiusTopleft(String mozOutlineRadiusTopleft) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS_TOPLEFT, mozOutlineRadiusTopleft);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadiusTopright")
    public String getMozOutlineRadiusTopright() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS_TOPRIGHT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineRadiusTopright")
    public void setMozOutlineRadiusTopright(String mozOutlineRadiusTopright) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS_TOPRIGHT, mozOutlineRadiusTopright);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineStyle")
    public String getMozOutlineStyle() {
        return this.getStyleAttribute(MOZ_OUTLINE_STYLE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineStyle")
    public void setMozOutlineStyle(String mozOutlineStyle) {
        this.setStyleAttribute(MOZ_OUTLINE_STYLE, mozOutlineStyle);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineWidth")
    public String getMozOutlineWidth() {
        return this.getStyleAttribute(MOZ_OUTLINE_WIDTH, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozOutlineWidth")
    public void setMozOutlineWidth(String mozOutlineWidth) {
        this.setStyleAttribute(MOZ_OUTLINE_WIDTH, mozOutlineWidth);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozPaddingEnd")
    public String getMozPaddingEnd() {
        return this.getStyleAttribute(MOZ_PADDING_END, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozPaddingEnd")
    public void setMozPaddingEnd(String mozPaddingEnd) {
        this.setStyleAttribute(MOZ_PADDING_END, mozPaddingEnd);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozPaddingStart")
    public String getMozPaddingStart() {
        return this.getStyleAttribute(MOZ_PADDING_START, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozPaddingStart")
    public void setMozPaddingStart(String mozPaddingStart) {
        this.setStyleAttribute(MOZ_PADDING_START, mozPaddingStart);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozStackSizing")
    public String getMozStackSizing() {
        return this.getStyleAttribute(MOZ_STACK_SIZING, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozStackSizing")
    public void setMozStackSizing(String mozStackSizing) {
        this.setStyleAttribute(MOZ_STACK_SIZING, mozStackSizing);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozTransform")
    public String getMozTransform() {
        return this.getStyleAttribute(MOZ_TRANSFORM, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozTransform")
    public void setMozTransform(String mozTransform) {
        this.setStyleAttribute(MOZ_TRANSFORM, mozTransform);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozTransformOrigin")
    public String getMozTransformOrigin() {
        return this.getStyleAttribute(MOZ_TRANSFORM_ORIGIN, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozTransformOrigin")
    public void setMozTransformOrigin(String mozTransformOrigin) {
        this.setStyleAttribute(MOZ_TRANSFORM_ORIGIN, mozTransformOrigin);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozUserFocus")
    public String getMozUserFocus() {
        return this.getStyleAttribute(MOZ_USER_FOCUS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozUserFocus")
    public void setMozUserFocus(String mozUserFocus) {
        this.setStyleAttribute(MOZ_USER_FOCUS, mozUserFocus);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozUserInput")
    public String getMozUserInput() {
        return this.getStyleAttribute(MOZ_USER_INPUT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozUserInput")
    public void setMozUserInput(String mozUserInput) {
        this.setStyleAttribute(MOZ_USER_INPUT, mozUserInput);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozUserModify")
    public String getMozUserModify() {
        return this.getStyleAttribute(MOZ_USER_MODIFY, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozUserModify")
    public void setMozUserModify(String mozUserModify) {
        this.setStyleAttribute(MOZ_USER_MODIFY, mozUserModify);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozUserSelect")
    public String getMozUserSelect() {
        return this.getStyleAttribute(MOZ_USER_SELECT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozUserSelect")
    public void setMozUserSelect(String mozUserSelect) {
        this.setStyleAttribute(MOZ_USER_SELECT, mozUserSelect);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozWindowShadow")
    public String getMozWindowShadow() {
        return this.getStyleAttribute(MOZ_WINDOW_SHADOW, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)}, propertyName="MozWindowShadow")
    public void setMozWindowShadow(String mozWindowShadow) {
        this.setStyleAttribute(MOZ_WINDOW_SHADOW, mozWindowShadow);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f)})
    public String getMsBlockProgression() {
        return this.getStyleAttribute(MS_BLOCK_PROGRESSION, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f)})
    public void setMsBlockProgression(String msBlockProgression) {
        this.setStyleAttribute(MS_BLOCK_PROGRESSION, msBlockProgression);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getMsInterpolationMode() {
        return this.getStyleAttribute(MS_INTERPOLATION_MODE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setMsInterpolationMode(String msInterpolationMode) {
        this.setStyleAttribute(MS_INTERPOLATION_MODE, msInterpolationMode);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public String getOpacity() {
        String opacity = this.getStyleAttribute(OPACITY, null);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OPACITY_ACCEPTS_ARBITRARY_VALUES)) {
            return opacity;
        }
        if (opacity == null || opacity.isEmpty()) {
            return "";
        }
        String trimedOpacity = opacity.trim();
        try {
            float value = Float.parseFloat(trimedOpacity);
            if (value % 1.0f == 0.0f) {
                return Integer.toString((int)value);
            }
            return Float.toString(value);
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public void setOpacity(String opacity) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OPACITY_ACCEPTS_ARBITRARY_VALUES)) {
            this.setStyleAttribute(OPACITY, opacity);
            return;
        }
        if (opacity.isEmpty()) {
            this.setStyleAttribute(OPACITY, opacity);
        }
        String trimedOpacity = opacity.trim();
        try {
            Float.parseFloat(trimedOpacity);
            this.setStyleAttribute(OPACITY, trimedOpacity);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getOrphans() {
        return this.getStyleAttribute(ORPHANS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setOrphans(String orphans) {
        this.setStyleAttribute(ORPHANS, orphans);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getOutline() {
        return this.getStyleAttribute(OUTLINE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setOutline(String outline) {
        this.setStyleAttribute(OUTLINE, outline);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getOutlineColor() {
        return this.getStyleAttribute(OUTLINE_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setOutlineColor(String outlineColor) {
        this.setStyleAttribute(OUTLINE_COLOR, outlineColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getOutlineOffset() {
        return this.getStyleAttribute(OUTLINE_OFFSET, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setOutlineOffset(String outlineOffset) {
        this.setStyleAttribute(OUTLINE_OFFSET, outlineOffset);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getOutlineStyle() {
        return this.getStyleAttribute(OUTLINE_STYLE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setOutlineStyle(String outlineStyle) {
        this.setStyleAttribute(OUTLINE_STYLE, outlineStyle);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getOutlineWidth() {
        return this.getStyleAttribute(OUTLINE_WIDTH, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setOutlineWidth(String outlineWidth) {
        this.setStyleAttributePixel(OUTLINE_WIDTH, outlineWidth);
    }

    @JsxGetter
    public String getOverflow() {
        return this.getStyleAttribute(OVERFLOW, null);
    }

    @JsxSetter
    public void setOverflow(String overflow) {
        this.setStyleAttribute(OVERFLOW, overflow);
    }

    @JsxGetter
    public String getOverflowX() {
        return this.getStyleAttribute(OVERFLOW_X, null);
    }

    @JsxSetter
    public void setOverflowX(String overflowX) {
        this.setStyleAttribute(OVERFLOW_X, overflowX);
    }

    @JsxGetter
    public String getOverflowY() {
        return this.getStyleAttribute(OVERFLOW_Y, null);
    }

    @JsxSetter
    public void setOverflowY(String overflowY) {
        this.setStyleAttribute(OVERFLOW_Y, overflowY);
    }

    @JsxGetter
    public String getPadding() {
        return this.getStyleAttribute(PADDING, null);
    }

    @JsxSetter
    public void setPadding(String padding) {
        this.setStyleAttribute(PADDING, padding);
    }

    @JsxGetter
    public String getPaddingBottom() {
        return this.getStyleAttribute(PADDING_BOTTOM, PADDING, Shorthand.BOTTOM);
    }

    @JsxSetter
    public void setPaddingBottom(String paddingBottom) {
        this.setStyleAttributePixel(PADDING_BOTTOM, paddingBottom);
    }

    @JsxGetter
    public String getPaddingLeft() {
        return this.getStyleAttribute(PADDING_LEFT, PADDING, Shorthand.LEFT);
    }

    @JsxSetter
    public void setPaddingLeft(String paddingLeft) {
        this.setStyleAttributePixel(PADDING_LEFT, paddingLeft);
    }

    @JsxGetter
    public String getPaddingRight() {
        return this.getStyleAttribute(PADDING_RIGHT, PADDING, Shorthand.RIGHT);
    }

    @JsxSetter
    public void setPaddingRight(String paddingRight) {
        this.setStyleAttributePixel(PADDING_RIGHT, paddingRight);
    }

    @JsxGetter
    public String getPaddingTop() {
        return this.getStyleAttribute(PADDING_TOP, PADDING, Shorthand.TOP);
    }

    @JsxSetter
    public void setPaddingTop(String paddingTop) {
        this.setStyleAttributePixel(PADDING_TOP, paddingTop);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getPage() {
        return this.getStyleAttribute(PAGE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setPage(String page) {
        this.setStyleAttribute(PAGE, page);
    }

    @JsxGetter
    public String getPageBreakAfter() {
        return this.getStyleAttribute(PAGE_BREAK_AFTER, null);
    }

    @JsxSetter
    public void setPageBreakAfter(String pageBreakAfter) {
        this.setStyleAttribute(PAGE_BREAK_AFTER, pageBreakAfter);
    }

    @JsxGetter
    public String getPageBreakBefore() {
        return this.getStyleAttribute(PAGE_BREAK_BEFORE, null);
    }

    @JsxSetter
    public void setPageBreakBefore(String pageBreakBefore) {
        this.setStyleAttribute(PAGE_BREAK_BEFORE, pageBreakBefore);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getPageBreakInside() {
        return this.getStyleAttribute(PAGE_BREAK_INSIDE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setPageBreakInside(String pageBreakInside) {
        this.setStyleAttribute(PAGE_BREAK_INSIDE, pageBreakInside);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getPause() {
        return this.getStyleAttribute(PAUSE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setPause(String pause) {
        this.setStyleAttribute(PAUSE, pause);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getPauseAfter() {
        return this.getStyleAttribute(PAUSE_AFTER, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setPauseAfter(String pauseAfter) {
        this.setStyleAttribute(PAUSE_AFTER, pauseAfter);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getPauseBefore() {
        return this.getStyleAttribute(PAUSE_BEFORE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setPauseBefore(String pauseBefore) {
        this.setStyleAttribute(PAUSE_BEFORE, pauseBefore);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getPitch() {
        return this.getStyleAttribute(PITCH, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setPitch(String pitch) {
        this.setStyleAttribute(PITCH, pitch);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getPitchRange() {
        return this.getStyleAttribute(PITCH_RANGE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setPitchRange(String pitchRange) {
        this.setStyleAttribute(PITCH_RANGE, pitchRange);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getPointerEvents() {
        return this.getStyleAttribute(POINTER_EVENTS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setPointerEvents(String pointerEvents) {
        this.setStyleAttribute(POINTER_EVENTS, pointerEvents);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelBottom() {
        return CSSStyleDeclaration.pixelValue(this.getBottom());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelBottom(int pixelBottom) {
        this.setBottom(pixelBottom + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelLeft() {
        return CSSStyleDeclaration.pixelValue(this.getLeft());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelLeft(int pixelLeft) {
        this.setLeft(pixelLeft + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelRight() {
        return CSSStyleDeclaration.pixelValue(this.getRight());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelRight(int pixelRight) {
        this.setRight(pixelRight + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelTop() {
        return CSSStyleDeclaration.pixelValue(this.getTop());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelTop(int pixelTop) {
        this.setTop(pixelTop + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosBottom() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosBottom(int posBottom) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosHeight() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosHeight(int posHeight) {
    }

    @JsxGetter
    public String getPosition() {
        return this.getStyleAttribute(POSITION, null);
    }

    @JsxSetter
    public void setPosition(String position) {
        this.setStyleAttribute(POSITION, position);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosLeft() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosLeft(int posLeft) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosRight() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosRight(int posRight) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosTop() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosTop(int posTop) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosWidth() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosWidth(int posWidth) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getQuotes() {
        return this.getStyleAttribute(QUOTES, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setQuotes(String quotes) {
        this.setStyleAttribute(QUOTES, quotes);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getRichness() {
        return this.getStyleAttribute(RICHNESS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setRichness(String richness) {
        this.setStyleAttribute(RICHNESS, richness);
    }

    @JsxGetter
    public String getRight() {
        return this.getStyleAttribute(RIGHT, null);
    }

    @JsxSetter
    public void setRight(String right) {
        this.setStyleAttributePixel(RIGHT, right);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getRubyAlign() {
        return this.getStyleAttribute(RUBY_ALIGN, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setRubyAlign(String rubyAlign) {
        this.setStyleAttribute(RUBY_ALIGN, rubyAlign);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getRubyOverhang() {
        return this.getStyleAttribute(RUBY_OVERHANG, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setRubyOverhang(String rubyOverhang) {
        this.setStyleAttribute(RUBY_OVERHANG, rubyOverhang);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getRubyPosition() {
        return this.getStyleAttribute(RUBY_POSITION, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setRubyPosition(String rubyPosition) {
        this.setStyleAttribute(RUBY_POSITION, rubyPosition);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getScrollbar3dLightColor() {
        return this.getStyleAttribute(SCROLLBAR3D_LIGHT_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setScrollbar3dLightColor(String scrollbar3dLightColor) {
        this.setStyleAttribute(SCROLLBAR3D_LIGHT_COLOR, scrollbar3dLightColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getScrollbarArrowColor() {
        return this.getStyleAttribute(SCROLLBAR_ARROW_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setScrollbarArrowColor(String scrollbarArrowColor) {
        this.setStyleAttribute(SCROLLBAR_ARROW_COLOR, scrollbarArrowColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getScrollbarBaseColor() {
        return this.getStyleAttribute(SCROLLBAR_BASE_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setScrollbarBaseColor(String scrollbarBaseColor) {
        this.setStyleAttribute(SCROLLBAR_BASE_COLOR, scrollbarBaseColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getScrollbarDarkShadowColor() {
        return this.getStyleAttribute(SCROLLBAR_DARK_SHADOW_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setScrollbarDarkShadowColor(String scrollbarDarkShadowColor) {
        this.setStyleAttribute(SCROLLBAR_DARK_SHADOW_COLOR, scrollbarDarkShadowColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getScrollbarFaceColor() {
        return this.getStyleAttribute(SCROLLBAR_FACE_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setScrollbarFaceColor(String scrollbarFaceColor) {
        this.setStyleAttribute(SCROLLBAR_FACE_COLOR, scrollbarFaceColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getScrollbarHighlightColor() {
        return this.getStyleAttribute(SCROLLBAR_HIGHLIGHT_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setScrollbarHighlightColor(String scrollbarHighlightColor) {
        this.setStyleAttribute(SCROLLBAR_HIGHLIGHT_COLOR, scrollbarHighlightColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getScrollbarShadowColor() {
        return this.getStyleAttribute(SCROLLBAR_SHADOW_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setScrollbarShadowColor(String scrollbarShadowColor) {
        this.setStyleAttribute(SCROLLBAR_SHADOW_COLOR, scrollbarShadowColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getScrollbarTrackColor() {
        return this.getStyleAttribute(SCROLLBAR_TRACK_COLOR, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setScrollbarTrackColor(String scrollbarTrackColor) {
        this.setStyleAttribute(SCROLLBAR_TRACK_COLOR, scrollbarTrackColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getSize() {
        return this.getStyleAttribute(SIZE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSize(String size) {
        this.setStyleAttribute(SIZE, size);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getSpeak() {
        return this.getStyleAttribute(SPEAK, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSpeak(String speak) {
        this.setStyleAttribute(SPEAK, speak);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getSpeakHeader() {
        return this.getStyleAttribute(SPEAK_HEADER, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSpeakHeader(String speakHeader) {
        this.setStyleAttribute(SPEAK_HEADER, speakHeader);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getSpeakNumeral() {
        return this.getStyleAttribute(SPEAK_NUMERAL, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSpeakNumeral(String speakNumeral) {
        this.setStyleAttribute(SPEAK_NUMERAL, speakNumeral);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getSpeakPunctuation() {
        return this.getStyleAttribute(SPEAK_PUNCTUATION, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSpeakPunctuation(String speakPunctuation) {
        this.setStyleAttribute(SPEAK_PUNCTUATION, speakPunctuation);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getSpeechRate() {
        return this.getStyleAttribute(SPEECH_RATE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSpeechRate(String speechRate) {
        this.setStyleAttribute(SPEECH_RATE, speechRate);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getStress() {
        return this.getStyleAttribute(STRESS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setStress(String stress) {
        this.setStyleAttribute(STRESS, stress);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getStyleFloat() {
        return this.getStyleAttribute(FLOAT, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setStyleFloat(String value) {
        this.setStyleAttribute(FLOAT, value);
    }

    @JsxGetter
    public String getTableLayout() {
        return this.getStyleAttribute(TABLE_LAYOUT, null);
    }

    @JsxSetter
    public void setTableLayout(String tableLayout) {
        this.setStyleAttribute(TABLE_LAYOUT, tableLayout);
    }

    @JsxGetter
    public String getTextAlign() {
        return this.getStyleAttribute(TEXT_ALIGN, null);
    }

    @JsxSetter
    public void setTextAlign(String textAlign) {
        this.setStyleAttribute(TEXT_ALIGN, textAlign);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getTextAlignLast() {
        return this.getStyleAttribute(TEXT_ALIGN_LAST, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextAlignLast(String textAlignLast) {
        this.setStyleAttribute(TEXT_ALIGN_LAST, textAlignLast);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getTextAutospace() {
        return this.getStyleAttribute(TEXT_AUTOSPACE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextAutospace(String textAutospace) {
        this.setStyleAttribute(TEXT_AUTOSPACE, textAutospace);
    }

    @JsxGetter
    public String getTextDecoration() {
        return this.getStyleAttribute(TEXT_DECORATION, null);
    }

    @JsxSetter
    public void setTextDecoration(String textDecoration) {
        this.setStyleAttribute(TEXT_DECORATION, textDecoration);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationBlink() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationBlink(boolean textDecorationBlink) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationLineThrough() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationLineThrough(boolean textDecorationLineThrough) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationNone() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationNone(boolean textDecorationNone) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationOverline() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationOverline(boolean textDecorationOverline) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationUnderline() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationUnderline(boolean textDecorationUnderline) {
    }

    @JsxGetter
    public String getTextIndent() {
        return this.getStyleAttribute(TEXT_INDENT, null);
    }

    @JsxSetter
    public void setTextIndent(String textIndent) {
        this.setStyleAttributePixel(TEXT_INDENT, textIndent);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getTextJustify() {
        return this.getStyleAttribute(TEXT_JUSTIFY, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextJustify(String textJustify) {
        this.setStyleAttribute(TEXT_JUSTIFY, textJustify);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getTextJustifyTrim() {
        return this.getStyleAttribute(TEXT_JUSTIFY_TRIM, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextJustifyTrim(String textJustifyTrim) {
        this.setStyleAttribute(TEXT_JUSTIFY_TRIM, textJustifyTrim);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getTextKashida() {
        return this.getStyleAttribute(TEXT_KASHIDA, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextKashida(String textKashida) {
        this.setStyleAttribute(TEXT_KASHIDA, textKashida);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getTextKashidaSpace() {
        return this.getStyleAttribute(TEXT_KASHIDA_SPACE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextKashidaSpace(String textKashidaSpace) {
        this.setStyleAttribute(TEXT_KASHIDA_SPACE, textKashidaSpace);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getTextOverflow() {
        return this.getStyleAttribute(TEXT_OVERFLOW, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextOverflow(String textOverflow) {
        this.setStyleAttribute(TEXT_OVERFLOW, textOverflow);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getTextShadow() {
        return this.getStyleAttribute(TEXT_SHADOW, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setTextShadow(String textShadow) {
        this.setStyleAttribute(TEXT_SHADOW, textShadow);
    }

    @JsxGetter
    public String getTextTransform() {
        return this.getStyleAttribute(TEXT_TRANSFORM, null);
    }

    @JsxSetter
    public void setTextTransform(String textTransform) {
        this.setStyleAttribute(TEXT_TRANSFORM, textTransform);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getTextUnderlinePosition() {
        return this.getStyleAttribute(TEXT_UNDERLINE_POSITION, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextUnderlinePosition(String textUnderlinePosition) {
        this.setStyleAttribute(TEXT_UNDERLINE_POSITION, textUnderlinePosition);
    }

    @JsxGetter
    public String getTop() {
        return this.getStyleAttribute(TOP, null);
    }

    @JsxSetter
    public void setTop(String top) {
        this.setStyleAttributePixel(TOP, top);
    }

    @JsxGetter
    public String getUnicodeBidi() {
        return this.getStyleAttribute(UNICODE_BIDI, null);
    }

    @JsxSetter
    public void setUnicodeBidi(String unicodeBidi) {
        this.setStyleAttribute(UNICODE_BIDI, unicodeBidi);
    }

    @JsxGetter
    public String getVerticalAlign() {
        return this.getStyleAttribute(VERTICAL_ALIGN, null);
    }

    @JsxSetter
    public void setVerticalAlign(String verticalAlign) {
        this.setStyleAttributePixel(VERTICAL_ALIGN, verticalAlign);
    }

    @JsxGetter
    public String getVisibility() {
        return this.getStyleAttribute(VISIBILITY, null);
    }

    @JsxSetter
    public void setVisibility(String visibility) {
        this.setStyleAttribute(VISIBILITY, visibility);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getVoiceFamily() {
        return this.getStyleAttribute(VOICE_FAMILY, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setVoiceFamily(String voiceFamily) {
        this.setStyleAttribute(VOICE_FAMILY, voiceFamily);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getVolume() {
        return this.getStyleAttribute(VOLUME, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setVolume(String volume) {
        this.setStyleAttribute(VOLUME, volume);
    }

    @JsxGetter
    public String getWhiteSpace() {
        return this.getStyleAttribute(WHITE_SPACE, null);
    }

    @JsxSetter
    public void setWhiteSpace(String whiteSpace) {
        this.setStyleAttribute(WHITE_SPACE, whiteSpace);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public String getWidows() {
        return this.getStyleAttribute(WIDOWS, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void setWidows(String widows) {
        this.setStyleAttribute(WIDOWS, widows);
    }

    @JsxGetter
    public String getWidth() {
        return this.getStyleAttribute(WIDTH, null);
    }

    @JsxSetter
    public void setWidth(String width) {
        this.setStyleAttributePixel(WIDTH, width);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getWordBreak() {
        return this.getStyleAttribute(WORD_BREAK, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setWordBreak(String wordBreak) {
        this.setStyleAttribute(WORD_BREAK, wordBreak);
    }

    @JsxGetter
    public String getWordSpacing() {
        return this.getStyleAttribute(WORD_SPACING, null);
    }

    @JsxSetter
    public void setWordSpacing(String wordSpacing) {
        this.setStyleAttributePixel(WORD_SPACING, wordSpacing);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public String getWordWrap() {
        return this.getStyleAttribute(WORD_WRAP, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public void setWordWrap(String wordWrap) {
        this.setStyleAttribute(WORD_WRAP, wordWrap);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getWritingMode() {
        return this.getStyleAttribute(WRITING_MODE, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setWritingMode(String writingMode) {
        this.setStyleAttribute(WRITING_MODE, writingMode);
    }

    @JsxGetter
    public Object getZIndex() {
        String value = this.getStyleAttribute(Z_INDEX, null);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_TYPE_NUMBER)) {
            if (value == null || Context.getUndefinedValue().equals(value) || StringUtils.isEmpty((CharSequence)value.toString())) {
                return 0;
            }
            try {
                Double numericValue = Double.valueOf(value);
                return numericValue.intValue();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        try {
            Integer.parseInt(value);
            return value;
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    @JsxSetter
    public void setZIndex(Object zIndex) {
        if (zIndex == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_UNDEFINED_OR_NULL_THROWS_ERROR)) {
            throw new EvaluatorException("Null is invalid for z-index.");
        }
        if (zIndex == null || StringUtils.isEmpty((CharSequence)zIndex.toString())) {
            this.setStyleAttribute(Z_INDEX, "");
            return;
        }
        if (Context.getUndefinedValue().equals(zIndex)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_UNDEFINED_OR_NULL_THROWS_ERROR)) {
                throw new EvaluatorException("Undefind is invalid for z-index.");
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_UNDEFINED_FORCES_RESET)) {
                this.setStyleAttribute(Z_INDEX, "");
            }
            return;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_TYPE_NUMBER)) {
            Double d;
            if (zIndex instanceof Double) {
                d = (Double)zIndex;
            } else {
                try {
                    d = Double.valueOf(zIndex.toString());
                }
                catch (NumberFormatException e) {
                    throw new WrappedException((Throwable)e);
                }
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_ROUNDED)) {
                this.setStyleAttribute(Z_INDEX, Integer.toString(Math.round(d.floatValue() - 1.0E-5f)));
            } else {
                this.setStyleAttribute(Z_INDEX, Integer.toString(d.intValue()));
            }
            return;
        }
        if (zIndex instanceof Number) {
            Number number = (Number)zIndex;
            if (number.doubleValue() % 1.0 == 0.0) {
                this.setStyleAttribute(Z_INDEX, Integer.toString(number.intValue()));
            }
            return;
        }
        try {
            int i = Integer.parseInt(zIndex.toString());
            this.setStyleAttribute(Z_INDEX, Integer.toString(i));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getZoom() {
        return this.getStyleAttribute(ZOOM, null);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setZoom(String zoom) {
        this.setStyleAttribute(ZOOM, zoom);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public String getPropertyValue(String name) {
        Object value;
        if (name != null && name.contains("-") && (value = CSSStyleDeclaration.getProperty((Scriptable)this, (String)CSSStyleDeclaration.camelize(name))) instanceof String) {
            return (String)value;
        }
        return this.getStyleAttribute(name, null);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public CSSValue getPropertyCSSValue(String name) {
        String cssText;
        org.w3c.dom.css.CSSValue cssValue;
        LOG.info((Object)("getPropertyCSSValue(" + name + "): getPropertyCSSValue support is experimental"));
        if (this.styleDeclaration_ == null) {
            String uri = ((DomNode)this.getDomNodeOrDie()).getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
            String styleAttribute = this.jsElement_.getDomNodeOrDie().getAttribute("style");
            InputSource source = new InputSource((Reader)new StringReader(styleAttribute));
            source.setURI(uri);
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS21());
            parser.setErrorHandler(errorHandler);
            try {
                this.styleDeclaration_ = parser.parseStyleDeclaration(source);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((cssValue = this.styleDeclaration_.getPropertyCSSValue(name)) == null) {
            CSSValueImpl newValue = new CSSValueImpl();
            newValue.setFloatValue((short)5, 0.0f);
            cssValue = newValue;
        }
        if ((cssText = cssValue.getCssText()).startsWith("rgb(")) {
            String formatedCssText = StringUtils.replace((String)cssText, (String)",", (String)", ");
            cssValue.setCssText(formatedCssText);
        }
        return new CSSPrimitiveValue(this.jsElement_, (org.w3c.dom.css.CSSPrimitiveValue)cssValue);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public String removeProperty(String name) {
        return this.removeStyleAttribute(name);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=10.0f)})
    public void setExpression(String propertyName, String expression, String language) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=10.0f)})
    public boolean removeExpression(String propertyName) {
        return true;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object getAttribute(String name, int flag) {
        if (flag == 1) {
            return this.getStyleAttribute(name, null);
        }
        Map<String, StyleElement> map = this.getStyleMap();
        for (String key : map.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            return map.get(key).getValue();
        }
        return "";
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void setAttribute(String name, String value, Object flag) {
        int flagInt = flag == Undefined.instance ? 1 : (int)Context.toNumber((Object)flag);
        if (flagInt == 0) {
            Map<String, StyleElement> map = this.getStyleMap();
            for (String key : map.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                this.setStyleAttribute(key, value);
            }
        } else if (this.getStyleAttribute(name, null).length() > 0) {
            this.setStyleAttribute(name, value);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public boolean removeAttribute(String name, Object flag) {
        int flagInt = flag == Undefined.instance ? 1 : (int)Context.toNumber((Object)flag);
        if (flagInt == 0) {
            String lastName = null;
            Map<String, StyleElement> map = this.getStyleMap();
            for (String key : map.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                lastName = key;
            }
            if (lastName != null) {
                this.removeStyleAttribute(lastName);
                return true;
            }
            return false;
        }
        String s = this.getStyleAttribute(name, null);
        if (s.length() > 0) {
            this.removeStyleAttribute(name);
            return true;
        }
        return false;
    }

    private String findColor(String text) {
        String[] tokens;
        Color tmpColor = com.gargoylesoftware.htmlunit.util.StringUtils.findColorRGB(text);
        if (tmpColor != null) {
            return com.gargoylesoftware.htmlunit.util.StringUtils.formatColor(tmpColor);
        }
        for (String token : tokens = StringUtils.split((String)text, (char)' ')) {
            if (CSSStyleDeclaration.isColorKeyword(token)) {
                return token;
            }
            tmpColor = com.gargoylesoftware.htmlunit.util.StringUtils.asColorHexadecimal(token);
            if (tmpColor == null) continue;
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_BACKGROUND_COLOR_FOR_COMPUTED_STYLE_AS_RGB)) {
                return com.gargoylesoftware.htmlunit.util.StringUtils.formatColor(tmpColor);
            }
            return token;
        }
        return null;
    }

    private String findImageUrl(String text) {
        Matcher m = URL_PATTERN.matcher(text);
        if (m.find()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_IMAGE_URL_QUOTED)) {
                return "url(\"" + m.group(1) + "\")";
            }
            return "url(" + m.group(1) + ")";
        }
        return null;
    }

    private static String findPosition(String text) {
        Matcher m = POSITION_PATTERN.matcher(text);
        if (m.find()) {
            return m.group(1) + " " + m.group(3);
        }
        m = POSITION_PATTERN2.matcher(text);
        if (m.find()) {
            return m.group(1) + " " + m.group(2);
        }
        m = POSITION_PATTERN3.matcher(text);
        if (m.find()) {
            return m.group(2) + " " + m.group(1);
        }
        return null;
    }

    private static String findRepeat(String text) {
        if (text.contains("repeat-x")) {
            return "repeat-x";
        }
        if (text.contains("repeat-y")) {
            return "repeat-y";
        }
        if (text.contains("no-repeat")) {
            return "no-repeat";
        }
        if (text.contains("repeat")) {
            return "repeat";
        }
        return null;
    }

    private static String findAttachment(String text) {
        if (text.contains("scroll")) {
            return "scroll";
        }
        if (text.contains("fixed")) {
            return "fixed";
        }
        return null;
    }

    private static String findBorderStyle(String text) {
        for (String token : StringUtils.split((String)text, (char)' ')) {
            if (!CSSStyleDeclaration.isBorderStyle(token)) continue;
            return token;
        }
        return null;
    }

    private static String findBorderWidth(String text) {
        for (String token : StringUtils.split((String)text, (char)' ')) {
            if (!CSSStyleDeclaration.isBorderWidth(token)) continue;
            return token;
        }
        return null;
    }

    private static boolean isColorKeyword(String token) {
        return CSSColors_.containsKey(token.toLowerCase());
    }

    public static String toRGBColor(String color) {
        String rgbValue = CSSColors_.get(color.toLowerCase());
        if (rgbValue != null) {
            return rgbValue;
        }
        return color;
    }

    private static boolean isBorderStyle(String token) {
        return "none".equalsIgnoreCase(token) || "hidden".equalsIgnoreCase(token) || "dotted".equalsIgnoreCase(token) || "dashed".equalsIgnoreCase(token) || "solid".equalsIgnoreCase(token) || "double".equalsIgnoreCase(token) || "groove".equalsIgnoreCase(token) || "ridge".equalsIgnoreCase(token) || "inset".equalsIgnoreCase(token) || "outset".equalsIgnoreCase(token);
    }

    private static boolean isBorderWidth(String token) {
        return "thin".equalsIgnoreCase(token) || "medium".equalsIgnoreCase(token) || "thick".equalsIgnoreCase(token) || CSSStyleDeclaration.isLength(token);
    }

    private static boolean isLength(String token) {
        if (token.endsWith("em") || token.endsWith("ex") || token.endsWith("px") || token.endsWith("in") || token.endsWith("cm") || token.endsWith("mm") || token.endsWith("pt") || token.endsWith("pc") || token.endsWith("%")) {
            token = token.endsWith("%") ? token.substring(0, token.length() - 1) : token.substring(0, token.length() - 2);
            try {
                Float.parseFloat(token);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static int pixelValue(HTMLElement element, CssValue value) {
        String s = value.get(element);
        if (s.endsWith("%") || s.isEmpty() && element instanceof HTMLHtmlElement) {
            int i = NumberUtils.toInt((String)TO_INT_PATTERN.matcher(s).replaceAll("$1"), (int)100);
            HTMLElement parent = (HTMLElement)element.getParentElement();
            int absoluteValue = parent == null ? value.getWindowDefaultValue() : CSSStyleDeclaration.pixelValue(parent, value);
            return (int)((double)i / 100.0 * (double)absoluteValue);
        }
        if (s.isEmpty() && element instanceof HTMLCanvasElement) {
            return value.getWindowDefaultValue();
        }
        return CSSStyleDeclaration.pixelValue(s);
    }

    protected static int pixelValue(String value) {
        Integer result = pixelValuesCache_.get(value);
        if (null != result) {
            return result;
        }
        int i = NumberUtils.toInt((String)TO_INT_PATTERN.matcher(value).replaceAll("$1"), (int)0);
        if (!value.endsWith("px")) {
            if (value.endsWith("em")) {
                i *= 16;
            } else if (value.endsWith("ex")) {
                i *= 10;
            } else if (value.endsWith("in")) {
                i *= 150;
            } else if (value.endsWith("cm")) {
                i *= 50;
            } else if (value.endsWith("mm")) {
                i *= 5;
            } else if (value.endsWith("pt")) {
                i *= 2;
            } else if (value.endsWith("pc")) {
                i *= 24;
            }
        }
        pixelValuesCache_.put(value, i);
        return i;
    }

    public String toString() {
        if (this.jsElement_ == null) {
            return "CSSStyleDeclaration for 'null'";
        }
        String style = this.jsElement_.getDomNodeOrDie().getAttribute("style");
        return "CSSStyleDeclaration for '" + style + "'";
    }

    protected void setStyleAttributePixel(String name, String value) {
        if (value.endsWith("px")) {
            value = value.substring(0, value.length() - 2);
        }
        try {
            float floatValue = Float.parseFloat(value);
            value = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_PIXEL_VALUES_INT_ONLY) ? Integer.toString((int)floatValue) + "px" : (floatValue % 1.0f == 0.0f ? Integer.toString((int)floatValue) + "px" : Float.toString(floatValue) + "px");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setStyleAttribute(name, value);
    }

    static {
        CSSColors_.put("aqua", "rgb(0, 255, 255)");
        CSSColors_.put("black", "rgb(0, 0, 0)");
        CSSColors_.put("blue", "rgb(0, 0, 255)");
        CSSColors_.put("fuchsia", "rgb(255, 0, 255)");
        CSSColors_.put("gray", "rgb(128, 128, 128)");
        CSSColors_.put("green", "rgb(0, 128, 0)");
        CSSColors_.put("lime", "rgb(0, 255, 0)");
        CSSColors_.put("maroon", "rgb(128, 0, 0)");
        CSSColors_.put("navy", "rgb(0, 0, 128)");
        CSSColors_.put("olive", "rgb(128, 128, 0)");
        CSSColors_.put("purple", "rgb(128, 0, 128)");
        CSSColors_.put("red", "rgb(255, 0, 0)");
        CSSColors_.put("silver", "rgb(192, 192, 192)");
        CSSColors_.put("teal", "rgb(0, 128, 128)");
        CSSColors_.put("white", "rgb(255, 255, 255)");
        CSSColors_.put("yellow", "rgb(255, 255, 0)");
    }

    public static class StyleElement
    implements Comparable<StyleElement> {
        private final String name_;
        private final String value_;
        private final String priority_;
        private final long index_;
        private final SelectorSpecificity specificity_;

        protected StyleElement(String name, String value, String priority, SelectorSpecificity specificity, long index) {
            this.name_ = name;
            this.value_ = value;
            this.priority_ = priority;
            this.index_ = index;
            this.specificity_ = specificity;
        }

        protected StyleElement(String name, String value, long index) {
            this(name, value, "", SelectorSpecificity.FROM_STYLE_ATTRIBUTE, index);
        }

        protected StyleElement(String name, String value) {
            this(name, value, Long.MIN_VALUE);
        }

        public String getName() {
            return this.name_;
        }

        public String getValue() {
            return this.value_;
        }

        public String getPriority() {
            return this.priority_;
        }

        public SelectorSpecificity getSpecificity() {
            return this.specificity_;
        }

        public long getIndex() {
            return this.index_;
        }

        public boolean isDefault() {
            return this.index_ == Long.MIN_VALUE;
        }

        public String toString() {
            return "[" + this.index_ + "]" + this.name_ + "=" + this.value_;
        }

        @Override
        public int compareTo(StyleElement e) {
            if (e != null) {
                long styleIndex = e.index_;
                return this.index_ < styleIndex ? -1 : (this.index_ == styleIndex ? 0 : 1);
            }
            return 1;
        }
    }

    protected static abstract class CssValue {
        private final int windowDefaultValue_;

        public CssValue(int windowDefaultValue) {
            this.windowDefaultValue_ = windowDefaultValue;
        }

        public int getWindowDefaultValue() {
            return this.windowDefaultValue_;
        }

        public final String get(HTMLElement element) {
            ComputedCSSStyleDeclaration style = element.getCurrentStyle();
            String value = this.get(style);
            return value;
        }

        public abstract String get(ComputedCSSStyleDeclaration var1);
    }

    private static enum Shorthand {
        TOP("top"),
        RIGHT("right"),
        BOTTOM("bottom"),
        LEFT("left");

        private final String string_;

        private Shorthand(String stringRepresentation) {
            this.string_ = stringRepresentation;
        }

        public String toString() {
            return this.string_;
        }
    }
}

