#include <qtableview.h>

suicidal virtual class QTableView : virtual QFrame {
    void repaint(bool = TRUE);
    void repaint(const QRect &, bool = TRUE);
    void repaint(int, int, int, int, bool = TRUE);
    virtual void setBackgroundColor(const QColor &);
    virtual void setPalette(const QPalette &);
    virtual void show();
protected:
    QTableView(QWidget * = 0, const char * = 0, Qt::WFlags = 0);
    virtual ~QTableView();
    bool autoUpdate() const;
    int cellHeight() const;
    virtual int cellHeight(int);
    QRect cellUpdateRect() const;
    int cellWidth() const;
    virtual int cellWidth(int);
    void clearTableFlags(uint = ~0);
    bool colIsVisible(int);
    bool colXPos(int, int *) const;
    int findCol(int) const;
    int findRow(int) const;
    const QScrollBar *horizontalScrollBar() const;
    int lastColVisible() const;
    int lastRowVisible() const;
    int leftCell() const;
    int maxColOffset();
    int maxRowOffset();
    int maxViewX() const;
    int maxViewY() const;
    int maxXOffset();
    int maxYOffset();
    int minViewX() const;
    int minViewY() const;
    int numCols() const;
    int numRows() const;
    abstract void paintCell(QPainter *, int, int);
    virtual void paintEvent(QPaintEvent *);
    virtual void resizeEvent(QResizeEvent *);
    bool rowIsVisible(int) const;
    bool rowYPos(int, int *) const;
    void scroll(int, int);
    void setAutoUpdate(bool);
    void setCellHeight(int);
    void setCellWidth(int);
    void setLeftCell(int);
    void setNumCols(int);
    void setNumRows(int);
    void setOffset(int, int, bool = TRUE);
    void setTableFlags(uint);
    void setTopCell(int);
    void setTopLeftCell(int, int);
    void setXOffset(int);
    void setYOffset(int);
    virtual void setupPainter(QPainter *);
    uint tableFlags() const;
    bool testTableFlags(uint) const;
    int topCell() const;
    virtual int totalHeight();
    virtual int totalWidth();
    void updateCell(int, int, bool = TRUE);
    void updateScrollBars();
    void updateTableSize();
    const QScrollBar *verticalScrollBar() const;
    int viewHeight() const;
    int viewWidth() const;
    QRect viewRect() const;
    int xOffset() const;
    int yOffset() const;
} Qt::TableView;
