/*
 * Decompiled with CFR 0.152.
 */
package org.flyingtitans.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetOpt {
    private static final String RCSID = "$Id: GetOpt.java 12 2008-08-10 01:06:08Z lanhel $";
    private String[] args = new String[0];
    private Map<String, String[]> options = new HashMap<String, String[]>();

    public GetOpt() {
    }

    public GetOpt(Map<String, String[]> defaults) {
        this();
        for (String key : defaults.keySet()) {
            String[] val = defaults.get(key);
            this.options.put(key, val);
        }
    }

    public final String[] getArgs() {
        return (String[])this.args.clone();
    }

    public final boolean containsOption(String option) {
        return this.options.containsKey(option);
    }

    public final String getParameter(String option, String defvalue) {
        String ret = defvalue;
        String[] param = this.options.get(option);
        if (param != null) {
            ret = param[param.length - 1];
        }
        return ret;
    }

    public final String getParameter(String option) {
        return this.getParameter(option, "");
    }

    public final String[] getParameters(String option) {
        return this.options.get(option);
    }

    public void parseArgs(String[] argv, String opt, String[] lngopt) {
        Object[] longopt = (String[])lngopt.clone();
        Arrays.sort(longopt);
        int nonopt = argv.length;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equals("--")) {
                nonopt = i + 1;
                i = argv.length;
                continue;
            }
            if (arg.startsWith("--")) {
                i = this.longOption((String[])longopt, argv, i);
                continue;
            }
            if (arg.startsWith("-")) {
                i = this.shortOption(opt, argv, i);
                continue;
            }
            nonopt = i;
            i = argv.length;
        }
        if (nonopt < argv.length) {
            int len = argv.length - nonopt;
            String[] rem = new String[len + this.args.length];
            System.arraycopy(this.args, 0, rem, 0, this.args.length);
            System.arraycopy(argv, nonopt, rem, this.args.length, len);
            this.args = rem;
        }
    }

    private int shortOption(String opt, String[] argv, int idx) {
        int index = idx;
        String arg = argv[index];
        int eq = arg.indexOf(61);
        if (eq == -1) {
            if (arg.length() > 2) {
                for (int i = 1; i < arg.length(); ++i) {
                    String o = "-" + arg.substring(i, i + 1);
                    int oi = opt.indexOf(o.substring(1));
                    if (oi == -1) {
                        this.unknownArgument(o);
                        continue;
                    }
                    if (oi + 1 < opt.length() && opt.charAt(oi + 1) == ':') {
                        this.parameterNeeded(o);
                        continue;
                    }
                    this.addOption(o, "");
                }
            } else {
                int oi = opt.indexOf(arg.substring(1));
                if (oi == -1) {
                    this.unknownArgument(arg);
                } else if (oi + 1 < opt.length() && opt.charAt(oi + 1) == ':') {
                    if (index + 1 >= argv.length) {
                        this.parameterNeeded(arg);
                    }
                    this.addOption(arg, argv[++index]);
                } else {
                    this.addOption(arg, "");
                }
            }
        } else {
            int oi = opt.indexOf(arg.substring(1, 2));
            if (oi == -1) {
                this.unknownArgument(arg);
            } else if (oi + 1 == opt.length() || opt.charAt(oi + 1) != ':') {
                this.noParameterAllowed(arg);
            } else {
                this.addOption(arg.substring(0, eq), arg.substring(eq + 1));
            }
        }
        return index;
    }

    private int longOption(String[] opt, String[] argv, int idx) {
        int index = idx;
        String arg = argv[index];
        int eq = arg.indexOf(61);
        if (eq == -1) {
            int oi = Arrays.binarySearch(opt, arg.substring(2));
            if (oi < 0) {
                oi = Arrays.binarySearch(opt, arg.substring(2) + "=");
                if (oi < 0) {
                    this.unknownArgument(arg);
                } else {
                    if (index + 1 >= argv.length) {
                        this.parameterNeeded(arg);
                    }
                    this.addOption(arg, argv[++index]);
                }
            } else {
                this.addOption(arg, "");
            }
        } else {
            int oi = Arrays.binarySearch(opt, arg.substring(2, eq + 1));
            if (oi < 0) {
                this.unknownArgument(arg);
            } else if (!opt[oi].endsWith("=")) {
                this.noParameterAllowed(arg);
            } else {
                this.addOption(arg.substring(0, eq), arg.substring(eq + 1));
            }
        }
        return index;
    }

    private void addOption(String key, String val) {
        String[] parm = new String[]{val};
        if (this.options.containsKey(key)) {
            String[] old = this.options.get(key);
            parm = new String[old.length + 1];
            System.arraycopy(old, 0, parm, 0, old.length);
            parm[parm.length - 1] = val;
        }
        this.options.put(key, parm);
    }

    private void unknownArgument(String arg) {
        String str = "Unknown argument {0}.";
        Object[] parms = new Object[]{arg};
        String msg = MessageFormat.format(str, parms);
        throw new IllegalArgumentException(msg);
    }

    private void parameterNeeded(String arg) {
        String str = "Option {0} requires a parameter.";
        Object[] parms = new Object[]{arg};
        String msg = MessageFormat.format(str, parms);
        throw new IllegalArgumentException(msg);
    }

    private void noParameterAllowed(String arg) {
        String str = "Option {0} cannot take a parameter.";
        Object[] parms = new Object[]{arg};
        String msg = MessageFormat.format(str, parms);
        throw new IllegalArgumentException(msg);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (String opt : this.options.keySet()) {
            String[] parms = this.options.get(opt);
            for (int i = 0; i < parms.length; ++i) {
                String parm = parms[i];
                if (parm.equals("")) {
                    ret.append(opt).append(" ");
                    continue;
                }
                ret.append(opt).append("=").append(parm).append(" ");
            }
        }
        for (int i = 0; i < this.args.length; ++i) {
            ret.append(this.args[i]).append(" ");
        }
        return ret.toString();
    }
}

