/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogConfig {
    public static final String RCSID = "$Id";
    private LogManager mgr = LogManager.getLogManager();
    private Formatter simplefmt = new SimpleFormatter();
    private Handler console = new ConsoleHandler();
    private Handler xmlfile;

    public LogConfig() throws IOException {
        LogManager.getLogManager().reset();
        String logType = System.getProperty("org.ttt.logging.config", "RELEASE");
        if (logType.equals("DEBUG")) {
            this.console.setLevel(Level.FINEST);
            this.console.setFormatter(this.simplefmt);
            Logger.getLogger("org.ttt").setLevel(Level.INFO);
            Logger.getLogger("org.ttt").addHandler(this.console);
            Logger.getLogger("org.ttt.salt", "org.ttt.salt.Logging");
            Logger.getLogger("org.ttt.salt").setLevel(Level.INFO);
        } else if (logType.equals("RELEASE")) {
            this.console.setLevel(Level.FINEST);
            this.console.setFormatter(this.simplefmt);
            Logger.getLogger("org.ttt").setLevel(Level.INFO);
            Logger.getLogger("org.ttt").addHandler(this.console);
            Logger.getLogger("org.ttt.salt", "org.ttt.salt.Logging");
            Logger.getLogger("org.ttt.salt").setLevel(Level.WARNING);
        } else if (logType.endsWith(".properties")) {
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream config = loader.getResourceAsStream(logType);
            assert (config != null);
            this.mgr.readConfiguration(config);
        } else {
            String msg = String.format("Invalid value for org.ttt.logging.config : %s", logType);
            throw new IOException(msg);
        }
    }
}

