package DBE::Install;
use 5.006;
use ExtUtils::MakeMaker;
use Config;

use strict;

our (%makeopts, $debug);

$ENV{'MAKE_DBE'} = 1;

$Verbose = 0;

my @argv = ();
foreach( @ARGV ) {
	$_ = lc( $_ );
	if( /--help/ ) {
		&print_usage();
	}
	elsif( /--debug-all/ ) {
		if( m/--debug-all=(\d+)/ ) {
			$debug = $ENV{'DBE_DEBUG'} = $1;
		}
		else {
			$debug = $ENV{'DBE_DEBUG'} = 1;
		}
	}
	elsif( /--debug/ ) {
		if( m/--debug=(\d+)/ ) {
			$debug = $1;
		}
		else {
			$debug = 1;
		}
	}
	elsif( /--verbose/ ) {
		$Verbose = $ENV{'DBE_VERBOSE'} = 1;
	}
	elsif( /--bundle/ ) {
		$ENV{'DBE_BUNDLE'} = 1;
	}
	elsif( /--build/ ) {
		$ENV{'DBE_BUILD'} = 1;
	}
	else {
		push @argv, $_;
	}
}
@ARGV = @argv;

open FH, '< dbe_sql.h' or die "can't open dbe_sql.h: $!";
my @dbe_sql = <FH>;
close FH;
my %getinfo_codes = ();
my $start = 0;
foreach( @dbe_sql ) {
	chomp;
	if( ! $start ) {
		if( /begin: getinfo codes/i ) {
			$start = 1;
		}
		next;
	}
	if( /end: getinfo codes/i ) {
		last;
	}
	if( /(\w+)\s+=\s+[\(]*([-]*\d+)/ ) {
		substr( $1, 0, 4 ) eq 'SQL_' or next;
		$getinfo_codes{$2} = $1;
	}
}
open FH, "> dbe_trace_getinfo.c";
print FH <<EOT;
/* generated by Makefile.PL from "dbe_sql.h" */

#include "dbe_def.h"

const char *dbe_trace_getinfo_name( int code ) {
	switch( code ) {
EOT
foreach( sort { $a <=> $b } keys %getinfo_codes ) {
	printf FH "\t\tcase %5d: return \"%s\";\n", $_, $getinfo_codes{$_};
}
print FH <<EOT;
		default: return NULL;
	}
}
EOT

%makeopts = (
	'NAME' => 'DBE',
	'VERSION_FROM' => 'DBE.pm',
	'ABSTRACT' => 'DBE - Database (Express) Engine for Perl',
	'INC' => '-I.',
	'LIBS' => [],
	'DEFINE' => '',
	'XSPROTOARG' => '-prototypes',
	'OBJECT' => '$(O_FILES)',
	'XS' => { 'DBE.xs' => 'DBE.c' },
	'C' => [ 'dbe_def.c', 'DBE.c', 'dbe_trace_getinfo.c' ],
	'H' => [ 'dbe_def.h', 'dbe.h', 'dbe_sql.h' ],
	'DIR' => [ 'xs' ],
	'PL_FILES' => {
		'install_files.PL' => 'true',
	},
);

if( $ENV{'DBE_BUILD'} ) {
	$makeopts{'PL_FILES'}{'dbe_build.PL'} = 'true';
}

if( $debug ) {
	print "DBE: enable debug messages\n";
	$makeopts{'DEFINE'} .= ' -DDBE_DEBUG=' . $debug;
	if( $^O eq 'linux' ) {
		$makeopts{'DEFINE'} .= ' -Wall';
	}
}
if( $^O eq 'MSWin32' ) {
	$makeopts{'DEFINE'} .= ' -D_CRT_SECURE_NO_DEPRECATE -D_CRT_SECURE_NO_WARNINGS';
	$makeopts{'LIBS'}[0] = '-lkernel32';
}
elsif( $^O eq 'cygwin' ) {
	$makeopts{'LIBS'}[0] = '-L/lib/w32api -lole32 -lversion';
}

open FH, "> dbe_config.h";
print FH <<EOF;
/* generated by Makefile.PL */

#ifndef __DBE_CONFIG_H__
#define __DBE_CONFIG_H__ 1

#define PERL_REVISION $Config{PERL_REVISION}
#define PERL_VERSION $Config{PERL_VERSION}
#define PERL_SUBVERSION $Config{PERL_SUBVERSION}

#endif
EOF
close FH;

WriteMakefile( %makeopts );

1;

sub print_usage {
	print <<EOTH;

Usage: perl $0 [options]
Options:
    --help                    print this message
    --debug[=LEVEL]           compile with debug messages enabled (level 1-2)
    --verbose                 enable MakeMakers verbosity
    --build                   increment build number

EOTH
	exit 256;
}

package MY;

sub cflags {
    my $inherited = shift->SUPER::cflags( @_ );
    if( $^O eq 'MSWin32' ) {
	    $inherited =~ s/-O1/-O2/sg;
    	# set static linking to crt
	    $inherited =~ s/-MD/-MT/sg;
	}
	if( ! $DBE::Install::debug ) {
		$inherited =~ s/\s*-Wall\s*/ /sg;
	}
    $inherited;
}

sub const_loadlibs {
    my $inherited = shift->SUPER::const_loadlibs( @_ );
    if( $^O eq 'MSWin32' ) {
    	# set static linking to crt
	    $inherited =~ s/msvcrt\.lib/libcmt\.lib/sgi;
	}
    $inherited;
}
