package DBE::Const::Install;
use 5.006;
use ExtUtils::MakeMaker;
use Config;

use strict;

open FH, '<../../dbe_sql.h' or die "can't open dbe_sql.h: $!";
my @dbe_sql = <FH>;
close FH;
my %dbe_sql = ();
my $tag = undef;
my %tags = ();
foreach( @dbe_sql ) {
	chomp;
	if( /begin: SQL datatype codes/i ) {
		$tag = 'sql_types';
	}
	elsif( /end: SQL datatype codes/i ) {
		$tag = undef;
	}
	elsif( /begin: getinfo codes/i ) {
		$tag = 'getinfo_types';
	}
	elsif( /end: getinfo codes/i ) {
		$tag = undef;
	}
	if( /(\w+)\s+=\s+[\(]*([-]*\d+)/ ) {
	}
	elsif( /#define\s+(\w+)\s+(0x*\d+)/ ) {
	}
	elsif( /#define\s+(\w+)\s+([-]*\d+)/ ) {
	}
	else {
		next;
	}
	substr( $1, 0, 4 ) eq 'SQL_' or next;
	$dbe_sql{$1} = $2;
	if( $tag ) {
		$tags{$tag} ||= {};
		$tags{$tag}{$1} = $2;
	}
}
my %cascade = ();
&build_tree( \%dbe_sql, \%cascade, 4 );
my $src = &build_switch( \%cascade, 4, 1 );
open FH, "> dbe_const.c";
print FH <<EOT;
/* generated by Makefile.PL from "dbe_sql.h" */

#include "dbe_const.h"

long dbe_const_by_name( const char *str, size_t str_len, int *empty ) {
	const char *tmp;
	if( str_len < 8 || str[0] != 'S' || str[1] != 'Q' || str[2] != 'L' ||
		str[3] != '_'
	) {
		*empty = 1;
		return 0;
	}
$src
	*empty = 1;
	return 0;
}
EOT
my @tags = sort keys %tags;
print FH "\nconst dbe_export_item_t dbe_export_items[] = {\n";
my %i;
my $i = 0;
foreach( @tags ) {
	my $tags = $tags{$_};
	$i{$_}{'start'} = $i;
	print FH "/* $_ */\n";
	foreach( sort keys %$tags ) {
		print FH "\t{ \"$_\", $_ },\n";
		$i ++;
	}
	$i{$_}{'end'} = $i - 1;
}
print FH "};\n";
print FH "\nconst dbe_export_tag_t dbe_export_tags[] = {\n";
foreach( @tags ) {
	print FH "\t{ \"$_\", ", $i{$_}{'start'}, ", ", $i{$_}{'end'}, " },\n";
}
print FH "};\n";
print FH "\nconst size_t dbe_export_tags_count = ", scalar @tags, ";\n";
close FH;
#print $src;

#use Data::Dumper;
#print Data::Dumper->Dump( [\%cascade] );
#die;

my %makeopts = (
	'NAME' => 'DBE::Const',
	'VERSION_FROM' => 'Const.pm',
	'ABSTRACT' => 'DBE Constants',
	'LIBS' => [],
	'DEFINE' => '',
	'INC' => '-I../../',
	'XSPROTOARG' => '-noprototypes',
	'PREREQ_PM' => {
	},
	'OBJECT' => '$(O_FILES)',
	'XS' => { 'Const.xs' => 'Const.c' },
	'C' => [ 'dbe_const.c', 'Const.c' ],
	'H' => [ 'dbe_const.h' ],
);

if( $^O eq 'MSWin32' ) {
	$makeopts{'DEFINE'} .= ' -D_CRT_SECURE_NO_DEPRECATE -D_CRT_SECURE_NO_WARNINGS';
	$makeopts{'LIBS'}[0] = '-lkernel32';
}
elsif( $^O eq 'cygwin' ) {
	$makeopts{'LIBS'}[0] = '-L/lib/w32api -lole32 -lversion';
}

WriteMakefile( %makeopts );

1;

sub build_tree {
	my ($kw, $cascade, $start) = @_;
	my $chc = 0;
	my $chp = '';
	foreach( sort keys %$kw ) {
		my $ch = substr( $_, $start, 1 );
		if( $ch ne $chp ) {
			if( $chc > 10 ) {
				my $kw = $cascade->{$chp};
				$cascade->{$chp} = {};
				&build_tree( $kw, $cascade->{$chp}, $start + 1 );
			}
			$chp = $ch;
			$cascade->{$ch} = {};
			$chc = 0;
		}
		$cascade->{$ch}{$_} = $kw->{$_};
		$chc ++;
	}
	if( $chc > 10 ) {
		my $kw = $cascade->{$chp};
		$cascade->{$chp} = {};
		&build_tree( $kw, $cascade->{$chp}, $start + 1 );
	}
}

sub build_switch {
	my ($tree, $start, $indent) = @_;
	my $ind = "\t" x $indent;
	my $ret = $ind . "switch( str[$start] ) {\n";
	foreach( sort keys %$tree ) {
		my $val = $tree->{$_};
		$ret .= $ind . "case '$_':\n";
		my ($key) = keys %$val;
		if( length( $key ) == 1 ) {
			$ret .= &build_switch( $val, $start + 1, $indent + 1 );
		}
		else {
			my $tree = $val;
			$ret .= $ind . "\ttmp = str + $start;\n";
			foreach( sort keys %$tree ) {
				$val = $tree->{$_};
				#my $key = substr( $_, $start );
				$ret .= $ind . "\tif( strcmp( tmp, \"$_\" + $start ) == 0 )\n";
				$ret .= $ind . "\t\treturn $_;\n";
			}
		}
		$ret .= $ind . "\tbreak;\n";
	}
	$ret .= $ind . "}\n";
	return $ret;
}

package MY;

sub cflags {
    my $inherited = shift->SUPER::cflags( @_ );
    if( $^O eq 'MSWin32' ) {
	    $inherited =~ s/-O1/-O2/sg;
    	# set static linking to crt
	    $inherited =~ s/-MD/-MT/sg;
	}
#	if( ! $DBE::Text::Install::debug ) {
#		$inherited =~ s/\s*-Wall\s*/ /sg;
#	}
    $inherited;
}

sub const_loadlibs {
    my $inherited = shift->SUPER::const_loadlibs( @_ );
    if( $^O eq 'MSWin32' ) {
    	# set static linking to crt
	    $inherited =~ s/msvcrt\.lib/libcmt\.lib/sgi;
	}
    $inherited;
}
