#include "common.h"

const char CHAR_FROM_HEX[] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

const char *HEX_FROM_CHAR = "0123456789ABCDEF";

const char ANSI_UCASE[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23,
	0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
	0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
	0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b,
	0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 0x82, 0x83,
	0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b,
	0x9c, 0x9d, 0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3,
	0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb,
	0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 0xe0, 0xe1, 0xe2, 0xe3,
	0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb,
	0xfc, 0xfd, 0xfe, 0xff
};

const char ANSI_LCASE[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
	0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23,
	0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
	0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x61, 0x62, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
	0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b,
	0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 0x82, 0x83,
	0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b,
	0x9c, 0x9d, 0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3,
	0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb,
	0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 0xe0, 0xe1, 0xe2, 0xe3,
	0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb,
	0xfc, 0xfd, 0xfe, 0xff
};

#ifdef USE_PERLIO

INLINE char *PerlIO_gets( PerlIO *stream, char *buf, int max ) {
	char *p1 = buf, *p2 = buf + max;
	int val;
	while( p1 < p2 ) {
		val = PerlIO_getc( stream );
		switch( val ) {
		case EOF:
			if( p1 == buf )
				return NULL;
			break;
		case '\n':
			break;
		case '\r':
			continue;
		}
		*p1 ++ = (char) val;
	}
	*p1 = '\0';
	return p1;
}

#endif


INLINE char *my_strtolower( register char *a ) {
	for( ; *a != '\0'; a ++ )
		*a = TOLOWER( *a );
	return a;
}

INLINE char *my_strtoupper( char *a ) {
	for( ; *a != '\0'; a ++ )
		*a = TOUPPER( *a );
	return a;
}

INLINE char *my_strncpy( register char *dst, register const char *src, size_t len ) {
	for( ; len > 0 && *src != '\0'; len --, *dst ++ = *src ++ );
	*dst = '\0';
	return dst;
}

INLINE char *my_strcpy( register char *dst, register const char *src ) {
	for( ; *src != '\0'; *dst ++ = *src ++ );
	*dst = '\0';
	return dst;
}

INLINE char *my_strncpyu( register char *dst, register const char *src, size_t len ) {
	for( ; len > 0 && *src != '\0'; len --, *dst ++ = TOUPPER( *src ++ ) );
	*dst = '\0';
	return dst;
}

INLINE int my_stricmp( register const char *cs, register const char *ct ) {
	register signed char res = 0;
	while( 1 ) {
		if( ! *cs || (res = TOUPPER( *cs ) - TOUPPER( *ct )) != 0 )
			break;
		ct ++, cs ++;
	}
	return res;
}

INLINE int my_strnicmp( const char *cs, const char *ct, size_t len ) {
	register signed char res = 0;
	register const char *ce = cs + len;
	while( 1 ) {
		if( cs == ce || ! *cs || (res = TOUPPER( *cs ) - TOUPPER( *ct )) != 0 )
			break;
		ct ++, cs ++;
	}
	return res;
}

INLINE int my_strncmp( const char *cs, const char *ct, size_t len ) {
	register signed char res = 0;
	register const char *ce = cs + len;
	while( 1 ) {
		if( cs == ce || ! *cs || (res = *cs - *ct) != 0 )
			break;
		ct ++, cs ++;
	}
	return res;
}

INLINE char *my_stristr( register const char *str, const char *search ) {
	register char *i, *j;
	register char first = TOUPPER(*search);
skip:
	while( *str != '\0' ) {
		if( TOUPPER(*str ++) == first ) {
			i = (char *) str;
			j = (char *) search + 1;
			while( *j )
				if( TOUPPER(*i ++) != TOUPPER(*j ++) )
					goto skip;
			return ((char *) str - 1);
		}
	}
	return ((char *) 0);
}

INLINE char *my_itoa( register char *str, long value, int radix ) {
	char tmp[21], *ret = tmp, neg;
	if( value >= 0 )
		neg = 0;
	else {
		value = -value;
		neg = 1;
	}
	switch( radix ) {
	case 16:
		do {
			*ret ++ = HEX_FROM_CHAR[value % 16];
			value /= 16;
		} while( value > 0 );
		break;
	default:
		do {
			*ret ++ = (char) ((value % radix) + '0');
			value /= radix;
		} while( value > 0 );
		if( neg )
			*ret ++ = '-';
	}
	for( ret --; ret >= tmp; *str ++ = *ret -- );
	*str = '\0';
	return str;
}

INLINE char *my_ftoa( register char *buf, double f ) {
	register char *p;
	f = f >= 0.0
		? (f * 1000000000.0 + 0.5) / 1000000000.0
		: (f * 1000000000.0 - 0.5) / 1000000000.0
	;
	if( f < 0.0 && f > -1.0 ) {
		p = my_itoa( buf, -1, 10 );
		*(p - 1) = '0';
	}
	else
		p = my_itoa( buf, (long) f, 10 );
	*p ++ = '.';
	if( f < 0.0 )
		f = -f;
	p = my_itoa( p, (long) ((f - (long) f) * 1000000000.0), 10 );
	for( ; *(p - 1) == '0'; p -- );
	*p = '\0';
	return p;
}

const double ROUND_PREC[] = {
	1, 10, 1e2, 1e3, 1e4, 1e5, 1e6, 1e7, 1e8, 1e9, 1e10, 1e11, 1e12
	, 1e13, 1e14, 1e15, 1e16, 1e17, 1e18, 1e19
};
const int ROUND_PREC_MAX = 1 + (int) ARRAY_LEN( ROUND_PREC );

INLINE double my_round( double num, int prec ) {
	if( prec < 0 ) {
		int div = prec * -10;
		return floor( num / div + (num < 0.0 ? -0.5 : 0.5) ) * div;
	}
	if( prec > ROUND_PREC_MAX ) {
		prec = ROUND_PREC_MAX;
	}
	if( num < 0.0 ) {
		return floor( num * ROUND_PREC[prec] - 0.5 ) / ROUND_PREC[prec];
	}
	else {
		return floor( num * ROUND_PREC[prec] + 0.5 ) / ROUND_PREC[prec];
	}
}

#ifdef CSV_DEBUG

int my_debug( const char *fmt, ... ) {
	va_list a;
	int r;
	size_t l;
	char *tmp, *s1;
	l = strlen( fmt );
	tmp = malloc( 64 + l );
	s1 = my_strcpy( tmp, "[dbe_csv] " );
	s1 = my_strcpy( s1, fmt );
	va_start( a, fmt );
	r = vfprintf( stderr, tmp, a );
	va_end( a );
	free( tmp );
	return r;
}

#if CSV_DEBUG > 1

HV					*hv_dbg_mem = NULL;
perl_mutex			dbg_mem_lock;

void debug_init() {
	_debug( "init memory logger\n" );
	MUTEX_INIT( &dbg_mem_lock );
	hv_dbg_mem = newHV();
}

void debug_free() {
	SV *sv_val;
	char *key, *val;
	I32 retlen;
	STRLEN lval;
	_debug( "hv_dbg_mem entries %u\n", HvKEYS( hv_dbg_mem ) );
	if( HvKEYS( hv_dbg_mem ) ) {
		hv_iterinit( hv_dbg_mem );
		while( (sv_val = hv_iternextsv( hv_dbg_mem, &key, &retlen )) != NULL ) {
			val = SvPV( sv_val, lval );
			_debug( "unfreed memory from %s\n", val );
		}
	}
	sv_2mortal( (SV *) hv_dbg_mem );
	MUTEX_DESTROY( &dbg_mem_lock );
}

#endif /* CSV_DEBUG > 1 */

#endif /* defined CSV_DEBUG */
