
/* This file is meant to be loaded by utility.c */

struct _class_poly {
  unsigned short  D;
  unsigned short  type;
  unsigned short  degree;
  const char *coefs;
};
/* Type:  1 = Hilbert, 2 = Weber */
/*
 * Discriminants under 10k with degree (1..12):
 *   (9, 18, 16, 54, 25, 51, 31, 131, 31, 82, 31, 181)
 */
static const struct _class_poly _class_poly_data[] =
{
  { 3, 1, 1, "\x00" },
  { 4, 1, 1, "\x81\x0c" },
  { 7, 1, 1, "\x01\x0f" },
  { 8, 1, 1, "\x81\x14" },
  { 11, 1, 1, "\x01\x20" },
  { 15, 1, 2, "\x82\x01\xef\x03\x02\xea\x31" },
  { 19, 1, 1, "\x01\x60" },
  { 20, 1, 2, "\x82\x03\x70\x83\x13\x49\x80" },
  { 23, 1, 3, "\x02\x5b\x4f\x85\x01\x33\x0a\x8d\x6b\x03\x35\x47\xa6" },
  { 24, 1, 2, "\x02\x09\x90\x83\x49\xc6\x80" },
  { 31, 2, 3, "\x81\x01\x00\x81\x01" },
  { 35, 1, 2, "\x82\x14\x00\x04\x07\x08\x00\x00" },
  { 39, 1, 4, "\x03\x2a\x0b\x31\x08\x01\x86\x59\x60\x01\x2d\x59\x13\x85\x64\x16\xc8\x63\x32\x04\x13\xc2\xc5\x4c" },
  { 40, 1, 2, "\x02\x51\x90\x84\x19\x5f\x8e\x80" },
  { 43, 1, 1, "\x02\x03\xc0" },
  { 47, 2, 5, "\x81\x01\x81\x02\x81\x02\x81\x01\x00" },
  { 51, 1, 2, "\x02\x48\x00\x05\x01\x4a\x46\x80\x00" },
  { 52, 1, 2, "\x83\x01\x43\x70\x85\x01\x9b\x16\x09\x80" },
  { 55, 2, 4, "\x81\x01\x01\x01\x00\x81\x02" },
  { 56, 2, 4, "\x01\x01\x81\x02\x01\x01\x81\x02" },
  { 59, 1, 3, "\x03\x0b\x00\x00\x86\x80\x11\x40\x00\x00\x00\x05\x07\x07\xec\x00\x00" },
  { 67, 1, 1, "\x02\x14\xa0" },
  { 68, 2, 4, "\x01\x01\x81\x01\x81\x02\x81\x01" },
  { 71, 2, 7, "\x81\x01\x81\x01\x01\x01\x01\x01\x01\x01\x81\x01\x81\x02" },
  { 79, 2, 5, "\x81\x01\x01\x01\x81\x01\x01\x02\x81\x03" },
  { 83, 1, 3, "\x03\x7d\x00\x00\x87\x93\x66\xfc\x40\x00\x00\x00\x06\x02\x72\xc2\x32\x00\x00" },
  { 84, 1, 4, "\x84\x0a\x48\x2f\x00\x0a\x12\xcf\x02\x69\xba\x4c\x8e\x50\x00\x00\x88\x4e\x99\x6e\x3e\xf5\xc2\xa0\x00\x86\x02\xe8\x50\x2f\x53\x00" },
  { 87, 1, 6, "\x05\xbe\xbd\x9f\x9d\x91\x0e\x15\x4e\xe4\xc7\x9e\x0b\x3e\x8c\x92\x23\xa5\x21\x0e\x69\x0d\x06\x47\xc2\xa7\x9a\xe4\x7e\x2e\xb7\x67\x2b\x8b\x55\x0b\x17\x6d\x39\x65\x89\x6c\x12\xcf\xe8\x43\xd8\x08\x01\x30\x0f\x4f\xcf\x53\x5a\x3e\x06\x04\xd7\x11\xb7\x67\x03" },
  { 88, 1, 2, "\x03\x26\x49\x90\x86\x05\xb9\xa1\xdc\x06\x80" },
  { 91, 1, 2, "\x83\x02\x64\x00\x06\x09\x6b\xe8\xde\x00\x00" },
  { 95, 2, 8, "\x81\x01\x01\x01\x00\x81\x01\x01\x02\x01\x01\x81\x02\x81\x02" },
  { 103, 2, 5, "\x81\x01\x81\x02\x81\x03\x81\x03\x81\x01" },
  { 104, 2, 6, "\x81\x01\x81\x02\x01\x02\x00\x81\x02\x81\x02" },
  { 107, 1, 3, "\x04\x04\x26\x80\x00\x88\x5d\xe0\x69\xf9\x40\x00\x00\x00\x06\x76\x09\x86\x47\x80\x00" },
  { 115, 1, 2, "\x03\x07\xbc\x00\x07\x01\x85\x23\xfe\x2a\x00\x00" },
  { 116, 2, 6, "\x81\x01\x81\x09\x81\x05\x01\x02\x01\x05\x81\x09" },
  { 119, 2, 10, "\x01\x01\x81\x01\x01\x02\x81\x04\x01\x05\x81\x07\x01\x09\x81\x08\x01\x05\x81\x04" },
  { 120, 1, 4, "\x05\x03\xf6\xc1\x71\x00\x8c\x08\x5d\x1f\x5e\x7f\x78\xe4\xc1\x3d\x50\x00\x00\x0a\x05\x93\x51\xeb\xb8\x08\x10\xcb\x60\x00\x87\x03\x23\x25\x48\xba\xed\x00" },
  { 123, 1, 2, "\x03\x50\xdc\x00\x07\x04\xcf\x96\xe1\x68\x00\x00" },
  { 127, 2, 5, "\x81\x01\x01\x01\x01\x02\x81\x01\x81\x03" },
  { 131, 1, 5, "\x05\x0c\x38\x00\x00\x00\x8c\xc3\x04\x38\xbc\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x58\xad\xa4\xf2\xb9\xa0\x00\x00\x00\x00\x00\x89\x24\x62\x74\x24\x41\x40\x00\x00\x00\x07\x0e\xac\xa7\xaa\x63\x80\x00" },
  { 132, 1, 4, "\x05\x02\xc1\x45\x51\x00\x0c\xb1\xaa\x25\x2f\x67\x5c\x12\x8d\x84\xd0\x00\x00\x8a\x44\xdd\xc1\xb9\x13\xdb\x3d\x86\xa0\x00\x87\x10\xd4\x26\xfa\x2c\xeb\x00" },
  { 136, 2, 4, "\x01\x01\x81\x03\x00\x81\x03" },
  { 139, 1, 3, "\x04\x02\x6d\x00\x00\x89\x02\xe0\x1a\x48\x06\xc0\x00\x00\x00\x07\x2b\x48\x85\x2d\xc1\x00\x00" },
  { 143, 2, 10, "\x81\x01\x01\x03\x81\x06\x01\x06\x81\x03\x81\x03\x01\x09\x81\x0d\x01\x0c\x81\x06" },
  { 148, 2, 2, "\x81\x01\x81\x0c" },
  { 151, 2, 7, "\x81\x01\x81\x01\x81\x01\x00\x81\x03\x81\x01\x81\x03" },
  { 152, 2, 6, "\x81\x01\x81\x04\x00\x01\x06\x00\x81\x04" },
  { 155, 1, 4, "\x05\x07\xc9\xc0\x00\x00\x0c\x41\xe7\x62\x49\xbb\x10\x00\x00\x00\x00\x00\x00\x8a\x09\x6b\x26\x75\x0c\x46\xc0\x00\x00\x00\x08\x01\x58\x47\x13\xf0\x5b\x00\x00" },
  { 163, 1, 1, "\x03\x09\xc5\x40" },
  { 164, 2, 8, "\x01\x01\x81\x05\x01\x07\x81\x0c\x01\x0e\x81\x0c\x01\x07\x81\x05" },
  { 167, 2, 11, "\x81\x01\x81\x01\x81\x05\x81\x04\x81\x0a\x81\x06\x81\x0b\x81\x07\x81\x09\x81\x04\x81\x02" },
  { 168, 1, 4, "\x05\xb8\x62\x28\x71\x00\x8e\x0d\x0c\xdf\x57\xce\x46\x1b\x66\xa7\xd0\x8c\x50\x00\x00\x0c\x01\x16\x5b\x1e\xb5\x54\x0a\x81\x94\xf3\x60\x00\x88\x06\xb5\x82\x38\x02\x13\xdd\x00" },
  { 179, 1, 5, "\x06\x03\xbc\xa8\x00\x00\x00\x8f\x04\x82\x24\xc7\x5d\x7b\xf8\x90\x00\x00\x00\x00\x00\x00\x00\x0d\x21\xbb\x85\xc7\xd6\xe9\xfa\xc0\x00\x00\x00\x00\x00\x8b\x01\xd1\xed\x0d\x19\xa9\xf0\x00\x00\x00\x00\x08\x18\xe9\xcf\xef\x3e\xf9\x00\x00" },
  { 184, 2, 4, "\x01\x01\x81\x06\x01\x09\x81\x06" },
  { 187, 1, 2, "\x83\xef\x10\x00\x08\x3f\x14\x47\x5b\x65\x24\x80\x00" },
  { 191, 2, 13, "\x81\x01\x01\x02\x00\x81\x04\x01\x05\x81\x01\x81\x05\x01\x0b\x81\x13\x01\x16\x81\x10\x01\x0a\x81\x06" },
  { 195, 1, 4, "\x85\x0e\x56\x50\x00\x00\x0d\x01\x52\x8a\x46\xfd\x3a\x45\x40\x00\x00\x00\x00\x00\x0b\x14\xf7\xe3\xad\x05\xbb\xdd\x00\x00\x00\x00\x08\x9c\x9a\x48\x7a\x35\xdf\x00\x00" },
  { 199, 2, 9, "\x81\x01\x81\x01\x00\x81\x03\x00\x00\x81\x03\x01\x03\x81\x05" },
  { 203, 1, 4, "\x05\x49\xda\x40\x00\x00\x0e\x0c\x5b\x72\x23\x61\xbc\xf4\x40\x00\x00\x00\x00\x00\x00\x8b\x44\xb3\x36\xe7\xbd\x25\x71\x40\x00\x00\x00\x09\x01\x7d\xac\x30\x8d\x07\xc4\x00\x00" },
  { 211, 1, 3, "\x04\x67\xfe\x00\x00\x0a\x3a\xbd\x5f\x8f\x2b\x18\xc0\x00\x00\x00\x09\x03\x92\x2d\xfe\xa0\x33\x7c\x00\x00" },
  { 212, 2, 6, "\x81\x01\x81\x17\x81\x0c\x81\x4b\x01\x0c\x81\x17" },
  { 215, 2, 14, "\x81\x01\x01\x02\x00\x81\x06\x01\x03\x01\x08\x81\x0d\x81\x04\x01\x10\x81\x07\x81\x0d\x01\x0b\x01\x04\x81\x06" },
  { 219, 1, 4, "\x05\x6f\xe3\xa0\x00\x00\x8d\xc9\xb1\x36\x8a\x9f\xf0\x2c\xa0\x00\x00\x00\x00\x00\x0c\x02\xaf\x6b\x60\xe1\xe4\x44\x86\xc0\x00\x00\x00\x09\x08\x6a\x00\xf2\x0f\x9b\x84\x80\x00" },
  { 223, 2, 7, "\x81\x01\x00\x81\x01\x81\x04\x01\x01\x00\x81\x05" },
  { 227, 1, 5, "\x06\x0f\xa3\xe8\x00\x00\x00\x90\x01\x96\x96\x29\xdf\x46\x91\xda\x70\x00\x00\x00\x00\x00\x00\x00\x0f\x03\x82\xad\x62\x96\xb9\x49\x55\xbc\x00\x00\x00\x00\x00\x00\x8c\x08\x47\x81\xd9\x27\x8c\x8d\x66\x80\x00\x00\x00\x09\x13\x85\x27\x6f\x9b\x5c\xb0\x00\x00" },
  { 228, 1, 4, "\x06\x2c\xdc\xd7\x55\x51\x00\x10\x2c\x41\xc6\x14\xbc\xc9\xfd\x2d\xf7\x38\x59\xf2\xf4\xd0\x00\x00\x8d\x64\xc9\xa0\x4e\x28\x65\xe6\x2b\xbe\x29\x06\xa0\x00\x89\x15\xa9\xa2\xf2\x9e\xba\x75\xeb\x00" },
  { 232, 2, 2, "\x81\x01\x81\x05" },
  { 235, 1, 2, "\x04\x0d\xa0\x34\x00\x09\x2c\x9f\xe1\xad\x9b\xbd\xc3\x00\x00" },
  { 239, 2, 15, "\x81\x01\x01\x04\x81\x04\x81\x04\x01\x05\x01\x0d\x81\x14\x81\x04\x01\x0f\x01\x0d\x81\x1b\x01\x04\x01\x08\x01\x02\x81\x06" },
  { 244, 2, 6, "\x81\x01\x81\x1e\x81\x06\x81\x30\x01\x06\x81\x1e" },
  { 247, 2, 6, "\x81\x01\x81\x03\x81\x06\x81\x07\x81\x07\x81\x04" },
  { 248, 2, 8, "\x01\x01\x81\x02\x81\x0d\x81\x1e\x81\x24\x81\x1e\x81\x0d\x81\x02" },
  { 259, 1, 4, "\x05\x26\x1b\x70\x00\x00\x0d\x45\x55\xdf\xf9\x45\x98\x82\x40\x00\x00\x00\x00\x00\x8c\x01\x30\x8f\x27\x46\xe1\xea\x98\x00\x00\x00\x00\x0a\x01\xeb\xa1\xa7\x44\x5b\x52\x9b\x00\x00" },
  { 260, 2, 8, "\x01\x01\x81\x08\x01\x0c\x01\x08\x81\x1b\x01\x08\x01\x0c\x81\x08" },
  { 263, 2, 13, "\x81\x01\x01\x06\x81\x0f\x01\x15\x81\x13\x01\x0d\x81\x0c\x01\x16\x81\x24\x01\x26\x81\x1b\x01\x10\x81\x08" },
  { 267, 1, 2, "\x05\x01\xe2\xcb\x50\x00\x0a\x04\x2b\x05\xc5\xab\xcb\x90\xb9\x80\x00" },
  { 271, 2, 11, "\x81\x01\x00\x81\x01\x81\x01\x81\x03\x01\x03\x01\x06\x01\x03\x81\x05\x81\x06\x81\x05" },
  { 280, 2, 4, "\x01\x01\x01\x06\x81\x03\x81\x06" },
  { 283, 1, 3, "\x05\x01\x5d\x5d\x80\x00\x0b\x4b\x23\xf4\xe1\x43\x46\xca\xc0\x00\x00\x00\x0a\x12\xf9\xd6\xee\x5f\x2f\x57\x7c\x80\x00" },
  { 287, 2, 14, "\x01\x01\x01\x01\x01\x03\x81\x01\x81\x01\x00\x01\x02\x01\x06\x81\x08\x81\x07\x81\x05\x01\x06\x01\x09\x81\x08" },
  { 291, 1, 4, "\x06\x19\x66\x62\xc0\x00\x00\x0f\x36\xf6\xc6\x86\x91\xb9\x98\xb9\x88\x20\x00\x00\x00\x00\x00\x0d\x88\x25\x58\x96\x0b\x2a\x30\x0a\xde\xc0\x00\x00\x00\x0a\x27\xd7\xef\x08\xe7\xbd\xfb\xb9\x80\x00" },
  { 292, 2, 4, "\x01\x01\x81\x05\x81\x0a\x81\x05" },
  { 295, 2, 8, "\x81\x01\x01\x03\x81\x07\x01\x0a\x81\x07\x81\x01\x01\x09\x81\x08" },
  { 296, 2, 10, "\x81\x01\x81\x08\x81\x09\x81\x04\x81\x09\x81\x04\x01\x09\x81\x04\x01\x09\x81\x08" },
  { 307, 1, 3, "\x05\x04\xd7\x42\x00\x00\x8c\x10\x6d\x18\x00\xf2\x4a\xf9\xd8\x00\x00\x00\x00\x0a\xaa\x78\x0c\x7f\xb1\x36\x22\x3f\x80\x00" },
  { 308, 2, 8, "\x01\x01\x01\x2e\x81\xab\x01\x2e\x02\x01\x64\x81\x2e\x81\xab\x81\x2e" },
  { 311, 2, 19, "\x81\x01\x81\x01\x81\x02\x81\x05\x81\x08\x81\x0e\x81\x0d\x81\x0a\x01\x01\x01\x09\x01\x12\x01\x19\x01\x0a\x81\x04\x81\x26\x81\x2a\x81\x25\x81\x10\x81\x04" },
  { 312, 1, 4, "\x07\x2a\x64\x52\xf3\xb9\x71\x00\x93\x06\xd4\xc8\x81\xc0\x47\x6b\x60\xc9\xcc\x93\xef\x26\xc3\x3d\x75\x50\x00\x00\x10\x01\x0f\xc7\xfa\x5c\x26\x31\xc3\x4f\x78\xfd\xd7\xca\x0b\x60\x00\x8b\x01\x0a\x66\x00\xaa\x55\x5a\xef\x5e\x6d\x00" },
  { 319, 2, 10, "\x81\x01\x81\x05\x81\x0b\x81\x0e\x81\x0a\x81\x02\x81\x01\x81\x05\x81\x09\x81\x06" },
  { 323, 1, 4, "\x87\x01\xc3\x0c\x71\xe0\x00\x00\x11\xd8\xe4\x61\x9e\xec\x56\x22\x92\x7b\x92\xd7\xa0\x00\x00\x00\x00\x00\x8e\x18\x65\xd5\xe6\x06\xa2\x65\x5b\x4e\xc3\x40\x00\x00\x00\x0b\x02\xbe\x90\x72\xf9\xd5\xd0\x4e\x13\x80\x00" },
  { 328, 2, 4, "\x01\x01\x81\x09\x01\x0c\x81\x09" },
  { 331, 1, 3, "\x05\x59\x2b\xd0\x80\x00\x0d\x04\xa7\x6e\x3f\xa2\x56\x09\x40\x52\xc0\x00\x00\x00\x0b\x05\x7f\xa4\x88\x51\x69\x5d\xe1\x49\x80\x00" },
  { 335, 2, 18, "\x81\x01\x81\x05\x81\x0e\x81\x19\x81\x21\x81\x2a\x81\x40\x81\x66\x81\x90\x81\xab\x81\xb3\x81\xae\x81\xa3\x81\x90\x81\x6a\x81\x37\x81\x14\x81\x04" },
  { 339, 1, 6, "\x08\x01\x09\xe3\x87\x00\x00\x00\x00\x14\x13\xfa\x51\xd3\x61\x5f\xa6\x30\x46\x67\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x01\x80\x7f\xa9\xc4\xed\xb7\x3e\x27\xf7\x90\x90\x00\x00\x00\x00\x00\x00\x00\x91\x01\x8d\x2b\x09\x62\xfb\x78\xc1\xa8\x65\xaf\x80\x00\x00\x00\x00\x00\x0e\x99\xd1\xd7\xde\x0f\x8c\x10\x61\xc1\x3d\x80\x00\x00\x00\x0b\x0a\xec\xe0\x1b\x45\x9b\xa0\xe4\x8e\x00\x00" },
  { 340, 2, 4, "\x01\x01\x01\x3f\x01\x22\x81\x3f" },
  { 344, 2, 10, "\x81\x01\x81\x08\x81\x02\x81\x12\x81\x09\x81\x04\x01\x09\x81\x12\x01\x02\x81\x08" },
  { 347, 1, 5, "\x07\x14\x3d\x80\xd8\x00\x00\x00\x93\x03\x72\x56\xa0\x8f\x25\x81\xfc\x3d\x65\x18\x50\x00\x00\x00\x00\x00\x00\x00\x12\x1a\x3f\xc3\xb2\xf4\x0b\x6e\xd3\x3d\x75\x98\x1c\x40\x00\x00\x00\x00\x00\x8f\x01\x7c\x65\x84\x0a\x49\xfb\x46\x03\x81\x79\x00\x00\x00\x00\x0b\x15\x88\x97\x25\x3a\xd8\x8d\xe0\x83\x00\x00" },
  { 355, 1, 4, "\x06\x05\x03\x6c\x40\x00\x00\x8f\x04\x9f\xf8\x4b\x50\x38\x5a\xdf\xdc\x00\x00\x00\x00\x00\x00\x0d\x56\x31\x78\x30\x73\xd0\xba\x84\x4f\xc0\x00\x00\x00\x0b\x2a\x1d\x09\x83\xf6\x1d\xce\x12\x46\x00\x00" },
  { 356, 2, 12, "\x01\x01\x81\x05\x81\x15\x81\x32\x81\x41\x81\x51\x81\x46\x81\x51\x81\x41\x81\x32\x81\x15\x81\x05" },
  { 359, 2, 19, "\x81\x01\x01\x02\x81\x02\x01\x02\x01\x03\x81\x0e\x01\x07\x01\x16\x81\x1e\x01\x09\x81\x05\x01\x02\x01\x33\x81\x5a\x01\x13\x01\x5b\x81\x71\x01\x3b\x81\x0e" },
  { 367, 2, 9, "\x81\x01\x01\x02\x01\x01\x81\x06\x01\x02\x00\x81\x02\x01\x03\x81\x09" },
  { 372, 1, 4, "\x08\x04\xcc\xf4\xc2\x76\xe3\xd1\x00\x15\x01\x33\x7f\xc1\xed\xc5\xfb\x86\x58\x60\x85\xa5\x03\xb5\x30\xc2\xea\x02\x50\x00\x00\x91\x08\xba\x08\xcb\x98\xaa\x89\x2c\xd8\xd0\x5e\x33\x17\x0c\x62\xa0\x00\x8b\xaa\xe6\x09\xd2\x5d\x41\x1b\x42\xb0\x13\x00" },
  { 376, 2, 8, "\x01\x01\x81\x06\x81\x15\x81\x2a\x81\x34\x81\x2a\x81\x15\x81\x06" },
  { 379, 1, 3, "\x06\x02\x43\xd0\xb6\x00\x00\x8e\x05\xfe\x66\xb7\xd5\x92\xd4\xc1\x8e\x25\x40\x00\x00\x00\x0c\x01\x2d\x6b\xba\x70\x4e\x88\xe4\x80\x44\x00\x00" },
  { 383, 2, 17, "\x81\x01\x01\x01\x01\x01\x01\x01\x00\x81\x01\x81\x0d\x81\x07\x81\x0b\x81\x04\x81\x01\x81\x07\x81\x17\x81\x1f\x81\x2a\x81\x18\x81\x06" },
  { 388, 2, 4, "\x01\x01\x81\x09\x81\x02\x81\x09" },
  { 391, 2, 14, "\x01\x01\x00\x81\x05\x81\x05\x01\x07\x01\x0f\x01\x06\x81\x08\x81\x03\x01\x04\x00\x81\x0c\x81\x0c\x81\x08" },
  { 403, 1, 2, "\x85\x01\x1c\x96\x4c\x00\x0c\x07\xec\xeb\x03\xd8\x50\xb4\x8f\x4e\x9d\x00\x00" },
  { 404, 2, 14, "\x81\x01\x81\x65\x82\x01\xc3\x82\x04\x64\x82\x04\x50\x82\x07\x2c\x81\xc2\x82\x09\x26\x01\xc2\x82\x07\x2c\x02\x04\x50\x82\x04\x64\x02\x01\xc3\x81\x65" },
  { 407, 2, 16, "\x81\x01\x81\x01\x81\x02\x81\x01\x81\x09\x01\x02\x81\x0f\x00\x81\x0c\x00\x81\x04\x81\x13\x01\x11\x81\x21\x01\x04\x81\x0a" },
  { 408, 1, 4, "\x08\x20\xf1\x63\x07\x0b\x07\x71\x00\x95\xe5\x29\x19\x9c\xe5\x09\x04\x6a\xa0\x72\xf5\xa1\x23\x66\x3a\x3a\xd1\x13\x50\x00\x00\x12\x02\x80\xd6\xbc\x6f\x04\xfe\xdc\xcb\x07\xc8\x02\xee\x9b\x54\xdb\x60\x00\x8c\x0b\xb4\xc2\x42\xb3\xdd\x87\x29\x42\xf0\x4d\x00" },
  { 411, 1, 6, "\x08\x3a\x02\x01\x29\x00\x00\x00\x00\x96\x0c\x81\xf6\x70\x54\x6e\x64\x07\x33\x8e\x74\x7c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x98\x77\x80\x1c\x23\x6b\x25\x43\x95\x3d\xb1\x8c\xf0\x00\x00\x00\x00\x00\x00\x00\x12\x11\xbb\x44\xfa\xcb\x8c\x35\x13\xa2\x5f\x67\xbf\xc0\x00\x00\x00\x00\x00\x10\x05\xb5\xfa\xdc\xcc\x96\xed\x0b\x01\xf3\x8b\x8a\x00\x00\x00\x00\x0c\x0e\xc6\x90\x58\x43\xfd\xce\x9d\x95\xc5\x00\x00" },
  { 415, 2, 10, "\x81\x01\x00\x81\x06\x01\x02\x81\x0e\x01\x02\x81\x0b\x81\x07\x81\x01\x81\x0a" },
  { 424, 2, 6, "\x81\x01\x81\x0b\x81\x05\x01\x06\x01\x05\x81\x0b" },
  { 427, 1, 2, "\x05\x0c\x82\x0f\xbc\x00\x0c\x32\x71\x7e\x4b\x1d\xf0\xbb\x69\x80\xde\x00\x00" },
  { 435, 1, 4, "\x87\x08\x3f\x6d\x33\x90\x00\x00\x13\x01\xec\x14\x81\xad\xa4\x78\x26\x63\x8a\xe5\xc4\xee\x40\x00\x00\x00\x00\x00\x10\x41\xcd\x38\x26\xc3\x9f\x4f\x0a\x66\xcb\x4c\x0c\x00\x00\x00\x00\x0c\x5c\x67\x21\x8e\x69\xaf\xe3\x9e\x56\x8b\x00\x00" },
  { 436, 2, 6, "\x81\x01\x81\x75\x01\x9c\x81\x09\x81\x9c\x81\x75" },
  { 439, 2, 15, "\x81\x01\x01\x05\x81\x0b\x01\x09\x01\x07\x81\x11\x01\x01\x01\x1d\x81\x26\x01\x0d\x01\x14\x81\x18\x81\x07\x01\x17\x81\x0d" },
  { 440, 2, 12, "\x01\x01\x81\x10\x01\x40\x81\x68\x01\x20\x01\x90\x81\xf6\x01\x90\x01\x20\x81\x68\x01\x40\x81\x10" },
  { 443, 1, 5, "\x08\x10\x2a\x3a\x59\x46\x00\x00\x00\x96\x01\xb9\xca\x61\xd0\xf2\x41\xb5\x53\xc7\xdf\xb1\x04\x6c\xf0\x00\x00\x00\x00\x00\x00\x00\x14\x7f\x48\xc2\xe0\x9a\x21\x3d\x07\xf1\x29\x79\x5c\x09\xa5\x40\x00\x00\x00\x00\x00\x90\x92\x60\x13\x41\x24\xe4\xd6\x49\xfe\x4a\xbd\x80\x80\x00\x00\x00\x0c\xa8\x54\x63\xe7\x67\x22\x45\xcf\x64\x75\x80\x00" },
  { 451, 1, 6, "\x07\xdf\x6e\x06\x00\x00\x00\x00\x15\x04\x79\x45\xf6\x36\xac\xc6\x89\x18\xd7\xc4\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x1a\x35\x65\x0b\x13\x2d\xd7\xd1\xbd\x36\x23\x30\x00\x00\x00\x00\x00\x00\x00\x11\x6d\x8f\x36\x3f\x37\xf6\xae\x45\x52\x21\xa6\xc0\x00\x00\x00\x00\x00\x0f\x07\x44\x59\x71\x99\xab\x6e\x19\x24\x0c\xa1\x00\x00\x00\x00\x0d\x01\x30\xff\x03\x69\xc8\xd6\x4a\x8d\x9b\x9d\x00\x00" },
  { 452, 2, 8, "\x01\x01\x81\x09\x81\x16\x81\x3b\x81\x4e\x81\x3b\x81\x16\x81\x09" },
  { 455, 2, 20, "\x01\x01\x01\x06\x01\x0f\x01\x17\x01\x1a\x01\x10\x81\x0f\x81\x39\x81\x49\x81\x1e\x01\x4c\x01\xc2\x01\xf6\x01\xbf\x01\x26\x81\x81\x81\xc8\x81\x8e\x81\x32\x81\x06" },
  { 463, 2, 7, "\x81\x01\x81\x03\x81\x07\x81\x07\x81\x08\x81\x09\x81\x0b" },
  { 472, 2, 6, "\x81\x01\x81\x0c\x00\x81\x16\x00\x81\x0c" },
  { 483, 1, 4, "\x87\x17\xae\xec\x9c\xb0\x00\x00\x13\x07\x33\x75\x84\x6f\xa6\x2e\x90\x37\x16\xce\x84\xe4\x80\x00\x00\x00\x00\x00\x11\x1c\x16\x35\x65\xbd\x9b\x09\xc6\xec\xe5\xa6\x75\xf4\x80\x00\x00\x00\x0d\x0c\x33\x50\x41\xef\x2c\x48\x7e\x0a\xc0\x36\x00\x00" },
  { 487, 2, 7, "\x81\x01\x01\x01\x81\x04\x01\x07\x81\x04\x01\x04\x81\x0d" },
  { 488, 2, 10, "\x81\x01\x81\x0c\x01\x07\x81\x20\x81\x01\x01\x24\x01\x01\x81\x20\x81\x07\x81\x0c" },
  { 499, 1, 3, "\x06\x98\x08\xb8\xd9\x00\x00\x90\x04\x8f\xd4\x5e\xec\xd9\x0f\x6c\x7a\x44\x66\x0d\x40\x00\x00\x00\x0d\x25\xee\x01\x60\x17\x75\xcd\x35\x64\x8e\x80\x00\x00" },
  { 511, 2, 14, "\x01\x01\x81\x07\x01\x15\x81\x23\x01\x23\x81\x15\x01\x10\x81\x25\x01\x46\x81\x54\x01\x4d\x81\x38\x01\x24\x81\x10" },
  { 515, 1, 6, "\x09\xbf\xa9\xd0\x26\xf4\x00\x00\x00\x00\x9a\x01\xee\xfd\xf4\x80\x26\xfd\x3a\x87\xe0\x19\x2f\xbf\x01\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\xff\x4a\xbd\x57\x7c\xa8\xb9\x8e\x01\x39\x7d\x52\xa1\x85\x2c\xec\x70\x00\x00\x00\x00\x00\x00\x00\x16\x0a\xbf\x5a\x9a\xef\x85\xd0\xac\x61\xb0\x50\x60\x24\xd8\x5a\x5a\xc0\x00\x00\x00\x00\x00\x92\x02\x34\x74\xf2\x76\xbc\xf2\x96\xc5\x70\x69\xd9\xa8\x24\x00\x00\x00\x00\x0d\x73\xcf\x70\xcc\x5f\xe3\x2d\xfd\x3b\xad\x19\x00\x00" },
  { 520, 2, 4, "\x01\x01\x81\x0c\x81\x1b\x81\x0c" },
  { 523, 1, 5, "\x07\x05\x57\x48\x6a\x00\x00\x00\x92\x5f\xb0\xb8\x03\x26\x1d\x06\x81\x63\x21\x30\x00\x00\x00\x00\x00\x00\x00\x11\x27\x5d\x52\xf5\x36\x9f\x7f\x6a\xa5\x64\x92\x40\x00\x00\x00\x00\x00\x8f\x2d\xa2\xe9\x99\x86\x6b\xc2\x49\x7e\xb0\x3b\x80\x00\x00\x00\x0d\xc9\x0d\x23\x10\x9c\x12\x5e\x46\xfc\x65\xb0\x80\x00" },
  { 527, 2, 18, "\x01\x01\x00\x01\x02\x01\x05\x01\x08\x81\x04\x81\x07\x81\x01\x81\x0a\x81\x20\x81\x05\x01\x14\x01\x0c\x01\x0f\x01\x2d\x81\x18\x81\x1f\x81\x0c" },
  { 532, 2, 4, "\x01\x01\x01\xd2\x01\x4f\x81\xd2" },
  { 535, 2, 14, "\x81\x01\x00\x01\x03\x01\x06\x81\x10\x81\x01\x01\x03\x01\x22\x81\x25\x01\x0a\x81\x0e\x01\x07\x01\x14\x81\x10" },
  { 536, 2, 14, "\x81\x01\x81\x0c\x01\x22\x81\x42\x01\x25\x81\x4c\x01\x03\x81\x7e\x81\x03\x81\x4c\x81\x25\x81\x42\x81\x22\x81\x0c" },
  { 547, 1, 3, "\x06\x03\xf8\xdc\xa6\x80\x00\x8f\x1a\xe8\x59\x80\x85\x6a\x81\x97\x88\xc2\x70\x40\x00\x00\x00\x0e\x04\x02\x1e\x0d\x71\x02\x19\x93\x7e\xb8\x6a\x05\x80\x00" },
  { 548, 2, 8, "\x01\x01\x81\x15\x01\x67\x81\xec\x02\x01\x2e\x81\xec\x01\x67\x81\x15" },
  { 555, 1, 4, "\x88\x01\x20\x01\xc5\x50\x40\x00\x00\x15\x0d\x31\x86\x32\xeb\x23\x69\xf8\x3a\xd8\x94\x36\x49\xb9\xf2\x00\x00\x00\x00\x00\x00\x12\x52\x8c\x7d\x34\xfb\x2b\x21\x93\x81\xa1\x9e\x17\xd5\xd8\xc0\x00\x00\x00\x0e\x06\xd8\xa7\x5c\x91\x90\xc9\xda\xe3\xb1\x2d\x84\x00\x00" },
  { 559, 2, 16, "\x81\x01\x01\x01\x00\x81\x02\x81\x01\x01\x0e\x81\x33\x01\x62\x81\x7b\x01\x53\x01\x12\x81\x8b\x01\xc4\x81\xa1\x01\x4e\x81\x14" },
  { 568, 2, 4, "\x01\x01\x81\x12\x01\x21\x81\x12" },
  { 571, 1, 5, "\x08\x03\x71\xa6\xc5\xb8\x00\x00\x00\x95\x0b\x2a\x9a\x0b\xe8\xa5\xd7\xac\x2a\x03\xf4\xfa\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x13\xc5\x39\x71\x48\x4d\x57\x1f\xe8\x63\xdb\xc5\xd4\x69\x60\x00\x00\x00\x00\x00\x11\x02\x67\xc9\x5f\xa7\x3b\x28\xb2\xc2\xf8\x27\x7a\x13\xc0\x00\x00\x00\x0e\x13\xbe\xfe\x54\xe1\x9f\x93\xff\x30\xec\x2e\xea\x80\x00" },
  { 580, 2, 8, "\x01\x01\x81\x11\x01\x07\x01\x0c\x81\x2a\x01\x0c\x01\x07\x81\x11" },
  { 583, 2, 8, "\x81\x01\x81\x04\x81\x03\x01\x05\x01\x0c\x01\x0b\x81\x0c\x81\x10" },
  { 584, 2, 16, "\x01\x01\x81\x16\x01\x63\x81\xbe\x01\xb1\x81\x58\x81\x22\x01\xe4\x82\x01\x76\x01\xe4\x81\x22\x81\x58\x01\xb1\x81\xbe\x01\x63\x81\x16" },
  { 595, 1, 4, "\x87\x10\x00\xd5\xd1\xc0\x00\x00\x13\x15\xa9\x31\xfd\xb2\xb2\x07\x03\xac\xbc\x57\xe7\x36\x00\x00\x00\x00\x00\x00\x11\x19\xb8\x5b\x5a\x51\xa5\x46\x50\x9f\xb0\xc8\x92\xb3\x40\x00\x00\x00\x0e\x5e\x1a\x00\xcd\x92\xc9\x14\x20\xef\x79\x77\x39\x00\x00" },
  { 596, 2, 14, "\x81\x01\x82\x01\x21\x02\x0a\xc1\x82\x22\x48\x02\x21\x78\x82\x06\xb8\x02\x09\xb2\x82\x41\xce\x82\x09\xb2\x82\x06\xb8\x82\x21\x78\x82\x22\x48\x82\x0a\xc1\x82\x01\x21" },
  { 607, 2, 13, "\x81\x01\x01\x02\x81\x03\x01\x01\x01\x07\x01\x09\x81\x15\x81\x15\x01\x03\x01\x22\x01\x10\x81\x0f\x81\x11" },
  { 616, 2, 8, "\x01\x01\x01\x12\x81\x03\x01\x12\x01\x14\x81\x12\x81\x03\x81\x12" },
  { 619, 1, 5, "\x08\xa3\xdb\xc6\xfe\x78\x00\x00\x00\x16\x4c\x28\x45\x16\x97\x31\x98\xaa\xab\xa1\xf4\x4d\xe8\x1e\x00\x00\x00\x00\x00\x00\x00\x00\x14\x39\x25\x0e\xb8\x17\xd6\x69\xcd\xfa\x81\xa4\x6f\xa4\x5d\x20\x00\x00\x00\x00\x00\x91\xff\xb8\x1a\x13\x8d\x4e\xcf\x50\x48\xca\xca\x37\x68\x40\x00\x00\x00\x0f\x01\xb2\xad\xfc\xc0\x42\x61\x36\x88\xb5\xa6\xb9\x7b\x80\x00" },
  { 627, 1, 4, "\x88\x01\x7f\xe4\xbd\x37\x00\x00\x00\x14\x5c\x31\x4d\x55\x7f\x41\x6c\xd7\x92\xcb\x6e\xb8\x1d\x28\x00\x00\x00\x00\x00\x00\x13\x9f\xcf\x15\xdc\xd9\x41\xe1\x34\x56\x7e\x97\xec\xac\x9d\x60\x00\x00\x00\x00\x0f\x02\xcf\x26\xf0\xe0\x6e\x68\x0b\x83\x95\x2b\xf1\x25\x80\x00" },
  { 628, 2, 6, "\x81\x01\x82\x01\x62\x81\xde\x82\x01\x08\x01\xde\x82\x01\x62" },
  { 631, 2, 13, "\x81\x01\x81\x04\x81\x0c\x81\x15\x81\x25\x81\x2e\x81\x36\x81\x48\x81\x47\x81\x4d\x81\x45\x81\x21\x81\x11" },
  { 632, 2, 8, "\x01\x01\x81\x12\x81\x0d\x81\x6e\x81\x24\x81\x6e\x81\x0d\x81\x12" },
  { 643, 1, 3, "\x07\x02\x66\x3e\xc6\x12\x80\x00\x91\x12\x83\xe0\xc3\x2b\xa0\x0f\x43\x4a\x73\x25\xd9\xaa\x40\x00\x00\x00\x0f\x07\x9d\xbf\x54\xde\xdd\x98\x01\x84\xfe\x73\x54\x25\x80\x00" },
  { 644, 2, 16, "\x01\x01\x81\x12\x81\x21\x01\x1a\x01\xa5\x81\x6c\x82\x01\x26\x01\x28\x02\x01\xca\x01\x28\x82\x01\x26\x81\x6c\x01\xa5\x01\x1a\x81\x21\x81\x12" },
  { 655, 2, 12, "\x81\x01\x01\x01\x81\x06\x81\x04\x81\x0f\x81\x13\x81\x20\x81\x2b\x81\x37\x81\x2f\x81\x29\x81\x12" },
  { 664, 2, 10, "\x81\x01\x81\x16\x81\x1d\x81\x0c\x01\x13\x81\x1a\x81\x13\x81\x0c\x01\x1d\x81\x16" },
  { 667, 1, 4, "\x87\x02\x52\x15\x1d\x10\x00\x00\x92\x01\xb0\x40\x53\x39\x2c\x50\xb2\x19\x5e\xdd\xe9\x40\x00\x00\x00\x00\x00\x90\x02\xcf\xe2\x1a\x41\xc2\xf5\xf1\xd0\x20\x97\x62\x00\x00\x00\x00\x0f\x21\x3a\x22\xe4\xf5\x7c\xbc\xd8\x62\x4f\x9b\x83\x01\x00\x00" },
  { 679, 2, 18, "\x01\x01\x00\x01\x07\x00\x01\x0c\x81\x09\x01\x0c\x01\x06\x01\x0d\x81\x03\x81\x08\x81\x09\x01\x21\x81\x1b\x01\x18\x81\x3c\x01\x3a\x81\x18" },
  { 680, 2, 12, "\x01\x01\x01\x12\x81\x45\x01\x76\x81\x35\x01\x44\x81\x0e\x81\x44\x81\x35\x81\x76\x81\x45\x81\x12" },
  { 683, 1, 5, "\x0a\x06\x49\x62\xa2\xf3\x71\xf0\x00\x00\x00\x9b\x0c\x37\x2a\x8a\xbf\x9b\xb9\x97\x67\x52\x80\x01\xa6\x58\xdc\xf7\xea\x7c\x6c\xf0\x00\x00\x00\x00\x00\x00\x00\x19\x2a\xb5\xf8\x29\x03\xf2\x7b\x46\x0f\xa6\x79\x0f\xe6\xd6\xa7\x9e\x20\x33\xec\x00\x00\x00\x00\x00\x00\x94\x3d\x1a\xef\xa4\x54\x4d\xf6\x54\xdf\x91\x6c\x72\x2a\x18\x68\x4c\x80\x00\x00\x00\x0f\x57\x6b\xed\x78\x3f\x9e\xd7\x87\x6a\x98\x9f\xc1\xd0\x00\x00" },
  { 691, 1, 5, "\x09\x07\xb6\xb4\x25\xdd\xf0\x00\x00\x00\x97\x65\xbc\xcc\x30\x3c\x4e\x6a\x77\x14\x8d\x11\x03\xe7\xd1\x9a\xd0\x00\x00\x00\x00\x00\x00\x00\x15\x6f\x05\x30\x81\xc8\x5a\x55\x94\xe0\xec\x9b\xdd\xb7\x5f\x89\xc0\x00\x00\x00\x00\x00\x12\x4c\xf4\x07\x0b\xf7\x56\x3e\x7a\x39\x74\x3c\xc1\xb3\x6d\x00\x00\x00\x00\x0f\x8d\x33\x57\xc6\xca\xb4\x25\x4b\x68\x96\xe0\xae\xbd\x00\x00" },
  { 692, 2, 14, "\x81\x01\x82\x01\xf1\x82\x0e\x1f\x82\x2b\xa8\x02\x07\x38\x82\x16\xd8\x82\x12\xae\x02\x67\xd2\x02\x12\xae\x82\x16\xd8\x82\x07\x38\x82\x2b\xa8\x02\x0e\x1f\x82\x01\xf1" },
  { 703, 2, 14, "\x81\x01\x81\x03\x81\x01\x81\x01\x81\x09\x01\x04\x01\x02\x01\x0f\x01\x07\x81\x06\x81\x0b\x81\x29\x81\x0f\x81\x16" },
  { 707, 1, 6, "\x0b\x02\xf4\xd0\x99\xfc\x9d\x59\x00\x00\x00\x00\x1e\x01\x00\x0f\x73\x7a\x90\x86\x0c\x0d\x86\x76\x83\x20\x27\x30\x35\xf5\xe4\x42\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x04\x98\x84\xc8\x9b\x09\x3b\x79\x13\xac\x25\x14\x41\x26\xa3\xf7\x9b\x20\x18\x22\x70\x00\x00\x00\x00\x00\x00\x00\x1a\x01\xcf\x13\x30\x73\xcc\x98\x20\x6b\x24\xe2\x2c\xd7\x0f\xf9\xfa\x9a\x91\x8b\xc1\x40\x00\x00\x00\x00\x00\x95\x01\x9b\x4f\x4c\xa6\x52\x22\xa0\x62\x7f\xd7\x9b\xcd\x10\x99\xcd\x44\x00\x00\x00\x00\x10\x01\x6d\x54\xcb\x77\xb3\xa6\x36\x61\x64\x5d\x10\x16\xf7\x00\x00" },
  { 708, 1, 4, "\x0b\x01\x51\x72\xae\xa8\xa3\xcb\xcd\x55\x51\x00\x1c\x22\x38\x90\x64\xab\x88\xd7\x5b\xd7\xb1\x04\x5a\x47\xb1\x0e\x64\xfd\x66\xdb\xc0\x3b\x6c\xea\x9c\xf4\xd0\x00\x00\x97\x1d\xcd\x94\xcd\xbd\xdb\xb9\x5b\x3c\xa1\xa9\xe9\xa3\xc3\xa8\x07\xd2\x5f\xfa\x89\x06\xa0\x00\x90\x01\x83\x8e\x3e\x53\x44\x54\xb4\x97\x0f\xfa\x50\xe1\xd5\xeb\x00" },
  { 712, 2, 8, "\x01\x01\x81\x15\x81\x33\x81\x1e\x01\x02\x81\x1e\x81\x33\x81\x15" },
  { 715, 1, 4, "\x07\x53\xf0\xe1\x43\xf0\x00\x00\x14\x10\x94\x97\x5a\x28\x66\x90\xb5\x7d\x54\xcb\xeb\xad\x24\xc0\x00\x00\x00\x00\x00\x13\x02\xb2\x8f\xb5\x0f\xf7\xe9\xa8\xe9\x7b\xc3\x97\x34\x3b\x5a\x00\x00\x00\x00\x10\x02\x49\x46\x6d\x55\xc5\x51\xa6\xf7\xfb\x23\xd2\xd5\x79\x00\x00" },
  { 723, 1, 4, "\x08\x30\xeb\x30\x80\xdf\x80\x00\x00\x96\x2e\x9b\x70\x4d\x52\x2d\xa7\x04\x26\xe0\xb5\x64\x3c\xc7\x5a\x04\x60\x00\x00\x00\x00\x00\x15\x05\xa0\x43\x71\xc5\xcb\x39\x55\xd0\x3b\x32\xf7\x0f\x2f\x63\xe4\xbc\xc0\x00\x00\x00\x10\x03\xa7\x2c\x01\x7e\x69\x52\x83\xe5\xc8\x84\x4f\x4a\x77\x80\x00" },
  { 724, 2, 10, "\x81\x01\x82\x02\x3d\x01\x56\x82\x04\xa7\x02\x0b\xab\x82\x01\x68\x82\x0b\xab\x82\x04\xa7\x81\x56\x82\x02\x3d" },
  { 727, 2, 13, "\x81\x01\x01\x04\x81\x08\x01\x05\x81\x06\x00\x81\x04\x81\x08\x81\x1e\x01\x0f\x81\x29\x01\x17\x81\x19" },
  { 728, 2, 12, "\x01\x01\x01\x1c\x01\x60\x01\x54\x81\x18\x01\x1c\x81\x2e\x81\x1c\x81\x18\x81\x54\x01\x60\x81\x1c" },
  { 739, 1, 5, "\x09\x02\x3e\x53\xf5\x57\x70\x00\x00\x00\x98\x01\x9c\x08\xec\x08\x01\x4c\xd7\x96\xc5\x6d\x1a\x82\x1e\xcf\xee\x30\x00\x00\x00\x00\x00\x00\x00\x16\x16\x8b\x94\xce\x39\x31\x92\x22\x10\x79\xa8\xeb\x78\xaf\x8c\x64\x80\x00\x00\x00\x00\x00\x93\x17\x5f\x1d\x83\xfe\x0b\xae\x68\xa2\xc8\x77\xd9\x61\x37\x37\x80\x00\x00\x00\x10\x09\x41\x36\x07\xd0\x11\xdb\x4f\xb1\x31\x10\x90\xf2\xa6\x00\x00" },
  { 740, 2, 16, "\x01\x01\x81\x12\x81\x8f\x82\x02\x6e\x82\x07\x67\x82\x10\x70\x82\x1c\x06\x82\x26\x40\x82\x2a\x6e\x82\x26\x40\x82\x1c\x06\x82\x10\x70\x82\x07\x67\x82\x02\x6e\x81\x8f\x81\x12" },
  { 751, 2, 15, "\x81\x01\x01\x05\x81\x09\x01\x06\x81\x07\x01\x0c\x81\x11\x01\x1d\x81\x02\x01\x04\x81\x15\x01\x09\x81\x35\x81\x0c\x81\x19" },
  { 760, 2, 4, "\x01\x01\x81\x18\x81\x36\x81\x18" },
  { 763, 1, 4, "\x07\x25\xe1\x79\x19\xc0\x00\x00\x13\xa7\x43\xf1\x15\xa8\x8b\x9c\x2a\x98\x06\xa3\xeb\x12\x00\x00\x00\x00\x00\x00\x12\x87\x0c\xfd\xef\x4f\xed\x04\xb5\x80\xff\x16\x8a\xed\x8a\xc0\x00\x00\x00\x10\x24\xa1\x02\xcd\x9c\x9c\xe7\xdb\xf1\xa5\xbd\xa7\xb3\x44\x00\x00" },
  { 771, 1, 6, "\x0a\xde\x6d\x16\x2b\x52\x46\x40\x00\x00\x00\x9d\x35\x06\x6e\x09\xe2\xb3\xe5\x64\x61\x4a\x14\x46\xdf\x04\x88\xbb\x0f\x04\x83\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x04\x67\xa4\xf0\x5b\x2a\x63\xf9\xda\xe9\x19\xda\x45\x4d\x3a\xfc\x1d\xb0\xad\x53\x70\x00\x00\x00\x00\x00\x00\x00\x19\x01\x35\xb5\xe7\x3f\x97\x01\x49\x57\xee\x83\xa1\x36\x50\x0b\x48\x40\x15\xec\x80\x00\x00\x00\x00\x00\x15\xde\xc3\xfa\xcb\x54\xd7\xe7\x4b\x23\xcb\xec\x2c\xd7\xf9\x04\xbc\x6f\xc0\x00\x00\x00\x10\x39\xa9\x49\x31\xec\x7b\xaa\x20\x0a\x77\xc9\x37\x11\x09\x00\x00" },
  { 772, 2, 4, "\x01\x01\x81\x1a\x81\x16\x81\x1a" },
  { 776, 2, 20, "\x01\x01\x81\x1a\x81\x17\x81\xbe\x81\x24\x81\xbe\x01\x67\x81\xe6\x81\x51\x81\x84\x02\x02\x48\x81\x84\x81\x51\x81\xe6\x01\x67\x81\xbe\x81\x24\x81\xbe\x81\x17\x81\x1a" },
  { 787, 1, 5, "\x08\x44\xca\xa5\x93\xa8\x00\x00\x00\x16\x30\x07\x41\x33\xba\x6e\x03\x53\xce\xa8\x96\xe3\x65\xb2\x70\x00\x00\x00\x00\x00\x00\x00\x15\x0b\x26\x6c\x34\x92\x14\xee\x3d\x91\xfd\x3b\x2d\x16\xe2\xc0\x40\x00\x00\x00\x00\x00\x13\x03\x18\x1d\xc2\xdf\x75\x9a\xcc\xf7\x64\x82\x24\xc3\x82\x2c\x00\x00\x00\x00\x10\x8d\xe4\x8b\xc8\x00\x7d\x29\xca\xa7\xfa\x7b\x1c\xce\xeb\x00\x00" },
  { 788, 2, 10, "\x81\x01\x82\x03\x0b\x82\x05\x16\x82\x61\x7d\x02\x29\x9f\x02\x3f\x00\x82\x29\x9f\x82\x61\x7d\x02\x05\x16\x82\x03\x0b" },
  { 795, 1, 4, "\x09\x06\x50\xa8\xe6\xe3\x7e\x30\x00\x00\x19\x0f\x73\x88\x52\x39\x99\x58\x1d\x40\xd6\x31\x03\x18\x7d\xe4\x74\x16\x40\xbd\xc0\x00\x00\x00\x00\x00\x16\x05\x3e\xce\x32\x31\x66\x6b\x91\xc4\xcd\x43\x57\x85\x70\xee\x36\xb6\x73\x00\x00\x00\x00\x10\xdd\xd2\xcb\xe2\x66\xd6\x5d\x16\x86\xe5\xed\x6a\x12\xcd\x00\x00" },
  { 799, 2, 16, "\x01\x01\x01\x03\x01\x09\x01\x09\x81\x06\x81\x15\x81\x27\x81\x06\x01\x34\x01\x18\x01\x12\x81\x12\x81\x4b\x01\x1e\x01\x27\x81\x1e" },
  { 808, 2, 6, "\x81\x01\x81\x1d\x01\x04\x81\x39\x81\x04\x81\x1d" },
  { 820, 2, 8, "\x01\x01\x02\x03\x87\x02\x06\x98\x02\x01\x3b\x02\x07\x0e\x82\x01\x3b\x02\x06\x98\x82\x03\x87" },
  { 823, 2, 9, "\x81\x01\x81\x01\x00\x81\x0c\x81\x1e\x81\x21\x81\x1e\x81\x24\x81\x1d" },
  { 824, 2, 20, "\x01\x01\x81\x1e\x81\x0d\x01\x76\x01\xcc\x82\x03\x1a\x01\x8d\x02\x04\xd6\x82\x02\xf1\x82\x03\xb4\x02\x06\x78\x82\x03\xb4\x82\x02\xf1\x02\x04\xd6\x01\x8d\x82\x03\x1a\x01\xcc\x01\x76\x81\x0d\x81\x1e" },
  { 835, 1, 6, "\x09\x09\x33\xd7\x7e\xc7\x00\x00\x00\x00\x99\x01\x1f\x3a\x82\x18\xac\xa9\xe0\xc1\x4b\xbc\xaa\xeb\x41\xde\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x45\x95\xf8\x19\x7a\xe9\x67\x01\x5a\xab\x50\xc3\x45\x18\x44\x30\x00\x00\x00\x00\x00\x00\x00\x96\x05\x85\x62\x21\xf9\xc4\xdd\x4b\xf2\xa4\x7f\x5e\x13\x5d\xec\x76\xc0\x00\x00\x00\x00\x00\x14\x23\xcf\x51\x95\xc8\x76\x06\xd0\xf4\xb3\x49\xe0\x40\xda\x8e\xb1\x00\x00\x00\x00\x11\x07\xd4\x1a\x09\x7c\x5c\x23\xe3\x44\xf8\xed\x9f\x4d\x8d\x3f\x00\x00" },
  { 836, 2, 20, "\x01\x01\x81\x22\x01\x5d\x81\x7c\x02\x01\x24\x82\x01\xa4\x81\x45\x82\x02\xc6\x82\x05\x09\x82\x02\xf0\x82\x08\x78\x82\x02\xf0\x82\x05\x09\x82\x02\xc6\x81\x45\x82\x01\xa4\x02\x01\x24\x81\x7c\x01\x5d\x81\x22" },
  { 843, 1, 6, "\x0a\x72\xa5\x66\xe9\xa2\x74\x80\x00\x00\x00\x1d\x02\xb5\xe4\x3d\x89\x28\xb6\xae\x17\x3e\x69\x4e\xb4\xed\x71\x6f\x36\x4b\x04\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1b\x21\xba\xa0\x42\x6c\xa2\xed\xf3\x4b\x59\x48\xd2\x27\x98\xb1\x0e\x71\xf7\x57\x50\x00\x00\x00\x00\x00\x00\x00\x19\x06\x02\x04\xec\xb2\x43\xce\x2e\xed\x15\x15\x46\x15\xba\x83\x10\x60\x69\xc7\xc0\x00\x00\x00\x00\x00\x16\xb0\x02\xbe\xa0\xae\x8e\x47\x9b\xd8\x14\x75\xf9\xb2\x82\x78\x18\xd8\x70\x80\x00\x00\x00\x11\x0c\x14\xac\xd6\x69\x20\x23\x50\xd7\xbc\x13\x40\xf8\xa4\xd1\x80\x00" },
  { 856, 2, 6, "\x81\x01\x81\x20\x01\x10\x81\x4e\x81\x10\x81\x20" },
  { 868, 2, 8, "\x01\x01\x81\x22\x01\x12\x01\x10\x01\x07\x01\x10\x01\x12\x81\x22" },
  { 872, 2, 10, "\x81\x01\x81\x26\x81\x94\x81\x94\x01\x31\x81\x4c\x81\x31\x81\x94\x01\x94\x81\x26" },
  { 883, 1, 3, "\x07\x13\x9a\x5b\x6b\x83\x80\x00\x93\x06\xd0\x6a\xa1\x64\xda\x28\xa4\x03\xb0\x6a\x53\x01\x32\x59\x40\x00\x00\x00\x11\x66\x92\xcd\x3b\x80\x67\xce\xd3\x17\x35\x67\x2a\xed\x03\x42\x80\x00" },
  { 884, 2, 16, "\x01\x01\x02\x04\xa6\x82\x32\x59\x02\x86\x42\x82\x03\x0f\x03\x05\x0a\xd8\x03\x01\x68\x9e\x03\x02\x92\xfc\x83\x01\xd0\x5e\x83\x02\x92\xfc\x03\x01\x68\x9e\x83\x05\x0a\xd8\x82\x03\x0f\x82\x86\x42\x82\x32\x59\x82\x04\xa6" },
  { 895, 2, 16, "\x81\x01\x01\x04\x81\x01\x81\x09\x81\x07\x01\x1a\x81\x11\x01\x03\x81\x2a\x01\x1d\x81\x08\x01\x18\x81\x5f\x01\x1f\x01\x11\x81\x24" },
  { 904, 2, 8, "\x01\x01\x81\x27\x01\x69\x81\x8a\x01\x6e\x81\x8a\x01\x69\x81\x27" },
  { 907, 1, 3, "\x07\x12\xd7\x63\x56\x98\x00\x00\x13\x01\xc1\xc8\x5b\x4b\x67\x8e\xc7\x9a\xf0\xf1\x68\x3f\x94\xb0\x00\x00\x00\x00\x12\x01\x69\xad\x24\x8e\xd2\x87\x32\x82\x48\x61\x00\x92\x3f\x5f\x00\x00\x00" },
  { 916, 2, 10, "\x81\x01\x82\x05\x61\x02\x13\xe2\x82\x28\x2f\x02\x22\x07\x82\x2d\x90\x82\x22\x07\x82\x28\x2f\x82\x13\xe2\x82\x05\x61" },
  { 919, 2, 19, "\x81\x01\x81\x05\x81\x0a\x81\x05\x81\x09\x81\x2a\x81\x33\x81\x06\x01\x17\x01\x04\x01\x1d\x01\x70\x01\x3f\x81\x93\x81\xb7\x01\x0f\x01\x4d\x81\x11\x81\x25" },
  { 920, 2, 20, "\x01\x01\x01\x24\x81\x32\x01\xcc\x81\x3d\x82\x02\x48\x01\x90\x01\x98\x82\x02\x23\x02\x03\x2c\x02\x02\xc6\x82\x03\x2c\x82\x02\x23\x81\x98\x01\x90\x02\x02\x48\x81\x3d\x81\xcc\x81\x32\x81\x24" },
  { 932, 2, 12, "\x01\x01\x81\x27\x01\x12\x01\x65\x01\xee\x82\x04\xef\x02\x07\x5e\x82\x04\xef\x01\xee\x01\x65\x01\x12\x81\x27" },
  { 943, 2, 16, "\x01\x01\x01\x05\x01\x08\x01\x01\x00\x81\x0b\x81\x26\x01\x02\x01\x3a\x01\x1c\x81\x3b\x81\x2e\x01\x42\x01\x20\x81\x37\x81\x26" },
  { 947, 1, 5, "\x0b\xe1\x46\xc7\xea\xb9\x74\x63\x3e\x00\x00\x00\x1f\x4e\x53\xbd\x6a\x2b\x32\xf4\x3a\x7b\x4c\x9d\xd0\xd1\xfb\x22\xb7\x12\x86\x72\x29\x0e\x78\x2b\x90\x00\x00\x00\x00\x00\x00\x00\x1e\x01\x60\x20\xbe\x1c\x78\x90\x05\xa6\x90\x47\xe9\x12\x99\xb8\xc6\x2c\x40\x07\x2c\xf9\x3a\x45\x0d\x40\x00\x00\x00\x00\x00\x98\x03\xe9\x83\x2d\x7c\x45\xa5\x59\x24\xa6\x36\x77\xfe\x01\x5e\x3a\x7e\x33\xb9\x4a\x80\x00\x00\x00\x12\x0b\x20\x79\x4d\x6c\x75\x64\x9a\x42\x58\x12\xbd\xc1\xc5\x91\x33\x80\x00" },
  { 952, 2, 8, "\x01\x01\x81\x2a\x01\x4b\x81\x06\x81\x34\x81\x06\x01\x4b\x81\x2a" },
  { 955, 1, 4, "\x09\x29\x32\xef\x5b\xaf\xd8\xd0\x00\x00\x18\x15\x37\x39\x40\x34\x31\x9a\x0d\xe1\x29\x8f\xae\x83\xa3\x61\xeb\xc8\xa6\x00\x00\x00\x00\x00\x00\x16\x01\x0f\x46\x8c\x8f\xb2\x0f\x4e\xec\xcf\xe3\x23\xc6\x46\x5e\x91\xe1\x78\x80\x00\x00\x00\x12\x10\xb9\x62\xc4\x01\xb5\x1b\xf5\x44\xe9\x70\x70\xf8\x05\xc5\xec\x00\x00" },
  { 964, 2, 12, "\x01\x01\x81\x2b\x01\x4a\x01\x41\x81\xe2\x81\x43\x02\x01\x76\x81\x43\x81\xe2\x01\x41\x01\x4a\x81\x2b" },
  { 967, 2, 11, "\x81\x01\x81\x02\x01\x01\x81\x0d\x81\x06\x01\x12\x81\x51\x01\x63\x81\x7a\x01\x44\x81\x2b" },
  { 991, 2, 17, "\x81\x01\x81\x01\x81\x04\x81\x12\x81\x0b\x01\x0e\x81\x15\x81\x3e\x81\x0e\x01\x32\x81\x36\x81\x79\x01\x07\x01\x24\x81\x40\x81\x17\x81\x2b" },
  { 1003, 1, 4, "\x08\x03\x6c\xf4\x82\x20\x80\x00\x00\x16\x03\x7d\x0e\x50\x12\xcf\x80\x1a\x9a\x5d\x14\xc9\xeb\x12\x4e\x9e\x20\x00\x00\x00\x00\x00\x94\x23\xd1\xd3\xee\xaa\x4c\x84\x24\x64\x85\xb4\x9e\x5b\xd0\x96\xb3\x40\x00\x00\x00\x12\xba\x30\xe9\x0a\xd1\x9d\x08\x67\x18\xdc\x71\xc3\x0c\xee\x97\xf5\x80\x00" },
  { 1012, 2, 4, "\x01\x01\x02\x08\x16\x02\x01\xb7\x82\x08\x16" },
  { 1015, 2, 16, "\x01\x01\x01\x04\x01\x0c\x01\x0b\x01\x0c\x81\x20\x81\x45\x81\x61\x81\x32\x01\x41\x01\x7e\x01\xac\x01\x42\x81\x10\x81\x51\x81\x2c" },
  { 1016, 2, 16, "\x01\x01\x81\x2e\x01\x01\x01\xda\x02\x01\x91\x81\xb8\x82\x0a\xe6\x82\x18\x44\x82\x1d\xf6\x82\x18\x44\x82\x0a\xe6\x81\xb8\x02\x01\x91\x01\xda\x01\x01\x81\x2e" },
  { 1027, 1, 4, "\x09\x03\x82\x1e\xdb\x71\x7e\x90\x00\x00\x18\x06\xb6\x6d\x15\xd2\xb6\x98\xde\x1d\x91\xd4\xf1\xd4\x7c\x9c\x81\x96\x53\x00\x00\x00\x00\x00\x00\x95\x1c\x6d\x8a\x09\x94\xb4\x77\x54\xf6\xed\x65\x93\x5b\x48\xd2\x64\x3a\x80\x00\x00\x00\x13\x02\x5f\xf4\xc8\x7e\x32\xe7\x42\xf8\xdd\xca\xda\x5d\x11\x79\x71\xe4\x00\x00" },
  { 1028, 2, 16, "\x01\x01\x81\x33\x01\xcb\x82\x03\x08\x02\x09\x2f\x82\x13\xab\x02\x1d\xa6\x82\x22\x5b\x02\x23\x00\x82\x22\x5b\x02\x1d\xa6\x82\x13\xab\x02\x09\x2f\x82\x03\x08\x01\xcb\x81\x33" },
  { 1048, 2, 6, "\x81\x01\x81\x30\x01\x30\x01\x2e\x81\x30\x81\x30" },
  { 1051, 1, 5, "\x0a\x2b\x9f\xce\x19\x37\x44\x5c\x00\x00\x00\x1c\x05\xc9\x8f\xac\x58\x0b\x6e\x78\x4a\x08\xe6\x20\x8a\x6f\x45\xb2\x5d\x43\x99\x40\xf0\x00\x00\x00\x00\x00\x00\x00\x1a\x34\x51\x8d\x31\xe1\xfd\xe8\xf2\x43\x1e\x70\xe1\xa7\x8e\xb7\x86\x1f\xa0\x3b\x00\x40\x00\x00\x00\x00\x00\x16\xc5\xcf\xd7\x55\x1b\x27\x48\x1e\x21\x2e\x27\xfa\x06\x62\x06\x5e\xec\x96\x00\x00\x00\x00\x13\x07\xa6\x02\xe1\xfc\x74\x69\x9c\x16\x2c\xea\xe1\x80\x02\x73\xf3\xf7\x00\x00" },
  { 1060, 2, 8, "\x01\x01\x81\x2f\x81\x99\x82\x01\x0c\x82\x01\x6a\x82\x01\x0c\x81\x99\x81\x2f" },
  { 1063, 2, 19, "\x81\x01\x00\x81\x09\x81\x0a\x81\x08\x81\x2d\x81\x27\x01\x07\x81\x2a\x81\x24\x01\x3c\x01\x09\x81\x37\x01\x3f\x81\x0f\x81\x58\x01\x07\x01\x1b\x81\x33" },
  { 1087, 2, 9, "\x81\x01\x81\x08\x81\x1c\x81\x3d\x81\x64\x81\x7c\x81\x8b\x81\x64\x81\x33" },
  { 1096, 2, 12, "\x01\x01\x81\x39\x01\xae\x82\x01\x6b\x02\x02\xdc\x82\x04\x7d\x02\x05\x28\x82\x04\x7d\x02\x02\xdc\x82\x01\x6b\x01\xae\x81\x39" },
  { 1108, 2, 6, "\x81\x01\x82\x0b\xe5\x01\x9c\x82\x16\xb9\x81\x9c\x82\x0b\xe5" },
  { 1112, 2, 14, "\x81\x01\x81\x34\x01\xc2\x82\x01\x8e\x01\x45\x82\x04\x94\x01\x23\x82\x07\x72\x81\x23\x82\x04\x94\x81\x45\x82\x01\x8e\x81\xc2\x81\x34" },
  { 1123, 1, 5, "\x09\x42\x10\x6a\x81\xf8\x14\x00\x00\x00\x9a\x07\x65\x0b\x2c\x12\xf0\xf4\x3b\xd7\x0e\x4e\xe4\x43\x0b\xe3\x91\x03\x4d\xb0\x00\x00\x00\x00\x00\x00\x00\x19\x09\xb6\x95\xb1\xdb\xe1\x12\xac\x84\xde\x72\x65\x07\x73\x10\xd9\x67\xe0\xaa\x80\x00\x00\x00\x00\x00\x16\x3b\xbb\xf2\x51\xf8\x0c\x28\xd6\x42\x0e\x30\xab\x59\x52\xab\x56\x14\x8e\x80\x00\x00\x00\x13\xec\x5a\x0b\x61\xc5\x6b\xc3\x0b\xa6\x36\xff\xf7\xf3\x73\x94\x71\xfa\x00\x00" },
  { 1135, 2, 18, "\x81\x01\x81\x01\x01\x08\x01\x09\x81\x2b\x81\x83\x81\x90\x81\x01\x01\xe4\x02\x01\x85\x02\x01\x72\x01\xc7\x81\x40\x82\x01\x62\x82\x02\x00\x82\x01\xb7\x81\xeb\x81\x36" },
  { 1144, 2, 12, "\x01\x01\x81\x3c\x01\x30\x81\x18\x81\x18\x81\x54\x82\x01\x86\x81\x54\x81\x18\x81\x18\x01\x30\x81\x3c" },
  { 1147, 1, 6, "\x8a\x23\xfd\xfe\x12\x83\x7a\xc0\x00\x00\x00\x1c\x20\x87\x12\x13\x85\x41\x87\x2c\x83\xaa\xec\x7c\x47\x95\x1c\x8b\xf9\xfc\xf0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x01\x59\x1f\x8c\x94\x94\x1e\xab\xd3\x4a\xab\xe4\xde\x22\xd4\x81\x08\x2d\xe0\x90\x00\x00\x00\x00\x00\x00\x00\x19\x29\x03\x45\x97\x2c\xca\x5b\xb5\x67\x79\x58\x01\x47\xf1\xfc\x1f\xdb\x5c\x88\x80\x00\x00\x00\x00\x00\x97\x01\x36\x63\xce\x69\x2b\x86\x05\x25\x16\xe5\x11\x67\x3a\x84\x08\x79\x62\x81\x40\x00\x00\x00\x14\x02\xd3\xad\x3b\x7d\xfe\x65\x15\x02\x4b\x71\x39\x57\xe7\x73\xed\xa8\x9f\x00\x00" },
  { 1159, 2, 16, "\x81\x01\x01\x05\x81\x01\x81\x17\x01\x16\x01\x20\x81\x6a\x01\x22\x01\x72\x81\x89\x81\x5f\x01\xf5\x81\x6a\x81\xbf\x01\xbe\x81\x40" },
  { 1160, 2, 20, "\x01\x01\x81\x42\x02\x01\x31\x81\x9a\x82\x04\xfc\x02\x06\x46\x01\xcf\x82\x10\x3e\x02\x09\x7f\x02\x0a\xd4\x82\x1d\x08\x02\x0a\xd4\x02\x09\x7f\x82\x10\x3e\x01\xcf\x02\x06\x46\x82\x04\xfc\x81\x9a\x02\x01\x31\x81\x42" },
  { 1172, 2, 18, "\x81\x01\x82\x0f\x29\x03\x01\x49\xfb\x83\x09\x51\x06\x03\x13\x3e\x7d\x83\x05\xa5\x91\x83\x0b\x9e\x7d\x83\x0d\xca\xd6\x03\x06\x77\x32\x03\x25\xf0\x2c\x83\x06\x77\x32\x83\x0d\xca\xd6\x03\x0b\x9e\x7d\x83\x05\xa5\x91\x83\x13\x3e\x7d\x83\x09\x51\x06\x83\x01\x49\xfb\x82\x0f\x29" },
  { 1192, 2, 6, "\x81\x01\x81\x41\x81\x05\x01\x72\x01\x05\x81\x41" },
  { 1204, 2, 8, "\x01\x01\x02\x11\x3a\x02\x33\x7d\x02\xb2\xaa\x02\x91\x14\x82\xb2\xaa\x02\x33\x7d\x82\x11\x3a" },
  { 1207, 2, 18, "\x01\x01\x81\x09\x01\x2a\x81\x79\x01\xfa\x82\x01\xb5\x02\x02\xb8\x82\x04\x0d\x02\x05\x95\x82\x06\xf6\x02\x08\x04\x82\x08\x4f\x02\x07\xa1\x82\x05\xf3\x02\x03\xd9\x82\x02\x18\x01\xe0\x81\x46" },
  { 1208, 2, 12, "\x01\x01\x81\x3e\x82\x01\x31\x82\x05\x82\x82\x0e\x66\x82\x18\x4e\x82\x1c\x59\x82\x18\x4e\x82\x0e\x66\x82\x05\x82\x82\x01\x31\x81\x3e" },
  { 1220, 2, 16, "\x01\x01\x81\x3c\x82\x02\x1c\x82\x09\x24\x82\x17\x6d\x82\x2e\x18\x82\x49\x5c\x82\x5d\x98\x82\x68\x58\x82\x5d\x98\x82\x49\x5c\x82\x2e\x18\x82\x17\x6d\x82\x09\x24\x82\x02\x1c\x81\x3c" },
  { 1227, 1, 4, "\x0b\x01\x1f\xeb\x20\xd0\xcf\xb8\xc1\x40\x00\x00\x1d\x03\x4f\x81\xe6\xc4\x1a\xc1\xca\xa7\xb5\x27\xa3\xe7\xf5\x38\x84\xbc\xef\x7c\xf8\x51\xdf\x00\x00\x00\x00\x00\x00\x00\x1b\x0c\xd7\x66\x27\xad\xab\x02\x5c\x5a\x6f\x49\x1d\xea\xe3\x5e\x4e\x62\xfe\x50\x24\x40\x91\x77\xc0\x00\x00\x00\x14\x6c\x89\x91\x9f\x5a\x1a\x88\x46\x3b\xa7\x48\x13\x11\x61\x12\x8c\x8e\xa8\x00\x00" },
  { 1240, 2, 8, "\x01\x01\x01\x46\x81\x49\x81\x46\x81\x34\x01\x46\x81\x49\x81\x46" },
  { 1243, 1, 4, "\x09\x01\xb1\xc9\xd7\x5b\x05\x00\x00\x00\x98\x02\x3a\xbc\xfa\xfe\xad\x2b\x11\x68\x2b\x04\xce\x9a\xd0\x9f\xce\xf4\x1b\x00\x00\x00\x00\x00\x00\x16\x46\xe2\xd0\x68\xb7\x26\xf4\xc0\x37\x95\xa1\x25\x79\x2b\xac\x88\xd0\xb8\x40\x00\x00\x00\x14\xdd\xe8\x7c\xce\x1e\x72\x80\x59\xa9\x38\x4b\x81\xad\x8d\xe5\x09\x53\x93\x00\x00" },
  { 1252, 2, 8, "\x01\x01\x81\x4c\x01\xfd\x82\x02\x04\x02\x02\x64\x82\x02\x04\x01\xfd\x81\x4c" },
  { 1255, 2, 12, "\x81\x01\x81\x01\x81\x07\x81\x02\x01\x1a\x81\x09\x81\x51\x81\x12\x01\x0a\x81\xa1\x81\xda\x81\x46" },
  { 1268, 2, 10, "\x81\x01\x82\x15\xe9\x83\x01\x5e\xd9\x83\x09\x23\x8a\x03\x0a\x71\x2f\x83\x09\xa6\x43\x83\x0a\x71\x2f\x83\x09\x23\x8a\x03\x01\x5e\xd9\x82\x15\xe9" },
  { 1288, 2, 8, "\x01\x01\x81\x4e\x01\x21\x81\x06\x01\xa4\x81\x06\x01\x21\x81\x4e" },
  { 1303, 2, 11, "\x81\x01\x81\x08\x81\x1e\x81\x39\x81\x43\x81\x3b\x81\x49\x81\x44\x81\x21\x81\x39\x81\x4f" },
  { 1327, 2, 15, "\x81\x01\x81\x06\x81\x10\x81\x18\x81\x26\x01\x01\x81\x18\x01\x03\x81\x34\x81\x14\x81\x0d\x01\x64\x01\x12\x81\x15\x81\x53" },
  { 1336, 2, 12, "\x01\x01\x81\x54\x81\x30\x82\x01\x08\x81\x18\x82\x01\x5c\x82\x02\x46\x82\x01\x5c\x81\x18\x82\x01\x08\x81\x30\x81\x54" },
  { 1348, 2, 8, "\x01\x01\x81\x55\x81\x7d\x01\x3c\x01\xea\x01\x3c\x81\x7d\x81\x55" },
  { 1384, 2, 10, "\x81\x01\x81\x5d\x81\x4e\x01\xdd\x02\x01\x67\x82\x02\x70\x82\x01\x67\x01\xdd\x01\x4e\x81\x5d" },
  { 1387, 1, 4, "\x09\x06\xe3\xb9\x11\xa0\x0a\xa0\x00\x00\x19\x05\xd8\x30\x67\x8a\x03\xdc\x59\x1a\x4a\x15\xc7\xe2\x79\xec\x8a\x67\x84\xe4\xe0\x00\x00\x00\x00\x00\x17\x57\xec\x66\x85\xbc\x66\x98\xca\x2d\x4b\x44\x55\x46\x2c\x57\xf4\x52\x14\x6f\xc0\x00\x00\x00\x16\x01\xbc\x8b\xf0\x83\xad\x1f\x82\xe8\xf8\xc0\x7c\x75\xe1\x0d\xce\x94\x68\xea\xb0\x80\x00" },
  { 1396, 2, 14, "\x81\x01\x82\x22\x8c\x03\x01\x2f\x01\x83\x04\x0c\x68\x03\x04\x2d\x20\x03\x05\xbc\x68\x83\x0b\xdc\x8e\x83\x05\x3d\xa8\x03\x0b\xdc\x8e\x03\x05\xbc\x68\x83\x04\x2d\x20\x83\x04\x0c\x68\x83\x01\x2f\x01\x82\x22\x8c" },
  { 1411, 1, 4, "\x0b\x05\x47\x5f\x4c\x45\x72\x0c\xf1\x40\x00\x00\x1e\x51\x98\xbd\xab\x02\x24\xe2\xb4\x75\x74\x8d\x95\xa2\xc7\x72\x4a\x19\x3c\xc9\x78\x72\x49\x28\xf4\x20\x00\x00\x00\x00\x00\x1a\x0c\x2d\x69\x94\xdd\xa4\xae\x27\x3d\xb5\x15\xbb\x53\x4d\xf1\xac\xbd\xcd\xaf\x89\x78\x8a\xc0\x00\x00\x00\x16\x04\xc2\x03\x1c\x0b\xfa\x7d\x0f\x93\x76\xd8\x71\xfe\x69\xba\x71\x05\x92\x4e\x29\x80\x00" },
  { 1412, 2, 16, "\x01\x01\x81\x65\x02\x01\x98\x02\x01\x17\x82\x08\x6f\x82\x08\xd4\x02\x05\x5a\x82\x08\xde\x82\x1b\x08\x82\x08\xde\x02\x05\x5a\x82\x08\xd4\x82\x08\x6f\x02\x01\x17\x02\x01\x98\x81\x65" },
  { 1423, 2, 9, "\x81\x01\x01\x05\x81\x16\x01\x25\x81\x41\x01\x2a\x81\x59\x01\x26\x81\x63" },
  { 1432, 2, 6, "\x81\x01\x81\x64\x01\x10\x81\x8a\x81\x10\x81\x64" },
  { 1435, 1, 4, "\x8b\x01\x50\x6b\x7c\x3d\xe1\xfc\x3a\x70\x00\x00\x1d\x5e\x36\x76\xf9\x80\x59\xc2\x7c\x84\xe6\x9c\x9f\xa9\x76\xe5\xc3\x7a\x43\xea\x3a\x7f\x1d\xf0\x00\x00\x00\x00\x00\x00\x1a\x41\x71\x31\x9e\xdc\xef\x23\xcb\x11\x94\x0f\xe6\x7d\xd1\xf8\x25\xf4\xf6\x06\x8e\x88\x4d\x80\x00\x00\x00\x16\x0c\xec\xdc\xc9\x12\x96\x38\xf6\xbb\x53\x43\x2f\x7f\x01\x82\xa6\xc1\x3e\x75\x60\x00\x00" },
  { 1448, 2, 18, "\x81\x01\x81\x6e\x82\x02\xde\x82\x04\x38\x02\x0a\x4e\x02\x16\x62\x82\x06\xed\x82\x2e\x54\x82\x08\xb4\x02\x37\xf0\x02\x08\xb4\x82\x2e\x54\x02\x06\xed\x02\x16\x62\x82\x0a\x4e\x82\x04\x38\x02\x02\xde\x81\x6e" },
  { 1480, 2, 12, "\x01\x01\x81\x66\x82\x02\xca\x82\x09\x54\x82\x14\x8e\x82\x20\x82\x82\x25\xda\x82\x20\x82\x82\x14\x8e\x82\x09\x54\x82\x02\xca\x81\x66" },
  { 1492, 2, 10, "\x81\x01\x82\x30\x24\x82\x2e\xe1\x82\x12\x60\x02\x1a\x6f\x82\x35\x04\x82\x1a\x6f\x82\x12\x60\x02\x2e\xe1\x82\x30\x24" },
  { 1495, 2, 20, "\x01\x01\x81\x07\x01\x11\x01\x0b\x81\x57\x01\x20\x01\xea\x81\x97\x82\x01\x99\x01\xde\x02\x01\xf7\x81\x60\x82\x01\x6f\x81\x23\x81\x09\x81\x83\x02\x01\x26\x02\x01\x00\x81\xb2\x81\x6e" },
  { 1507, 1, 4, "\x0a\x02\x14\x4d\xca\xcf\xa5\x2c\x30\x00\x00\x9a\x51\xf9\xcd\xaa\xa5\x8b\xfb\x87\x8e\x14\x06\xa9\xf7\xb9\x9e\x67\xa5\x4b\x63\x59\xc0\x00\x00\x00\x00\x00\x18\x96\xa2\xe5\x7e\x41\x15\x72\x93\xc8\x20\x7d\x64\xc1\xed\x90\x20\x34\x03\x6e\x8f\x00\x00\x00\x00\x16\xf6\xb5\x68\xb7\xe3\xa6\x1e\x1b\x0f\xc7\x52\xe9\xb5\x19\xeb\xc2\x61\x30\xa6\x5b\x00\x00" },
  { 1508, 2, 16, "\x01\x01\x81\x66\x82\x05\x17\x82\x1e\xda\x82\x70\x17\x83\x01\x1b\xe0\x83\x02\x17\xd6\x83\x03\x0a\x00\x83\x03\x70\x3e\x83\x03\x0a\x00\x83\x02\x17\xd6\x83\x01\x1b\xe0\x82\x70\x17\x82\x1e\xda\x82\x05\x17\x81\x66" },
  { 1528, 2, 8, "\x01\x01\x81\x78\x01\xf6\x82\x01\xe0\x02\x02\x03\x82\x01\xe0\x01\xf6\x81\x78" },
  { 1540, 2, 8, "\x01\x01\x81\x76\x82\x01\x1b\x01\xc6\x02\x02\xd8\x01\xc6\x82\x01\x1b\x81\x76" },
  { 1543, 2, 19, "\x81\x01\x01\x09\x81\x18\x01\x06\x01\x2a\x81\x04\x81\x22\x81\x4a\x81\x2e\x01\xee\x01\x31\x81\xb5\x81\xc3\x81\x74\x01\xc1\x02\x01\x13\x81\x6a\x01\x08\x81\x79" },
  { 1555, 1, 4, "\x0a\x77\x67\x2f\x66\xf9\x14\x7a\x30\x00\x00\x9d\x05\xb4\x70\x5d\x2f\x31\xb5\x6d\x91\x98\x13\x59\x74\xae\x42\xec\x07\x0e\xd5\x3e\x20\xb5\xdb\x40\x00\x00\x00\x00\x00\x1b\x58\xc7\x14\x3f\x52\x0e\x69\xab\x61\xb0\x09\xa4\x00\xe2\xf9\xe4\x4d\xda\xba\xd1\x08\x0d\x53\x00\x00\x00\x00\x17\x06\x9e\xa6\x1b\x7c\xc7\x0f\xa7\xb4\x6a\x3b\xed\x5a\x2c\x0f\xee\x91\x2b\x78\x4d\x31\x00\x00" },
  { 1567, 2, 15, "\x81\x01\x01\x01\x81\x0d\x01\x2c\x81\x4c\x01\xb6\x82\x01\x3d\x02\x01\x4a\x82\x01\x96\x02\x02\x0a\x82\x02\x14\x02\x02\x8a\x82\x02\x9e\x02\x01\x91\x81\x81" },
  { 1576, 2, 10, "\x81\x01\x81\x7f\x01\x5b\x82\x01\xc2\x81\xd1\x81\xd1\x01\xd1\x82\x01\xc2\x81\x5b\x81\x7f" },
  { 1588, 2, 6, "\x81\x01\x82\x42\x4e\x02\x34\x4a\x83\x01\x46\xd0\x82\x34\x4a\x82\x42\x4e" },
  { 1624, 2, 16, "\x01\x01\x01\x8e\x02\x02\x15\x02\x02\x96\x81\x47\x82\x01\x8c\x81\xf6\x82\x03\xc0\x01\xea\x02\x03\xc0\x81\xf6\x02\x01\x8c\x81\x47\x82\x02\x96\x02\x02\x15\x81\x8e" },
  { 1636, 2, 16, "\x01\x01\x81\x8b\x82\x01\x06\x82\x02\x79\x82\x02\x3d\x82\x02\x44\x82\x06\x14\x82\x08\x5c\x01\x64\x82\x08\x5c\x82\x06\x14\x82\x02\x44\x82\x02\x3d\x82\x02\x79\x82\x01\x06\x81\x8b" },
  { 1640, 2, 16, "\x01\x01\x01\x8a\x82\x02\x09\x02\x0a\x3e\x82\x11\xcf\x82\x14\xc8\x02\x33\xde\x02\x15\x94\x82\x49\xbe\x82\x15\x94\x02\x33\xde\x02\x14\xc8\x82\x11\xcf\x82\x0a\x3e\x82\x02\x09\x81\x8a" },
  { 1663, 2, 17, "\x81\x01\x01\x01\x01\x0e\x01\x08\x81\x55\x81\xcb\x81\xe1\x81\xdc\x82\x01\x03\x82\x01\x01\x82\x01\x22\x82\x01\x6d\x82\x01\xb5\x82\x02\x1d\x82\x01\xfb\x82\x01\x3a\x81\x91" },
  { 1672, 2, 8, "\x01\x01\x81\x96\x01\x69\x01\x1e\x82\x01\xe4\x01\x1e\x01\x69\x81\x96" },
  { 1684, 2, 10, "\x81\x01\x82\x5a\x7b\x82\xe6\x89\x83\x06\xce\x2e\x82\x58\x51\x83\x07\xaa\x99\x02\x58\x51\x83\x06\xce\x2e\x02\xe6\x89\x82\x5a\x7b" },
  { 1687, 2, 18, "\x01\x01\x01\x06\x01\x11\x01\x11\x01\x41\x01\x8d\x01\xfc\x02\x01\x89\x02\x01\xb8\x02\x02\x65\x02\x02\xad\x02\x02\x22\x02\x01\xbb\x01\xe3\x01\x52\x01\x08\x81\x8c\x81\x98" },
  { 1688, 2, 10, "\x81\x01\x81\x94\x02\x03\x0e\x82\x04\xfe\x82\x11\xf9\x02\x06\x1c\x02\x11\xf9\x82\x04\xfe\x82\x03\x0e\x81\x94" },
  { 1720, 2, 12, "\x01\x01\x81\x9c\x82\x03\x30\x82\x06\xa8\x82\x09\x18\x82\x0c\x54\x82\x0f\x06\x82\x0c\x54\x82\x09\x18\x82\x06\xa8\x82\x03\x30\x81\x9c" },
  { 1723, 1, 5, "\x0b\x02\x52\x69\x1d\x6f\xfd\x33\x84\x00\x00\x00\x9e\x03\xb5\x06\x6e\x8e\xa9\xa0\xb2\x54\xa6\x99\x82\xe4\x67\xd2\xd7\x38\xfa\x18\x90\x48\x84\x90\x00\x00\x00\x00\x00\x00\x00\x1c\x4d\x5d\x1d\xaa\xbf\x6e\x63\x34\x48\xe8\x5f\x0f\xd4\x32\xe3\xf1\xe1\xbd\x4a\xc9\x04\x62\x40\x00\x00\x00\x00\x00\x1a\x3e\x3c\x24\x93\x65\x45\x86\x17\x10\xbf\xab\x05\xa5\xef\x69\x96\xf7\x3b\xbd\x4c\xef\x9c\x00\x00\x00\x00\x18\x11\x8e\x59\x61\x86\xb3\xd7\x01\xce\x2b\x76\xef\x79\xdb\x26\xe3\x49\x93\x96\x86\x66\x27\x00\x00" },
  { 1732, 2, 12, "\x01\x01\x81\xa8\x02\x02\x78\x82\x05\xca\x02\x0a\xb8\x82\x10\x68\x02\x13\x0a\x82\x10\x68\x02\x0a\xb8\x82\x05\xca\x02\x02\x78\x81\xa8" },
  { 1747, 1, 5, "\x0a\x2f\x0e\x15\x41\x16\xef\x48\x00\x00\x00\x1c\x04\xa8\x6a\xd4\x65\x8b\xfb\xeb\x1d\x6e\xa3\xa9\x27\x4b\x33\xdd\xca\xe3\x47\xe8\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x0c\x3d\xd5\x89\x34\x40\xdc\xf0\x82\xd2\xf2\x75\xae\x21\xd6\x98\x1b\xfd\xe0\x84\xcb\xa0\x00\x00\x00\x00\x00\x99\xab\x18\x51\x27\x87\x25\x84\x40\xb6\x46\xac\x4f\xc9\x98\x6b\x4e\xcc\xcb\x82\x07\xad\x40\x00\x00\x00\x18\x2b\x66\x8b\x6e\xa9\xc5\x71\xaf\xcd\xec\xca\x2b\xf0\x74\x2f\x9a\x5f\x50\x29\x20\x14\x94\x80\x00" },
  { 1768, 2, 8, "\x01\x01\x01\xae\x01\x30\x81\x78\x81\x97\x01\x78\x01\x30\x81\xae" },
  { 1780, 2, 8, "\x01\x01\x02\x7a\x61\x03\x01\xc5\xbf\x83\x02\x97\x9c\x83\x02\xf2\x5c\x03\x02\x97\x9c\x03\x01\xc5\xbf\x82\x7a\x61" },
  { 1783, 2, 17, "\x81\x01\x81\x07\x81\x1e\x81\x3d\x81\x73\x81\x9e\x81\x5e\x81\x6f\x82\x01\x0c\x82\x01\x9b\x82\x01\xd1\x82\x01\xd9\x82\x01\x3a\x81\x6d\x82\x01\xbe\x82\x01\xf2\x81\xaf" },
  { 1807, 2, 12, "\x81\x01\x01\x05\x81\x16\x01\x1e\x81\x36\x01\x98\x82\x01\x03\x01\xff\x81\x63\x81\xaf\x02\x01\x10\x81\xba" },
  { 1816, 2, 14, "\x81\x01\x81\xba\x01\xc9\x82\x03\xe8\x82\x01\x40\x81\x48\x82\x06\xc2\x02\x03\xdc\x02\x06\xc2\x81\x48\x02\x01\x40\x82\x03\xe8\x81\xc9\x81\xba" },
  { 1828, 2, 8, "\x01\x01\x81\xbd\x82\x01\x29\x82\x02\xac\x82\x02\x42\x82\x02\xac\x82\x01\x29\x81\xbd" },
  { 1831, 2, 19, "\x81\x01\x01\x07\x81\x2b\x01\xa9\x82\x01\xda\x02\x03\xc9\x82\x05\x94\x02\x05\xe2\x82\x03\xcd\x01\x61\x02\x01\x19\x02\x01\x96\x82\x07\x9b\x02\x0c\x5a\x82\x0c\x87\x02\x09\x0f\x82\x03\xd3\x02\x01\x2d\x81\xc1" },
  { 1864, 2, 8, "\x01\x01\x81\xcf\x02\x04\x86\x82\x0b\x91\x02\x0f\x32\x82\x0b\x91\x02\x04\x86\x81\xcf" },
  { 1867, 1, 5, "\x0c\xde\xd8\x7f\x5c\xb2\xdf\x90\x64\xe4\x00\x00\x00\xa2\x0e\x17\x09\xb5\x20\x2f\x22\x4f\x95\x4e\xe2\x0d\xcc\xbe\x65\x1d\xb5\x36\x7d\xed\xfd\x23\x7c\x76\x7d\xd8\x30\x00\x00\x00\x00\x00\x00\x00\x20\x0d\xd9\x32\x89\xdf\xc5\x98\x73\xe5\xdb\xb7\xce\x80\xfc\xa5\xdf\x20\x3c\x9f\x7e\xc4\x57\x3c\x5d\xe4\x07\x80\x00\x00\x00\x00\x00\x9c\x64\x40\xc6\xa4\xa9\x56\xb2\x49\x8c\x1d\x9f\xb0\x7f\x10\x15\x9b\xd8\x6b\x5f\x2d\x2e\x9d\x10\xd7\x80\x00\x00\x00\x19\x0e\x4c\x7e\x14\x33\x32\x49\x62\xa5\x36\xcd\x46\x1f\x5f\x8d\x83\xec\xc9\x37\x9a\x5e\xf5\x96\x00\x00" },
  { 1876, 2, 16, "\x01\x01\x02\xa4\x28\x83\x03\x60\x62\x03\x03\x16\xb0\x03\x20\x87\xd1\x03\x09\x56\x10\x03\x28\xde\x7e\x83\x27\x65\xb8\x03\x5a\x9d\x24\x03\x27\x65\xb8\x03\x28\xde\x7e\x83\x09\x56\x10\x03\x20\x87\xd1\x83\x03\x16\xb0\x83\x03\x60\x62\x82\xa4\x28" },
  { 1892, 2, 12, "\x01\x01\x81\xd2\x01\x0f\x82\x0f\x50\x02\x1c\x07\x02\x10\x22\x82\x40\x2e\x02\x10\x22\x02\x1c\x07\x82\x0f\x50\x01\x0f\x81\xd2" },
  { 1912, 2, 8, "\x01\x01\x81\xd8\x81\x5a\x00\x02\x01\x73\x00\x81\x5a\x81\xd8" },
  { 1924, 2, 16, "\x01\x01\x81\xe2\x02\x04\xf1\x82\x0d\xfe\x02\x15\x39\x82\x11\x80\x82\x06\x86\x02\x20\x60\x82\x32\xae\x02\x20\x60\x82\x06\x86\x82\x11\x80\x02\x15\x39\x82\x0d\xfe\x02\x04\xf1\x81\xe2" },
  { 1927, 2, 18, "\x01\x01\x81\x08\x01\x0d\x01\x15\x81\x24\x00\x01\x51\x81\xa5\x02\x01\x5a\x82\x03\x08\x02\x05\x89\x82\x07\xc8\x02\x08\xc1\x82\x08\x28\x02\x06\x27\x82\x04\x3e\x02\x02\x56\x81\xe0" },
  { 1972, 2, 12, "\x01\x01\x02\xda\xa9\x03\x03\x0d\x65\x03\x04\xe4\x02\x83\x04\xa9\x01\x83\x0b\xe2\x03\x03\x03\xed\x76\x03\x0b\xe2\x03\x83\x04\xa9\x01\x83\x04\xe4\x02\x03\x03\x0d\x65\x82\xda\xa9" },
  { 2008, 2, 14, "\x81\x01\x81\xfa\x81\x8f\x02\x01\xd4\x02\x03\x78\x82\x03\xb4\x82\x07\x32\x02\x04\xec\x02\x07\x32\x82\x03\xb4\x82\x03\x78\x02\x01\xd4\x01\x8f\x81\xfa" },
  { 2020, 2, 8, "\x01\x01\x81\xff\x02\x01\x27\x02\x03\xd4\x82\x08\x0a\x02\x03\xd4\x02\x01\x27\x81\xff" },
  { 2047, 2, 18, "\x01\x01\x81\x0f\x01\x5e\x82\x01\x40\x02\x02\x93\x82\x03\x54\x02\x02\xce\x82\x01\xe4\x02\x01\xa2\x81\xb6\x82\x01\xf8\x02\x02\xbf\x02\x01\x2c\x82\x05\xdd\x02\x06\x25\x82\x03\x78\x02\x02\x1c\x82\x01\x0a" },
  { 2056, 2, 16, "\x01\x01\x82\x01\x05\x82\x06\x9c\x82\x1a\x55\x82\x47\xcf\x82\x91\x20\x82\xe7\xd2\x83\x01\x35\x06\x83\x01\x52\x88\x83\x01\x35\x06\x82\xe7\xd2\x82\x91\x20\x82\x47\xcf\x82\x1a\x55\x82\x06\x9c\x82\x01\x05" },
  { 2068, 2, 12, "\x01\x01\x03\x01\x21\x2c\x83\x04\x4d\xc0\x03\x03\x26\x88\x03\x07\x86\xa8\x83\x04\xfb\xfc\x03\x0f\x17\x3e\x03\x04\xfb\xfc\x03\x07\x86\xa8\x83\x03\x26\x88\x83\x04\x4d\xc0\x83\x01\x21\x2c" },
  { 2072, 2, 16, "\x01\x01\x02\x01\x10\x82\x01\xae\x02\x19\x68\x02\x09\xc9\x82\x47\x80\x02\x1d\xa2\x02\x6b\x28\x02\x16\x14\x82\x6b\x28\x02\x1d\xa2\x02\x47\x80\x02\x09\xc9\x82\x19\x68\x82\x01\xae\x82\x01\x10" },
  { 2095, 2, 16, "\x81\x01\x81\x0a\x81\x2b\x81\x65\x81\xc8\x81\xd3\x81\x64\x01\x0a\x01\xea\x01\xe2\x81\x6e\x82\x01\x93\x82\x01\x42\x82\x01\x91\x82\x03\x20\x82\x01\x18" },
  { 2104, 2, 12, "\x01\x01\x82\x01\x20\x02\x01\xb0\x81\x48\x82\x03\x30\x82\x09\x00\x82\x0d\xb6\x82\x09\x00\x82\x03\x30\x81\x48\x02\x01\xb0\x82\x01\x20" },
  { 2132, 2, 12, "\x01\x01\x03\x01\x5b\x5c\x03\x38\x73\xf0\x04\x03\xdb\x16\x08\x84\x06\x08\x8f\x08\x04\x01\xd1\xc9\x34\x04\x14\x48\x8f\xbe\x84\x01\xd1\xc9\x34\x84\x06\x08\x8f\x08\x84\x03\xdb\x16\x08\x03\x38\x73\xf0\x83\x01\x5b\x5c" },
  { 2143, 2, 13, "\x81\x01\x00\x81\x0c\x81\x2b\x01\x0e\x02\x01\x0c\x02\x01\x8c\x81\x9b\x82\x05\x0c\x82\x08\x71\x82\x08\x0a\x82\x04\x7b\x82\x01\x2b" },
  { 2152, 2, 10, "\x81\x01\x82\x01\x33\x81\x62\x82\x01\x51\x82\x03\x5d\x02\x02\x18\x02\x03\x5d\x82\x01\x51\x01\x62\x82\x01\x33" },
  { 2164, 2, 10, "\x81\x01\x83\x01\x7c\x0d\x83\x04\xb6\xca\x83\x32\x8f\x77\x03\x03\x32\x4b\x83\x83\x60\x28\x83\x03\x32\x4b\x83\x32\x8f\x77\x03\x04\xb6\xca\x83\x01\x7c\x0d" },
  { 2167, 2, 18, "\x81\x01\x81\x06\x81\x1b\x81\x20\x81\x66\x01\x07\x01\x07\x01\x59\x01\x2f\x01\x77\x82\x01\x1e\x01\x0e\x01\x84\x81\xa6\x82\x01\x7b\x02\x01\xe7\x01\xef\x82\x01\x3a" },
  { 2203, 1, 5, "\x0d\x07\x95\xd6\xbf\x9a\x04\x67\x04\x93\x20\x00\x00\x00\xa4\x46\x12\x50\xd6\x3b\x96\x63\x57\x57\x8f\x67\x06\xb5\xbc\x31\x42\xc3\x46\x54\x3b\x47\x27\x1b\x91\x28\x6a\x9c\x30\x00\x00\x00\x00\x00\x00\x00\x00\x23\x02\xda\x0b\x9b\x60\x50\xe1\xd8\x14\x2c\x30\xcc\x1f\x17\xaf\xb4\x44\x09\x6c\xaf\xa5\x5a\xcb\xfb\x9b\x07\xe7\x61\xd1\xe0\x00\x00\x00\x00\x00\x9f\x03\xdf\xa2\x99\x03\xa3\xa0\xbd\x7a\x3b\x39\x78\x19\xca\x5a\xe7\xf5\xd0\xe4\x49\x35\xce\x9f\x30\xc0\x1b\x3c\x40\x00\x00\x00\x1b\x1a\x90\x86\x59\x5a\xd3\x9e\xab\xcb\x9e\x22\x15\xc1\x71\x59\xa0\x79\x88\xd7\x2e\x08\xbc\xd4\xe8\x50\x80\x00" },
  { 2212, 2, 8, "\x01\x01\x82\x01\x4e\x01\x8a\x02\x01\xf0\x01\x7f\x02\x01\xf0\x01\x8a\x82\x01\x4e" },
  { 2228, 2, 18, "\x81\x01\x83\x01\xc6\x7d\x83\x19\x32\x49\x84\x06\xdd\x1b\xda\x84\x17\x87\xf8\x23\x84\x2c\x38\x77\x81\x84\x30\x9c\xc1\x25\x84\x2c\xea\x63\x62\x84\x14\xa8\x05\xda\x84\x3c\x5f\xce\x8c\x04\x14\xa8\x05\xda\x84\x2c\xea\x63\x62\x04\x30\x9c\xc1\x25\x84\x2c\x38\x77\x81\x04\x17\x87\xf8\x23\x84\x06\xdd\x1b\xda\x03\x19\x32\x49\x83\x01\xc6\x7d" },
  { 2248, 2, 8, "\x01\x01\x82\x01\x5f\x01\x7e\x82\x03\xb1\x02\x01\x22\x82\x03\xb1\x01\x7e\x82\x01\x5f" },
  { 2260, 2, 12, "\x01\x01\x03\x01\xf0\x77\x03\x08\xfd\xcc\x03\x04\x33\x8f\x03\x75\x99\xf0\x83\x02\x60\xd9\x03\xb6\xe8\x0a\x03\x02\x60\xd9\x03\x75\x99\xf0\x83\x04\x33\x8f\x03\x08\xfd\xcc\x83\x01\xf0\x77" },
  { 2296, 2, 16, "\x01\x01\x82\x01\x7a\x02\x05\x19\x82\x0c\x72\x02\x24\x31\x82\x47\xb8\x02\x4b\xba\x82\x19\xbc\x82\x0a\x86\x82\x19\xbc\x02\x4b\xba\x82\x47\xb8\x02\x24\x31\x82\x0c\x72\x02\x05\x19\x82\x01\x7a" },
  { 2308, 2, 8, "\x01\x01\x82\x01\x78\x82\x06\xfb\x82\x0e\xac\x82\x11\xc4\x82\x0e\xac\x82\x06\xfb\x82\x01\x78" },
  { 2335, 2, 14, "\x81\x01\x81\x08\x81\x36\x81\xca\x82\x02\x0e\x82\x04\x23\x82\x06\x46\x82\x08\x9d\x82\x0c\x59\x82\x0f\x2e\x82\x0f\xae\x82\x0d\xd9\x82\x07\x97\x82\x01\x86" },
  { 2344, 2, 18, "\x81\x01\x82\x01\x95\x82\x08\x34\x82\x15\xa1\x82\x1b\xb4\x82\x1c\x95\x82\x0f\xf5\x82\x29\xa6\x82\x0e\x40\x82\x30\x4e\x02\x0e\x40\x82\x29\xa6\x02\x0f\xf5\x82\x1c\x95\x02\x1b\xb4\x82\x15\xa1\x02\x08\x34\x82\x01\x95" },
  { 2347, 1, 5, "\x0c\x03\x1f\x1e\xc8\xdf\x94\x90\xf7\x72\x00\x00\x00\xa1\x02\x5f\xff\xa8\x30\x86\xd8\xaf\x18\xb5\x16\x13\xc6\x2d\x96\xf0\x3a\xce\x23\x53\xed\x7c\xb4\x59\x27\x70\x00\x00\x00\x00\x00\x00\x00\x9f\x02\x3f\xf0\x35\x6f\xf4\xb0\x21\xa6\xbf\x18\x9f\x1d\x10\x99\x73\x72\x80\x9d\xf0\x12\x8f\x51\x12\x25\x40\x00\x00\x00\x00\x00\x1d\x8e\xd1\xaa\x3e\x0e\x23\xde\x11\x2c\x64\x4a\x5e\xd6\x56\x89\xc7\x5d\xf7\xa6\xe9\x90\x1f\x04\x3d\xd1\x80\x00\x00\x00\x1c\x0b\xe8\xca\x94\xe9\x33\x6d\x0b\x13\xda\x75\x9a\x80\xf0\xfd\x28\x9b\x54\xe7\x4d\xe3\xc8\x43\x56\x22\x28\x80\x00" },
  { 2356, 2, 16, "\x01\x01\x03\x02\x84\xd6\x83\x1b\xcb\x69\x03\x7e\x26\x52\x83\x7e\xa9\x4f\x03\xbf\x60\x58\x03\x09\x07\xde\x03\x43\xbe\xdc\x04\x01\xa4\x98\xc2\x83\x43\xbe\xdc\x03\x09\x07\xde\x83\xbf\x60\x58\x83\x7e\xa9\x4f\x83\x7e\x26\x52\x83\x1b\xcb\x69\x83\x02\x84\xd6" },
  { 2392, 2, 8, "\x01\x01\x02\x01\xa8\x82\x04\x12\x81\x50\x02\x07\x1b\x01\x50\x82\x04\x12\x82\x01\xa8" },
  { 2407, 2, 20, "\x81\x01\x81\x02\x81\x15\x81\x12\x01\x68\x01\x35\x82\x01\xa7\x01\x5e\x02\x01\x7b\x81\x98\x81\x17\x82\x01\xcf\x02\x02\x27\x01\x36\x82\x05\x1a\x02\x08\x3e\x81\xeb\x82\x06\x81\x02\x04\xfc\x82\x01\xb6" },
  { 2440, 2, 12, "\x01\x01\x82\x01\xc8\x02\x02\x7f\x02\x04\x20\x82\x10\x7a\x02\x1f\x08\x82\x26\xfd\x02\x1f\x08\x82\x10\x7a\x02\x04\x20\x02\x02\x7f\x82\x01\xc8" },
  { 2452, 2, 10, "\x81\x01\x83\x03\x41\x46\x03\x07\x0f\x4c\x83\x01\x86\xcc\x83\x03\x34\x0f\x83\x02\x10\x9c\x03\x03\x34\x0f\x83\x01\x86\xcc\x83\x07\x0f\x4c\x83\x03\x41\x46" },
  { 2468, 2, 12, "\x01\x01\x82\x01\xd7\x82\x01\x2e\x82\x46\xab\x02\x5f\x6e\x82\xd2\x9f\x03\x01\x07\x5e\x82\xd2\x9f\x02\x5f\x6e\x82\x46\xab\x82\x01\x2e\x82\x01\xd7" },
  { 2488, 2, 12, "\x01\x01\x82\x01\xe0\x82\x08\x10\x82\x19\xc8\x82\x34\xb0\x82\x52\x80\x82\x5d\xf6\x82\x52\x80\x82\x34\xb0\x82\x19\xc8\x82\x08\x10\x82\x01\xe0" },
  { 2536, 2, 14, "\x81\x01\x82\x02\x01\x02\x05\x3d\x82\x12\x14\x02\x0d\xc0\x82\x05\xac\x82\x05\x12\x82\x12\xee\x02\x05\x12\x82\x05\xac\x82\x0d\xc0\x82\x12\x14\x82\x05\x3d\x82\x02\x01" },
  { 2584, 2, 16, "\x01\x01\x02\x02\x28\x02\x07\x32\x02\x07\x20\x82\x0c\x77\x82\x01\x20\x82\x0b\xbe\x02\x0a\x68\x02\x25\x14\x82\x0a\x68\x82\x0b\xbe\x02\x01\x20\x82\x0c\x77\x82\x07\x20\x02\x07\x32\x82\x02\x28" },
  { 2612, 2, 14, "\x81\x01\x83\x04\xef\x31\x04\x01\x90\x96\x61\x84\x23\xea\xf4\x08\x84\x01\x80\x0b\xa8\x84\x3a\xd6\xec\x78\x05\x01\x18\xaa\xce\x52\x04\x1d\xb1\x98\xd2\x85\x01\x18\xaa\xce\x52\x84\x3a\xd6\xec\x78\x04\x01\x80\x0b\xa8\x84\x23\xea\xf4\x08\x84\x01\x90\x96\x61\x83\x04\xef\x31" },
  { 2632, 2, 8, "\x01\x01\x82\x02\x4c\x02\x0a\x62\x82\x15\x00\x02\x1a\x7b\x82\x15\x00\x02\x0a\x62\x82\x02\x4c" },
  { 2644, 2, 18, "\x81\x01\x83\x05\x5b\x1e\x83\x2b\x3f\xe6\x84\x01\xa3\x2b\x18\x84\x04\x7d\xcb\x0a\x84\x07\x7e\x68\x4e\x04\x0e\x70\x9b\x73\x04\x08\xfb\xb1\x8c\x84\x03\xa1\x79\x84\x84\x05\xbe\x7a\xd0\x04\x03\xa1\x79\x84\x04\x08\xfb\xb1\x8c\x84\x0e\x70\x9b\x73\x84\x07\x7e\x68\x4e\x04\x04\x7d\xcb\x0a\x84\x01\xa3\x2b\x18\x03\x2b\x3f\xe6\x83\x05\x5b\x1e" },
  { 2647, 2, 15, "\x81\x01\x01\x04\x81\x02\x81\x3d\x81\xc1\x81\xad\x82\x01\x4c\x82\x03\x0a\x82\x01\xa6\x01\xf2\x82\x01\x15\x81\x8c\x02\x03\x5b\x01\xa7\x82\x02\x53" },
  { 2680, 2, 12, "\x01\x01\x82\x02\x70\x02\x09\x60\x82\x06\x18\x82\x2e\x80\x02\x96\xf0\x82\xd2\xf6\x02\x96\xf0\x82\x2e\x80\x82\x06\x18\x02\x09\x60\x82\x02\x70" },
  { 2683, 1, 5, "\x0d\x09\x4f\xe2\x65\xc8\xb8\x55\xd7\x15\x8c\x00\x00\x00\xa4\x9b\xf0\xb8\x7e\x55\x3f\xde\x83\x38\x58\xcb\xa7\x8b\x18\xd4\x50\x7f\x3e\xdf\xa0\xe3\x48\x25\xe6\x24\x60\xaa\x5c\xd0\x00\x00\x00\x00\x00\x00\x00\x23\x2b\xc7\x62\x15\x0d\x3b\xd5\x92\xa9\x30\xb1\xf9\x01\x1c\x41\x6b\xbb\x69\xef\x19\x15\x3b\x68\x4f\xe2\xab\xc4\x41\x21\x40\x00\x00\x00\x00\x00\xa1\x02\x11\xbb\x71\x01\x01\xc6\x6b\x24\x51\x0b\x0d\x86\x4e\xe8\x6c\xd9\x8c\xc7\x5f\x99\xb2\x81\xe6\xe9\xaa\x87\x68\xdf\x00\x00\x00\x00\x1e\x06\xcd\x10\xf9\xc2\xf8\x1b\xe1\xf8\xd5\x77\x9e\x5f\xe3\x75\x87\x52\x95\xc4\xe1\xea\xda\x63\x7a\x2c\x5d\x62\x53\x00\x00" },
  { 2692, 2, 12, "\x01\x01\x82\x02\x78\x02\x05\xe8\x82\x07\x6a\x02\x07\xe8\x82\x0c\xf8\x02\x11\xca\x82\x0c\xf8\x02\x07\xe8\x82\x07\x6a\x02\x05\xe8\x82\x02\x78" },
  { 2743, 2, 20, "\x81\x01\x01\x06\x81\x11\x81\x3a\x01\x43\x02\x01\xf5\x02\x01\xef\x82\x04\x1a\x82\x0c\xd6\x82\x0a\xec\x02\x08\xe6\x02\x1e\xcb\x02\x1b\x4c\x82\x01\x2f\x82\x19\xa1\x82\x18\x9f\x82\x08\xc8\x81\xab\x82\x03\x3e\x82\x02\x9e" },
  { 2728, 2, 12, "\x01\x01\x02\x02\x90\x82\x07\x18\x82\x03\x38\x02\x17\x28\x02\x01\x00\x82\x21\xf2\x82\x01\x00\x02\x17\x28\x02\x03\x38\x82\x07\x18\x82\x02\x90" },
  { 2740, 2, 12, "\x01\x01\x03\x06\xd2\xdb\x03\x11\xb9\x08\x83\xe5\x52\x01\x04\x01\x6e\x47\x94\x04\x01\x97\xd5\xeb\x04\x04\x97\x90\xaa\x84\x01\x97\xd5\xeb\x04\x01\x6e\x47\x94\x03\xe5\x52\x01\x03\x11\xb9\x08\x83\x06\xd2\xdb" },
  { 2776, 2, 10, "\x81\x01\x82\x02\xba\x02\x03\xd3\x82\x14\xc4\x82\x05\x8d\x82\x08\xe6\x02\x05\x8d\x82\x14\xc4\x82\x03\xd3\x82\x02\xba" },
  { 2788, 2, 8, "\x01\x01\x82\x02\xc7\x02\x03\x0a\x02\x01\xcb\x82\x04\x0e\x02\x01\xcb\x02\x03\x0a\x82\x02\xc7" },
  { 2836, 2, 10, "\x81\x01\x83\x08\xa8\x31\x03\x6f\xe5\x82\x84\x02\x2b\x99\x3f\x83\x07\x0d\x59\x84\x02\x5e\x3e\xd0\x03\x07\x0d\x59\x84\x02\x2b\x99\x3f\x83\x6f\xe5\x82\x83\x08\xa8\x31" },
  { 2872, 2, 12, "\x01\x01\x82\x03\x12\x82\x03\xab\x82\x08\x6a\x82\x02\x85\x82\x03\xe4\x02\x04\x0e\x82\x03\xe4\x82\x02\x85\x82\x08\x6a\x82\x03\xab\x82\x03\x12" },
  { 2884, 2, 16, "\x01\x01\x82\x03\x26\x02\x16\x8a\x82\x48\x84\x02\x84\xb5\x82\xd6\x4c\x03\x01\x67\xae\x83\x01\xb1\xfa\x03\x01\xb6\x44\x83\x01\xb1\xfa\x03\x01\x67\xae\x82\xd6\x4c\x02\x84\xb5\x82\x48\x84\x02\x16\x8a\x82\x03\x26" },
  { 2920, 2, 12, "\x01\x01\x02\x03\x40\x82\x08\x38\x82\x04\x18\x02\x02\x28\x82\x06\x70\x02\x07\xae\x02\x06\x70\x02\x02\x28\x02\x04\x18\x82\x08\x38\x82\x03\x40" },
  { 2932, 2, 14, "\x81\x01\x83\x0a\xf0\x8f\x03\x01\x67\x1d\x83\xa7\x14\x5c\x83\xb4\xf9\x60\x84\x02\x38\xb0\xb4\x83\x05\x69\xc2\x83\xf1\x56\x72\x03\x05\x69\xc2\x84\x02\x38\xb0\xb4\x03\xb4\xf9\x60\x83\xa7\x14\x5c\x83\x01\x67\x1d\x83\x0a\xf0\x8f" },
  { 2968, 2, 8, "\x01\x01\x02\x03\x76\x02\x05\xff\x02\x03\xc2\x02\x06\x5c\x82\x03\xc2\x02\x05\xff\x82\x03\x76" },
  { 2980, 2, 16, "\x01\x01\x82\x03\x7d\x82\x0e\x54\x82\x0b\xf1\x82\x08\xcf\x82\x28\x94\x82\x1b\x16\x02\x0b\x02\x82\x85\x90\x02\x0b\x02\x82\x1b\x16\x82\x28\x94\x82\x08\xcf\x82\x0b\xf1\x82\x0e\x54\x82\x03\x7d" },
  { 2983, 2, 20, "\x81\x01\x00\x81\x2b\x81\x20\x82\x01\x52\x01\x1f\x82\x04\x33\x02\x01\xee\x82\x06\xeb\x02\x03\x9e\x82\x08\x7c\x81\x10\x82\x05\x81\x82\x03\x67\x02\x04\xab\x82\x03\x77\x02\x05\x60\x82\x06\xd7\x82\x01\x22\x82\x03\x84" },
  { 3028, 2, 10, "\x81\x01\x83\x0d\xc5\x81\x03\x0f\xab\x62\x03\x2e\x79\x31\x83\x29\x57\xb9\x83\x48\x95\x10\x03\x29\x57\xb9\x03\x2e\x79\x31\x83\x0f\xab\x62\x83\x0d\xc5\x81" },
  { 3112, 2, 14, "\x81\x01\x82\x04\x19\x01\x79\x82\x0d\x20\x02\x03\x48\x82\x0f\x00\x02\x02\x0a\x82\x0c\x1e\x82\x02\x0a\x82\x0f\x00\x82\x03\x48\x82\x0d\x20\x81\x79\x82\x04\x19" },
  { 3140, 2, 16, "\x01\x01\x82\x04\x4e\x02\x4c\x51\x83\x01\xbe\xf2\x03\x02\x44\xb9\x03\x07\x5c\x90\x83\x26\xdc\xa6\x03\x52\x24\x40\x83\x67\xc8\xae\x03\x52\x24\x40\x83\x26\xdc\xa6\x03\x07\x5c\x90\x03\x02\x44\xb9\x83\x01\xbe\xf2\x02\x4c\x51\x82\x04\x4e" },
  { 3160, 2, 16, "\x01\x01\x02\x04\x52\x82\x0f\xd3\x02\x1b\xb2\x82\x37\x67\x02\x02\xf4\x82\x3c\x96\x02\x13\xc8\x82\x86\xa6\x82\x13\xc8\x82\x3c\x96\x82\x02\xf4\x82\x37\x67\x82\x1b\xb2\x82\x0f\xd3\x82\x04\x52" },
  { 3172, 2, 8, "\x01\x01\x82\x04\x60\x82\x17\x0c\x82\x35\x48\x82\x45\x43\x82\x35\x48\x82\x17\x0c\x82\x04\x60" },
  { 3208, 2, 12, "\x01\x01\x82\x04\x95\x81\xe1\x02\x0b\x58\x02\x09\xc9\x82\x0a\x53\x82\x10\xf2\x82\x0a\x53\x02\x09\xc9\x02\x0b\x58\x81\xe1\x82\x04\x95" },
  { 3220, 2, 16, "\x01\x01\x03\x15\x97\x92\x04\x01\x41\x75\xaf\x04\x04\xb2\x12\x16\x04\x05\x7d\x64\x11\x04\x09\x9d\xe6\x18\x04\x09\x4c\xcc\x7e\x84\x11\xc7\x2e\x5c\x84\x1d\xd5\x0b\xee\x04\x11\xc7\x2e\x5c\x04\x09\x4c\xcc\x7e\x84\x09\x9d\xe6\x18\x04\x05\x7d\x64\x11\x84\x04\xb2\x12\x16\x04\x01\x41\x75\xaf\x83\x15\x97\x92" },
  { 3256, 2, 12, "\x01\x01\x82\x04\xd4\x82\x12\x90\x82\x4e\xa8\x82\x88\x38\x82\xb5\x5c\x82\xf1\x86\x82\xb5\x5c\x82\x88\x38\x82\x4e\xa8\x82\x12\x90\x82\x04\xd4" },
  { 3268, 2, 12, "\x01\x01\x82\x04\xec\x02\x0e\xb0\x82\x1b\xc6\x02\x03\x20\x02\x17\x34\x82\x39\x26\x02\x17\x34\x02\x03\x20\x82\x1b\xc6\x02\x0e\xb0\x82\x04\xec" },
  { 3304, 2, 12, "\x01\x01\x02\x05\x24\x02\x20\x00\x02\x51\x28\x02\x48\x48\x02\x3d\xcc\x02\x58\x1e\x82\x3d\xcc\x02\x48\x48\x82\x51\x28\x02\x20\x00\x82\x05\x24" },
  { 3343, 2, 19, "\x81\x01\x01\x08\x81\x3c\x01\x7e\x82\x01\x7c\x02\x04\x8c\x82\x0b\x47\x02\x16\x09\x82\x22\x87\x02\x2b\xd5\x82\x30\x65\x02\x2b\x41\x82\x28\x5f\x02\x21\xc1\x82\x25\xc9\x02\x1e\x54\x82\x19\xc8\x02\x0a\x6f\x82\x05\x5b" },
  { 3352, 2, 14, "\x81\x01\x82\x05\x6a\x82\x0f\xe7\x82\x29\x68\x82\x27\x20\x82\x44\xe8\x82\x16\xb2\x82\x43\xc4\x02\x16\xb2\x82\x44\xe8\x02\x27\x20\x82\x29\x68\x02\x0f\xe7\x82\x05\x6a" },
  { 3412, 2, 10, "\x81\x01\x83\x21\x68\x88\x04\x01\x3f\xfe\xef\x84\x04\x74\xc3\x84\x04\x05\x91\xb6\xe7\x84\x01\xe4\x05\x54\x84\x05\x91\xb6\xe7\x84\x04\x74\xc3\x84\x84\x01\x3f\xfe\xef\x83\x21\x68\x88" },
  { 3448, 2, 8, "\x01\x01\x82\x06\x06\x02\x09\x7b\x82\x05\x0a\x82\x03\x94\x82\x05\x0a\x02\x09\x7b\x82\x06\x06" },
  { 3460, 2, 16, "\x01\x01\x82\x06\x15\x82\x19\x49\x82\x1a\x20\x82\x2b\x25\x82\x40\xd5\x82\x4c\x12\x82\x3b\x95\x82\x7e\xc4\x82\x3b\x95\x82\x4c\x12\x82\x40\xd5\x82\x2b\x25\x82\x1a\x20\x82\x19\x49\x82\x06\x15" },
  { 3463, 2, 19, "\x81\x01\x01\x0b\x81\x09\x81\x8a\x81\x43\x02\x01\xb5\x02\x01\xaf\x02\x01\x97\x82\x0c\x95\x02\x06\xd6\x82\x0a\x66\x02\x26\x7b\x82\x1c\xa0\x02\x09\x73\x82\x22\x0d\x02\x18\x3a\x02\x0f\x57\x82\x08\x61\x82\x06\x1d" },
  { 3508, 2, 10, "\x81\x01\x83\x29\x5d\x94\x03\x85\xeb\x0f\x83\x76\x97\x70\x03\x2d\x37\xaf\x83\x40\x88\xc4\x83\x2d\x37\xaf\x83\x76\x97\x70\x83\x85\xeb\x0f\x83\x29\x5d\x94" },
  { 3544, 2, 18, "\x81\x01\x82\x06\xb6\x82\x20\x93\x82\x41\xdc\x82\x16\xc6\x82\x9f\x08\x82\x52\x76\x82\x30\xa8\x02\x0b\x9d\x02\x24\x72\x82\x0b\x9d\x82\x30\xa8\x02\x52\x76\x82\x9f\x08\x02\x16\xc6\x82\x41\xdc\x02\x20\x93\x82\x06\xb6" },
  { 3556, 2, 16, "\x01\x01\x82\x06\xca\x02\x0e\x7a\x82\x38\xdc\x03\x01\x05\x25\x83\x01\x8f\x34\x02\xd2\x3e\x02\x3d\xca\x82\x85\x9c\x02\x3d\xca\x02\xd2\x3e\x83\x01\x8f\x34\x03\x01\x05\x25\x82\x38\xdc\x02\x0e\x7a\x82\x06\xca" },
  { 3592, 2, 12, "\x01\x01\x82\x07\x0b\x82\x12\xae\x82\x23\x61\x82\x37\x5c\x82\x51\x57\x82\x52\xec\x82\x51\x57\x82\x37\x5c\x82\x23\x61\x82\x12\xae\x82\x07\x0b" },
  { 3607, 2, 19, "\x81\x01\x81\x08\x81\x13\x01\x90\x81\x3a\x81\x70\x82\x05\x74\x02\x12\x2c\x82\x14\xe1\x81\x4b\x02\x25\x66\x82\x41\xe0\x02\x3c\xf4\x82\x0f\x4d\x82\x2a\x47\x02\x41\x3b\x82\x32\x0d\x02\x19\x8b\x82\x07\x2f" },
  { 3640, 2, 16, "\x01\x01\x82\x07\x68\x82\x30\x36\x82\x59\xd0\x82\x01\x7f\x03\x01\x02\x30\x03\x02\xc2\x4a\x03\x05\x46\x48\x03\x06\xad\x64\x03\x05\x46\x48\x03\x02\xc2\x4a\x03\x01\x02\x30\x82\x01\x7f\x82\x59\xd0\x82\x30\x36\x82\x07\x68" },
  { 3652, 2, 12, "\x01\x01\x82\x07\x80\x82\x37\xa0\x82\xbd\x7e\x83\x01\x91\xe0\x83\x02\x6e\x80\x83\x02\xd6\x86\x83\x02\x6e\x80\x83\x01\x91\xe0\x82\xbd\x7e\x82\x37\xa0\x82\x07\x80" },
  { 3688, 2, 18, "\x81\x01\x82\x07\xd7\x82\x18\xbd\x82\x25\x42\x02\x05\xcd\x02\x0f\x09\x82\x47\x2d\x82\x40\x62\x02\x39\xba\x02\x3f\xe4\x82\x39\xba\x82\x40\x62\x02\x47\x2d\x02\x0f\x09\x82\x05\xcd\x82\x25\x42\x02\x18\xbd\x82\x07\xd7" },
  { 3752, 2, 16, "\x01\x01\x02\x08\x78\x02\xb6\x8e\x03\x05\x23\x60\x03\x0b\x90\xc1\x03\x14\x2e\x50\x03\x19\xb7\xee\x03\x0e\xbb\xe8\x03\x20\x6c\x84\x83\x0e\xbb\xe8\x03\x19\xb7\xee\x83\x14\x2e\x50\x03\x0b\x90\xc1\x83\x05\x23\x60\x02\xb6\x8e\x82\x08\x78" },
  { 3784, 2, 16, "\x01\x01\x82\x08\xb2\x02\x2d\x33\x82\x45\xba\x82\x75\xef\x02\x4c\xc8\x02\xbd\x7e\x02\x5f\x7c\x83\x02\x0e\x56\x02\x5f\x7c\x02\xbd\x7e\x02\x4c\xc8\x82\x75\xef\x82\x45\xba\x02\x2d\x33\x82\x08\xb2" },
  { 3796, 2, 12, "\x01\x01\x03\x4d\x33\x22\x84\x05\xe5\x40\x95\x04\x2a\x02\x9e\x86\x04\x36\x3b\xaf\xab\x84\x72\x1e\xa2\x3c\x84\x2b\xb7\x2d\x2e\x04\x72\x1e\xa2\x3c\x04\x36\x3b\xaf\xab\x84\x2a\x02\x9e\x86\x84\x05\xe5\x40\x95\x83\x4d\x33\x22" },
  { 3832, 2, 16, "\x01\x01\x82\x09\x1e\x82\x19\x5f\x82\x2a\x96\x82\x03\x2f\x02\xa0\x08\x02\xdf\x1a\x82\x70\xa4\x83\x01\x83\xf6\x82\x70\xa4\x02\xdf\x1a\x02\xa0\x08\x82\x03\x2f\x82\x2a\x96\x82\x19\x5f\x82\x09\x1e" },
  { 3880, 2, 12, "\x01\x01\x02\x09\x98\x82\x13\xa8\x82\x1b\x38\x82\x58\x98\x82\x06\xc8\x82\x5c\xd2\x02\x06\xc8\x82\x58\x98\x02\x1b\x38\x82\x13\xa8\x82\x09\x98" },
  { 3892, 2, 12, "\x01\x01\x03\x5e\x8b\xd0\x04\x01\xaa\x1d\xd0\x83\x2a\x3e\x58\x04\x05\x49\x92\x70\x03\x1b\x8c\x10\x04\x06\x6c\xe4\x8e\x83\x1b\x8c\x10\x04\x05\x49\x92\x70\x03\x2a\x3e\x58\x04\x01\xaa\x1d\xd0\x83\x5e\x8b\xd0" },
  { 3928, 2, 10, "\x81\x01\x82\x0a\x18\x02\x08\x0e\x02\x16\x6e\x82\x11\xf9\x82\x1d\xe4\x02\x11\xf9\x02\x16\x6e\x82\x08\x0e\x82\x0a\x18" },
  { 3976, 2, 16, "\x01\x01\x82\x0a\x9e\x02\x07\xfb\x82\x5d\xba\x03\x01\x91\x89\x83\x01\x32\xb4\x02\xd2\x4e\x83\x01\x85\xd0\x03\x03\x6f\xa2\x83\x01\x85\xd0\x02\xd2\x4e\x83\x01\x32\xb4\x03\x01\x91\x89\x82\x5d\xba\x02\x07\xfb\x82\x0a\x9e" },
  { 3988, 2, 14, "\x81\x01\x83\x73\x80\x9c\x84\x04\x2e\xed\x0f\x84\x18\x56\x6a\x78\x84\x3c\x71\xee\x00\x84\x79\xc4\x92\xc8\x84\x4d\x17\xe1\xde\x84\x40\x5d\x6f\x08\x04\x4d\x17\xe1\xde\x84\x79\xc4\x92\xc8\x04\x3c\x71\xee\x00\x84\x18\x56\x6a\x78\x04\x04\x2e\xed\x0f\x83\x73\x80\x9c" },
  { 4072, 2, 18, "\x81\x01\x82\x0b\xb5\x02\x25\x3b\x82\x3b\x9e\x02\x49\x4d\x82\x84\x2d\x02\x55\x63\x83\x01\x78\x6e\x02\x28\xc2\x83\x02\x67\x24\x82\x28\xc2\x83\x01\x78\x6e\x82\x55\x63\x82\x84\x2d\x82\x49\x4d\x82\x3b\x9e\x82\x25\x3b\x82\x0b\xb5" },
  { 4120, 2, 12, "\x01\x01\x02\x0c\x4a\x82\x3f\x0d\x02\x56\xd2\x82\x6b\x6e\x02\x3e\x22\x82\x10\x6d\x82\x3e\x22\x82\x6b\x6e\x82\x56\xd2\x82\x3f\x0d\x82\x0c\x4a" },
  { 4132, 2, 12, "\x01\x01\x82\x0c\x77\x02\x0d\xd2\x02\x15\x35\x82\x0b\x72\x82\x1a\x3f\x02\x0b\x7e\x82\x1a\x3f\x82\x0b\x72\x02\x15\x35\x02\x0d\xd2\x82\x0c\x77" },
  { 4168, 2, 12, "\x01\x01\x82\x0c\xed\x02\x03\xa2\x82\x6d\x9b\x02\x4f\xc8\x83\x01\x43\xa9\x02\xbe\xc8\x83\x01\x43\xa9\x02\x4f\xc8\x82\x6d\x9b\x02\x03\xa2\x82\x0c\xed" },
  { 4180, 2, 16, "\x01\x01\x03\xab\x28\xc2\x04\x0b\x43\x84\x7f\x04\x13\xa3\x88\x66\x84\x0f\x28\x5c\x2f\x84\x15\x64\x29\xa8\x84\x20\x9c\x09\x42\x84\x2a\xc3\x21\x3c\x04\x4b\x44\x02\x72\x04\x2a\xc3\x21\x3c\x84\x20\x9c\x09\x42\x04\x15\x64\x29\xa8\x84\x0f\x28\x5c\x2f\x84\x13\xa3\x88\x66\x04\x0b\x43\x84\x7f\x83\xab\x28\xc2" },
  { 4216, 2, 16, "\x01\x01\x82\x0d\x92\x02\x0a\x89\x82\xa2\xea\x03\x02\x11\x81\x83\x03\x2a\xd8\x03\x02\x1c\xea\x03\x01\xa2\x14\x83\x03\xf0\x66\x03\x01\xa2\x14\x03\x02\x1c\xea\x83\x03\x2a\xd8\x03\x02\x11\x81\x82\xa2\xea\x02\x0a\x89\x82\x0d\x92" },
  { 4228, 2, 16, "\x01\x01\x82\x0d\xc4\x02\x75\x5b\x83\x01\xd6\x7c\x03\x04\xbb\x05\x83\x08\xda\xb8\x03\x0d\x07\x96\x83\x0f\xf5\xf0\x03\x10\xfb\x26\x83\x0f\xf5\xf0\x03\x0d\x07\x96\x83\x08\xda\xb8\x03\x04\xbb\x05\x83\x01\xd6\x7c\x02\x75\x5b\x82\x0d\xc4" },
  { 4324, 2, 16, "\x01\x01\x82\x0f\x1e\x81\x51\x02\xa7\xd6\x82\xdc\x7b\x83\x09\xac\xd4\x83\x0c\x12\x06\x03\x09\x27\x18\x03\x1a\x08\xaa\x03\x09\x27\x18\x83\x0c\x12\x06\x83\x09\xac\xd4\x82\xdc\x7b\x02\xa7\xd6\x81\x51\x82\x0f\x1e" },
  { 4327, 2, 19, "\x81\x01\x01\x04\x81\x49\x02\x01\x8b\x82\x02\x67\x82\x03\x40\x02\x09\xe9\x81\x9f\x82\x1a\x5b\x02\x12\x8c\x02\x22\x04\x82\x20\x99\x82\x17\x02\x02\x17\xbd\x82\x05\xaf\x01\x43\x02\x13\x32\x82\x08\xf0\x82\x0f\x29" },
  { 4360, 2, 12, "\x01\x01\x82\x0f\xae\x02\x30\x7e\x02\x35\x4c\x83\x03\x07\x26\x03\x08\x85\x96\x83\x0b\xaf\x5a\x03\x08\x85\x96\x83\x03\x07\x26\x02\x35\x4c\x02\x30\x7e\x82\x0f\xae" },
  { 4372, 2, 10, "\x81\x01\x83\xfb\x61\x03\x04\x02\x13\x6e\xd5\x84\x03\xd7\x08\x14\x04\x02\x51\x55\x86\x84\x05\x12\xa0\xd2\x84\x02\x51\x55\x86\x84\x03\xd7\x08\x14\x84\x02\x13\x6e\xd5\x83\xfb\x61\x03" },
  { 4420, 2, 16, "\x01\x01\x82\x10\x98\x82\x81\xcc\x83\x01\xb8\x70\x83\x04\x10\xf5\x83\x04\xf1\x58\x82\x6c\x24\x03\x07\xea\x20\x03\x0c\xae\x48\x03\x07\xea\x20\x82\x6c\x24\x83\x04\xf1\x58\x83\x04\x10\xf5\x83\x01\xb8\x70\x82\x81\xcc\x82\x10\x98" },
  { 4447, 2, 17, "\x81\x01\x01\x0b\x81\x74\x02\x01\xe2\x82\x01\xc5\x82\x05\x89\x02\x0b\x8d\x81\x65\x82\x16\x0f\x02\x0f\x8d\x02\x07\x0d\x82\x24\x0b\x82\x03\x15\x02\x13\xff\x82\x03\x47\x82\x15\xc4\x82\x11\x11" },
  { 4468, 2, 14, "\x81\x01\x84\x01\x2f\xae\x8d\x83\x63\xad\x1e\x03\x76\x17\x2d\x84\x09\x0d\x29\xcf\x84\x1b\xd0\xe0\x96\x84\x0d\x3d\x02\x5d\x84\x09\x2f\xd4\x8f\x04\x0d\x3d\x02\x5d\x84\x1b\xd0\xe0\x96\x04\x09\x0d\x29\xcf\x03\x76\x17\x2d\x03\x63\xad\x1e\x84\x01\x2f\xae\x8d" },
  { 4516, 2, 16, "\x01\x01\x82\x12\x3f\x82\x4d\xdd\x83\x01\x5a\x54\x83\x01\x28\xd5\x03\x04\x00\x15\x03\x07\xbb\xae\x83\x02\xca\x73\x83\x0c\x41\x9c\x83\x02\xca\x73\x03\x07\xbb\xae\x03\x04\x00\x15\x83\x01\x28\xd5\x83\x01\x5a\x54\x82\x4d\xdd\x82\x12\x3f" },
  { 4552, 2, 12, "\x01\x01\x82\x12\xe7\x82\x34\x35\x82\x64\x38\x82\x76\xe3\x82\x79\x71\x82\x6a\xf2\x82\x79\x71\x82\x76\xe3\x82\x64\x38\x82\x34\x35\x82\x12\xe7" },
  { 4568, 2, 18, "\x81\x01\x82\x13\x20\x03\x01\x9a\xe0\x83\x0f\x23\xf2\x03\x10\x9c\xa0\x83\x37\xc7\x60\x02\x28\x47\x83\x1f\x1c\x00\x83\x0d\x50\x40\x03\x1b\x4e\x2c\x03\x0d\x50\x40\x83\x1f\x1c\x00\x82\x28\x47\x83\x37\xc7\x60\x83\x10\x9c\xa0\x83\x0f\x23\xf2\x83\x01\x9a\xe0\x82\x13\x20" },
  { 4612, 2, 16, "\x01\x01\x82\x14\x07\x82\x4f\x59\x82\x91\xbc\x83\x01\x76\x41\x83\x05\x29\x6b\x83\x0c\x6d\xda\x83\x13\xd2\x23\x83\x16\xda\x78\x83\x13\xd2\x23\x83\x0c\x6d\xda\x83\x05\x29\x6b\x83\x01\x76\x41\x82\x91\xbc\x82\x4f\x59\x82\x14\x07" },
  { 4648, 2, 12, "\x01\x01\x02\x14\xc0\x02\x05\x48\x82\x4b\xc8\x02\x6d\x68\x02\x13\x30\x02\x22\xae\x82\x13\x30\x02\x6d\x68\x02\x4b\xc8\x02\x05\x48\x82\x14\xc0" },
  { 4687, 2, 16, "\x81\x01\x81\x01\x81\x2e\x02\x01\xf2\x82\x07\xfb\x02\x0e\x94\x82\x0c\xea\x02\x01\x8c\x02\x0a\x3f\x82\x0b\x0b\x82\x0a\xbd\x02\x08\xd1\x02\x0c\x40\x82\x1f\x6d\x02\x2c\x02\x82\x15\x8c" },
  { 4708, 2, 12, "\x01\x01\x82\x15\xf4\x82\x7c\x10\x83\x01\x72\xfa\x83\x02\xf3\x00\x83\x04\x64\x74\x83\x05\x04\xa6\x83\x04\x64\x74\x83\x02\xf3\x00\x83\x01\x72\xfa\x82\x7c\x10\x82\x15\xf4" },
  { 4712, 2, 16, "\x01\x01\x02\x15\xfc\x83\x01\xa5\xdc\x03\x0c\x7a\x30\x03\x2c\x4f\xb2\x83\x06\xb6\xd4\x83\x45\xac\x60\x03\x1c\x74\xb4\x03\x1e\xb7\x8b\x83\x1c\x74\xb4\x83\x45\xac\x60\x03\x06\xb6\xd4\x03\x2c\x4f\xb2\x83\x0c\x7a\x30\x83\x01\xa5\xdc\x82\x15\xfc" },
  { 4792, 2, 12, "\x01\x01\x82\x17\xd6\x02\xdb\x2d\x83\x03\x9c\x1e\x03\x09\x30\x1b\x83\x0f\xa3\x2c\x03\x12\x97\x9e\x83\x0f\xa3\x2c\x03\x09\x30\x1b\x83\x03\x9c\x1e\x02\xdb\x2d\x82\x17\xd6" },
  { 4804, 2, 16, "\x01\x01\x82\x18\x1a\x02\xba\x12\x83\x02\x74\x8c\x03\x02\xd9\x5d\x83\x05\x1e\xf4\x03\x05\x03\xe6\x83\x0a\xbe\xf6\x03\x03\xa6\x74\x83\x0a\xbe\xf6\x03\x05\x03\xe6\x83\x05\x1e\xf4\x03\x02\xd9\x5d\x83\x02\x74\x8c\x02\xba\x12\x82\x18\x1a" },
  { 4852, 2, 10, "\x81\x01\x84\x02\x7a\x45\x11\x84\x01\xdd\x59\x3e\x84\x06\xba\x86\x1f\x83\x95\xc7\x19\x04\x0e\x50\x2a\xb0\x03\x95\xc7\x19\x84\x06\xba\x86\x1f\x04\x01\xdd\x59\x3e\x84\x02\x7a\x45\x11" },
  { 4888, 2, 12, "\x01\x01\x02\x1a\x0c\x82\x11\xe0\x82\x12\x2c\x82\x0d\x98\x82\x31\x94\x02\x2d\x52\x02\x31\x94\x82\x0d\x98\x02\x12\x2c\x82\x11\xe0\x82\x1a\x0c" },
  { 4948, 2, 14, "\x81\x01\x84\x02\xf6\xfe\xe3\x04\x0a\x2b\x63\x41\x84\x90\x64\x30\x08\x04\x34\x33\x04\x28\x04\x32\x0e\x45\x08\x05\x01\x99\x0d\x43\x32\x84\x2f\xec\xbb\x6a\x85\x01\x99\x0d\x43\x32\x04\x32\x0e\x45\x08\x84\x34\x33\x04\x28\x84\x90\x64\x30\x08\x84\x0a\x2b\x63\x41\x84\x02\xf6\xfe\xe3" },
  { 4984, 2, 16, "\x01\x01\x82\x1c\x86\x03\x01\x0c\xd1\x83\x03\xe4\xde\x03\x04\x47\x61\x02\xe0\x28\x03\x03\x2c\x0a\x03\x01\x47\xcc\x83\x06\xb2\x56\x03\x01\x47\xcc\x03\x03\x2c\x0a\x02\xe0\x28\x03\x04\x47\x61\x83\x03\xe4\xde\x03\x01\x0c\xd1\x82\x1c\x86" },
  { 5032, 2, 12, "\x01\x01\x02\x1d\xca\x02\x47\x5e\x02\x80\x5c\x82\x66\x36\x02\xf7\xc2\x03\x01\x66\x5e\x82\xf7\xc2\x82\x66\x36\x82\x80\x5c\x02\x47\x5e\x82\x1d\xca" },
  { 5128, 2, 12, "\x01\x01\x82\x20\x7f\x82\xe9\x9a\x83\x03\x4e\x39\x83\x07\xbe\xa0\x83\x0c\xa9\x53\x83\x0e\xdf\x9c\x83\x0c\xa9\x53\x83\x07\xbe\xa0\x83\x03\x4e\x39\x82\xe9\x9a\x82\x20\x7f" },
  { 5140, 2, 12, "\x01\x01\x04\x04\x39\x44\x87\x04\x55\x2c\xed\x0c\x84\x67\x7f\xae\xc1\x04\x3c\x84\xa3\x50\x04\x6b\xaa\xa1\xb7\x04\x6d\xa6\x0b\x2a\x84\x6b\xaa\xa1\xb7\x04\x3c\x84\xa3\x50\x04\x67\x7f\xae\xc1\x04\x55\x2c\xed\x0c\x84\x04\x39\x44\x87" },
  { 5188, 2, 12, "\x01\x01\x82\x22\x5c\x02\x40\x3b\x82\x23\x7e\x02\x8e\x0b\x82\xfd\x0e\x02\x8e\x22\x82\xfd\x0e\x02\x8e\x0b\x82\x23\x7e\x02\x40\x3b\x82\x22\x5c" },
  { 5224, 2, 18, "\x81\x01\x82\x23\x85\x82\xf6\xc0\x83\x02\x7d\x15\x03\x01\x51\x08\x82\x91\x95\x03\x06\x23\xcb\x03\x01\x19\x6a\x83\x0f\x84\x78\x03\x02\x01\xba\x03\x0f\x84\x78\x03\x01\x19\x6a\x83\x06\x23\xcb\x82\x91\x95\x83\x01\x51\x08\x83\x02\x7d\x15\x02\xf6\xc0\x82\x23\x85" },
  { 5272, 2, 10, "\x81\x01\x82\x25\x10\x02\x1b\xbe\x02\x15\x2a\x02\x0f\xc7\x82\x06\x7c\x82\x0f\xc7\x02\x15\x2a\x82\x1b\xbe\x82\x25\x10" },
  { 5380, 2, 16, "\x01\x01\x82\x28\xd5\x82\x20\x8d\x03\x02\x52\xcc\x83\x03\xde\xc8\x82\x16\xba\x03\x03\x67\xcd\x03\x02\xfa\x83\x83\x08\xf5\x72\x03\x02\xfa\x83\x03\x03\x67\xcd\x82\x16\xba\x83\x03\xde\xc8\x03\x02\x52\xcc\x82\x20\x8d\x82\x28\xd5" },
  { 5428, 2, 16, "\x01\x01\x04\x07\x18\x4d\x42\x84\x57\xfd\x32\x41\x05\x01\x03\xe5\x23\xe6\x05\x03\x10\xfe\x5b\x51\x04\x16\x0e\x7b\xd8\x85\x01\x9f\x31\x88\xc2\x04\xf9\xd3\xeb\xc4\x84\xa3\x1d\x36\x0e\x84\xf9\xd3\xeb\xc4\x85\x01\x9f\x31\x88\xc2\x84\x16\x0e\x7b\xd8\x05\x03\x10\xfe\x5b\x51\x85\x01\x03\xe5\x23\xe6\x84\x57\xfd\x32\x41\x84\x07\x18\x4d\x42" },
  { 5464, 2, 18, "\x81\x01\x82\x2c\x0a\x83\x01\xaf\x91\x83\x07\x64\x5c\x83\x0d\x85\xf7\x83\x12\xe1\x72\x83\x08\x90\xf9\x83\x0e\x3d\x0c\x83\x04\x6e\xd2\x83\x20\x0c\x58\x03\x04\x6e\xd2\x83\x0e\x3d\x0c\x03\x08\x90\xf9\x83\x12\xe1\x72\x03\x0d\x85\xf7\x83\x07\x64\x5c\x03\x01\xaf\x91\x82\x2c\x0a" },
  { 5527, 2, 19, "\x81\x01\x81\x08\x81\x0a\x02\x02\x14\x82\x0f\xb4\x02\x39\x69\x82\x8d\x54\x02\xfa\xe6\x83\x01\x4c\x65\x03\x01\x4c\x6b\x82\xe0\x1a\x02\x10\x57\x02\xba\x09\x82\xff\x0f\x02\xc8\x2e\x82\x43\x1a\x82\x52\x3c\x02\x74\xf2\x82\x2e\x87" },
  { 5572, 2, 16, "\x01\x01\x82\x30\x64\x82\x23\x85\x02\xb7\x64\x03\x02\x98\x25\x03\x02\xea\xe8\x03\x01\x3b\xf6\x83\x04\x3e\xf0\x83\x05\x60\x9a\x83\x04\x3e\xf0\x03\x01\x3b\xf6\x03\x02\xea\xe8\x03\x02\x98\x25\x02\xb7\x64\x82\x23\x85\x82\x30\x64" },
  { 5608, 2, 14, "\x81\x01\x82\x31\xf3\x82\x51\x56\x02\x58\x9b\x02\xe6\xd9\x82\x60\xba\x83\x01\x60\x95\x02\x53\x07\x03\x01\x60\x95\x82\x60\xba\x82\xe6\xd9\x02\x58\x9b\x02\x51\x56\x82\x31\xf3" },
  { 5668, 2, 16, "\x01\x01\x82\x34\x9e\x82\x60\xa9\x03\x01\x2f\x2a\x03\x01\x60\xbd\x83\x07\x1a\x48\x03\x04\xdd\x0a\x03\x08\xcb\x2c\x83\x11\xc7\x5e\x03\x08\xcb\x2c\x03\x04\xdd\x0a\x83\x07\x1a\x48\x03\x01\x60\xbd\x03\x01\x2f\x2a\x82\x60\xa9\x82\x34\x9e" },
  { 5752, 2, 16, "\x01\x01\x82\x38\x8e\x83\x02\x54\x4f\x83\x0b\x68\x86\x83\x23\x3a\xef\x83\x51\x43\x38\x83\x96\x00\x66\x83\xdc\x76\x04\x83\xfb\x8d\x16\x83\xdc\x76\x04\x83\x96\x00\x66\x83\x51\x43\x38\x83\x23\x3a\xef\x83\x0b\x68\x86\x83\x02\x54\x4f\x82\x38\x8e" },
  { 5812, 2, 14, "\x81\x01\x84\x0d\xdf\x9f\xb5\x04\x0f\x1c\x84\xf0\x84\x77\xda\xf7\x55\x04\x22\xa9\x4e\x8e\x85\x01\x65\x52\xbd\xef\x04\x05\xaa\xf5\xad\x85\x01\xbf\xcf\x01\x0e\x84\x05\xaa\xf5\xad\x85\x01\x65\x52\xbd\xef\x84\x22\xa9\x4e\x8e\x84\x77\xda\xf7\x55\x84\x0f\x1c\x84\xf0\x84\x0d\xdf\x9f\xb5" },
  { 5848, 2, 16, "\x01\x01\x02\x3d\x78\x02\x57\x32\x03\x01\xa6\x20\x03\x05\x7b\x49\x03\x03\xd3\x60\x03\x01\x1a\x42\x03\x05\x84\x38\x83\x05\x7e\x6c\x83\x05\x84\x38\x03\x01\x1a\x42\x83\x03\xd3\x60\x03\x05\x7b\x49\x83\x01\xa6\x20\x02\x57\x32\x82\x3d\x78" },
  { 5860, 2, 16, "\x01\x01\x82\x3e\x13\x83\x01\x70\x45\x83\x01\x2b\xfc\x83\x02\xaf\xb0\x83\x07\xb4\x76\x83\x0b\xda\xdb\x83\x0e\x42\x7b\x83\x17\xcc\x62\x83\x0e\x42\x7b\x83\x0b\xda\xdb\x83\x07\xb4\x76\x83\x02\xaf\xb0\x83\x01\x2b\xfc\x83\x01\x70\x45\x82\x3e\x13" },
  { 5896, 2, 16, "\x01\x01\x82\x40\x08\x82\x44\x3a\x83\x05\x61\xe4\x03\x0d\xcc\x69\x83\x06\x30\xd8\x83\x13\x17\x12\x03\x36\x7a\xc4\x83\x4a\xb2\x3c\x03\x36\x7a\xc4\x83\x13\x17\x12\x83\x06\x30\xd8\x03\x0d\xcc\x69\x83\x05\x61\xe4\x82\x44\x3a\x82\x40\x08" },
  { 5908, 2, 16, "\x01\x01\x04\x10\x59\x3d\x56\x04\x6f\xc9\xcf\xf7\x84\xf3\x43\xde\xce\x05\x01\x51\x71\x58\xb1\x85\x03\x3a\x06\xa5\xc8\x05\x02\x83\x2a\x05\x5e\x85\x02\x61\xce\x96\xc4\x05\x01\xd2\xf4\xe5\x82\x05\x02\x61\xce\x96\xc4\x05\x02\x83\x2a\x05\x5e\x05\x03\x3a\x06\xa5\xc8\x05\x01\x51\x71\x58\xb1\x04\xf3\x43\xde\xce\x04\x6f\xc9\xcf\xf7\x84\x10\x59\x3d\x56" },
  { 5992, 2, 16, "\x01\x01\x02\x45\x7e\x03\x01\x5a\xbf\x03\x02\x8e\x2a\x03\x03\x7d\x71\x03\x02\xe9\x98\x03\x01\xe8\xbe\x83\x03\xba\xb4\x83\x03\x84\xae\x03\x03\xba\xb4\x03\x01\xe8\xbe\x83\x02\xe9\x98\x03\x03\x7d\x71\x83\x02\x8e\x2a\x03\x01\x5a\xbf\x82\x45\x7e" },
  { 6040, 2, 16, "\x01\x01\x02\x48\x56\x82\x9c\x43\x83\x03\x48\x92\x83\x0b\x9c\xe7\x03\x0b\x75\xf4\x03\x0e\x5a\x6a\x83\x0d\x28\x10\x83\x17\x2c\x86\x03\x0d\x28\x10\x03\x0e\x5a\x6a\x83\x0b\x75\xf4\x83\x0b\x9c\xe7\x03\x03\x48\x92\x82\x9c\x43\x82\x48\x56" },
  { 6052, 2, 16, "\x01\x01\x82\x49\x15\x02\x3c\x3f\x82\xe4\x4c\x03\x01\x65\xf4\x83\x02\x12\x82\x03\x02\x47\x61\x82\x6f\x1d\x02\xce\xd6\x82\x6f\x1d\x03\x02\x47\x61\x83\x02\x12\x82\x03\x01\x65\xf4\x82\xe4\x4c\x02\x3c\x3f\x82\x49\x15" },
  { 6148, 2, 16, "\x01\x01\x82\x4f\x35\x02\x7d\x57\x83\x01\xaf\xc0\x03\x01\xcf\x1b\x83\x01\x8e\x95\x82\x31\xd2\x03\x02\xe0\xab\x83\x05\xb4\x84\x03\x02\xe0\xab\x82\x31\xd2\x83\x01\x8e\x95\x03\x01\xcf\x1b\x83\x01\xaf\xc0\x02\x7d\x57\x82\x4f\x35" },
  { 6232, 2, 12, "\x01\x01\x02\x54\xec\x82\xf7\x90\x82\x17\x0c\x03\x02\xeb\x78\x83\x01\x17\x74\x83\x03\xf3\x6e\x03\x01\x17\x74\x03\x02\xeb\x78\x02\x17\x0c\x82\xf7\x90\x82\x54\xec" },
  { 6328, 2, 16, "\x01\x01\x82\x5b\xf2\x02\x58\xa1\x03\x01\xf3\x86\x02\xb0\xd1\x02\x01\xf8\x03\x06\x95\x9a\x03\x04\x52\x04\x83\x01\x88\x76\x03\x04\x52\x04\x03\x06\x95\x9a\x02\x01\xf8\x02\xb0\xd1\x03\x01\xf3\x86\x02\x58\xa1\x82\x5b\xf2" },
  { 6388, 2, 14, "\x81\x01\x84\x24\x70\x44\xf3\x04\x86\x7a\xda\x01\x85\x02\x00\xb5\xd2\x48\x05\x03\x9c\xf1\xfe\xa8\x04\x9a\xfd\xd6\x48\x85\x08\x53\x12\x43\x0e\x05\x01\xdb\xf1\x83\xb6\x05\x08\x53\x12\x43\x0e\x04\x9a\xfd\xd6\x48\x85\x03\x9c\xf1\xfe\xa8\x85\x02\x00\xb5\xd2\x48\x84\x86\x7a\xda\x01\x84\x24\x70\x44\xf3" },
  { 6472, 2, 12, "\x01\x01\x82\x67\x6b\x83\x01\xfd\x01\x83\x04\xb2\xdc\x83\x07\x0b\xdb\x83\x07\xd0\x79\x83\x07\xc1\xca\x83\x07\xd0\x79\x83\x07\x0b\xdb\x83\x04\xb2\xdc\x83\x01\xfd\x01\x82\x67\x6b" },
  { 6532, 2, 16, "\x01\x01\x82\x6c\xa0\x03\x02\xc8\xc8\x83\x09\x80\x50\x03\x16\x9a\x4a\x83\x29\xe5\x30\x03\x3f\xed\xb0\x83\x52\x46\xf0\x03\x59\x90\xeb\x83\x52\x46\xf0\x03\x3f\xed\xb0\x83\x29\xe5\x30\x03\x16\x9a\x4a\x83\x09\x80\x50\x03\x02\xc8\xc8\x82\x6c\xa0" },
  { 6568, 2, 14, "\x81\x01\x82\x6f\xd1\x82\xfe\x5a\x82\xd6\x23\x02\x10\x95\x02\x08\x6a\x02\x55\xa7\x03\x01\x2c\x69\x82\x55\xa7\x02\x08\x6a\x82\x10\x95\x82\xd6\x23\x02\xfe\x5a\x82\x6f\xd1" },
  { 6580, 2, 16, "\x01\x01\x04\x31\xc9\x77\xe4\x05\x08\x33\x87\x34\x8e\x05\x2c\x21\xb3\x3c\x98\x85\x9a\x9c\xd9\xee\x17\x06\x02\x5b\xc4\xae\xbb\xa0\x06\x02\x80\xed\xbd\xda\x2e\x06\x07\x66\x46\x48\xa7\xec\x86\x03\x55\x5d\x90\x78\x4c\x86\x07\x66\x46\x48\xa7\xec\x06\x02\x80\xed\xbd\xda\x2e\x86\x02\x5b\xc4\xae\xbb\xa0\x85\x9a\x9c\xd9\xee\x17\x85\x2c\x21\xb3\x3c\x98\x05\x08\x33\x87\x34\x8e\x84\x31\xc9\x77\xe4" },
  { 6628, 2, 16, "\x01\x01\x82\x75\x5a\x02\xb0\x6f\x82\x5c\xe2\x83\x09\xd1\xc3\x83\x0a\x5a\x38\x03\x12\xaf\x2a\x83\x03\xf4\x5c\x83\x2e\x84\x4e\x83\x03\xf4\x5c\x03\x12\xaf\x2a\x83\x0a\x5a\x38\x83\x09\xd1\xc3\x82\x5c\xe2\x02\xb0\x6f\x82\x75\x5a" },
  { 6820, 2, 16, "\x01\x01\x82\x88\xc0\x83\x04\x27\x78\x83\x04\xa2\x10\x03\x05\x28\xaa\x03\x03\x31\xf0\x83\x08\x0b\x50\x01\x30\x03\x12\x3e\xcb\x01\x30\x83\x08\x0b\x50\x03\x03\x31\xf0\x03\x05\x28\xaa\x83\x04\xa2\x10\x83\x04\x27\x78\x82\x88\xc0" },
  { 6868, 2, 16, "\x01\x01\x04\x4e\xd9\x27\x4d\x84\x76\xa9\x0c\x63\x04\x2c\x7f\xed\x72\x05\x02\x95\x9e\x8e\xd5\x05\x03\x05\x8b\x97\x8f\x05\x06\x53\x77\x75\xf6\x05\x02\xaa\xe6\x62\x25\x05\x08\x10\x4b\x3d\x12\x85\x02\xaa\xe6\x62\x25\x05\x06\x53\x77\x75\xf6\x85\x03\x05\x8b\x97\x8f\x05\x02\x95\x9e\x8e\xd5\x84\x2c\x7f\xed\x72\x84\x76\xa9\x0c\x63\x84\x4e\xd9\x27\x4d" },
  { 6952, 2, 16, "\x01\x01\x02\x97\xc6\x83\x02\x50\x51\x03\x01\xad\x52\x03\x04\x69\x11\x83\x06\x9b\x18\x83\x03\x8f\xe2\x03\x09\x7e\xac\x03\x01\xba\x72\x83\x09\x7e\xac\x83\x03\x8f\xe2\x03\x06\x9b\x18\x03\x04\x69\x11\x83\x01\xad\x52\x83\x02\x50\x51\x82\x97\xc6" },
  { 7288, 2, 16, "\x01\x01\x82\xc4\xf8\x83\x03\x33\x06\x83\x07\x14\x30\x83\x0a\x12\x4f\x83\x0d\xa9\x10\x83\x0d\x9a\xa6\x83\x0e\xfc\x88\x83\x0c\x44\x7c\x83\x0e\xfc\x88\x83\x0d\x9a\xa6\x83\x0d\xa9\x10\x83\x0a\x12\x4f\x83\x07\x14\x30\x83\x03\x33\x06\x82\xc4\xf8" },
  { 7480, 2, 16, "\x01\x01\x82\xe4\x00\x83\x01\x43\x34\x03\x17\x7e\xa0\x83\x3c\xcd\xd6\x03\x26\x67\x60\x03\x7c\x29\x30\x84\x01\x70\x46\x60\x04\x01\xea\x61\xd3\x84\x01\x70\x46\x60\x03\x7c\x29\x30\x03\x26\x67\x60\x83\x3c\xcd\xd6\x03\x17\x7e\xa0\x83\x01\x43\x34\x82\xe4\x00" },
  { 7492, 2, 12, "\x01\x01\x82\xe6\x19\x03\x02\xfc\xd3\x83\x08\x26\x22\x03\x0e\x2c\x2f\x83\x13\xa3\x0d\x03\x16\xb1\x6a\x83\x13\xa3\x0d\x03\x0e\x2c\x2f\x83\x08\x26\x22\x03\x02\xfc\xd3\x82\xe6\x19" },
  { 7528, 2, 18, "\x81\x01\x82\xec\x6b\x03\x01\xf4\x77\x83\x0d\x0d\x26\x03\x04\x73\x7d\x83\x04\xd7\x27\x83\x17\xc9\x95\x83\x2c\xc9\x5e\x03\x1c\x32\x16\x83\x02\x30\xd4\x83\x1c\x32\x16\x83\x2c\xc9\x5e\x03\x17\xc9\x95\x83\x04\xd7\x27\x83\x04\x73\x7d\x83\x0d\x0d\x26\x83\x01\xf4\x77\x82\xec\x6b" },
  { 7540, 2, 16, "\x01\x01\x04\xde\x56\x26\xc8\x05\x29\xd9\x17\x9c\x9e\x05\x22\x00\xd6\x41\x50\x86\x01\x86\x3c\xde\x70\xaf\x85\xd7\x6d\x92\x93\x70\x06\x04\x5f\xc8\xd8\x12\xfe\x06\x02\xf0\x81\x64\x81\x48\x86\x05\xba\xbc\x13\x2c\xdc\x86\x02\xf0\x81\x64\x81\x48\x06\x04\x5f\xc8\xd8\x12\xfe\x05\xd7\x6d\x92\x93\x70\x86\x01\x86\x3c\xde\x70\xaf\x85\x22\x00\xd6\x41\x50\x05\x29\xd9\x17\x9c\x9e\x84\xde\x56\x26\xc8" },
  { 7588, 2, 16, "\x01\x01\x82\xf7\x5e\x03\x04\x16\x52\x03\x01\x1f\x84\x83\x0b\xf3\x23\x83\x05\x7f\x6c\x03\x13\x8d\xe6\x03\x06\x96\x36\x83\x0e\x7c\x0c\x03\x06\x96\x36\x03\x13\x8d\xe6\x83\x05\x7f\x6c\x83\x0b\xf3\x23\x03\x01\x1f\x84\x03\x04\x16\x52\x82\xf7\x5e" },
  { 7672, 2, 16, "\x01\x01\x83\x01\x07\x6a\x83\x01\x61\xf7\x03\x06\x49\xfe\x03\x19\x68\xf1\x03\x30\x97\x68\x03\x3d\x24\x7a\x03\x37\xd0\xc4\x03\x31\x08\x5a\x03\x37\xd0\xc4\x03\x3d\x24\x7a\x03\x30\x97\x68\x03\x19\x68\xf1\x03\x06\x49\xfe\x83\x01\x61\xf7\x83\x01\x07\x6a" },
  { 7780, 2, 16, "\x01\x01\x83\x01\x1d\x6d\x83\x0e\xfb\xd4\x83\x57\xd1\x21\x84\x01\x82\x38\x6f\x84\x04\x4e\x51\xd4\x84\x08\xdf\xa8\x36\x84\x0d\x65\xdc\x9e\x84\x0f\x66\x11\x10\x84\x0d\x65\xdc\x9e\x84\x08\xdf\xa8\x36\x84\x04\x4e\x51\xd4\x84\x01\x82\x38\x6f\x83\x57\xd1\x21\x83\x0e\xfb\xd4\x83\x01\x1d\x6d" },
  { 7828, 2, 16, "\x01\x01\x05\x01\x55\xd1\x7c\x28\x05\x0d\x0f\xcb\x9d\x7e\x05\x35\x22\x53\x13\xf0\x05\x5c\x60\x7d\xfe\x31\x05\x40\xe4\xfc\x01\x10\x85\x03\x17\xa6\x46\xe2\x05\x2a\x94\x82\x9b\x08\x05\x45\x46\xba\x8f\x64\x85\x2a\x94\x82\x9b\x08\x85\x03\x17\xa6\x46\xe2\x85\x40\xe4\xfc\x01\x10\x05\x5c\x60\x7d\xfe\x31\x85\x35\x22\x53\x13\xf0\x05\x0d\x0f\xcb\x9d\x7e\x85\x01\x55\xd1\x7c\x28" },
  { 7912, 2, 12, "\x01\x01\x03\x01\x3a\xba\x02\x49\x43\x03\x01\xda\xbe\x02\xb9\xeb\x02\x13\x24\x03\x01\xb4\xa2\x82\x13\x24\x02\xb9\xeb\x83\x01\xda\xbe\x02\x49\x43\x83\x01\x3a\xba" },
  { 8008, 2, 16, "\x01\x01\x83\x01\x51\xb0\x82\x96\x8a\x03\x12\x77\x58\x03\x1b\x7d\x59\x83\x2d\xb0\xa0\x83\x67\x3f\x1a\x03\x1b\xaa\xb8\x03\x9a\xb1\x14\x03\x1b\xaa\xb8\x83\x67\x3f\x1a\x83\x2d\xb0\xa0\x03\x1b\x7d\x59\x03\x12\x77\x58\x82\x96\x8a\x83\x01\x51\xb0" },
  { 8068, 2, 12, "\x01\x01\x83\x01\x60\xcb\x83\x05\xb7\xb6\x83\x0a\xb4\xff\x83\x09\x95\x02\x83\x01\x51\xa3\x03\x03\xfd\xd6\x83\x01\x51\xa3\x83\x09\x95\x02\x83\x0a\xb4\xff\x83\x05\xb7\xb6\x83\x01\x60\xcb" },
  { 8152, 2, 18, "\x81\x01\x83\x01\x77\x04\x03\x01\x39\x00\x83\x06\xb4\xd2\x03\x01\xa7\x20\x83\x11\xbb\x64\x82\x4d\xc9\x83\x1d\xc0\x88\x03\x02\x92\xe0\x83\x23\xae\xf4\x83\x02\x92\xe0\x83\x1d\xc0\x88\x02\x4d\xc9\x83\x11\xbb\x64\x83\x01\xa7\x20\x83\x06\xb4\xd2\x83\x01\x39\x00\x83\x01\x77\x04" },
  { 8248, 2, 12, "\x01\x01\x83\x01\x91\xf4\x83\x04\x6c\x80\x83\x02\xf5\x08\x82\x59\x88\x83\x07\x7e\x5c\x83\x0e\x6e\x86\x83\x07\x7e\x5c\x82\x59\x88\x83\x02\xf5\x08\x83\x04\x6c\x80\x83\x01\x91\xf4" },
  { 8452, 2, 16, "\x01\x01\x83\x01\xd1\x37\x03\x04\x00\x6a\x83\x1d\x6c\xe9\x03\x6c\x31\x27\x83\xce\xe6\x2c\x04\x01\x2c\x16\xd0\x84\x01\x9d\x51\xd8\x04\x01\xde\x4b\x84\x84\x01\x9d\x51\xd8\x04\x01\x2c\x16\xd0\x83\xce\xe6\x2c\x03\x6c\x31\x27\x83\x1d\x6c\xe9\x03\x04\x00\x6a\x83\x01\xd1\x37" },
  { 8488, 2, 18, "\x81\x01\x83\x01\xdd\x47\x83\x03\x74\x4e\x83\x01\x87\x91\x83\x07\x24\x2b\x03\x03\x38\xe2\x03\x1b\xd1\x39\x83\x12\xbd\xff\x03\x0c\x07\x57\x83\x2c\x5c\x16\x83\x0c\x07\x57\x83\x12\xbd\xff\x83\x1b\xd1\x39\x03\x03\x38\xe2\x03\x07\x24\x2b\x83\x01\x87\x91\x03\x03\x74\x4e\x83\x01\xdd\x47" },
  { 8548, 2, 16, "\x01\x01\x83\x01\xf2\x06\x03\x03\xcc\x6a\x83\x0b\x85\xc8\x03\x10\xd7\xcd\x83\x1e\x12\xd4\x03\x23\x32\x46\x83\x2f\x46\x9e\x03\x2c\x54\x84\x83\x2f\x46\x9e\x03\x23\x32\x46\x83\x1e\x12\xd4\x03\x10\xd7\xcd\x83\x0b\x85\xc8\x03\x03\xcc\x6a\x83\x01\xf2\x06" },
  { 8680, 2, 16, "\x01\x01\x03\x02\x22\x98\x83\x03\x83\xaa\x83\x59\x8e\xd0\x83\xaf\xb5\xc7\x83\x29\x39\xe0\x03\x19\x7e\x86\x03\x3f\x10\x88\x04\x01\x19\x30\xd4\x83\x3f\x10\x88\x03\x19\x7e\x86\x03\x29\x39\xe0\x83\xaf\xb5\xc7\x03\x59\x8e\xd0\x83\x03\x83\xaa\x83\x02\x22\x98" },
  { 8932, 2, 16, "\x01\x01\x83\x02\x8b\xa2\x82\x54\xf9\x03\x1a\xf5\x02\x03\x3b\xa7\xe5\x03\x33\xd6\x5c\x82\xb7\x06\x03\x71\x46\x00\x04\x01\x07\x6d\xba\x03\x71\x46\x00\x82\xb7\x06\x03\x33\xd6\x5c\x03\x3b\xa7\xe5\x03\x1a\xf5\x02\x82\x54\xf9\x83\x02\x8b\xa2" },
  { 8968, 2, 16, "\x01\x01\x83\x02\x9c\x10\x83\x02\xb2\x8a\x02\x65\x04\x03\x01\x32\x79\x03\x05\xfd\xa8\x03\x09\x8a\xde\x83\x04\x16\x1c\x83\x15\x96\x9c\x83\x04\x16\x1c\x03\x09\x8a\xde\x03\x05\xfd\xa8\x03\x01\x32\x79\x02\x65\x04\x83\x02\xb2\x8a\x83\x02\x9c\x10" },
  { 9172, 2, 14, "\x81\x01\x85\x09\x03\xab\xe0\x82\x05\x0e\x56\x1c\xbc\x96\x05\x30\x99\x96\xfe\xd0\x85\x14\xc5\x1e\x63\x80\x85\xd3\xea\x77\xbc\x2e\x05\x3a\x15\x31\x96\x99\x05\xff\xb8\xe2\xaf\xc0\x85\x3a\x15\x31\x96\x99\x85\xd3\xea\x77\xbc\x2e\x05\x14\xc5\x1e\x63\x80\x05\x30\x99\x96\xfe\xd0\x85\x0e\x56\x1c\xbc\x96\x85\x09\x03\xab\xe0\x82" },
  { 9208, 2, 16, "\x01\x01\x83\x03\x13\xbc\x83\x02\x0b\x86\x83\x3b\xed\xb8\x03\x36\x6e\x29\x83\xcf\xe7\xc0\x03\x88\xa8\x7a\x83\xf7\xd9\x4c\x04\x01\xfe\xc7\xd4\x83\xf7\xd9\x4c\x03\x88\xa8\x7a\x83\xcf\xe7\xc0\x03\x36\x6e\x29\x83\x3b\xed\xb8\x83\x02\x0b\x86\x83\x03\x13\xbc" },
  { 9412, 2, 16, "\x01\x01\x83\x03\x88\xa6\x03\x02\x82\x8f\x03\x17\x82\xa2\x83\x11\x13\x03\x83\x2f\xa7\x88\x03\x20\xd1\xea\x83\x11\xb4\xe4\x83\x7f\xfe\x0e\x83\x11\xb4\xe4\x03\x20\xd1\xea\x83\x2f\xa7\x88\x83\x11\x13\x03\x03\x17\x82\xa2\x03\x02\x82\x8f\x83\x03\x88\xa6" },
  { 9508, 2, 16, "\x01\x01\x83\x03\xc5\x07\x03\x0b\xc2\xde\x83\x20\x93\xa9\x03\x42\x42\x4f\x83\x6d\x73\x7c\x03\x9c\x4f\x88\x83\xc1\x29\x78\x03\xcb\xfb\x4c\x83\xc1\x29\x78\x03\x9c\x4f\x88\x83\x6d\x73\x7c\x03\x42\x42\x4f\x83\x20\x93\xa9\x03\x0b\xc2\xde\x83\x03\xc5\x07" },
  { 9640, 2, 16, "\x01\x01\x03\x04\x1e\x0e\x83\x2c\x12\xa9\x03\x38\xb5\x5a\x83\x05\xfa\xef\x83\x1d\x62\x08\x83\x6c\x70\x02\x03\x5a\x5c\xac\x83\x0e\x54\xbe\x83\x5a\x5c\xac\x83\x6c\x70\x02\x03\x1d\x62\x08\x83\x05\xfa\xef\x83\x38\xb5\x5a\x83\x2c\x12\xa9\x83\x04\x1e\x0e" },
  { 9832, 2, 18, "\x81\x01\x83\x04\xad\x45\x83\x02\xd4\xb0\x83\x17\x7d\x45\x03\x01\x76\x88\x83\x24\x3c\x45\x03\x09\x96\xeb\x03\x08\xf2\x1a\x03\x04\xb4\x38\x03\x33\xfe\x9a\x83\x04\xb4\x38\x03\x08\xf2\x1a\x83\x09\x96\xeb\x83\x24\x3c\x45\x83\x01\x76\x88\x83\x17\x7d\x45\x03\x02\xd4\xb0\x83\x04\xad\x45" },
  { 10168, 2, 16, "\x01\x01\x83\x05\xd3\xc6\x03\x0a\xab\x89\x03\x17\x96\xb2\x83\x3b\x12\x0f\x83\x1b\x94\xc8\x03\x7c\x61\x3a\x02\xa9\xbc\x83\x85\x9c\xe6\x02\xa9\xbc\x03\x7c\x61\x3a\x83\x1b\x94\xc8\x83\x3b\x12\x0f\x03\x17\x96\xb2\x03\x0a\xab\x89\x83\x05\xd3\xc6" },
  { 10312, 2, 16, "\x01\x01\x83\x06\x65\x61\x83\x03\xe2\x95\x83\x01\xfe\x84\x83\x19\x07\xe1\x83\x35\x25\xc9\x83\x62\x50\x26\x83\x98\xfb\xad\x83\x8b\xca\xdc\x83\x98\xfb\xad\x83\x62\x50\x26\x83\x35\x25\xc9\x83\x19\x07\xe1\x83\x01\xfe\x84\x83\x03\xe2\x95\x83\x06\x65\x61" },
  { 11608, 2, 18, "\x81\x01\x83\x0e\x62\xd4\x03\x19\x58\xa0\x83\x31\xbf\x4a\x03\x16\x6e\x00\x03\x50\xb8\x0c\x83\x78\xa6\x79\x83\x99\x95\x28\x03\xb1\x55\x20\x03\xd6\xf6\xbc\x83\xb1\x55\x20\x83\x99\x95\x28\x03\x78\xa6\x79\x03\x50\xb8\x0c\x83\x16\x6e\x00\x83\x31\xbf\x4a\x83\x19\x58\xa0\x83\x0e\x62\xd4" },
  { 12868, 2, 16, "\x01\x01\x83\x1e\x53\x27\x83\x37\x44\xb9\x83\x7d\x94\xdc\x83\x0c\xe0\xc1\x83\x50\x07\xab\x03\x4c\x85\x66\x84\x01\x25\xf7\x63\x83\x73\x11\xf8\x84\x01\x25\xf7\x63\x03\x4c\x85\x66\x83\x50\x07\xab\x83\x0c\xe0\xc1\x83\x7d\x94\xdc\x83\x37\x44\xb9\x83\x1e\x53\x27" },
  { 13288, 2, 16, "\x01\x01\x03\x26\x90\xaa\x83\x7d\x69\x41\x03\x60\x3c\xee\x83\x8c\x4d\x8f\x03\x1e\xdb\xe8\x03\x07\xd8\x9e\x03\x41\xa4\xe4\x83\xd2\x10\x8e\x83\x41\xa4\xe4\x03\x07\xd8\x9e\x83\x1e\xdb\xe8\x83\x8c\x4d\x8f\x83\x60\x3c\xee\x83\x7d\x69\x41\x83\x26\x90\xaa" },
  { 14008, 2, 16, "\x01\x01\x83\x39\xba\x96\x03\x44\x04\xc9\x83\x51\xd6\x9e\x04\x01\x05\x67\xb1\x83\x14\xb9\xc8\x03\x88\xcc\x7a\x83\x9d\xe5\x64\x83\x8a\x72\x66\x83\x9d\xe5\x64\x03\x88\xcc\x7a\x83\x14\xb9\xc8\x04\x01\x05\x67\xb1\x83\x51\xd6\x9e\x03\x44\x04\xc9\x83\x39\xba\x96" },
};
#define NUM_CLASS_POLYS (sizeof(_class_poly_data)/sizeof(_class_poly_data[0]))
