/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.caucho;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mx4j.tools.remote.caucho.CauchoInput;
import mx4j.tools.remote.caucho.CauchoOutput;
import mx4j.tools.remote.caucho.CauchoService;

public abstract class CauchoServlet
extends HttpServlet {
    private Map methods;
    static /* synthetic */ Class class$mx4j$tools$remote$http$HTTPConnection;

    public void init() throws ServletException {
        this.methods = new HashMap();
        this.mapMethods(class$mx4j$tools$remote$http$HTTPConnection == null ? (class$mx4j$tools$remote$http$HTTPConnection = CauchoServlet.class$("mx4j.tools.remote.http.HTTPConnection")) : class$mx4j$tools$remote$http$HTTPConnection, this.methods);
    }

    protected void mapMethods(Class cls, Map methods) {
        Method[] mthds = cls.getMethods();
        for (int i = 0; i < mthds.length; ++i) {
            Method mthd = mthds[i];
            String key = this.mangleMethodName(mthd);
            methods.put(key, mthd);
        }
    }

    protected Method findMethod(String methodName) {
        return (Method)this.methods.get(methodName);
    }

    protected String mangleMethodName(Method method) {
        return CauchoService.mangleMethodName(method);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new ServletException("Caucho protocol requires POST");
        }
        BufferedInputStream is = new BufferedInputStream(request.getInputStream(), 48);
        CauchoInput input = this.createCauchoInput(is);
        BufferedOutputStream bos = new BufferedOutputStream(response.getOutputStream(), 48);
        CauchoOutput output = this.createCauchoOutput(bos);
        this.invoke(request, input, output);
        bos.flush();
    }

    protected abstract CauchoInput createCauchoInput(InputStream var1);

    protected abstract CauchoOutput createCauchoOutput(OutputStream var1);

    protected abstract Object getService();

    protected void invoke(HttpServletRequest request, CauchoInput input, CauchoOutput output) throws IOException {
        input.startCall();
        Map headers = this.readHeaders(input);
        String methodName = input.readMethod();
        Method method = this.findMethod(methodName);
        if (method == null) {
            output.startReply();
            NoSuchMethodException x = new NoSuchMethodException(methodName);
            output.writeFault(x);
            output.completeReply();
        } else {
            Object[] values = this.readArguments(input, method);
            input.completeCall();
            Object result = null;
            try {
                result = this.invoke(request.getRequestURL().toString(), this.getService(), method, headers, values);
            }
            catch (Throwable x) {
                output.startReply();
                output.writeFault(x);
                output.completeReply();
                return;
            }
            output.startReply();
            output.writeObject(result);
            output.completeReply();
        }
    }

    protected Map readHeaders(CauchoInput input) throws IOException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        String header = null;
        while ((header = input.readHeader()) != null) {
            headers.put(header, input.readObject(null));
        }
        return headers;
    }

    protected Object[] readArguments(CauchoInput input, Method method) throws IOException {
        Class<?>[] types = method.getParameterTypes();
        Object[] values = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            values[i] = input.readObject(types[i]);
        }
        return values;
    }

    protected Object invoke(String url, Object target, Method method, Map headers, Object[] values) throws Exception {
        if (target == null) {
            throw new IOException("Service is not available");
        }
        String connectionId = (String)headers.get("connectionContext");
        CauchoService.setConnectionContext(url, connectionId);
        try {
            Object object = method.invoke(target, values);
            return object;
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
        finally {
            CauchoService.resetConnectionContext();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

