
require '../VRMLFields.pm';

@Fields = qw/
	SFColor
	SFBool
	SFFloat
	SFTime
/;

for(@Fields) {
	my $c = $_;
	my $p = "VRML::Field::$_";
	open O, ">fields/$_.java";
	open OC, ">fields/Const$_.java";
	$str = "// GENERATED BY genfields.pl. DO NOT EDIT!\npackage vrml.field;\nimport vrml.*;\nimport java.util.*;\n\n";
	print O $str; print OC $str;
	
	print O "public class $_ extends Field {\n";
	print OC "public class Const$_ extends ConstField {\n";

	$str = $p->jdata."\n";
	print O $str; print OC $str;

	my $alloc = $p->jalloc;
	my $set = $p->jset;
	while(($args, $s) = each %$set) {
		print O "public $c($args) {$alloc $s}\n";
		if($args) {
			print OC "public Const$c($args) {$alloc $s}\n";
			print O "public void setValue($args) {$s value_touched();}\n";
		}
	}

	# Construct from string
	print O "public $c(String s) throws Exception {
		$alloc;
		if(s == null) {
			$set->{''}; return;
		}
		s = s.trim();
		".$p->jset_str."
	}";
	print OC "public Const$c(String s) throws Exception {
		$alloc;
		if(s == null) {
			$set->{''}; return;
		}
		s = s.trim();
		".$p->jset_str."
	}";


	my $get = $p->jget;
	while(($type, $s) = each %$get) {
		$args = "";
		if(ref $s) {$args = $s->[0]; $s = $s->[1]}
		$str = "public $type getValue($args) {$s}\n";
		print O $str; print OC $str;
	}
	my $get = $p->jsimpleget;
	while(($name, $type) = each %$get) {
		my $n = ucfirst $name;
		$str = "public $type get$n() {return $name;}\n";
		print O $str; print OC $str;
	}

	# Copy 
	my $copy = $p->jcopy;
	print O "public void setValue(Const$_ f) {$copy value_touched();}
		public void setValue($_ f) {$copy value_touched(); }\n";

	$str = "public String toString() {".$p->jstr."}";
	print O $str; print OC $str;

	print O "public Object clone() {$c _x = new $c(".$p->jclonearg."); return _x;}";
	print OC "public Object clone() {Const$c _x = new Const$c(".$p->jclonearg."); return _x;}";
		 
	print O "}";
	print OC "}";
	close O;
	close OC;
}
