package Bundle::Sledge;

use strict;
use vars qw($VERSION);
$VERSION = 0.01;

1;
__END__

=head1 NAME

Bundle::Sledge - Bundle to install all Sledge related modules

=head1 SYNOPSIS

  perl -MCPAN -e 'install Bundle::Sledge'

=head1 CONTENTS

Apache::Request - Methods for dealing with client request

Apache::Reload - Reload changed modules

Test::Inline - Inlining your tests next to the code being

Carp::Assert - executable comments

Class::Fields - Inspect the fields of a class.

Class::Accessor - Automated accessor generation

Class::Data::Inheritable - Inheritable, overridable class

Class::Singleton - Implementation of a "Singleton" class

Class::Trigger - Mixin to add / call inheritable triggers

Digest::SHA1 - Perl interface to the SHA-1 Algorithm

File::Spec - portably perform operations on file names

File::Temp - return name and handle of a temporary file

HTML::FillInForm - Populates HTML Forms with CGI data.

HTML::Template - Perl module to use HTML Templates from

HTML::StickyQuery - add sticky QUERY_STRING

IO::Stringy - I/O on in-core objects like strings and arrays

Jcode - Japanese Charset Handler

Test::Simple - Basic utilities for writing tests.

Test::Harness - run perl standard test scripts with

Time::HiRes - High resolution alarm, sleep, gettimeofday,

URI - Uniform Resource Identifiers (absolute and relative)

Errno - System errno constants

Template - Front-end module to the Template Toolkit

Data::Properties - persistent properties

Error 0.15 - Error/exception handling in an OO-ish way

=head1 DESCRIPTION

Sledge is yet another MVC Web Application Framework.

Bundle::Sledge is a bundle to install all Sledge related modules. See
http://sl.edge.jp/ (Japanese) or
http://sourceforge.jp/projects/sledge to get more detailed
information on Sledge.

=head1 AUTHOR

Tatsuhiko Miyagawa E<lt>miyagawa@bulknews.netE<gt>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

http://sl.edge.jp/

http://sourceforge.jp/projects/sledge

=cut
