/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 35 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };


#line 34 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqliteParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqliteParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqliteParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqliteParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqliteParserARG_STORE     Code to store %extra_argument into yypParser
**    sqliteParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 219
#define YYACTIONTYPE unsigned short int
#define sqliteParserTOKENTYPE Token
typedef union {
  sqliteParserTOKENTYPE yy0;
  Select* yy11;
  int yy52;
  ExprList* yy62;
  IdList* yy92;
  Token yy210;
  struct TrigEvent yy234;
  Expr * yy270;
  struct {int value; int mask;} yy279;
  struct LimitVal yy280;
  Expr* yy334;
  SrcList* yy335;
  TriggerStep * yy347;
  int yy437;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqliteParserARG_SDECL Parse *pParse;
#define sqliteParserARG_PDECL ,Parse *pParse
#define sqliteParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqliteParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 555
#define YYNRULE 287
#define YYERRORSYMBOL 155
#define YYERRSYMDT yy437
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */   104,  258,  174,  219,  215,  347,  162,  129,   20,  131,
 /*    10 */     5,  174,  219,  295,  536,   62,   20,  325,  368,  103,
 /*    20 */   154,  221,  275,   22,   41,  474,  106,  355,  330,  327,
 /*    30 */    69,   22,  537,  535,  827,  106,  277,  275,   20,  530,
 /*    40 */   127,  168,  539,  106,   36,   37,  532,  352,  529,  123,
 /*    50 */   143,  371,  119,   22,  256,  531,  533,  458,  166,   20,
 /*    60 */   564,   21,  231,   95,  177,  143,  157,  156,  183,   21,
 /*    70 */    18,  121,  142,  225,   22,  133,  117,  185,  146,  125,
 /*    80 */   139,  161,   46,  351,   44,  473,  115,  142,  144,  289,
 /*    90 */   680,   21,   54,  152,  302,  357,   73,  220,  184,  135,
 /*   100 */   112,  340,  510,  150,  680,  148,  384,  257,  104,  106,
 /*   110 */    64,  332,   21,  443,  162,  129,   20,  131,   60,  111,
 /*   120 */   333,  363,  106,  389,    6,   67,    4,  435,  154,  386,
 /*   130 */    68,   22,  424,   29,  179,  337,  175,  368,  105,  341,
 /*   140 */   327,  353,  560,  154,  181,  334,  355,  193,  127,  129,
 /*   150 */   172,  131,   20,  174,  219,  229,   14,  123,  143,  502,
 /*   160 */   119,  286,  154,   66,  331,  154,  166,   22,  172,   21,
 /*   170 */   371,   69,  172,  171,  157,  156,  315,  106,  113,  121,
 /*   180 */   142,   69,  489,  133,  117,  245,  146,  125,  139,  161,
 /*   190 */   307,  171,  227,  380,  115,  171,  144,  137,  309,  797,
 /*   200 */   409,  152,   31,   15,  370,   21,  294,  135,  172,  410,
 /*   210 */   830,  150,  104,  148,  357,   16,  152,  133,  162,  129,
 /*   220 */   146,  131,  632,  146,  169,  173,  150,  455,  148,  228,
 /*   230 */   144,  171,  154,  144,  172,  152,  246,  247,  152,   10,
 /*   240 */   363,  135,  169,  256,  500,  150,  169,  148,  150,  450,
 /*   250 */   148,   62,  127,  325,   17,  643,   13,  171,   69,   20,
 /*   260 */   316,  123,  143,  343,  119,  327,  368,  312,  716,  437,
 /*   270 */   166,   20,  172,  250,   22,  355,  209,  779,  157,  156,
 /*   280 */   440,  442,  169,  121,  142,  248,   22,  133,  117,    8,
 /*   290 */   146,  125,  139,  161,  655,  171,  257,  555,  115,  371,
 /*   300 */   144,  385,   37,   32,  285,  152,  314,  116,  169,  241,
 /*   310 */   300,  135,   21,  174,  218,  150,  104,  148,   46,  172,
 /*   320 */    44,  293,  162,  129,   21,  131,  201,  258,   54,  279,
 /*   330 */   302,  106,  543,  710,    7,  103,  154,  106,  260,  242,
 /*   340 */   351,  416,  171,  357,  553,  106,  169,  528,   23,   69,
 /*   350 */   137,  268,  515,  388,   60,    1,  127,  239,  490,  106,
 /*   360 */    70,  549,  313,  189,  478,  123,  143,   25,  119,  363,
 /*   370 */   554,  275,    3,  205,  166,  256,  172,  172,   97,  653,
 /*   380 */   256,  540,  157,  156,  680,  195,  843,  121,  142,    9,
 /*   390 */   512,  133,  117,  169,  146,  125,  139,  161,  339,  171,
 /*   400 */   171,   10,  115,  552,  144,  483,  710,  104,  804,  152,
 /*   410 */   174,  219,  238,  162,  129,  135,  131,  338,  526,  150,
 /*   420 */    69,  148,  464,  514,  118,   27,  197,  154,  257,   73,
 /*   430 */   239,  437,  323,  257,  106,  177,  575,  832,  291,  183,
 /*   440 */   172,  788,  440,  438,  310,  778,  495,  127,  106,  524,
 /*   450 */   169,  169,  272,  322,  479,   83,  123,  143,  486,  119,
 /*   460 */   272,  266,  411,  171,  414,  166,  819,  270,  645,  481,
 /*   470 */    86,  112,  290,  157,  156,  270,  319,  420,  121,  142,
 /*   480 */    84,   64,  133,  117,  419,  146,  125,  139,  161,  444,
 /*   490 */   111,  423,  350,  115,  412,  144,   67,  292,  434,  163,
 /*   500 */   152,   68,  268,  283,   75,  179,  135,  175,   58,  105,
 /*   510 */   150,  473,  148,  104,  169,  181,  272,  431,  193,  162,
 /*   520 */   129,  390,  131,  106,  120,  396,  563,   73,  469,  382,
 /*   530 */   381,  270,  317,  154,   66,  106,  392,   59,   40,   38,
 /*   540 */   342,  177,  421,  329,  217,  183,  272,  374,  106,  113,
 /*   550 */   413,   73,  180,  127,  122,  272,  365,  324,  272,  360,
 /*   560 */    73,  270,  123,  143,   69,  119,  124,  268,   43,  306,
 /*   570 */   270,  166,  508,  270,  240,  507,  106,  112,  106,  157,
 /*   580 */   156,  467,  324,  375,  121,  142,  126,   64,  133,  117,
 /*   590 */   106,  146,  125,  139,  161,  178,  111,  243,  106,  115,
 /*   600 */   217,  144,   67,  253,  261,  583,  152,   68,  235,  128,
 /*   610 */   106,  179,  135,  175,  470,  105,  150,  130,  148,  106,
 /*   620 */   455,  181,  104,  191,  193,  230,  824,  224,  162,  129,
 /*   630 */    18,  131,  106,  106,  132,  165,  222,  449,  260,  134,
 /*   640 */    66,  106,  154,  136,  274,   65,  138,  217,  267,  269,
 /*   650 */   553,  106,  299,   19,  214,  113,   91,  781,  106,  106,
 /*   660 */   106,  212,  127,  106,  270,  470,   69,  106,  106,   12,
 /*   670 */   106,  123,  143,   69,  119,  141,  106,  278,  106,  280,
 /*   680 */   166,  216,  210,  284,  466,  106,   35,  453,  157,  156,
 /*   690 */   145,  268,  457,  121,  142,  472,  147,  133,  117,  106,
 /*   700 */   146,  125,  139,  161,  307,   49,  106,  287,  115,  552,
 /*   710 */   144,  106,  309,  260,  106,  152,  106,  149,  192,  151,
 /*   720 */   106,  135,  416,   89,  176,  150,  190,  148,  296,  153,
 /*   730 */   471,  104,  213,  406,  155,   52,  825,  162,  129,  369,
 /*   740 */   131,  106,  106,  106,  114,  405,  511,  159,  106,  158,
 /*   750 */   106,  154,  463,  106,  106,  415,   11,  106,  106,   69,
 /*   760 */    47,  268,  418,  106,   53,  418,  336,  631,  106,  796,
 /*   770 */   395,  127,  366,    2,  275,    3,   24,  170,  346,   30,
 /*   780 */   123,  143,   69,  119,  182,  335,  268,  521,  567,  166,
 /*   790 */   820,   26,  568,  387,   28,  569,  570,  157,  156,   33,
 /*   800 */    34,  574,  121,  142,   39,   42,  133,  117,  106,  146,
 /*   810 */   125,  139,  161,   10,  680,   51,   45,  115,   50,  144,
 /*   820 */    48,   55,   56,   57,  152,   61,   63,  584,  585,   73,
 /*   830 */   135,   71,   72,   74,  150,   76,  148,  104,  239,  236,
 /*   840 */    77,   78,  361,  162,  129,  234,  131,   79,   80,   93,
 /*   850 */    82,   88,   85,   81,   87,   90,   92,  154,   94,  345,
 /*   860 */    96,  100,   98,  101,  137,  102,  107,  432,   99,  108,
 /*   870 */   109,  140,  110,  154,  167,  659,  660,  127,  658,  160,
 /*   880 */   661,  211,  188,  186,  194,  187,  123,  143,  196,  119,
 /*   890 */   198,  199,  202,  200,  203,  166,  204,  206,  226,  207,
 /*   900 */   208,  177,  232,  157,  156,  183,  233,  237,  121,  142,
 /*   910 */   249,  217,  133,  117,  251,  146,  125,  139,  161,  244,
 /*   920 */   252,  254,  275,  115,  255,  144,  259,  273,  265,  263,
 /*   930 */   152,  264,  262,  271,  276,  282,  135,  112,  281,  288,
 /*   940 */   150,  321,  148,  298,  301,  304,  223,   64,  303,  308,
 /*   950 */   305,  328,  162,  129,  306,  131,  111,  348,  326,  311,
 /*   960 */   358,  780,   67,  349,  344,  359,  154,   68,  318,  320,
 /*   970 */   383,  179,  356,  175,  364,  105,  372,  373,  376,  378,
 /*   980 */   354,  181,   49,  362,  193,  367,  127,  377,  379,  391,
 /*   990 */   393,  394,  398,  397,  400,  123,  143,  401,  119,  407,
 /*  1000 */    66,  402,  403,  812,  166,  408,  817,  818,  422,  417,
 /*  1010 */   399,  425,  157,  156,  426,  113,  427,  121,  142,  404,
 /*  1020 */   433,  133,  117,  429,  146,  125,  139,  161,  786,  787,
 /*  1030 */   430,  428,  115,  436,  144,  439,  811,  441,  826,  152,
 /*  1040 */   447,  446,  448,  444,  451,  135,  445,  454,  452,  150,
 /*  1050 */   828,  148,  104,  456,  460,  459,  462,  461,  162,  129,
 /*  1060 */   468,  131,  465,  829,  475,  476,  831,  652,  480,  477,
 /*  1070 */   491,  485,  154,  654,  482,  484,  794,  487,  488,  837,
 /*  1080 */   492,  494,  493,  496,  709,  712,  497,  498,  501,  499,
 /*  1090 */   503,  504,  127,  505,  509,  506,  715,  513,  717,  718,
 /*  1100 */   516,  123,  143,  518,  119,  517,  519,  522,  520,  523,
 /*  1110 */   166,  795,  798,  527,  525,  799,  800,  801,  157,  156,
 /*  1120 */   802,  534,  805,  121,  142,  807,  541,  133,  117,  542,
 /*  1130 */   146,  125,  139,  161,  548,  544,  808,  538,  115,  806,
 /*  1140 */   144,  803,  546,  547,  838,  152,  841,  550,  545,  551,
 /*  1150 */   507,  135,  507,  507,  507,  150,  507,  148,  164,  507,
 /*  1160 */   507,  507,  507,  507,  162,  129,  507,  131,  507,  507,
 /*  1170 */   507,  507,  507,  507,  507,  507,  507,  507,  154,  507,
 /*  1180 */   507,  507,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1190 */   507,  507,  507,  507,  507,  507,  507,  507,  127,  507,
 /*  1200 */   507,  507,  507,  507,  507,  507,  507,  123,  143,  507,
 /*  1210 */   119,  507,  507,  507,  507,  507,  166,  507,  507,  507,
 /*  1220 */   507,  507,  507,  507,  157,  156,  507,  507,  507,  121,
 /*  1230 */   142,  507,  507,  133,  117,  507,  146,  125,  139,  161,
 /*  1240 */   507,  507,  507,  507,  115,  507,  144,  507,  507,  507,
 /*  1250 */   507,  152,  507,  507,  507,  507,  507,  135,  507,  507,
 /*  1260 */   507,  150,  507,  148,  104,  507,  507,  507,  507,  507,
 /*  1270 */   162,  129,  507,  131,  507,  507,  507,  507,  507,  507,
 /*  1280 */   507,  507,  507,  507,  154,  507,  507,  507,  507,  507,
 /*  1290 */   507,  507,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1300 */   507,  507,  507,  507,  127,  507,  507,  507,  507,  507,
 /*  1310 */   507,  507,  507,  123,  143,  507,  119,  507,  507,  507,
 /*  1320 */   507,  507,  166,  507,  507,  507,  507,  507,  507,  507,
 /*  1330 */   157,  156,  507,  507,  507,  121,  142,  507,  507,  133,
 /*  1340 */   117,  507,  146,  125,  139,  161,  507,  162,  129,  507,
 /*  1350 */   131,  507,  144,  507,  507,  507,  507,  152,  507,  507,
 /*  1360 */   507,  154,  507,  135,  507,  507,  507,  150,  507,  148,
 /*  1370 */   507,  507,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1380 */   507,  127,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1390 */   123,  143,  507,  119,  507,  507,  507,  507,  507,  166,
 /*  1400 */   507,  507,  507,  507,  507,  177,  507,  157,  156,  183,
 /*  1410 */   507,  507,  121,  142,  507,  507,  133,  117,  507,  146,
 /*  1420 */   125,  139,  161,  507,  507,  129,  507,  131,  507,  144,
 /*  1430 */   507,  507,  507,  507,  152,  507,  507,  507,  154,  507,
 /*  1440 */   135,  112,  507,  507,  150,  507,  148,  507,  507,  507,
 /*  1450 */   507,   64,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1460 */   111,  507,  507,  507,  507,  507,   67,  123,  507,  507,
 /*  1470 */   119,   68,  507,  507,  507,  179,  507,  175,  507,  105,
 /*  1480 */   507,  507,  507,  507,  507,  181,  507,  507,  193,  121,
 /*  1490 */   507,  507,  507,  133,  117,  507,  146,  507,  507,  507,
 /*  1500 */   507,  507,  297,  507,   66,  507,  144,  507,  507,  507,
 /*  1510 */   507,  152,  507,  507,  507,  507,  507,  135,  507,  113,
 /*  1520 */   507,  150,  507,  148,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */     5,    6,  157,  158,  159,  199,   11,   12,   59,   14,
 /*    10 */   106,  157,  158,  159,   49,   18,   59,   20,   18,  157,
 /*    20 */    25,   11,   39,   74,   27,   34,  181,   27,   31,   32,
 /*    30 */   185,   74,   83,   68,   43,  181,   79,   39,   59,   90,
 /*    40 */    45,  196,   93,  181,  142,  143,  179,  145,  181,   54,
 /*    50 */    55,   51,   57,   74,   59,  188,  189,   66,   63,   59,
 /*    60 */   106,  112,  200,  201,   13,   55,   71,   72,   17,  112,
 /*    70 */   116,   76,   77,   63,   74,   80,   81,  136,   83,   84,
 /*    80 */    85,   86,   85,  181,   87,  157,   91,   77,   93,  110,
 /*    90 */   107,  112,   95,   98,   97,   95,  105,   87,  157,  104,
 /*   100 */    49,   49,  174,  108,  106,  110,  204,  112,    5,  181,
 /*   110 */    59,   59,  112,  122,   11,   12,   59,   14,  121,   68,
 /*   120 */    68,  121,  181,  205,  138,   74,  140,  209,   25,    6,
 /*   130 */    79,   74,  214,  147,   83,   83,   85,   18,   87,   87,
 /*   140 */    32,   22,  106,   25,   93,   93,   27,   96,   45,   12,
 /*   150 */    46,   14,   59,  157,  158,  159,    1,   54,   55,  173,
 /*   160 */    57,  110,   25,  112,  112,   25,   63,   74,   46,  112,
 /*   170 */    51,  185,   46,   69,   71,   72,   16,  181,  127,   76,
 /*   180 */    77,  185,  196,   80,   81,   22,   83,   84,   85,   86,
 /*   190 */    82,   69,  196,   85,   91,   69,   93,  177,   90,  106,
 /*   200 */   102,   98,   79,   48,  184,  112,  103,  104,   46,  111,
 /*   210 */   106,  108,    5,  110,   95,   60,   98,   80,   11,   12,
 /*   220 */    83,   14,  103,   83,  120,  103,  108,  181,  110,  103,
 /*   230 */    93,   69,   25,   93,   46,   98,   73,   74,   98,   90,
 /*   240 */   121,  104,  120,   59,  198,  108,  120,  110,  108,   22,
 /*   250 */   110,   18,   45,   20,   99,  106,  101,   69,  185,   59,
 /*   260 */   100,   54,   55,   79,   57,   32,   18,  107,  106,  196,
 /*   270 */    63,   59,   46,   73,   74,   27,   42,   43,   71,   72,
 /*   280 */   207,  208,  120,   76,   77,   73,   74,   80,   81,  206,
 /*   290 */    83,   84,   85,   86,  106,   69,  112,    0,   91,   51,
 /*   300 */    93,  142,  143,  144,  131,   98,   31,  157,  120,   22,
 /*   310 */   103,  104,  112,  157,  158,  108,    5,  110,   85,   46,
 /*   320 */    87,  157,   11,   12,  112,   14,    1,    6,   95,  103,
 /*   330 */    97,  181,    8,  106,   10,  157,   25,  181,  165,   52,
 /*   340 */   181,   22,   69,   95,   47,  181,  120,   45,   24,  185,
 /*   350 */   177,   22,   28,   29,  121,  139,   45,  130,   34,  181,
 /*   360 */   196,   37,   87,  129,   40,   54,   55,   43,   57,  121,
 /*   370 */   154,   39,  156,   48,   63,   59,   46,   46,  200,  106,
 /*   380 */    59,   79,   71,   72,   52,   60,  170,   76,   77,  184,
 /*   390 */    66,   80,   81,  120,   83,   84,   85,   86,   49,   69,
 /*   400 */    69,   90,   91,  106,   93,   64,  106,    5,  106,   98,
 /*   410 */   157,  158,  159,   11,   12,  104,   14,   68,   94,  108,
 /*   420 */   185,  110,  103,   99,  157,  101,  101,   25,  112,  105,
 /*   430 */   130,  196,  103,  112,  181,   13,  106,  106,    4,   17,
 /*   440 */    46,   64,  207,  208,   34,   43,  122,   45,  181,  125,
 /*   450 */   120,  120,  166,  167,  113,   68,   54,   55,  117,   57,
 /*   460 */   166,  167,   34,   69,   88,   63,   90,  181,   70,  128,
 /*   470 */    83,   49,   38,   71,   72,  181,   66,    2,   76,   77,
 /*   480 */    93,   59,   80,   81,    9,   83,   84,   85,   86,   91,
 /*   490 */    68,  114,  165,   91,   66,   93,   74,  103,  121,  157,
 /*   500 */    98,   79,   22,  194,  195,   83,  104,   85,    7,   87,
 /*   510 */   108,  157,  110,    5,  120,   93,  166,  167,   96,   11,
 /*   520 */    12,  113,   14,  181,  157,  117,  106,  105,  174,  151,
 /*   530 */   152,  181,  122,   25,  112,  181,  128,   36,  132,  212,
 /*   540 */   213,   13,   67,  137,   22,   17,  166,  167,  181,  127,
 /*   550 */   122,  105,  157,   45,  157,  166,  167,  151,  166,  167,
 /*   560 */   105,  181,   54,   55,  185,   57,  157,   22,  137,  191,
 /*   570 */   181,   63,  126,  181,  157,  196,  181,   49,  181,   71,
 /*   580 */    72,  126,  151,  103,   76,   77,  157,   59,   80,   81,
 /*   590 */   181,   83,   84,   85,   86,  157,   68,  197,  181,   91,
 /*   600 */    22,   93,   74,  203,  131,   39,   98,   79,  157,  157,
 /*   610 */   181,   83,  104,   85,   22,   87,  108,  157,  110,  181,
 /*   620 */   181,   93,    5,  115,   96,  103,   10,  157,   11,   12,
 /*   630 */   116,   14,  181,  181,  157,  157,  157,  198,  165,  157,
 /*   640 */   112,  181,   25,  157,  157,   79,  157,   22,  103,  166,
 /*   650 */    47,  181,  157,  181,  157,  127,   22,  129,  181,  181,
 /*   660 */   181,  157,   45,  181,  181,   22,  185,  181,  181,  193,
 /*   670 */   181,   54,   55,  185,   57,  157,  181,  196,  181,  131,
 /*   680 */    63,  103,  157,  157,  196,  181,   22,  157,   71,   72,
 /*   690 */   157,   22,  157,   76,   77,  103,  157,   80,   81,  181,
 /*   700 */    83,   84,   85,   86,   82,   32,  181,  181,   91,  106,
 /*   710 */    93,  181,   90,  165,  181,   98,  181,  157,  157,  157,
 /*   720 */   181,  104,   22,   89,  157,  108,  157,  110,  103,  157,
 /*   730 */   157,    5,  115,  157,  157,   33,   10,   11,   12,  157,
 /*   740 */    14,  181,  181,  181,  157,  129,  103,   85,  181,   87,
 /*   750 */   181,   25,  171,  181,  181,  171,   26,  181,  181,  185,
 /*   760 */    87,   22,  181,  181,   62,  181,   49,  103,  181,  106,
 /*   770 */   196,   45,  103,  154,   39,  156,  206,    4,   22,  148,
 /*   780 */    54,   55,  185,   57,  157,   68,   22,  124,  106,   63,
 /*   790 */    90,  206,  106,  196,  206,  106,  106,   71,   72,  146,
 /*   800 */   103,  106,   76,   77,  133,  181,   80,   81,  181,   83,
 /*   810 */    84,   85,   86,   90,   79,   65,  184,   91,  169,   93,
 /*   820 */   184,   75,  202,  184,   98,  184,   79,   39,   39,  105,
 /*   830 */   104,  180,  185,  153,  108,  161,  110,    5,  130,   56,
 /*   840 */   217,  162,  103,   11,   12,   58,   14,  163,  187,   92,
 /*   850 */    78,  199,   68,  178,   68,  199,  199,   25,   15,  103,
 /*   860 */    22,   20,  141,   59,  177,  164,   39,  103,  202,  181,
 /*   870 */    39,  177,  181,   25,   79,  105,  105,   45,  105,   87,
 /*   880 */   105,  129,   43,  135,   79,  134,   54,   55,  103,   57,
 /*   890 */    22,  181,   22,  103,  181,   63,  103,   22,   79,  181,
 /*   900 */   103,   13,  141,   71,   72,   17,  202,   15,   76,   77,
 /*   910 */   181,   22,   80,   81,  181,   83,   84,   85,   86,  175,
 /*   920 */    73,  181,   39,   91,  150,   93,  181,   90,   79,  215,
 /*   930 */    98,  124,  183,  202,  181,  215,  104,   49,  183,   39,
 /*   940 */   108,   79,  110,  103,  184,  168,    5,   59,  181,  181,
 /*   950 */   192,  169,   11,   12,  191,   14,   68,  103,  164,  190,
 /*   960 */    75,  129,   74,  165,  199,   79,   25,   79,  190,  190,
 /*   970 */   204,   83,  181,   85,   79,   87,   75,   79,   97,  168,
 /*   980 */   204,   93,   32,  184,   96,  184,   45,  181,  192,  181,
 /*   990 */   181,    6,  211,  181,   90,   54,   55,  181,   57,   50,
 /*  1000 */   112,  150,  160,   10,   63,   41,   90,   90,   88,  181,
 /*  1010 */   210,   64,   71,   72,  181,  127,   90,   76,   77,  216,
 /*  1020 */   184,   80,   81,  150,   83,   84,   85,   86,  106,   64,
 /*  1030 */    79,  181,   91,   10,   93,   43,  106,  106,   43,   98,
 /*  1040 */   181,  186,  107,   91,  181,  104,  193,  217,   45,  108,
 /*  1050 */   106,  110,    5,   45,   70,  186,   79,  181,   11,   12,
 /*  1060 */    79,   14,  172,  106,   52,  181,  106,  106,  181,  217,
 /*  1070 */    52,  150,   25,  106,  181,  181,  106,  181,  150,  106,
 /*  1080 */   181,  217,  150,  186,  106,  106,  181,  150,  217,  107,
 /*  1090 */    70,  181,   45,  150,   79,  172,  106,  186,   70,   70,
 /*  1100 */   186,   54,   55,  150,   57,  181,   52,   35,  181,  112,
 /*  1110 */    63,  106,  106,  165,  181,  106,  106,  106,   71,   72,
 /*  1120 */   106,  182,  106,   76,   77,  106,  181,   80,   81,  103,
 /*  1130 */    83,   84,   85,   86,   30,  149,  106,  182,   91,  106,
 /*  1140 */    93,  106,    6,  181,  106,   98,  106,  149,  165,  181,
 /*  1150 */   218,  104,  218,  218,  218,  108,  218,  110,    5,  218,
 /*  1160 */   218,  218,  218,  218,   11,   12,  218,   14,  218,  218,
 /*  1170 */   218,  218,  218,  218,  218,  218,  218,  218,   25,  218,
 /*  1180 */   218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1190 */   218,  218,  218,  218,  218,  218,  218,  218,   45,  218,
 /*  1200 */   218,  218,  218,  218,  218,  218,  218,   54,   55,  218,
 /*  1210 */    57,  218,  218,  218,  218,  218,   63,  218,  218,  218,
 /*  1220 */   218,  218,  218,  218,   71,   72,  218,  218,  218,   76,
 /*  1230 */    77,  218,  218,   80,   81,  218,   83,   84,   85,   86,
 /*  1240 */   218,  218,  218,  218,   91,  218,   93,  218,  218,  218,
 /*  1250 */   218,   98,  218,  218,  218,  218,  218,  104,  218,  218,
 /*  1260 */   218,  108,  218,  110,    5,  218,  218,  218,  218,  218,
 /*  1270 */    11,   12,  218,   14,  218,  218,  218,  218,  218,  218,
 /*  1280 */   218,  218,  218,  218,   25,  218,  218,  218,  218,  218,
 /*  1290 */   218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1300 */   218,  218,  218,  218,   45,  218,  218,  218,  218,  218,
 /*  1310 */   218,  218,  218,   54,   55,  218,   57,  218,  218,  218,
 /*  1320 */   218,  218,   63,  218,  218,  218,  218,  218,  218,  218,
 /*  1330 */    71,   72,  218,  218,  218,   76,   77,  218,  218,   80,
 /*  1340 */    81,  218,   83,   84,   85,   86,  218,   11,   12,  218,
 /*  1350 */    14,  218,   93,  218,  218,  218,  218,   98,  218,  218,
 /*  1360 */   218,   25,  218,  104,  218,  218,  218,  108,  218,  110,
 /*  1370 */   218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1380 */   218,   45,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1390 */    54,   55,  218,   57,  218,  218,  218,  218,  218,   63,
 /*  1400 */   218,  218,  218,  218,  218,   13,  218,   71,   72,   17,
 /*  1410 */   218,  218,   76,   77,  218,  218,   80,   81,  218,   83,
 /*  1420 */    84,   85,   86,  218,  218,   12,  218,   14,  218,   93,
 /*  1430 */   218,  218,  218,  218,   98,  218,  218,  218,   25,  218,
 /*  1440 */   104,   49,  218,  218,  108,  218,  110,  218,  218,  218,
 /*  1450 */   218,   59,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1460 */    68,  218,  218,  218,  218,  218,   74,   54,  218,  218,
 /*  1470 */    57,   79,  218,  218,  218,   83,  218,   85,  218,   87,
 /*  1480 */   218,  218,  218,  218,  218,   93,  218,  218,   96,   76,
 /*  1490 */   218,  218,  218,   80,   81,  218,   83,  218,  218,  218,
 /*  1500 */   218,  218,  110,  218,  112,  218,   93,  218,  218,  218,
 /*  1510 */   218,   98,  218,  218,  218,  218,  218,  104,  218,  127,
 /*  1520 */   218,  108,  218,  110,
};
#define YY_SHIFT_USE_DFLT (-97)
static short yy_shift_ofst[] = {
 /*     0 */   603,  297,  -97,  324,  -96,  -97,   36,  514,  149,  420,
 /*    10 */   730,  155,  -97,  -97,  -97,  -97,  -97,  -97,   57,  -97,
 /*    20 */   -97,  -97,  -97,  -46,  682,  -46,  686,  -46,  689,  123,
 /*    30 */   690,   57,  664,  697,  695,    0,  -97,  316,  -97,   -3,
 /*    40 */   -97,   57,  233,  -97,  723,  -97,  673,  723,  -97,  750,
 /*    50 */   -97,  702,  -97,  -97,  746,  501,  723,  -97,  -97,  -97,
 /*    60 */   723,  -97,  747,  888,  566, 1392,  788,  789,  422,  -97,
 /*    70 */   394,  724,  -97,  434,  -97,  287,  708,  783,  787,  757,
 /*    80 */   772,  -97,  387,  -97,  784,  -97,  786,  -97,  634,  387,
 /*    90 */   -97,  387,  -97,  843,  888,  838,  888,  841,  501,  -97,
 /*   100 */   804,  -97,  -97, 1047,  888,  -97,  827,   57,  831,   57,
 /*   110 */   -97,  -97,  -97,  -97, 1336,  888, 1259,  888,  137,  888,
 /*   120 */   137,  888,  137,  888,  137,  888, 1413,  888, 1413,  888,
 /*   130 */   140,  888,  140,  888,  140,  888,  140,  888, 1413,   10,
 /*   140 */   888, 1413,  -97,  -97,  888,  118,  888,  118,  888,  848,
 /*   150 */   888,  848,  888,  848,  888,  -97,  -97,  662,  -97,  792,
 /*   160 */   -97,  -97,  888, 1153,  888, 1413,  795,  422,  122,  773,
 /*   170 */   770,  771,  775,  -97, 1047,  888, 1336,  888,  -97,  888,
 /*   180 */   -97,  888,  -97,  528,  832,  752,  234,  839,  -97,  888,
 /*   190 */   508,  888, 1047,  805,  325,  785,  -97,  868,   57,  790,
 /*   200 */   -97,  870,   57,  793,  -97,  875,   57,  797,  -97,  888,
 /*   210 */   402,  888,  617,  888, 1047,  578,  -97,  888,  -97,  -97,
 /*   220 */   -97,  888,  941,  888, 1336,  819,  422,  126,  -97,  522,
 /*   230 */   -97,  841,  501,  -97,  888, 1047,  892,  888,  889,  888,
 /*   240 */  1047,  -97,  -97,  163,  -97,  -97,  -97,  212,  -97,  200,
 /*   250 */   -97,  847,  -97,  -43,  883,  321,  -97,  -97,   57,  -97,
 /*   260 */   -97,  837,  807,  -97,  849,   57,  545,  -97,   57,  -97,
 /*   270 */   501,  -97,  -97,  888, 1047,   57,  -97,  724,  226,  321,
 /*   280 */   837,  807,  -97,   51,   -5,  -97,  -97,  900,  -21,  -97,
 /*   290 */   -97,  -97,  -97,  103,  -97,  625,  -97,  840,  -97,  207,
 /*   300 */   723,  -97,   57,  862,  -97,  622,  -97,   57,  -97,  410,
 /*   310 */   160,  -97,  275,  -97,  -97,  -97,  -97,  160,  -97,  160,
 /*   320 */   -97,   57,  329,  -97,  -97,  804,  -97,  750,  -97,  -97,
 /*   330 */    52,  -97,  -97,  -97,  717,  -97,  -97,  349,  -97,  -97,
 /*   340 */   -97,  -97,  184,  387,  756,  -97,  387,  854,  -97,  -97,
 /*   350 */   -97,  -97,  119,  248,  -97,   57,  -97,  885,  886,   57,
 /*   360 */   739,  723,  -97,  895,   57,  669,  723,  -97,  888,  311,
 /*   370 */   -97,  901,  898,   57,  480,  881,   57,  862,  -97,  108,
 /*   380 */   950,  -97,  -97,  -97,  -97,  -97,  724,  330,  377,  408,
 /*   390 */    57,  -97,   57,  985,  724,  273,   57,  475,  428,  904,
 /*   400 */    57,  883,  949,  616,  993,  888,  726,  964,   98,  -97,
 /*   410 */   -97,  916,  917,  376,   57,  700,   57,  -97,  -97,  -97,
 /*   420 */   -97,  920,  -97,  -97,  947,   57,  926,   57,  735,  951,
 /*   430 */    57,  764,  149,  922,  965, 1023,   -9,  331,  992,  930,
 /*   440 */   931,   -9,  995,  952,  155,  -97,   57,  935,   57,  227,
 /*   450 */    57, 1003,  888, 1047,  944, 1008,  888, 1047,  398,  984,
 /*   460 */    57,  977,   57,  319,  -97,  455,  104,  981,  888,  592,
 /*   470 */   888, 1047,  957, 1047, 1012,   57,  300,  960,  341,   57,
 /*   480 */   961,   57,  967,   57,   -2,  970,   57,   -2,  973,  188,
 /*   490 */  1018,   57,  883,  300,  978,  952,   57,  -17,  982,   57,
 /*   500 */   227,  979, 1020,   57,  883,  977,  446,  162, 1015,  888,
 /*   510 */   643,  990,  398, 1028, 1029,  952,   57,  332, 1054,   57,
 /*   520 */   663, 1072,  997, 1005,   93, 1006,  316,  302,  -51, 1009,
 /*   530 */  1010, 1011, 1014,  -35, 1016, 1019, 1030,  -35, 1033,  -97,
 /*   540 */    57, 1026, 1035, 1104,  316, 1136,   57, 1038,  -97, 1104,
 /*   550 */    57, 1040,  -97,  -97,  -97,
};
#define YY_REDUCE_USE_DFLT (-195)
static short yy_reduce_ofst[] = {
 /*     0 */   216,  619, -195,  -14, -195, -195, -195,   83,  205, -195,
 /*    10 */  -195,  476, -195, -195, -195, -195, -195, -195,  472, -195,
 /*    20 */  -195, -195, -195,  570, -195,  585, -195,  588, -195,  631,
 /*    30 */  -195,  159,  653, -195, -195,  -98, -195,  327,  671,  406,
 /*    40 */  -195,  624,  431, -195,  632, -195, -195,  636, -195,  649,
 /*    50 */  -195, -195, -195, -195, -195,  620,  639, -195, -195, -195,
 /*    60 */   641, -195, -195,  495, -195, -146, -195, -195,  164, -195,
 /*    70 */   651,  647, -195,  680,  309,  674,  623,  679,  684,  661,
 /*    80 */   675, -195,  652, -195, -195, -195, -195, -195, -195,  656,
 /*    90 */  -195,  657, -195, -195, -138, -195,  178,  721,  666, -195,
 /*   100 */   701, -195, -195,  687,  587, -195, -195,  688, -195,  691,
 /*   110 */  -195, -195, -195, -195,  687,  150,  687,  267,  687,  367,
 /*   120 */   687,  397,  687,  409,  687,  429,  687,  452,  687,  460,
 /*   130 */   687,  477,  687,  482,  687,  486,  687,  489,  687,  694,
 /*   140 */   518,  687, -195, -195,  533,  687,  539,  687,  560,  687,
 /*   150 */   562,  687,  572,  687,  577,  687, -195, -195, -195, -195,
 /*   160 */  -195, -195,  342,  687,  478,  687, -195, -155,  651, -195,
 /*   170 */  -195, -195, -195, -195,  687,  567,  687,  438,  687,  395,
 /*   180 */   687,  627,  687,  -59,  687,  748,  751, -195, -195,  569,
 /*   190 */   687,  561,  687, -195, -195, -195, -195, -195,  710, -195,
 /*   200 */  -195, -195,  713, -195, -195, -195,  718, -195, -195,  525,
 /*   210 */   687,  504,  687,  497,  687, -195, -195,  156, -195, -195,
 /*   220 */  -195,  479,  687,  470,  687, -195,   -4,  651, -195, -195,
 /*   230 */  -195,  761,  704, -195,  451,  687, -195,  253, -195,  417,
 /*   240 */   687, -195,  400,  744, -195, -195, -195,  729, -195,  733,
 /*   250 */  -195, -195, -195,  740,  774,  473, -195, -195,  745, -195,
 /*   260 */  -195,  749,  714, -195, -195,  294, -195, -195,  483, -195,
 /*   270 */   731, -195, -195,  487,  687,  753, -195,  481,  651,  548,
 /*   280 */   755,  720, -195,  526,  173, -195, -195, -195,  688, -195,
 /*   290 */  -195, -195, -195,  687, -195, -195, -195, -195, -195,  687,
 /*   300 */   760, -195,  767,  777,  758,  763, -195,  768, -195, -195,
 /*   310 */   769, -195, -195, -195, -195, -195, -195,  778, -195,  779,
 /*   320 */  -195,  286, -195, -195, -195,  794, -195,  782, -195, -195,
 /*   330 */  -195, -195, -195, -195, -195, -195, -195, -195, -195, -195,
 /*   340 */  -195, -195,  798,  765, -195, -195, -194, -195, -195, -195,
 /*   350 */  -195, -195,  766,  776, -195,  791, -195, -195, -195,  392,
 /*   360 */  -195,  799, -195, -195,  389, -195,  801, -195,  582,   20,
 /*   370 */  -195, -195, -195,  380, -195, -195,  806,  811,  796,  378,
 /*   380 */  -195, -195, -195, -195, -195, -195,  597,  651,  -82, -195,
 /*   390 */   808, -195,  809, -195,  574,  651,  812,  781,  800, -195,
 /*   400 */   816,  851,  842,  803, -195,  576,  687, -195, -195, -195,
 /*   410 */  -195, -195, -195, -195,  584, -195,  828, -195, -195, -195,
 /*   420 */  -195, -195, -195, -195, -195,  833, -195,  850,  873, -195,
 /*   430 */   350, -195,  836, -195, -195, -195,  235,  651, -195, -195,
 /*   440 */  -195,   73, -195,  855,  853, -195,  859, -195,  439,  830,
 /*   450 */   863, -195,  530,  687, -195, -195,  535,  687,  869, -195,
 /*   460 */   876,  890,  581, -195, -195,  488,  651, -195,  354, -195,
 /*   470 */   573,  687, -195,  687, -195,  884,  852, -195, -195,  887,
 /*   480 */  -195,  893, -195,  894,  921, -195,  896,  928, -195,  651,
 /*   490 */  -195,  899,  932,  864, -195,  897,  905,  937, -195,   46,
 /*   500 */   871, -195, -195,  910,  943,  923,  379,  651, -195,  -72,
 /*   510 */  -195, -195,  911, -195, -195,  914,  924,  953, -195,  927,
 /*   520 */  -195, -195, -195, -195,  933, -195,  948, -195, -133, -195,
 /*   530 */  -195, -195, -195,  939, -195, -195, -195,  955, -195, -195,
 /*   540 */   945, -195, -195,  986,  983, -195,  962, -195, -195,  998,
 /*   550 */   968, -195, -195, -195, -195,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   562,  562,  557,  842,  842,  558,  842,  564,  842,  842,
 /*    10 */   842,  842,  644,  647,  648,  649,  650,  651,  565,  566,
 /*    20 */   583,  584,  585,  842,  842,  842,  842,  842,  842,  842,
 /*    30 */   842,  842,  842,  842,  842,  842,  576,  586,  596,  578,
 /*    40 */   595,  842,  842,  597,  643,  608,  842,  643,  609,  628,
 /*    50 */   626,  842,  629,  630,  842,  698,  643,  610,  696,  697,
 /*    60 */   643,  611,  842,  842,  727,  785,  733,  728,  842,  656,
 /*    70 */   842,  842,  657,  665,  667,  674,  710,  701,  703,  691,
 /*    80 */   705,  662,  842,  592,  842,  593,  842,  594,  706,  842,
 /*    90 */   707,  842,  708,  842,  842,  692,  842,  699,  698,  693,
 /*   100 */   842,  580,  700,  695,  842,  726,  842,  842,  729,  842,
 /*   110 */   730,  731,  732,  734,  737,  842,  738,  842,  739,  842,
 /*   120 */   740,  842,  741,  842,  742,  842,  743,  842,  744,  842,
 /*   130 */   745,  842,  746,  842,  747,  842,  748,  842,  749,  842,
 /*   140 */   842,  750,  751,  752,  842,  753,  842,  754,  842,  755,
 /*   150 */   842,  756,  842,  757,  842,  758,  759,  842,  760,  842,
 /*   160 */   763,  761,  842,  842,  842,  769,  842,  785,  842,  842,
 /*   170 */   842,  842,  842,  772,  784,  842,  764,  842,  765,  842,
 /*   180 */   766,  842,  767,  842,  842,  842,  842,  842,  775,  842,
 /*   190 */   842,  842,  776,  842,  842,  842,  833,  842,  842,  842,
 /*   200 */   834,  842,  842,  842,  835,  842,  842,  842,  836,  842,
 /*   210 */   842,  842,  842,  842,  777,  842,  771,  785,  782,  783,
 /*   220 */   762,  842,  842,  842,  770,  842,  785,  842,  774,  842,
 /*   230 */   773,  699,  698,  694,  842,  704,  842,  785,  702,  842,
 /*   240 */   711,  666,  677,  675,  676,  682,  683,  842,  684,  842,
 /*   250 */   685,  842,  686,  842,  680,  673,  581,  582,  842,  671,
 /*   260 */   672,  688,  690,  678,  842,  842,  842,  689,  842,  791,
 /*   270 */   698,  793,  792,  842,  687,  842,  681,  842,  842,  673,
 /*   280 */   688,  690,  679,  842,  673,  668,  669,  842,  842,  670,
 /*   290 */   663,  664,  768,  842,  725,  842,  735,  842,  736,  842,
 /*   300 */   643,  612,  842,  789,  616,  613,  617,  842,  618,  842,
 /*   310 */   842,  619,  842,  622,  623,  624,  625,  842,  620,  842,
 /*   320 */   621,  842,  842,  790,  614,  842,  615,  628,  627,  598,
 /*   330 */   842,  599,  600,  601,  842,  602,  605,  842,  603,  606,
 /*   340 */   604,  607,  587,  842,  842,  588,  842,  842,  589,  591,
 /*   350 */   590,  579,  842,  842,  633,  842,  636,  842,  842,  842,
 /*   360 */   842,  643,  637,  842,  842,  842,  643,  638,  842,  643,
 /*   370 */   639,  842,  842,  842,  842,  842,  842,  789,  616,  641,
 /*   380 */   842,  640,  642,  634,  635,  577,  842,  842,  573,  842,
 /*   390 */   842,  571,  842,  842,  842,  842,  842,  816,  842,  842,
 /*   400 */   842,  680,  821,  842,  842,  842,  842,  842,  842,  822,
 /*   410 */   823,  842,  842,  842,  842,  842,  842,  723,  724,  813,
 /*   420 */   814,  842,  815,  572,  842,  842,  842,  842,  842,  842,
 /*   430 */   842,  842,  842,  842,  842,  842,  842,  842,  842,  842,
 /*   440 */   842,  842,  842,  645,  842,  646,  842,  842,  842,  842,
 /*   450 */   842,  842,  842,  713,  842,  842,  842,  714,  842,  842,
 /*   460 */   842,  721,  842,  842,  722,  842,  842,  842,  842,  842,
 /*   470 */   842,  719,  842,  720,  842,  842,  842,  842,  842,  842,
 /*   480 */   842,  842,  842,  842,  842,  842,  842,  842,  842,  842,
 /*   490 */   842,  842,  680,  842,  842,  645,  842,  842,  842,  842,
 /*   500 */   842,  842,  842,  842,  680,  721,  842,  842,  842,  842,
 /*   510 */   842,  842,  842,  842,  842,  645,  842,  842,  842,  842,
 /*   520 */   842,  842,  842,  842,  842,  842,  842,  842,  810,  842,
 /*   530 */   842,  842,  842,  842,  842,  842,  842,  842,  842,  809,
 /*   540 */   842,  842,  842,  840,  842,  842,  842,  842,  839,  840,
 /*   550 */   842,  842,  559,  561,  556,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
   59,  /*      ABORT => ID */
   59,  /*      AFTER => ID */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*        ALL => nothing */
    0,  /*        AND => nothing */
    0,  /*         AS => nothing */
   59,  /*        ASC => ID */
   59,  /*     ATTACH => ID */
   59,  /*     BEFORE => ID */
   59,  /*      BEGIN => ID */
    0,  /*    BETWEEN => nothing */
    0,  /*     BITAND => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*      BITOR => nothing */
    0,  /*         BY => nothing */
   59,  /*    CASCADE => ID */
    0,  /*       CASE => nothing */
    0,  /*      CHECK => nothing */
   59,  /*    CLUSTER => ID */
    0,  /*    COLLATE => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*      COMMA => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*     COMMIT => nothing */
    0,  /*     CONCAT => nothing */
   59,  /*   CONFLICT => ID */
    0,  /* CONSTRAINT => nothing */
   59,  /*       COPY => ID */
    0,  /*     CREATE => nothing */
   59,  /*   DATABASE => ID */
    0,  /*    DEFAULT => nothing */
    0,  /* DEFERRABLE => nothing */
   59,  /*   DEFERRED => ID */
    0,  /*     DELETE => nothing */
   59,  /* DELIMITERS => ID */
   59,  /*       DESC => ID */
   59,  /*     DETACH => ID */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       DROP => nothing */
   59,  /*       EACH => ID */
    0,  /*       ELSE => nothing */
   59,  /*        END => ID */
    0,  /* END_OF_FILE => nothing */
    0,  /*         EQ => nothing */
    0,  /*     EXCEPT => nothing */
   59,  /*    EXPLAIN => ID */
   59,  /*       FAIL => ID */
    0,  /*      FLOAT => nothing */
   59,  /*        FOR => ID */
    0,  /*    FOREIGN => nothing */
    0,  /*       FROM => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*         GE => nothing */
   59,  /*       GLOB => ID */
    0,  /*      GROUP => nothing */
    0,  /*         GT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*         ID => nothing */
   59,  /*     IGNORE => ID */
    0,  /*    ILLEGAL => nothing */
   59,  /*  IMMEDIATE => ID */
    0,  /*         IN => nothing */
    0,  /*      INDEX => nothing */
   59,  /*  INITIALLY => ID */
    0,  /*     INSERT => nothing */
   59,  /*    INSTEAD => ID */
    0,  /*    INTEGER => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*       INTO => nothing */
    0,  /*         IS => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*       JOIN => nothing */
    0,  /*    JOIN_KW => nothing */
   59,  /*        KEY => ID */
    0,  /*         LE => nothing */
   59,  /*       LIKE => ID */
    0,  /*      LIMIT => nothing */
    0,  /*         LP => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*         LT => nothing */
   59,  /*      MATCH => ID */
    0,  /*      MINUS => nothing */
    0,  /*         NE => nothing */
    0,  /*        NOT => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*       NULL => nothing */
   59,  /*         OF => ID */
   59,  /*     OFFSET => ID */
    0,  /*         ON => nothing */
    0,  /*         OR => nothing */
    0,  /*      ORDER => nothing */
    0,  /*       PLUS => nothing */
   59,  /*     PRAGMA => ID */
    0,  /*    PRIMARY => nothing */
   59,  /*      RAISE => ID */
    0,  /* REFERENCES => nothing */
    0,  /*        REM => nothing */
   59,  /*    REPLACE => ID */
   59,  /*   RESTRICT => ID */
    0,  /*   ROLLBACK => nothing */
   59,  /*        ROW => ID */
    0,  /*         RP => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*       SEMI => nothing */
    0,  /*        SET => nothing */
    0,  /*      SLASH => nothing */
    0,  /*      SPACE => nothing */
    0,  /*       STAR => nothing */
   59,  /*  STATEMENT => ID */
    0,  /*     STRING => nothing */
    0,  /*      TABLE => nothing */
   59,  /*       TEMP => ID */
    0,  /*       THEN => nothing */
    0,  /* TRANSACTION => nothing */
   59,  /*    TRIGGER => ID */
    0,  /*     UMINUS => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*      UNION => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*      USING => nothing */
   59,  /*     VACUUM => ID */
    0,  /*     VALUES => nothing */
    0,  /*   VARIABLE => nothing */
   59,  /*       VIEW => ID */
    0,  /*       WHEN => nothing */
    0,  /*      WHERE => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  yyStackEntry *yytop;          /* Pointer to the top stack element */
  sqliteParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "ABORT",         "AFTER",         "AGG_FUNCTION",
  "ALL",           "AND",           "AS",            "ASC",         
  "ATTACH",        "BEFORE",        "BEGIN",         "BETWEEN",     
  "BITAND",        "BITNOT",        "BITOR",         "BY",          
  "CASCADE",       "CASE",          "CHECK",         "CLUSTER",     
  "COLLATE",       "COLUMN",        "COMMA",         "COMMENT",     
  "COMMIT",        "CONCAT",        "CONFLICT",      "CONSTRAINT",  
  "COPY",          "CREATE",        "DATABASE",      "DEFAULT",     
  "DEFERRABLE",    "DEFERRED",      "DELETE",        "DELIMITERS",  
  "DESC",          "DETACH",        "DISTINCT",      "DOT",         
  "DROP",          "EACH",          "ELSE",          "END",         
  "END_OF_FILE",   "EQ",            "EXCEPT",        "EXPLAIN",     
  "FAIL",          "FLOAT",         "FOR",           "FOREIGN",     
  "FROM",          "FUNCTION",      "GE",            "GLOB",        
  "GROUP",         "GT",            "HAVING",        "ID",          
  "IGNORE",        "ILLEGAL",       "IMMEDIATE",     "IN",          
  "INDEX",         "INITIALLY",     "INSERT",        "INSTEAD",     
  "INTEGER",       "INTERSECT",     "INTO",          "IS",          
  "ISNULL",        "JOIN",          "JOIN_KW",       "KEY",         
  "LE",            "LIKE",          "LIMIT",         "LP",          
  "LSHIFT",        "LT",            "MATCH",         "MINUS",       
  "NE",            "NOT",           "NOTNULL",       "NULL",        
  "OF",            "OFFSET",        "ON",            "OR",          
  "ORDER",         "PLUS",          "PRAGMA",        "PRIMARY",     
  "RAISE",         "REFERENCES",    "REM",           "REPLACE",     
  "RESTRICT",      "ROLLBACK",      "ROW",           "RP",          
  "RSHIFT",        "SELECT",        "SEMI",          "SET",         
  "SLASH",         "SPACE",         "STAR",          "STATEMENT",   
  "STRING",        "TABLE",         "TEMP",          "THEN",        
  "TRANSACTION",   "TRIGGER",       "UMINUS",        "UNCLOSED_STRING",
  "UNION",         "UNIQUE",        "UPDATE",        "UPLUS",       
  "USING",         "VACUUM",        "VALUES",        "VARIABLE",    
  "VIEW",          "WHEN",          "WHERE",         "as",          
  "carg",          "carglist",      "case_else",     "case_exprlist",
  "case_operand",  "ccons",         "cmd",           "cmdlist",     
  "cmdx",          "collate",       "column",        "columnid",    
  "columnlist",    "conslist",      "conslist_opt",  "create_table",
  "create_table_args",  "database_kw_opt",  "dbnm",          "defer_subclause",
  "defer_subclause_opt",  "distinct",      "ecmd",          "error",       
  "explain",       "expr",          "expritem",      "exprlist",    
  "foreach_clause",  "from",          "groupby_opt",   "having_opt",  
  "id",            "ids",           "idxitem",       "idxlist",     
  "idxlist_opt",   "init_deferred_pred_opt",  "input",         "inscollist",  
  "inscollist_opt",  "insert_cmd",    "itemlist",      "joinop",      
  "joinop2",       "likeop",        "limit_opt",     "minus_num",   
  "multiselect_op",  "nm",            "number",        "on_opt",      
  "onconf",        "oneselect",     "orconf",        "orderby_opt", 
  "plus_num",      "plus_opt",      "refact",        "refarg",      
  "refargs",       "resolvetype",   "sclp",          "selcollist",  
  "select",        "seltablist",    "setlist",       "signed",      
  "sortitem",      "sortlist",      "sortorder",     "stl_prefix",  
  "tcons",         "temp",          "trans_opt",     "trigger_cmd", 
  "trigger_cmd_list",  "trigger_decl",  "trigger_event",  "trigger_time",
  "type",          "typename",      "uniqueflag",    "using_opt",   
  "when_clause",   "where_opt",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= ecmd",
 /*   2 */ "cmdlist ::= cmdlist ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN trans_opt onconf",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "cmd ::= COMMIT trans_opt",
 /*  13 */ "cmd ::= END trans_opt",
 /*  14 */ "cmd ::= ROLLBACK trans_opt",
 /*  15 */ "cmd ::= create_table create_table_args",
 /*  16 */ "create_table ::= CREATE temp TABLE nm",
 /*  17 */ "temp ::= TEMP",
 /*  18 */ "temp ::=",
 /*  19 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  20 */ "create_table_args ::= AS select",
 /*  21 */ "columnlist ::= columnlist COMMA column",
 /*  22 */ "columnlist ::= column",
 /*  23 */ "column ::= columnid type carglist",
 /*  24 */ "columnid ::= nm",
 /*  25 */ "id ::= ID",
 /*  26 */ "ids ::= ID",
 /*  27 */ "ids ::= STRING",
 /*  28 */ "nm ::= ID",
 /*  29 */ "nm ::= STRING",
 /*  30 */ "nm ::= JOIN_KW",
 /*  31 */ "type ::=",
 /*  32 */ "type ::= typename",
 /*  33 */ "type ::= typename LP signed RP",
 /*  34 */ "type ::= typename LP signed COMMA signed RP",
 /*  35 */ "typename ::= ids",
 /*  36 */ "typename ::= typename ids",
 /*  37 */ "signed ::= INTEGER",
 /*  38 */ "signed ::= PLUS INTEGER",
 /*  39 */ "signed ::= MINUS INTEGER",
 /*  40 */ "carglist ::= carglist carg",
 /*  41 */ "carglist ::=",
 /*  42 */ "carg ::= CONSTRAINT nm ccons",
 /*  43 */ "carg ::= ccons",
 /*  44 */ "carg ::= DEFAULT STRING",
 /*  45 */ "carg ::= DEFAULT ID",
 /*  46 */ "carg ::= DEFAULT INTEGER",
 /*  47 */ "carg ::= DEFAULT PLUS INTEGER",
 /*  48 */ "carg ::= DEFAULT MINUS INTEGER",
 /*  49 */ "carg ::= DEFAULT FLOAT",
 /*  50 */ "carg ::= DEFAULT PLUS FLOAT",
 /*  51 */ "carg ::= DEFAULT MINUS FLOAT",
 /*  52 */ "carg ::= DEFAULT NULL",
 /*  53 */ "ccons ::= NULL onconf",
 /*  54 */ "ccons ::= NOT NULL onconf",
 /*  55 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  56 */ "ccons ::= UNIQUE onconf",
 /*  57 */ "ccons ::= CHECK LP expr RP onconf",
 /*  58 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  59 */ "ccons ::= defer_subclause",
 /*  60 */ "ccons ::= COLLATE id",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= ROLLBACK",
 /*  93 */ "resolvetype ::= ABORT",
 /*  94 */ "resolvetype ::= FAIL",
 /*  95 */ "resolvetype ::= IGNORE",
 /*  96 */ "resolvetype ::= REPLACE",
 /*  97 */ "cmd ::= DROP TABLE nm",
 /*  98 */ "cmd ::= CREATE temp VIEW nm AS select",
 /*  99 */ "cmd ::= DROP VIEW nm",
 /* 100 */ "cmd ::= select",
 /* 101 */ "select ::= oneselect",
 /* 102 */ "select ::= select multiselect_op oneselect",
 /* 103 */ "multiselect_op ::= UNION",
 /* 104 */ "multiselect_op ::= UNION ALL",
 /* 105 */ "multiselect_op ::= INTERSECT",
 /* 106 */ "multiselect_op ::= EXCEPT",
 /* 107 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 108 */ "distinct ::= DISTINCT",
 /* 109 */ "distinct ::= ALL",
 /* 110 */ "distinct ::=",
 /* 111 */ "sclp ::= selcollist COMMA",
 /* 112 */ "sclp ::=",
 /* 113 */ "selcollist ::= sclp expr as",
 /* 114 */ "selcollist ::= sclp STAR",
 /* 115 */ "selcollist ::= sclp nm DOT STAR",
 /* 116 */ "as ::= AS nm",
 /* 117 */ "as ::= ids",
 /* 118 */ "as ::=",
 /* 119 */ "from ::=",
 /* 120 */ "from ::= FROM seltablist",
 /* 121 */ "stl_prefix ::= seltablist joinop",
 /* 122 */ "stl_prefix ::=",
 /* 123 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 124 */ "seltablist ::= stl_prefix LP select RP as on_opt using_opt",
 /* 125 */ "dbnm ::=",
 /* 126 */ "dbnm ::= DOT nm",
 /* 127 */ "joinop ::= COMMA",
 /* 128 */ "joinop ::= JOIN",
 /* 129 */ "joinop ::= JOIN_KW JOIN",
 /* 130 */ "joinop ::= JOIN_KW nm JOIN",
 /* 131 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 132 */ "on_opt ::= ON expr",
 /* 133 */ "on_opt ::=",
 /* 134 */ "using_opt ::= USING LP idxlist RP",
 /* 135 */ "using_opt ::=",
 /* 136 */ "orderby_opt ::=",
 /* 137 */ "orderby_opt ::= ORDER BY sortlist",
 /* 138 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 139 */ "sortlist ::= sortitem collate sortorder",
 /* 140 */ "sortitem ::= expr",
 /* 141 */ "sortorder ::= ASC",
 /* 142 */ "sortorder ::= DESC",
 /* 143 */ "sortorder ::=",
 /* 144 */ "collate ::=",
 /* 145 */ "collate ::= COLLATE id",
 /* 146 */ "groupby_opt ::=",
 /* 147 */ "groupby_opt ::= GROUP BY exprlist",
 /* 148 */ "having_opt ::=",
 /* 149 */ "having_opt ::= HAVING expr",
 /* 150 */ "limit_opt ::=",
 /* 151 */ "limit_opt ::= LIMIT signed",
 /* 152 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 153 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 154 */ "cmd ::= DELETE FROM nm dbnm where_opt",
 /* 155 */ "where_opt ::=",
 /* 156 */ "where_opt ::= WHERE expr",
 /* 157 */ "cmd ::= UPDATE orconf nm dbnm SET setlist where_opt",
 /* 158 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 159 */ "setlist ::= nm EQ expr",
 /* 160 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt VALUES LP itemlist RP",
 /* 161 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt select",
 /* 162 */ "insert_cmd ::= INSERT orconf",
 /* 163 */ "insert_cmd ::= REPLACE",
 /* 164 */ "itemlist ::= itemlist COMMA expr",
 /* 165 */ "itemlist ::= expr",
 /* 166 */ "inscollist_opt ::=",
 /* 167 */ "inscollist_opt ::= LP inscollist RP",
 /* 168 */ "inscollist ::= inscollist COMMA nm",
 /* 169 */ "inscollist ::= nm",
 /* 170 */ "expr ::= LP expr RP",
 /* 171 */ "expr ::= NULL",
 /* 172 */ "expr ::= ID",
 /* 173 */ "expr ::= JOIN_KW",
 /* 174 */ "expr ::= nm DOT nm",
 /* 175 */ "expr ::= nm DOT nm DOT nm",
 /* 176 */ "expr ::= INTEGER",
 /* 177 */ "expr ::= FLOAT",
 /* 178 */ "expr ::= STRING",
 /* 179 */ "expr ::= VARIABLE",
 /* 180 */ "expr ::= ID LP exprlist RP",
 /* 181 */ "expr ::= ID LP STAR RP",
 /* 182 */ "expr ::= expr AND expr",
 /* 183 */ "expr ::= expr OR expr",
 /* 184 */ "expr ::= expr LT expr",
 /* 185 */ "expr ::= expr GT expr",
 /* 186 */ "expr ::= expr LE expr",
 /* 187 */ "expr ::= expr GE expr",
 /* 188 */ "expr ::= expr NE expr",
 /* 189 */ "expr ::= expr EQ expr",
 /* 190 */ "expr ::= expr BITAND expr",
 /* 191 */ "expr ::= expr BITOR expr",
 /* 192 */ "expr ::= expr LSHIFT expr",
 /* 193 */ "expr ::= expr RSHIFT expr",
 /* 194 */ "expr ::= expr likeop expr",
 /* 195 */ "expr ::= expr NOT likeop expr",
 /* 196 */ "likeop ::= LIKE",
 /* 197 */ "likeop ::= GLOB",
 /* 198 */ "expr ::= expr PLUS expr",
 /* 199 */ "expr ::= expr MINUS expr",
 /* 200 */ "expr ::= expr STAR expr",
 /* 201 */ "expr ::= expr SLASH expr",
 /* 202 */ "expr ::= expr REM expr",
 /* 203 */ "expr ::= expr CONCAT expr",
 /* 204 */ "expr ::= expr ISNULL",
 /* 205 */ "expr ::= expr IS NULL",
 /* 206 */ "expr ::= expr NOTNULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT expr",
 /* 210 */ "expr ::= BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "expr ::= LP select RP",
 /* 214 */ "expr ::= expr BETWEEN expr AND expr",
 /* 215 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 216 */ "expr ::= expr IN LP exprlist RP",
 /* 217 */ "expr ::= expr IN LP select RP",
 /* 218 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 219 */ "expr ::= expr NOT IN LP select RP",
 /* 220 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 221 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 222 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 223 */ "case_else ::= ELSE expr",
 /* 224 */ "case_else ::=",
 /* 225 */ "case_operand ::= expr",
 /* 226 */ "case_operand ::=",
 /* 227 */ "exprlist ::= exprlist COMMA expritem",
 /* 228 */ "exprlist ::= expritem",
 /* 229 */ "expritem ::= expr",
 /* 230 */ "expritem ::=",
 /* 231 */ "cmd ::= CREATE uniqueflag INDEX nm ON nm dbnm LP idxlist RP onconf",
 /* 232 */ "uniqueflag ::= UNIQUE",
 /* 233 */ "uniqueflag ::=",
 /* 234 */ "idxlist_opt ::=",
 /* 235 */ "idxlist_opt ::= LP idxlist RP",
 /* 236 */ "idxlist ::= idxlist COMMA idxitem",
 /* 237 */ "idxlist ::= idxitem",
 /* 238 */ "idxitem ::= nm sortorder",
 /* 239 */ "cmd ::= DROP INDEX nm dbnm",
 /* 240 */ "cmd ::= COPY orconf nm dbnm FROM nm USING DELIMITERS STRING",
 /* 241 */ "cmd ::= COPY orconf nm dbnm FROM nm",
 /* 242 */ "cmd ::= VACUUM",
 /* 243 */ "cmd ::= VACUUM nm",
 /* 244 */ "cmd ::= PRAGMA ids EQ nm",
 /* 245 */ "cmd ::= PRAGMA ids EQ ON",
 /* 246 */ "cmd ::= PRAGMA ids EQ plus_num",
 /* 247 */ "cmd ::= PRAGMA ids EQ minus_num",
 /* 248 */ "cmd ::= PRAGMA ids LP nm RP",
 /* 249 */ "cmd ::= PRAGMA ids",
 /* 250 */ "plus_num ::= plus_opt number",
 /* 251 */ "minus_num ::= MINUS number",
 /* 252 */ "number ::= INTEGER",
 /* 253 */ "number ::= FLOAT",
 /* 254 */ "plus_opt ::= PLUS",
 /* 255 */ "plus_opt ::=",
 /* 256 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 257 */ "trigger_decl ::= temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause",
 /* 258 */ "trigger_time ::= BEFORE",
 /* 259 */ "trigger_time ::= AFTER",
 /* 260 */ "trigger_time ::= INSTEAD OF",
 /* 261 */ "trigger_time ::=",
 /* 262 */ "trigger_event ::= DELETE",
 /* 263 */ "trigger_event ::= INSERT",
 /* 264 */ "trigger_event ::= UPDATE",
 /* 265 */ "trigger_event ::= UPDATE OF inscollist",
 /* 266 */ "foreach_clause ::=",
 /* 267 */ "foreach_clause ::= FOR EACH ROW",
 /* 268 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 269 */ "when_clause ::=",
 /* 270 */ "when_clause ::= WHEN expr",
 /* 271 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 272 */ "trigger_cmd_list ::=",
 /* 273 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 274 */ "trigger_cmd ::= INSERT orconf INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 275 */ "trigger_cmd ::= INSERT orconf INTO nm inscollist_opt select",
 /* 276 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 277 */ "trigger_cmd ::= select",
 /* 278 */ "expr ::= RAISE LP IGNORE RP",
 /* 279 */ "expr ::= RAISE LP ROLLBACK COMMA nm RP",
 /* 280 */ "expr ::= RAISE LP ABORT COMMA nm RP",
 /* 281 */ "expr ::= RAISE LP FAIL COMMA nm RP",
 /* 282 */ "cmd ::= DROP TRIGGER nm dbnm",
 /* 283 */ "cmd ::= ATTACH database_kw_opt ids AS nm",
 /* 284 */ "database_kw_opt ::= DATABASE",
 /* 285 */ "database_kw_opt ::=",
 /* 286 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqliteParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqliteParser and sqliteParserFree.
*/
void *sqliteParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 135:
#line 675 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1275 "parse.c"
      break;
    case 157:
#line 520 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1280 "parse.c"
      break;
    case 158:
#line 694 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1285 "parse.c"
      break;
    case 159:
#line 692 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1290 "parse.c"
      break;
    case 161:
#line 342 "parse.y"
{sqliteSrcListDelete((yypminor->yy335));}
#line 1295 "parse.c"
      break;
    case 162:
#line 436 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1300 "parse.c"
      break;
    case 163:
#line 441 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1305 "parse.c"
      break;
    case 167:
#line 717 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1310 "parse.c"
      break;
    case 168:
#line 719 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1315 "parse.c"
      break;
    case 171:
#line 499 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1320 "parse.c"
      break;
    case 172:
#line 497 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1325 "parse.c"
      break;
    case 174:
#line 491 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1330 "parse.c"
      break;
    case 183:
#line 397 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1335 "parse.c"
      break;
    case 185:
#line 277 "parse.y"
{sqliteSelectDelete((yypminor->yy11));}
#line 1340 "parse.c"
      break;
    case 187:
#line 408 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1345 "parse.c"
      break;
    case 194:
#line 313 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1350 "parse.c"
      break;
    case 195:
#line 311 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1355 "parse.c"
      break;
    case 196:
#line 275 "parse.y"
{sqliteSelectDelete((yypminor->yy11));}
#line 1360 "parse.c"
      break;
    case 197:
#line 338 "parse.y"
{sqliteSrcListDelete((yypminor->yy335));}
#line 1365 "parse.c"
      break;
    case 198:
#line 466 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1370 "parse.c"
      break;
    case 200:
#line 412 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1375 "parse.c"
      break;
    case 201:
#line 410 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1380 "parse.c"
      break;
    case 203:
#line 340 "parse.y"
{sqliteSrcListDelete((yypminor->yy335));}
#line 1385 "parse.c"
      break;
    case 207:
#line 809 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy347));}
#line 1390 "parse.c"
      break;
    case 208:
#line 801 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy347));}
#line 1395 "parse.c"
      break;
    case 210:
#line 785 "parse.y"
{sqliteIdListDelete((yypminor->yy234).b);}
#line 1400 "parse.c"
      break;
    case 215:
#line 402 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1405 "parse.c"
      break;
    case 217:
#line 460 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1410 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->yytop->major]);
  }
#endif
  yymajor = pParser->yytop->major;
  yy_destructor( yymajor, &pParser->yytop->minor);
  pParser->yyidx--;
  pParser->yytop--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqliteParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqliteParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[pParser->yytop->stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[pParser->yytop->stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[pParser->yytop->stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
 
  i = yy_reduce_ofst[pParser->yytop->stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[pParser->yytop->stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[pParser->yytop->stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->yyidx++;
  yypParser->yytop++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqliteParserARG_FETCH;
     yypParser->yyidx--;
     yypParser->yytop--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yypParser->yytop->stateno = yyNewState;
  yypParser->yytop->major = yyMajor;
  yypParser->yytop->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 170, 1 },
  { 139, 1 },
  { 139, 2 },
  { 154, 3 },
  { 154, 1 },
  { 140, 1 },
  { 156, 1 },
  { 156, 0 },
  { 138, 3 },
  { 206, 0 },
  { 206, 1 },
  { 206, 2 },
  { 138, 2 },
  { 138, 2 },
  { 138, 2 },
  { 138, 2 },
  { 147, 4 },
  { 205, 1 },
  { 205, 0 },
  { 148, 4 },
  { 148, 2 },
  { 144, 3 },
  { 144, 1 },
  { 142, 3 },
  { 143, 1 },
  { 164, 1 },
  { 165, 1 },
  { 165, 1 },
  { 181, 1 },
  { 181, 1 },
  { 181, 1 },
  { 212, 0 },
  { 212, 1 },
  { 212, 4 },
  { 212, 6 },
  { 213, 1 },
  { 213, 2 },
  { 199, 1 },
  { 199, 2 },
  { 199, 2 },
  { 133, 2 },
  { 133, 0 },
  { 132, 3 },
  { 132, 1 },
  { 132, 2 },
  { 132, 2 },
  { 132, 2 },
  { 132, 3 },
  { 132, 3 },
  { 132, 2 },
  { 132, 3 },
  { 132, 3 },
  { 132, 2 },
  { 137, 2 },
  { 137, 3 },
  { 137, 4 },
  { 137, 2 },
  { 137, 5 },
  { 137, 4 },
  { 137, 1 },
  { 137, 2 },
  { 192, 0 },
  { 192, 2 },
  { 191, 2 },
  { 191, 3 },
  { 191, 3 },
  { 191, 3 },
  { 190, 2 },
  { 190, 2 },
  { 190, 1 },
  { 190, 1 },
  { 151, 3 },
  { 151, 2 },
  { 169, 0 },
  { 169, 2 },
  { 169, 2 },
  { 146, 0 },
  { 146, 2 },
  { 145, 3 },
  { 145, 2 },
  { 145, 1 },
  { 204, 2 },
  { 204, 6 },
  { 204, 5 },
  { 204, 3 },
  { 204, 10 },
  { 152, 0 },
  { 152, 1 },
  { 184, 0 },
  { 184, 3 },
  { 186, 0 },
  { 186, 2 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 138, 3 },
  { 138, 6 },
  { 138, 3 },
  { 138, 1 },
  { 196, 1 },
  { 196, 3 },
  { 180, 1 },
  { 180, 2 },
  { 180, 1 },
  { 180, 1 },
  { 185, 9 },
  { 153, 1 },
  { 153, 1 },
  { 153, 0 },
  { 194, 2 },
  { 194, 0 },
  { 195, 3 },
  { 195, 2 },
  { 195, 4 },
  { 131, 2 },
  { 131, 1 },
  { 131, 0 },
  { 161, 0 },
  { 161, 2 },
  { 203, 2 },
  { 203, 0 },
  { 197, 6 },
  { 197, 7 },
  { 150, 0 },
  { 150, 2 },
  { 175, 1 },
  { 175, 1 },
  { 175, 2 },
  { 175, 3 },
  { 175, 4 },
  { 183, 2 },
  { 183, 0 },
  { 215, 4 },
  { 215, 0 },
  { 187, 0 },
  { 187, 3 },
  { 201, 5 },
  { 201, 3 },
  { 200, 1 },
  { 202, 1 },
  { 202, 1 },
  { 202, 0 },
  { 141, 0 },
  { 141, 2 },
  { 162, 0 },
  { 162, 3 },
  { 163, 0 },
  { 163, 2 },
  { 178, 0 },
  { 178, 2 },
  { 178, 4 },
  { 178, 4 },
  { 138, 5 },
  { 217, 0 },
  { 217, 2 },
  { 138, 7 },
  { 198, 5 },
  { 198, 3 },
  { 138, 9 },
  { 138, 6 },
  { 173, 2 },
  { 173, 1 },
  { 174, 3 },
  { 174, 1 },
  { 172, 0 },
  { 172, 3 },
  { 171, 3 },
  { 171, 1 },
  { 157, 3 },
  { 157, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 3 },
  { 157, 5 },
  { 157, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 4 },
  { 157, 4 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 4 },
  { 177, 1 },
  { 177, 1 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 2 },
  { 157, 3 },
  { 157, 2 },
  { 157, 3 },
  { 157, 4 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 157, 3 },
  { 157, 5 },
  { 157, 6 },
  { 157, 5 },
  { 157, 5 },
  { 157, 6 },
  { 157, 6 },
  { 157, 5 },
  { 135, 5 },
  { 135, 4 },
  { 134, 2 },
  { 134, 0 },
  { 136, 1 },
  { 136, 0 },
  { 159, 3 },
  { 159, 1 },
  { 158, 1 },
  { 158, 0 },
  { 138, 11 },
  { 214, 1 },
  { 214, 0 },
  { 168, 0 },
  { 168, 3 },
  { 167, 3 },
  { 167, 1 },
  { 166, 2 },
  { 138, 4 },
  { 138, 9 },
  { 138, 6 },
  { 138, 1 },
  { 138, 2 },
  { 138, 4 },
  { 138, 4 },
  { 138, 4 },
  { 138, 4 },
  { 138, 5 },
  { 138, 2 },
  { 188, 2 },
  { 179, 2 },
  { 182, 1 },
  { 182, 1 },
  { 189, 1 },
  { 189, 0 },
  { 138, 5 },
  { 209, 10 },
  { 211, 1 },
  { 211, 1 },
  { 211, 2 },
  { 211, 0 },
  { 210, 1 },
  { 210, 1 },
  { 210, 1 },
  { 210, 3 },
  { 160, 0 },
  { 160, 3 },
  { 160, 3 },
  { 216, 0 },
  { 216, 2 },
  { 208, 3 },
  { 208, 0 },
  { 207, 6 },
  { 207, 9 },
  { 207, 6 },
  { 207, 4 },
  { 207, 1 },
  { 157, 4 },
  { 157, 6 },
  { 157, 6 },
  { 157, 6 },
  { 138, 4 },
  { 138, 5 },
  { 149, 1 },
  { 149, 0 },
  { 138, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqliteParserARG_FETCH;
  yymsp = yypParser->yytop;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        /* No destructor defined for cmdlist */
        break;
      case 1:
        /* No destructor defined for ecmd */
        break;
      case 2:
        /* No destructor defined for cmdlist */
        /* No destructor defined for ecmd */
        break;
      case 3:
        /* No destructor defined for explain */
        /* No destructor defined for cmdx */
        /* No destructor defined for SEMI */
        break;
      case 4:
        /* No destructor defined for SEMI */
        break;
      case 5:
#line 77 "parse.y"
{ sqliteExec(pParse); }
#line 1928 "parse.c"
        /* No destructor defined for cmd */
        break;
      case 6:
#line 78 "parse.y"
{ sqliteBeginParse(pParse, 1); }
#line 1934 "parse.c"
        /* No destructor defined for EXPLAIN */
        break;
      case 7:
#line 79 "parse.y"
{ sqliteBeginParse(pParse, 0); }
#line 1940 "parse.c"
        break;
      case 8:
#line 84 "parse.y"
{sqliteBeginTransaction(pParse,yymsp[0].minor.yy52);}
#line 1945 "parse.c"
        /* No destructor defined for BEGIN */
        /* No destructor defined for trans_opt */
        break;
      case 9:
        break;
      case 10:
        /* No destructor defined for TRANSACTION */
        break;
      case 11:
        /* No destructor defined for TRANSACTION */
        /* No destructor defined for nm */
        break;
      case 12:
#line 88 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1961 "parse.c"
        /* No destructor defined for COMMIT */
        /* No destructor defined for trans_opt */
        break;
      case 13:
#line 89 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1968 "parse.c"
        /* No destructor defined for END */
        /* No destructor defined for trans_opt */
        break;
      case 14:
#line 90 "parse.y"
{sqliteRollbackTransaction(pParse);}
#line 1975 "parse.c"
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for trans_opt */
        break;
      case 15:
        /* No destructor defined for create_table */
        /* No destructor defined for create_table_args */
        break;
      case 16:
#line 95 "parse.y"
{
   sqliteStartTable(pParse,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy210,yymsp[-2].minor.yy52,0);
}
#line 1988 "parse.c"
        /* No destructor defined for TABLE */
        break;
      case 17:
#line 99 "parse.y"
{yygotominor.yy52 = 1;}
#line 1994 "parse.c"
        /* No destructor defined for TEMP */
        break;
      case 18:
#line 100 "parse.y"
{yygotominor.yy52 = 0;}
#line 2000 "parse.c"
        break;
      case 19:
#line 101 "parse.y"
{
  sqliteEndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 2007 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for columnlist */
        /* No destructor defined for conslist_opt */
        break;
      case 20:
#line 104 "parse.y"
{
  sqliteEndTable(pParse,0,yymsp[0].minor.yy11);
  sqliteSelectDelete(yymsp[0].minor.yy11);
}
#line 2018 "parse.c"
        /* No destructor defined for AS */
        break;
      case 21:
        /* No destructor defined for columnlist */
        /* No destructor defined for COMMA */
        /* No destructor defined for column */
        break;
      case 22:
        /* No destructor defined for column */
        break;
      case 23:
        /* No destructor defined for columnid */
        /* No destructor defined for type */
        /* No destructor defined for carglist */
        break;
      case 24:
#line 116 "parse.y"
{sqliteAddColumn(pParse,&yymsp[0].minor.yy210);}
#line 2037 "parse.c"
        break;
      case 25:
#line 122 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2042 "parse.c"
        break;
      case 26:
#line 138 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2047 "parse.c"
        break;
      case 27:
#line 139 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2052 "parse.c"
        break;
      case 28:
#line 144 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2057 "parse.c"
        break;
      case 29:
#line 145 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2062 "parse.c"
        break;
      case 30:
#line 146 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2067 "parse.c"
        break;
      case 31:
        break;
      case 32:
#line 149 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[0].minor.yy210,&yymsp[0].minor.yy210);}
#line 2074 "parse.c"
        break;
      case 33:
#line 150 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-3].minor.yy210,&yymsp[0].minor.yy0);}
#line 2079 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        break;
      case 34:
#line 152 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-5].minor.yy210,&yymsp[0].minor.yy0);}
#line 2086 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        /* No destructor defined for COMMA */
        /* No destructor defined for signed */
        break;
      case 35:
#line 154 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 2095 "parse.c"
        break;
      case 36:
#line 155 "parse.y"
{yygotominor.yy210 = yymsp[-1].minor.yy210;}
#line 2100 "parse.c"
        /* No destructor defined for ids */
        break;
      case 37:
#line 157 "parse.y"
{ yygotominor.yy52 = atoi(yymsp[0].minor.yy0.z); }
#line 2106 "parse.c"
        break;
      case 38:
#line 158 "parse.y"
{ yygotominor.yy52 = atoi(yymsp[0].minor.yy0.z); }
#line 2111 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 39:
#line 159 "parse.y"
{ yygotominor.yy52 = -atoi(yymsp[0].minor.yy0.z); }
#line 2117 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 40:
        /* No destructor defined for carglist */
        /* No destructor defined for carg */
        break;
      case 41:
        break;
      case 42:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        /* No destructor defined for ccons */
        break;
      case 43:
        /* No destructor defined for ccons */
        break;
      case 44:
#line 164 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2137 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 45:
#line 165 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2143 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 46:
#line 166 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2149 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 47:
#line 167 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2155 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 48:
#line 168 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2162 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 49:
#line 169 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2169 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 50:
#line 170 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2175 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 51:
#line 171 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2182 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 52:
        /* No destructor defined for DEFAULT */
        /* No destructor defined for NULL */
        break;
      case 53:
        /* No destructor defined for NULL */
        /* No destructor defined for onconf */
        break;
      case 54:
#line 178 "parse.y"
{sqliteAddNotNull(pParse, yymsp[0].minor.yy52);}
#line 2197 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for NULL */
        break;
      case 55:
#line 179 "parse.y"
{sqliteAddPrimaryKey(pParse,0,yymsp[0].minor.yy52);}
#line 2204 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for sortorder */
        break;
      case 56:
#line 180 "parse.y"
{sqliteCreateIndex(pParse,0,0,0,yymsp[0].minor.yy52,0,0);}
#line 2212 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 57:
        /* No destructor defined for CHECK */
        /* No destructor defined for LP */
  yy_destructor(157,&yymsp[-2].minor);
        /* No destructor defined for RP */
        /* No destructor defined for onconf */
        break;
      case 58:
#line 183 "parse.y"
{sqliteCreateForeignKey(pParse,0,&yymsp[-2].minor.yy210,yymsp[-1].minor.yy92,yymsp[0].minor.yy52);}
#line 2225 "parse.c"
        /* No destructor defined for REFERENCES */
        break;
      case 59:
#line 184 "parse.y"
{sqliteDeferForeignKey(pParse,yymsp[0].minor.yy52);}
#line 2231 "parse.c"
        break;
      case 60:
#line 185 "parse.y"
{
   sqliteAddCollateType(pParse, sqliteCollateType(yymsp[0].minor.yy210.z, yymsp[0].minor.yy210.n));
}
#line 2238 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 61:
#line 195 "parse.y"
{ yygotominor.yy52 = OE_Restrict * 0x010101; }
#line 2244 "parse.c"
        break;
      case 62:
#line 196 "parse.y"
{ yygotominor.yy52 = (yymsp[-1].minor.yy52 & yymsp[0].minor.yy279.mask) | yymsp[0].minor.yy279.value; }
#line 2249 "parse.c"
        break;
      case 63:
#line 198 "parse.y"
{ yygotominor.yy279.value = 0;     yygotominor.yy279.mask = 0x000000; }
#line 2254 "parse.c"
        /* No destructor defined for MATCH */
        /* No destructor defined for nm */
        break;
      case 64:
#line 199 "parse.y"
{ yygotominor.yy279.value = yymsp[0].minor.yy52;     yygotominor.yy279.mask = 0x0000ff; }
#line 2261 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for DELETE */
        break;
      case 65:
#line 200 "parse.y"
{ yygotominor.yy279.value = yymsp[0].minor.yy52<<8;  yygotominor.yy279.mask = 0x00ff00; }
#line 2268 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for UPDATE */
        break;
      case 66:
#line 201 "parse.y"
{ yygotominor.yy279.value = yymsp[0].minor.yy52<<16; yygotominor.yy279.mask = 0xff0000; }
#line 2275 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for INSERT */
        break;
      case 67:
#line 203 "parse.y"
{ yygotominor.yy52 = OE_SetNull; }
#line 2282 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for NULL */
        break;
      case 68:
#line 204 "parse.y"
{ yygotominor.yy52 = OE_SetDflt; }
#line 2289 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for DEFAULT */
        break;
      case 69:
#line 205 "parse.y"
{ yygotominor.yy52 = OE_Cascade; }
#line 2296 "parse.c"
        /* No destructor defined for CASCADE */
        break;
      case 70:
#line 206 "parse.y"
{ yygotominor.yy52 = OE_Restrict; }
#line 2302 "parse.c"
        /* No destructor defined for RESTRICT */
        break;
      case 71:
#line 208 "parse.y"
{yygotominor.yy52 = yymsp[0].minor.yy52;}
#line 2308 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for DEFERRABLE */
        break;
      case 72:
#line 209 "parse.y"
{yygotominor.yy52 = yymsp[0].minor.yy52;}
#line 2315 "parse.c"
        /* No destructor defined for DEFERRABLE */
        break;
      case 73:
#line 211 "parse.y"
{yygotominor.yy52 = 0;}
#line 2321 "parse.c"
        break;
      case 74:
#line 212 "parse.y"
{yygotominor.yy52 = 1;}
#line 2326 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for DEFERRED */
        break;
      case 75:
#line 213 "parse.y"
{yygotominor.yy52 = 0;}
#line 2333 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for IMMEDIATE */
        break;
      case 76:
        break;
      case 77:
        /* No destructor defined for COMMA */
        /* No destructor defined for conslist */
        break;
      case 78:
        /* No destructor defined for conslist */
        /* No destructor defined for COMMA */
        /* No destructor defined for tcons */
        break;
      case 79:
        /* No destructor defined for conslist */
        /* No destructor defined for tcons */
        break;
      case 80:
        /* No destructor defined for tcons */
        break;
      case 81:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        break;
      case 82:
#line 225 "parse.y"
{sqliteAddPrimaryKey(pParse,yymsp[-2].minor.yy92,yymsp[0].minor.yy52);}
#line 2362 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 83:
#line 227 "parse.y"
{sqliteCreateIndex(pParse,0,0,yymsp[-2].minor.yy92,yymsp[0].minor.yy52,0,0);}
#line 2371 "parse.c"
        /* No destructor defined for UNIQUE */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 84:
        /* No destructor defined for CHECK */
  yy_destructor(157,&yymsp[-1].minor);
        /* No destructor defined for onconf */
        break;
      case 85:
#line 230 "parse.y"
{
    sqliteCreateForeignKey(pParse, yymsp[-6].minor.yy92, &yymsp[-3].minor.yy210, yymsp[-2].minor.yy92, yymsp[-1].minor.yy52);
    sqliteDeferForeignKey(pParse, yymsp[0].minor.yy52);
}
#line 2387 "parse.c"
        /* No destructor defined for FOREIGN */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        /* No destructor defined for REFERENCES */
        break;
      case 86:
#line 235 "parse.y"
{yygotominor.yy52 = 0;}
#line 2397 "parse.c"
        break;
      case 87:
#line 236 "parse.y"
{yygotominor.yy52 = yymsp[0].minor.yy52;}
#line 2402 "parse.c"
        break;
      case 88:
#line 244 "parse.y"
{ yygotominor.yy52 = OE_Default; }
#line 2407 "parse.c"
        break;
      case 89:
#line 245 "parse.y"
{ yygotominor.yy52 = yymsp[0].minor.yy52; }
#line 2412 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for CONFLICT */
        break;
      case 90:
#line 246 "parse.y"
{ yygotominor.yy52 = OE_Default; }
#line 2419 "parse.c"
        break;
      case 91:
#line 247 "parse.y"
{ yygotominor.yy52 = yymsp[0].minor.yy52; }
#line 2424 "parse.c"
        /* No destructor defined for OR */
        break;
      case 92:
#line 248 "parse.y"
{ yygotominor.yy52 = OE_Rollback; }
#line 2430 "parse.c"
        /* No destructor defined for ROLLBACK */
        break;
      case 93:
#line 249 "parse.y"
{ yygotominor.yy52 = OE_Abort; }
#line 2436 "parse.c"
        /* No destructor defined for ABORT */
        break;
      case 94:
#line 250 "parse.y"
{ yygotominor.yy52 = OE_Fail; }
#line 2442 "parse.c"
        /* No destructor defined for FAIL */
        break;
      case 95:
#line 251 "parse.y"
{ yygotominor.yy52 = OE_Ignore; }
#line 2448 "parse.c"
        /* No destructor defined for IGNORE */
        break;
      case 96:
#line 252 "parse.y"
{ yygotominor.yy52 = OE_Replace; }
#line 2454 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 97:
#line 256 "parse.y"
{sqliteDropTable(pParse,&yymsp[0].minor.yy210,0);}
#line 2460 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TABLE */
        break;
      case 98:
#line 260 "parse.y"
{
  sqliteCreateView(pParse, &yymsp[-5].minor.yy0, &yymsp[-2].minor.yy210, yymsp[0].minor.yy11, yymsp[-4].minor.yy52);
}
#line 2469 "parse.c"
        /* No destructor defined for VIEW */
        /* No destructor defined for AS */
        break;
      case 99:
#line 263 "parse.y"
{
  sqliteDropTable(pParse, &yymsp[0].minor.yy210, 1);
}
#line 2478 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for VIEW */
        break;
      case 100:
#line 269 "parse.y"
{
  sqliteSelect(pParse, yymsp[0].minor.yy11, SRT_Callback, 0, 0, 0, 0);
  sqliteSelectDelete(yymsp[0].minor.yy11);
}
#line 2488 "parse.c"
        break;
      case 101:
#line 279 "parse.y"
{yygotominor.yy11 = yymsp[0].minor.yy11;}
#line 2493 "parse.c"
        break;
      case 102:
#line 280 "parse.y"
{
  if( yymsp[0].minor.yy11 ){
    yymsp[0].minor.yy11->op = yymsp[-1].minor.yy52;
    yymsp[0].minor.yy11->pPrior = yymsp[-2].minor.yy11;
  }
  yygotominor.yy11 = yymsp[0].minor.yy11;
}
#line 2504 "parse.c"
        break;
      case 103:
#line 288 "parse.y"
{yygotominor.yy52 = TK_UNION;}
#line 2509 "parse.c"
        /* No destructor defined for UNION */
        break;
      case 104:
#line 289 "parse.y"
{yygotominor.yy52 = TK_ALL;}
#line 2515 "parse.c"
        /* No destructor defined for UNION */
        /* No destructor defined for ALL */
        break;
      case 105:
#line 290 "parse.y"
{yygotominor.yy52 = TK_INTERSECT;}
#line 2522 "parse.c"
        /* No destructor defined for INTERSECT */
        break;
      case 106:
#line 291 "parse.y"
{yygotominor.yy52 = TK_EXCEPT;}
#line 2528 "parse.c"
        /* No destructor defined for EXCEPT */
        break;
      case 107:
#line 293 "parse.y"
{
  yygotominor.yy11 = sqliteSelectNew(yymsp[-6].minor.yy62,yymsp[-5].minor.yy335,yymsp[-4].minor.yy334,yymsp[-3].minor.yy62,yymsp[-2].minor.yy334,yymsp[-1].minor.yy62,yymsp[-7].minor.yy52,yymsp[0].minor.yy280.limit,yymsp[0].minor.yy280.offset);
}
#line 2536 "parse.c"
        /* No destructor defined for SELECT */
        break;
      case 108:
#line 301 "parse.y"
{yygotominor.yy52 = 1;}
#line 2542 "parse.c"
        /* No destructor defined for DISTINCT */
        break;
      case 109:
#line 302 "parse.y"
{yygotominor.yy52 = 0;}
#line 2548 "parse.c"
        /* No destructor defined for ALL */
        break;
      case 110:
#line 303 "parse.y"
{yygotominor.yy52 = 0;}
#line 2554 "parse.c"
        break;
      case 111:
#line 314 "parse.y"
{yygotominor.yy62 = yymsp[-1].minor.yy62;}
#line 2559 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 112:
#line 315 "parse.y"
{yygotominor.yy62 = 0;}
#line 2565 "parse.c"
        break;
      case 113:
#line 316 "parse.y"
{
   yygotominor.yy62 = sqliteExprListAppend(yymsp[-2].minor.yy62,yymsp[-1].minor.yy334,yymsp[0].minor.yy210.n?&yymsp[0].minor.yy210:0);
}
#line 2572 "parse.c"
        break;
      case 114:
#line 319 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(yymsp[-1].minor.yy62, sqliteExpr(TK_ALL, 0, 0, 0), 0);
}
#line 2579 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 115:
#line 322 "parse.y"
{
  Expr *pRight = sqliteExpr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  yygotominor.yy62 = sqliteExprListAppend(yymsp[-3].minor.yy62, sqliteExpr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2589 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for STAR */
        break;
      case 116:
#line 332 "parse.y"
{ yygotominor.yy210 = yymsp[0].minor.yy210; }
#line 2596 "parse.c"
        /* No destructor defined for AS */
        break;
      case 117:
#line 333 "parse.y"
{ yygotominor.yy210 = yymsp[0].minor.yy210; }
#line 2602 "parse.c"
        break;
      case 118:
#line 334 "parse.y"
{ yygotominor.yy210.n = 0; }
#line 2607 "parse.c"
        break;
      case 119:
#line 346 "parse.y"
{yygotominor.yy335 = sqliteMalloc(sizeof(*yygotominor.yy335));}
#line 2612 "parse.c"
        break;
      case 120:
#line 347 "parse.y"
{yygotominor.yy335 = yymsp[0].minor.yy335;}
#line 2617 "parse.c"
        /* No destructor defined for FROM */
        break;
      case 121:
#line 352 "parse.y"
{
   yygotominor.yy335 = yymsp[-1].minor.yy335;
   if( yygotominor.yy335 && yygotominor.yy335->nSrc>0 ) yygotominor.yy335->a[yygotominor.yy335->nSrc-1].jointype = yymsp[0].minor.yy52;
}
#line 2626 "parse.c"
        break;
      case 122:
#line 356 "parse.y"
{yygotominor.yy335 = 0;}
#line 2631 "parse.c"
        break;
      case 123:
#line 357 "parse.y"
{
  yygotominor.yy335 = sqliteSrcListAppend(yymsp[-5].minor.yy335,&yymsp[-4].minor.yy210,&yymsp[-3].minor.yy210);
  if( yymsp[-2].minor.yy210.n ) sqliteSrcListAddAlias(yygotominor.yy335,&yymsp[-2].minor.yy210);
  if( yymsp[-1].minor.yy334 ){
    if( yygotominor.yy335 && yygotominor.yy335->nSrc>1 ){ yygotominor.yy335->a[yygotominor.yy335->nSrc-2].pOn = yymsp[-1].minor.yy334; }
    else { sqliteExprDelete(yymsp[-1].minor.yy334); }
  }
  if( yymsp[0].minor.yy92 ){
    if( yygotominor.yy335 && yygotominor.yy335->nSrc>1 ){ yygotominor.yy335->a[yygotominor.yy335->nSrc-2].pUsing = yymsp[0].minor.yy92; }
    else { sqliteIdListDelete(yymsp[0].minor.yy92); }
  }
}
#line 2647 "parse.c"
        break;
      case 124:
#line 369 "parse.y"
{
  yygotominor.yy335 = sqliteSrcListAppend(yymsp[-6].minor.yy335,0,0);
  yygotominor.yy335->a[yygotominor.yy335->nSrc-1].pSelect = yymsp[-4].minor.yy11;
  if( yymsp[-2].minor.yy210.n ) sqliteSrcListAddAlias(yygotominor.yy335,&yymsp[-2].minor.yy210);
  if( yymsp[-1].minor.yy334 ){
    if( yygotominor.yy335 && yygotominor.yy335->nSrc>1 ){ yygotominor.yy335->a[yygotominor.yy335->nSrc-2].pOn = yymsp[-1].minor.yy334; }
    else { sqliteExprDelete(yymsp[-1].minor.yy334); }
  }
  if( yymsp[0].minor.yy92 ){
    if( yygotominor.yy335 && yygotominor.yy335->nSrc>1 ){ yygotominor.yy335->a[yygotominor.yy335->nSrc-2].pUsing = yymsp[0].minor.yy92; }
    else { sqliteIdListDelete(yymsp[0].minor.yy92); }
  }
}
#line 2664 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 125:
#line 384 "parse.y"
{yygotominor.yy210.z=0; yygotominor.yy210.n=0;}
#line 2671 "parse.c"
        break;
      case 126:
#line 385 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 2676 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 127:
#line 389 "parse.y"
{ yygotominor.yy52 = JT_INNER; }
#line 2682 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 128:
#line 390 "parse.y"
{ yygotominor.yy52 = JT_INNER; }
#line 2688 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 129:
#line 391 "parse.y"
{ yygotominor.yy52 = sqliteJoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2694 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 130:
#line 392 "parse.y"
{ yygotominor.yy52 = sqliteJoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy210,0); }
#line 2700 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 131:
#line 394 "parse.y"
{ yygotominor.yy52 = sqliteJoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy210,&yymsp[-1].minor.yy210); }
#line 2706 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 132:
#line 398 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 2712 "parse.c"
        /* No destructor defined for ON */
        break;
      case 133:
#line 399 "parse.y"
{yygotominor.yy334 = 0;}
#line 2718 "parse.c"
        break;
      case 134:
#line 403 "parse.y"
{yygotominor.yy92 = yymsp[-1].minor.yy92;}
#line 2723 "parse.c"
        /* No destructor defined for USING */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 135:
#line 404 "parse.y"
{yygotominor.yy92 = 0;}
#line 2731 "parse.c"
        break;
      case 136:
#line 414 "parse.y"
{yygotominor.yy62 = 0;}
#line 2736 "parse.c"
        break;
      case 137:
#line 415 "parse.y"
{yygotominor.yy62 = yymsp[0].minor.yy62;}
#line 2741 "parse.c"
        /* No destructor defined for ORDER */
        /* No destructor defined for BY */
        break;
      case 138:
#line 416 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(yymsp[-4].minor.yy62,yymsp[-2].minor.yy334,0);
  if( yygotominor.yy62 ) yygotominor.yy62->a[yygotominor.yy62->nExpr-1].sortOrder = yymsp[-1].minor.yy52+yymsp[0].minor.yy52;
}
#line 2751 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 139:
#line 420 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(0,yymsp[-2].minor.yy334,0);
  if( yygotominor.yy62 ) yygotominor.yy62->a[0].sortOrder = yymsp[-1].minor.yy52+yymsp[0].minor.yy52;
}
#line 2760 "parse.c"
        break;
      case 140:
#line 424 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 2765 "parse.c"
        break;
      case 141:
#line 429 "parse.y"
{yygotominor.yy52 = SQLITE_SO_ASC;}
#line 2770 "parse.c"
        /* No destructor defined for ASC */
        break;
      case 142:
#line 430 "parse.y"
{yygotominor.yy52 = SQLITE_SO_DESC;}
#line 2776 "parse.c"
        /* No destructor defined for DESC */
        break;
      case 143:
#line 431 "parse.y"
{yygotominor.yy52 = SQLITE_SO_ASC;}
#line 2782 "parse.c"
        break;
      case 144:
#line 432 "parse.y"
{yygotominor.yy52 = SQLITE_SO_UNK;}
#line 2787 "parse.c"
        break;
      case 145:
#line 433 "parse.y"
{yygotominor.yy52 = sqliteCollateType(yymsp[0].minor.yy210.z, yymsp[0].minor.yy210.n);}
#line 2792 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 146:
#line 437 "parse.y"
{yygotominor.yy62 = 0;}
#line 2798 "parse.c"
        break;
      case 147:
#line 438 "parse.y"
{yygotominor.yy62 = yymsp[0].minor.yy62;}
#line 2803 "parse.c"
        /* No destructor defined for GROUP */
        /* No destructor defined for BY */
        break;
      case 148:
#line 442 "parse.y"
{yygotominor.yy334 = 0;}
#line 2810 "parse.c"
        break;
      case 149:
#line 443 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 2815 "parse.c"
        /* No destructor defined for HAVING */
        break;
      case 150:
#line 446 "parse.y"
{yygotominor.yy280.limit = -1; yygotominor.yy280.offset = 0;}
#line 2821 "parse.c"
        break;
      case 151:
#line 447 "parse.y"
{yygotominor.yy280.limit = yymsp[0].minor.yy52; yygotominor.yy280.offset = 0;}
#line 2826 "parse.c"
        /* No destructor defined for LIMIT */
        break;
      case 152:
#line 449 "parse.y"
{yygotominor.yy280.limit = yymsp[-2].minor.yy52; yygotominor.yy280.offset = yymsp[0].minor.yy52;}
#line 2832 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for OFFSET */
        break;
      case 153:
#line 451 "parse.y"
{yygotominor.yy280.limit = yymsp[0].minor.yy52; yygotominor.yy280.offset = yymsp[-2].minor.yy52;}
#line 2839 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for COMMA */
        break;
      case 154:
#line 455 "parse.y"
{
   sqliteDeleteFrom(pParse, sqliteSrcListAppend(0,&yymsp[-2].minor.yy210,&yymsp[-1].minor.yy210), yymsp[0].minor.yy334);
}
#line 2848 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 155:
#line 462 "parse.y"
{yygotominor.yy334 = 0;}
#line 2855 "parse.c"
        break;
      case 156:
#line 463 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 2860 "parse.c"
        /* No destructor defined for WHERE */
        break;
      case 157:
#line 471 "parse.y"
{sqliteUpdate(pParse,sqliteSrcListAppend(0,&yymsp[-4].minor.yy210,&yymsp[-3].minor.yy210),yymsp[-1].minor.yy62,yymsp[0].minor.yy334,yymsp[-5].minor.yy52);}
#line 2866 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 158:
#line 474 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(yymsp[-4].minor.yy62,yymsp[0].minor.yy334,&yymsp[-2].minor.yy210);}
#line 2873 "parse.c"
        /* No destructor defined for COMMA */
        /* No destructor defined for EQ */
        break;
      case 159:
#line 475 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(0,yymsp[0].minor.yy334,&yymsp[-2].minor.yy210);}
#line 2880 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 160:
#line 481 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-6].minor.yy210,&yymsp[-5].minor.yy210), yymsp[-1].minor.yy62, 0, yymsp[-4].minor.yy92, yymsp[-8].minor.yy52);}
#line 2886 "parse.c"
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 161:
#line 483 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210), 0, yymsp[0].minor.yy11, yymsp[-1].minor.yy92, yymsp[-5].minor.yy52);}
#line 2895 "parse.c"
        /* No destructor defined for INTO */
        break;
      case 162:
#line 486 "parse.y"
{yygotominor.yy52 = yymsp[0].minor.yy52;}
#line 2901 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 163:
#line 487 "parse.y"
{yygotominor.yy52 = OE_Replace;}
#line 2907 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 164:
#line 493 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(yymsp[-2].minor.yy62,yymsp[0].minor.yy334,0);}
#line 2913 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 165:
#line 494 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(0,yymsp[0].minor.yy334,0);}
#line 2919 "parse.c"
        break;
      case 166:
#line 501 "parse.y"
{yygotominor.yy92 = 0;}
#line 2924 "parse.c"
        break;
      case 167:
#line 502 "parse.y"
{yygotominor.yy92 = yymsp[-1].minor.yy92;}
#line 2929 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 168:
#line 503 "parse.y"
{yygotominor.yy92 = sqliteIdListAppend(yymsp[-2].minor.yy92,&yymsp[0].minor.yy210);}
#line 2936 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 169:
#line 504 "parse.y"
{yygotominor.yy92 = sqliteIdListAppend(0,&yymsp[0].minor.yy210);}
#line 2942 "parse.c"
        break;
      case 170:
#line 522 "parse.y"
{yygotominor.yy334 = yymsp[-1].minor.yy334; sqliteExprSpan(yygotominor.yy334,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2947 "parse.c"
        break;
      case 171:
#line 523 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_NULL, 0, 0, &yymsp[0].minor.yy0);}
#line 2952 "parse.c"
        break;
      case 172:
#line 524 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2957 "parse.c"
        break;
      case 173:
#line 525 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2962 "parse.c"
        break;
      case 174:
#line 526 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy210);
  yygotominor.yy334 = sqliteExpr(TK_DOT, temp1, temp2, 0);
}
#line 2971 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 175:
#line 531 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-4].minor.yy210);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  Expr *temp3 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy210);
  Expr *temp4 = sqliteExpr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy334 = sqliteExpr(TK_DOT, temp1, temp4, 0);
}
#line 2983 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for DOT */
        break;
      case 176:
#line 538 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 2990 "parse.c"
        break;
      case 177:
#line 539 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 2995 "parse.c"
        break;
      case 178:
#line 540 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 3000 "parse.c"
        break;
      case 179:
#line 541 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_VARIABLE, 0, 0, &yymsp[0].minor.yy0);
  if( yygotominor.yy334 ) yygotominor.yy334->iTable = ++pParse->nVar;
}
#line 3008 "parse.c"
        break;
      case 180:
#line 545 "parse.y"
{
  yygotominor.yy334 = sqliteExprFunction(yymsp[-1].minor.yy62, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3016 "parse.c"
        /* No destructor defined for LP */
        break;
      case 181:
#line 549 "parse.y"
{
  yygotominor.yy334 = sqliteExprFunction(0, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3025 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for STAR */
        break;
      case 182:
#line 553 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_AND, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3032 "parse.c"
        /* No destructor defined for AND */
        break;
      case 183:
#line 554 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_OR, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3038 "parse.c"
        /* No destructor defined for OR */
        break;
      case 184:
#line 555 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_LT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3044 "parse.c"
        /* No destructor defined for LT */
        break;
      case 185:
#line 556 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_GT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3050 "parse.c"
        /* No destructor defined for GT */
        break;
      case 186:
#line 557 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_LE, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3056 "parse.c"
        /* No destructor defined for LE */
        break;
      case 187:
#line 558 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_GE, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3062 "parse.c"
        /* No destructor defined for GE */
        break;
      case 188:
#line 559 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_NE, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3068 "parse.c"
        /* No destructor defined for NE */
        break;
      case 189:
#line 560 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_EQ, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3074 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 190:
#line 561 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_BITAND, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3080 "parse.c"
        /* No destructor defined for BITAND */
        break;
      case 191:
#line 562 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_BITOR, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3086 "parse.c"
        /* No destructor defined for BITOR */
        break;
      case 192:
#line 563 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_LSHIFT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3092 "parse.c"
        /* No destructor defined for LSHIFT */
        break;
      case 193:
#line 564 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_RSHIFT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3098 "parse.c"
        /* No destructor defined for RSHIFT */
        break;
      case 194:
#line 565 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy334, 0);
  pList = sqliteExprListAppend(pList, yymsp[-2].minor.yy334, 0);
  yygotominor.yy334 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->op = yymsp[-1].minor.yy52;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-2].minor.yy334->span, &yymsp[0].minor.yy334->span);
}
#line 3110 "parse.c"
        break;
      case 195:
#line 572 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy334, 0);
  pList = sqliteExprListAppend(pList, yymsp[-3].minor.yy334, 0);
  yygotominor.yy334 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->op = yymsp[-1].minor.yy52;
  yygotominor.yy334 = sqliteExpr(TK_NOT, yygotominor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-3].minor.yy334->span,&yymsp[0].minor.yy334->span);
}
#line 3122 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 196:
#line 581 "parse.y"
{yygotominor.yy52 = TK_LIKE;}
#line 3128 "parse.c"
        /* No destructor defined for LIKE */
        break;
      case 197:
#line 582 "parse.y"
{yygotominor.yy52 = TK_GLOB;}
#line 3134 "parse.c"
        /* No destructor defined for GLOB */
        break;
      case 198:
#line 583 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_PLUS, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3140 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 199:
#line 584 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_MINUS, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3146 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 200:
#line 585 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_STAR, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3152 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 201:
#line 586 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_SLASH, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3158 "parse.c"
        /* No destructor defined for SLASH */
        break;
      case 202:
#line 587 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_REM, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3164 "parse.c"
        /* No destructor defined for REM */
        break;
      case 203:
#line 588 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_CONCAT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3170 "parse.c"
        /* No destructor defined for CONCAT */
        break;
      case 204:
#line 589 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_ISNULL, yymsp[-1].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3179 "parse.c"
        break;
      case 205:
#line 593 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_ISNULL, yymsp[-2].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-2].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3187 "parse.c"
        /* No destructor defined for IS */
        break;
      case 206:
#line 597 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_NOTNULL, yymsp[-1].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3196 "parse.c"
        break;
      case 207:
#line 601 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_NOTNULL, yymsp[-2].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-2].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3204 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 208:
#line 605 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_NOTNULL, yymsp[-3].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-3].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3213 "parse.c"
        /* No destructor defined for IS */
        /* No destructor defined for NOT */
        break;
      case 209:
#line 609 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_NOT, yymsp[0].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy334->span);
}
#line 3223 "parse.c"
        break;
      case 210:
#line 613 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_BITNOT, yymsp[0].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy334->span);
}
#line 3231 "parse.c"
        break;
      case 211:
#line 617 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_UMINUS, yymsp[0].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy334->span);
}
#line 3239 "parse.c"
        break;
      case 212:
#line 621 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_UPLUS, yymsp[0].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy334->span);
}
#line 3247 "parse.c"
        break;
      case 213:
#line 625 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pSelect = yymsp[-1].minor.yy11;
  sqliteExprSpan(yygotominor.yy334,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3256 "parse.c"
        break;
      case 214:
#line 630 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy334, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy334, 0);
  yygotominor.yy334 = sqliteExpr(TK_BETWEEN, yymsp[-4].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = pList;
  sqliteExprSpan(yygotominor.yy334,&yymsp[-4].minor.yy334->span,&yymsp[0].minor.yy334->span);
}
#line 3267 "parse.c"
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 215:
#line 637 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy334, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy334, 0);
  yygotominor.yy334 = sqliteExpr(TK_BETWEEN, yymsp[-5].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = pList;
  yygotominor.yy334 = sqliteExpr(TK_NOT, yygotominor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-5].minor.yy334->span,&yymsp[0].minor.yy334->span);
}
#line 3281 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 216:
#line 645 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_IN, yymsp[-4].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = yymsp[-1].minor.yy62;
  sqliteExprSpan(yygotominor.yy334,&yymsp[-4].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3293 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 217:
#line 650 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_IN, yymsp[-4].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pSelect = yymsp[-1].minor.yy11;
  sqliteExprSpan(yygotominor.yy334,&yymsp[-4].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3304 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 218:
#line 655 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_IN, yymsp[-5].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = yymsp[-1].minor.yy62;
  yygotominor.yy334 = sqliteExpr(TK_NOT, yygotominor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-5].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3316 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 219:
#line 661 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_IN, yymsp[-5].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pSelect = yymsp[-1].minor.yy11;
  yygotominor.yy334 = sqliteExpr(TK_NOT, yygotominor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-5].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3329 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 220:
#line 669 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_CASE, yymsp[-3].minor.yy334, yymsp[-1].minor.yy334, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = yymsp[-2].minor.yy62;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3341 "parse.c"
        break;
      case 221:
#line 676 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(yymsp[-4].minor.yy62, yymsp[-2].minor.yy334, 0);
  yygotominor.yy62 = sqliteExprListAppend(yygotominor.yy62, yymsp[0].minor.yy334, 0);
}
#line 3349 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 222:
#line 680 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(0, yymsp[-2].minor.yy334, 0);
  yygotominor.yy62 = sqliteExprListAppend(yygotominor.yy62, yymsp[0].minor.yy334, 0);
}
#line 3359 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 223:
#line 685 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 3366 "parse.c"
        /* No destructor defined for ELSE */
        break;
      case 224:
#line 686 "parse.y"
{yygotominor.yy334 = 0;}
#line 3372 "parse.c"
        break;
      case 225:
#line 688 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 3377 "parse.c"
        break;
      case 226:
#line 689 "parse.y"
{yygotominor.yy334 = 0;}
#line 3382 "parse.c"
        break;
      case 227:
#line 697 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(yymsp[-2].minor.yy62,yymsp[0].minor.yy334,0);}
#line 3387 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 228:
#line 698 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(0,yymsp[0].minor.yy334,0);}
#line 3393 "parse.c"
        break;
      case 229:
#line 699 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 3398 "parse.c"
        break;
      case 230:
#line 700 "parse.y"
{yygotominor.yy334 = 0;}
#line 3403 "parse.c"
        break;
      case 231:
#line 705 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-5].minor.yy210, &yymsp[-4].minor.yy210);
  if( yymsp[-9].minor.yy52!=OE_None ) yymsp[-9].minor.yy52 = yymsp[0].minor.yy52;
  if( yymsp[-9].minor.yy52==OE_Default) yymsp[-9].minor.yy52 = OE_Abort;
  sqliteCreateIndex(pParse, &yymsp[-7].minor.yy210, pSrc, yymsp[-2].minor.yy92, yymsp[-9].minor.yy52, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 3413 "parse.c"
        /* No destructor defined for INDEX */
        /* No destructor defined for ON */
        /* No destructor defined for LP */
        break;
      case 232:
#line 713 "parse.y"
{ yygotominor.yy52 = OE_Abort; }
#line 3421 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 233:
#line 714 "parse.y"
{ yygotominor.yy52 = OE_None; }
#line 3427 "parse.c"
        break;
      case 234:
#line 722 "parse.y"
{yygotominor.yy92 = 0;}
#line 3432 "parse.c"
        break;
      case 235:
#line 723 "parse.y"
{yygotominor.yy92 = yymsp[-1].minor.yy92;}
#line 3437 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 236:
#line 724 "parse.y"
{yygotominor.yy92 = sqliteIdListAppend(yymsp[-2].minor.yy92,&yymsp[0].minor.yy210);}
#line 3444 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 237:
#line 725 "parse.y"
{yygotominor.yy92 = sqliteIdListAppend(0,&yymsp[0].minor.yy210);}
#line 3450 "parse.c"
        break;
      case 238:
#line 726 "parse.y"
{yygotominor.yy210 = yymsp[-1].minor.yy210;}
#line 3455 "parse.c"
        /* No destructor defined for sortorder */
        break;
      case 239:
#line 731 "parse.y"
{
  sqliteDropIndex(pParse, sqliteSrcListAppend(0,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210));
}
#line 3463 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for INDEX */
        break;
      case 240:
#line 739 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-6].minor.yy210,&yymsp[-5].minor.yy210),&yymsp[-3].minor.yy210,&yymsp[0].minor.yy0,yymsp[-7].minor.yy52);}
#line 3470 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        /* No destructor defined for USING */
        /* No destructor defined for DELIMITERS */
        break;
      case 241:
#line 741 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210),&yymsp[0].minor.yy210,0,yymsp[-4].minor.yy52);}
#line 3479 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        break;
      case 242:
#line 745 "parse.y"
{sqliteVacuum(pParse,0);}
#line 3486 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 243:
#line 746 "parse.y"
{sqliteVacuum(pParse,&yymsp[0].minor.yy210);}
#line 3492 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 244:
#line 750 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,0);}
#line 3498 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 245:
#line 751 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy0,0);}
#line 3505 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 246:
#line 752 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,0);}
#line 3512 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 247:
#line 753 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,1);}
#line 3519 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 248:
#line 754 "parse.y"
{sqlitePragma(pParse,&yymsp[-3].minor.yy210,&yymsp[-1].minor.yy210,0);}
#line 3526 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 249:
#line 755 "parse.y"
{sqlitePragma(pParse,&yymsp[0].minor.yy210,&yymsp[0].minor.yy210,0);}
#line 3534 "parse.c"
        /* No destructor defined for PRAGMA */
        break;
      case 250:
#line 756 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 3540 "parse.c"
        /* No destructor defined for plus_opt */
        break;
      case 251:
#line 757 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 3546 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 252:
#line 758 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 3552 "parse.c"
        break;
      case 253:
#line 759 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 3557 "parse.c"
        break;
      case 254:
        /* No destructor defined for PLUS */
        break;
      case 255:
        break;
      case 256:
#line 765 "parse.y"
{
  Token all;
  all.z = yymsp[-4].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-4].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqliteFinishTrigger(pParse, yymsp[-1].minor.yy347, &all);
}
#line 3572 "parse.c"
        /* No destructor defined for trigger_decl */
        /* No destructor defined for BEGIN */
        break;
      case 257:
#line 773 "parse.y"
{
  SrcList *pTab = sqliteSrcListAppend(0, &yymsp[-3].minor.yy210, &yymsp[-2].minor.yy210);
  sqliteBeginTrigger(pParse, &yymsp[-7].minor.yy210, yymsp[-6].minor.yy52, yymsp[-5].minor.yy234.a, yymsp[-5].minor.yy234.b, pTab, yymsp[-1].minor.yy52, yymsp[0].minor.yy270, yymsp[-9].minor.yy52);
}
#line 3582 "parse.c"
        /* No destructor defined for TRIGGER */
        /* No destructor defined for ON */
        break;
      case 258:
#line 779 "parse.y"
{ yygotominor.yy52 = TK_BEFORE; }
#line 3589 "parse.c"
        /* No destructor defined for BEFORE */
        break;
      case 259:
#line 780 "parse.y"
{ yygotominor.yy52 = TK_AFTER;  }
#line 3595 "parse.c"
        /* No destructor defined for AFTER */
        break;
      case 260:
#line 781 "parse.y"
{ yygotominor.yy52 = TK_INSTEAD;}
#line 3601 "parse.c"
        /* No destructor defined for INSTEAD */
        /* No destructor defined for OF */
        break;
      case 261:
#line 782 "parse.y"
{ yygotominor.yy52 = TK_BEFORE; }
#line 3608 "parse.c"
        break;
      case 262:
#line 786 "parse.y"
{ yygotominor.yy234.a = TK_DELETE; yygotominor.yy234.b = 0; }
#line 3613 "parse.c"
        /* No destructor defined for DELETE */
        break;
      case 263:
#line 787 "parse.y"
{ yygotominor.yy234.a = TK_INSERT; yygotominor.yy234.b = 0; }
#line 3619 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 264:
#line 788 "parse.y"
{ yygotominor.yy234.a = TK_UPDATE; yygotominor.yy234.b = 0;}
#line 3625 "parse.c"
        /* No destructor defined for UPDATE */
        break;
      case 265:
#line 789 "parse.y"
{yygotominor.yy234.a = TK_UPDATE; yygotominor.yy234.b = yymsp[0].minor.yy92; }
#line 3631 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for OF */
        break;
      case 266:
#line 792 "parse.y"
{ yygotominor.yy52 = TK_ROW; }
#line 3638 "parse.c"
        break;
      case 267:
#line 793 "parse.y"
{ yygotominor.yy52 = TK_ROW; }
#line 3643 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for ROW */
        break;
      case 268:
#line 794 "parse.y"
{ yygotominor.yy52 = TK_STATEMENT; }
#line 3651 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for STATEMENT */
        break;
      case 269:
#line 797 "parse.y"
{ yygotominor.yy270 = 0; }
#line 3659 "parse.c"
        break;
      case 270:
#line 798 "parse.y"
{ yygotominor.yy270 = yymsp[0].minor.yy334; }
#line 3664 "parse.c"
        /* No destructor defined for WHEN */
        break;
      case 271:
#line 802 "parse.y"
{
  yymsp[-2].minor.yy347->pNext = yymsp[0].minor.yy347;
  yygotominor.yy347 = yymsp[-2].minor.yy347;
}
#line 3673 "parse.c"
        /* No destructor defined for SEMI */
        break;
      case 272:
#line 806 "parse.y"
{ yygotominor.yy347 = 0; }
#line 3679 "parse.c"
        break;
      case 273:
#line 812 "parse.y"
{ yygotominor.yy347 = sqliteTriggerUpdateStep(&yymsp[-3].minor.yy210, yymsp[-1].minor.yy62, yymsp[0].minor.yy334, yymsp[-4].minor.yy52); }
#line 3684 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 274:
#line 817 "parse.y"
{yygotominor.yy347 = sqliteTriggerInsertStep(&yymsp[-5].minor.yy210, yymsp[-4].minor.yy92, yymsp[-1].minor.yy62, 0, yymsp[-7].minor.yy52);}
#line 3691 "parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 275:
#line 820 "parse.y"
{yygotominor.yy347 = sqliteTriggerInsertStep(&yymsp[-2].minor.yy210, yymsp[-1].minor.yy92, 0, yymsp[0].minor.yy11, yymsp[-4].minor.yy52);}
#line 3701 "parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        break;
      case 276:
#line 824 "parse.y"
{yygotominor.yy347 = sqliteTriggerDeleteStep(&yymsp[-1].minor.yy210, yymsp[0].minor.yy334);}
#line 3708 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 277:
#line 827 "parse.y"
{yygotominor.yy347 = sqliteTriggerSelectStep(yymsp[0].minor.yy11); }
#line 3715 "parse.c"
        break;
      case 278:
#line 830 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy334->iColumn = OE_Ignore;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3724 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for IGNORE */
        break;
      case 279:
#line 835 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy210); 
  yygotominor.yy334->iColumn = OE_Rollback;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3735 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for COMMA */
        break;
      case 280:
#line 840 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy210); 
  yygotominor.yy334->iColumn = OE_Abort;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3747 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ABORT */
        /* No destructor defined for COMMA */
        break;
      case 281:
#line 845 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy210); 
  yygotominor.yy334->iColumn = OE_Fail;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3759 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for FAIL */
        /* No destructor defined for COMMA */
        break;
      case 282:
#line 852 "parse.y"
{
  sqliteDropTrigger(pParse,sqliteSrcListAppend(0,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210));
}
#line 3769 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TRIGGER */
        break;
      case 283:
#line 857 "parse.y"
{
  sqliteAttach(pParse, &yymsp[-2].minor.yy210, &yymsp[0].minor.yy210);
}
#line 3778 "parse.c"
        /* No destructor defined for ATTACH */
        /* No destructor defined for database_kw_opt */
        /* No destructor defined for AS */
        break;
      case 284:
        /* No destructor defined for DATABASE */
        break;
      case 285:
        break;
      case 286:
#line 865 "parse.y"
{
  sqliteDetach(pParse, &yymsp[0].minor.yy210);
}
#line 3793 "parse.c"
        /* No destructor defined for DETACH */
        /* No destructor defined for database_kw_opt */
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yypParser->yytop -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqliteParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqliteSetNString(&pParse->zErrMsg, 
          "near \"", -1, TOKEN.z, TOKEN.n, "\": syntax error", -1, 0);
    }else{
      sqliteSetString(&pParse->zErrMsg, "incomplete SQL statement", 0);
    }
  }
  pParse->nErr++;

#line 3850 "parse.c"
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqliteParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqliteParserTOKENTYPE yyminor       /* The value for the token */
  sqliteParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yytop = &yypParser->yystack[0];
    yypParser->yytop->stateno = 0;
    yypParser->yytop->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqliteParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      if( yypParser->yytop->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yypParser->yytop->major != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yypParser->yytop->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
