/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  Expr * yy386;
  struct {int value; int mask;} yy405;
  Token yy410;
  IdList* yy432;
  int yy495;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 586
#define YYNRULE 311
#define YYERRORSYMBOL 138
#define YYERRSYMDT yy495
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   290,  427,  888,  400,  888,  160,  181,  494,   67,   67,
 /*    10 */    67,   67,  551,   69,   69,   69,   69,   70,   70,   71,
 /*    20 */    71,   71,   72,  220,  510,  284,  517,  508,   80,   69,
 /*    30 */    69,   69,   69,   70,   70,   71,   71,   71,   72,  220,
 /*    40 */   536,  514,  478,  473,   66,   90,  301,  501,  500,  506,
 /*    50 */   506,   68,   68,   67,   67,   67,   67,  245,   69,   69,
 /*    60 */    69,   69,   70,   70,   71,   71,   71,   72,  220,  290,
 /*    70 */   567,  542,  494,  402,    9,   64,  168,  527,  478,  546,
 /*    80 */    69,   69,   69,   69,   70,   70,   71,   71,   71,   72,
 /*    90 */   220,   79,  457,   84,  153,  517,  508,  479,  244,   60,
 /*   100 */    70,   70,   71,   71,   71,   72,  220,  456,  452,  521,
 /*   110 */   521,  521,  290,   66,   90,  301,  501,  500,  506,  506,
 /*   120 */    68,   68,   67,   67,   67,   67,  311,   69,   69,   69,
 /*   130 */    69,   70,   70,   71,   71,   71,   72,  220,  517,  508,
 /*   140 */    89,  312,  519,  456,  452,  447,  211,  216,  539,   45,
 /*   150 */   426,  397,  396,  495,  174,  290,   66,   90,  301,  501,
 /*   160 */   500,  506,  506,   68,   68,   67,   67,   67,   67,  620,
 /*   170 */    69,   69,   69,   69,   70,   70,   71,   71,   71,   72,
 /*   180 */   220,  517,  508,  446,  292,  478,  129,  372,  536,  289,
 /*   190 */   329,  552,  475,  543,  176,  338,  304,  488,  486,   66,
 /*   200 */    90,  301,  501,  500,  506,  506,   68,   68,   67,   67,
 /*   210 */    67,   67,  377,   69,   69,   69,   69,   70,   70,   71,
 /*   220 */    71,   71,   72,  220,  523,  386,  437,  290,  544,  150,
 /*   230 */   308,  404,  410,  371,  238,  241,  544,  571,   22,  318,
 /*   240 */   385,  497,  497,    1,  211,  460,   22,  478,  579,  535,
 /*   250 */   456,  452,  166,  517,  508,  343,  346,  347,  361,  478,
 /*   260 */   210,  147,  580,  220,  364,  821,  348,  534,  533,  254,
 /*   270 */    82,   66,   90,  301,  501,  500,  506,  506,   68,   68,
 /*   280 */    67,   67,   67,   67,  379,   69,   69,   69,   69,   70,
 /*   290 */    70,   71,   71,   71,   72,  220,  290,  166,  282,  308,
 /*   300 */   343,  346,  347,  211,  167,  116,  253,  341,  276,  342,
 /*   310 */   204,  348,  456,  452,  479,  205,  378,  281,  318,  195,
 /*   320 */   497,  497,  517,  508,  456,  452,  418,  358,  418,  531,
 /*   330 */   210,  163,  164,  165,  532,   71,   71,   71,   72,  220,
 /*   340 */    66,   90,  301,  501,  500,  506,  506,   68,   68,   67,
 /*   350 */    67,   67,   67,  536,   69,   69,   69,   69,   70,   70,
 /*   360 */    71,   71,   71,   72,  220,  196,  154,  282,  290,  211,
 /*   370 */   336,  466,  401,  112,  116,  253,  341,  276,  342,  204,
 /*   380 */   351,  311,  370,  465,  245,  478,  281,  166,  516,  515,
 /*   390 */   343,  346,  347,  334,  517,  508,  464,  562,  395,  431,
 /*   400 */   434,  348,    2,  539,   46,  546,  161,  161,  390,  511,
 /*   410 */   509,   74,   66,   90,  301,  501,  500,  506,  506,   68,
 /*   420 */    68,   67,   67,   67,   67,  382,   69,   69,   69,   69,
 /*   430 */    70,   70,   71,   71,   71,   72,  220,  290,  512,  414,
 /*   440 */   434,  408,  411,  331,  213,  466,  311,  478,  578,  573,
 /*   450 */   456,  452,  311,  388,  584,  577,   79,  465,   84,  153,
 /*   460 */   156,  293,  293,  517,  508,   72,  220,  281,  539,   46,
 /*   470 */   464,  468,  325,  193,  539,   45,  384,  427,  889,  277,
 /*   480 */   889,   66,   90,  301,  501,  500,  506,  506,   68,   68,
 /*   490 */    67,   67,   67,   67,  536,   69,   69,   69,   69,   70,
 /*   500 */    70,   71,   71,   71,   72,  220,  290,  311,  535,  207,
 /*   510 */   574,  472,  456,  452,  544,  151,  329,  514,  478,  311,
 /*   520 */   246,  328,  311,  581,   22,   79,  534,   84,  153,  539,
 /*   530 */    26,  132,  517,  508,  898,  133,  471,  403,  440,    2,
 /*   540 */   270,  539,   33,  564,  539,   45,  557,  565,  569,  536,
 /*   550 */    66,   90,  301,  501,  500,  506,  506,   68,   68,   67,
 /*   560 */    67,   67,   67,  563,   69,   69,   69,   69,   70,   70,
 /*   570 */    71,   71,   71,   72,  220,  290,  483,  483,  233,  271,
 /*   580 */   230,  478,  311,  456,  452,  311,  333,  423,  380,  210,
 /*   590 */   442,  422,  547,  263,  320,  488,  486,  318,  190,  497,
 /*   600 */   497,  517,  508,  360,  539,   50,  582,  539,   50,  441,
 /*   610 */    79,  454,   84,  153,  318,  300,  497,  497,  453,   66,
 /*   620 */    90,  301,  501,  500,  506,  506,   68,   68,   67,   67,
 /*   630 */    67,   67,  536,   69,   69,   69,   69,   70,   70,   71,
 /*   640 */    71,   71,   72,  220,  290,  337,  456,  452,   20,   86,
 /*   650 */   297,  311,  494,  306,  311,  218,  369,  158,  210,  232,
 /*   660 */   494,  311,   55,  311,  475,  321,  176,  539,    3,  279,
 /*   670 */   517,  508,  267,  539,   39,  221,  539,   36,  268,  365,
 /*   680 */   552,  245,  442,  539,   40,  539,   30,  290,   66,   90,
 /*   690 */   301,  501,  500,  506,  506,   68,   68,   67,   67,   67,
 /*   700 */    67,  311,   69,   69,   69,   69,   70,   70,   71,   71,
 /*   710 */    71,   72,  220,  517,  508,  206,  252,  494,  256,  586,
 /*   720 */   523,  386,  491,  539,   41,  494,  552,  552,  552,  552,
 /*   730 */   290,   66,   90,  301,  501,  500,  506,  506,   68,   68,
 /*   740 */    67,   67,   67,   67,  311,   69,   69,   69,   69,   70,
 /*   750 */    70,   71,   71,   71,   72,  220,  517,  508,  247,  479,
 /*   760 */   205,  294,  302,  303,  295,  316,  539,   38,  540,  433,
 /*   770 */   424,  416,  550,  290,   66,   88,  301,  501,  500,  506,
 /*   780 */   506,   68,   68,   67,   67,   67,   67,  311,   69,   69,
 /*   790 */    69,   69,   70,   70,   71,   71,   71,   72,  220,  517,
 /*   800 */   508,   18,  307,  120,  247,  247,  247,  247,  187,  539,
 /*   810 */    27,  436,  350,  132,  132,  450,  290,  339,   90,  301,
 /*   820 */   501,  500,  506,  506,   68,   68,   67,   67,   67,   67,
 /*   830 */   311,   69,   69,   69,   69,   70,   70,   71,   71,   71,
 /*   840 */    72,  220,  517,  508,  540,  522,  326,   85,  550,  430,
 /*   850 */     8,  193,  539,  115,  152,  317,  160,  558,  494,  132,
 /*   860 */   159,    5,  301,  501,  500,  506,  506,   68,   68,   67,
 /*   870 */    67,   67,   67,  435,   69,   69,   69,   69,   70,   70,
 /*   880 */    71,   71,   71,   72,  220,   77,  322,  311,    4,  311,
 /*   890 */   434,  311,  299,  239,  536,  132,  311,   75,  311,   57,
 /*   900 */   319,   77,  322,  311,    4,  428,  146,   81,  299,  539,
 /*   910 */    47,  539,   25,  539,   52,  311,  319,  324,  539,   97,
 /*   920 */   539,   96,  311,  494,  428,  539,  100,  473,  311,  224,
 /*   930 */   311,  505,  311,  324,  490,  572,   21,  539,  101,  476,
 /*   940 */    19,   85,  142,  473,  539,  111,  311,   63,   73,  222,
 /*   950 */   539,  113,  539,  114,  539,   34,   77,  314,  315,  231,
 /*   960 */   428,  527,  570,   63,   73,  413,  359,  203,  539,   24,
 /*   970 */   200,  549,   77,  314,  315,   77,  322,  527,    4,  211,
 /*   980 */   311,  537,  299,  311,   59,  298,  444,  396,  554,  258,
 /*   990 */   319,  189,  154,  521,  521,  521,  520,  518,   11,  560,
 /*  1000 */   260,  536,  539,   28,  536,  539,   54,  324,  559,  521,
 /*  1010 */   521,  521,  520,  518,   11,  117,  485,  473,  287,  175,
 /*  1020 */   421,  310,  477,  473,  265,  229,  235,  103,  368,  242,
 /*  1030 */   173,  368,  480,  311,  525,  526,  311,   63,   73,  487,
 /*  1040 */   186,  245,  280,  149,  148,  269,   77,  314,  315,  248,
 /*  1050 */   311,  527,  311,  402,  245,  539,   44,  527,  539,   16,
 /*  1060 */   266,  169,  482,  446,  536,  245,  443,  172,  345,  245,
 /*  1070 */   191,  245,  539,   98,  539,   42,  311,  245,  311,  438,
 /*  1080 */   311,  327,  240,  521,  521,  521,  520,  518,   11,  521,
 /*  1090 */   521,  521,  261,  219,  311,  376,  208,  461,  539,   35,
 /*  1100 */   539,   49,  539,   43,  311,  264,  496,  367,  197,  311,
 /*  1110 */   499,  311,  236,  375,  237,  241,  539,   51,  502,  291,
 /*  1120 */   311,  366,  311,  234,  211,  363,  539,   10,  311,  429,
 /*  1130 */   311,  539,   23,  539,   95,  228,  311,  355,  311,  250,
 /*  1140 */   255,  257,  539,   37,  539,   53,  259,  513,  381,  455,
 /*  1150 */   539,   31,  539,   32,  484,  392,  548,  144,  539,   29,
 /*  1160 */   539,   48,  323,  573,  275,  554,  459,  451,  528,  243,
 /*  1170 */   555,  185,  135,  107,  285,   87,   58,  529,  335,  582,
 /*  1180 */   583,  330,  362,  180,  225,  398,  374,  223,  125,  492,
 /*  1190 */   432,  124,  122,  406,  393,   81,  507,  119,  340,  126,
 /*  1200 */   188,  134,  561,  445,  305,  226,  356,    7,  409,  249,
 /*  1210 */   553,  313,  568,  198,  352,  556,  399,  131,  199,  585,
 /*  1220 */   354,  283,  201,  286,  391,  389,  296,  140,  463,   91,
 /*  1230 */   415,  419,  481,  458,  202,  209,  194,  217,  373,  212,
 /*  1240 */   130,  566,   78,  227,  332,  541,  273,   56,  575,  545,
 /*  1250 */   278,  530,  104,   99,  274,   62,  412,   61,   17,  170,
 /*  1260 */   504,  576,  102,  420,  621,  214,  121,  622,  309,  171,
 /*  1270 */   503,  498,   76,  470,  489,  474,  141,  155,  183,    6,
 /*  1280 */   469,  467,   12,  462,  439,  136,   83,   14,  137,  407,
 /*  1290 */   405,  215,  157,   65,  344,  105,  349,  251,  109,  118,
 /*  1300 */    93,  106,  162,  260,  353,  143,  394,  138,  357,  193,
 /*  1310 */   192,  110,  288,  449,  272,  184,   94,   92,  139,   13,
 /*  1320 */   425,  179,  417,  178,  123,  177,  127,  493,  524,  128,
 /*  1330 */    15,  108,  182,  538,  262,  383,  387,  145,  448,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,   19,   20,  160,   22,   21,  155,   23,   69,   70,
 /*    10 */    71,   72,  169,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,  244,  245,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */   189,   59,   23,   58,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  147,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   167,  168,   88,   88,   19,   22,   19,   92,   23,  176,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  217,  218,  219,  220,   42,   43,   78,  188,   46,
 /*   100 */    78,   79,   80,   81,   82,   83,   84,   88,   89,  124,
 /*   110 */   125,  126,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,  147,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,  142,  143,   88,   89,   11,  110,  148,  169,  170,
 /*   150 */    18,  185,  186,   20,  155,   16,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  112,
 /*   170 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   42,   43,   49,  150,   23,  102,   55,  189,  158,
 /*   190 */   211,  147,  161,  162,  163,  216,  164,  165,  166,   60,
 /*   200 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   210 */    71,   72,  213,   74,   75,   76,   77,   78,   79,   80,
 /*   220 */    81,   82,   83,   84,    1,    2,   94,   16,  147,   22,
 /*   230 */    16,   20,   20,   99,  100,  101,  147,  156,  157,  106,
 /*   240 */   241,  108,  109,   19,  110,  156,  157,   23,  181,  147,
 /*   250 */    88,   89,   90,   42,   43,   93,   94,   95,  224,   23,
 /*   260 */   228,  180,  181,   84,  230,  133,  104,  165,  166,  225,
 /*   270 */   131,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   280 */    69,   70,   71,   72,   91,   74,   75,   76,   77,   78,
 /*   290 */    79,   80,   81,   82,   83,   84,   16,   90,   84,   16,
 /*   300 */    93,   94,   95,  110,   90,   91,   92,   93,   94,   95,
 /*   310 */    96,  104,   88,   89,   78,   79,  123,  103,  106,  155,
 /*   320 */   108,  109,   42,   43,   88,   89,   99,  100,  101,  227,
 /*   330 */   228,   99,  100,  101,   98,   80,   81,   82,   83,   84,
 /*   340 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   350 */    70,   71,   72,  189,   74,   75,   76,   77,   78,   79,
 /*   360 */    80,   81,   82,   83,   84,  201,  202,   84,   16,  110,
 /*   370 */   206,   12,  169,   21,   91,   92,   93,   94,   95,   96,
 /*   380 */    16,  147,  123,   24,  147,   23,  103,   90,   42,   43,
 /*   390 */    93,   94,   95,  147,   42,   43,   37,  168,   39,  141,
 /*   400 */   161,  104,  144,  169,  170,  176,   43,   43,   49,   63,
 /*   410 */    64,  131,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   420 */    68,   69,   70,   71,   72,  188,   74,   75,   76,   77,
 /*   430 */    78,   79,   80,   81,   82,   83,   84,   16,   92,  200,
 /*   440 */   161,   20,   80,  209,  210,   12,  147,   23,  176,  177,
 /*   450 */    88,   89,  147,    7,    8,  183,  217,   24,  219,  220,
 /*   460 */   155,   98,   98,   42,   43,   83,   84,  103,  169,  170,
 /*   470 */    37,   20,   39,   22,  169,  170,  239,   19,   20,  200,
 /*   480 */    22,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   490 */    69,   70,   71,   72,  189,   74,   75,   76,   77,   78,
 /*   500 */    79,   80,   81,   82,   83,   84,   16,  147,  147,  210,
 /*   510 */    20,   20,   88,   89,  147,  155,  211,   59,   23,  147,
 /*   520 */   153,  216,  147,  156,  157,  217,  165,  219,  220,  169,
 /*   530 */   170,   22,   42,   43,  139,  140,  141,  169,  114,  144,
 /*   540 */    14,  169,  170,   30,  169,  170,  238,   91,   92,  189,
 /*   550 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   560 */    70,   71,   72,   50,   74,   75,   76,   77,   78,   79,
 /*   570 */    80,   81,   82,   83,   84,   16,  124,  125,   52,   20,
 /*   580 */    54,   23,  147,   88,   89,  147,  211,   25,  227,  228,
 /*   590 */    22,   29,  181,  221,  164,  165,  166,  106,  155,  108,
 /*   600 */   109,   42,   43,   41,  169,  170,   97,  169,  170,  114,
 /*   610 */   217,   27,  219,  220,  106,  102,  108,  109,   34,   60,
 /*   620 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   630 */    71,   72,  189,   74,   75,   76,   77,   78,   79,   80,
 /*   640 */    81,   82,   83,   84,   16,  147,   88,   89,   19,   21,
 /*   650 */   215,  147,   23,  215,  147,  192,  213,   89,  228,  133,
 /*   660 */    23,  147,  199,  147,  161,  162,  163,  169,  170,  190,
 /*   670 */    42,   43,  147,  169,  170,  147,  169,  170,   14,  236,
 /*   680 */   147,  147,  114,  169,  170,  169,  170,   16,   60,   61,
 /*   690 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   700 */    72,  147,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   710 */    82,   83,   84,   42,   43,  182,   52,   88,   54,    0,
 /*   720 */     1,    2,  188,  169,  170,   88,  147,  147,  147,  147,
 /*   730 */    16,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   740 */    69,   70,   71,   72,  147,   74,   75,   76,   77,   78,
 /*   750 */    79,   80,   81,   82,   83,   84,   42,   43,  225,   78,
 /*   760 */    79,  182,  182,  182,  182,  147,  169,  170,  107,    7,
 /*   770 */     8,    9,  111,   16,   60,   61,   62,   63,   64,   65,
 /*   780 */    66,   67,   68,   69,   70,   71,   72,  147,   74,   75,
 /*   790 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   42,
 /*   800 */    43,   19,  242,  243,  225,  225,  225,  225,   22,  169,
 /*   810 */   170,   20,   20,   22,   22,   22,   16,   80,   61,   62,
 /*   820 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   830 */   147,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   840 */    83,   84,   42,   43,  107,   20,  186,   22,  111,   20,
 /*   850 */    68,   22,  169,  170,  147,   16,   21,   20,   23,   22,
 /*   860 */   155,  191,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   870 */    70,   71,   72,  147,   74,   75,   76,   77,   78,   79,
 /*   880 */    80,   81,   82,   83,   84,   16,   17,  147,   19,  147,
 /*   890 */   161,  147,   23,   20,  189,   22,  147,  130,  147,  132,
 /*   900 */    31,   16,   17,  147,   19,  147,  113,  121,   23,  169,
 /*   910 */   170,  169,  170,  169,  170,  147,   31,   48,  169,  170,
 /*   920 */   169,  170,  147,   88,  147,  169,  170,   58,  147,  200,
 /*   930 */   147,   92,  147,   48,   20,  147,   22,  169,  170,   20,
 /*   940 */    19,   22,   21,   58,  169,  170,  147,   78,   79,  147,
 /*   950 */   169,  170,  169,  170,  169,  170,   87,   88,   89,  145,
 /*   960 */   147,   92,  178,   78,   79,   80,  208,  155,  169,  170,
 /*   970 */   155,  147,   87,   88,   89,   16,   17,   92,   19,  110,
 /*   980 */   147,   20,   23,  147,   19,  208,  185,  186,   23,   92,
 /*   990 */    31,  201,  202,  124,  125,  126,  127,  128,  129,  178,
 /*  1000 */   103,  189,  169,  170,  189,  169,  170,   48,  178,  124,
 /*  1010 */   125,  126,  127,  128,  129,  147,   20,   58,   22,    5,
 /*  1020 */    59,  208,  161,   58,   10,   11,   12,   13,  147,  147,
 /*  1030 */   155,  147,  229,  147,  147,  147,  147,   78,   79,  147,
 /*  1040 */    26,  147,   28,   78,   79,  147,   87,   88,   89,   35,
 /*  1050 */   147,   92,  147,   88,  147,  169,  170,   92,  169,  170,
 /*  1060 */   147,   47,  147,   49,  189,  147,  203,   53,  173,  147,
 /*  1070 */    56,  147,  169,  170,  169,  170,  147,  147,  147,  147,
 /*  1080 */   147,  147,  188,  124,  125,  126,  127,  128,  129,  124,
 /*  1090 */   125,  126,  147,  212,  147,  188,  212,  147,  169,  170,
 /*  1100 */   169,  170,  169,  170,  147,  147,  188,  147,  232,  147,
 /*  1110 */   188,  147,  188,   99,  100,  101,  169,  170,  188,  105,
 /*  1120 */   147,  147,  147,  147,  110,  147,  169,  170,  147,  147,
 /*  1130 */   147,  169,  170,  169,  170,  147,  147,  233,  147,  147,
 /*  1140 */   147,  147,  169,  170,  169,  170,  147,  194,  134,  172,
 /*  1150 */   169,  170,  169,  170,  229,  149,  172,  191,  169,  170,
 /*  1160 */   169,  170,  223,  177,  193,   23,  194,  172,  160,  172,
 /*  1170 */   172,  112,  152,   19,  174,  120,   98,  198,  115,   97,
 /*  1180 */   173,  116,  152,    6,  204,  146,   15,  197,  187,  146,
 /*  1190 */   205,  187,  187,  152,  146,  121,  194,   60,   98,  184,
 /*  1200 */   184,   19,  171,  184,  152,  171,   38,   22,  152,   84,
 /*  1210 */   160,  154,   33,  152,   15,  171,  171,  214,  151,  179,
 /*  1220 */   152,  234,  151,  174,  152,  171,   40,  214,  137,  130,
 /*  1230 */   146,  152,  194,  152,  151,  226,  151,  226,  152,  222,
 /*  1240 */   187,  171,  119,  196,  118,  179,  195,  237,  171,  160,
 /*  1250 */   204,  189,  240,  159,  194,  237,  235,  130,  231,  112,
 /*  1260 */     1,   20,  175,  205,  112,  175,  243,  112,  246,  112,
 /*  1270 */    92,  107,   19,   11,   20,   20,   19,   19,   22,  117,
 /*  1280 */    20,   20,  117,   20,  114,   19,   22,   22,   20,   20,
 /*  1290 */    20,   44,  112,   19,   44,   19,   44,   20,   19,   32,
 /*  1300 */    19,   19,   96,  103,   16,   21,   17,   98,   36,   22,
 /*  1310 */    98,   19,    5,    1,  133,  122,   68,   68,   45,   19,
 /*  1320 */    45,  113,   51,   14,  113,  115,  102,   17,  123,  122,
 /*  1330 */    19,   14,  135,   20,  136,   57,    3,   19,    4,
};
#define YY_SHIFT_USE_DFLT (-62)
#define YY_SHIFT_MAX 387
static const short yy_shift_ofst[] = {
 /*     0 */   223,  869, 1014,  -16,  869,  959,  959,  162,  236,   36,
 /*    10 */    96,  959,  959,  959,  959,  959,  -45,  134,   19,  558,
 /*    20 */   681,  681,  637,   53,  139,  490,  421,  628,  352,  559,
 /*    30 */   211,  280,  671,  671,  671,  671,  671,  671,  671,  671,
 /*    40 */   671,  671,  671,  714,  671,  671,  671,  671,  671,  671,
 /*    50 */   671,  671,  757,  800,  800,  885,  959,  959,  959,  959,
 /*    60 */   959,  959,  959,  959,  959,  959,  959,  959,  959,  959,
 /*    70 */   959,  959,  959,  959,  959,  959,  959,  959,  959,  959,
 /*    80 */   959,  959,  959,  959,  959,  959,  959,  959,  959,  959,
 /*    90 */   959,  959,  959,  959,  959,  -61,  -61,    6,    6,  214,
 /*   100 */    22,  255,  364,  132,  558,  558,  558,  558,  558,  558,
 /*   110 */   558,  382,  637,  179,  -62,  -62,  965,  283,  359,  359,
 /*   120 */   -18,  458,  558,  558,  558,  558,  558,  558,  558,  558,
 /*   130 */   558,  193,  558,  719,  558,  835,  558,  835,  558,  558,
 /*   140 */   259,   36,   36,   36,  -62,  -62,  -62,  207,  -15,  -15,
 /*   150 */   297,  212,  424,  224,   55,  433,  133,  362,  495,  491,
 /*   160 */   558,  558,  558,  513,  513,  513,  558,  558,  737,  558,
 /*   170 */   558,  558,  558,  508,  508,  762,  629,  558,  558,  558,
 /*   180 */   558,  508,  558,  558,  558,  558,  558,  558,  558,  568,
 /*   190 */   508,  558,  558,  558,  558,  508,  568,  227,  562,  558,
 /*   200 */   508,  558,  558,  508,  558,  452,  509,  584,  786,  584,
 /*   210 */   452,  661,  767,  584,  363,  584,  921,  584,  793,  786,
 /*   220 */  1142, 1059, 1154, 1055, 1078, 1063, 1082, 1065, 1059, 1177,
 /*   230 */  1171, 1177, 1171, 1171, 1059, 1177, 1074, 1137, 1137, 1100,
 /*   240 */  1182, 1137, 1059, 1100, 1168, 1059, 1185, 1125, 1179, 1142,
 /*   250 */  1059, 1100, 1199, 1100, 1125, 1059, 1199, 1059, 1100, 1154,
 /*   260 */  1186, 1182, 1091, 1099, 1059, 1177, 1074, 1059, 1199, 1059,
 /*   270 */  1171, 1100, 1199, 1123, 1126, 1074, 1100, 1078, 1063,   36,
 /*   280 */  1179, 1186, 1142, 1127,  -62,  -62,  -62,  -62,  -62,  -62,
 /*   290 */   346,  526,  664,  232,  792,  791,  446,  825,  829,   57,
 /*   300 */   456,  839,  837,  873,  914,  782,  919,  996,  897,  961,
 /*   310 */   451, 1147, 1259, 1241, 1152, 1155, 1157, 1178, 1164, 1253,
 /*   320 */  1254, 1255, 1257, 1262, 1258, 1260, 1256, 1261, 1263, 1264,
 /*   330 */  1162, 1265, 1165, 1264, 1170, 1266, 1268, 1180, 1269, 1270,
 /*   340 */  1267, 1247, 1274, 1250, 1276, 1277, 1279, 1281, 1252, 1282,
 /*   350 */  1206, 1200, 1288, 1289, 1284, 1209, 1272, 1271, 1273, 1287,
 /*   360 */  1275, 1181, 1212, 1292, 1307, 1312,   84, 1248, 1249, 1193,
 /*   370 */  1300, 1208, 1309, 1210, 1310, 1211, 1224, 1207, 1311, 1205,
 /*   380 */  1313, 1317, 1278, 1197, 1198, 1318, 1333, 1334,
};
#define YY_REDUCE_USE_DFLT (-221)
#define YY_REDUCE_MAX 289
static const short yy_reduce_ofst[] = {
 /*     0 */   395,  305,   -1,  239,  360,  -21,  234,   81,  102,  164,
 /*    10 */   308,  372,  375,  438,  299,  435, -126,  443,  361,  367,
 /*    20 */    32,  430,   31,  393,  393,  393,  393,  393,  393,  393,
 /*    30 */   393,  393,  393,  393,  393,  393,  393,  393,  393,  393,
 /*    40 */   393,  393,  393,  393,  393,  393,  393,  393,  393,  393,
 /*    50 */   393,  393,  393,  393,  393,  498,  504,  507,  514,  516,
 /*    60 */   554,  597,  640,  683,  740,  742,  744,  749,  751,  756,
 /*    70 */   768,  775,  781,  783,  785,  799,  833,  836,  886,  889,
 /*    80 */   903,  905,  929,  931,  933,  947,  957,  962,  964,  973,
 /*    90 */   975,  981,  983,  989,  991,  393,  393,  393,  393,  -97,
 /*   100 */   393,  393,  272,   34,   89,  533,  579,  580,  237,  581,
 /*   110 */   582,  393,  503,  393,  393,  393, -157,  229,  -34,  801,
 /*   120 */  -220, -220,  930,  924,  922,  918,  907,  884,  894,  881,
 /*   130 */   534,  875,   44,  258,  813,  729,  777,  279,  -90,  758,
 /*   140 */  -149,  705,  812,  815,  463,  560,  790,   67,  203,  368,
 /*   150 */   411,  479,  246,  525,  528,  660,  479,  618,  707,  479,
 /*   160 */   726,  788,  802,  784,  821,  830,  824,  868,  670,  882,
 /*   170 */   618,  887,  888,  479,  479,  814,  861,  892,  898,  913,
 /*   180 */   915,  479,  932,  934,  945,  950,  958,  960,  974,  863,
 /*   190 */   479,  976,  978,  982,  988,  479,  863,  904,  876,  992,
 /*   200 */   479,  993,  994,  479,  999,  803,  895,  977,  953,  984,
 /*   210 */   925,  966,  939,  995,  986,  997, 1006,  998,  971,  972,
 /*   220 */  1008, 1020, 1000,  979,  980,  985, 1007,  990, 1030, 1039,
 /*   230 */  1001, 1043, 1004, 1005, 1041, 1048, 1002, 1015, 1016, 1031,
 /*   240 */  1003, 1019, 1052, 1034,  987, 1056, 1057, 1009, 1010, 1050,
 /*   250 */  1061, 1044, 1067, 1045, 1011, 1068, 1071, 1072, 1054, 1049,
 /*   260 */  1040, 1013, 1012, 1017, 1079, 1084, 1038, 1081, 1083, 1086,
 /*   270 */  1053, 1070, 1085, 1047, 1051, 1060, 1077, 1046, 1058, 1062,
 /*   280 */  1018, 1066, 1089, 1021, 1022, 1087, 1090, 1023, 1027, 1094,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   592,  816,  897,  707,  897,  816,  897,  897,  843,  711,
 /*    10 */   872,  814,  897,  897,  897,  897,  789,  897,  843,  897,
 /*    20 */   843,  843,  623,  740,  897,  897,  897,  897,  897,  897,
 /*    30 */   897,  897,  748,  813,  810,  809,  811,  873,  856,  871,
 /*    40 */   723,  741,  745,  897,  738,  818,  731,  742,  747,  817,
 /*    50 */   755,  754,  777,  776,  795,  897,  897,  897,  897,  897,
 /*    60 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    70 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    80 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    90 */   897,  897,  897,  897,  897,  800,  779,  778,  788,  616,
 /*   100 */   780,  781,  676,  611,  897,  897,  897,  897,  897,  897,
 /*   110 */   897,  782,  897,  783,  796,  797,  897,  897,  897,  897,
 /*   120 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   130 */   897,  897,  897,  592,  897,  707,  897,  707,  897,  897,
 /*   140 */   897,  897,  897,  897,  701,  890,  711,  667,  897,  897,
 /*   150 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   160 */   897,  897,  897,  897,  897,  897,  897,  897,  699,  897,
 /*   170 */   897,  897,  830,  750,  690,  599,  625,  897,  897,  897,
 /*   180 */   597,  861,  897,  897,  897,  897,  878,  897,  897,  709,
 /*   190 */   863,  876,  897,  897,  897,  714,  715,  897,  849,  897,
 /*   200 */   688,  897,  897,  613,  897,  897,  649,  734,  744,  734,
 /*   210 */   897,  699,  812,  734,  646,  734,  897,  734,  708,  744,
 /*   220 */   897,  716,  822,  739,  724,  726,  649,  727,  716,  596,
 /*   230 */   687,  596,  687,  687,  716,  596,  744,  680,  680,  678,
 /*   240 */   756,  680,  716,  678,  853,  716,  666,  827,  875,  897,
 /*   250 */   716,  678,  608,  678,  827,  716,  608,  716,  678,  822,
 /*   260 */   663,  756,  883,  897,  716,  596,  744,  716,  608,  716,
 /*   270 */   687,  678,  608,  737,  735,  744,  678,  724,  726,  897,
 /*   280 */   875,  663,  897,  855,  895,  651,  651,  890,  858,  633,
 /*   290 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  763,
 /*   300 */   897,  897,  897,  897,  897,  836,  897,  897,  897,  897,
 /*   310 */   897,  897,  897,  897,  768,  764,  765,  897,  693,  897,
 /*   320 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  815,
 /*   330 */   897,  728,  897,  736,  897,  897,  897,  897,  897,  897,
 /*   340 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   350 */   897,  897,  897,  897,  897,  897,  897,  897,  851,  852,
 /*   360 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   370 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*   380 */   897,  897,  882,  897,  897,  885,  593,  897,  664,  642,
 /*   390 */   684,  607,  606,  605,  609,  683,  682,  679,  604,  641,
 /*   400 */   640,  639,  768,  638,  637,  774,  877,  773,  761,  718,
 /*   410 */   804,  704,  845,  703,  702,  603,  602,  854,  850,  879,
 /*   420 */   713,  896,  846,  847,  601,  848,  610,  894,  759,  758,
 /*   430 */   725,  587,  712,  600,  706,  705,  819,  820,  880,  722,
 /*   440 */   721,  720,  719,  710,  681,  752,  753,  844,  594,  857,
 /*   450 */   700,  730,  622,  733,  732,  729,  621,  790,  806,  859,
 /*   460 */   881,  717,  803,  884,  868,  867,  866,  865,  757,  864,
 /*   470 */   808,  588,  807,  775,  772,  628,  860,  629,  620,  842,
 /*   480 */   840,  862,  598,  841,  839,  886,  631,  887,  630,  627,
 /*   490 */   626,  685,  595,  686,  619,  805,  689,  695,  694,  829,
 /*   500 */   801,  798,  869,  794,  591,  792,  791,  743,  786,  802,
 /*   510 */   891,  799,  793,  746,  892,  787,  785,  784,  770,  589,
 /*   520 */   769,  767,  749,  590,  751,  766,  831,  762,  771,  696,
 /*   530 */   692,  832,  833,  834,  837,  838,  691,  893,  835,  760,
 /*   540 */   698,  662,  635,  624,  617,  648,  647,  668,  825,  671,
 /*   550 */   697,  636,  826,  828,  618,  824,  672,  870,  823,  656,
 /*   560 */   655,  673,  634,  660,  659,  658,  674,  632,  874,  657,
 /*   570 */   654,  614,  653,  652,  645,  644,  612,  675,  677,  669,
 /*   580 */   670,  615,  650,  643,  665,  661,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ALTER",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "idxitem",       "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE id",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT|BITNOT expr",
 /* 210 */ "expr ::= MINUS expr",
 /* 211 */ "expr ::= PLUS expr",
 /* 212 */ "between_op ::= BETWEEN",
 /* 213 */ "between_op ::= NOT BETWEEN",
 /* 214 */ "expr ::= expr between_op expr AND expr",
 /* 215 */ "in_op ::= IN",
 /* 216 */ "in_op ::= NOT IN",
 /* 217 */ "expr ::= expr in_op LP exprlist RP",
 /* 218 */ "expr ::= LP select RP",
 /* 219 */ "expr ::= expr in_op LP select RP",
 /* 220 */ "expr ::= expr in_op nm dbnm",
 /* 221 */ "expr ::= EXISTS LP select RP",
 /* 222 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 223 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 224 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 225 */ "case_else ::= ELSE expr",
 /* 226 */ "case_else ::=",
 /* 227 */ "case_operand ::= expr",
 /* 228 */ "case_operand ::=",
 /* 229 */ "exprlist ::= nexprlist",
 /* 230 */ "exprlist ::=",
 /* 231 */ "nexprlist ::= nexprlist COMMA expr",
 /* 232 */ "nexprlist ::= expr",
 /* 233 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 234 */ "uniqueflag ::= UNIQUE",
 /* 235 */ "uniqueflag ::=",
 /* 236 */ "idxlist_opt ::=",
 /* 237 */ "idxlist_opt ::= LP idxlist RP",
 /* 238 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 239 */ "idxlist ::= idxitem collate sortorder",
 /* 240 */ "idxitem ::= nm",
 /* 241 */ "collate ::=",
 /* 242 */ "collate ::= COLLATE id",
 /* 243 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 244 */ "cmd ::= VACUUM",
 /* 245 */ "cmd ::= VACUUM nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 249 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 250 */ "cmd ::= PRAGMA nm dbnm",
 /* 251 */ "nmnum ::= plus_num",
 /* 252 */ "nmnum ::= nm",
 /* 253 */ "plus_num ::= plus_opt number",
 /* 254 */ "minus_num ::= MINUS number",
 /* 255 */ "number ::= INTEGER|FLOAT",
 /* 256 */ "plus_opt ::= PLUS",
 /* 257 */ "plus_opt ::=",
 /* 258 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 259 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 260 */ "trigger_time ::= BEFORE",
 /* 261 */ "trigger_time ::= AFTER",
 /* 262 */ "trigger_time ::= INSTEAD OF",
 /* 263 */ "trigger_time ::=",
 /* 264 */ "trigger_event ::= DELETE|INSERT",
 /* 265 */ "trigger_event ::= UPDATE",
 /* 266 */ "trigger_event ::= UPDATE OF inscollist",
 /* 267 */ "foreach_clause ::=",
 /* 268 */ "foreach_clause ::= FOR EACH ROW",
 /* 269 */ "when_clause ::=",
 /* 270 */ "when_clause ::= WHEN expr",
 /* 271 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 272 */ "trigger_cmd_list ::=",
 /* 273 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 274 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 276 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 277 */ "trigger_cmd ::= select",
 /* 278 */ "expr ::= RAISE LP IGNORE RP",
 /* 279 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 280 */ "raisetype ::= ROLLBACK",
 /* 281 */ "raisetype ::= ABORT",
 /* 282 */ "raisetype ::= FAIL",
 /* 283 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 284 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 285 */ "cmd ::= DETACH database_kw_opt expr",
 /* 286 */ "key_opt ::=",
 /* 287 */ "key_opt ::= KEY expr",
 /* 288 */ "database_kw_opt ::= DATABASE",
 /* 289 */ "database_kw_opt ::=",
 /* 290 */ "cmd ::= REINDEX",
 /* 291 */ "cmd ::= REINDEX nm dbnm",
 /* 292 */ "cmd ::= ANALYZE",
 /* 293 */ "cmd ::= ANALYZE nm dbnm",
 /* 294 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 295 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 296 */ "add_column_fullname ::= fullname",
 /* 297 */ "kwcolumn_opt ::=",
 /* 298 */ "kwcolumn_opt ::= COLUMNKW",
 /* 299 */ "cmd ::= create_vtab",
 /* 300 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 301 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 302 */ "vtabarglist ::= vtabarg",
 /* 303 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 304 */ "vtabarg ::=",
 /* 305 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 306 */ "vtabargtoken ::= ANY",
 /* 307 */ "vtabargtoken ::= lp anylist RP",
 /* 308 */ "lp ::= LP",
 /* 309 */ "anylist ::=",
 /* 310 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 155:
    case 189:
    case 206:
#line 374 "parse.y"
{sqlite3SelectDelete((yypminor->yy219));}
#line 1272 "parse.c"
      break;
    case 169:
    case 170:
    case 194:
    case 196:
    case 204:
    case 210:
    case 218:
    case 221:
    case 223:
    case 235:
#line 627 "parse.y"
{sqlite3ExprDelete((yypminor->yy172));}
#line 1286 "parse.c"
      break;
    case 174:
    case 182:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 211:
    case 212:
    case 215:
    case 216:
    case 222:
#line 876 "parse.y"
{sqlite3ExprListDelete((yypminor->yy174));}
#line 1302 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 489 "parse.y"
{sqlite3SrcListDelete((yypminor->yy373));}
#line 1310 "parse.c"
      break;
    case 205:
    case 208:
    case 214:
#line 506 "parse.y"
{sqlite3IdListDelete((yypminor->yy432));}
#line 1317 "parse.c"
      break;
    case 231:
    case 236:
#line 979 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy243));}
#line 1323 "parse.c"
      break;
    case 233:
#line 965 "parse.y"
{sqlite3IdListDelete((yypminor->yy370).b);}
#line 1328 "parse.c"
      break;
    case 238:
#line 1052 "parse.y"
{sqlite3ExprDelete((yypminor->yy386));}
#line 1333 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1497 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 139, 1 },
  { 140, 2 },
  { 140, 1 },
  { 142, 1 },
  { 141, 1 },
  { 141, 3 },
  { 144, 0 },
  { 144, 1 },
  { 144, 3 },
  { 143, 3 },
  { 146, 0 },
  { 146, 1 },
  { 146, 2 },
  { 145, 0 },
  { 145, 1 },
  { 145, 1 },
  { 145, 1 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 148, 6 },
  { 151, 0 },
  { 151, 3 },
  { 150, 1 },
  { 150, 0 },
  { 149, 4 },
  { 149, 2 },
  { 153, 3 },
  { 153, 1 },
  { 156, 3 },
  { 157, 1 },
  { 160, 1 },
  { 161, 1 },
  { 147, 1 },
  { 147, 1 },
  { 147, 1 },
  { 158, 0 },
  { 158, 1 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 163, 1 },
  { 163, 2 },
  { 164, 1 },
  { 164, 1 },
  { 159, 2 },
  { 159, 0 },
  { 167, 3 },
  { 167, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 5 },
  { 168, 2 },
  { 168, 4 },
  { 168, 4 },
  { 168, 1 },
  { 168, 2 },
  { 173, 0 },
  { 173, 1 },
  { 175, 0 },
  { 175, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 1 },
  { 178, 1 },
  { 176, 3 },
  { 176, 2 },
  { 179, 0 },
  { 179, 2 },
  { 179, 2 },
  { 154, 0 },
  { 154, 2 },
  { 180, 3 },
  { 180, 2 },
  { 180, 1 },
  { 181, 2 },
  { 181, 7 },
  { 181, 5 },
  { 181, 5 },
  { 181, 10 },
  { 183, 0 },
  { 183, 1 },
  { 171, 0 },
  { 171, 3 },
  { 184, 0 },
  { 184, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 143, 4 },
  { 187, 2 },
  { 187, 0 },
  { 143, 8 },
  { 143, 4 },
  { 143, 1 },
  { 155, 1 },
  { 155, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 152, 0 },
  { 152, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 4 },
  { 209, 2 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 143, 4 },
  { 194, 0 },
  { 194, 2 },
  { 143, 6 },
  { 212, 5 },
  { 212, 3 },
  { 143, 8 },
  { 143, 5 },
  { 143, 6 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 208, 3 },
  { 208, 1 },
  { 170, 1 },
  { 170, 3 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 5 },
  { 169, 1 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 6 },
  { 170, 5 },
  { 170, 4 },
  { 169, 1 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 170, 4 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 4 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 219, 1 },
  { 219, 2 },
  { 170, 5 },
  { 220, 1 },
  { 220, 2 },
  { 170, 5 },
  { 170, 3 },
  { 170, 5 },
  { 170, 4 },
  { 170, 4 },
  { 170, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 1 },
  { 216, 0 },
  { 211, 3 },
  { 211, 1 },
  { 143, 11 },
  { 224, 1 },
  { 224, 0 },
  { 174, 0 },
  { 174, 3 },
  { 182, 5 },
  { 182, 3 },
  { 225, 1 },
  { 226, 0 },
  { 226, 2 },
  { 143, 4 },
  { 143, 1 },
  { 143, 2 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 6 },
  { 143, 3 },
  { 227, 1 },
  { 227, 1 },
  { 165, 2 },
  { 166, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 143, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 170, 4 },
  { 170, 6 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 143, 4 },
  { 143, 6 },
  { 143, 3 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 143, 1 },
  { 143, 3 },
  { 143, 1 },
  { 143, 3 },
  { 143, 6 },
  { 143, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 143, 1 },
  { 143, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
      case 1:
      case 2:
      case 4:
      case 5:
      case 10:
      case 11:
      case 12:
      case 20:
      case 28:
      case 29:
      case 37:
      case 44:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      case 55:
      case 82:
      case 83:
      case 84:
      case 85:
      case 256:
      case 257:
      case 267:
      case 268:
      case 288:
      case 289:
      case 297:
      case 298:
      case 302:
      case 303:
      case 305:
      case 309:
#line 97 "parse.y"
{
}
#line 1951 "parse.c"
        break;
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1956 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1961 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1966 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1971 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 1976 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy46 = TK_DEFERRED;}
#line 1981 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 1990 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1996 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2001 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 2008 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 212:
      case 215:
#line 132 "parse.y"
{yygotominor.yy46 = 0;}
#line 2023 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 213:
      case 216:
#line 133 "parse.y"
{yygotominor.yy46 = 1;}
#line 2035 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy0,0);
}
#line 2042 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2050 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy410.z = yymsp[-2].minor.yy410.z;
  yygotominor.yy410.n = (pParse->sLastToken.z-yymsp[-2].minor.yy410.z) + pParse->sLastToken.n;
}
#line 2058 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy410);
  yygotominor.yy410 = yymsp[0].minor.yy410;
}
#line 2066 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 255:
#line 168 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy0;}
#line 2076 "parse.c"
        break;
      case 38:
#line 229 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy410);}
#line 2081 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 240:
      case 242:
      case 251:
      case 252:
      case 253:
      case 254:
#line 230 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy410;}
#line 2096 "parse.c"
        break;
      case 40:
#line 231 "parse.y"
{
  yygotominor.yy410.z = yymsp[-3].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy410.z;
}
#line 2104 "parse.c"
        break;
      case 41:
#line 235 "parse.y"
{
  yygotominor.yy410.z = yymsp[-5].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy410.z;
}
#line 2112 "parse.c"
        break;
      case 43:
#line 241 "parse.y"
{yygotominor.yy410.z=yymsp[-1].minor.yy410.z; yygotominor.yy410.n=yymsp[0].minor.yy410.n+(yymsp[0].minor.yy410.z-yymsp[-1].minor.yy410.z);}
#line 2117 "parse.c"
        break;
      case 50:
      case 52:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2123 "parse.c"
        break;
      case 51:
#line 253 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2128 "parse.c"
        break;
      case 53:
#line 255 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2136 "parse.c"
        break;
      case 54:
#line 259 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy410);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2144 "parse.c"
        break;
      case 56:
#line 268 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2149 "parse.c"
        break;
      case 57:
#line 270 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2154 "parse.c"
        break;
      case 58:
#line 271 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2159 "parse.c"
        break;
      case 59:
#line 272 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2164 "parse.c"
        break;
      case 60:
#line 274 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy410,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2169 "parse.c"
        break;
      case 61:
#line 275 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2174 "parse.c"
        break;
      case 62:
#line 276 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy410.z, yymsp[0].minor.yy410.n);}
#line 2179 "parse.c"
        break;
      case 65:
#line 289 "parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2184 "parse.c"
        break;
      case 66:
#line 290 "parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2189 "parse.c"
        break;
      case 67:
#line 292 "parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2194 "parse.c"
        break;
      case 68:
#line 293 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2199 "parse.c"
        break;
      case 69:
#line 294 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2204 "parse.c"
        break;
      case 70:
#line 295 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2209 "parse.c"
        break;
      case 71:
#line 297 "parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2214 "parse.c"
        break;
      case 72:
#line 298 "parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2219 "parse.c"
        break;
      case 73:
#line 299 "parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2224 "parse.c"
        break;
      case 74:
#line 300 "parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2229 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 166:
#line 302 "parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2240 "parse.c"
        break;
      case 80:
#line 312 "parse.y"
{yygotominor.yy410.n = 0; yygotominor.yy410.z = 0;}
#line 2245 "parse.c"
        break;
      case 81:
#line 313 "parse.y"
{yygotominor.yy410 = yymsp[-1].minor.yy0;}
#line 2250 "parse.c"
        break;
      case 86:
#line 319 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2255 "parse.c"
        break;
      case 87:
#line 321 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2260 "parse.c"
        break;
      case 88:
#line 322 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2265 "parse.c"
        break;
      case 89:
#line 324 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy410, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2273 "parse.c"
        break;
      case 92:
      case 94:
#line 338 "parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2279 "parse.c"
        break;
      case 97:
#line 343 "parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2284 "parse.c"
        break;
      case 98:
      case 167:
#line 344 "parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2290 "parse.c"
        break;
      case 99:
#line 348 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2297 "parse.c"
        break;
      case 102:
#line 358 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, yymsp[0].minor.yy219, yymsp[-6].minor.yy46, yymsp[-4].minor.yy46);
}
#line 2304 "parse.c"
        break;
      case 103:
#line 361 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2311 "parse.c"
        break;
      case 104:
#line 368 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy219, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2319 "parse.c"
        break;
      case 105:
      case 128:
#line 378 "parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2325 "parse.c"
        break;
      case 106:
#line 380 "parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }else{
    sqlite3SelectDelete(yymsp[-2].minor.yy219);
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2338 "parse.c"
        break;
      case 108:
#line 391 "parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2343 "parse.c"
        break;
      case 110:
#line 395 "parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2350 "parse.c"
        break;
      case 114:
      case 237:
#line 416 "parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2356 "parse.c"
        break;
      case 115:
      case 141:
      case 149:
      case 230:
      case 236:
#line 417 "parse.y"
{yygotominor.yy174 = 0;}
#line 2365 "parse.c"
        break;
      case 116:
#line 418 "parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy410.n?&yymsp[0].minor.yy410:0);
}
#line 2372 "parse.c"
        break;
      case 117:
#line 421 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-1].minor.yy174, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2379 "parse.c"
        break;
      case 118:
#line 424 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-3].minor.yy174, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2388 "parse.c"
        break;
      case 121:
#line 436 "parse.y"
{yygotominor.yy410.n = 0;}
#line 2393 "parse.c"
        break;
      case 122:
#line 448 "parse.y"
{yygotominor.yy373 = sqliteMalloc(sizeof(*yygotominor.yy373));}
#line 2398 "parse.c"
        break;
      case 123:
#line 449 "parse.y"
{
  yygotominor.yy373 = yymsp[0].minor.yy373;
  sqlite3SrcListShiftJoinType(yygotominor.yy373);
}
#line 2406 "parse.c"
        break;
      case 124:
#line 457 "parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2414 "parse.c"
        break;
      case 125:
#line 461 "parse.y"
{yygotominor.yy373 = 0;}
#line 2419 "parse.c"
        break;
      case 126:
#line 462 "parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppendFromTerm(yymsp[-5].minor.yy373,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,0,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
}
#line 2426 "parse.c"
        break;
      case 127:
#line 467 "parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppendFromTerm(yymsp[-6].minor.yy373,0,0,&yymsp[-2].minor.yy410,yymsp[-4].minor.yy219,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
  }
#line 2433 "parse.c"
        break;
      case 129:
#line 478 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy373);
     yygotominor.yy219 = sqlite3SelectNew(0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2441 "parse.c"
        break;
      case 130:
#line 485 "parse.y"
{yygotominor.yy410.z=0; yygotominor.yy410.n=0;}
#line 2446 "parse.c"
        break;
      case 132:
#line 490 "parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);}
#line 2451 "parse.c"
        break;
      case 133:
#line 494 "parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2456 "parse.c"
        break;
      case 134:
#line 495 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2461 "parse.c"
        break;
      case 135:
#line 496 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy410,0); }
#line 2466 "parse.c"
        break;
      case 136:
#line 498 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy410,&yymsp[-1].minor.yy410); }
#line 2471 "parse.c"
        break;
      case 137:
      case 145:
      case 152:
      case 159:
      case 174:
      case 202:
      case 225:
      case 227:
#line 502 "parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2483 "parse.c"
        break;
      case 138:
      case 151:
      case 158:
      case 203:
      case 226:
      case 228:
#line 503 "parse.y"
{yygotominor.yy172 = 0;}
#line 2493 "parse.c"
        break;
      case 139:
      case 171:
#line 507 "parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2499 "parse.c"
        break;
      case 140:
      case 170:
#line 508 "parse.y"
{yygotominor.yy432 = 0;}
#line 2505 "parse.c"
        break;
      case 142:
      case 150:
      case 229:
#line 519 "parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2512 "parse.c"
        break;
      case 143:
#line 520 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-3].minor.yy174,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2520 "parse.c"
        break;
      case 144:
#line 524 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2528 "parse.c"
        break;
      case 146:
      case 148:
#line 532 "parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2534 "parse.c"
        break;
      case 147:
#line 533 "parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2539 "parse.c"
        break;
      case 153:
#line 559 "parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2544 "parse.c"
        break;
      case 154:
#line 560 "parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2549 "parse.c"
        break;
      case 155:
#line 562 "parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2554 "parse.c"
        break;
      case 156:
#line 564 "parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2559 "parse.c"
        break;
      case 157:
#line 568 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2564 "parse.c"
        break;
      case 160:
#line 578 "parse.y"
{
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy174,SQLITE_MAX_COLUMN,"set list"); 
  sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);
}
#line 2572 "parse.c"
        break;
      case 161:
#line 587 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2577 "parse.c"
        break;
      case 162:
#line 588 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2582 "parse.c"
        break;
      case 163:
#line 594 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2587 "parse.c"
        break;
      case 164:
#line 596 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2592 "parse.c"
        break;
      case 165:
#line 598 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy373, 0, 0, yymsp[-2].minor.yy432, yymsp[-5].minor.yy46);}
#line 2597 "parse.c"
        break;
      case 168:
      case 231:
#line 608 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2603 "parse.c"
        break;
      case 169:
      case 232:
#line 609 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,0);}
#line 2609 "parse.c"
        break;
      case 172:
#line 618 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(yymsp[-2].minor.yy432,&yymsp[0].minor.yy410);}
#line 2614 "parse.c"
        break;
      case 173:
#line 619 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(0,&yymsp[0].minor.yy410);}
#line 2619 "parse.c"
        break;
      case 175:
#line 630 "parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2624 "parse.c"
        break;
      case 176:
      case 181:
      case 182:
#line 631 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2631 "parse.c"
        break;
      case 177:
      case 178:
#line 632 "parse.y"
{yygotominor.yy172 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2637 "parse.c"
        break;
      case 179:
#line 634 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2646 "parse.c"
        break;
      case 180:
#line 639 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2657 "parse.c"
        break;
      case 183:
#line 648 "parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2662 "parse.c"
        break;
      case 184:
#line 649 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2671 "parse.c"
        break;
      case 185:
#line 654 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy172, &yymsp[0].minor.yy410);
}
#line 2678 "parse.c"
        break;
      case 186:
#line 658 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy410);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2686 "parse.c"
        break;
      case 187:
#line 663 "parse.y"
{
  if( yymsp[-1].minor.yy174 && yymsp[-1].minor.yy174->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2700 "parse.c"
        break;
      case 188:
#line 673 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2708 "parse.c"
        break;
      case 189:
#line 677 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->op = TK_CONST_FUNC;  
    yygotominor.yy172->span = yymsp[0].minor.yy0;
  }
}
#line 2721 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 686 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy172, yymsp[0].minor.yy172, 0);}
#line 2733 "parse.c"
        break;
      case 198:
      case 200:
#line 696 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 0;}
#line 2739 "parse.c"
        break;
      case 199:
      case 201:
#line 697 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 1;}
#line 2745 "parse.c"
        break;
      case 204:
#line 704 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.not ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2761 "parse.c"
        break;
      case 205:
#line 717 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2769 "parse.c"
        break;
      case 206:
#line 721 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2777 "parse.c"
        break;
      case 207:
#line 725 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2785 "parse.c"
        break;
      case 208:
#line 729 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2793 "parse.c"
        break;
      case 209:
#line 733 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2801 "parse.c"
        break;
      case 210:
#line 737 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2809 "parse.c"
        break;
      case 211:
#line 741 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2817 "parse.c"
        break;
      case 214:
#line 748 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 2833 "parse.c"
        break;
      case 217:
#line 764 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2848 "parse.c"
        break;
      case 218:
#line 775 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2862 "parse.c"
        break;
      case 219:
#line 785 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2877 "parse.c"
        break;
      case 220:
#line 796 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy410.z?&yymsp[0].minor.yy410:&yymsp[-1].minor.yy410);
  }
#line 2893 "parse.c"
        break;
      case 221:
#line 808 "parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
  }
#line 2907 "parse.c"
        break;
      case 222:
#line 821 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
    sqlite3ExprSetHeight(yygotominor.yy172);
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2921 "parse.c"
        break;
      case 223:
#line 833 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2929 "parse.c"
        break;
      case 224:
#line 837 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2937 "parse.c"
        break;
      case 233:
#line 864 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy410, &yymsp[-5].minor.yy410, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy410,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 2945 "parse.c"
        break;
      case 234:
      case 281:
#line 870 "parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 2951 "parse.c"
        break;
      case 235:
#line 871 "parse.y"
{yygotominor.yy46 = OE_None;}
#line 2956 "parse.c"
        break;
      case 238:
#line 881 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, SQLITE_MAX_COLUMN, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2970 "parse.c"
        break;
      case 239:
#line 891 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, SQLITE_MAX_COLUMN, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2984 "parse.c"
        break;
      case 241:
#line 904 "parse.y"
{yygotominor.yy410.z = 0; yygotominor.yy410.n = 0;}
#line 2989 "parse.c"
        break;
      case 243:
#line 910 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 2994 "parse.c"
        break;
      case 244:
      case 245:
#line 916 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3000 "parse.c"
        break;
      case 246:
#line 924 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,0);}
#line 3005 "parse.c"
        break;
      case 247:
#line 925 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy0,0);}
#line 3010 "parse.c"
        break;
      case 248:
#line 926 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,1);
}
#line 3017 "parse.c"
        break;
      case 249:
#line 929 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-1].minor.yy410,0);}
#line 3022 "parse.c"
        break;
      case 250:
#line 930 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,0,0);}
#line 3027 "parse.c"
        break;
      case 258:
#line 944 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy410.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy410.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 3037 "parse.c"
        break;
      case 259:
#line 953 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy410, &yymsp[-6].minor.yy410, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[0].minor.yy172, yymsp[-10].minor.yy46, yymsp[-8].minor.yy46);
  yygotominor.yy410 = (yymsp[-6].minor.yy410.n==0?yymsp[-7].minor.yy410:yymsp[-6].minor.yy410);
}
#line 3045 "parse.c"
        break;
      case 260:
      case 263:
#line 959 "parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 3051 "parse.c"
        break;
      case 261:
#line 960 "parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 3056 "parse.c"
        break;
      case 262:
#line 961 "parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 3061 "parse.c"
        break;
      case 264:
      case 265:
#line 966 "parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 3067 "parse.c"
        break;
      case 266:
#line 968 "parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 3072 "parse.c"
        break;
      case 269:
#line 975 "parse.y"
{ yygotominor.yy172 = 0; }
#line 3077 "parse.c"
        break;
      case 270:
#line 976 "parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 3082 "parse.c"
        break;
      case 271:
#line 980 "parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3095 "parse.c"
        break;
      case 272:
#line 989 "parse.y"
{ yygotominor.yy243 = 0; }
#line 3100 "parse.c"
        break;
      case 273:
#line 995 "parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy410, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3105 "parse.c"
        break;
      case 274:
#line 1000 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy410, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3110 "parse.c"
        break;
      case 275:
#line 1003 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy410, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3115 "parse.c"
        break;
      case 276:
#line 1007 "parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy410, yymsp[0].minor.yy172);}
#line 3120 "parse.c"
        break;
      case 277:
#line 1010 "parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(yymsp[0].minor.yy219); }
#line 3125 "parse.c"
        break;
      case 278:
#line 1013 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3136 "parse.c"
        break;
      case 279:
#line 1020 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy410); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3147 "parse.c"
        break;
      case 280:
#line 1030 "parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3152 "parse.c"
        break;
      case 282:
#line 1032 "parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3157 "parse.c"
        break;
      case 283:
#line 1037 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373,yymsp[-1].minor.yy46);
}
#line 3164 "parse.c"
        break;
      case 284:
#line 1044 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy386);
}
#line 3171 "parse.c"
        break;
      case 285:
#line 1047 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3178 "parse.c"
        break;
      case 286:
#line 1053 "parse.y"
{ yygotominor.yy386 = 0; }
#line 3183 "parse.c"
        break;
      case 287:
#line 1054 "parse.y"
{ yygotominor.yy386 = yymsp[0].minor.yy172; }
#line 3188 "parse.c"
        break;
      case 290:
#line 1062 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3193 "parse.c"
        break;
      case 291:
#line 1063 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3198 "parse.c"
        break;
      case 292:
#line 1068 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3203 "parse.c"
        break;
      case 293:
#line 1069 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3208 "parse.c"
        break;
      case 294:
#line 1074 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy410);
}
#line 3215 "parse.c"
        break;
      case 295:
#line 1077 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy410);
}
#line 3222 "parse.c"
        break;
      case 296:
#line 1080 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3229 "parse.c"
        break;
      case 299:
#line 1089 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3234 "parse.c"
        break;
      case 300:
#line 1090 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3239 "parse.c"
        break;
      case 301:
#line 1091 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, &yymsp[0].minor.yy410);
}
#line 3246 "parse.c"
        break;
      case 304:
#line 1096 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3251 "parse.c"
        break;
      case 306:
      case 307:
      case 308:
      case 310:
#line 1098 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3259 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3327 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
